class ChangesetsController < ApplicationController

  TIMELINE_LIMIT = 15
  CHANGESET_CHANGES_LIMIT = 3

  before_filter :repository_detected?, :except => :index
  before_filter :welcome_screen,       :only => :index
  before_filter :setup_page,           :only => [:index, :repository]

  caches_action :message, :differences

  helper_method :current_branch
  helper_method :repository_scope?
  helper_method :changesets_changes_limit
  helper_method :diff_taking_too_much_time_msg

  def repository
    unless current_repository.import_in_progress?
      return render(:template => "changesets/import_in_progress")
    end
    @changesets         = find_changesets_for_current_scope
    @grouped_changesets = group_by_days(@changesets)
    @total_count = current_repository.revision_caches.count(find_options.only(:conditions))
  end

end
