import roseau.load_flow as rlf
import roseau.load_flow_single as rlfs


def test_import():
    # Ensure that RLF and RLFS have nearly the same interface
    rlf_dir = set(dir(rlf))
    rlfs_dir = set(dir(rlfs)) - {"_constants"}

    assert rlf_dir - rlfs_dir == {
        # Multi-phase elements
        "Ground",
        "PotentialRef",
        # Sequences
        "NegativeSequence",
        "PositiveSequence",
        "ZeroSequence",
        "ALPHA",
        "ALPHA2",
        "converters",
        # Plotting
        "plotting",
        # Underscore things
        "__getattr__",
        "_compat",
        "_solvers",
        "_wrapper",
        # Typing used for a deprecation
        "Any",
    }
    # conftest is not included in wheels
    assert rlfs_dir - rlf_dir == {"conftest"}
