# Summary

- [MiniOB 简介](./miniob-introduction.md)
- [如何编译](./how_to_build.md)
- [如何运行](./how_to_run.md)
- [开发环境搭建](./dev-env/introduction.md)
  - [使用 GitPod 开发 MiniOB](./dev-env/dev_by_gitpod.md)
  - [开发环境搭建(本地调试, 适用 Linux 和 Mac)](./dev-env/how_to_dev_miniob_by_vscode.md)
  - [开发环境搭建(远程调试, 适用于 Window, Linux 和 Mac)](./dev-env/how_to_dev_in_docker_container_by_vscode.md)
  - [Windows 使用Docker开发MiniOB](./dev-env/how_to_dev_miniob_by_docker_on_windows.md)
  - [使用Docker开发MiniOB](./dev-env/how-to-dev-using-docker.md)
  - [MiniOB 调试](./dev-env/miniob-how-to-debug.md)

- [功能模块设计说明文档](./design/introduction.md)
  - [存储实现](./design/miniob-buffer-pool.md)
  - [事务](./design/miniob-transaction.md)
  - [CLog](./design/miniob-clog.md)
  - [SQL Parser](./design/miniob-sql-parser.md)
  - [如何新增支持一种新类型SQL](./design/miniob-how-to-add-new-sql.md)
  - [表达式解析](./design/miniob-sql-expression.md)
  - [B+树实现](./design/miniob-bplus-tree.md)
  - [并发B+树实现](./design/miniob-bplus-tree-concurrency.md)
  - [Doxy代码文档](./design/doxy/html/index.html)

- [OceanBase 数据库大赛](./game/introduction.md)
  - [提交测试需要满足的输出要求](./game/miniob-output-convention.md)
  - [自助输出调试信息](./game/debug-output.md)
  - [2021届大赛题目介绍](./game/miniob_topics.md)
  - [使用GitHub参加训练营](./game/github-introduction.md)
  - [使用Gitee参加训练营](./game/gitee-instructions.md)
  - [date 测试说明](./game/miniob-test-comment-date.md)
  - [date 实现解析](./game/miniob-date-implementation.md)
  - [drop table 实现解析](./game/miniob-drop-table-implementation.md)

- [数据库基础理论课程](./lectures/index.md)
  - [版权声明](./lectures/copyright.md)
  - [第1章 数据库管理系统概述](./lectures/lecture-1.md)
  - [第2章 数据库的存储结构](./lectures/lecture-2.md)
  - [第3章 索引结构](./lectures/lecture-3.md)
  - [第4章 查询处理](./lectures/lecture-4.md)
  - [第5章 查询优化](./lectures/lecture-5.md)
  - [第6章 事务处理](./lectures/lecture-6.md)
  - [参考资料](./lectures/references.md)

- [Blog](./blog/introduction.md)
  - [High-Performance Concurrency Control Mechanisms for Main-Memory Databases](./blog/1.md)