#ifndef STAT_H
#define STAT_H

#include <sys/types.h>

#if 0
struct stat
{
	dev_t     st_dev;
	ino_t     st_ino;
	mode_t    st_mode;
	nlink_t   st_nlink;
	uid_t     st_uid;
	gid_t     st_gid;
	dev_t     st_rdev;
	off_t     st_size;
	blksize_t st_blksize;
	blkcnt_t  st_blocks;
	time_t    st_atime;
	time_t    st_mtime;
	time_t    st_ctime;
};
#endif

struct stat
{
	/* I don't know why these need to be shorts, bash needs it to function 
	   (actually newlib _isatty needs it) */
	short     st_dev;
	short     st_ino;
	int    st_mode;
	int   st_nlink;
	int     st_uid;
	int     st_gid;
	int     st_rdev;
	int     st_size;
	int st_blksize;
	int  st_blocks;
	int    st_atime;
	int    st_mtime;
	int    st_ctime;
};


#define S_IFMT   0170000 /* type of file */
#define S_IFIFO  0010000 /* named pipe (fifo) */
#define S_IFCHR  0020000 /* character special */
#define S_IFDIR  0040000 /* directory */
#define S_IFBLK  0060000 /* block special */
#define S_IFREG  0100000 /* regular */
#define S_IFLNK  0120000 /* symbolic link */
#define S_IFSOCK 0140000 /* socket */

#define S_ISUID 0004000
#define S_ISGID 0002000
#define S_ISVTX 0001000

#define S_ISREG(m)  (((m) &S_IFMT) == S_IFREG)
#define S_ISDIR(m)  (((m) &S_IFMT) == S_IFDIR)
#define S_ISCHR(m)  (((m) &S_IFMT) == S_IFCHR)
#define S_ISBLK(m)  (((m) &S_IFMT) == S_IFBLK)
#define S_ISFIFO(m) (((m) &S_IFMT) == S_IFIFO)
#define S_ISLNK(m)  (((m) &S_IFMT) == S_IFLNK) /* symbolic link */
#define S_ISSOCK(m) (((m) &S_IFMT) == S_IFSOCK) /* socket */

#define S_IRWXU 00700
#define S_IRUSR 00400
#define S_IWUSR 00200
#define S_IXUSR 00100

#define S_IRWXG 00070
#define S_IRGRP 00040
#define S_IWGRP 00020
#define S_IXGRP 00010

#define S_IRWXO 00007
#define S_IROTH 00004
#define S_IWOTH 00002
#define S_IXOTH 00001

#endif