# Two Great Places to Discover Tech Talent and How to Attract Them

In 2020 and beyond, finding and hiring talented individuals who have technological experience will become increasingly important. This is due to the fact that technology is disrupting every industry of work in new and unprecedented ways. Staying on top of this disruption and making your company stand out from the competition starts with learning where to find talented tech employees.

To that point, finding talented tech workers is only the tip of the iceberg, as it is equally important to retain your workforce. If your company has a high employee turnover rate, it’s more likely than not that fewer people will want to work there. Therefore, there are a few small steps you can take that will help you retain the talent you work so hard to identify.

## Tech Bootcamps

More often than not, companies choose to source their employees from a standard source such as colleges or universities. However, there are new and unique educational institutions that produce graduates who are just as talented. An example of such a unique institution is a tech bootcamp. Unlike a university, bootcamps often last a number of months and teach students a single skill that prepares them for one career.

For example, highly rated [data science bootcamps](https://careerkarma.com/rankings/best-data-science-bootcamps/) prepare students for a career in data science. Even though data science is a field that used to require a master’s degree, the field has been opened up to bootcamp graduates due to their specialized knowledge. Despite the quick level of education, bootcamp graduates often boast as many skills as university counterparts.

![alt_text](assets/image-1.jpeg "image_tooltip")

Alt text: Two Women Sitting in Front of Computer Monitor (Pexels.com)

Caption: Bootcamp graduates often boast the same level of skill, if not higher, than their university counterparts

The above bootcamp is just one example of the many bootcamps available to prospective students. Bootcamps ranging from coding to web design are all available to anyone interested. If your company is hiring for a specific job, using bootcamps to source new employees is a unique and smart idea.

## Vocational Schools

Vocational schools, sometimes called [trade schools](https://jobtraininghub.com/), are similar to tech bootcamps, but take a longer amount of time to complete, typically around a year. Additionally, vocational schools usually offer a wider course selection than tech bootcamps. As with tech bootcamps, graduates from this educational institution are often overlooked despite having extensive knowledge and skills.

With that in mind, however, choosing to partner with a top trade school could provide you with a unique source of talented tech workers. Some schools, such as [Metis](https://careerkarma.com/schools/metis/), specialize in one field whereas others have a wide array of courses. Therefore, finding a school that aligns with your company's field shouldn’t prove difficult.

To that end, if you are worried that graduates from this source are less capable than university graduates, don’t be. [The Simple Dollar](https://www.thesimpledollar.com/investing/college/why-you-should-consider-trade-school-instead-of-college/) outlined some of the top reasons people should consider attending a trade school, and the fact of the matter is that graduates are equally as capable as any university counterpart.

![alt_text](assets/image-2.jpeg "image_tooltip")

Alt text: People Looking at Laptop Computer (Pexels.com)

Caption: Vocational schools are similar to bootcamps but last longer

## Offering Growth Opportunities

It’s human nature to grow.

We’ve been doing it since we were little. First it was growing up, now (for some of us) it’s growing out... either way, our bodies — and our minds — naturally want to become bigger than they are.
The human desire for growth is perhaps manifested most in the realm of career.

The 4 Types of Growth Opportunities

1. **Financial Growth**
   This is the one most people consider when they think about career development. Naturally, employees will be motivated by the possibility of increased income, especially when it’s tied to their performance.
   But don’t make the mistake of thinking that money is the only way to keep your staff happy. If you don’t have the funds (or you don’t like the competitive atmosphere that performance-based compensation can create), consider offering other forms of growth.

1. **Career Growth**
   Don’t underestimate the power of prestige.
   Even if they’re not part of a big corporation, most driven individuals will still want to move up in the ranks of their organization. So offer them various opportunities to do so — more significant duties, more impressive job titles, bigger offices, etc.

1. **Professional Growth**
   If they’re serious about their work, employees will want to improve in their field. In fact, most employees in this study rated training opportunities as highly important career benefits, with job-specific training at the top (54%).
   The best part about providing opportunities for professional growth is that it is mutually beneficial — employees get to feel more competent, and employers get to have more competent employees!
   Take advantage of this arrangement by offering ways for employees to sharpen their skills and knowledge, such as conferences, mentoring programs, online courses, or even tuition reimbursement. 

1. **Personal Growth**
   While it may seem like personal growth has nothing to do with career development, many employees are motivated by factors that are completely unrelated to work. With the increasingly blurred line between private and professional lives, it makes sense to encourage employees to pursue their personal goals.

   Do this by allowing:
   * *Flexible work schedules*
   * *The freedom to work remotely*
   * *Social gatherings outside of work*

   Lipman says that “peer praise” and a “fun work environment” are also good motivators, especially for those a little lower on the totem pole.

## Connect With Your Workforce

Now that you’ve found your talented employees and built a team that will carry your company far into the future, it’s time to reflect on how to keep them around. The easiest way to do this is with one thing: benefits.

You need to be offering workplace benefits that are attractive and better than anything offered by the competition. The heavy demand for tech professionals will result in competitive benefits among employers, but reaching out to your workforce through polls and one-on-one discussions is a great way to discover their unique needs. After doing so, you can focus on offering the benefits that apply most to your employees. Return to your notes where you asked employees [what motivates them](https://careerkarma.com/blog/what-motivates-you/) and use those answers to craft a benefits package that resonates with the majority of your workers.

### Conclusion

No matter how you look at it, technology is disrupting the entire workforce in new and unprecedented ways. It is increasingly less clear as to what the future of work will look like or even which industries will survive the disruption. The best any company can hope to do is hire a diverse workforce that can propel them into the future of work with a dynamic skill set that sets your company apart from any competition. Bootcamps and vocational schools are great sources of budding talent, so don’t forget to consider graduates from these institutions. Keeping that in mind, connect with your employees in key ways so that you can convince them to stay with your company for years to come.

**-- Artur Meyster**

Artur Meyster is the CTO of [Career Karma](https://careerkarma.com) (YC W19), an online marketplace that matches career switchers with coding bootcamps. He is also the host of the Breaking Into Startups podcast, which features people with non-traditional backgrounds who broke into tech.

[Twitter](https://twitter.com/arturmeyster)
[LinkedIn](https://www.linkedin.com/in/meyster)
