<!-- @format -->

[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/issues)
[![GitHub issues](https://img.shields.io/github/issues/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/issues)
[![GitHub forks](https://img.shields.io/github/forks/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/network)
[![GitHub stars](https://img.shields.io/github/stars/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/stargazers)
[![Twitter](https://img.shields.io/twitter/url/https/github.com/RitikPatni/Front-End-Web-Development-Resources.svg?style=social)](https://twitter.com/intent/tweet?text=Check%20this%20Amazing%20Resource:&url=https%3A%2F%2Fgithub.com%2FRitikPatni%2FFront-End-Web-Development-Resources)

# Front-end development

# Hi There

<p>
This is an open-source repository for all who want to learn front-end Development.</p>

<br>
<h2 align="center" ><strong>Front-end development</strong></h2><br>

> **Front-end web development** is the practice of converting data to a graphical interface, through the use of HTML, CSS, and JavaScript, so that users can view and interact with that data.
> <br>

**Make sure to show your support by star mark & sharing the repository**

# A List of Useful Resources for Front End Developers

---

## Table of Contents

- [Front-end development](#front-end-development)
- [Hi There](#hi-there)
- [A List of Useful Resources for Front End Developers](#a-list-of-useful-resources-for-front-end-developers)
  - [Table of Contents](#table-of-contents)
  - [RoadMap](#roadmap)
  - [Useful](#useful)
  - [Learning](#learning)
  - [A11y](#a11y)
  - [YouTube Channels](#youtube-channels)
  - [Blogs](#blogs)
    - [Hiring](#hiring)
  - [Podcasts](#podcasts)
  - [Code Editors](#code-editors)
    - [Visual Studio Code Extensions](#visual-studio-code-extensions)
  - [Tools](#tools)
  - [CSS Frameworks](#css-frameworks)
  - [Icons](#icons)
  - [Colors](#colors)
  - [Typography](#typography)
  - [Design Inspiration](#design-inspiration)
  - [Animation Frameworks](#animation-frameworks)
  - [Stock Resources](#stock-resources)
  - [Geolocation](#geolocation)
  - [APIs](#apis)
  - [Mockups](#mockups)
  - [Books](#books)
  - [Challenges / Games](#challenges--games)
  - [Free Tools For Students](#free-tools-for-students)
  - [YouTube Videos](#youtube-videos)
  - [Testing](#testing)

## RoadMap

- [Roadmap](https://roadmap.sh/frontend) - For a well described step-by-step roadmap for front-end developers. ![Free](https://img.shields.io/badge/-Free-brightgreen)

## Useful

- [BGJar](https://bgjar.com/) - Free SVG background generator for your websites, blogs, and app. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Inspect](https://inspect.dev/) - inspect and debug your mobile web apps and websites on iOS devices directly from Mac or Windows.

## Learning

- [A Complete Guide to Flexbox | CSS-Tricks](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) - A comprehensive guide to the Flexbox Layout. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [A Complete Guide to Grid | CSS-Tricks](https://css-tricks.com/snippets/css/complete-guide-grid/) - A comprehensive guide to the Grid Layout. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Command Line Power User](https://commandlinepoweruser.com/) - A video series for web developers on learning a modern command-line workflow with ZSH, Z, and related tools. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Grid](https://cssgrid.io/) - Complete video course all about CSS Grid ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Best Of JS](https://bestof.js.org/) A site to check the best GitHub Repos for your favourite js framework ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CodeCademy](https://www.codecademy.com/) - A series of interactive courses teaching the world how to code. Offering free and paid subscriptions across a variety of languages. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Codementor](https://www.codementor.io/experts) - A tool to get help from experienced developers in various coding languages on your learning journey. ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Scaler Topics](https://www.scaler.com/topics/) - A platform to learn programming languages like HTML, Java, Javascript, Python etc. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Conquering Responsive Layouts](https://courses.kevinpowell.co/conquering-responsive-layouts) - Made by Kevin Powell(https://twitter.com/KevinJPowell). This course takes you through everything you need to know to create responsive layouts in his brilliant 21-day course. ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Coursera](https://www.coursera.org/) - A selection of courses from highly reputable schools like Stanford and Yale. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [CSS Almanac | CSS-Tricks](https://css-tricks.com/almanac/) - A quick reference guide to many features of CSS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Grid Playground](https://mozilladevelopers.github.io/playground/css-grid/) - A visual guide curated by the Mozilla team to help you learn CSS's grid layout features with lots of code example and demos. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Design Resources](http://designresources.party/) - Design Resources from Skullface. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [dev.to](https://dev.to/) - Where programmers share ideas and help each other grow. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [DevProjects](https://www.codementor.io/projects) - A free community consists of curated projects from senior developers to help you bridge the gap between theory and practice. ![Free](https://img.shields.io/badge/-Free-brightgreen) !
- [Dicoding Academy](https://dicoding.com/) - Where everyone can learn programming from fundamentals (**Available only in Bahasa Indonesia**). ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [edx](https://www.edx.org/) - A series of University-level courses from Harvard, MIT, Wharton, and more. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [EggHead](https://egghead.io/) - Web development video tutorials in "bite-size" segments. Has both free and "Pro" (paid) memberships. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Enboard | Front End Resources](https://enboard.co/frontend/) - Organized resources about front end development. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Flexbox](https://flexboxzombies.com/p/flexbox-zombies) - Level up your Flexbox knowledge – an online, Zombie-centric story course. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [freeCodeCamp](https://www.freecodecamp.org) - A free resource incorporating programming projects and interview preparation for developer jobs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Frontend Masters](https://frontendmasters.com/) - Web development video tutorials from industry leaders (updated frequently). Has both free (limited-time) and paid memberships. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Full Stack Open](https://fullstackopen.com/en/) - Course on Full Stack Web Development by University of Helsinski. Learn React, Redux, Node.js, MongoDB, GraphQL and TypeScript in one go! This course will introduce you to modern JavaScript-based web development. The main focus is on building single page applications with ReactJS that use REST APIs built with Node.js. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [GeeksforGeeks](https://geeksforgeeks.org/) - A computer science portal for geeks. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Khan Academy](https://www.khanacademy.org/computing) - A universal online learning platform that also provides the important courses for developers. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [LearnAnything](https://learn-anything.xyz/) - Search interactive mind maps to learn anything. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Learn JavaScript](https://learnjavascript.online/) - Learn JavaScript in an interactive environment. Read short lessons, take notes, and complete challenges directly in your browser. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Mastering Markdown](https://masteringmarkdown.com/) - A Mini Series that will change how you write documentation. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Mozilla Developer Network](https://developer.mozilla.org/en-US/) - The latest information about Open Web technologies. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Complete web development tutorials](https://lyty.dev/) -Lyty.dev complete web development tutorials with well explained examples for free. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pluralsight](https://www.pluralsight.com/) - Unlimited online developer training from industry experts. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Saylor](https://www.saylor.org/) - An open, online learning solution offering college credit opportunities for students. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Scrimba](https://www.scrimba.com/) - Code-screencast-based learning in a variety of languages. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Scotch](https://scotch.io/) - Many Web development courses. Has both free and "Premium" (paid) memberships. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Search Courses](https://hackr.io/) - A selection of trending courses and tutorials. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [SoloLearn](https://www.sololearn.com/)- A free portal for learning web development. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Team Treehouse](https://teamtreehouse.com/) - Self-paced learning across a variety of languages and subjects. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [The Modern JavaScript Tutorial](https://javascript.info/) - Everything about the Javascript Language. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Odin Project](https://www.theodinproject.com/) - An Open-Source Curriculum for Learning Web Development ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Tutorials point](https://www.tutorialspoint.com/html/) - Tutorials for many different languages with interactive code examples. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Udacity](https://in.udacity.com/) - Learn anything online – deep learning, machine learning, front end languages. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Udemy](https://www.udemy.com/) - An online learning and teaching marketplace. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Watch and Code](https://watchandcode.com) - The computer science school for students that demand intellectual rigor and depth. ![Paid](https://img.shields.io/badge/-Paid-blue)
- [W3School](https://www.w3schools.com/) - Web development reference library. Covers HTML, CSS, Javascript (jQuery, AJAX, and more), as well as some server-side languages. Includes descriptions and interactive examples. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web APIs | MDN](https://developer.mozilla.org/en/docs/Web/API) - Everything a beginner needs to know about Web APIs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web Design in 4 minutes](http://jgthms.com/web-design-in-4-minutes/) by Jeremy Thomas creator of [Bulma CSS](http://bulma.io/) and [marksheet.io](http://marksheet.io). ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [WesBos](http://wesbos.com/) - Free and premium courses in web development ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Web Dev Tricks](https://webdevtrick.com) - All your CSS, js, jQuery trending codes with source codes in one place. Your handy partner for all types of modern web development and designs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [web.dev](https://web.dev/) - Guides and resources for modern fast websites by google developers. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Become a Front-End Web Developer](https://www.lynda.com/learning-paths/Web/become-a-front-end-web-developer) - Develop competency with HTML, CSS, JavaScript, and jQuery. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [WebGlossary.info](https://webglossary.info/) - Glossary for web development and design, with more than 3,500 entries (as per August 2023) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web Skills](https://andreasbm.github.io/web-skills/) - A visual overview of useful skills to learn as a web developer. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The App Brewery](https://www.appbrewery.co/) - All in one platform to cover your web development skills ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Full Stack open 2021](https://fullstackopen.com/en/) - This course serves as an introduction to modern web application development with JavaScript. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Devtools Tech](https://devtools.tech?ref=frontend-web-development-resources-github-repo) - A free interview preparation platform for Frontend Engineers with a focus on high quality real world programming questions. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## A11y

- [A11y Style Guide](https://a11y-style-guide.com/style-guide/section-resources.html) - A living style guide or pattern library, generated from KSS documented styles...with an accessibility twist. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Axe](https://www.deque.com/axe/) - Accessibility testing toolkit. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Colour Contrast Analyser](https://developer.paciellogroup.com/resources/contrastanalyser/) - CCA helps you determine the legibility of text and the contrast of visual elements, such as graphical controls and visual indicators. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Deque University](https://dequeuniversity.com/) - Online courses on web and mobile accessibility skills. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [W3C Intro to Web Accessibility](https://www.w3.org/WAI/fundamentals/accessibility-intro/) - Strategies, standards, resources to make the Web accessible to people with disabilities. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## YouTube Channels

- [Apna College](https://www.youtube.com/@ApnaCollegeOfficial)- Tutorials on HTML,CSS,Bootstrap,JavaScript,Git,Github,SQL ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Adrian Twarog](https://www.youtube.com/c/AdrianTwarog)- Tutorials on HTML,CSS,Bootstrap,JavaScript,React,React  
  Native,UI/UX and cool Designing stuff ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [1stWebDesigner](https://www.youtube.com/user/1stwebdesigner/) - Tutorials on WordPress, PSD to HTML ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Brad Hussey](https://www.youtube.com/user/hussey17) - Tutorials on Bootstrap, SASS, jQuery, PHP, Freelancing ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Tricks](https://www.youtube.com/channel/UCADyUOnhyEoQqrw_RrsGleA) - YouTube channel of well-known web design and development blog CSS Tricks by Chris Coyier. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Tutorials](https://www.youtube.com/watch?v=rxjFI4RlR9A&list=PLw9zMOoodWb4OtAt8aDKqklEJDqZHYXBm) - Tutorials in Hindi by Husain sir covering all the basics of CSS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Coder’s Guide](https://www.youtube.com/user/CodersGuide/) - Tutorials on HTML, CSS, JavaScript, Bootstrap ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Codevolution](https://www.youtube.com/c/Codevolution/featured) - Tutorials on React, Vue, Angular, MongoDB, JavaScript, MEAN stack, HTML, CSS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Clever Programmer](https://www.youtube.com/c/CleverProgrammer/videos) - Tutorials on React, MongoDB, JavaScript, MERN stack, HTML, CSS, React Native. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Derek Banas](https://www.youtube.com/user/derekbanas) - Tutorials on C#, Visual Basic, Django, Python, NodeJS, AngularJS, MongoDB, jQuery, JavaScript, CSS, Ruby on Rails, Java, SQLite, Android, HTML, PHP, Objective C ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [DevTips](https://www.youtube.com/user/DevTipsForDesigners) - Tutorials on HTML5, CSS, SASS, Bootstrap, Foundation, jQuery, Ruby on Rails, GitHub. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [DesignCourse](https://www.youtube.com/user/DesignCourse) - Tutorials on UI/UX Design or HTML5, CSS, SASS, Animation Library. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Dennis Ivy](https://www.youtube.com/channel/UCTZRcDjjkVajGL6wd76UnGg) - Tutorials on Django & Flask Full-Stack Web Development Projects ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Elzero Web School](https://www.youtube.com/user/OsamaElzero/) - **Arabic only** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [freeCodeCamp](https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ/) - Tutorials on JQuery, JavaScript, React, Math, Science, Software Engineering, Open source software ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Fun Fun Function](https://www.youtube.com/channel/UCO1cgjhGzsSYb1rsB4bFe4Q) - Tutorials on JavaScript, React, Functional Programming, GraphQL, Life as a Developer ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Google Chrome Developers](https://www.youtube.com/user/ChromeDevelopers) - Latest and greatest talks on modern web development with pro-tips, insights, and techniques to help you level up your web development skill. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Kevin Powell](https://www.youtube.com/user/KepowOb) - Tutorials on HTML, CSS, Helping to Understand Css Better in Simple Way ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [LearnCode.academy](https://www.youtube.com/user/learncodeacademy/) - Tutorials on HTML, CSS, jQuery, JavaScript, React JS / Redux, Node JS ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [LevelUpTuts](https://www.youtube.com/user/LevelUpTuts/) - Tutorials on HTML, CSS, SASS, WordPress, Magento,Drupal, React, Meteor ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Mackenzie Child - Design to Code Challenge](https://www.youtube.com/watch?v=gnizXEUupsA&list=PL23ZvcdS3XPJZDL1M-kxoPF06cl9hfVB_) - Tutorials on UI, how to design & code multiple styles of sites. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Coding Train](https://www.youtube.com/user/shiffman/videos) - Tutorials on JavaScript, Node, Machine Learning, Neural Networks, Algorithms ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Net Ninja](https://www.youtube.com/channel/UCW5YeuERMmlnqo4oq8vwUpg/) - Tutorials on HTML, CSS, jQuery, JavaScript, Git and GitHub, Bootstrap, MangoDB, PSD to WordPress, PSD to HTML, and many more. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [TheDigiCraft](https://www.youtube.com/user/TheDigiCraft) - Tutorials on HTML, CSS, jQuery, PHP, Ajax, Bootstrap, MySQL. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [thenewboston](https://www.youtube.com/user/thenewboston) - Tutorials on ECMAScript 6, React JS / Redux, Django, Angular 2, Gulp, Git, Python, SEO, SASS, SCSS, Grunt, Illustrator, MongoDB, PHP, Java, Ruby, Objective C ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Traversy Media](https://www.youtube.com/user/TechGuyWeb/) - Tutorials on HTML, CSS, jQuery, PHP, Ajax, Bootstrap, MySQL, ECMAScript 6, React JS / Redux, Django, Angular, Ionic, Gulp, Git, Python, Node JS, PHP, Laravel, Cake PHP, Symfony, CodeIgniter, Programming Tips ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CodeWithHarry](https://www.youtube.com/watch?v=6mbwJ2xhgzM&list=PLu0W_9lII9agiCUZYRsvtGTXdxkzPyItg) - Tutorials on HTML, CSS, Javascript, Node JS, MongoDB and hosting. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Programming With Mosh](https://www.youtube.com/watch?v=Ke90Tje7VS0) - Tutorial on React, Nodejs, Python, Javascript, Angular,Typescipt and C#. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Dev Ed](https://www.youtube.com/c/DevEd/featured) - Learn web development, web design, 3d modelling, tools like figma and more ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web Dev Simplified](https://www.youtube.com/channel/UCFbNIlppjAuEX4znoulh0Cw) - Learn Website Developments with Html , Javascript , Css and other Frameworks with same projects and more ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Mozilla Developer](https://www.youtube.com/channel/UCh5UlGiu9d6LegIeUCW4N1w) - Videos for helping you with your work as a web designer, web developer, or person involved making websites or web apps ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Academind](https://www.youtube.com/channel/UCSJbGtTlrDami-tDGPUV9-w) - There's always something to learn. Whether you want to have look at Angular Tutorials or Guides, Vue.js, other Frontend Development Content or Data Science Topics or anything else - you're probably right![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Sonny Sangha](https://www.youtube.com/channel/UCqeTj_QAnNlmt7FwzNwHZnA) Project Tutorials on React, Redux, Next JS & React Native![Free](https://img.shields.io/badge/-Free-brightgreen)
- [WB Web Development](https://www.youtube.com/c/WBWeb/) - Tutorials on HTML, CSS, Bootstrap, SASS, JavaScript, Git and GitHub, MongoDB, NodeJS, ReactJS ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Online Tutorials](https://www.youtube.com/c/OnlineTutorials4Designers)- Top class contents on front end web development. Has exclusive tutorials on HTML,CSS and javascript with amazing effects. A must visit for all front end developers![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Akshay Saini](https://www.youtube.com/c/akshaymarch7)- Videos on Frontend Interview Tips, Interview Experiences, and specially core concepts of Javascript.
- [Devtools Tech](https://www.youtube.com/c/devtoolstech)- Videos on Advanced Frontend Concepts, Interview Questions & Experiences, and focus on intermediate to advanced JavaScript concepts. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Blogs

- [10 Need to Know JavaScript Concepts Courses](https://scotch.io/courses/10-need-to-know-javascript-concepts) - From basic to advance Javascript concept explained in simple way that every Javascript developer need to know. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [100 Ways to be more creative](https://medium.com/the-1000-day-mfa/100-ways-to-be-more-creative-44e4a491b456) - 100 Ways to be More Creative from Shaunta Grimes. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [2017 Design RoundUp](https://tympanus.net/codrops2017/) - Collection of all Codrops web development resources for 2017. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [50 Things You [Probably] Forgot To Design – UX Power Tools – Medium](https://medium.com/ux-power-tools/50-things-you-probably-forgot-to-design-7a288b0ef914) - 50 Things You Probably Forgot to Design from Jon Moore ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [ACM Month Of Code 2k17: Building Moodify](https://medium.com/@ajay.ns08/acm-month-of-code-2k17-building-moodify-d5d9e0c52ca7) - ACM Month Of Code 2k17: Building Moodify from Ajay NS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [An Illustrated Guide for Setting Up Your Website Using GitHub &amp; Cloudflare](https://medium.freecodecamp.com/an-illustrated-guide-for-setting-up-your-website-using-github-cloudflare-5a7a11ca9465) - An illustrated guide to setting up your website using GitHub and Cloudflare from Karan Thakkar. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Brad Frost Blog](https://bradfrost.com/) - Author of Atomic Design, building design systems in CSS & HTML. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Best Free Fonts](https://www.websiteplanet.com/blog/best-free-fonts/) - 70+ Best Free Fonts for Designers – Free for Commercial Use in 2019 ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Animations vs the Web Animations API: A Case Study](https://bitsofco.de/css-animations-vs-the-web-animations-api/) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Tricks](https://css-tricks.com/) - Daily articles about CSS, HTML, JavaScript, and all things related to web design and development. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Design and Creativity quotes](http://blog.invisionapp.com/design-and-creativity-quotes/) - 72 Quotes about Design and Creativity from Margaret Kelsey. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Design Resources](http://designresources.party/) - List of resources for working in and learning about design. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Design For Change](https://medium.muz.li/design-for-change-439fc7ec6bb9?source=grid_home---8-5969bf7021a3-----3-1-----------------10) - Article on regenerative and sustainable designing by Viba Mohan. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Domain registrars DNS and hosting](https://medium.freecodecamp.com/domain-registrars-dns-and-hosting-353e4163a19) - Domain Registrars, DNS, and Hosting from Kirby Kohlmorge ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Beginners guide to Gatsby](https://medium.freecodecamp.org/setting-up-and-getting-used-to-gatsby-1fc27985ae8a) - Gatsby.js: How to set up and use the React Static Site Generator from Aman Mittal ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Examples of everything in ECMAScript in 2016,2017, 2018](https://medium.freecodecamp.org/here-are-examples-of-everything-new-in-ecmascript-2016-2017-and-2018-d52fa3b5a70e) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Flavio Copes Tutorials](https://flaviocopes.com/) - Daily tutorials about Javascript and Web development by Flavio Copes ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [From URL to Interactive](https://alistapart.com/article/from-url-to-interactive/) - Explanation of how our world wide web works. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Frontend Dogma](https://frontenddogma.com/) - News and tools for frontend development, usually updated twice a day ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Frontend Weekly](https://frontendweekly.co/) - The best articles, links and news related to Frontend Development delivered once a week to your inbox. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [How I Animated the bitsofcode Logo with CSS](https://bitsofco.de/how-i-animated-the-bitsofcode-logo/) - Process article on a custom CSS animation. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [How the minmax() Function Works](https://bitsofco.de/how-the-minmax-function-works/) - Explanation of the CSS minmax() function, which can be used for CSS grid layouts. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [How to Build an Impressive Portfolio When You're New to Tech](https://skillcrush.com/2015/03/12/impressive-tech-portfolio/) - How to Build an Impressive Portfolio When You’re New to Tech from Randle Browning ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [How to build a random quote generator with JavaScript and HTML, for absolute beginners](https://medium.freecodecamp.com/creating-a-bare-bones-quote-generator-with-javascript-and-html-for-absolute-beginners-5264e1725f08#.jbxuk5hiw) - How to Build a Random Quote Generator with JavaScript and HTML, for Absolute Beginners from Sophanarith Sok. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [How to build your first Vue Component](https://medium.freecodecamp.org/build-your-first-vue-js-component-2dc204bca514) - Beginner project tutorial to build a Vue Component by Sarah Dayan. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Let’s code a Neural Network from scratch — Part 1 – TypeMe – Medium](https://medium.com/typeme/lets-code-a-neural-network-from-scratch-part-1-24f0a30d7d62) - Let’s Code a Neural Network from Scratch from Charles Fried ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Music Player Inspirations](https://medium.muz.li/music-player-inspiration-2017-999403b2a85e) - Music Player Inspiration 2017 from Muzli. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Front End CheckList](https://codeburst.io/the-front-end-checklist-8b2292fdda44) - An Exhaustive List of all the Elements you need to have/test Before Launching your Website To Production. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [What it’s like to build and market a chatbot when you’re only 14 years old](https://medium.freecodecamp.com/the-ups-and-downs-of-building-and-marketing-a-chat-bot-when-youre-14-8a072830b43c#.eosguojxg) - What it’s Like to Build and Market a Chatbot When You’re Only 14 Years Old from Alec Jones ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [What's the Deal with Collapsible Margins?](https://bitsofco.de/collapsible-margins/) - Explanation of CSS' Collapsing Margins feature. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [A well curated list for UX](https://blog.prototypr.io/my-ux-resource-list-96ab9e36ac24) - Curated resource list for UX by fernandocomet. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Airbnb Open source](https://airbnb.io/) - Engineering and Data Science articles and open source projects. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Cost of JS](https://medium.com/@addyosmani/the-cost-of-javascript-in-2018-7d8950fbb5d4) - How to deliver JavaScript efficiently for valuable user experience by Addy Osmani. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Scroll-Snap](https://css-tricks.com/practical-css-scroll-snapping/) - Tutorial on CSS scroll snapping, which allows you to lock the viewport after a user has finished scrolling. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Preload, Prefetch and priorities in chrome](https://medium.com/reloading/preload-prefetch-and-priorities-in-chrome-776165961bbf) - Article on how web loading primitives work on Chrome's neworking stack by Addy Osmani. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Learning Git for yourself](https://gitbook.tw/) - Traditional Chinese ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [IDEs for web Developers](https://websitesetup.org/best-ide-software/) - Factors to consider when choosing an IDE for web development and examples of good options. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Top 8 Weather APIs for 2020](https://www.climacell.co/blog/top-8-weather-apis-for-2020/) - Top 8 Weather APIs for 2020 - The Best Free Weather APIs for Developers
- [Digital Ocean community Tutorials](https://www.digitalocean.com/community/tutorials) - A free tutorial collection from experts. All contributted from digital ocean community.
- [React for Beginners – A React.js Handbook for Front End Developers](https://www.freecodecamp.org/news/react-beginner-handbook/) - A React.js Handbook for Front End Developers
- [Ultimate React Resources](https://dev.to/hulyakarakaya/ultimate-react-resources-obl) - The blog includes blog posts, free e-books, Github Repos with curated lists, practical implementation of React.js in the real world with working code.
- [Complete Introduction to CSS Grid](https://dev.to/cenacr007_harsh/complete-introduction-to-css-grid-2ffh) - A blog to learn the fundamentals of CSS grid by building different complex layouts.
- [Rado's Blog)](https://blog.rstankov.com/) - A blog consisiting of articles on React Dependencies and Implementation, GraphQl and Lot more!
- [Roblog](https://robiul.dev/) - A Go-to destination for all things related to technology, JavaScript, Node.js, and web development.
- [Monica Powell Blog](https://aboutmonica.com/writing/) - An awesome blog on JavaScript, React, Gatsby and Git.
- [Devtools Tech](https://www.devtools.tech/resources/all?ref=frontend-web-development-resources-github-repo) - Carefully curated high quality resources for Frontend Engineers. ![Free](https://img.shields.io/badge/-Free-brightgreen)

### Hiring

- [Two Great Places to Discover Tech Talent and How to Attract Them](where-to-find-tech-talent.md) - Hiring tech talent in 2020

  **[⬆ back to top](#table-of-contents)**

---

## Podcasts

- [Coding Blocks](https://www.codingblocks.net/) - Software development podcasts by a team of professional programmers. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Frontend Happy Hour](https://frontendhappyhour.com/) - Front end, software, and career development podcasts by industry panelists. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [JavaScript Jabber](https://devchat.tv/js-jabber) - Podcasts for JavaScript developers. Website also offers many other programming-related podcasts. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Syntax](https://syntax.fm/) - Front end development podcasts by Wes Bos and Scott Tolinski from Level Up Tuts. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Code Editors

- [Atom](https://atom.io/) - Atom is a text editor that's modern, approachable, yet hackable to the core—a tool you can customize to do anything but also use productively without ever touching a config file. **Open Source** | **All Platforms** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Brackets](http://brackets.io/) - With focused visual tools and preprocessor support, Brackets is a modern text editor that makes it easy to design in the browser. It's crafted from the ground up for web designers and front-end developers. **Open Source** | **All Platforms** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Geany](https://geany.org/) - Geany is a small and lightweight integrated development environment. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [IntellijIDEA](https://www.jetbrains.com/idea/) - A universal IDE from JetBrains. It has code-completion, integrationa, and Version Control System (VCS). ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Notepad++](https://notepad-plus-plus.org/) - Notepad++ is a free (as in "free speech" and also as in "free beer") source code editor and Notepad replacement that supports several languages. **Windows Only** ![Free](https://img.shields.io/badge/-Free-brightgreen) -[Pycharm](https://www.jetbrains.com/pycharm/)-Used specially for python language,It provides code analysis,a graphical debugger,an integrated unit tester,integration with version control systems and supports web development with Django as well as data science with Anaconda. **All Platforms** | **Open Source** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Sublime Text](https://www.sublimetext.com/) - A sophisticated text editor for code, markup and prose. **All Platforms** ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Vim](https://www.vim.org/) - Vim is a highly configurable text editor for efficiently creating and changing any kind of text. It is included as "vi" with most UNIX systems and with Apple OS X. ![Free](https://img.shields.io/badge/-Free-brightgreen)

- [Visual Studio Code](https://code.visualstudio.com/) - Code editing Redefined. It has syntax highlighting and autocompletion with IntelliSense, Git commands built-in, Extensible and customizable. **Open Source** | **All Platforms** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [WebStorm](https://www.jetbrains.com/webstorm/) - The smartest JavaScript IDE, WebStorm is an integrated development environment for JavaScript and related technologies. **All Platforms** ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [UltraEdit](https://www.ultraedit.com/) - UltraEdit is a powerful HTML and Code editor available for Mac, Windows, and Linux. It comes with a built-in file comparison utility, autocompletion, advanced layout, multi-tab, multi-pane editors, and syntax highlighting for the most popular programming languages. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Nano](https://www.nano-editor.org) - GNU nano is a text editor for Unix-like OS's. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [StackBlitz](https://stackblitz.com/) - An online open-source powerful code editor for JavaScript Frameworks and Libraries, with some awesome features such as GitHub Imports, Live Server and direct commit from the Editor to Github! ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

### Visual Studio Code Extensions

- [Auto Rename Tag](https://marketplace.visualstudio.com/items?itemName=formulahendry.auto-rename-tag) - When you rename one HTML/XML tag, automatically rename the paired HTML/XML tag. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Better Comments](https://marketplace.visualstudio.com/items?itemName=aaron-bond.better-comments) - This extension color codes various types of comments to give them different significance and stand out from the rest of your code. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Bracket Pair Colorizor](https://marketplace.visualstudio.com/items?itemName=CoenraadS.bracket-pair-colorizer) - Colors matching brackets to make your code much more readable - very helpful. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Code Spell Checker](https://marketplace.visualstudio.com/items?itemName=streetsidesoftware.code-spell-checker) - A basic spell checker that works well with camelCase code. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [ES Lint](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint) - Javascript linter for highlighting code errors and best practices. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Formatting Toggle](https://marketplace.visualstudio.com/items?itemName=tombonnike.vscode-status-bar-format-toggle) - A VS Code extension that allows you to toggle the formatter (Prettier, Beautify, …) ON and OFF with a simple click. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Git History](https://marketplace.visualstudio.com/items?itemName=donjayamanne.githistory) - View git log, file history, compare branches or commits ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [GitLens](https://marketplace.visualstudio.com/items?itemName=eamodio.gitlens) - Supercharge the Git capabilities built into Visual Studio Code — Visualize code authorship at a glance via Git blame annotations and code lens, seamlessly navigate and explore Git repositories, gain valuable insights via powerful comparison commands, and so much more. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [JS Snippets](https://marketplace.visualstudio.com/items?itemName=xabikos.JavaScriptSnippets) - This extension contains code snippets for JavaScript in ES6 syntax for VS Code editor (supports both JavaScript and TypeScript). ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Live server](https://marketplace.visualstudio.com/items?itemName=ritwickdey.LiveServer) - A Quick Development Live Server with live browser reload. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Material Icon Theme](https://marketplace.visualstudio.com/items?itemName=PKief.material-icon-theme) - Google Material themed icon pack. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Path Intellisense](https://marketplace.visualstudio.com/items?itemName=christian-kohler.path-intellisense) - As you start typing a path in quotations, you will get intellisense for directories and file names. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Peacock](https://marketplace.visualstudio.com/items?itemName=johnpapa.vscode-peacock) - Subtly change the workspace color of your workspace. Ideal when you have multiple VS Code instances and you want to quickly identify which is which. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Polacode](https://marketplace.visualstudio.com/items?itemName=pnp.polacode) - You know those fancy code screenshots you see in articles and tweets? Well, most likely they came from Polacode. It's super simple to use. Copy a piece of code to your clipboard, open up the extension, paste the code, and click to save your image! ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Prettier](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode) - Format your code automatically on save. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Quokka.js](https://marketplace.visualstudio.com/items?itemName=WallabyJs.quokka-vscode) - Quokka.js is a developer productivity tool for rapid JavaScript / TypeScript prototyping. Runtime values are updated and displayed in your IDE next to your code, as you type. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Settings Sync](https://marketplace.visualstudio.com/items?itemName=Shan.code-settings-sync) - Settings Sync extension save your setting off in Github. Then, you can load them to any new version of VS Code with one command. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Tools

- [API Directory | ProgrammableWeb](https://www.programmableweb.com/apis/directory) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Animista](http://animista.net/) - CSS animation presets/generator ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Better Code Hub](https://bettercodehub.com/repositories) - Checks GitHub codebase against software engineering guidelines and gives feedback. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Browserling](https://www.browserling.com/) - Live interactive cross-browser testing on virtual machines. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [LambdaTest](https://www.lambdatest.com/) - Test websites & web apps on 2000+ browsers & OS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [BrowserStack](https://www.browserstack.com/) - Test websites and mobile apps on different browsers and mobile devices. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Can I use...](http://www.caniuse.com/) - Support tables for HTML5, CSS3, etc. on desktop and mobile browsers ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Checkbot](https://www.checkbot.io/) - Browser extension that tests websites for SEO, speed and security issues ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Codepen](https://codepen.io/) - Social development environment where you can write code in the browser and see results as you build. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Codeply](https://www.codeply.com/) - A HTML, CSS, JavaScript editor playground for designers & developers to compare, prototype and test frontend frameworks.![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Codesandbox](https://codesandbox.io/) - Instant IDE and prototyping tool for web development. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Create a new fiddle - JSFiddle](https://jsfiddle.net/) - Test JS, CSS, HTML, or CoffeeScript in an online code editor. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Critical Path CSS Generator - by Jonas Ohlsson](https://jonassebastianohlsson.com/criticalpathcssgenerator/) - Reduces the amount of CSS the browser has to go through to render a webpage. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CrossBrowserTesting App](https://app.crossbrowsertesting.com/livetests/run) - Web service for running functional web tests on mobile and desktop web browsers. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS cheat sheet](https://adam-marsden.co.uk/css-cheat-sheet) - A very easy to use one page reference for css selectors and properties. It also includes categories for flexbox and grid. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Minifier](https://cssminifier.com/) - Minify your CSS files! ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Reference](https://cssreference.io/) - A free visual guide to CSS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Triggers](https://csstriggers.com/) - Tells you what gets triggered when mutating a given CSS property. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Filters](https://www.cssfilters.co/) - Interactive CSS filter generator ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [ColorLisa](http://colorlisa.com/) - Color palette generator based on great artists ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [DirtyMarkup](https://dirtymarkup.com/) - Tidy up your HTML, CSS, and JavaScript code. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [ExtendsClass](https://extendsclass.com/) - Provides tools to add features directly usable in the browser. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Favicon Generator](http://www.favicon-generator.org/) - Upload an image and generate a favicon for your website. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Favicon Generator for iOS/Google Progressive Web App Manifest](https://realfavicongenerator.net/) - Online tool to test favicons on different platforms. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Free Developer Stuff](https://freestuff.dev/) - List of free stuff for developer by developer to use. Some services are free forever or have a free tier at least for 1 year. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Free for Developers](https://free-for.dev/) - This website has an extensive amount of free and paid resource lists curated not only for frontend developers but also for any kind of developer. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Generate favicon based on text](https://favicon.io/) - Generate a favicon from text, an image, or emojis. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Get Waves](https://getwaves.io/) - Generate many types of SVG waves for use in web design. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Glitch](https://glitch.com/) - Glitch is like working together in Google Docs–multiple people can work on the same project at the same time. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Graphic Generator](https://www.norio.be/graphic-generator/) - Generates graphics for some common front end applications.
- [Google Analytics](https://analytics.google.com/) - Web service that tracks and reports website traffic. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Google APIs Explorer](https://developers.google.com/apis-explorer/#p/) - Tool to interactively explore various Google APIs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Javascript Console in Sublime Text](https://pawelgrzybek.com/javascript-console-in-sublime-text/) - Tutorial to test JavaScript and execute it via build systems in Sublime Text 3. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [jQuery mega cheat sheet](https://cdn.makeawebsitehub.com/wp-content/uploads/2015/09/jquery-mega-cheat-sheet-Printable.pdf) - Cheat sheet of jQuery selectros, manipulation, events, and more in PDF format. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [JS Bin](http://jsbin.com/?html,output) - Live pastebin for HTML, CSS, and JS, as well as a range of processors. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Lighthouse](https://developers.google.com/web/tools/lighthouse) - Open source, automated tool for improving the quality of webpages. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Modern JavaScript cheat sheet](https://mbeaudru.github.io/modern-js-cheatsheet/) - This is an excellent collection of JavaScript Tips and concept by Manuel Beaudru works as a nice overview of many of the things you'll need to be familiar with if you're just getting started with JavaScript and other related frameworks. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Node Package Manager(npm)](https://www.npmjs.com) - Package manager for Javascript. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Yarn](https://yarnpkg.com) - Package manager for Javascript, Like npm. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Responsinator](http://www.responsinator.com/) - Replicate how responsive sites will look on popular devices. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [React cheat sheet](https://reactcheatsheet.com/) - A documentation based website also a progressive web app which means that works well even in offline. You can search by keyword or select one of the predefined filters. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Responsive Grid System](http://www.responsivegridsystem.com/) - Generate flexible grids to create a responsive website. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Regular Expression (Regex) Editor](https://rubular.com/) - Helps create and verify your regular expressions.
- [Sans Francisco - a tool for designers](http://www.sansfrancis.co/) - Collection of tools for designers ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Screensizemap](https://www.screensizemap.com/) - A comparison of screen sizes in device-independent pixel. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Sizzy:Browser Testing Tool](https://sizzy.co/) - Tool for developing and testing responsive design on multiple devices at once. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Stack Overflow](https://stackoverflow.com/) - Online community for developers to ask questions and get answers. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The W3C Markup Validation Service](http://validator.w3.org/#validate_by_input) - Checks the markup validity of Web documents in HTML, XHTML, SMIL, MATHML, etc. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The W3C CSS Validation Service](http://jigsaw.w3.org/css-validator/#validate_by_input) - Checks the validity of CSS and XHTML documents with style sheets. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Time Helper](https://currentmillis.com/) - Helps convert millis to DateTimes and vice-versa.
- [TinyPNG](https://tinypng.com/) - PNG and JPEG compression/optimizer ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web Developer Checklist](http://webdevchecklist.com/) - Categorized checklist for things to cover during web development. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Progressive Tooling to optimize your performance on Web](https://progressivetooling.com/) - List of tools that can be used to improve page performance. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [StackBlitz](https://stackblitz.com/angular/pxxjqeeegeba) - Online IDE for Angular and React projects that can be share via link. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Postman(Tool for testing APIs)](https://docs.api.getpostman.com/?version=latest) - API client to create, share, test, and document APIs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Free Bootstrap 5 Cheat Sheet](https://bootstrap-cheatsheet.themeselection.com/) - It is an interactive list of Bootstrap 5 classes, variables, and mixins. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [JSONT](https://www.jsont.run/) - An online simple and powerful JSON formatting tool. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## CSS Frameworks

- [Bootstrap](http://getbootstrap.com/) - Design and customize responsible mobile-first sites. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Bulma CSS](http://bulma.io/) - Modular open source framework based on Flexbox. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Caramel](http://caramel.kurisubrooks.com/) - A simple, modern, responsive website framework. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Cardinal](http://cardinalcss.com/) - Modular mobile-first framework for performance and scalability. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Element CSS](http://element.eleme.io/#/en-US) - Vue 2.0 based component library. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Foundation CSS](http://foundation.zurb.com/) - Family of responsive front-end frameworks. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Halfmoon](https://www.gethalfmoon.com/) - Fully customizable and responsive front-end framework for building dashboards and tools. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Jeet](http://jeet.gs/) - Fractional grid system for Sass and Stylus. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Less](http://lessframework.com/) - CSS grid system for designing adaptive websites. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Material Design Lite](https://getmdl.io/) - Implementation of Material Design components in vanilla CSS, JS, and HTML. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Materialize CSS](http://materializecss.com/) - CSS framework aimed to allow a unified user experience across all products on any platform. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Milligram](https://milligram.io/) - A minimalist CSS framework. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Neat](https://neat.bourbon.io/) - A lightweight and flexible Sass grid. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Petal CSS](https://shakrmedia.github.io/petal/) - Light CSS UI framework based on LESS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pure CSS](https://purecss.io/) - A set of small, responsive CSS modules. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Semantic UI](https://semantic-ui.com/) - UI framework designed for theming and responsive design. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Skeleton CSS](http://getskeleton.com/) - Simple, responsive boilerplate to kickstart any responsive project. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Spectre CSS](https://picturepan2.github.io/spectre/) - Lightweight, Responsive and Modern CSS framework for faster and extensible development. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Tacit](https://github.com/yegor256/tacit) - Primitive but attractive framework for beginners in graphic design. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [TailwindCSS](https://tailwindcss.com/) - Highly customizable, low level CSS framework. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [UI Kit](https://getuikit.com/) - Lightweight and modular front-end framework for web interfaces. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Unsemantic](https://unsemantic.com/) - Fluid grid system based on percentages, rather than a set number of columns. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Vital CSS](https://vitalcss.com/components/) - Minimally invasive CSS framework for web applications built with Sass and Slim. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Icons

- [Brandicons](http://fontello.github.io/brandico.font/demo.html) - Icon font generator and viewer. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Flat Icon](https://www.flaticon.com/) - Database of free icons in PNG, SVG, EPS, PSD, and Base64 formats. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Font Awesome](http://fontawesome.io/) - Open source icon set and toolkit with consistent styles. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Glyphicon](http://www.webhostinghub.com/glyphs/) - Icons for use with Bootstrap, other CSS frameworks, and any web projects. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Google Material Design Icons](http://google.github.io/material-design-icons/) - An overview of material icons and how to integrate them into projects. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Icomoon](https://icomoon.io/) - Icon font generator and icon collection. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Icongram](https://icongr.am/) - Collection of icon packs from different sources. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [IconSVG](https://iconsvg.xyz/) - Quick customizable icons for your projects ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Icons8](https://icons8.com/) - Consistently styled and customizable icon packs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Ionicons](http://ionicons.com/) - Open source icons in SVG and webfont. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Mapicons](http://map-icons.com/) - Icon font for use with Google Maps API and Google Places API using SVG markers and icon labels. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Material Design Iconic Font](http://zavoloklom.github.io/material-design-iconic-font/) - Full suite of material design icons for easy SVGs on website or desktop. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [MfgLabs-Iconset](http://mfglabs.github.io/mfglabs-iconset/) - MFG Lab's icon set for use in webfonts and CSS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Micon](http://xtoolkit.github.io/Micon/) - Windows font and CSS toolkit. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Noun Project](https://thenounproject.com/) - Comprehensive icon collection. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Octicons](https://octicons.github.com/) - Collection of GitHub's icons for projects. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Open Iconic, a free and open icon set](https://useiconic.com/open/) - Open source icon set in SVG, webfont, and raster formats. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [OpenWebIcons](http://pfefferle.github.io/openwebicons/) - Webfont for scalable vector icons and logos. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [ReactIcons](https://github.com/react-icons/react-icons) -SVG react icons of popular icon packs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [RemixIcon](https://github.com/Remix-Design/remixicon) - Open source neutral style icon system. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Shape.so](https://shape.so/) - Customizable collection of icons and animations. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Stackicons](http://stackicons.com/) - Customizable icons for social brands. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Typicons](https://www.s-ings.com/typicons/) - Free-to-use vector icons embedded in a webfont. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Weather Icons](https://erikflowers.github.io/weather-icons/) - Weather themed icon font and CSS. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Zocial | CSS3 Button Set](http://zocial.smcllns.com/) - Create social buttons using CSS and rendering social icons as a font. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Colors

- [Adobe Color](https://color.adobe.com/create/color-wheel) - Color Wheel, Extract Theme, Extract Gradient, Accessibility Tools and more ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [BADA55 Color Codes](http://bada55.io/) - Convert leet words into CSS hex colors. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Branition Colors](http://branition.com/colors/) - Hand-curated collection of color palettes best fitted for branding. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Color Hunt](http://colorhunt.co/) - Open collections of beautiful color palettes ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Color Theory by Natalya Shelburne](https://tallys.github.io/color-theory/) - Practical Color Theory for People who Code: Tutorial on the use of color with examples ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Color wheel | Color schemes - Adobe Color CC](https://color.adobe.com/create/color-wheel/?base=2&rule=Analogous&selected=4&name=My%20Color%20Theme&mode=rgb&rgbvalues=0.050000000000000044,1,0.6943295865110486,0.13153196324950517,0.04550000000000004,0.91,1,0,0,0.91,0.6632375135840386,0.04550000000000004,0.2526315789473136,0.48,0.216140350877193&swatchOrder=0,1,2,3,4) - Interactive color wheel with different color rules (adjustments possible) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Colordesigner Tools](https://colordesigner.io/) - The main purpose of this tool is to help with building a color palette and generate tints and shades based on it. Just pick a color, and the app does the rest. You can use the preselected colors or the color picker for more control. Check also the other tools [here](https://colordesigner.io/tools) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Colormind - Bootstrap](http://colormind.io/bootstrap/) - Colormind is a color scheme generator that uses deep learning to automatically apply the color pallete to a live website mockup. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Coolors](https://coolors.co)- Super fast color scheme creator with a lot of functionalities ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Gradient](https://cssgradient.io/gradient-backgrounds/) - Curated list of sites to explore gradients and color palettes. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Data Color Picker](https://learnui.design/tools/data-color-picker.html) - Generate color palettes with visually equidistant colors. Useful for data visualizations. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Designing in Color](https://medium.freecodecamp.com/designing-in-color-abd358660a7b) - A complete guide to design in color (article on Medium) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Flat UI Colors](https://flatuicolors.com/) - Color picker for flat designs ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Image Color Picker](https://image-color.com) - Image color picker and palette generator ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [LOL Colors](https://www.webdesignrankings.com/resources/lolcolors/) - Curated color palette inspirations ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Material Palette](https://www.materialpalette.com/) - Color palette generator for Material Design ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Palettable](http://www.palettable.io/ED3E75-383838-D4D4D4) - Interactive color picker: creates a color scheme based on your preferences and palettes on the Internet ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Paletton - The Color Scheme Designer](http://paletton.com/#uid=1000u0kllllaFw0g0qFqFg0w0aF) - Advanced tool for creating color schemes ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Picular - Google, but for colors](https://picular.co/) - Primary color generator using Google's image search. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pigment - Palette Generator](https://pigment.shapefactory.co/) - Generate color palettes based on lighting and pigment. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [UI Gradients](https://uigradients.com/#Influenza) - Scroll through or pick from beautiful gradients, download JPG and copy CSS Code ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [W3school Color Picker](https://www.w3schools.com/colors/colors_picker.asp) - Find the perfect color from the color wheel, easy control ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [UI Color Picker](https://uicolorpicker.com/) - Best colors in few selected shades to choose from very helpful for quickly choosing and adding color to design. ![Free]

**[⬆ back to top](#table-of-contents)**

---

## Typography

- [A Crash Course in Typography: The Basics of Type](https://www.noupe.com/essentials/icons-fonts/a-crash-course-in-typography-the-basics-of-type.html) - First article of a series on Typography ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Circular Font Combinations | Free Alternatives | Typewolf](https://www.typewolf.com/site-of-the-day/fonts/circular) - A great resource for everything related to Typography ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Font Pair - Helps designers pair Google Fonts together. Beautiful Google Font combinations and pairs.](http://fontpair.co/) - Clean web-tool on How to pair Google Fonts ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Fontspiration](http://sfcd.com/work/fontspiration/) - An iOS app for creating custom typographic designs ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Fontsquirrel](https://www.fontsquirrel.com/) - A resource for FREE, hand-picked, high-quality, commercial-use fonts ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Google Fonts](https://fonts.google.com/) - A catalog of free & open source fonts, great details and font pair suggestions ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Just My Type](https://justmytype.co/) - A collection of font pairings ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Table of Contents | The Elements of Typographic Style Applied to the Web](http://webtypography.net/toc/) - A practical guide to web typography ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Typekit](https://typekit.com/) - "Quality fonts from the world’s best foundries" ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Typography Terms](https://designschool.canva.com/blog/typography-terms/) - An infographic on Typography Terms + explanations ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Design Inspiration

- [Admire The Web](https://www.admiretheweb.com/) - Admire the Web is where we showcase the very best in website design inspiration - carefully curated and organised to keep you inspired. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Awwwards](https://www.awwwards.com/) - The Website Awards that recognize and promote the talent and effort of the best developers, designers and web agencies in the world. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Dribble](https://dribbble.com/) - Dribbble is where designers gain inspiration, feedback, community, and jobs and is your best resource to discover and connect with designers worldwide. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Site Inspire](https://www.siteinspire.com/) - siteInspire is a showcase of the finest web and interactive design. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web design Inspiration](http://www.webdesign-inspiration.com/) - Find inspiration for your next web design project. We help web designers, digital agencies and entrepreneurs to be inspired. Everyday, our team of experts hand picks the best new web designs from all over the world. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Behance](https://www.behance.net/) - Behance is a social media platform to showcase and discover creative work like Graphic Design, Illustration, Game Design and many more things ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pinterest](https://www.pinterest.com/) - Pinterest has a host of design inspirations in a variety of forms and styles. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pixpa](https://www.pixpa.com/) - Pixpa features some nice modern designs and inspirations for web designers and photographers. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Lapa Ninja](https://www.lapa.ninja/) - Lapa Ninja is a gallery featuring the best 4127 landing page examples, free books for designers and free UI kits from around the web. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Landings](https://landings.dev/) - Find the best landing pages for your design inspiration based on your preference. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Animation Frameworks

- [Animate CSS](https://daneden.github.io/animate.css/) - Choose, try out and get the CSS-Code for different animation types (over 70) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Anime JS](https://animejs.com/) - It’s easy to use, has a small and simple API, and offers everything you could want from a modern animation engine. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Bounce JS](http://bouncejs.com/) - Tool and JS Library, creating CSS3 powered animations(adjustments possible) & export CSS code ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Magic Animations](https://www.minimamente.com/example/magic_animations/) - Showcase of different animations with link to GitHub repo ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [MO JS](https://mojs.github.io/) - The library provides built-in components to start animating from scratch like HTML, shape, swirl, burst, and stagger but also brings you tools to help craft your animation in a most natural way. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Particles JS](https://vincentgarreau.com/particles.js/) - A lightweight JavaScript library for creating particles. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Typed JS](http://www.mattboldt.com/typed.js/) - A JavaScript typing animation library with a great documentation on GitHub ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Wow JS](https://wowjs.uk/) - JavaScript library: Reveal CSS animation as you scroll down a page ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)

**[⬆ back to top](#table-of-contents)**

---

## Stock Resources

- [Burst](https://burst.shopify.com) - Free, high-resolution images. All our pictures are free to download for personal and commercial use. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Canva](https://www.canva.com) - 8,000+ free templates and thousands of free photos ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Free stock images and Videos](http://allthefreestock.com/) - A great collection of stock photos, videos and other resources. Most of them under the CC0-License, all of them free. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Gratisography](https://www.gratisography.com) - Photographer Ryan McGuire provides this collection of high-resolution pictures for free. You can use them on your personal or commercial project free of copyright restrictions. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Humaaans](https://www.humaaans.com/) - Library of editable people illustrations. Free for both commercial and personal use. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [I’d Pin That!](http://idpinthat.com) - Created to help bloggers and non-designers create high quality images like those often seen on Pinterest. I’d Pin That is more than just a source for free images — **it is an image editor!** Use the tools provided here to add your own text and edit the images right on the site. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Illlustrations](https://illlustrations.co/) - 120+ Awesome free illustrations made by the artist vijay verma on a 100 days challenge. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [MakerBook - The best free resources for creatives](http://makerbook.net/) - A directory of sites to get free resources (Photography, Mockups, Graphics, Textures, Fonts, Colours, Video, Audio & Tools). ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Morguefile](https://morguefile.com/) - Founded in 1996 by college student Michael Connors.Photographers contribute images to Morguefile for visitors to use in their creative projects. Yes, they’re all completely free. The website does ask that you credit the photographer when possible. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Open Doodles](https://www.opendoodles.com/) - A Free Set of Open-Source Illustrations. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Open Photo Project](https://openphoto.net/) - The Open Photo Project is a photo sharing platform created in 1998 by Michael Jastremski. Contributors have offered their images free of charge under terms of Creative Commons licensing. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pexels](https://www.pexels.com/) - Exclusively stock photos of high quality, great feature: Filter photos by color. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Picalls](https://picalls.com/) - Free photos and wallpapers licensed under the Creative Commons CC0 license. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pixabay](https://pixabay.com/) - In addition to photos, Pixabay offers **video, vectors and illustrations.** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Pikwizard](https://pikwizard.com) - Free stock photo library for commercial and editorial use. Huge library of stunning, high quality, royalty free images. No attribution required ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Public Domain Archive](http://publicdomainarchive.com/) - “a public domain image repository” created by Matt a graphic designer, web designer and photographer.Vintage and modern images. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [StockSnap.io](https://stocksnap.io/) - High quality stock photos free to download and use. Licensed under the Creative Commons CC0 license. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [The Stocks](http://thestocks.im) - Another awesome directory sharing sites for resources, loading directly on the webpage ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [UnDraw](https://undraw.co) - "MIT licensed illustrations for every project you can imagine and create ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [UnSplash](https://unsplash.com) - "Beautiful, Free Photos" & themed collections of photos ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [3D Bay](https://clouddevs.com/3dbay/) - "Free, 3D Illustrations" A collection of High-quality 3D Illustration resources ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Design Stripe](https://designstripe.com/catalog) - "Create beautiful illustrations, no design skills needed ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)

**[⬆ back to top](#table-of-contents)**

---

## Geolocation

- [Geocomplete-location autocomplete](https://ubilabs.github.io/geocomplete/) - An advanced jQuery plugin that wraps the Google Maps APIs Geocoding and Places Autocomplete services into a dropdown for an input-form. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Google maps API | Google](https://developers.google.com/maps/) - Google Map APIs including documentation & learning resources - extensive ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Google maps API | Traversy](https://youtu.be/Zxf1mnP5zcw/) - Great YouTube tutorial on using the Google Maps APIs ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [OpenCage Geocoder](https://opencagedata.com/) - Free to use forward (lat/long to text) and reverse (text to lat/long) geocoding API ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [GeoJS](https://www.geojs.io/) - Free to use API for geolocation lookup by IP address ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## APIs

- [Alexa API | Codecademy](https://www.codecademy.com/learn/learn-alexa) - Learn to develop a custom Amazon Alexa skill that respond to the user's voice with custom messages. ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Abstract APIs](https://www.abstractapi.com) - Free utility API's for compressing images, creating user avatars, validating emails, and more ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [jsonplaceholder](https://jsonplaceholder.typicode.com) - Fake Online REST API for Testing and Prototyping ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [A list of public APIs](https://github.com/toddmotto/public-apis) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Lorem Picsum](https://picsum.photos/) - Easy to use and customize placeholder photos ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [OpenWeatherMap](https://openweathermap.org/api) - Weather API with free and paid licenses ![Free](https://img.shields.io/badge/-Free-brightgreen)
  ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Random famous quotes | Rapid APIs](https://rapidapi.com/andruxnet/api/Random%20Famous%20Quotes) - Gets a random quote in JSON format. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [TMDB API](https://www.themoviedb.org/documentation/api) - API Service for those who are interested in displaying data/images about different movies, TV Shows or actors in their application. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Unsplash Source](https://source.unsplash.com/) - API to retrieve random images from Unsplash.com ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Web APIs | MDN](https://developer.mozilla.org/en/docs/Web/API) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [News API](https://newsapi.org/) - Locate articles and breaking news headlines from news sources and blogs across the web with our JSON API. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Spotify API](https://developer.spotify.com/) - Spotify's Web API allows you to find music and podcasts, manage your Spotify collection, control audio playing, and do a variety of other things. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)

**[⬆ back to top](#table-of-contents)**

---

## Mockups

- [Am I Responsive](http://ami.responsivedesign.is/) - This is a tool to check the responsiveness of a website and take a screenshot on multiple devices in a single frame. Go to the site and enter the URL to capture the screenshot. You should have separate screen capture tool to take the proper screenshot. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Figma](https://www.figma.com/) - Free app with a simple to use surface for designing, prototyping and sharing your website and app ideas ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Adobe XD](https://www.adobe.com/products/xd.html?sdid=12B9F15S&mv=Search&ef_id=CjwKCAjwn9v7BRBqEiwAbq1Ey9SoyrTK1Zsdd88wGlJfTVkU0JuW40rItPaiAypnKZ7J-lLv_IUE0xoC0GEQAvD_BwE:G:s&s_kwcid=AL!3085!3!394015010053!e!!g!!adobe%20xd!1641846448!65452677551) - One of the best tool for UI/UX Design, Wireframe, animate, prototype, collaborate, and more ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Magic Mockups](http://magicmockups.com/) - Place your product in realistic environment! Free real-life product/app mockup generator. **Laptop, Phone, Tablet, Imac.** ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Rotato 3D Mockup Generator](https://rotato.app) - Make video 3D mockups and images. No experience required. Unlimited renders. MacOS.
- [The MockUp Club](https://themockup.club/) - Website that offers free downloads of design mockups (mostly Photoshop format). ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [MockupsJar](https://mockupsjar.com/) - Build mockups with screenshots of your application or web Design for free to share with customers and clients ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [MockUPhone](https://mockuphone.com) - Free and simple screenshots device mockups generator. Wrap your design in mobile devices or Laptop/Desktop in a few clicks! ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Multi Device Website Mockup Generator](http://techsini.com/multi-mockup/) - Multi device website mockup generator is free online tool to test your responsive website on apple devices including Apple iMac, MacBook, iPad and iPhone. This tool is very helpful for theme developers to mockup the web template on various apple devices with a single click. You should have a proper screen grabber tool to take the screenshot from the browser. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Wireframe.cc](https://wireframe.cc/) - Great tool for sketching out ideas and layouts, super minimalistic ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Books

- [Ebook Foundation-free programing books: GitHub Repository](https://github.com/EbookFoundation/free-programming-books) - A directory of free learning resources, categorized by language ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [HTML Basics](https://www.austincc.edu/hr/profdev/eworkshops/docs/HTML_Basics.pdf) - A workshop covering the basics of HTML (free pdf/18 pages) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [HTML5 for Masterminds, 2nd Edition](https://www.amazon.com/gp/product/1500429120/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1500429120&linkCode=as2&tag=pinnok-20&linkId=IBCPBVE3TBPCOUWF) - A complete course from Beginner to Mastermind ![Paid](https://img.shields.io/badge/-Paid-blue)
- [HTML5 Pocket Reference (Pocket Reference (O'Reilly)](http://www.amazon.com/gp/product/1449363350/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1449363350&linkCode=as2&tag=pinnok-20&linkId=M6JD2MFAN24X3E7W) - A comprehensive compact reference for HTML 5 ![Paid](https://img.shields.io/badge/-Paid-blue)
- [HTML Tutorialspoint](http://www.tutorialspoint.com/html/html_tutorial.pdf) - A thorough tutorial on HTML (free pdf/486 pages) ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Learn How To Code In HTML5 and CSS3](http://howtocodeinhtml.com/) - A free e-book about making websites in HTML5 and CSS for absolute beginners ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Responsive Web Design with HTML5 and CSS3](http://www.amazon.com/gp/product/1784398934/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1784398934&linkCode=as2&tag=pinnok-20&linkId=6CN4JQGXTZU6DHRY) - A comprehensive book about making RWD ![Paid](https://img.shields.io/badge/-Paid-blue)
- [You don't know JS](https://github.com/getify/You-Dont-Know-JS) - Book series diving deep into the core mechanisms of the JavaScript language. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Guide to Git and Github](https://launchschool.com/books/git) - A beginner friendly guide to using git and working with Github. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Introduction to HTTP](https://launchschool.com/books/http) - Introduction to HTTP, the stateless protocol underlying all of the web. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Introduction to the Command Line](https://launchschool.com/books/command_line) - A short and beginner friendly introduction to the command line, covering common commands that will make you immediately productive. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [HTML & CSS Books](https://www.interviewbit.com/blog/html-css-books/)  ![Free]
- [Web Design Playground, Second Edition](https://www.manning.com/books/web-design-playground-second-edition) - Modern HTML, CSS, and web design standards.[Paid](https://img.shields.io/badge/-Paid-blue)
- [Build a Frontend Web Framework (From Scratch)](https://www.manning.com/books/build-a-frontend-web-framework-from-scratch) - Learn how a frontend web framework works by coding your own.[Paid](https://img.shields.io/badge/-Paid-blue)

**[⬆ back to top](#table-of-contents)**

---

## Challenges / Games

- [Ace Front End](https://www.acefrontend.com/) - Ace Front End has complete and practical coding challenges, with a detailed walk through of a perfect interview solution. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Codepen Challenges](https://codepen.io/challenges/) - Each month has a theme and every week there is a new challenge prompt that you can use to build a project online using HTML, CSS and JavaScript. The best projects are featured on Codepen's homepage. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Codewars](https://www.codewars.com/) - Improve your skills by training with others on real code challenges. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Battle](https://cssbattle.dev/) - CSSBattle is an online CSS [Code Golfing](https://en.wikipedia.org/wiki/Code_golf) game. Here, players from all around the world try to visually replicate **Targets** in smallest possible CSS code and battle it out to get to the top of the leaderboard. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Diner](http://flukeout.github.io/) - It's a fun game to learn and practice CSS selectors. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [CSS Zen Garden](http://www.csszengarden.com/) - A demonstration of what can be accomplished through CSS-based design, and a chance to do your own. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Dev Challenges](https://devchallenges.io/) - Made by [Thu Nghiem](https://twitter.com/thunghiemdinh). devChallenges.io is a community driven platform for anyone who wants to solve practical tasks. It has some tricky and curated challenges. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Flexbox Defense](http://www.flexboxdefense.com) - It is a game that covers the flex properties align-items, justify-content, flex-direction, align-self and has 12 different levels. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Flexbox Froggy](https://flexboxfroggy.com) - This game is also about Flexbox and it covers even more flex properties: align-items, justify-content, align-content, flex-direction, align-self, flex-wrap, flex-flow and has 24 different levels. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Front End Mentor](https://www.frontendmentor.io/) - Solve real-world HTML, CSS and JavaScript challenges whilst working to professional designs. Join 192,401 developers building projects, reviewing code, and helping each other get better. ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Grid Garden](http://cssgridgarden.com/) - Interactive CSS code game. Practice your CSS skills by watering your garden! It has 28 different levels to learn CSS Grid Layout. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Hackerrank](https://www.hackerrank.com/) - Practice coding, prepare for interviews, and solve interview style coding challenges. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [JavaScript30](https://javascript30.com/) - A free challenge course, building 30 little projects with HTML, CSS and plain JavaScript. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Leetcode](https://leetcode.com/) - Coding problems to solve in a range of categories and difficulties ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Project Euler](https://projecteuler.net/) - Challenging computer science and mathematical problems. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [100DaysOfCode](https://www.100daysofcode.com/) - Regardless of your coding skills or your language of choice, this challenge invites you to code for at least 1 hour a day. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Devtools Tech](https://www.devtools.tech/questions/all?ref=frontend-web-development-resources-github-repo) - Devtools Tech is a free platform for Frontend Engineers to practice high quality real world programming interview questions, follow curated learning paths, read blogs, and track progress across various frontend domains. ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## Free Tools For Students

- [**JetBrains Student License**](https://www.jetbrains.com/student/): Free individual licenses of the award-winning professional developer tools from JetBrains for students and faculty members. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [**Student Developer Pack**](https://education.github.com/pack): The best developer tools, free for students via @githubeducation ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

---

## YouTube Videos

- [**Flexbox in 20 minutes**](https://youtu.be/JJSoEo8JSnc) - Quick crash-course on the CSS Flexbox model. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [**SVGs can do that**](https://www.youtube.com/watch?&v=4laPOtTRteI) 😎 - Sarah Drasner's talk on nontypical pratical uses of SVGs. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [**CSS Grid Tutorial**](https://www.youtube.com/watch?v=EFafSYg-PkI&ab_channel=DevEd) - Use CSS grid to structure and position websites with ease. ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [**Git and GitHub for Beginners - Crash Course**](https://www.youtube.com/watch?v=RGOj5yH7evk&ab_channel=freeCodeCamp.org) - Ad-free tutorial by freeCodeCamp.![Free](https://img.shields.io/badge/-Free-brightgreen)
- [**12HR Coding Bootcamp 2021!**](https://www.youtube.com/watch?v=Xm4BObh4MhI) - Complete frontend bootcamp!
  ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**

## Testing

- [Jest](https://jestjs.io/) - JavaScript testing framework ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Mocha](https://mochajs.org/) - JavaScript testing framework ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Karma](https://karma-runner.github.io/latest/index.html) - JavaScript test runner![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Istanbul](https://istanbul.js.org/) - JavaScript test coverage tool ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [TestCafe](https://devexpress.github.io/testcafe/) - Node.js end-to-end testing ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Cypress](https://www.cypress.io/) - JavaScript end-to-end testing framework ![Free](https://img.shields.io/badge/-Free-brightgreen) ![Paid](https://img.shields.io/badge/-Paid-blue)
- [Puppeteer](https://pptr.dev) - Google's Chrome automation tool for E2E testing.
- [Playwright](https://playwright.dev) - Microsoft's browser automation tool for E2E testing.
- [Sinon.JS](https://sinonjs.org/) - Standalone test spies, stubs and mocks for JavaScript ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Chai](https://www.chaijs.com/) - Assertation library for JavaScript testing ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [PactumJS](https://pactumjs.github.io/) - REST API Testing Tool used to automate e2e, integration, contract & component (or service level) tests ![Free](https://img.shields.io/badge/-Free-brightgreen)
- [Vitest](https://vitest.dev/) - Vitest is a blazing fast unit test framework powered by Vite ![Free](https://img.shields.io/badge/-Free-brightgreen)

**[⬆ back to top](#table-of-contents)**