[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](https://github.com/dwyl/esta/issues)
[![HitCount](http://hits.dwyl.io/RitikPatni/Front-End-Web-Development-Resources.svg)](http://hits.dwyl.io/RitikPatni/Front-End-Web-Development-Resources)
[![GitHub issues](https://img.shields.io/github/issues/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/issues)
[![GitHub forks](https://img.shields.io/github/forks/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/network)
[![GitHub stars](https://img.shields.io/github/stars/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/stargazers)
[![GitHub license](https://img.shields.io/github/license/RitikPatni/Front-End-Web-Development-Resources.svg)](https://github.com/RitikPatni/Front-End-Web-Development-Resources/blob/master/LICENSE)
[![Twitter](https://img.shields.io/twitter/url/https/github.com/RitikPatni/Front-End-Web-Development-Resources.svg?style=social)](https://twitter.com/intent/tweet?text=Check%20this%20Amazing%20Resource:&url=https%3A%2F%2Fgithub.com%2FRitikPatni%2FFront-End-Web-Development-Resources)

# Uma Lista de Recursos Úteis para Desenvolvedores Front End

---

## Tabela de Conteúdos

- [A List of Useful Resources for Front End Developers](#a-list-of-useful-resources-for-front-end-developers)
  - [Table of Contents](#table-of-contents)
  - [Learning](#learning)
  - [YouTube Channels](#youtube-channels)
  - [Blogs](#blogs)
  - [Code Editors](#code-editors)
    - [Visual Studio Code Extensions](#visual-studio-code-extensions)
  - [Tools](#tools)
  - [CSS Frameworks](#css-frameworks)
  - [Icons](#icons)
  - [Colors](#colors)
  - [Typography](#typography)
  - [Design Inspiration](#design-inspiration)
  - [Animation Frameworks](#animation-frameworks)
  - [Stock Resources](#stock-resources)
  - [Geolocation](#geolocation)
  - [APIs](#apis)
  - [Mockups](#mockups)
  - [Books](#books)
  - [Challenges](#challenges)
  - [Free Tools For Students](#free-tools-for-students)
  - [YouTubeVideos](#youtubevideos)

---

## Aprendendo

- [A Complete Guide to Flexbox | CSS-Tricks](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) - A comprehensive guide to the Flexbox Layout.
- [Best Of JS](https://bestof.js.org/) 👍 A site to check best GitHub repos for your favorite js framework
- [CodeCademy](https://www.codecademy.com/) 👍 - A series of interactive courses teaching the world how to code. Offering free and paid subscriptions across a variety of languages.
- [Coursera](https://www.coursera.org/) - A selection of courses from highly reputable schools like Stanford and Yale.
- [CSS Almanac | CSS-Tricks](https://css-tricks.com/almanac/) 👍 - A quick reference guide to many features of CSS.
- [Design Resources](http://designresources.party/) - Design Resources from Skullface.
- [edx](https://www.edx.org/) - A series of University-level courses from Harvard, MIT, Wharton and more.
- [EggHead](https://egghead.io/) - Web development video tutorials in "bite-size" segments. Has both free and "Pro" (paid) memberships.
- [Flexbox](http://gedd.ski/master/flexbox/) 👍 - Level up your Flexbox knowledge – an online, Zombie-centric story course.
- [Flexbox Froggy](http://flexboxfroggy.com/)
- [freeCodeCamp](https://www.freecodecamp.org) 👍 - A free resource incorporating programming projects and interview preparation for developer jobs.
- [Grid Garden](http://cssgridgarden.com/) - Interactive CSS code game. Practice your CSS skills by watering your garden!
- [LearnAnything](https://learn-anything.xyz/) - Search interactive mind maps to learn anything.
- [Mozilla Developer Network](https://developer.mozilla.org/en-US/) 👍 - The latest information about Open Web technologies.
- [Pluralsight](https://www.pluralsight.com/) - Unlimited online developer training from industry experts.
- [Saylor](https://www.saylor.org/) - An open, online learning solution offering college credit opportunities for students.
- [Scrimba](https://www.scrimba.com/)
- [Scotch](https://scotch.io/) - Many Web development courses. Has both free and "Premium" (paid) memberships.
- [Search Courses](https://hackr.io/) - A selection of trending courses and tutorials.
- [Team Treehouse](https://teamtreehouse.com/) - Self-paced learning across a variety of languages and subjects.
- [The Odin Project](https://www.theodinproject.com/) - An Open-Source Curriculum for Learning Web Development
- [Tutorials point](https://www.tutorialspoint.com/html/) - Tutorials for many different languages with interactive code examples.
- [Udacity](https://in.udacity.com/) 👍 - Learn anything online – deep learning, machine learning, front end languages.
- [Udemy](https://www.udemy.com/) - An online learning and teaching marketplace.
- [Watch and Code®](https://watchandcode.com/p/practical-javascript) - Build a strong JavaScript foundation for web development.
- [W3School](https://www.w3schools.com/) - Web developlment reference library. Covers HTML, CSS, Javascript (jQuery, AJAX, and more), as well as some server-side languages. Includes descriptions and interactive examples.
- [Web APIs | MDN](https://developer.mozilla.org/en/docs/Web/API) - Everything a beginner needs to know about Web APIs.
- [Web Design in 4 minutes](http://jgthms.com/web-design-in-4-minutes/) by Jeremy Thomas creator of [Bulma CSS](http://bulma.io/) and [marksheet.io](http://marksheet.io).
- [WesBos](http://wesbos.com/)

**[⬆ back to top](#table-of-contents)**

---

## Canais do Youtube

- [1stWebDesigner](https://www.youtube.com/user/1stwebdesigner/) - Tutorials on: WordPress, PSD to HTML
- [Brad Hussey](https://www.youtube.com/user/hussey17) - Tutorials on: Bootstrap, SASS, jQuery, PHP, Freelancing
- [CSS Tricks](https://www.youtube.com/channel/UCADyUOnhyEoQqrw_RrsGleA) - YouTube channel of well-known web design and development blog CSS Tricks by Chris Coyier.
- [Coder’s Guide](https://www.youtube.com/user/CodersGuide/) - Tutorials on: HTML, CSS, JavaScript, Bootstrap
- [Derek Banas](https://www.youtube.com/user/derekbanas) - Tutorials on: C#, Visual Basic, Django, Python, NodeJS, AngularJS, MongoDB, jQuery, JavaScript, CSS, Ruby on Rails, Java, SQLite, Android, HTML, PHP, Objective C
- [DevTips](https://www.youtube.com/user/DevTipsForDesigners) - Tutorials on HTML5, CSS, SASS, Bootstrap, Foundation, jQuery, Ruby on Rails, GitHub.
- [Elzero Web School](https://www.youtube.com/user/OsamaElzero/) - **Arabic only**
- [freeCodeCamp](https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ/) - Tutorials on: JQuery, JavaScript, React, Math, Science, Software Engineering, Open source software
- [Google Chrome Developers](https://www.youtube.com/user/ChromeDevelopers) - Latest and greatest talks on modern web development with pro-tips, insights, and techniques to help you level up your web development skill.
- [LearnCode.academy](https://www.youtube.com/user/learncodeacademy/) - Tutorials on: HTML, CSS, jQuery, JavaScript, React JS / Redux, Node JS
- [LevelUpTuts](https://www.youtube.com/user/LevelUpTuts/) - Tutorials on: HTML, CSS, SASS, WordPress, Magento,Drupal, React, Meteor
- [The Net Ninja](https://www.youtube.com/channel/UCW5YeuERMmlnqo4oq8vwUpg/) - Tutorials on: HTML, CSS, jQuery, JavaScript, Git and GitHub, Bootstrap, MangoDB, PSD to WordPress, PSD to HTML, and many more.
- [TheDigiCraft](https://www.youtube.com/user/TheDigiCraft) - Tutorials on: HTML, CSS, jQuery, PHP, Ajax, Bootstrap, MySQL.
- [thenewboston](https://www.youtube.com/user/thenewboston) - Tutorials on: ECMAScript 6, React JS / Redux, Django, Angular 2, Gulp, Git, Python, SEO, SASS, SCSS, Grunt, Illustrator, MongoDB, PHP, Java, Ruby, Objective C
- [Traversy Media](https://www.youtube.com/user/TechGuyWeb/) 👍 - Tutorials on: HTML, CSS, jQuery, PHP, Ajax, Bootstrap, MySQL, ECMAScript 6, React JS / Redux, Django, Angular, Ionic, Gulp, Git, Python, Node JS, PHP, Laravel, Cake PHP, Symfony, CodeIgniter, Programing Tips

**[⬆ back to top](#table-of-contents)**

---

## Blogs

- [100 Ways to be more creative](https://medium.com/the-mission/100-ways-to-be-more-creative-bbaa99643fe5) - 100 Ways to be More Creative from Shaunta Grimes.
- [2017 Design RoundUp](https://tympanus.net/codrops2017/) 👍
- [50 Things You [Probably] Forgot To Design – UX Power Tools – Medium](https://medium.com/ux-power-tools/50-things-you-probably-forgot-to-design-7a288b0ef914) - 50 Things You Probably Forgot to Design from Jon Moore
- [ACM Month Of Code 2k17: Building Moodify](https://medium.com/@ajay.ns08/acm-month-of-code-2k17-building-moodify-d5d9e0c52ca7) - ACM Month Of Code 2k17: Building Moodify from Ajay NS.
- [An Illustrated Guide for Setting Up Your Website Using GitHub &amp; Cloudflare](https://medium.freecodecamp.com/an-illustrated-guide-for-setting-up-your-website-using-github-cloudflare-5a7a11ca9465) - An illustrated guide to setting up your website using GitHub and Cloudflare from Karan Thakkar.
- [CSS Animations vs the Web Animations API: A Case Study](https://bitsofco.de/css-animations-vs-the-web-animations-api/)
- [Design and Creativity quotes](http://blog.invisionapp.com/design-and-creativity-quotes/) - 72 Quotes about Design and Creativity from Margaret Kelsey.
- [Design Resources](http://designresources.party/)
- [Design For Change](https://medium.muz.li/design-for-change-439fc7ec6bb9?source=grid_home---8-5969bf7021a3-----3-1-----------------10)
- [Domain registrars DNS and hosting](https://medium.freecodecamp.com/domain-registrars-dns-and-hosting-353e4163a19) - Domain Registrars, DNS, and Hosting from Kirby Kohlmorge
- [Beginners guide to Gatsby](https://medium.freecodecamp.org/setting-up-and-getting-used-to-gatsby-1fc27985ae8a) Gatsby.js: How to set up and use the React Static Site Generator from Aman Mittal
- [Examples of everything in ECMAScript in 2016,2017, 2018](https://medium.freecodecamp.org/here-are-examples-of-everything-new-in-ecmascript-2016-2017-and-2018-d52fa3b5a70e)
- [How I Animated the bitsofcode Logo with CSS](https://bitsofco.de/how-i-animated-the-bitsofcode-logo/)
- [How the minmax() Function Works](https://bitsofco.de/how-the-minmax-function-works/)
- [How to Build an Impressive Portfolio When You're New to Tech](https://skillcrush.com/2015/03/12/impressive-tech-portfolio/) - How to Build an Impressive Portfolio When You’re New to Tech from Randle Browning
- [How to build a random quote generator with JavaScript and HTML, for absolute beginners](https://medium.freecodecamp.com/creating-a-bare-bones-quote-generator-with-javascript-and-html-for-absolute-beginners-5264e1725f08#.jbxuk5hiw) - How to Build a Random Quote Generator with JavaScript and HTML, for Absolute Beginners from Sophanarith Sok.
- [How to build your first Vue Component](https://medium.freecodecamp.org/build-your-first-vue-js-component-2dc204bca514) 👍
- [Let’s code a Neural Network from scratch — Part 1 – TypeMe – Medium](https://medium.com/typeme/lets-code-a-neural-network-from-scratch-part-1-24f0a30d7d62) - Let’s Code a Neural Network from Scratch from Charles Fried
- [Music Player Inspirations](https://medium.muz.li/music-player-inspiration-2017-999403b2a85e) - Music Player Inspiration 2017 from Muzli.
- [The Front End CheckList](https://codeburst.io/the-front-end-checklist-8b2292fdda44) - An Exhaustive List of all the Elements you need to have/test Before Launching your Website To Production.
- [What it’s like to build and market a chatbot when you’re only 14 years old](https://medium.freecodecamp.com/the-ups-and-downs-of-building-and-marketing-a-chat-bot-when-youre-14-8a072830b43c#.eosguojxg) - What it’s Like to Build and Market a Chatbot When You’re Only 14 Years Old from Alec Jones
- [What's the Deal with Collapsible Margins?](https://bitsofco.de/collapsible-margins/)
- [A well curated list for UX](https://blog.prototypr.io/my-ux-resource-list-96ab9e36ac24) 👍
- [Airbnb Open source](https://airbnb.io/) 👍
- [The Cost of JS](https://medium.com/@addyosmani/the-cost-of-javascript-in-2018-7d8950fbb5d4) 👍
- [CSS Scroll-Snap](https://css-tricks.com/practical-css-scroll-snapping/) 🔥🔥🔥

  **[⬆ back to top](#table-of-contents)**

---

## Editores de Código

- [Atom](https://atom.io/) - Atom is a text editor that's modern, approachable, yet hackable to the core—a tool you can customize to do anything but also use productively without ever touching a config file. **Open Source** | **All Platforms**
- [Brackets](http://brackets.io/) - With focused visual tools and preprocessor support, Brackets is a modern text editor that makes it easy to design in the browser. It's crafted from the ground up for web designers and front-end developers. **Open Source** | **All Platforms**
- [Notepad++](https://notepad-plus-plus.org/) - Notepad++ is a free (as in "free speech" and also as in "free beer") source code editor and Notepad replacement that supports several languages. **Windows Only**
- [Sublime Text](https://www.sublimetext.com/) - A sophisticated text editor for code, markup and prose. **All Platforms**
- [Visual Studio Code](https://code.visualstudio.com/) - Code editing Redefined. It has syntax highlighting and autocompletion with IntelliSense, Git commands built-in, Extensible and customizable. **Open Source** | **All Platforms**

### Extensões do Visual Studio Code

- [Auto Rename Tag](https://marketplace.visualstudio.com/items?itemName=formulahendry.auto-rename-tag) - When you rename one HTML/XML tag, automatically rename the paired HTML/XML tag.
- [Better Comments](https://marketplace.visualstudio.com/items?itemName=aaron-bond.better-comments) - This extension color codes various types of comments to give them different significance and stand out from the rest of your code.
- [Bracket Pair Colorizor](https://marketplace.visualstudio.com/items?itemName=CoenraadS.bracket-pair-colorizer) - Colors matching brackets to make your code much more readable very helpfull.
- [Live server](https://marketplace.visualstudio.com/items?itemName=ritwickdey.LiveServer) - A Quick Development Live Server with live browser reload.
- [Material Icon Theme](https://marketplace.visualstudio.com/items?itemName=PKief.material-icon-theme) - Google Material themed icon pack.
- [Path Intellisense](https://marketplace.visualstudio.com/items?itemName=christian-kohler.path-intellisense) - As you start typing a path in quotations, you will get intellisense for directories and file names.
- [Polacode](https://marketplace.visualstudio.com/items?itemName=pnp.polacode) - You know those fancy code screenshots you see in articles and tweets? Well, most likely they came from Polacode. It's super simple to use. Copy a piece of code to your clipboard, open up the extension, paste the code, and click to save your image!
- [Prettier](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode) - Format your code automatically on save.
- [Settings Sync](https://marketplace.visualstudio.com/items?itemName=Shan.code-settings-sync) - Settings Sync extension save your setting off in Github. Then, you can load them to any new version of VS Code with one command.

**[⬆ back to top](#table-of-contents)**

---

## Ferramentas

- [API Directory | ProgrammableWeb](https://www.programmableweb.com/apis/directory)
- [Better Code Hub](https://bettercodehub.com/repositories)
- [Browserling - Live interactive cross-browser testing](https://www.browserling.com/)
- [Can I use... Support tables for HTML5, CSS3, etc.](http://www.caniuse.com/) 👍
- [Checkbot - Browser extension that tests websites for SEO, speed and security issues](https://www.checkbot.io/)
- [Codepen](https://codepen.io/)
- [Create a new fiddle - JSFiddle](https://jsfiddle.net/)
- [Critical Path CSS Generator - by Jonas Ohlsson](https://jonassebastianohlsson.com/criticalpathcssgenerator/)
- [CrossBrowserTesting App](https://app.crossbrowsertesting.com/livetests/run)
- [CSS Triggers](https://csstriggers.com/) 👍
- [DirtyMarkup · Tidy up your HTML, CSS, and JavaScript code](https://dirtymarkup.com/) 👍
- [Favicon Generator](http://www.favicon-generator.org/)
- [Favicon Generator for iOS/Google Progressive Web App Manifest](https://realfavicongenerator.net/) 👍
- [Generate favicon based on text](https://favicon.io/) 👍
- [Google Analytics](https://analytics.google.com/)
- [Google APIs Explorer](https://developers.google.com/apis-explorer/#p/)
- [Javascript Console in Sublime Text](https://pawelgrzybek.com/javascript-console-in-sublime-text/)
- [jQuery mega cheat sheet](https://cdn.makeawebsitehub.com/wp-content/uploads/2015/09/jquery-mega-cheat-sheet-Printable.pdf)
- [JS Bin](http://jsbin.com/?html,output)
- [PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights/) 👍
- [Responsinator](http://www.responsinator.com/)
- [Responsive Grid System](http://www.responsivegridsystem.com/)
- [Sans Francisco - a tool for designers](http://www.sansfrancis.co/)
- [Sizzy:Browser Testing Tool](https://sizzy.co/)
- [Stack Overflow](https://stackoverflow.com/)
- [The W3C Markup Validation Service](http://validator.w3.org/#validate_by_input)
- [The W3C CSS Validation Service](http://jigsaw.w3.org/css-validator/#validate_by_input)
- [Web Developer Checklist](http://webdevchecklist.com/) 👍
- [Progressive Tooling to optimize your performance on Web](https://progressivetooling.com/)

**[⬆ back to top](#table-of-contents)**

---

## Frameworks de CSS

- [Bootstrap](http://getbootstrap.com/)
- [Bulma CSS](http://bulma.io/)
- [Caramel](http://caramel.ga/)
- [Cardinal](http://cardinalcss.com/)
- [Element CSS](http://element.eleme.io/#/en-US)
- [Flexbox Froggy](http://flexboxfroggy.com/)
- [Foundation CSS](http://foundation.zurb.com/)
- [Jeet](http://jeet.gs/)
- [Petal CSS](https://shakrmedia.github.io/petal/)
- [Pure CSS](https://purecss.io/)
- [Less](http://lessframework.com/)
- [Material Design Lite](https://getmdl.io/)
- [Materialize CSS](http://materializecss.com/)
- [Neat](https://neat.bourbon.io/)
- [Semantic UI](https://semantic-ui.com/)
- [Skeleton CSS](http://getskeleton.com/)
- [Tacit](https://github.com/yegor256/tacit)
- [TailwindCSS](https://tailwindcss.com/) 🔥🔥🔥
- [UI Kit](https://getuikit.com/)
- [Unsemantic](https://unsemantic.com/)
- [Vital CSS](https://vitalcss.com/components/)
- [Ant Design](https://ant.design/)

**[⬆ back to top](#table-of-contents)**

---

## Ícones

- [Brandicons](http://fontello.github.io/brandico.font/demo.html)
- [Flat Icon](https://www.flaticon.com/)
- [Font Awesome](http://fontawesome.io/) 👍
- [Glyphicon](http://www.webhostinghub.com/glyphs/)
- [Google Material Design Icons](http://google.github.io/material-design-icons/) 👍
- [Icomoon](https://icomoon.io/)
- [Icongram](https://icongr.am/)
- [Ionicons](http://ionicons.com/)
- [Mapicons](http://map-icons.com/)
- [Material Design Iconic Font](http://zavoloklom.github.io/material-design-iconic-font/)
- [MfgLabs-Iconset](http://mfglabs.github.io/mfglabs-iconset/)
- [Micon](http://xtoolkit.github.io/Micon/)
- [Octicons](https://octicons.github.com/)
- [Open Iconic, a free and open icon set](https://useiconic.com/open/)
- [OpenWebIcons](http://pfefferle.github.io/openwebicons/)
- [ReactIcons](https://github.com/react-icons/react-icons)
- [RemixIcon](https://github.com/Remix-Design/remixicon)
- [Stackicons](http://stackicons.com/)
- [Typicons](http://typicons.com/)
- [Weather Icons](https://erikflowers.github.io/weather-icons/)
- [Zocial | CSS3 Button Set](http://zocial.smcllns.com/)

**[⬆ back to top](#table-of-contents)**

---

## Cores

- [BADA55 Color Codes](http://bada55.io/)
- [Color Hunt](http://colorhunt.co/) - Open collections of beautiful color palettes
- [Color Theory by Natalya Shelburne](https://tallys.github.io/color-theory/) - Practical Color Theory for People who Code: Tutorial on the use of color with examples
- [Color wheel | Color schemes - Adobe Color CC](https://color.adobe.com/create/color-wheel/?base=2&rule=Analogous&selected=4&name=My%20Color%20Theme&mode=rgb&rgbvalues=0.050000000000000044,1,0.6943295865110486,0.13153196324950517,0.04550000000000004,0.91,1,0,0,0.91,0.6632375135840386,0.04550000000000004,0.2526315789473136,0.48,0.216140350877193&swatchOrder=0,1,2,3,4) - Interactive color wheel with different color rules (adjustments possible)
- [Coolors](https://coolors.co)👍 - Super fast color scheme creator with a lot of funcionalities
- [Data Color Picker](https://learnui.design/tools/data-color-picker.html) 👍
- [Designing in Color](https://medium.freecodecamp.com/designing-in-color-abd358660a7b) - A complete guide to design in color (article on Medium)
- [LOL Colors](https://www.webdesignrankings.com/resources/lolcolors/) - Curated color palette inspirations
- [Material Palette](https://www.materialpalette.com/) - Color palette generator for Material Design
- [Pigment Palette Generator](https://pigment.shapefactory.co/)
- [Palettable](http://www.palettable.io/ED3E75-383838-D4D4D4) - Interactive color picker: creates a color scheme based on your preferences and palettes on the Internet
- [Paletton - The Color Scheme Designer](http://paletton.com/#uid=1000u0kllllaFw0g0qFqFg0w0aF) - Advanced tool for creating color schemes
- [UI Gradients](https://uigradients.com/#Influenza) - Scroll through or pick from beautiful gradients, download JPG and copy CSS Code
- [All Gradient sites in one place](https://cssgradient.io/gradient-backgrounds/) 👍
- [Google, but for colors](https://picular.co/)
- [FLAT UI COLORS 2](https://flatuicolors.com/)

**[⬆ back to top](#table-of-contents)**

---

## Tipografia

- [A Crash Course in Typography: The Basics of Type](https://www.noupe.com/essentials/icons-fonts/a-crash-course-in-typography-the-basics-of-type.html) - First article of a series on Typography
- [Circular Font Combinations | Free Alternatives | Typewolf](https://www.typewolf.com/site-of-the-day/fonts/circular) - A great resource for everything related to Typography
- [Font Pair - Helps designers pair Google Fonts together. Beautiful Google Font combinations and pairs.](http://fontpair.co/) - Clean web-tool on How to pair Google Fonts
- [Fontspiration](http://sfcd.com/work/fontspiration/) - An iOS app for creating custom typographic designs
- [Fontsquirrel](https://www.fontsquirrel.com/) - A resource for FREE, hand-picked, high-quality, commercial-use fonts
- [Google Fonts](https://fonts.google.com/) 👍 - A catalog of free & open source fonts, great details and font pair suggestions
- [Just My Type](https://justmytype.co/) - A collection of font pairings
- [Table of Contents | The Elements of Typographic Style Applied to the Web](http://webtypography.net/toc/) - A practical guide to web typography
- [Typekit](https://typekit.com/) - "Quality fonts from the world’s best foundries"
- [Typography Terms](https://designschool.canva.com/blog/typography-terms/) - An infographic on Typography Terms + explanations

**[⬆ back to top](#table-of-contents)**

---

## Inspirações de Design

- [Admire The Web](https://www.admiretheweb.com/) - Admire the Web is where we showcase the very best in website design inspiration - carefully curated and organised to keep you inspired.
- [Site Inspire](https://www.siteinspire.com/) - siteInspire is a showcase of the finest web and interactive design.
- [Web design Inspiration](http://www.webdesign-inspiration.com/) - Find inspiration for your next web design project. We help web designers, digital agencies and entrepreneurs to be inspired. Everyday, our team of experts hand picks the best new web designs from all over the world.

**[⬆ back to top](#table-of-contents)**

---

## Frameworks de Animação

- [Animate CSS](https://daneden.github.io/animate.css/) - Choose, try out and get the CSS-Code for different animation types (over 70)
- [Bounce JS](http://bouncejs.com/) - Tool and JS Library, creating CSS3 powered animations(adjustments possible) & export CSS code
- [Magic Animations](https://www.minimamente.com/example/magic_animations/) - Showcase of different animations with link to GitHub repo
- [Partcles JS](https://vincentgarreau.com/particles.js/) 👍
- [Typed JS](http://www.mattboldt.com/typed.js/) - A JavaScript typing animation library with a great documentation on GitHub
- [Wow JS](http://mynameismatthieu.com/WOW/) - JavaScript library: Reveal CSS animation as you scroll down a page

**[⬆ back to top](#table-of-contents)**

---

## Coleção de Recursos

- [Free stock images and Videos](http://allthefreestock.com/) - A great collection of stock photos, videos and other resources. Most of them under the CC0-License, all of them free.
- [Gratisography](https://www.gratisography.com) - Photographer Ryan McGuire provides this collection of high-resolution pictures for free. You can use them on your personal or commercial project free of copyright restrictions.
- [I’d Pin That!](http://idpinthat.com) - Created to help bloggers and non-designers create high quality images like those often seen on Pinterest. I’d Pin That is more than just a source for free images — **it is an image editor!** Use the tools provided here to add your own text and edit the images right on the site.
- [MakerBook - The best free resources for creatives](http://makerbook.net/) - A directory of sites to get free resources (Photography, Mockups, Graphics, Textures, Fonts, Colours, Video, Audio & Tools).
- [Morguefile](https://morguefile.com/) - Founded in 1996 by college student Michael Connors.Photographers contribute images to Morguefile for visitors to use in their creative projects. Yes, they’re all completely free. The website does ask that you credit the photographer when possible.
- [Pexels](https://www.pexels.com/) - Exclusively stock photos of high quality, great feature: Filter photos by color.
- [Pixabay](https://pixabay.com/) - In addition to photos, Pixabay offers **video, vectors and illustrations.**
- [Public Domain Archive](http://publicdomainarchive.com/) - “a public domain image repository” created by Matt a graphic designer, web designer and photographer.Vintage and modern images.
- [The Stocks](http://thestocks.im) - Another awesome directory sharing sites for resources, loading directly on the webpage
- [The Open Photo Project](https://openphoto.net/) - The Open Photo Project is a photo sharing platform created in 1998 by Michael Jastremski. Contributors have offered their images free of charge under terms of Creative Commons licensing.
- [UnSplash](https://unsplash.com) 👍 - "Beautiful, Free Photos" & themed collections of photos
- [UnDraw](https://undraw.co) 👍 - "MIT licensed illustrations for every project you can imagine and create
- [storyset](https://storyset.com/) - Awesome free customizable illustrations for your next project
Customize, animate and download illustrations to make incredible landing pages, app or presentations!

**[⬆ back to top](#table-of-contents)**

---

## Geolocalização

- [Geocomplete-location autocomplete](https://ubilabs.github.io/geocomplete/) - An advanced jQuery plugin that wraps the Google Maps APIs Geocoding and Places Autocomplete services into a dropdown for an input-form.
- [Google maps API | Google](https://developers.google.com/maps/) - Google Map APIs including documentation & learning resources - extensive
- [Google maps API | Traversy](https://youtu.be/Zxf1mnP5zcw/) - Great TouTube tutorial on using the Google Maps APIs

**[⬆ back to top](#table-of-contents)**

---

## APIs

- [Alexa API | Codecademy](https://www.codecademy.com/learn/learn-alexa)
- [Random famous quotes | Mashape APIs](https://market.mashape.com/andruxnet/random-famous-quotes)
- [Web APIs | MDN](https://developer.mozilla.org/en/docs/Web/API)
- [A list of public APIs](https://github.com/toddmotto/public-apis)
- [RapidAPI, the world's largest API hub](https://rapidapi.com/hub)

**[⬆ back to top](#table-of-contents)**

---

## Maquetes

- [Am I Responsive](http://ami.responsivedesign.is/) - This is a tool to check the responsiveness of a website and take a screenshot on multiple devices in a single frame. Go to the site and enter the URL to capture the screenshot. You should have separate screen capture tool to take the proper screenshot.
- [Figma](https://www.figma.com/) 👍 - Free app with a simple to use surface for designing, prototyping and sharing your website and app ideas
- [Magic Mockups](http://magicmockups.com/) - Place your product in realistic environment! Free real-life product/app mockup generator. **Laptop, Phone, Tablet, Imac.**
- [MockupsJar](https://mockupsjar.com/) 👍 - Build mockups with screenshots of your application or web Design for free to share with customers and clients
- [MockUPhone](https://mockuphone.com) - Free and simple screenshots device mockups generator. Wrap your design in mobile devices or Laptop/Desktop in a few clicks!
- [Wireframe.cc](https://wireframe.cc/) - Great tool for sketching out ideas and layouts, super minimalistic
- [Multi Device Website Mockup Generator](http://techsini.com/multi-mockup/) - Multi device website mockup generator is free online tool to test your responsive website on apple devices including Apple iMac, MacBook, iPad and iPhone. This tool is very helpful for theme developers to mockup the web template on various apple devices with a single click. You should have a proper screen grabber tool to take the screenshot from the browser.
- [The MockUp Club](https://themockup.club/)

**[⬆ back to top](#table-of-contents)**

---

## Livros

- [HTML Basics](https://www.austincc.edu/hr/profdev/eworkshops/docs/HTML_Basics.pdf) - A workshop covering the bascis of HTML (free pdf/18 pages)
- [HTML Tutorialspoint](http://www.tutorialspoint.com/html/html_tutorial.pdf) - A thorough tutorial on HTML (free pdf/486 pages)
- [HTML5 Pocket Reference (Pocket Reference (O'Reilly)](http://www.amazon.com/gp/product/1449363350/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1449363350&linkCode=as2&tag=pinnok-20&linkId=M6JD2MFAN24X3E7W) - A comprehensive compact reference for HTML 5
- [HTML5 for Masterminds, 2nd Edition](https://www.amazon.com/gp/product/1500429120/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1500429120&linkCode=as2&tag=pinnok-20&linkId=IBCPBVE3TBPCOUWF) - A complete course from Beginner to Mastermind
- [Learn How To Code In HTML5 and CSS3](http://howtocodeinhtml.com/) - A free e-book about making websites in HTML5 and CSS for absolute beginners
- [Responsive Web Design with HTML5 and CSS3](http://www.amazon.com/gp/product/1784398934/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1784398934&linkCode=as2&tag=pinnok-20&linkId=6CN4JQGXTZU6DHRY) - A comprehensive book about making RWD
- [Ebook Foundation-free programing books: GitHub Repository](https://github.com/EbookFoundation/free-programming-books) A directory of free learning resources, categorized by language

**[⬆ back to top](#table-of-contents)**

---

## Desafios

- [CSS Diner](http://flukeout.github.io/) - It's a fun game to learn and practice CSS selectors.
- [CSS Zen Garden](http://www.csszengarden.com/) - A demonstration of what can be accomplished through CSS-based design, and a chance to do your own.
- [JavaScript30](https://javascript30.com/) - A free challenge course, building 30 little projects with HTML, CSS and plain JavaScript.

**[⬆ back to top](#table-of-contents)**

---

## Free Tools For Students Ferramentas Gratuitas para Estudantes

- [**Student Developer Pack**](https://education.github.com/pack): The best developer tools, free for students via @githubeducation

- [**JetBrains Student License**](https://www.jetbrains.com/student/): Free individual licenses of the award-winning professional developer tools from JetBrains for students and faculty members.

**[⬆ back to top](#table-of-contents)**

---

## Vídeos do YouTube

- [**SVGs can do that**](https://www.youtube.com/watch?&v=4laPOtTRteI) 😎
