<div align="center">
  <a href="https://github.com/RiptideNetworking/Riptide">
    <img src="https://riptide.tomweiland.net/images/logo.png" width="150px" height="auto">
  </a>
</div>
<div align="center"><a href="https://riptide.tomweiland.net">Docs</a>&emsp;<b>•</b>&emsp;<a href="https://discord.gg/tomweiland">Discord</a>&emsp;<b>•</b>&emsp;<a href="https://github.com/sponsors/tom-weiland">Donate</a></div>
<h1 align="center">Riptide Networking</h1>

Riptide Networking is a lightweight C# networking library primarily designed for use in multiplayer games. It can be used in Unity as well as in other .NET environments such as console applications.

It provides functionality for establishing connections and sending data back and forth, leaving it up to you to decide what data you want to send and when. This is ideal if you like to be in control of your code and know what's going on under the hood.

## Getting Started

Check out the documentation for [installation instructions](https://riptide.tomweiland.net/manual/overview/installation.html) and a [guide on setting up the basics](https://riptide.tomweiland.net/manual/overview/get-started.html).

For a video tutorial on how to set up Riptide (using v1.1.0) in your project, see [this video](https://youtu.be/6kWNZOFcFQw). You can use the [upgrade guides](https://riptide.tomweiland.net/manual/updates/guides/update-to-v2.html) to update your project to newer versions afterwards.

## Low-Level Transports

- [UDP Transport](RiptideNetworking/RiptideNetworking/Transports/Udp) (built-in)
- [TCP Transport](RiptideNetworking/RiptideNetworking/Transports/Tcp) (built-in)
- [Steam Transport](https://github.com/RiptideNetworking/SteamTransport)

## Implementations in Other Languages

The following is a list of Riptide implementations in other programming languages. These ports are managed and maintained separately and independently by their respective owners, and are not affiliated with Riptide in any official capacity. As such, they may not function interchangeably with all versions of Riptide or with each other.

However, if you need to use Riptide with/in a language other than C# on one end, these implementations may provide a starting point:

- Python: [Pytide](https://github.com/ebosseck/PytideNetworking/tree/main)
- Dart/Flutter: [Riptide Dart Port](https://github.com/JayKay135/Riptide-Dart-Port)

## Contributions

Community bug reports, feature requests, and pull requests are welcome and appreciated, but please read the [contribution guidelines](CONTRIBUTING.md) before submitting one 🙂

## Donate

Riptide is 100% free to use, but if you'd like to financially support Riptide's development you can do so through [GitHub Sponsors](https://github.com/sponsors/tom-weiland).

## License

Distributed under the MIT license. See [LICENSE.md](LICENSE.md) for more information.
