---
_description: Release notes for Riptide v2.1.0.
---

# v2.1.0 Release Notes

Install this version with Unity's Package Manager using the following URL ([step-by-step instructions](~/manual/overview/installation.md#option-1-unity-package-manager)):
```plaintext
https://github.com/RiptideNetworking/Riptide.git?path=/Packages/Core#2.1.0
```

It can also be installed a number of [other ways](~/manual/overview/installation.md#net-projects) for use outside of Unity, including as a [NuGet package](https://www.nuget.org/packages/RiptideNetworking.Riptide).

For a full list of source code changes, check out the [version comparison](https://github.com/RiptideNetworking/Riptide/compare/v2.0.0...v2.1.0) on GitHub.

## Additions

- Added the ["notify" message send mode](~/manual/guides/send-modes-explained.md#notify-send-mode) and overhauled message sequencing ([PR #109](https://github.com/RiptideNetworking/Riptide/pull/109)).
- Added support for reserving (when writing) and skipping (when reading) bits in a message via <code><xref:Riptide.Message.ReserveBits*></code> and <code><xref:Riptide.Message.SkipBits*></code>, respectively ([#103](https://github.com/RiptideNetworking/Riptide/issues/103)).
- Added support for setting and retrieving specific ranges of bits in a message, regardless of its internal write and read positions via <code><xref:Riptide.Message.SetBits*></code> and <code><xref:Riptide.Message.PeekBits*></code>, respectively. Use these with care, as accidentally setting or peeking bits in an incorrect range or at an incorrect position will scramble your data.
- Added support for adding bits to a message via <code><xref:Riptide.Message.AddBits*></code>.
- Added support for adding data to a message directly from another existing message via <code><xref:Riptide.Message.AddMessage*></code>.
- Added support for adding values to a message using a variable amount of bits (based on how large the value is) via <code><xref:Riptide.Message.AddVarLong*></code>/<code><xref:Riptide.Message.AddVarULong*></code>.
- Added an option to disable the <code>[<xref:Riptide.MessageHandlerAttribute?text=MessageHandler>]</code> attribute-based message handler system via the `useMessageHandlers` parameter in the <code><xref:Riptide.Server.Start*?displayProperty=nameWithType></code> & <code><xref:Riptide.Client.Connect*?displayProperty=nameWithType></code> methods. This is useful if you prefer to handle messages via the <code><xref:Riptide.Server.MessageReceived?displayProperty=nameWithType></code> & <code><xref:Riptide.Client.MessageReceived?displayProperty=nameWithType></code> events.
- Added an option to set timeout time per <code><xref:Riptide.Connection></code>.
- Added an option to specify the IP address that <code><xref:Riptide.Transports.Udp.UdpServer></code> and <code><xref:Riptide.Transports.Tcp.TcpServer></code> should listen on ([#26](https://github.com/RiptideNetworking/Riptide/issues/26) and [#79](https://github.com/RiptideNetworking/Riptide/issues/79)).
- Added the <code><xref:Riptide.Connection.ReliableDelivered?displayProperty=nameWithType></code> event for when a reliably sent message is successfully delivered ([#42](https://github.com/RiptideNetworking/Riptide/pull/42)).
- Added bandwidth-related <code><xref:Riptide.Connection.Metrics?displayProperty=nameWithType></code> ([#77](https://github.com/RiptideNetworking/Riptide/issues/77)).
- Added <code><xref:Riptide.ConnectionFailedEventArgs.Reason></code> to <code><xref:Riptide.ConnectionFailedEventArgs></code>.
- Added the <code><xref:Riptide.Server.ConnectionFailed?displayProperty=nameWithType></code> event for when a pending connection fails ([#104](https://github.com/RiptideNetworking/Riptide/issues/104)).
- Added error logs for when the incorrect <code><xref:Riptide.Message.Create*></code> overload is used ([#113](https://github.com/RiptideNetworking/Riptide/pull/113)).

## Changes

- Made the <code><xref:Riptide.Message></code> class operate on the bit-level instead of the byte-level. This allowed for a slightly reduced message header size and gives you more control over how much data you're sending ([PR #121](https://github.com/RiptideNetworking/Riptide/pull/121)).
- Made poor connection quality trigger disconnections. This can be finely controlled via the `Connection` class's <code><xref:Riptide.Connection.MaxAvgSendAttempts></code>, <code><xref:Riptide.Connection.AvgSendAttemptsResilience></code>, <code><xref:Riptide.Connection.MaxSendAttempts></code>, <code><xref:Riptide.Connection.MaxNotifyLoss></code>, and <code><xref:Riptide.Connection.NotifyLossResilience></code> fields, or disabled entirely by setting <code><xref:Riptide.Connection.CanQualityDisconnect></code> to `false`.
- Deprecated the `Message` class's `ReadLength`, `UnreadLength`, and `WrittenLength` properties. Use <code><xref:Riptide.Message.ReadBits></code>, <code><xref:Riptide.Message.UnreadBits></code>, and <code><xref:Riptide.Message.WrittenBits></code> instead.
- Changed <code><xref:Riptide.Message.MaxPayloadSize?displayProperty=nameWithType></code> setter's error logs to exceptions.
- Disabled Nagle's algorithm in the TCP transport.
- Removed the unnecessary 65 second limit on <code><xref:Riptide.Connection.TimeoutTime?displayProperty=nameWithType></code> and <code><xref:Riptide.Peer.HeartbeatInterval?displayProperty=nameWithType></code>.
- Made <code><xref:Riptide.Utils.PriorityQueue`2></code> publicly accessible and removed its internal use of <code><xref:System.Collections.Generic.List`1></code>.
- Removed the unnecessary `AckExtra` <code><xref:Riptide.Transports.MessageHeader></code> type.
- Stopped using <code><xref:System.DateTime></code> for calculating timeouts.
- Updated DocFX to v2.70.1.

## Fixes

- Fixed improper duplicate filtering which allowed duplicates to be handled under certain circumstances ([PR #109](https://github.com/RiptideNetworking/Riptide/pull/109)).
- Fixed unintended processing of subsequent connection attempts from connections that had already been rejected.
- Fixed incorrect processing of new acks for reliable messages.
- Fixed incorrect transport data buffer sizes.
- Fixed incorrect values that were used in some of the `Message` class's error messages.
- Fixed the size of `PendingMessage`s not being changed along with `Message.MaxPayloadSize`.
- Fixed incorrect "unknown reason" rejection log when an already-connected connection was rejected ([#84](https://github.com/RiptideNetworking/Riptide/issues/84)).
- Fixed errors that occurred when various <code><xref:Riptide.Server></code> properties were accessed before the first player connected ([#86](https://github.com/RiptideNetworking/Riptide/issues/86)).
- Fixed the TCP transport's improper handling of large packets ([#92](https://github.com/RiptideNetworking/Riptide/issues/92)).
- Fixed unhandled <code><xref:System.Net.Sockets.SocketException></code>s when sending data, such as the one that occurred when a <code><xref:Riptide.Client></code> with no internet connection attempted to connect ([#102](https://github.com/RiptideNetworking/Riptide/pull/102)).
- Fixed unintended timeout when a `Client` would disconnect and reconnect again in quick succession ([#105](https://github.com/RiptideNetworking/Riptide/issues/105)).
- Fixed an infinite loop when a `Server` was started with a `maxClientCount` of 65,535 ([#111](https://github.com/RiptideNetworking/Riptide/issues/111)).
- Fixed an issue with the TCP transport that caused connections to be rejected shortly after they were accepted and fully connected (similar to [SteamTransport#1](https://github.com/RiptideNetworking/SteamTransport/issues/1)).

## Sponsor Shoutout

Thank you so much to all of my [GitHub Sponsors](https://github.com/sponsors/tom-weiland) for helping to make this update possible by financially supporting the project!
