---
_description: Release notes for Riptide v2.0.0.
---

# v2.0.0 Release Notes

Install this version with Unity's Package Manager using the following URL ([step-by-step instructions](~/manual/overview/installation.md#option-1-unity-package-manager)):
```plaintext
https://github.com/RiptideNetworking/Riptide.git?path=/Packages/Core#2.0.0
```

It can also be installed a number of [other ways](~/manual/overview/installation.md#net-projects) for use outside of Unity, including as a [NuGet package](https://www.nuget.org/packages/RiptideNetworking.Riptide).

For a full list of source code changes, check out the [version comparison](https://github.com/RiptideNetworking/Riptide/compare/v1.2.0...v2.0.0) on GitHub.

## Additions

- Added a documentation site.
- Made a [NuGet package](https://www.nuget.org/packages/RiptideNetworking.Riptide) ([#12](https://github.com/RiptideNetworking/Riptide/issues/12)).
- Made it possible to accept or reject connections by setting <code><xref:Riptide.Server.HandleConnection?displayProperty=nameWithType></code>.
- Made it possible to send custom data when kicking a client ([#20](https://github.com/RiptideNetworking/Riptide/issues/20)).
- Made it possible to retrieve connected clients by their ID using <code><xref:Riptide.Server.TryGetClient*?displayProperty=nameWithType></code>.
- Added disconnect reasons.
- Added support for adding `sbyte`s to messages.
- Added support for adding custom types to the messages class, as long as they implement <code><xref:Riptide.IMessageSerializable></code>.
- Added an option to disable the timeout system for individual connections using <code><xref:Riptide.Connection.CanTimeout?displayProperty=nameWithType></code>.
- Made it possible to change the maximum message payload size using <code><xref:Riptide.Message.MaxPayloadSize?displayProperty=nameWithType></code>.
- Added an option to disable dual-mode sockets for the UDP transport.
- Made the default transport's socket buffer size configurable.
- Added a [TCP transport](xref:Riptide.Transports.Tcp) (primarily for use as a fallback in situations where UDP doesn't work).

## Changes

- Renamed a lot of things (including the base `RiptideNetworking` namespace—now it's just <code><xref:Riptide></code>). For a full list of what was renamed, see the [updating to v2 guide](~/manual/updates/guides/update-to-v2.md#renames-and-replacements).
- Made calling <code><xref:Riptide.Client.Disconnect*?displayProperty=nameWithType></code> invoke the <code><xref:Riptide.Client.Disconnected?displayProperty=nameWithType></code> event. Previously, this event was only invoked when the disconnection was not initiated by the client.
- Removed the `isBigArray` parameter from the <code><xref:Riptide.Message></code> class's `Add`/`Get` methods. This is now determined automatically.
- Reduced the default maximum message payload size to 1225 bytes (from 1247 bytes) to ensure messages are smaller than the [MTU](https://en.wikipedia.org/wiki/Maximum_transmission_unit).
- Made <code><xref:Riptide.Client.Connect*?displayProperty=nameWithType></code> return a `bool` to indicate whether a connection attempt will be made or an issue occurred ([#39](https://github.com/RiptideNetworking/Riptide/issues/39)).
- Completely overhauled the transport system (which resulted in the removal of the `RudpListener`, `RudpServer`, `RudpClient`, and `RudpConnection` classes). For more information on the transport rework and all of the changes involved, see [pull request #56](https://github.com/RiptideNetworking/Riptide/pull/56).
- Made the default transport single-threaded, as the multithreading didn't provide much benefit but caused difficult-to-debug issues.
- Improved error handling.
- Made error messages more descriptive.
- Gave servers authority over which messages are automatically relayed. This is customizable via <code><xref:Riptide.Server.RelayFilter?displayProperty=nameWithType></code>.
- Removed customizable maximum send attempts for messages. In a future update, this system will be replaced by a system which disconnects clients if their connection health deteriorates too much.
- Removed `LanDiscovery` class. It will be overhauled and re-added in a future update.
- Removed unused `DoubleKeyDictionary` class.
- Removed unused `ActionQueue` class.
- Removed unnecessary custom type size constants.
- Made event args' properties readonly fields.

## Fixes

- Fixed some message handler methods not being found ([#44](https://github.com/RiptideNetworking/Riptide/issues/44)).

## Sponsor Shoutout

Thank you so much to all of my GitHub Sponsors for making this update possible, and an extra special thank you to the following individuals for their extreme generosity:

- [oalpar](https://github.com/oalpar)
- those who wish to remain anonymous (you know who you are!)

If you too would like to financially support Riptide's development and get access to various perks, you can do so through [GitHub Sponsors](https://github.com/sponsors/tom-weiland). Thank you!
