// SDD64 license verifier

#include <windows.h>
#include <stdio.h>

#include "public_key.h"

UINT64 f_evaluate(UINT64 x)
{
    UINT64 y = 0;

    INT cursor = 0;

    for(INT i=0; i<64; ++i)
        for(INT j=i; j<64; ++j)
        {
            if( (x & ((UINT64)1<<i)) &&
                (x & ((UINT64)1<<j))
            )
            {
                y ^= lsvec_obf[cursor];
            }

            cursor++;
        }

    return y;
}

INT verify_parity(UINT64 x)
{
   UINT64 sig = x & 0xFFFFF;
   UINT64 parity = (x & 0xFFFFFFFFFFF00000) >> 20;
   UINT64 result = 0;

   for(int i=0; i<20; ++i)
       if(sig & ((UINT64)1 << i))
           result ^= (parity << i);

   for(int i=0; i<24; i++)
       if(result & ((UINT64)1 << (63-i)))
           result ^= (0xBD36E46C30800000 >> i);

   return result == 1;
}

INT main(INT ac, PCHAR *av)
{
    if(ac<2)
        return -1;

    // decode argument
    //
    UINT64 x=0;

    PCHAR hex_string = av[1];

    UCHAR lookup[256];
    for(CHAR i='0'; i<='9'; ++i)
        lookup[i] = i-'0';
    for(CHAR i='A'; i<='G'; ++i)
        lookup[i] = i-'A'+10;

    while(*hex_string)
    {
        x <<= 4;
        x |= lookup[*hex_string++];
    }

    printf("input license ID: %016I64X\n", x);

    // encrypt (evaluate the function)
    //
    UINT64 y = f_evaluate(x);
    printf("decoded: %016I64X\n", y);

    // verify parity
    //
    if(verify_parity(y))
    {
        if((y & 0xFFFFF) > 30) // low 20 bits are the id of the key
            printf("accepted license ID %d!", y & 0xFFFFF);
        else
            printf("blacklisted license ID %d!", y & 0xFFFFF);
    }
    else
        printf("rejected!");

    return 0;
}
