//#define DEBUG
//#define DEBUG_INFO
#define FUN_SIZE 16 
#define FUN_KEY 0x66
#define KEY_LEN 48
#include <cstdio>
#include <cstring>
#include "vm.cpp"

unsigned char VM_CODE[] =
{
  0xDE, 0xAD, 0xC0, 0xDE,   //magic code
  FUN, 0x2E, 0x27, 0x25, 0x2D, 0x39, 0x32, 0x2E, 0x23, 0x39, 0x36, 0x2a, 0x27, 0x28, 0x23, 0x32, 
  PUSHD,  0x00, 0x00, 0x00, 0x2f,   //key len
  LOOP,   0x05,
  POP,    0x30,

  MOVD,   0x00,   //loop begin
  XOR,    0x22,
  CMP,    0x02,
  JZ,     0x33,
  INCD,
  PUSHD,  0x00, 0x00, 0x00, 0x46,
  POP,    0x10,
  CMP,    0x01,
  JG,     0x27,   //error             x<0x46
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x10,
  CMP,    0x01,
  JL,     0x16,   //error             x>0x30
  PUSHD,  0x00, 0x00, 0x00, 0x39,
  POP,    0x10,
  CMP,    0x01,
  JL,     0x0b,   //loop              x<0x39
  PUSHD,  0x00, 0x00, 0x00, 0x41,
  POP,    0x01,
  CMP,    0x01,
  JL,     0x06,   //error             x<0x41
  XOR,    0x00,   //jmp to loop
  CMP,    0x00,
  JZ,     0x05,
  XOR,    0x00,   //error
  INC,    0x00,
  END,
  LOOP,   0x40,   //loop end

  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x30,
  XOR,    0x11,

  DECD,
  MOVD,   0x00,
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x0a,
  POP,    0x20,
  CMP,    0x02,
  JL,     0x09,
  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x10,
  POP,    0x20,
  MUL,    0x12,
  ADD,    0x10,
  LOOP,   0x2b,

  PUSHD,  0xf3, 0x37, 0x46, 0xe6,   //6e64733f
  POP,    0x20,
  CMP,    0x12,
  XOR,    0x00,
  JZ,     0x03,
  INC,    0x00,
  END,

  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x30,
  XOR,    0x11,

  DECD,
  MOVD,   0x00,
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x0a,
  POP,    0x20,
  CMP,    0x02,
  JL,     0x09,
  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x10,
  POP,    0x20,
  MUL,    0x12,
  ADD,    0x10,
  LOOP,   0x2b,

  PUSHD,  0x54, 0x96, 0x27, 0x66,   //66726945
  POP,    0x20,
  CMP,    0x12,
  XOR,    0x00,
  JZ,     0x03,
  INC,    0x00,
  END,

  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x30,
  XOR,    0x11,

  DECD,
  MOVD,   0x00,
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x0a,
  POP,    0x20,
  CMP,    0x02,
  JL,     0x09,
  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x10,
  POP,    0x20,
  MUL,    0x12,
  ADD,    0x10,
  LOOP,   0x2b,

  DEC,    0x10,
  PUSHD,  0x02, 0x54, 0x26, 0x01,   //20624520
  POP,    0x20,
  CMP,    0x12,
  XOR,    0x00,
  JZ,     0x03,
  INC,    0x00,
  END,

  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x30,
  XOR,    0x11,

  DECD,
  MOVD,   0x00,
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x0a,
  POP,    0x20,
  CMP,    0x02,
  JL,     0x09,
  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x10,
  POP,    0x20,
  MUL,    0x12,
  ADD,    0x10,
  LOOP,   0x2b,

  INC,    0x10,
  PUSHD,  0x54, 0x77, 0x02, 0xe7,   //6e207745
  POP,    0x20,
  CMP,    0x12,
  XOR,    0x00,
  JZ,     0x03,
  INC,    0x00,
  END,

  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x30,
  XOR,    0x11,

  DECD,
  MOVD,   0x00,
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x0a,
  POP,    0x20,
  CMP,    0x02,
  JL,     0x09,
  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x10,
  POP,    0x20,
  MUL,    0x12,
  ADD,    0x10,
  LOOP,   0x2b,

  PUSHD,  0x16, 0x36, 0xc2, 0xf6,   //6f2c6361
  POP,    0x20,
  CMP,    0x12,
  XOR,    0x00,
  JZ,     0x03,
  INC,    0x00,
  END,

  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x30,
  XOR,    0x11,

  DECD,
  MOVD,   0x00,
  PUSHD,  0x00, 0x00, 0x00, 0x30,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x0a,
  POP,    0x20,
  CMP,    0x02,
  JL,     0x09,
  PUSHD,  0x00, 0x00, 0x00, 0x07,
  POP,    0x20,
  SUB,    0x02,
  PUSHD,  0x00, 0x00, 0x00, 0x10,
  POP,    0x20,
  MUL,    0x12,
  ADD,    0x10,
  LOOP,   0x2b,

  PUSHD,  0x16, 0x86, 0x57, 0x47,   //74756861
  POP,    0x20,
  CMP,    0x12,
  XOR,    0x00,
  JZ,     0x02,
  INC,    0x00,
  END,
};

int main(int argc, char *argv[]) {
  if (argc < 2) {
    printf("Hello World!\n");
    return 0;
  }
  if (strlen(argv[1]) > KEY_LEN) {
    return 0;
  }
  VM *vm = new VM;
  REG *x = new REG;
  unsigned char *y = new unsigned char[D_SIZE];
  unsigned int *s = new unsigned int[S_SIZE];
  
  memcpy(y, argv[1], 50);
  x->db = y;
  x->bp = s;
  x->ip = VM_CODE;
  vm->vm_init(x);
  vm->vm_run();
  vm->vm_out(x);
  if (x->r0 == 0) {
    printf("Nice!!! U got it!\n");
  }
  delete [] s;
  delete [] y;
  delete x;
  delete vm;
  return 0;
}
