#include <miracl.h> 
#include "md5c.c"

int CheckLicense( char * lpName, char * license )
{
    int status;
    unsigned char szHash[41] = {0};
    MD5_CTX context;
    
    miracl *mip=mirsys(500,16);  /* base 0, 50 digits par big  */
    big M        =mirvar(0);
    big Hash_M   =mirvar(0);    
    big N        =mirvar(0);
    big E        =mirvar(0);

    mip->IOBASE=16;
    cinstr(N,"7D4C538A3766CA67C73534105AB812817E0E3C5F1CC3853136AAC8279D501EB51572226C060D420A70331348B6E0F1974DFB969B7BE30E31F8128EAF3A0CBE4D5C134528AD61E707AC3E6233BF5755DA4FDB63E48AC053A00D227C3A9B031FC282157CB3071ECA94013140ABC1F886DE9EBF6ED1C39965ECF46846BF74BFC681");
    cinstr(E,"44D7A0FD047CA62C70DF9C4E4B77D22CDC7A07FF325E4302CAC6EC7F79321E325338EDFCB86F56F8E67D5458559446F9840F69E220326AA75FFDF60679B1A7E1EF8ABBC3DC873B3C19ED7C0A59667AF746E4877907AB2FF9C85BBFEAF3AF8013676E05EA735EDF6AE8D5FE8B130D7B805CC28844B921C3100FA7282DA359DBA7");
    cinstr(M,license);  
      

    MD5Init(&context);
    MD5Update(&context, lpName, strlen(lpName));
    MD5Final(szHash, &context);
    bytes_to_big(16,szHash,Hash_M);  
     
    powmod(M,E,N,M);
    status = compare(M,Hash_M);
    
    mirkill(M);
    mirkill(Hash_M);
    mirkill(N);
    mirkill(E);
    mirexit();
    return status;
}


