
;               Knapsack encoder
;               Compile using FASM (www.flatassembler.net)

format PE GUI 4.0
entry start

include '%fasminc%\win32a.inc'

ID_OK		   = 101
ID_CANCEL	   = 102
ID_NAME 	   = 201
ID_SERIAL	   = 202

section '.data' data readable writeable

public_array	file	'public.dat'
hextable	db	"0123456789ABCDEF"
str_error	db	"Errornous input.",0

plaintext	rb	8*2+2
ciphertext	rb	16*2+1
plaintextbin	rb	8
ciphertextbin	rb	16

section '.code' code readable executable

start:		invoke	GetModuleHandle,0
		invoke	DialogBoxParam,eax,37,HWND_DESKTOP,dialogproc,0
		invoke	ExitProcess,0

;               Simple dialog proc

dialogproc:	pushad
		mov	ebp, [esp+4*8+4+4*0]
		mov	eax, [esp+4*8+4+4*1]
		cmp	eax,WM_COMMAND
		je	wmcommand
		cmp	eax,WM_CLOSE
		jnz	finish
wmclose:	invoke	EndDialog,ebp,0
finish: 	popad
		xor	eax, eax
		ret	4*4

;               Process command messages

wmcommand:	mov	eax, [esp+4*8+4+4*2]
		cmp	eax,BN_CLICKED shl 16 + ID_OK
		jne	finish
		invoke	GetDlgItemText,ebp,ID_NAME,plaintext+1,8*2
		mov	esi, plaintext+1
		cmp	byte [esi], 0
		jz	errornous_input

;               Convert inputted number to binary

.startplain:	inc	esi
		cmp	byte [esi], 0
		jnz	.startplain
		dec	esi
		mov	edi, plaintextbin+7
.loopconvert:	mov	al, [esi]
		or	al, al
		jz	.2bindone
		call	convert
		dec	esi
		mov	ah, al
		mov	al, [esi]
		or	al, al
		jz	.2binpredone
		call	convert
		shl	al, 4
		or	ah, al
		mov	byte [edi], ah
		dec	esi
		dec	edi
		jmp	.loopconvert
.2binpredone:	mov	byte [edi], ah
.2bindone:

;               Main encoding routine

calcencode:	mov	edx, public_array
		mov	ecx, 64
		and	dword [ciphertextbin+12], 0		; Clear ciphertext
		and	dword [ciphertextbin+8], 0
		and	dword [ciphertextbin+4], 0
		and	dword [ciphertextbin+0], 0
.loop:		shr	dword [plaintextbin], 1
		rcr	dword [plaintextbin+4], 1		; If bit is set
		jnc	.skip
		mov	eax, [edx+8]				; add "special number"
		add	dword [ciphertextbin],eax		; to the encoded sum.
		mov	eax, [edx+4]
		adc	dword [ciphertextbin+4], eax
		mov	eax, [edx]
		adc	dword [ciphertextbin+8], eax
		adc	dword [ciphertextbin+12], 0
.skip:		add	edx, 12
		loop	.loop

;               Convert encoded back to ascii

convertencode:	mov	edi, ciphertext+16*2-1
		mov	esi, ciphertextbin
		xor	eax, eax
		mov	ecx, 16
.loop:		mov	al, [esi]
		and	al, 0fh
		mov	al, [hextable+eax]
		mov	byte [edi], al
		dec	edi
		mov	al, [esi]
		shr	al, 4
		mov	al, [hextable+eax]
		mov	byte [edi], al
		inc	esi
		dec	edi
		loop	.loop
		inc	edi
setdlg: 	invoke	SetDlgItemText,ebp,ID_SERIAL,edi
		jmp	finish

;               Convert binary to ascii number

convert:	mov	al, [esi]
		cmp	al, "0"
		jb	errornous_input2
		cmp	al, "9"
		jbe	.num2bin
		or	al, 20h
		cmp	al, "a"
		jb	errornous_input2
		cmp	al, "f"
		ja	errornous_input2
		sub	al, "a"-10
		jmp	.converted
.num2bin:	sub	al, "0"
.converted:	ret

;               Handle errornous input

errornous_input2:add	esp, 4
errornous_input:mov	edi, str_error
		jmp	setdlg

section '.idata' import data readable writeable

  library kernel,'KERNEL32.DLL',\
	  user,'USER32.DLL'

  import kernel,\
	 GetModuleHandle,'GetModuleHandleA',\
	 ExitProcess,'ExitProcess'

  import user,\
	 DialogBoxParam,'DialogBoxParamA',\
	 GetDlgItemText,'GetDlgItemTextA',\
	 SetDlgItemText,'SetDlgItemTextA',\
	 EndDialog,'EndDialog'

section '.rsrc' resource data readable

  directory RT_DIALOG,dialogs

  resource dialogs,\
	   37,LANG_ENGLISH+SUBLANG_DEFAULT,demonstration

  dialog demonstration,'Knapsack encoder',70,70,230,85,WS_CAPTION+WS_POPUP+WS_SYSMENU+DS_MODALFRAME or 2048

    dialogitem 'BUTTON','Number encoding form (hexadecimal)',-1,10,10,210,50,WS_VISIBLE+BS_GROUPBOX
    dialogitem 'STATIC','&Number:',-1,15,23,30,8,WS_VISIBLE
    dialogitem 'EDIT','',ID_NAME,50,20,160,13,WS_VISIBLE+WS_BORDER+WS_TABSTOP
    dialogitem 'STATIC','&Encoding:',-1,15,43,70,8,WS_VISIBLE
    dialogitem 'EDIT','',ID_SERIAL,50,40,160,13,WS_VISIBLE+WS_BORDER+WS_TABSTOP+ES_AUTOHSCROLL+ES_READONLY
    dialogitem 'BUTTON','Encode!',ID_OK,10,65,45,15,WS_VISIBLE+WS_TABSTOP+BS_DEFPUSHBUTTON
  enddialog

