#define _WIN32_WINNT 0x0502
#include <windows.h>
#include "res_dialog.h"

BYTE colors_scroll[3] = {153,188,226};
BYTE colors_edits[3] = {153,188,226};

WCHAR strCrackmeInfo[] = L"<DECODING TRANSMISSION>\n"
                        L"\n"
                        L"Shmoocon 2010\n"
                    L"Crypto Challenge #4\n"
                    L"\"A taste of post-quantum!\"\n"
                    L"\n"
                    L"Difficulty: 7/9\n"
                    L"\n"
                    L"Example keys:\n" 
L"    Batou 000000BA8C4BEDDC\n"
L"   Togusa 000000C02A4CC4D2\n"
L"  Aramaki 000000BB4F2C2A7C\n"
L" Kusanagi 000000F076A4999F\n"
                        L"\n"
                        L"<END OF TRANSMISSION>";


BOOL VerifySerial(UINT64 name, UINT64 serial)
{
    CHAR x[40];
    CHAR y[40];
    memset(y, 0, 40*sizeof(CHAR));

    name ^= 0xDEADBEEFCAFEBABE;

    // save top 40 bits of name
    name >>= 24;

    // top 24 bits must be 0 (only bottom 40 matter)
    if(serial & 0xFFFFFF0000000000)
        return 0;

    // convert input to bits
    for(INT i=0; i<40; ++i)
        x[i] = !!(serial & ((UINT64)1<<i));

    // :)
y[0] = 0^(x[0]&x[0])^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[18])^(x[0]&x[19])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[38])^(x[1]&x[5])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[16])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[10])^(x[4]&x[12])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[34])^(x[4]&x[36])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[33])^(x[5]&x[38])^(x[6]&x[6])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[13])^(x[6]&x[19])^(x[6]&x[21])^(x[6]&x[24])^(x[6]&x[29])^(x[6]&x[31])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[22])^(x[7]&x[24])^(x[7]&x[25])^(x[7]&x[29])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[37])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[26])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[33])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[38])^(x[9]&x[11])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[39])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[27])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[38])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[23])^(x[11]&x[25])^(x[11]&x[26])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[37])^(x[13]&x[38])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[20])^(x[14]&x[21])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[37])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[26])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[23])^(x[16]&x[26])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[23])^(x[17]&x[26])^(x[17]&x[28])^(x[17]&x[29])^(x[17]&x[31])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[23])^(x[18]&x[26])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[35])^(x[18]&x[36])^(x[18]&x[37])^(x[19]&x[19])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[36])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[34])^(x[20]&x[36])^(x[21]&x[21])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[36])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[29])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[38])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[29])^(x[23]&x[32])^(x[23]&x[34])^(x[23]&x[36])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[29])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[35])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[26])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[31])^(x[26]&x[34])^(x[26]&x[36])^(x[26]&x[39])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[32])^(x[27]&x[37])^(x[28]&x[28])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[34])^(x[28]&x[36])^(x[28]&x[37])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[34])^(x[29]&x[36])^(x[29]&x[37])^(x[30]&x[30])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[37])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[36])^(x[34]&x[34])^(x[34]&x[36])^(x[34]&x[39])^(x[35]&x[37])^(x[35]&x[39])^(x[36]&x[37])^(x[37]&x[39])^(x[38]&x[38])^(x[38]&x[39]);
y[1] = 0^(x[0]&x[2])^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[6])^(x[0]&x[10])^(x[0]&x[12])^(x[0]&x[15])^(x[0]&x[20])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[30])^(x[0]&x[37])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[4])^(x[1]&x[5])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[13])^(x[1]&x[15])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[27])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[9])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[5])^(x[3]&x[8])^(x[3]&x[10])^(x[3]&x[14])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[22])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[32])^(x[3]&x[37])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[10])^(x[4]&x[12])^(x[4]&x[14])^(x[4]&x[18])^(x[4]&x[23])^(x[4]&x[27])^(x[4]&x[29])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[35])^(x[4]&x[37])^(x[4]&x[39])^(x[5]&x[6])^(x[5]&x[9])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[27])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[6])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[21])^(x[6]&x[24])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[33])^(x[6]&x[36])^(x[6]&x[38])^(x[7]&x[9])^(x[7]&x[11])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[25])^(x[7]&x[27])^(x[7]&x[29])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[38])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[33])^(x[8]&x[34])^(x[8]&x[37])^(x[8]&x[38])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[18])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[11])^(x[10]&x[13])^(x[10]&x[17])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[31])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[11]&x[13])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[21])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[27])^(x[11]&x[30])^(x[11]&x[32])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[12]&x[12])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[19])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[26])^(x[12]&x[28])^(x[12]&x[31])^(x[12]&x[33])^(x[12]&x[34])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[37])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[24])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[36])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[26])^(x[16]&x[32])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[38])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[20])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[35])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[26])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[33])^(x[18]&x[36])^(x[18]&x[37])^(x[18]&x[38])^(x[19]&x[20])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[26])^(x[19]&x[28])^(x[19]&x[34])^(x[19]&x[36])^(x[19]&x[37])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[26])^(x[20]&x[28])^(x[20]&x[31])^(x[20]&x[33])^(x[20]&x[38])^(x[21]&x[21])^(x[21]&x[24])^(x[21]&x[26])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[37])^(x[21]&x[39])^(x[22]&x[25])^(x[22]&x[33])^(x[22]&x[37])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[34])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[29])^(x[24]&x[32])^(x[24]&x[34])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[37])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[38])^(x[27]&x[27])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[35])^(x[27]&x[39])^(x[28]&x[35])^(x[28]&x[37])^(x[28]&x[38])^(x[29]&x[29])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[38])^(x[31]&x[32])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[37])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[35])^(x[32]&x[38])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[36])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[2] = 0^(x[0]&x[2])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[18])^(x[0]&x[21])^(x[0]&x[24])^(x[0]&x[27])^(x[0]&x[30])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[37])^(x[1]&x[1])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[21])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[31])^(x[1]&x[34])^(x[1]&x[37])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[15])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[25])^(x[2]&x[26])^(x[2]&x[29])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[35])^(x[2]&x[38])^(x[3]&x[4])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[17])^(x[4]&x[19])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[33])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[11])^(x[5]&x[15])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[23])^(x[5]&x[28])^(x[5]&x[30])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[8])^(x[6]&x[12])^(x[6]&x[15])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[25])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[39])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[25])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[36])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[31])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[19])^(x[9]&x[24])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[32])^(x[9]&x[34])^(x[9]&x[35])^(x[10]&x[10])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[20])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[28])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[23])^(x[11]&x[26])^(x[11]&x[27])^(x[11]&x[28])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[22])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[31])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[19])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[27])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[37])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[33])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[35])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[29])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[27])^(x[18]&x[32])^(x[18]&x[37])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[21])^(x[19]&x[24])^(x[19]&x[26])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[37])^(x[19]&x[38])^(x[20]&x[24])^(x[20]&x[30])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[22])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[29])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[34])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[37])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[35])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[36])^(x[27]&x[37])^(x[27]&x[38])^(x[28]&x[33])^(x[28]&x[35])^(x[28]&x[36])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[33])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[36])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[39])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[39])^(x[36]&x[36])^(x[37]&x[37])^(x[38]&x[38]);
y[3] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[6])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[18])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[36])^(x[0]&x[37])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[5])^(x[1]&x[8])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[26])^(x[1]&x[29])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[2])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[26])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[4])^(x[3]&x[7])^(x[3]&x[10])^(x[3]&x[16])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[31])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[4]&x[8])^(x[4]&x[11])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[23])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[34])^(x[4]&x[35])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[8])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[35])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[8])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[27])^(x[6]&x[29])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[21])^(x[7]&x[24])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[30])^(x[7]&x[32])^(x[7]&x[36])^(x[8]&x[11])^(x[8]&x[14])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[21])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[22])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[32])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[36])^(x[10]&x[10])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[19])^(x[10]&x[21])^(x[10]&x[29])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[37])^(x[11]&x[11])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[25])^(x[11]&x[28])^(x[11]&x[30])^(x[11]&x[35])^(x[11]&x[37])^(x[11]&x[38])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[28])^(x[12]&x[33])^(x[12]&x[36])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[28])^(x[13]&x[30])^(x[13]&x[33])^(x[13]&x[35])^(x[13]&x[39])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[20])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[28])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[38])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[18])^(x[15]&x[21])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[33])^(x[15]&x[36])^(x[15]&x[37])^(x[16]&x[18])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[25])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[23])^(x[18]&x[25])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[39])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[23])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[35])^(x[20]&x[37])^(x[21]&x[21])^(x[21]&x[22])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[32])^(x[21]&x[36])^(x[21]&x[38])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[27])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[37])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[31])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[28])^(x[24]&x[30])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[36])^(x[24]&x[37])^(x[25]&x[25])^(x[25]&x[27])^(x[25]&x[33])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[27])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[36])^(x[26]&x[37])^(x[27]&x[32])^(x[27]&x[33])^(x[27]&x[35])^(x[27]&x[36])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[38])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[35])^(x[32]&x[36])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[39])^(x[35]&x[39])^(x[36]&x[37])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[4] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[16])^(x[0]&x[18])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[32])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[15])^(x[1]&x[17])^(x[1]&x[19])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[31])^(x[1]&x[34])^(x[1]&x[37])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[12])^(x[2]&x[14])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[25])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[33])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[37])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[7])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[15])^(x[3]&x[17])^(x[3]&x[19])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[30])^(x[3]&x[33])^(x[3]&x[35])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[11])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[21])^(x[4]&x[24])^(x[4]&x[27])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[13])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[22])^(x[6]&x[24])^(x[6]&x[27])^(x[6]&x[35])^(x[6]&x[37])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[12])^(x[7]&x[19])^(x[7]&x[21])^(x[7]&x[26])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[33])^(x[7]&x[37])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[17])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[36])^(x[8]&x[38])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[36])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[29])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[29])^(x[11]&x[31])^(x[11]&x[33])^(x[11]&x[35])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[16])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[26])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[14])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[26])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[26])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[36])^(x[16]&x[17])^(x[16]&x[20])^(x[16]&x[24])^(x[16]&x[26])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[37])^(x[16]&x[38])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[35])^(x[17]&x[36])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[34])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[27])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[37])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[36])^(x[20]&x[38])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[37])^(x[21]&x[39])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[30])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[35])^(x[25]&x[36])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[33])^(x[26]&x[36])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[36])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[29])^(x[28]&x[31])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[38])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[35])^(x[30]&x[30])^(x[30]&x[32])^(x[30]&x[34])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[34])^(x[31]&x[36])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[36])^(x[32]&x[39])^(x[33]&x[34])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[38]&x[39]);
y[5] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[5])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[17])^(x[0]&x[18])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[5])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[21])^(x[1]&x[24])^(x[1]&x[28])^(x[1]&x[30])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[38])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[28])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[33])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[25])^(x[3]&x[27])^(x[3]&x[30])^(x[3]&x[35])^(x[3]&x[38])^(x[4]&x[6])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[32])^(x[4]&x[34])^(x[4]&x[39])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[25])^(x[5]&x[30])^(x[5]&x[33])^(x[5]&x[36])^(x[5]&x[38])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[17])^(x[6]&x[20])^(x[6]&x[23])^(x[6]&x[25])^(x[6]&x[28])^(x[6]&x[30])^(x[6]&x[34])^(x[6]&x[37])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[14])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[28])^(x[7]&x[31])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[38])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[20])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[38])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[31])^(x[9]&x[35])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[26])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[38])^(x[11]&x[12])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[24])^(x[11]&x[27])^(x[11]&x[30])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[37])^(x[11]&x[38])^(x[12]&x[14])^(x[12]&x[16])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[31])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[35])^(x[12]&x[36])^(x[12]&x[37])^(x[13]&x[13])^(x[13]&x[15])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[23])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[36])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[16])^(x[14]&x[18])^(x[14]&x[20])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[35])^(x[14]&x[36])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[22])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[30])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[21])^(x[17]&x[34])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[34])^(x[18]&x[37])^(x[18]&x[38])^(x[19]&x[19])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[28])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[35])^(x[19]&x[36])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[29])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[37])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[36])^(x[21]&x[38])^(x[22]&x[24])^(x[22]&x[26])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[33])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[29])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[32])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[37])^(x[26]&x[26])^(x[26]&x[29])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[37])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[36])^(x[27]&x[39])^(x[28]&x[30])^(x[28]&x[31])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[38])^(x[29]&x[29])^(x[29]&x[36])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[36])^(x[30]&x[38])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[35])^(x[31]&x[36])^(x[32]&x[36])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[37])^(x[33]&x[39])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[38])^(x[35]&x[35])^(x[35]&x[38])^(x[36]&x[36])^(x[36]&x[38])^(x[37]&x[37]);
y[6] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[10])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[18])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[36])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[6])^(x[1]&x[9])^(x[1]&x[12])^(x[1]&x[14])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[28])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[36])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[7])^(x[2]&x[9])^(x[2]&x[14])^(x[2]&x[16])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[25])^(x[2]&x[26])^(x[2]&x[28])^(x[2]&x[33])^(x[2]&x[37])^(x[3]&x[3])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[34])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[11])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[18])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[32])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[13])^(x[5]&x[15])^(x[5]&x[17])^(x[5]&x[18])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[25])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[31])^(x[5]&x[33])^(x[5]&x[36])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[6])^(x[6]&x[15])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[26])^(x[6]&x[30])^(x[6]&x[32])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[39])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[12])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[31])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[38])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[23])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[32])^(x[8]&x[37])^(x[8]&x[38])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[31])^(x[9]&x[33])^(x[9]&x[35])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[11])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[21])^(x[10]&x[24])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[19])^(x[11]&x[24])^(x[11]&x[26])^(x[11]&x[29])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[14])^(x[12]&x[17])^(x[12]&x[23])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[34])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[15])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[30])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[37])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[20])^(x[14]&x[22])^(x[14]&x[23])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[35])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[23])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[38])^(x[16]&x[17])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[25])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[29])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[28])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[38])^(x[18]&x[19])^(x[18]&x[21])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[27])^(x[18]&x[29])^(x[18]&x[31])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[34])^(x[19]&x[37])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[26])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[35])^(x[20]&x[36])^(x[20]&x[38])^(x[21]&x[22])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[37])^(x[21]&x[38])^(x[22]&x[22])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[37])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[28])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[28])^(x[24]&x[29])^(x[24]&x[35])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[28])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[37])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[32])^(x[27]&x[35])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[34])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[34])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[35])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[37])^(x[32]&x[37])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[38])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[38]&x[39]);
y[7] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[28])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[38])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[8])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[28])^(x[2]&x[34])^(x[2]&x[35])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[9])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[17])^(x[3]&x[20])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[26])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[20])^(x[4]&x[23])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[36])^(x[5]&x[6])^(x[5]&x[8])^(x[5]&x[15])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[35])^(x[5]&x[37])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[29])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[11])^(x[7]&x[12])^(x[7]&x[15])^(x[7]&x[22])^(x[7]&x[26])^(x[7]&x[29])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[34])^(x[8]&x[36])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[12])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[36])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[31])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[27])^(x[11]&x[28])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[31])^(x[12]&x[32])^(x[12]&x[35])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[38])^(x[13]&x[13])^(x[13]&x[15])^(x[13]&x[17])^(x[13]&x[20])^(x[13]&x[22])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[35])^(x[13]&x[37])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[26])^(x[14]&x[28])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[23])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[30])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[18])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[33])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[30])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[36])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[28])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[36])^(x[21]&x[22])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[38])^(x[21]&x[39])^(x[22]&x[22])^(x[22]&x[25])^(x[22]&x[30])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[36])^(x[22]&x[38])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[36])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[27])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[35])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[28])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[37])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[36])^(x[27]&x[37])^(x[28]&x[28])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[36])^(x[28]&x[39])^(x[29]&x[37])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[33])^(x[30]&x[37])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[34])^(x[31]&x[36])^(x[32]&x[32])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[36])^(x[33]&x[35])^(x[33]&x[37])^(x[34]&x[34])^(x[34]&x[36])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[38])^(x[36]&x[36])^(x[36]&x[38])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[38])^(x[39]&x[39]);
y[8] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[27])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[36])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[5])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[28])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[6])^(x[2]&x[8])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[15])^(x[3]&x[20])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[34])^(x[3]&x[37])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[30])^(x[4]&x[33])^(x[4]&x[34])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[13])^(x[5]&x[18])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[7])^(x[6]&x[11])^(x[6]&x[13])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[38])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[14])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[19])^(x[7]&x[20])^(x[7]&x[21])^(x[7]&x[23])^(x[7]&x[25])^(x[7]&x[27])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[32])^(x[7]&x[35])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[12])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[32])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[37])^(x[9]&x[9])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[22])^(x[10]&x[24])^(x[10]&x[27])^(x[10]&x[29])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[34])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[15])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[24])^(x[11]&x[28])^(x[11]&x[30])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[24])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[31])^(x[12]&x[33])^(x[12]&x[36])^(x[12]&x[39])^(x[13]&x[14])^(x[13]&x[20])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[38])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[22])^(x[14]&x[24])^(x[14]&x[26])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[37])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[23])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[21])^(x[16]&x[24])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[33])^(x[16]&x[37])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[31])^(x[17]&x[33])^(x[17]&x[34])^(x[18]&x[18])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[28])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[37])^(x[19]&x[19])^(x[19]&x[21])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[39])^(x[20]&x[20])^(x[20]&x[22])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[35])^(x[21]&x[21])^(x[21]&x[22])^(x[21]&x[23])^(x[21]&x[25])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[36])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[26])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[30])^(x[23]&x[33])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[29])^(x[24]&x[33])^(x[24]&x[36])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[38])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[33])^(x[27]&x[39])^(x[28]&x[31])^(x[28]&x[36])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[36])^(x[29]&x[38])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[35])^(x[30]&x[37])^(x[30]&x[38])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[36])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[32]&x[38])^(x[33]&x[34])^(x[33]&x[35])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[38])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39]);
y[9] = 0^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[7])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[31])^(x[0]&x[36])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[30])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[36])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[7])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[12])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[28])^(x[2]&x[32])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[18])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[34])^(x[3]&x[35])^(x[4]&x[7])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[18])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[23])^(x[4]&x[31])^(x[4]&x[34])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[7])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[13])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[21])^(x[5]&x[24])^(x[5]&x[30])^(x[5]&x[38])^(x[6]&x[6])^(x[6]&x[8])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[33])^(x[7]&x[7])^(x[7]&x[10])^(x[7]&x[14])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[24])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[38])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[31])^(x[8]&x[34])^(x[8]&x[37])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[12])^(x[9]&x[16])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[26])^(x[9]&x[31])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[19])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[11]&x[16])^(x[11]&x[21])^(x[11]&x[25])^(x[11]&x[28])^(x[11]&x[33])^(x[11]&x[37])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[15])^(x[12]&x[17])^(x[12]&x[20])^(x[12]&x[23])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[32])^(x[12]&x[34])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[22])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[37])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[20])^(x[14]&x[21])^(x[14]&x[22])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[36])^(x[14]&x[38])^(x[15]&x[16])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[26])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[34])^(x[15]&x[36])^(x[16]&x[18])^(x[16]&x[20])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[26])^(x[16]&x[28])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[37])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[28])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[34])^(x[18]&x[38])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[24])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[32])^(x[19]&x[34])^(x[19]&x[36])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[25])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[32])^(x[20]&x[37])^(x[20]&x[38])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[31])^(x[22]&x[34])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[30])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[34])^(x[23]&x[37])^(x[23]&x[38])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[32])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[35])^(x[25]&x[37])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[33])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[28])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[34])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[35])^(x[28]&x[36])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[34])^(x[32]&x[34])^(x[32]&x[37])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[38])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[37])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[39]&x[39]);
y[10] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[8])^(x[0]&x[10])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[15])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[36])^(x[0]&x[39])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[6])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[15])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[21])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[29])^(x[1]&x[31])^(x[1]&x[33])^(x[1]&x[36])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[7])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[19])^(x[2]&x[23])^(x[2]&x[30])^(x[2]&x[33])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[5])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[31])^(x[3]&x[32])^(x[3]&x[37])^(x[3]&x[38])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[13])^(x[4]&x[16])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[21])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[32])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[8])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[17])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[31])^(x[5]&x[35])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[8])^(x[6]&x[11])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[19])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[20])^(x[7]&x[21])^(x[7]&x[22])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[36])^(x[7]&x[38])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[34])^(x[9]&x[10])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[19])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[33])^(x[9]&x[37])^(x[10]&x[10])^(x[10]&x[12])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[18])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[26])^(x[11]&x[27])^(x[11]&x[29])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[36])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[16])^(x[12]&x[18])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[30])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[35])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[18])^(x[13]&x[20])^(x[13]&x[25])^(x[13]&x[27])^(x[13]&x[29])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[38])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[23])^(x[16]&x[25])^(x[16]&x[29])^(x[16]&x[34])^(x[16]&x[39])^(x[17]&x[18])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[36])^(x[18]&x[18])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[34])^(x[18]&x[35])^(x[18]&x[36])^(x[19]&x[19])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[28])^(x[19]&x[30])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[37])^(x[20]&x[21])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[38])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[38])^(x[22]&x[22])^(x[22]&x[25])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[38])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[30])^(x[23]&x[34])^(x[23]&x[37])^(x[23]&x[38])^(x[24]&x[24])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[29])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[38])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[33])^(x[25]&x[35])^(x[25]&x[38])^(x[26]&x[26])^(x[26]&x[31])^(x[26]&x[32])^(x[27]&x[27])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[36])^(x[27]&x[37])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[32]&x[33])^(x[32]&x[37])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[37])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[34])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[37])^(x[36]&x[36])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[39])^(x[38]&x[39]);
y[11] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[8])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[16])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[34])^(x[1]&x[36])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[26])^(x[2]&x[28])^(x[2]&x[29])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[34])^(x[2]&x[36])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[12])^(x[3]&x[14])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[30])^(x[3]&x[32])^(x[3]&x[36])^(x[3]&x[39])^(x[4]&x[5])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[16])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[25])^(x[4]&x[27])^(x[4]&x[29])^(x[4]&x[31])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[17])^(x[5]&x[22])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[36])^(x[5]&x[39])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[14])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[19])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[8])^(x[7]&x[11])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[19])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[32])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[35])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[39])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[20])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[13])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[28])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[16])^(x[12]&x[18])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[25])^(x[12]&x[29])^(x[12]&x[32])^(x[12]&x[34])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[37])^(x[13]&x[39])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[24])^(x[14]&x[27])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[21])^(x[15]&x[23])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[32])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[23])^(x[16]&x[25])^(x[16]&x[26])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[34])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[31])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[35])^(x[18]&x[37])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[31])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[26])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[39])^(x[21]&x[22])^(x[21]&x[25])^(x[21]&x[28])^(x[21]&x[30])^(x[21]&x[35])^(x[21]&x[36])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[30])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[30])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[35])^(x[23]&x[37])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[30])^(x[24]&x[36])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[26])^(x[25]&x[31])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[37])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[35])^(x[28]&x[28])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[33])^(x[30]&x[36])^(x[30]&x[37])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[37])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[38])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[12] = 0^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[26])^(x[0]&x[29])^(x[0]&x[31])^(x[0]&x[35])^(x[0]&x[36])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[31])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[14])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[26])^(x[2]&x[28])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[17])^(x[3]&x[19])^(x[3]&x[21])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[31])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[21])^(x[4]&x[23])^(x[4]&x[25])^(x[4]&x[31])^(x[4]&x[36])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[9])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[30])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[37])^(x[6]&x[6])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[29])^(x[6]&x[32])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[12])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[21])^(x[7]&x[23])^(x[7]&x[25])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[31])^(x[7]&x[33])^(x[8]&x[8])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[35])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[13])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[25])^(x[9]&x[30])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[37])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[31])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[37])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[24])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[26])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[31])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[37])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[26])^(x[13]&x[30])^(x[13]&x[33])^(x[13]&x[35])^(x[13]&x[37])^(x[13]&x[38])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[22])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[35])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[18])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[26])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[36])^(x[16]&x[37])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[35])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[20])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[27])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[36])^(x[18]&x[37])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[36])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[28])^(x[20]&x[30])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[37])^(x[21]&x[39])^(x[22]&x[23])^(x[22]&x[25])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[31])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[38])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[29])^(x[23]&x[31])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[29])^(x[24]&x[30])^(x[24]&x[32])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[39])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[37])^(x[25]&x[39])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[32])^(x[27]&x[37])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[33])^(x[30]&x[36])^(x[30]&x[37])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[36])^(x[31]&x[38])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[38])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[38])^(x[35]&x[35])^(x[35]&x[37])^(x[36]&x[36])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[13] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[5])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[20])^(x[0]&x[23])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[35])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[14])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[24])^(x[1]&x[28])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[37])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[20])^(x[2]&x[23])^(x[2]&x[26])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[37])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[30])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[17])^(x[4]&x[21])^(x[4]&x[23])^(x[4]&x[26])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[33])^(x[4]&x[35])^(x[4]&x[38])^(x[5]&x[6])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[14])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[26])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[37])^(x[6]&x[6])^(x[6]&x[7])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[27])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[24])^(x[7]&x[25])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[37])^(x[7]&x[38])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[13])^(x[8]&x[17])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[28])^(x[8]&x[30])^(x[8]&x[32])^(x[8]&x[34])^(x[9]&x[10])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[37])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[30])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[33])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[16])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[23])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[32])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[36])^(x[13]&x[13])^(x[13]&x[15])^(x[13]&x[17])^(x[13]&x[20])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[35])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[24])^(x[14]&x[26])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[34])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[21])^(x[15]&x[25])^(x[15]&x[27])^(x[15]&x[32])^(x[15]&x[35])^(x[15]&x[37])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[20])^(x[16]&x[26])^(x[16]&x[28])^(x[16]&x[31])^(x[16]&x[37])^(x[16]&x[38])^(x[17]&x[20])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[25])^(x[18]&x[27])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[37])^(x[18]&x[38])^(x[19]&x[19])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[37])^(x[19]&x[38])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[24])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[36])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[25])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[32])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[25])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[35])^(x[22]&x[37])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[37])^(x[26]&x[39])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[38])^(x[28]&x[28])^(x[28]&x[31])^(x[28]&x[32])^(x[28]&x[34])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[34])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[33])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[39])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[39])^(x[37]&x[37])^(x[37]&x[39])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[14] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[29])^(x[0]&x[32])^(x[0]&x[36])^(x[1]&x[1])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[34])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[8])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[19])^(x[2]&x[21])^(x[2]&x[24])^(x[2]&x[27])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[37])^(x[3]&x[8])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[32])^(x[3]&x[34])^(x[3]&x[36])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[16])^(x[4]&x[17])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[37])^(x[4]&x[39])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[28])^(x[5]&x[31])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[36])^(x[5]&x[38])^(x[6]&x[6])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[32])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[25])^(x[7]&x[27])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[35])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[31])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[39])^(x[9]&x[13])^(x[9]&x[17])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[37])^(x[9]&x[38])^(x[10]&x[10])^(x[10]&x[12])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[19])^(x[10]&x[22])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[31])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[25])^(x[11]&x[27])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[34])^(x[11]&x[37])^(x[11]&x[38])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[39])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[30])^(x[13]&x[36])^(x[13]&x[37])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[19])^(x[14]&x[22])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[31])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[36])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[34])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[23])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[29])^(x[17]&x[31])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[39])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[32])^(x[18]&x[36])^(x[18]&x[37])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[29])^(x[19]&x[31])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[26])^(x[20]&x[29])^(x[20]&x[31])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[36])^(x[20]&x[37])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[23])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[25])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[34])^(x[22]&x[36])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[39])^(x[24]&x[29])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[26])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[33])^(x[25]&x[36])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[27])^(x[26]&x[32])^(x[26]&x[34])^(x[26]&x[36])^(x[26]&x[37])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[29])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[33])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[39])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[37])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[39])^(x[38]&x[38]);
y[15] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[17])^(x[0]&x[20])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[36])^(x[0]&x[37])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[13])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[27])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[33])^(x[2]&x[36])^(x[2]&x[38])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[13])^(x[5]&x[15])^(x[5]&x[18])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[32])^(x[5]&x[35])^(x[5]&x[37])^(x[5]&x[38])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[20])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[28])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[38])^(x[7]&x[7])^(x[7]&x[11])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[21])^(x[7]&x[22])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[29])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[38])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[15])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[29])^(x[8]&x[34])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[34])^(x[9]&x[36])^(x[10]&x[10])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[12])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[19])^(x[11]&x[27])^(x[11]&x[29])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[35])^(x[11]&x[36])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[20])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[37])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[18])^(x[13]&x[20])^(x[13]&x[22])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[27])^(x[13]&x[31])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[37])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[22])^(x[14]&x[29])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[24])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[29])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[21])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[20])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[29])^(x[17]&x[31])^(x[17]&x[33])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[23])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[39])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[36])^(x[20]&x[39])^(x[21]&x[22])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[39])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[33])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[38])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[26])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[33])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[32])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[36])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[33])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[37])^(x[32]&x[33])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[38])^(x[33]&x[33])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[34])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[38])^(x[36]&x[38])^(x[37]&x[37])^(x[38]&x[38])^(x[39]&x[39]);
y[16] = 0^(x[0]&x[2])^(x[0]&x[3])^(x[0]&x[6])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[20])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[30])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[5])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[27])^(x[2]&x[29])^(x[2]&x[33])^(x[2]&x[34])^(x[2]&x[35])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[8])^(x[3]&x[10])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[26])^(x[3]&x[29])^(x[3]&x[30])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[12])^(x[4]&x[15])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[31])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[7])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[17])^(x[5]&x[18])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[27])^(x[5]&x[31])^(x[5]&x[33])^(x[5]&x[39])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[20])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[20])^(x[7]&x[30])^(x[7]&x[34])^(x[7]&x[37])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[23])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[30])^(x[8]&x[33])^(x[8]&x[34])^(x[8]&x[36])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[34])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[20])^(x[11]&x[23])^(x[11]&x[25])^(x[11]&x[27])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[35])^(x[11]&x[37])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[18])^(x[12]&x[20])^(x[12]&x[23])^(x[12]&x[25])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[39])^(x[13]&x[15])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[20])^(x[13]&x[22])^(x[13]&x[24])^(x[13]&x[28])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[37])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[20])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[35])^(x[14]&x[38])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[26])^(x[15]&x[30])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[23])^(x[16]&x[25])^(x[16]&x[26])^(x[16]&x[30])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[36])^(x[16]&x[37])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[21])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[31])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[37])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[32])^(x[19]&x[35])^(x[19]&x[36])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[35])^(x[20]&x[36])^(x[20]&x[37])^(x[20]&x[38])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[25])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[35])^(x[21]&x[38])^(x[21]&x[39])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[29])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[35])^(x[26]&x[37])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[32])^(x[27]&x[34])^(x[27]&x[36])^(x[27]&x[37])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[31])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[36])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[34])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[36])^(x[34]&x[38])^(x[35]&x[37])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[39]&x[39]);
y[17] = 0^(x[0]&x[1])^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[27])^(x[0]&x[29])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[35])^(x[0]&x[39])^(x[1]&x[4])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[15])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[28])^(x[1]&x[37])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[12])^(x[2]&x[14])^(x[2]&x[18])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[31])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[30])^(x[3]&x[32])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[16])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[34])^(x[5]&x[5])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[22])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[28])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[35])^(x[6]&x[6])^(x[6]&x[8])^(x[6]&x[10])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[36])^(x[6]&x[37])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[26])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[37])^(x[7]&x[38])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[19])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[31])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[10])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[27])^(x[9]&x[30])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[36])^(x[9]&x[39])^(x[10]&x[12])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[37])^(x[10]&x[39])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[21])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[21])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[31])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[37])^(x[14]&x[14])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[20])^(x[14]&x[22])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[37])^(x[15]&x[15])^(x[15]&x[19])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[25])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[38])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[28])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[34])^(x[16]&x[36])^(x[16]&x[37])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[36])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[35])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[30])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[37])^(x[19]&x[38])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[26])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[35])^(x[20]&x[37])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[26])^(x[21]&x[28])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[38])^(x[21]&x[39])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[26])^(x[23]&x[29])^(x[23]&x[31])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[26])^(x[24]&x[29])^(x[24]&x[30])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[25])^(x[25]&x[27])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[36])^(x[26]&x[39])^(x[27]&x[29])^(x[27]&x[33])^(x[27]&x[35])^(x[27]&x[36])^(x[27]&x[37])^(x[27]&x[39])^(x[28]&x[29])^(x[28]&x[31])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[38])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[30]&x[31])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[35])^(x[31]&x[36])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[33]&x[33])^(x[33]&x[35])^(x[33]&x[37])^(x[33]&x[38])^(x[34]&x[34])^(x[34]&x[36])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[39])^(x[39]&x[39]);
y[18] = 0^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[10])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[19])^(x[0]&x[23])^(x[0]&x[26])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[33])^(x[0]&x[37])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[10])^(x[1]&x[14])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[32])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[2])^(x[2]&x[3])^(x[2]&x[6])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[26])^(x[2]&x[28])^(x[2]&x[29])^(x[2]&x[32])^(x[2]&x[34])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[9])^(x[4]&x[13])^(x[4]&x[19])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[26])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[37])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[14])^(x[5]&x[17])^(x[5]&x[19])^(x[5]&x[21])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[31])^(x[5]&x[33])^(x[5]&x[36])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[7])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[28])^(x[6]&x[30])^(x[6]&x[32])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[37])^(x[6]&x[38])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[21])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[11])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[35])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[12])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[13])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[26])^(x[11]&x[29])^(x[11]&x[31])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[16])^(x[12]&x[17])^(x[12]&x[20])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[30])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[37])^(x[12]&x[38])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[33])^(x[13]&x[39])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[31])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[21])^(x[15]&x[24])^(x[15]&x[27])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[18]&x[19])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[27])^(x[18]&x[31])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[24])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[32])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[27])^(x[20]&x[30])^(x[20]&x[32])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[35])^(x[21]&x[39])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[27])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[37])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[30])^(x[23]&x[33])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[27])^(x[24]&x[29])^(x[24]&x[33])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[31])^(x[25]&x[33])^(x[25]&x[35])^(x[25]&x[38])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[35])^(x[26]&x[36])^(x[26]&x[37])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[30])^(x[27]&x[32])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[36])^(x[27]&x[37])^(x[28]&x[28])^(x[28]&x[31])^(x[28]&x[32])^(x[28]&x[35])^(x[28]&x[38])^(x[29]&x[31])^(x[29]&x[33])^(x[29]&x[36])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[37])^(x[31]&x[39])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[35])^(x[32]&x[38])^(x[33]&x[37])^(x[33]&x[39])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[39]&x[39]);
y[19] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[18])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[34])^(x[0]&x[37])^(x[0]&x[39])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[31])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[22])^(x[2]&x[27])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[33])^(x[2]&x[35])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[33])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[12])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[25])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[37])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[23])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[31])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[38])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[13])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[21])^(x[6]&x[25])^(x[6]&x[26])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[37])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[36])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[28])^(x[8]&x[30])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[13])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[24])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[33])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[38])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[32])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[37])^(x[11]&x[12])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[26])^(x[11]&x[27])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[32])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[12]&x[15])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[25])^(x[12]&x[27])^(x[12]&x[30])^(x[12]&x[33])^(x[12]&x[35])^(x[12]&x[36])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[17])^(x[13]&x[19])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[27])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[35])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[21])^(x[14]&x[25])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[32])^(x[14]&x[34])^(x[14]&x[35])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[25])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[31])^(x[15]&x[37])^(x[15]&x[38])^(x[15]&x[39])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[21])^(x[16]&x[23])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[29])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[36])^(x[16]&x[39])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[27])^(x[17]&x[30])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[21])^(x[18]&x[23])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[37])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[28])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[26])^(x[20]&x[28])^(x[20]&x[30])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[35])^(x[20]&x[37])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[27])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[38])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[37])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[35])^(x[23]&x[38])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[31])^(x[24]&x[33])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[35])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[29])^(x[26]&x[33])^(x[26]&x[36])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[29])^(x[27]&x[32])^(x[27]&x[35])^(x[27]&x[36])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[37])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[32])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[34])^(x[30]&x[37])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[32])^(x[31]&x[35])^(x[31]&x[37])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[37])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[35])^(x[33]&x[38])^(x[34]&x[36])^(x[34]&x[37])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[39])^(x[37]&x[37])^(x[38]&x[38]);
y[20] = 0^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[23])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[7])^(x[1]&x[10])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[27])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[34])^(x[1]&x[36])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[26])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[7])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[14])^(x[3]&x[17])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[34])^(x[3]&x[35])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[17])^(x[4]&x[21])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[35])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[7])^(x[5]&x[11])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[22])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[33])^(x[5]&x[38])^(x[6]&x[7])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[24])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[16])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[21])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[30])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[37])^(x[7]&x[38])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[37])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[35])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[29])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[13])^(x[11]&x[16])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[26])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[23])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[36])^(x[12]&x[38])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[26])^(x[13]&x[28])^(x[13]&x[31])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[39])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[20])^(x[14]&x[23])^(x[14]&x[28])^(x[14]&x[30])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[37])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[36])^(x[15]&x[38])^(x[15]&x[39])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[26])^(x[16]&x[28])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[38])^(x[18]&x[19])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[28])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[37])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[37])^(x[20]&x[38])^(x[21]&x[21])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[38])^(x[21]&x[39])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[26])^(x[22]&x[28])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[36])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[28])^(x[24]&x[29])^(x[24]&x[32])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[31])^(x[25]&x[34])^(x[25]&x[36])^(x[26]&x[27])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[34])^(x[26]&x[36])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[35])^(x[27]&x[37])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[31])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[36])^(x[28]&x[38])^(x[29]&x[31])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[38])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[36])^(x[30]&x[37])^(x[31]&x[34])^(x[31]&x[36])^(x[31]&x[37])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[39])^(x[34]&x[34])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[37])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[37])^(x[38]&x[38]);
y[21] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[8])^(x[0]&x[12])^(x[0]&x[14])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[24])^(x[0]&x[27])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[39])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[9])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[17])^(x[1]&x[22])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[33])^(x[1]&x[34])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[28])^(x[2]&x[31])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[9])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[29])^(x[3]&x[37])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[7])^(x[4]&x[9])^(x[4]&x[12])^(x[4]&x[14])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[18])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[26])^(x[5]&x[28])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[35])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[30])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[36])^(x[6]&x[38])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[23])^(x[7]&x[25])^(x[7]&x[26])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[33])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[38])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[12])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[31])^(x[8]&x[33])^(x[8]&x[39])^(x[9]&x[10])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[33])^(x[9]&x[35])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[37])^(x[11]&x[12])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[28])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[18])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[24])^(x[12]&x[30])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[16])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[31])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[33])^(x[15]&x[36])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[22])^(x[16]&x[25])^(x[16]&x[29])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[37])^(x[16]&x[38])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[37])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[29])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[35])^(x[18]&x[36])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[39])^(x[20]&x[20])^(x[20]&x[22])^(x[20]&x[27])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[36])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[35])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[39])^(x[23]&x[24])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[25])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[39])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[37])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[37])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[37])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[38])^(x[30]&x[31])^(x[30]&x[33])^(x[30]&x[36])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[34])^(x[31]&x[36])^(x[32]&x[33])^(x[32]&x[36])^(x[32]&x[39])^(x[33]&x[37])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[39])^(x[35]&x[37])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[37])^(x[36]&x[38])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[38])^(x[39]&x[39]);
y[22] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[10])^(x[0]&x[13])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[28])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[35])^(x[0]&x[37])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[7])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[37])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[5])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[15])^(x[2]&x[19])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[30])^(x[2]&x[32])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[17])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[36])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[13])^(x[5]&x[17])^(x[5]&x[18])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[24])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[35])^(x[5]&x[36])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[23])^(x[6]&x[25])^(x[6]&x[27])^(x[6]&x[30])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[38])^(x[7]&x[9])^(x[7]&x[11])^(x[7]&x[16])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[30])^(x[7]&x[32])^(x[7]&x[38])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[14])^(x[8]&x[17])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[31])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[38])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[31])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[24])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[35])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[14])^(x[11]&x[18])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[27])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[33])^(x[11]&x[35])^(x[11]&x[36])^(x[12]&x[12])^(x[12]&x[14])^(x[12]&x[17])^(x[12]&x[20])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[26])^(x[12]&x[31])^(x[12]&x[34])^(x[12]&x[36])^(x[12]&x[38])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[20])^(x[13]&x[25])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[22])^(x[14]&x[24])^(x[14]&x[27])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[18])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[30])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[35])^(x[15]&x[36])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[30])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[19])^(x[17]&x[20])^(x[17]&x[22])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[36])^(x[17]&x[39])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[36])^(x[19]&x[22])^(x[19]&x[25])^(x[19]&x[28])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[37])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[38])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[29])^(x[24]&x[30])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[37])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[37])^(x[25]&x[39])^(x[26]&x[28])^(x[26]&x[32])^(x[26]&x[35])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[32])^(x[27]&x[35])^(x[27]&x[37])^(x[27]&x[38])^(x[28]&x[28])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[35])^(x[28]&x[39])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[39])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[36])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[37])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[37])^(x[33]&x[33])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[39])^(x[35]&x[38])^(x[36]&x[38])^(x[37]&x[39])^(x[38]&x[38])^(x[39]&x[39]);
y[23] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[15])^(x[0]&x[17])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[11])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[10])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[25])^(x[2]&x[28])^(x[2]&x[29])^(x[2]&x[31])^(x[2]&x[33])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[5])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[15])^(x[4]&x[17])^(x[4]&x[20])^(x[4]&x[25])^(x[4]&x[28])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[36])^(x[4]&x[37])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[24])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[37])^(x[6]&x[6])^(x[6]&x[8])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[21])^(x[6]&x[25])^(x[6]&x[29])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[37])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[16])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[31])^(x[8]&x[35])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[24])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[12])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[32])^(x[10]&x[34])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[20])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[26])^(x[11]&x[28])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[12]&x[14])^(x[12]&x[17])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[23])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[20])^(x[13]&x[22])^(x[13]&x[24])^(x[13]&x[27])^(x[13]&x[30])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[36])^(x[13]&x[38])^(x[14]&x[14])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[24])^(x[14]&x[25])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[31])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[24])^(x[15]&x[27])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[39])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[29])^(x[16]&x[30])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[35])^(x[16]&x[37])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[31])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[20])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[25])^(x[18]&x[28])^(x[18]&x[33])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[29])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[34])^(x[20]&x[38])^(x[21]&x[21])^(x[21]&x[24])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[36])^(x[21]&x[37])^(x[21]&x[38])^(x[21]&x[39])^(x[22]&x[24])^(x[22]&x[26])^(x[22]&x[29])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[35])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[28])^(x[24]&x[31])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[36])^(x[25]&x[25])^(x[25]&x[27])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[30])^(x[26]&x[32])^(x[26]&x[37])^(x[27]&x[28])^(x[27]&x[32])^(x[27]&x[34])^(x[27]&x[39])^(x[28]&x[29])^(x[28]&x[35])^(x[28]&x[37])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[35])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[37])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[37])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[37])^(x[33]&x[39])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[37])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[37]&x[38])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[24] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[6])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[15])^(x[0]&x[18])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[25])^(x[0]&x[27])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[25])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[36])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[8])^(x[2]&x[10])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[19])^(x[2]&x[21])^(x[2]&x[23])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[33])^(x[2]&x[35])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[29])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[39])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[14])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[27])^(x[4]&x[29])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[35])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[8])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[37])^(x[6]&x[7])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[25])^(x[6]&x[27])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[35])^(x[6]&x[38])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[14])^(x[7]&x[16])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[29])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[12])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[30])^(x[8]&x[33])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[38])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[36])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[15])^(x[10]&x[19])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[30])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[36])^(x[10]&x[38])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[32])^(x[11]&x[35])^(x[11]&x[38])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[16])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[20])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[30])^(x[12]&x[32])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[14])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[27])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[38])^(x[14]&x[16])^(x[14]&x[21])^(x[14]&x[23])^(x[14]&x[24])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[31])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[21])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[32])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[38])^(x[15]&x[39])^(x[16]&x[17])^(x[16]&x[20])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[31])^(x[16]&x[37])^(x[17]&x[17])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[26])^(x[17]&x[29])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[28])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[34])^(x[19]&x[36])^(x[19]&x[37])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[24])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[37])^(x[20]&x[38])^(x[21]&x[21])^(x[21]&x[25])^(x[21]&x[28])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[37])^(x[21]&x[39])^(x[22]&x[23])^(x[22]&x[24])^(x[22]&x[26])^(x[22]&x[29])^(x[22]&x[34])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[34])^(x[24]&x[25])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[29])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[37])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[27])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[39])^(x[26]&x[29])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[31])^(x[28]&x[32])^(x[28]&x[36])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[38])^(x[32]&x[34])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[39])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[35])^(x[34]&x[36])^(x[35]&x[35])^(x[35]&x[37])^(x[36]&x[36])^(x[36]&x[38])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[38])^(x[38]&x[39]);
y[25] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[10])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[30])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[7])^(x[1]&x[9])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[29])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[38])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[12])^(x[2]&x[14])^(x[2]&x[17])^(x[2]&x[19])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[28])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[4])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[31])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[39])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[10])^(x[4]&x[16])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[7])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[17])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[19])^(x[6]&x[22])^(x[6]&x[29])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[36])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[10])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[22])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[34])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[38])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[13])^(x[8]&x[15])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[33])^(x[8]&x[39])^(x[9]&x[10])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[25])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[36])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[21])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[37])^(x[10]&x[39])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[27])^(x[11]&x[29])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[36])^(x[11]&x[38])^(x[12]&x[12])^(x[12]&x[16])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[20])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[35])^(x[12]&x[39])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[33])^(x[13]&x[36])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[23])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[31])^(x[14]&x[35])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[23])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[32])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[18])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[26])^(x[16]&x[30])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[21])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[30])^(x[17]&x[33])^(x[17]&x[37])^(x[17]&x[39])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[23])^(x[18]&x[25])^(x[18]&x[29])^(x[18]&x[32])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[20])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[34])^(x[19]&x[38])^(x[20]&x[20])^(x[20]&x[22])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[28])^(x[20]&x[30])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[22])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[29])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[35])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[37])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[36])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[36])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[31])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[39])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[37])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[36])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[32])^(x[32]&x[34])^(x[32]&x[37])^(x[33]&x[35])^(x[33]&x[37])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[38])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[38])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39]);
y[26] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[8])^(x[0]&x[10])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[37])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[9])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[39])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[15])^(x[3]&x[17])^(x[3]&x[19])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[38])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[28])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[39])^(x[5]&x[6])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[21])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[26])^(x[5]&x[32])^(x[5]&x[34])^(x[5]&x[36])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[13])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[26])^(x[6]&x[30])^(x[6]&x[33])^(x[6]&x[38])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[19])^(x[7]&x[20])^(x[7]&x[21])^(x[7]&x[22])^(x[7]&x[25])^(x[7]&x[26])^(x[7]&x[28])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[38])^(x[8]&x[11])^(x[8]&x[13])^(x[8]&x[15])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[32])^(x[8]&x[34])^(x[8]&x[37])^(x[8]&x[39])^(x[9]&x[13])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[37])^(x[9]&x[38])^(x[10]&x[10])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[27])^(x[10]&x[29])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[20])^(x[11]&x[24])^(x[11]&x[28])^(x[11]&x[32])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[37])^(x[12]&x[38])^(x[13]&x[15])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[23])^(x[13]&x[26])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[33])^(x[13]&x[36])^(x[13]&x[37])^(x[14]&x[14])^(x[14]&x[16])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[23])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[15]&x[15])^(x[15]&x[17])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[32])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[29])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[33])^(x[19]&x[36])^(x[19]&x[38])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[33])^(x[20]&x[36])^(x[20]&x[37])^(x[21]&x[21])^(x[21]&x[24])^(x[21]&x[28])^(x[21]&x[31])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[36])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[25])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[32])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[30])^(x[23]&x[32])^(x[23]&x[35])^(x[23]&x[37])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[29])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[36])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[36])^(x[27]&x[39])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[37])^(x[29]&x[38])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[36])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[36])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[33])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[38])^(x[35]&x[35])^(x[35]&x[36])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[38])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[27] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[15])^(x[0]&x[18])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[29])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[30])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[37])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[6])^(x[2]&x[12])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[29])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[14])^(x[3]&x[18])^(x[3]&x[21])^(x[3]&x[24])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[7])^(x[4]&x[10])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[21])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[33])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[6])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[18])^(x[5]&x[20])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[34])^(x[5]&x[37])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[6])^(x[6]&x[8])^(x[6]&x[13])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[22])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[25])^(x[7]&x[26])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[34])^(x[7]&x[36])^(x[7]&x[37])^(x[8]&x[8])^(x[8]&x[11])^(x[8]&x[14])^(x[8]&x[17])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[33])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[38])^(x[9]&x[9])^(x[9]&x[10])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[32])^(x[9]&x[34])^(x[10]&x[10])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[16])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[27])^(x[10]&x[31])^(x[10]&x[34])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[16])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[27])^(x[11]&x[29])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[18])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[23])^(x[12]&x[25])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[32])^(x[12]&x[35])^(x[12]&x[36])^(x[13]&x[13])^(x[13]&x[16])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[37])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[17])^(x[14]&x[25])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[39])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[38])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[25])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[38])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[39])^(x[18]&x[20])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[28])^(x[18]&x[31])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[35])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[27])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[28])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[31])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[39])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[29])^(x[22]&x[32])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[30])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[29])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[36])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[28])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[31])^(x[26]&x[37])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[34])^(x[27]&x[37])^(x[27]&x[38])^(x[28]&x[30])^(x[28]&x[31])^(x[28]&x[35])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[36])^(x[30]&x[39])^(x[31]&x[32])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[38])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[38])^(x[36]&x[38])^(x[37]&x[38])^(x[39]&x[39]);
y[28] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[30])^(x[2]&x[34])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[24])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[39])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[10])^(x[4]&x[12])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[34])^(x[4]&x[37])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[6])^(x[5]&x[13])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[20])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[33])^(x[5]&x[35])^(x[5]&x[37])^(x[5]&x[39])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[24])^(x[6]&x[27])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[31])^(x[6]&x[36])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[37])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[36])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[23])^(x[9]&x[27])^(x[9]&x[30])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[35])^(x[9]&x[36])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[36])^(x[11]&x[13])^(x[11]&x[16])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[26])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[33])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[16])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[29])^(x[13]&x[34])^(x[13]&x[36])^(x[13]&x[39])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[23])^(x[14]&x[26])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[31])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[38])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[23])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[18])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[37])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[25])^(x[18]&x[29])^(x[18]&x[30])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[35])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[27])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[32])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[36])^(x[20]&x[37])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[29])^(x[21]&x[31])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[24])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[37])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[38])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[28])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[30])^(x[27]&x[35])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[31])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[37])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[34])^(x[29]&x[36])^(x[29]&x[39])^(x[30]&x[32])^(x[30]&x[34])^(x[30]&x[35])^(x[30]&x[37])^(x[30]&x[38])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[32]&x[32])^(x[32]&x[34])^(x[33]&x[33])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[37])^(x[34]&x[34])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[37])^(x[35]&x[39])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[38]&x[39])^(x[39]&x[39]);
y[29] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[39])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[10])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[28])^(x[2]&x[30])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[8])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[17])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[25])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[31])^(x[3]&x[33])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[29])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[9])^(x[5]&x[11])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[36])^(x[5]&x[37])^(x[5]&x[38])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[14])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[29])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[39])^(x[7]&x[9])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[18])^(x[7]&x[19])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[27])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[36])^(x[8]&x[8])^(x[8]&x[10])^(x[8]&x[12])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[19])^(x[8]&x[20])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[34])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[37])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[29])^(x[9]&x[30])^(x[9]&x[35])^(x[9]&x[38])^(x[10]&x[10])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[20])^(x[10]&x[24])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[37])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[18])^(x[11]&x[22])^(x[11]&x[23])^(x[11]&x[24])^(x[11]&x[26])^(x[11]&x[27])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[34])^(x[11]&x[36])^(x[11]&x[37])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[32])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[37])^(x[12]&x[38])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[21])^(x[13]&x[24])^(x[13]&x[27])^(x[13]&x[30])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[39])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[20])^(x[14]&x[25])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[32])^(x[15]&x[15])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[24])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[30])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[22])^(x[16]&x[27])^(x[16]&x[31])^(x[16]&x[32])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[29])^(x[17]&x[32])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[19])^(x[18]&x[22])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[30])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[36])^(x[18]&x[37])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[29])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[20]&x[23])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[31])^(x[20]&x[33])^(x[20]&x[37])^(x[21]&x[22])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[31])^(x[21]&x[36])^(x[21]&x[37])^(x[21]&x[38])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[31])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[39])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[32])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[36])^(x[23]&x[37])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[29])^(x[24]&x[30])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[35])^(x[24]&x[36])^(x[25]&x[29])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[37])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[35])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[36])^(x[28]&x[29])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[37])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[37])^(x[29]&x[38])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[34])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[37])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[36])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[38])^(x[39]&x[39]);
y[30] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[15])^(x[0]&x[18])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[26])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[37])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[37])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[6])^(x[2]&x[9])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[13])^(x[2]&x[14])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[20])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[26])^(x[2]&x[28])^(x[2]&x[31])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[8])^(x[3]&x[13])^(x[3]&x[15])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[34])^(x[3]&x[36])^(x[3]&x[38])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[15])^(x[4]&x[19])^(x[4]&x[23])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[33])^(x[4]&x[35])^(x[5]&x[5])^(x[5]&x[8])^(x[5]&x[10])^(x[5]&x[14])^(x[5]&x[16])^(x[5]&x[22])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[31])^(x[5]&x[39])^(x[6]&x[6])^(x[6]&x[7])^(x[6]&x[8])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[25])^(x[6]&x[26])^(x[6]&x[27])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[32])^(x[6]&x[35])^(x[6]&x[38])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[20])^(x[7]&x[21])^(x[7]&x[25])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[29])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[37])^(x[7]&x[38])^(x[8]&x[8])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[23])^(x[8]&x[25])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[31])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[39])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[19])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[38])^(x[10]&x[10])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[24])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[36])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[12])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[29])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[34])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[20])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[31])^(x[12]&x[37])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[19])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[29])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[37])^(x[13]&x[38])^(x[14]&x[15])^(x[14]&x[19])^(x[14]&x[20])^(x[14]&x[22])^(x[14]&x[23])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[31])^(x[14]&x[34])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[18])^(x[15]&x[22])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[36])^(x[15]&x[39])^(x[16]&x[17])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[27])^(x[16]&x[31])^(x[16]&x[36])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[30])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[39])^(x[18]&x[20])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[36])^(x[18]&x[39])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[33])^(x[19]&x[34])^(x[19]&x[37])^(x[19]&x[38])^(x[20]&x[20])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[37])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[25])^(x[21]&x[26])^(x[21]&x[27])^(x[21]&x[29])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[27])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[31])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[36])^(x[23]&x[39])^(x[24]&x[28])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[26])^(x[25]&x[28])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[36])^(x[26]&x[37])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[34])^(x[27]&x[36])^(x[27]&x[38])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[38])^(x[29]&x[31])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[37])^(x[30]&x[38])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[36])^(x[32]&x[37])^(x[32]&x[38])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[39])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[37]&x[38])^(x[38]&x[38]);
y[31] = 0^(x[0]&x[3])^(x[0]&x[5])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[34])^(x[0]&x[36])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[7])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[12])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[30])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[38])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[8])^(x[2]&x[11])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[30])^(x[2]&x[32])^(x[2]&x[34])^(x[2]&x[36])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[7])^(x[3]&x[11])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[25])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[11])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[15])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[17])^(x[5]&x[24])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[33])^(x[5]&x[34])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[15])^(x[6]&x[17])^(x[6]&x[19])^(x[6]&x[24])^(x[6]&x[28])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[34])^(x[6]&x[36])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[14])^(x[7]&x[16])^(x[7]&x[17])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[23])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[29])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[36])^(x[8]&x[8])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[13])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[24])^(x[9]&x[26])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[13])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[23])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[30])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[34])^(x[11]&x[35])^(x[12]&x[12])^(x[12]&x[14])^(x[12]&x[17])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[24])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[35])^(x[12]&x[37])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[24])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[33])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[37])^(x[13]&x[38])^(x[14]&x[18])^(x[14]&x[20])^(x[14]&x[21])^(x[14]&x[22])^(x[14]&x[31])^(x[14]&x[32])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[37])^(x[15]&x[15])^(x[15]&x[17])^(x[15]&x[19])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[24])^(x[15]&x[26])^(x[15]&x[29])^(x[15]&x[33])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[38])^(x[15]&x[39])^(x[16]&x[17])^(x[16]&x[20])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[29])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[21])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[22])^(x[18]&x[25])^(x[18]&x[28])^(x[18]&x[31])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[35])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[23])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[35])^(x[19]&x[36])^(x[20]&x[21])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[26])^(x[20]&x[27])^(x[20]&x[31])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[37])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[26])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[33])^(x[21]&x[35])^(x[22]&x[24])^(x[22]&x[26])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[38])^(x[23]&x[23])^(x[23]&x[27])^(x[23]&x[33])^(x[23]&x[35])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[31])^(x[24]&x[33])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[38])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[36])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[34])^(x[27]&x[36])^(x[27]&x[39])^(x[28]&x[29])^(x[28]&x[31])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[38])^(x[28]&x[39])^(x[29]&x[30])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[36])^(x[29]&x[39])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[37])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[37])^(x[32]&x[38])^(x[33]&x[33])^(x[33]&x[35])^(x[33]&x[37])^(x[33]&x[38])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[37])^(x[34]&x[38])^(x[34]&x[39])^(x[35]&x[36])^(x[35]&x[37])^(x[36]&x[37])^(x[38]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[32] = 0^(x[0]&x[1])^(x[0]&x[2])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[14])^(x[0]&x[19])^(x[0]&x[21])^(x[0]&x[26])^(x[0]&x[28])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[37])^(x[1]&x[2])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[9])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[19])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[24])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[36])^(x[1]&x[38])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[13])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[26])^(x[2]&x[29])^(x[2]&x[31])^(x[2]&x[33])^(x[2]&x[34])^(x[2]&x[36])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[16])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[32])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[6])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[16])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[21])^(x[4]&x[25])^(x[4]&x[27])^(x[4]&x[30])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[8])^(x[5]&x[10])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[19])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[26])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[31])^(x[5]&x[34])^(x[5]&x[37])^(x[5]&x[38])^(x[6]&x[6])^(x[6]&x[9])^(x[6]&x[13])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[27])^(x[6]&x[28])^(x[6]&x[31])^(x[6]&x[33])^(x[6]&x[35])^(x[6]&x[37])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[19])^(x[7]&x[21])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[26])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[35])^(x[7]&x[37])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[21])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[32])^(x[8]&x[35])^(x[8]&x[36])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[15])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[38])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[37])^(x[10]&x[38])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[14])^(x[11]&x[16])^(x[11]&x[25])^(x[11]&x[28])^(x[11]&x[31])^(x[11]&x[33])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[25])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[33])^(x[12]&x[36])^(x[12]&x[38])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[18])^(x[14]&x[23])^(x[14]&x[26])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[16])^(x[15]&x[20])^(x[15]&x[24])^(x[15]&x[25])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[31])^(x[15]&x[36])^(x[15]&x[37])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[25])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[29])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[37])^(x[18]&x[19])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[27])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[34])^(x[18]&x[35])^(x[18]&x[37])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[29])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[21])^(x[20]&x[24])^(x[20]&x[32])^(x[20]&x[34])^(x[20]&x[35])^(x[20]&x[39])^(x[21]&x[27])^(x[21]&x[28])^(x[21]&x[29])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[37])^(x[21]&x[38])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[25])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[33])^(x[22]&x[36])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[30])^(x[23]&x[31])^(x[23]&x[34])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[33])^(x[24]&x[36])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[37])^(x[25]&x[38])^(x[26]&x[26])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[36])^(x[28]&x[28])^(x[28]&x[29])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[31])^(x[29]&x[34])^(x[29]&x[37])^(x[29]&x[38])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[34])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[39])^(x[32]&x[33])^(x[32]&x[35])^(x[32]&x[36])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[38])^(x[34]&x[34])^(x[34]&x[39])^(x[35]&x[35])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[38])^(x[36]&x[36])^(x[36]&x[38])^(x[36]&x[39])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[39]);
y[33] = 0^(x[0]&x[1])^(x[0]&x[3])^(x[0]&x[5])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[18])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[32])^(x[0]&x[34])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[8])^(x[1]&x[12])^(x[1]&x[14])^(x[1]&x[15])^(x[1]&x[18])^(x[1]&x[20])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[28])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[37])^(x[2]&x[4])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[11])^(x[2]&x[13])^(x[2]&x[14])^(x[2]&x[16])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[21])^(x[2]&x[29])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[36])^(x[3]&x[5])^(x[3]&x[8])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[31])^(x[3]&x[32])^(x[3]&x[34])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[15])^(x[4]&x[16])^(x[4]&x[19])^(x[4]&x[23])^(x[4]&x[28])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[18])^(x[5]&x[19])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[36])^(x[6]&x[7])^(x[6]&x[9])^(x[6]&x[12])^(x[6]&x[15])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[11])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[17])^(x[7]&x[20])^(x[7]&x[24])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[38])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[16])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[35])^(x[8]&x[37])^(x[8]&x[38])^(x[9]&x[10])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[17])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[29])^(x[9]&x[31])^(x[9]&x[34])^(x[9]&x[37])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[18])^(x[10]&x[20])^(x[10]&x[21])^(x[10]&x[24])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[34])^(x[10]&x[36])^(x[11]&x[11])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[17])^(x[11]&x[22])^(x[11]&x[24])^(x[11]&x[26])^(x[11]&x[27])^(x[11]&x[28])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[34])^(x[11]&x[35])^(x[11]&x[36])^(x[11]&x[37])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[17])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[36])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[14])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[21])^(x[13]&x[23])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[31])^(x[13]&x[32])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[38])^(x[14]&x[14])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[24])^(x[14]&x[27])^(x[14]&x[29])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[37])^(x[14]&x[38])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[29])^(x[15]&x[33])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[38])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[27])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[35])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[29])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[18]&x[18])^(x[18]&x[22])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[30])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[36])^(x[18]&x[37])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[32])^(x[19]&x[34])^(x[19]&x[36])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[23])^(x[20]&x[26])^(x[20]&x[30])^(x[20]&x[31])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[37])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[22])^(x[21]&x[26])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[24])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[36])^(x[22]&x[37])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[30])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[38])^(x[24]&x[25])^(x[24]&x[27])^(x[24]&x[32])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[29])^(x[25]&x[31])^(x[25]&x[33])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[30])^(x[26]&x[35])^(x[26]&x[38])^(x[26]&x[39])^(x[27]&x[27])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[33])^(x[27]&x[35])^(x[27]&x[37])^(x[27]&x[38])^(x[28]&x[28])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[37])^(x[28]&x[38])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[38])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[32])^(x[31]&x[36])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[36])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[35])^(x[33]&x[36])^(x[33]&x[38])^(x[34]&x[34])^(x[34]&x[35])^(x[35]&x[35])^(x[35]&x[36])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[39])^(x[37]&x[39]);
y[34] = 0^(x[0]&x[1])^(x[0]&x[4])^(x[0]&x[8])^(x[0]&x[9])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[20])^(x[0]&x[22])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[32])^(x[0]&x[33])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[11])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[20])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[27])^(x[1]&x[28])^(x[1]&x[29])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[39])^(x[2]&x[2])^(x[2]&x[5])^(x[2]&x[9])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[23])^(x[2]&x[25])^(x[2]&x[27])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[35])^(x[2]&x[37])^(x[2]&x[39])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[6])^(x[3]&x[7])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[12])^(x[3]&x[15])^(x[3]&x[16])^(x[3]&x[19])^(x[3]&x[21])^(x[3]&x[25])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[32])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[23])^(x[4]&x[25])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[33])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[14])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[20])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[39])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[11])^(x[6]&x[13])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[18])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[30])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[10])^(x[7]&x[12])^(x[7]&x[15])^(x[7]&x[16])^(x[7]&x[19])^(x[7]&x[20])^(x[7]&x[23])^(x[7]&x[27])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[36])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[16])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[29])^(x[8]&x[31])^(x[8]&x[34])^(x[8]&x[35])^(x[9]&x[10])^(x[9]&x[11])^(x[9]&x[14])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[26])^(x[9]&x[31])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[38])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[15])^(x[10]&x[19])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[24])^(x[10]&x[30])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[37])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[13])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[26])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[34])^(x[11]&x[39])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[18])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[23])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[36])^(x[12]&x[37])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[25])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[38])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[20])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[31])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[37])^(x[15]&x[15])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[24])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[21])^(x[16]&x[23])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[35])^(x[16]&x[36])^(x[16]&x[37])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[32])^(x[17]&x[33])^(x[17]&x[34])^(x[17]&x[37])^(x[18]&x[18])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[30])^(x[18]&x[32])^(x[18]&x[35])^(x[18]&x[36])^(x[18]&x[37])^(x[18]&x[39])^(x[19]&x[20])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[27])^(x[19]&x[30])^(x[19]&x[32])^(x[19]&x[35])^(x[19]&x[37])^(x[19]&x[38])^(x[20]&x[21])^(x[20]&x[29])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[22])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[26])^(x[21]&x[30])^(x[21]&x[32])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[22]&x[22])^(x[22]&x[24])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[35])^(x[22]&x[37])^(x[22]&x[38])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[29])^(x[23]&x[31])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[24])^(x[24]&x[25])^(x[24]&x[26])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[26])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[37])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[37])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[38])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[35])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[35])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[38])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[36])^(x[31]&x[37])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[33])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[38])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[37])^(x[34]&x[38])^(x[35]&x[35])^(x[35]&x[37])^(x[35]&x[38])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[39])^(x[37]&x[38])^(x[38]&x[38]);
y[35] = 0^(x[0]&x[4])^(x[0]&x[7])^(x[0]&x[9])^(x[0]&x[10])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[19])^(x[0]&x[25])^(x[0]&x[26])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[37])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[1])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[8])^(x[1]&x[9])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[19])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[28])^(x[1]&x[30])^(x[1]&x[33])^(x[1]&x[34])^(x[1]&x[39])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[26])^(x[2]&x[27])^(x[2]&x[28])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[34])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[6])^(x[3]&x[9])^(x[3]&x[12])^(x[3]&x[16])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[22])^(x[3]&x[24])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[30])^(x[3]&x[31])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[38])^(x[4]&x[6])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[11])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[17])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[27])^(x[4]&x[28])^(x[4]&x[29])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[37])^(x[5]&x[5])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[10])^(x[5]&x[12])^(x[5]&x[14])^(x[5]&x[17])^(x[5]&x[20])^(x[5]&x[21])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[33])^(x[5]&x[34])^(x[5]&x[35])^(x[5]&x[38])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[19])^(x[6]&x[21])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[27])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[37])^(x[7]&x[7])^(x[7]&x[9])^(x[7]&x[12])^(x[7]&x[14])^(x[7]&x[16])^(x[7]&x[19])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[28])^(x[7]&x[30])^(x[7]&x[36])^(x[7]&x[37])^(x[8]&x[8])^(x[8]&x[15])^(x[8]&x[20])^(x[8]&x[26])^(x[8]&x[30])^(x[8]&x[35])^(x[8]&x[37])^(x[9]&x[9])^(x[9]&x[12])^(x[9]&x[13])^(x[9]&x[14])^(x[9]&x[15])^(x[9]&x[16])^(x[9]&x[19])^(x[9]&x[21])^(x[9]&x[23])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[13])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[20])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[27])^(x[10]&x[29])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[14])^(x[11]&x[17])^(x[11]&x[18])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[24])^(x[11]&x[25])^(x[11]&x[28])^(x[11]&x[33])^(x[11]&x[36])^(x[11]&x[37])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[19])^(x[12]&x[20])^(x[12]&x[21])^(x[12]&x[22])^(x[12]&x[24])^(x[12]&x[27])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[37])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[21])^(x[13]&x[22])^(x[13]&x[23])^(x[13]&x[24])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[29])^(x[13]&x[32])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[39])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[20])^(x[14]&x[21])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[35])^(x[14]&x[36])^(x[14]&x[38])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[20])^(x[15]&x[23])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[37])^(x[15]&x[38])^(x[15]&x[39])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[22])^(x[16]&x[23])^(x[16]&x[26])^(x[16]&x[27])^(x[16]&x[29])^(x[16]&x[35])^(x[16]&x[38])^(x[16]&x[39])^(x[17]&x[19])^(x[17]&x[20])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[27])^(x[17]&x[28])^(x[17]&x[29])^(x[17]&x[34])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[38])^(x[18]&x[25])^(x[18]&x[33])^(x[18]&x[35])^(x[18]&x[39])^(x[19]&x[23])^(x[19]&x[28])^(x[19]&x[30])^(x[19]&x[31])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[35])^(x[20]&x[36])^(x[20]&x[37])^(x[20]&x[38])^(x[21]&x[23])^(x[21]&x[24])^(x[21]&x[27])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[33])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[23])^(x[22]&x[27])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[38])^(x[22]&x[39])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[27])^(x[23]&x[29])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[39])^(x[24]&x[26])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[34])^(x[24]&x[37])^(x[24]&x[38])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[36])^(x[26]&x[37])^(x[27]&x[28])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[33])^(x[27]&x[36])^(x[28]&x[30])^(x[28]&x[31])^(x[28]&x[33])^(x[28]&x[36])^(x[28]&x[38])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[33])^(x[29]&x[38])^(x[30]&x[31])^(x[30]&x[34])^(x[30]&x[35])^(x[30]&x[36])^(x[30]&x[37])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[33])^(x[31]&x[34])^(x[32]&x[33])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[33]&x[33])^(x[33]&x[37])^(x[33]&x[39])^(x[34]&x[34])^(x[34]&x[35])^(x[34]&x[36])^(x[34]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[37]&x[38])^(x[37]&x[39])^(x[38]&x[39]);
y[36] = 0^(x[0]&x[3])^(x[0]&x[6])^(x[0]&x[11])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[17])^(x[0]&x[20])^(x[0]&x[21])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[31])^(x[0]&x[33])^(x[0]&x[34])^(x[0]&x[36])^(x[0]&x[39])^(x[1]&x[2])^(x[1]&x[3])^(x[1]&x[5])^(x[1]&x[6])^(x[1]&x[7])^(x[1]&x[9])^(x[1]&x[13])^(x[1]&x[16])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[20])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[32])^(x[1]&x[33])^(x[1]&x[35])^(x[1]&x[36])^(x[1]&x[37])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[17])^(x[2]&x[19])^(x[2]&x[23])^(x[2]&x[25])^(x[2]&x[27])^(x[2]&x[31])^(x[2]&x[32])^(x[2]&x[33])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[39])^(x[3]&x[3])^(x[3]&x[4])^(x[3]&x[5])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[24])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[31])^(x[3]&x[32])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[37])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[5])^(x[4]&x[16])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[26])^(x[4]&x[27])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[36])^(x[4]&x[38])^(x[4]&x[39])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[22])^(x[5]&x[23])^(x[5]&x[24])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[37])^(x[6]&x[6])^(x[6]&x[8])^(x[6]&x[10])^(x[6]&x[12])^(x[6]&x[19])^(x[6]&x[21])^(x[6]&x[26])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[37])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[17])^(x[7]&x[19])^(x[7]&x[23])^(x[7]&x[24])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[33])^(x[7]&x[34])^(x[7]&x[35])^(x[7]&x[37])^(x[7]&x[38])^(x[7]&x[39])^(x[8]&x[8])^(x[8]&x[12])^(x[8]&x[15])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[27])^(x[8]&x[28])^(x[8]&x[32])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[10])^(x[9]&x[16])^(x[9]&x[18])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[25])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[34])^(x[9]&x[36])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[11])^(x[10]&x[12])^(x[10]&x[13])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[16])^(x[10]&x[18])^(x[10]&x[20])^(x[10]&x[22])^(x[10]&x[23])^(x[10]&x[24])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[33])^(x[10]&x[36])^(x[11]&x[13])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[17])^(x[11]&x[20])^(x[11]&x[24])^(x[11]&x[34])^(x[11]&x[36])^(x[11]&x[38])^(x[11]&x[39])^(x[12]&x[14])^(x[12]&x[16])^(x[12]&x[17])^(x[12]&x[20])^(x[12]&x[25])^(x[12]&x[26])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[31])^(x[12]&x[33])^(x[12]&x[38])^(x[12]&x[39])^(x[13]&x[16])^(x[13]&x[17])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[23])^(x[13]&x[29])^(x[13]&x[30])^(x[13]&x[32])^(x[14]&x[16])^(x[14]&x[18])^(x[14]&x[20])^(x[14]&x[22])^(x[14]&x[23])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[34])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[27])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[21])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[31])^(x[16]&x[33])^(x[16]&x[35])^(x[16]&x[36])^(x[17]&x[19])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[27])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[35])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[19])^(x[18]&x[26])^(x[18]&x[30])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[35])^(x[18]&x[38])^(x[18]&x[39])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[19]&x[38])^(x[19]&x[39])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[25])^(x[20]&x[29])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[34])^(x[20]&x[36])^(x[20]&x[38])^(x[21]&x[22])^(x[21]&x[27])^(x[21]&x[30])^(x[21]&x[31])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[36])^(x[21]&x[37])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[25])^(x[22]&x[28])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[37])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[26])^(x[23]&x[30])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[35])^(x[23]&x[37])^(x[23]&x[39])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[25])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[39])^(x[26]&x[28])^(x[26]&x[29])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[27]&x[29])^(x[27]&x[31])^(x[27]&x[33])^(x[27]&x[35])^(x[27]&x[37])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[33])^(x[28]&x[37])^(x[29]&x[29])^(x[29]&x[30])^(x[29]&x[32])^(x[29]&x[33])^(x[29]&x[36])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[39])^(x[31]&x[36])^(x[31]&x[37])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[32])^(x[32]&x[33])^(x[32]&x[34])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[35])^(x[33]&x[37])^(x[34]&x[34])^(x[34]&x[36])^(x[34]&x[37])^(x[35]&x[39])^(x[36]&x[37])^(x[36]&x[39])^(x[38]&x[38])^(x[38]&x[39]);
y[37] = 0^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[9])^(x[0]&x[11])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[15])^(x[0]&x[16])^(x[0]&x[17])^(x[0]&x[18])^(x[0]&x[21])^(x[0]&x[22])^(x[0]&x[28])^(x[0]&x[29])^(x[0]&x[30])^(x[0]&x[34])^(x[0]&x[38])^(x[0]&x[39])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[8])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[16])^(x[1]&x[19])^(x[1]&x[21])^(x[1]&x[22])^(x[1]&x[23])^(x[1]&x[25])^(x[1]&x[28])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[38])^(x[2]&x[3])^(x[2]&x[5])^(x[2]&x[6])^(x[2]&x[8])^(x[2]&x[9])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[23])^(x[2]&x[25])^(x[2]&x[26])^(x[2]&x[30])^(x[2]&x[31])^(x[2]&x[34])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[38])^(x[2]&x[39])^(x[3]&x[6])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[12])^(x[3]&x[13])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[20])^(x[3]&x[21])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[28])^(x[3]&x[32])^(x[3]&x[34])^(x[3]&x[37])^(x[3]&x[38])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[9])^(x[4]&x[10])^(x[4]&x[12])^(x[4]&x[15])^(x[4]&x[18])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[25])^(x[4]&x[29])^(x[4]&x[30])^(x[4]&x[31])^(x[4]&x[32])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[10])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[17])^(x[5]&x[18])^(x[5]&x[22])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[32])^(x[5]&x[34])^(x[5]&x[37])^(x[6]&x[7])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[14])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[25])^(x[6]&x[27])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[18])^(x[7]&x[20])^(x[7]&x[22])^(x[7]&x[23])^(x[7]&x[27])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[32])^(x[7]&x[33])^(x[7]&x[37])^(x[7]&x[38])^(x[8]&x[9])^(x[8]&x[11])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[19])^(x[8]&x[21])^(x[8]&x[22])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[26])^(x[8]&x[30])^(x[8]&x[33])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[9])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[17])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[23])^(x[9]&x[24])^(x[9]&x[30])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[36])^(x[9]&x[37])^(x[9]&x[38])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[14])^(x[10]&x[15])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[21])^(x[10]&x[22])^(x[10]&x[25])^(x[10]&x[30])^(x[10]&x[31])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[36])^(x[11]&x[15])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[20])^(x[11]&x[22])^(x[11]&x[24])^(x[11]&x[26])^(x[11]&x[28])^(x[11]&x[31])^(x[11]&x[32])^(x[11]&x[38])^(x[12]&x[14])^(x[12]&x[23])^(x[12]&x[25])^(x[12]&x[28])^(x[12]&x[29])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[32])^(x[12]&x[33])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[39])^(x[13]&x[13])^(x[13]&x[15])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[21])^(x[13]&x[25])^(x[13]&x[26])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[31])^(x[13]&x[33])^(x[13]&x[34])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[37])^(x[13]&x[38])^(x[14]&x[14])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[21])^(x[14]&x[22])^(x[14]&x[26])^(x[14]&x[27])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[32])^(x[14]&x[33])^(x[14]&x[37])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[17])^(x[15]&x[18])^(x[15]&x[19])^(x[15]&x[20])^(x[15]&x[21])^(x[15]&x[22])^(x[15]&x[24])^(x[15]&x[29])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[34])^(x[15]&x[37])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[20])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[38])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[22])^(x[17]&x[23])^(x[17]&x[24])^(x[17]&x[25])^(x[17]&x[26])^(x[17]&x[32])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[39])^(x[18]&x[19])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[28])^(x[18]&x[33])^(x[18]&x[35])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[25])^(x[20]&x[27])^(x[20]&x[28])^(x[20]&x[29])^(x[20]&x[30])^(x[20]&x[32])^(x[21]&x[21])^(x[21]&x[23])^(x[21]&x[26])^(x[21]&x[29])^(x[21]&x[32])^(x[21]&x[33])^(x[21]&x[35])^(x[21]&x[38])^(x[22]&x[23])^(x[22]&x[24])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[28])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[31])^(x[22]&x[33])^(x[22]&x[34])^(x[22]&x[35])^(x[22]&x[36])^(x[22]&x[39])^(x[23]&x[28])^(x[23]&x[29])^(x[23]&x[32])^(x[23]&x[36])^(x[23]&x[38])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[29])^(x[24]&x[31])^(x[24]&x[34])^(x[24]&x[39])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[35])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[26])^(x[26]&x[29])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[36])^(x[26]&x[37])^(x[26]&x[38])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[33])^(x[27]&x[34])^(x[27]&x[35])^(x[27]&x[38])^(x[28]&x[31])^(x[28]&x[32])^(x[28]&x[34])^(x[28]&x[35])^(x[28]&x[36])^(x[28]&x[38])^(x[29]&x[30])^(x[29]&x[33])^(x[29]&x[34])^(x[29]&x[36])^(x[30]&x[30])^(x[30]&x[33])^(x[30]&x[37])^(x[31]&x[32])^(x[31]&x[34])^(x[31]&x[35])^(x[31]&x[36])^(x[31]&x[38])^(x[31]&x[39])^(x[32]&x[32])^(x[32]&x[38])^(x[33]&x[34])^(x[33]&x[38])^(x[34]&x[36])^(x[34]&x[37])^(x[35]&x[37])^(x[35]&x[38])^(x[35]&x[39])^(x[36]&x[36])^(x[36]&x[37])^(x[36]&x[38])^(x[36]&x[39])^(x[39]&x[39]);
y[38] = 0^(x[0]&x[3])^(x[0]&x[4])^(x[0]&x[5])^(x[0]&x[9])^(x[0]&x[16])^(x[0]&x[22])^(x[0]&x[24])^(x[0]&x[27])^(x[0]&x[28])^(x[0]&x[34])^(x[0]&x[35])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[3])^(x[1]&x[8])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[12])^(x[1]&x[15])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[21])^(x[1]&x[23])^(x[1]&x[26])^(x[1]&x[27])^(x[1]&x[29])^(x[1]&x[30])^(x[1]&x[31])^(x[1]&x[35])^(x[2]&x[4])^(x[2]&x[6])^(x[2]&x[7])^(x[2]&x[8])^(x[2]&x[12])^(x[2]&x[17])^(x[2]&x[19])^(x[2]&x[23])^(x[2]&x[24])^(x[2]&x[25])^(x[2]&x[28])^(x[2]&x[33])^(x[2]&x[35])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[4])^(x[3]&x[7])^(x[3]&x[9])^(x[3]&x[10])^(x[3]&x[11])^(x[3]&x[13])^(x[3]&x[18])^(x[3]&x[19])^(x[3]&x[21])^(x[3]&x[24])^(x[3]&x[25])^(x[3]&x[26])^(x[3]&x[27])^(x[3]&x[28])^(x[3]&x[29])^(x[3]&x[32])^(x[3]&x[33])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[38])^(x[4]&x[5])^(x[4]&x[7])^(x[4]&x[9])^(x[4]&x[12])^(x[4]&x[13])^(x[4]&x[14])^(x[4]&x[22])^(x[4]&x[24])^(x[4]&x[33])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[37])^(x[4]&x[38])^(x[5]&x[6])^(x[5]&x[7])^(x[5]&x[8])^(x[5]&x[9])^(x[5]&x[11])^(x[5]&x[12])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[19])^(x[5]&x[24])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[29])^(x[5]&x[30])^(x[5]&x[31])^(x[5]&x[32])^(x[5]&x[35])^(x[5]&x[36])^(x[5]&x[37])^(x[5]&x[38])^(x[6]&x[8])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[14])^(x[6]&x[15])^(x[6]&x[16])^(x[6]&x[17])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[22])^(x[6]&x[23])^(x[6]&x[24])^(x[6]&x[28])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[33])^(x[6]&x[36])^(x[6]&x[39])^(x[7]&x[8])^(x[7]&x[9])^(x[7]&x[11])^(x[7]&x[13])^(x[7]&x[14])^(x[7]&x[15])^(x[7]&x[19])^(x[7]&x[20])^(x[7]&x[26])^(x[7]&x[27])^(x[7]&x[28])^(x[7]&x[29])^(x[7]&x[30])^(x[7]&x[31])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[39])^(x[8]&x[9])^(x[8]&x[10])^(x[8]&x[11])^(x[8]&x[12])^(x[8]&x[15])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[21])^(x[8]&x[25])^(x[8]&x[28])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[36])^(x[8]&x[37])^(x[8]&x[38])^(x[8]&x[39])^(x[9]&x[11])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[17])^(x[9]&x[18])^(x[9]&x[20])^(x[9]&x[22])^(x[9]&x[24])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[33])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[37])^(x[9]&x[39])^(x[10]&x[10])^(x[10]&x[14])^(x[10]&x[17])^(x[10]&x[18])^(x[10]&x[19])^(x[10]&x[27])^(x[10]&x[29])^(x[10]&x[30])^(x[10]&x[32])^(x[10]&x[33])^(x[10]&x[35])^(x[10]&x[36])^(x[10]&x[39])^(x[11]&x[11])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[16])^(x[11]&x[18])^(x[11]&x[19])^(x[11]&x[21])^(x[11]&x[22])^(x[11]&x[23])^(x[11]&x[29])^(x[11]&x[30])^(x[11]&x[32])^(x[11]&x[33])^(x[11]&x[36])^(x[11]&x[38])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[14])^(x[12]&x[17])^(x[12]&x[24])^(x[12]&x[25])^(x[12]&x[27])^(x[12]&x[30])^(x[12]&x[31])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[38])^(x[13]&x[13])^(x[13]&x[14])^(x[13]&x[15])^(x[13]&x[16])^(x[13]&x[18])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[24])^(x[13]&x[27])^(x[13]&x[28])^(x[13]&x[31])^(x[13]&x[35])^(x[14]&x[14])^(x[14]&x[16])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[21])^(x[14]&x[22])^(x[14]&x[24])^(x[14]&x[26])^(x[14]&x[28])^(x[14]&x[29])^(x[14]&x[30])^(x[14]&x[31])^(x[14]&x[35])^(x[14]&x[37])^(x[14]&x[38])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[20])^(x[15]&x[22])^(x[15]&x[25])^(x[15]&x[26])^(x[15]&x[28])^(x[15]&x[29])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[34])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[16]&x[17])^(x[16]&x[18])^(x[16]&x[19])^(x[16]&x[22])^(x[16]&x[24])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[32])^(x[16]&x[33])^(x[16]&x[34])^(x[16]&x[39])^(x[17]&x[17])^(x[17]&x[18])^(x[17]&x[19])^(x[17]&x[21])^(x[17]&x[23])^(x[17]&x[25])^(x[17]&x[28])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[32])^(x[17]&x[34])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[18])^(x[18]&x[19])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[24])^(x[18]&x[26])^(x[18]&x[30])^(x[18]&x[32])^(x[18]&x[33])^(x[18]&x[34])^(x[18]&x[35])^(x[18]&x[36])^(x[18]&x[37])^(x[18]&x[39])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[21])^(x[19]&x[22])^(x[19]&x[24])^(x[19]&x[25])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[30])^(x[19]&x[32])^(x[19]&x[33])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[39])^(x[20]&x[20])^(x[20]&x[21])^(x[20]&x[22])^(x[20]&x[26])^(x[20]&x[33])^(x[20]&x[35])^(x[20]&x[39])^(x[21]&x[21])^(x[21]&x[22])^(x[21]&x[26])^(x[21]&x[28])^(x[21]&x[34])^(x[21]&x[35])^(x[21]&x[36])^(x[21]&x[37])^(x[21]&x[39])^(x[22]&x[22])^(x[22]&x[23])^(x[22]&x[25])^(x[22]&x[27])^(x[22]&x[30])^(x[22]&x[32])^(x[22]&x[33])^(x[22]&x[35])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[30])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[33])^(x[23]&x[34])^(x[23]&x[36])^(x[23]&x[37])^(x[23]&x[38])^(x[23]&x[39])^(x[24]&x[26])^(x[24]&x[27])^(x[24]&x[28])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[37])^(x[24]&x[38])^(x[24]&x[39])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[30])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[33])^(x[25]&x[34])^(x[25]&x[35])^(x[25]&x[36])^(x[26]&x[26])^(x[26]&x[30])^(x[26]&x[31])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[36])^(x[27]&x[29])^(x[27]&x[32])^(x[27]&x[33])^(x[27]&x[36])^(x[27]&x[39])^(x[28]&x[28])^(x[28]&x[30])^(x[28]&x[31])^(x[28]&x[33])^(x[28]&x[34])^(x[28]&x[36])^(x[28]&x[37])^(x[28]&x[39])^(x[29]&x[29])^(x[29]&x[31])^(x[29]&x[32])^(x[29]&x[39])^(x[30]&x[30])^(x[30]&x[31])^(x[30]&x[32])^(x[30]&x[33])^(x[30]&x[34])^(x[30]&x[36])^(x[30]&x[38])^(x[30]&x[39])^(x[31]&x[31])^(x[31]&x[38])^(x[32]&x[32])^(x[32]&x[34])^(x[32]&x[35])^(x[33]&x[39])^(x[34]&x[38])^(x[35]&x[36])^(x[35]&x[37])^(x[35]&x[38])^(x[36]&x[36])^(x[37]&x[37])^(x[37]&x[38])^(x[38]&x[39])^(x[39]&x[39]);
y[39] = 0^(x[0]&x[5])^(x[0]&x[6])^(x[0]&x[7])^(x[0]&x[12])^(x[0]&x[13])^(x[0]&x[14])^(x[0]&x[17])^(x[0]&x[18])^(x[0]&x[21])^(x[0]&x[23])^(x[0]&x[24])^(x[0]&x[25])^(x[0]&x[28])^(x[0]&x[30])^(x[0]&x[31])^(x[0]&x[36])^(x[0]&x[37])^(x[0]&x[38])^(x[1]&x[3])^(x[1]&x[4])^(x[1]&x[6])^(x[1]&x[10])^(x[1]&x[11])^(x[1]&x[13])^(x[1]&x[15])^(x[1]&x[16])^(x[1]&x[17])^(x[1]&x[18])^(x[1]&x[19])^(x[1]&x[23])^(x[1]&x[24])^(x[1]&x[25])^(x[1]&x[26])^(x[1]&x[31])^(x[1]&x[34])^(x[2]&x[3])^(x[2]&x[4])^(x[2]&x[5])^(x[2]&x[7])^(x[2]&x[10])^(x[2]&x[11])^(x[2]&x[12])^(x[2]&x[14])^(x[2]&x[15])^(x[2]&x[16])^(x[2]&x[17])^(x[2]&x[18])^(x[2]&x[19])^(x[2]&x[20])^(x[2]&x[21])^(x[2]&x[22])^(x[2]&x[24])^(x[2]&x[29])^(x[2]&x[30])^(x[2]&x[34])^(x[2]&x[36])^(x[2]&x[37])^(x[2]&x[38])^(x[3]&x[4])^(x[3]&x[6])^(x[3]&x[8])^(x[3]&x[9])^(x[3]&x[11])^(x[3]&x[14])^(x[3]&x[15])^(x[3]&x[17])^(x[3]&x[18])^(x[3]&x[20])^(x[3]&x[22])^(x[3]&x[23])^(x[3]&x[25])^(x[3]&x[29])^(x[3]&x[32])^(x[3]&x[34])^(x[3]&x[35])^(x[3]&x[36])^(x[3]&x[39])^(x[4]&x[4])^(x[4]&x[5])^(x[4]&x[6])^(x[4]&x[7])^(x[4]&x[8])^(x[4]&x[13])^(x[4]&x[15])^(x[4]&x[18])^(x[4]&x[19])^(x[4]&x[20])^(x[4]&x[21])^(x[4]&x[22])^(x[4]&x[23])^(x[4]&x[24])^(x[4]&x[26])^(x[4]&x[28])^(x[4]&x[30])^(x[4]&x[32])^(x[4]&x[33])^(x[4]&x[34])^(x[4]&x[35])^(x[4]&x[36])^(x[4]&x[38])^(x[5]&x[5])^(x[5]&x[6])^(x[5]&x[8])^(x[5]&x[11])^(x[5]&x[13])^(x[5]&x[14])^(x[5]&x[15])^(x[5]&x[16])^(x[5]&x[17])^(x[5]&x[22])^(x[5]&x[25])^(x[5]&x[26])^(x[5]&x[27])^(x[5]&x[28])^(x[5]&x[31])^(x[5]&x[34])^(x[5]&x[36])^(x[5]&x[37])^(x[5]&x[38])^(x[5]&x[39])^(x[6]&x[6])^(x[6]&x[7])^(x[6]&x[9])^(x[6]&x[10])^(x[6]&x[11])^(x[6]&x[12])^(x[6]&x[18])^(x[6]&x[19])^(x[6]&x[20])^(x[6]&x[21])^(x[6]&x[23])^(x[6]&x[25])^(x[6]&x[26])^(x[6]&x[29])^(x[6]&x[30])^(x[6]&x[31])^(x[6]&x[32])^(x[6]&x[34])^(x[6]&x[35])^(x[6]&x[36])^(x[6]&x[37])^(x[6]&x[38])^(x[6]&x[39])^(x[7]&x[7])^(x[7]&x[8])^(x[7]&x[12])^(x[7]&x[13])^(x[7]&x[15])^(x[7]&x[21])^(x[7]&x[24])^(x[7]&x[25])^(x[7]&x[28])^(x[7]&x[33])^(x[7]&x[35])^(x[7]&x[36])^(x[7]&x[37])^(x[7]&x[38])^(x[7]&x[39])^(x[8]&x[10])^(x[8]&x[12])^(x[8]&x[13])^(x[8]&x[14])^(x[8]&x[15])^(x[8]&x[16])^(x[8]&x[17])^(x[8]&x[18])^(x[8]&x[20])^(x[8]&x[21])^(x[8]&x[23])^(x[8]&x[24])^(x[8]&x[25])^(x[8]&x[26])^(x[8]&x[27])^(x[8]&x[29])^(x[8]&x[30])^(x[8]&x[31])^(x[8]&x[33])^(x[8]&x[35])^(x[8]&x[37])^(x[8]&x[38])^(x[9]&x[9])^(x[9]&x[12])^(x[9]&x[14])^(x[9]&x[16])^(x[9]&x[18])^(x[9]&x[19])^(x[9]&x[20])^(x[9]&x[21])^(x[9]&x[26])^(x[9]&x[27])^(x[9]&x[28])^(x[9]&x[29])^(x[9]&x[31])^(x[9]&x[32])^(x[9]&x[34])^(x[9]&x[35])^(x[9]&x[36])^(x[9]&x[39])^(x[10]&x[11])^(x[10]&x[14])^(x[10]&x[18])^(x[10]&x[23])^(x[10]&x[25])^(x[10]&x[26])^(x[10]&x[28])^(x[10]&x[29])^(x[10]&x[34])^(x[10]&x[35])^(x[10]&x[38])^(x[11]&x[11])^(x[11]&x[12])^(x[11]&x[14])^(x[11]&x[15])^(x[11]&x[30])^(x[11]&x[33])^(x[11]&x[39])^(x[12]&x[12])^(x[12]&x[13])^(x[12]&x[15])^(x[12]&x[16])^(x[12]&x[20])^(x[12]&x[22])^(x[12]&x[26])^(x[12]&x[27])^(x[12]&x[28])^(x[12]&x[30])^(x[12]&x[32])^(x[12]&x[34])^(x[12]&x[35])^(x[12]&x[38])^(x[13]&x[17])^(x[13]&x[19])^(x[13]&x[20])^(x[13]&x[23])^(x[13]&x[26])^(x[13]&x[29])^(x[13]&x[31])^(x[13]&x[35])^(x[13]&x[36])^(x[13]&x[38])^(x[13]&x[39])^(x[14]&x[15])^(x[14]&x[17])^(x[14]&x[18])^(x[14]&x[19])^(x[14]&x[23])^(x[14]&x[25])^(x[14]&x[26])^(x[14]&x[32])^(x[14]&x[34])^(x[14]&x[36])^(x[14]&x[39])^(x[15]&x[15])^(x[15]&x[16])^(x[15]&x[18])^(x[15]&x[20])^(x[15]&x[26])^(x[15]&x[27])^(x[15]&x[29])^(x[15]&x[30])^(x[15]&x[31])^(x[15]&x[32])^(x[15]&x[33])^(x[15]&x[35])^(x[15]&x[36])^(x[15]&x[37])^(x[15]&x[38])^(x[16]&x[16])^(x[16]&x[19])^(x[16]&x[20])^(x[16]&x[25])^(x[16]&x[27])^(x[16]&x[28])^(x[16]&x[29])^(x[16]&x[32])^(x[16]&x[34])^(x[16]&x[35])^(x[17]&x[17])^(x[17]&x[19])^(x[17]&x[26])^(x[17]&x[27])^(x[17]&x[30])^(x[17]&x[31])^(x[17]&x[33])^(x[17]&x[35])^(x[17]&x[36])^(x[17]&x[37])^(x[17]&x[38])^(x[17]&x[39])^(x[18]&x[20])^(x[18]&x[21])^(x[18]&x[22])^(x[18]&x[23])^(x[18]&x[25])^(x[18]&x[26])^(x[18]&x[27])^(x[18]&x[30])^(x[18]&x[31])^(x[18]&x[34])^(x[18]&x[36])^(x[19]&x[19])^(x[19]&x[20])^(x[19]&x[22])^(x[19]&x[23])^(x[19]&x[24])^(x[19]&x[26])^(x[19]&x[27])^(x[19]&x[28])^(x[19]&x[29])^(x[19]&x[30])^(x[19]&x[34])^(x[19]&x[35])^(x[19]&x[36])^(x[19]&x[37])^(x[19]&x[39])^(x[20]&x[22])^(x[20]&x[23])^(x[20]&x[24])^(x[20]&x[26])^(x[20]&x[30])^(x[20]&x[32])^(x[20]&x[33])^(x[20]&x[35])^(x[20]&x[38])^(x[20]&x[39])^(x[21]&x[24])^(x[21]&x[25])^(x[21]&x[28])^(x[21]&x[30])^(x[21]&x[33])^(x[21]&x[34])^(x[21]&x[37])^(x[21]&x[38])^(x[22]&x[25])^(x[22]&x[26])^(x[22]&x[27])^(x[22]&x[29])^(x[22]&x[30])^(x[22]&x[36])^(x[22]&x[37])^(x[22]&x[39])^(x[23]&x[23])^(x[23]&x[24])^(x[23]&x[25])^(x[23]&x[26])^(x[23]&x[27])^(x[23]&x[29])^(x[23]&x[30])^(x[23]&x[31])^(x[23]&x[32])^(x[23]&x[35])^(x[23]&x[36])^(x[24]&x[26])^(x[24]&x[30])^(x[24]&x[31])^(x[24]&x[32])^(x[24]&x[33])^(x[24]&x[34])^(x[24]&x[35])^(x[24]&x[36])^(x[24]&x[39])^(x[25]&x[26])^(x[25]&x[27])^(x[25]&x[28])^(x[25]&x[29])^(x[25]&x[31])^(x[25]&x[32])^(x[25]&x[34])^(x[25]&x[36])^(x[25]&x[37])^(x[25]&x[38])^(x[25]&x[39])^(x[26]&x[27])^(x[26]&x[28])^(x[26]&x[30])^(x[26]&x[32])^(x[26]&x[33])^(x[26]&x[34])^(x[26]&x[35])^(x[26]&x[37])^(x[27]&x[27])^(x[27]&x[28])^(x[27]&x[29])^(x[27]&x[30])^(x[27]&x[31])^(x[27]&x[32])^(x[27]&x[36])^(x[27]&x[39])^(x[28]&x[29])^(x[28]&x[30])^(x[28]&x[32])^(x[28]&x[38])^(x[29]&x[34])^(x[29]&x[35])^(x[29]&x[39])^(x[30]&x[33])^(x[30]&x[35])^(x[30]&x[36])^(x[31]&x[32])^(x[31]&x[33])^(x[31]&x[34])^(x[31]&x[37])^(x[32]&x[34])^(x[32]&x[35])^(x[32]&x[37])^(x[32]&x[39])^(x[33]&x[33])^(x[33]&x[34])^(x[33]&x[36])^(x[33]&x[38])^(x[33]&x[39])^(x[34]&x[34])^(x[34]&x[37])^(x[35]&x[35])^(x[35]&x[39])^(x[36]&x[37])^(x[36]&x[39])^(x[37]&x[37])^(x[39]&x[39]);

    // convert bits to output
    UINT64 result = 0;

    for(INT i=0; i<40; ++i)
        if(y[i])
            result |= ((UINT64)1<<i);

    return (result == name);
}




