#include <miracl.h> 
#include "md5c.c"

int CheckLicense( char * lpName, char * license )
{
    int status;
    unsigned char szHash[41] = {0};
    MD5_CTX context;
    
    miracl *mip=mirsys(500,16);  /* base 0, 50 digits par big  */
    big M        =mirvar(0);
    big Hash_M   =mirvar(0);    
    big N        =mirvar(0);


    mip->IOBASE=16;
    cinstr(N,"9BE29093439A7855DFF27D74C7BCAC60FECA520AE10F82EB7493BEE6D100C501C0D10088593098FCBFD476B2F3EA27961AB362076F3640B91B761CD664A5115D38C391D6671CE9E0E1C05785A85C477F171FE3B32359D74F599A46381974D20A5C6F873C2FCDA0BB0A5730C5D3925FA1FF2FA8D7FDDBBF84F860D5531EADB66D");
    cinstr(M,license);  
      
    MD5Init(&context);
    MD5Update(&context, lpName, strlen(lpName));
    MD5Final(szHash, &context);
    bytes_to_big(16,szHash,Hash_M);  
     
    power(M,65537,N,M);
    status = compare(M,Hash_M);
    
    mirkill(M);
    mirkill(Hash_M);
    mirkill(N);
    mirexit();
    return status;
}


