# ShmooCon 2011 Crypto Challenges - Challenge 5
# 
# difficulty: 6/9 (too many clues here!)
#
# example keys:
#
#          AcidBurn 0841764548280084481-9499849483526563429
#          ZeroCool 2661499048212306902-5055640594654910056
#      CerealKiller 4552765060758858095-0072992698253694475
#     CrashOverride 4795610244957889545-9279851027665587529
#     PhantomPhreak 1244969805179441937-3652959212268739476

import sys
import random

#------------------------------------------------------------------------------
# GLOBAL PARAMETERS
#------------------------------------------------------------------------------
p = 9524793152874449521
extension = 12
ef_poly = [   6927354994984596761, 3748481628317431011, 4620394961492627319, 5139526688006885996, 
              7434977584397438745, 5869627458528271108, 6614627009312766654, 7678097075714978717, 
              5204744523362322329, 9398406610703021891, 3699077701165988134, 4097988535177883106, 1 ]
field_0 = [0]*extension
field_1 = [1]+[0]*(extension-1)
field_2 = [2]+[0]*(extension-1)
field_3 = [3]+[0]*(extension-1)
[a_1,a_2,a_3,a_4,a_6] = [field_0, field_0, field_0, field_0, [13]+[0]*(extension-1)]
ecc_0 = [field_0, field_1, field_0]
ecc_r = 9524793149788155121
ecc_g1 = [field_1, [4577206343548535956]+[0]*(extension-1), field_1]
ecc_g2 = [ [ 2582477270547956977, 2530023797852594208, 3239246275650681784, 9356115311475410715, 
             4925994372571715422, 9082757750092742366, 3946459769382694037, 9258625410126221791, 
             1546806533803993509, 7416446501236864153, 3476916985694553167, 28930072329430674    ],
           [ 544373368025887171,  8874621118513866374, 8009494946720473686, 1065433853209237195, 
             1956558743620835276, 7323759157123465679, 2253879482993753613, 3769727620341931341, 
             2471082114350274565, 53398003196643395,   392122047555439583,  4569041207989982512  ],
             field_1 ]
ecc_P =  [ [ 6400173802196845754, 474243480778556212,  5936146128578535690, 1305341026780126317, 
             832499822664426562,  5522347192587339249, 6887819078187130363, 7183243026634094341, 
             5513000999900352828, 6346523241154805362, 7779915664763212307, 9234041514029458289  ],
           [ 122495515023342804,  6985863117841018225, 171210160812342620,  8053089739653482422, 
             318194623178172360,  8111126461946895687, 915090504523216963,  5152204995298522178, 
             212427926173001815,  359467867455554913,  3816268899954016796, 4965553112357672903  ],
             field_1 ]

"""
you use open tools? rewards!

PARI/GP CODE:
p = 9524793152874449521
r = 9524793149788155121
irred = 6927354994984596761 + 3748481628317431011*x^1 + 4620394961492627319*x^2 + 5139526688006885996*x^3 + 7434977584397438745*x^4 + 5869627458528271108*x^5 + 6614627009312766654*x^6 + 7678097075714978717*x^7 + 5204744523362322329*x^8 + 9398406610703021891*x^9 + 3699077701165988134*x^10 + 4097988535177883106*x^11 + 1*x^12
E = ellinit([0,0,0,0,13]
g1 = [1,4577206343548535956]
g2_x = 2582477270547956977 + 2530023797852594208*x^1 + 3239246275650681784*x^2 + 9356115311475410715*x^3 + 4925994372571715422*x^4 + 9082757750092742366*x^5 + 3946459769382694037*x^6 + 9258625410126221791*x^7 + 1546806533803993509*x^8 + 7416446501236864153*x^9 + 3476916985694553167*x^10 + 28930072329430674*x^11
g2_y = 544373368025887171 + 8874621118513866374*x^1 + 8009494946720473686*x^2 + 1065433853209237195*x^3 + 1956558743620835276*x^4 + 7323759157123465679*x^5 + 2253879482993753613*x^6 + 3769727620341931341*x^7 + 2471082114350274565*x^8 + 53398003196643395*x^9 +  392122047555439583*x^10 + 4569041207989982512*x^11
g2 = [g2_x,g2_y]

SAGE CODE:
p = 9524793152874449521
r = 9524793149788155121
F.<a> = GF(p)[]
irred = 6927354994984596761 + 3748481628317431011*a^1 + 4620394961492627319*a^2 + 5139526688006885996*a^3 + 7434977584397438745*a^4 + 5869627458528271108*a^5 + 6614627009312766654*a^6 + 7678097075714978717*a^7 + 5204744523362322329*a^8 + 9398406610703021891*a^9 + 3699077701165988134*a^10 + 4097988535177883106*a^11 + 1*a^12
K.<b> = GF(p^12, modulus=irred)
E = EllipticCurve(K,[0,0,0,0,13])
g1 = E([1,4577206343548535956,1])
g2_x = 2582477270547956977 + 2530023797852594208*a^1 + 3239246275650681784*a^2 + 9356115311475410715*a^3 + 4925994372571715422*a^4 + 9082757750092742366*a^5 + 3946459769382694037*a^6 + 9258625410126221791*a^7 + 1546806533803993509*a^8 + 7416446501236864153*a^9 + 3476916985694553167*a^10 + 28930072329430674*a^11
g2_y = 544373368025887171 + 8874621118513866374*a^1 + 8009494946720473686*a^2 + 1065433853209237195*a^3 + 1956558743620835276*a^4 + 7323759157123465679*a^5 + 2253879482993753613*a^6 + 3769727620341931341*a^7 + 2471082114350274565*a^8 + 53398003196643395*a^9 +  392122047555439583*a^10 + 4569041207989982512*a^11
g2 = E([g2_x,g2_y,1])
"""


#------------------------------------------------------------------------------
# MISC
#------------------------------------------------------------------------------
step = 0
def status_tick():
    global step
    print "%s%%" % round(step/.05, 2)
    step = step+1

#------------------------------------------------------------------------------
# PRIME FIELD OPS
#------------------------------------------------------------------------------
def pf_add(a,b):
    return (a+b) % p

def pf_inva(a):
    return (-a) % p

def pf_sub(a,b):
    return pf_add(a, pf_inva(b))

def pf_mul(a,b):
    return a*b % p

def pf_pow(a,e):
    result = 1
    runner = a
    while e:
        if e%2:
            result = pf_mul(result, runner)
        runner = pf_mul(runner, runner)
        e = int(e/2)
    return result

def pf_invm(a):
    b = p
    equ_a = 1
    equ_b = 0
    while 1:
        n = a / b
        a = a - n*b
        equ_a = equ_a - n*equ_b
        if a==1:
            if equ_a < 0: equ_a += p
            return equ_a
        [a, equ_a, b, equ_b] = [b, equ_b, a, equ_a]

def pf_div(a,b):
    return pf_mul(a, pf_invm(b))

#------------------------------------------------------------------------------
# GF(P)[] OPS
#------------------------------------------------------------------------------
def polyring_sub(a,b):
    while len(a) < len(b): a = a + [0]
    while len(b) < len(a): b = b + [0]
    r = [0]*len(a)
    for i in range(len(a)):
        r[i] = (a[i] - b[i]) % p
    return r

def polyring_mul(a,b):
    len_a = len(a)
    len_b = len(b)    
    r = [0]*(len_a + len_b - 1)
    for i in range(len_a):
        for j in range(len_b):
            r[j+i] = (r[j+i] + a[i]*b[j]) % p
    return r

def polyring_div(a,b):
    q = []
    while a[-1:] == [0]: a = a[0:-1]    
    while b[-1:] == [0]: b = b[0:-1]
    width = len(b)

    big_c = pf_invm(b[-1:][0])
    while len(a) >= width:
        t = a[-width:]
        c = pf_mul(t[-1:][0], big_c)
        q = [c]+q
        for i in range(width):
            t[i] = pf_sub(t[i], pf_mul(c,b[i]))
        a = a[0:-width] + t[0:-1]
    while len(q) < len(b): q = q + [0]
    return [q,a]

#------------------------------------------------------------------------------
# EXTENSION FIELD OPS
#------------------------------------------------------------------------------
def ef_add(a,b):
    degree = len(a)
    r = [0]*degree
    for i in range(degree):
        r[i] = (a[i] + b[i]) % p
    return r

def ef_mul(a,b):
    degree = len(a)

    if degree != len(b):
        print "a: %s" % a
        print "b: %s" % b
        raise ValueError("incoming elements not from same field!")
    if degree != len(ef_poly)-1:
        raise ValueError("incoming elements incompatible with reduction poly!")

    r = polyring_mul(a,b)
    r = polyring_div(r,ef_poly)[1]
    if len(r) < extension: r = r + [0]*(extension - len(r))
    return r

def ef_inva(a):
    result = [pf_inva(x) for x in a]
    return result

def ef_sub(a,b):
    return ef_add(a, ef_inva(b))
    
def ef_pow(a,e):
    degree = len(a)
    result = [1]+[0]*(degree-1)
    runner = a
    while(e):
        if(e % 2):
            result = ef_mul(result, runner)
        runner = ef_mul(runner, runner)
        e = int(e/2);
    return result

def ef_invm(a):
    b = ef_poly
    equ_a = field_1
    equ_b = field_0
    while 1:
        [n,a] = polyring_div(a, b)
        equ_a = polyring_sub(equ_a, polyring_mul(n,equ_b))
        # is constant result?
        if a[0] and (len(a)==1 or sum(1 for x in a if x>1)==1):
            # make monic?
            if a[0] != 1: 
                equ_a = polyring_mul(equ_a, [pf_invm(a[0])])
            return equ_a[0:extension]
        [a, equ_a, b, equ_b] = [b, equ_b, a, equ_a]

def ef_div(a,b):
    return ef_mul(a,ef_invm(b))

#------------------------------------------------------------------------------
# CURVE OPS OVER XFIELD
#------------------------------------------------------------------------------
def ecc_add(A,B):
    [x1,y1,z1] = A
    [x2,y2,z2] = B
    if z1==field_0: return B
    if z2==field_0: return A
    if x1==x2 and y1==ef_inva(y2): return ecc_0
    if A==B:
        slope = ef_div(ef_add(ef_mul(field_3, ef_mul(x1,x1)), a_4), ef_mul(field_2, y1))
    else:
        slope = ef_div(ef_sub(y2,y1), ef_sub(x2, x1))
    x3 = ef_sub(ef_sub(ef_mul(slope, slope), x1), x2)
    y3 = ef_sub(ef_mul(slope, ef_sub(x1, x3)), y1)
    return [x3,y3,field_1]    

def ecc_inv(A):
    if A[2]==0: return A
    return [A[0], ef_inva(A[1]), A[2]]

def ecc_mul(A,n):
    result = ecc_0
    runner = A
    while n:
        if n%2:
            result = ecc_add(result, runner)
        runner = ecc_add(runner, runner)
        n = int(n/2)
    return result

#------------------------------------------------------------------------------
# PAIRING FUNCTIONS
#------------------------------------------------------------------------------
# evaluate A and B independently on line thru P,Q
def eval_on_line(P,Q,A,B):
    # case: line thru points at infinity
    if P==ecc_0 and Q==ecc_0: return [field_1,field_1]
    # case: one point at infinity -> vertical line
    if P==ecc_0: return [ef_sub(A[0], Q[0]), ef_sub(B[0], Q[0])]
    if Q==ecc_0: return [ef_sub(A[0], P[0]), ef_sub(B[0], P[0])]
    # case: P==Q -> tangent line
    if P==Q:
        # m = dy/dx = (3*x^2 + 2*a_2*x + a_4) / (2*y + a_1*x + a_3)  
        temp = ef_add(ef_mul(field_2, P[1]), ef_add(ef_mul(a_1,P[0]), a_3))
        # infinite slope? vert line again
        if temp == field_0: return [ef_sub(A[0], P[0]), ef_sub(B[0], P[0])]
        # else normal slope
        m = ef_div(ef_add(ef_add(ef_mul(field_3,ef_mul(P[0],P[0])), ef_mul(ef_mul(field_2,a_2),P[0])), a_4), temp)
        # y - y_1 = m*(x - x_1) or zeros of f(x,y) = y - y_1 - m*(x - x_1)
        return [ef_sub(ef_sub(A[1],P[1]), ef_mul(m, ef_sub(A[0],P[0]))), ef_sub(ef_sub(B[1],P[1]), ef_mul(m, ef_sub(B[0],P[0])))]

    # case: normal line, normal slope
    # m = (y_2 - y_1)/(x_2 - x_1)
    temp = ef_sub(Q[0],P[0])
    # infinite slope -> vert line again
    if temp == field_0: return [ef_sub(A[0],P[0]), ef_sub(B[0],P[0])]
    # 
    m = ef_div(ef_sub(Q[1],P[1]),temp)
    return [ef_sub(ef_sub(A[1],P[1]), ef_mul(m, ef_sub(A[0],P[0]))), ef_sub(ef_sub(B[1],P[1]), ef_mul(m, ef_sub(B[0],P[0])))]

# evaluate rational f_k on E at A, B independently
# f_k has divisor <f_k> = k<P+R> - k<R> - <kP>
lookup_f_k = {}
def eval_rational(P,R,k,A,B):
    global lookup_f_k
    lookup_f_k.clear()
    result = eval_rational_worker(P,R,k,A,B) 
    return result

def eval_rational_worker(P,R,k,A,B):
    # skip recursion?
    global lookup_f_k
    if k in lookup_f_k:
        return lookup_f_k[k]

    # base case
    # <f_1> = <vertical_{P+R}> - <line_{P,R}>
    if k==1:
        # evaluate vertical_{P+R}(A)
        temp = ecc_add(P,R)
        [top_A, top_B] = eval_on_line(temp, ecc_0, A,B)
        # evaluate line_{P+R}(A)
        [bottom_A, bottom_B] = eval_on_line(P, R, A,B)
        # result
        result = [ef_div(top_A, bottom_A), ef_div(top_B, bottom_B)]
        lookup_f_k[k] = result
        return result
 
    # even split case
    # <f_{2k}> = <f_k^2> + <T_{kP}> - <vertical_{2kP}>
    if k%2 == 0:
        # calculate f_k^2
        [top_A, top_B] = eval_rational_worker(P,R,k//2,A,B)

        top_A = ef_mul(top_A, top_A)
        top_B = ef_mul(top_B, top_B)

        # evaluate tangent_{kP}(A)
        temp = ecc_mul(P,k/2)
        [tang_A, tang_B] = eval_on_line(temp, temp, A,B)
        # evaluate vertical_{2kP}(A)
        temp = ecc_mul(P,k)
        [vert_A, vert_B] = eval_on_line(temp, ecc_0, A,B)
        # result
        result = [ef_div(ef_mul(top_A,tang_A),vert_A), ef_div(ef_mul(top_B,tang_B),vert_B)]
        lookup_f_k[k] = result
        return result

    # odd split case
    # <f_{a+b}> = <f_a> + <f_b> + <line_{aP,bP} - <vertical_{(a+b)P}>
    # split k = a+b, a even, b odd
    a = k//2;
    b = k - a;
    # calc f_a + f_b
    #[top_A, top_B] = ef_mul(eval_rational_worker(P,R,a,A,B), eval_rational_worker(P,R,b,A,B));

    [t1,t2] = eval_rational_worker(P,R,a,A,B)
    [t3,t4] = eval_rational_worker(P,R,b,A,B)
    top_A = ef_mul(t1,t3)
    top_B = ef_mul(t2,t4)

    # evaluate line_{aP,bP}(A)
    [line_A, line_B] = eval_on_line(ecc_mul(P,a), ecc_mul(P,b), A,B)
    # evaluate vertical_{2kP)(A)
    temp = ecc_mul(P,k)
    [vert_A, vert_B] = eval_on_line(temp, ecc_0, A,B)
    # result
    result = [ef_div(ef_mul(top_A,line_A),vert_A), ef_div(ef_mul(top_B,line_B),vert_B)]
    lookup_f_k[k] = result
    return result

# compute Weil pairing on P,Q torsion t
def weil_map(P,Q,t):
    # random points
    R = ecc_mul(ecc_g1, random.randint(0,ecc_r))
    S = ecc_mul(ecc_g2, random.randint(0,ecc_r))
    
    [t1,t2] = eval_rational(P,R,t,ecc_add(Q,S),S)
    top = ef_div(t1,t2)

    status_tick()

    [t1,t2] = eval_rational(Q,S,t,ecc_add(P,R),R)
    bottom = ef_div(t1,t2)

    status_tick()

    return ef_div(top, bottom)

#------------------------------------------------------------------------------
# MAIN()
#------------------------------------------------------------------------------
# args?
if len(sys.argv) != 3:
    print "usage: ", sys.argv[0], " <name> <serial>";
    quit()

# convert name to point in r-torsion
name_c = 0;
for char in sys.argv[1]:
    name_c = name_c*256 + ord(char)
ecc_M = ecc_mul(ecc_g1, name_c)

# convert serial to point (no check if on curve) eg: "1234-5678" -> (1234, 5678)
try:
    sys.argv[2].rindex("-")
    [serial_x, serial_y] = sys.argv[2].split("-")
    ecc_S = [[int(serial_x, 10)]+[0]*(extension-1), [int(serial_y, 10)]+[0]*(extension-1), field_1]
except ValueError:
    print "bad"
    quit()

# process, test serial
print "verifying (may take several minutes, sorry)..."
status_tick()
if weil_map(ecc_g2,ecc_S,ecc_r) == weil_map(ecc_P,ecc_M,ecc_r):
	print "good"
else:
	print "bad"
