# ShmooCon 2011 Crypto Challenges - Challenge 4
# 
# difficulty: 7/9
#
# example keys:
#
#          AcidBurn 4446516010411799432224950548178309176606862298491935246199-2780265864193007681176158224028480645105082362897203766104
#          ZeroCool 3885107771288962989360710658363762334737893787493342647481-1233405372775577705605073247840132110186006890755883384439
#      CerealKiller 2396332569456298887640979467391322754150544981100159376381-4825310099731898397100357951883715230990906651419774124965
#     CrashOverride 3633397119311953421982333737853628008345487858089157764503-4455666574870961551103401814117034938684863728837882945780
#     PhantomPhreak 4481225319032251764000163920733325658100771858905088734742-4199033124922816699773409616115005876591491504646904762450

import sys

# secp192k1
p =  6277101735386680763835789423207666416102355444459739541047
a =  0;
b =  3;
g = [5377521262291226325198505011805525673063229037935769709693,
     3805108391982600717572440947423858335415441070543209377693]
o =  6277101735386680763835789423061264271957123915200845512077

def xgcd(x,y):
	a0=1; b0=0
	a1=0; b1=1

	if x<0: 
		x *= -1
		a0 = -1
	if y<0: 
		y *= -1
		b1 = -1
	
	if x<y:
		x,y,a0,b0,a1,b1 = y,x,a1,b1,a0,b0

	while 1:
		times = x/y
		x -= times*y
		a0 -= times*a1
		b0 -= times*b1
		if x==0:
			break
		x,y,a0,b0,a1,b1 = y,x,a1,b1,a0,b0

	# x is 0 -> y is gcd
	return [y,a1,b1]
			
def invmod(x,p):
	[gcd,a,b] = xgcd(x,p)

	if gcd != 1:
		raise ValueError
	
	if a<0:
		a += p;

	return a	

def encrypt(P):
	x,y = P[0],P[1]

	top = \
		pow(x,169,p) + \
		6277101735386680763835789423207666416102355444459737610391*pow(x,166,p) + \
		48283573104*pow(x,163,p) + \
		189438412423104*pow(x,160,p) + \
		1728178030862599680*pow(x,157,p) + \
		6277101735386680763835789423207666415774316461042907856439*pow(x,154,p) + \
		1107355422930201742123008*pow(x,151,p) + \
		6277101735386680763835789423207549332965174895317377314359*pow(x,148,p) + \
		6277101735386680763835789423054752131633692820585978719799*pow(x,145,p) + \
		6277101735386680763835789379725112334640957520834037018167*pow(x,142,p) + \
		1730257818274707100838305603780608*pow(x,139,p) + \
		193364965040442258963597919090900992*pow(x,136,p) + \
		39472701322817088992629738132790575104*pow(x,133,p) + \
		809540665366571311813507669972802863104*pow(x,130,p) + \
		79919107951094788672507084651791416033280*pow(x,127,p) + \
		10063905327400794120793413656076772832182272*pow(x,124,p) + \
		452387740512756323812411267489016114124423168*pow(x,121,p) + \
		7594677754188782307434940133645625324747096064*pow(x,118,p) + \
		122894005959196989369255633911429593679133671424*pow(x,115,p) + \
		3693552938563558712287876318620794774777663324160*pow(x,112,p) + \
		102730034434716528057265845264978928418462059462656*pow(x,109,p) + \
		1610752078697812278172298165859567547299060007305216*pow(x,106,p) + \
		12102410483233234775544404477364480033137890972139520*pow(x,103,p) + \
		6277002836131192931856161399076839042396325539409574227511*pow(x,100,p) + \
		6271935116283086931348942438241265126874543678926415195703*pow(x,97,p) + \
		6184913729660429314377020092225143279919872580809979326007*pow(x,94,p) + \
		5276831219568264918372126294053722136739783423230107184695*pow(x,91,p) + \
		5279768527103665216997266428455900588309379289353270844526*pow(x,88,p) + \
		2829705712710526066488609214440948825852457527283927717194*pow(x,85,p) + \
		4263776745476109231216181694501178215617499641448780212884*pow(x,82,p) + \
		2851352306139456443534559555236577366586056343262375302644*pow(x,79,p) + \
		527794034468401313178510316244477991537309051827665060120*pow(x,76,p) + \
		1442798646485028607822188372077141406260660351494383912749*pow(x,73,p) + \
		4432104767222534894952657104974244843195501214468433312992*pow(x,70,p) + \
		4770994212407577184412177141566861328102478377763307931019*pow(x,67,p) + \
		2063561669983446881710108727321857200600675461650065061883*pow(x,64,p) + \
		2818856940972458801535233361248204652442975899489869796653*pow(x,61,p) + \
		5820538893141362474923166260057073300467721389031143985153*pow(x,58,p) + \
		1764319426398196000695951721432821047528749930072834827068*pow(x,55,p) + \
		1610997829040209097309890100212664728876316495374429291122*pow(x,52,p) + \
		5120251576725441729297496608830880775846742173829363939532*pow(x,49,p) + \
		727085278933527393056422491375353581673183710865463524016*pow(x,46,p) + \
		5878191071840125285186173950058654100042644614006972145280*pow(x,43,p) + \
		1330563700688743985852278246917380268969023833697426505750*pow(x,40,p) + \
		6126986267129572021208325582340409885281552057737380218591*pow(x,37,p) + \
		4429016435551826244791813697572450866493667017841173446363*pow(x,34,p) + \
		1686085819102882723324087022420689404644707689585612162201*pow(x,31,p) + \
		2060186930436405241688260536730125880769326263043873712155*pow(x,28,p) + \
		2957412638549810782324504848666199580002870395257279982097*pow(x,25,p) + \
		4460930379462929716089232002055310484191938001117685234815*pow(x,22,p) + \
		4115532970508121711990715816943583265677355071405593858383*pow(x,19,p) + \
		3870223616254428833952275238332630722254439189061531725968*pow(x,16,p) + \
		5866980095717851469915555319045104802009712663401164459290*pow(x,13,p) + \
		5189403486801530665806426569577544695457002438061479147879*pow(x,10,p) + \
		6252643754037918441307359710986650051278611061028552907187*pow(x,7,p) + \
		5201594789127303588611831612301943095336282107483895713972*pow(x,4,p) + \
		4640056543972287283748223661507911314708404572314331966739*x

	bottom = \
		169*pow(x,168,p) + \
		23317944*pow(x,165,p) + \
		765747712080*pow(x,162,p) + \
		6277101735386680763835789423207666416102352717215973359671*pow(x,159,p) + \
		6277101735386680763835789423207666416100036686977777394743*pow(x,156,p) + \
		7759220406248809046016*pow(x,153,p) + \
		5777107797747179084046336*pow(x,150,p) + \
		6277101735386680763835789423207092074741129083112303160887*pow(x,147,p) + \
		425804208859039756584443904000*pow(x,144,p) + \
		32554109915916406457004408176640*pow(x,141,p) + \
		2098051263143427858698351215116288*pow(x,138,p) + \
		1585889915777030724095080932833230848*pow(x,135,p) + \
		118940316834430786543058394804041809920*pow(x,132,p) + \
		81279126887675297050700631914462576640*pow(x,129,p) + \
		6277101735386680675992544602542451570709984873942257495607*pow(x,126,p) + \
		6277101735386670386450973308536003873249442230583345278519*pow(x,123,p) + \
		6277101735386377626157251312135899929175900348878770138679*pow(x,120,p) + \
		6277101735384817573813862604901534878533994085249921838647*pow(x,117,p) + \
		173358309380828695830554378307540480407629725696*pow(x,114,p) + \
		10207705241128684925414424323358207247397393793024*pow(x,111,p) + \
		259256946380685345456231842703234686992825567936512*pow(x,108,p) + \
		3676459945822013997169328141880945657658950046187520*pow(x,105,p) + \
		37124126617571225284041972420540492299641174100017152*pow(x,102,p) + \
		380866977930902654292404782331405993808078209550385152*pow(x,99,p) + \
		4909488031956537467005204132037090776512723778805956608*pow(x,96,p) + \
		59504787316520774408777164100257576106621820157594435584*pow(x,93,p) + \
		555955292161486075587298304340079933638943718422156935168*pow(x,90,p) + \
		4217976861586280848927976660301012563401399600668576055296*pow(x,87,p) + \
		587079486498432023288942744125900899097539956796530120941*pow(x,84,p) + \
		3531738937236400424691839500645094865760021023814154648771*pow(x,81,p) + \
		4145461245410904472421430016588058868203852510240750222212*pow(x,78,p) + \
		3620261579856454479681959074902175270834040951224158850499*pow(x,75,p) + \
		1049672511933012088840914559180047574521566865424904752876*pow(x,72,p) + \
		491380913916147894597853947609745644697000211312673071609*pow(x,69,p) + \
		5839894846778628852530368292063392136466663832110288607379*pow(x,66,p) + \
		542025714734773501374593540277739413515217335805325499797*pow(x,63,p) + \
		2485072347289369477289031485634219553159906592881779616544*pow(x,60,p) + \
		5189605872974981893485738985913522154902487040540102275875*pow(x,57,p) + \
		1797632007490987032753505847520508442954535757822995003807*pow(x,54,p) + \
		1365458946601756418079780603816211152599410061673652647460*pow(x,51,p) + \
		4885395583932235502380357611301944532663288982694787769328*pow(x,48,p) + \
		5395131886888771738239984543557388337341338622497421447553*pow(x,45,p) + \
		3773326022737825464320183792176999626519280957840855073147*pow(x,42,p) + \
		2017645663918948879958532227884577908758273051348167000368*pow(x,39,p) + \
		5184241178250860483678923117246767260165677957877672481891*pow(x,36,p) + \
		1979061717785047423470439399464048092988118837599257860134*pow(x,33,p) + \
		4435217465475340000688767386986351314197236878768235708349*pow(x,30,p) + \
		3275839375257811739869714592990504852472851669791270092151*pow(x,27,p) + \
		5078796789241317512062359250372332516923064475671426674426*pow(x,24,p) + \
		4053734645454348189696314483206253255232326899908231532102*pow(x,21,p) + \
		2900211445003284739914575703855682101324249410411114201986*pow(x,18,p) + \
		5987780802364356093952104797267914850317766346024577233288*pow(x,15,p) + \
		900843131224268848357464001914792135630040946583941107636*pow(x,12,p) + \
		5475024774877915314443314939367602022316623852131321594743*pow(x,9,p) + \
		1722580118210910928397956479241307083636545876191180645312*pow(x,6,p) + \
		816760760742357649876995544157939023271431668170359947621*pow(x,3,p) + \
		5668321202555828898918608255137864760910331881643958993712

	a = top * invmod(bottom,p) % p

	top = \
		338*pow(x,336,p)*y +  \
		1491667008*pow(x,333,p)*y +  \
		6277101735386680763835789423207666416102355283543111981879*pow(x,330,p)*y +  \
		6277101735386680763835789423207666416085458000183679731767*pow(x,327,p)*y +  \
		97002448303253641873920*pow(x,324,p)*y +  \
		6277101735386680763835789423205479293488421913767449886263*pow(x,321,p)*y +  \
		6277101735386680763835789407146131602699877386028034027063*pow(x,318,p)*y +  \
		25771392198996935703268739274768384*pow(x,315,p)*y +  \
		6277101735386680763828140658969883104203818070927646387767*pow(x,312,p)*y +  \
		176170326108350144793144227678714981253120*pow(x,309,p)*y +  \
		155312574555955966195594841808632704797769728*pow(x,306,p)*y +  \
		6277101735305258862282106462813297274681751184767889436215*pow(x,303,p)*y +  \
		31995024414646029091337190945234648813467905032192*pow(x,300,p)*y +  \
		12987868834867099055138194808524376279939283733708800*pow(x,297,p)*y +  \
		23026759801442367633533772228645591187183528284059074560*pow(x,294,p)*y +  \
		3737507092021593596910117144247425475155534118608684711936*pow(x,291,p)*y +  \
		3822679341715824362515634326597692423979097014653739910744*pow(x,288,p)*y +  \
		4645340468946412336965413204947456804538088523708574398335*pow(x,285,p)*y +  \
		6218179768547075710361064675942273694388314316857534520120*pow(x,282,p)*y +  \
		512029252250685053683090787676752472213182937186964299351*pow(x,279,p)*y +  \
		4775019414111058758691810984954708586776091980102023166531*pow(x,276,p)*y +  \
		3590012026234174403930432882284601622629368761192047270551*pow(x,273,p)*y +  \
		3038718869560215482861150789791958438830253241007906104155*pow(x,270,p)*y +  \
		941727067704338967486108797188501297937579216383758743638*pow(x,267,p)*y +  \
		5903545434522912414966213716841188343978532722975148777697*pow(x,264,p)*y +  \
		4002222726292993869670464418582812804538387424148737136523*pow(x,261,p)*y +  \
		5504881863408213729871842212794694001581328508929561798703*pow(x,258,p)*y +  \
		1796289244673497227790310258558671045902903734893537277864*pow(x,255,p)*y +  \
		4866484065271184423653354780578617165227815137481081875364*pow(x,252,p)*y +  \
		4519707461799445136733796260913159843548456331527364990094*pow(x,249,p)*y +  \
		4607880495947398336593866645372467244348272395446230492859*pow(x,246,p)*y +  \
		3439909138046194746403851597015108696991935472850276798644*pow(x,243,p)*y +  \
		5079857315364273415990584930606679226710339451499498029888*pow(x,240,p)*y +  \
		4164968002747559138880334935332332878355368263904515448009*pow(x,237,p)*y +  \
		2340425556790180301223767267826715881853003552577247218454*pow(x,234,p)*y +  \
		3629280213591664461886272817145269160630338937381164131115*pow(x,231,p)*y +  \
		2424590939587866242566819491919339988628971700615086342703*pow(x,228,p)*y +  \
		1395709950620611124817700846838498272274264806832188377477*pow(x,225,p)*y +  \
		3614288613312896705289795974713679422934094211712423929002*pow(x,222,p)*y +  \
		1301570747284683908122450570802136919751783134652223066561*pow(x,219,p)*y +  \
		143489939304719328228396002581249708812791973528069269898*pow(x,216,p)*y +  \
		2689278316221142879754697065333487932169909114695516845302*pow(x,213,p)*y +  \
		3535200314414463933917014190405639453162717307789510104558*pow(x,210,p)*y +  \
		5789832942137531987850468312798521322946262666465846006964*pow(x,207,p)*y +  \
		5757174808253755450740876703067253113594906261255035999664*pow(x,204,p)*y +  \
		1766142562948954141800538551968760458912658586007852403085*pow(x,201,p)*y +  \
		3486211843750656681084464918524706972050779685807971268865*pow(x,198,p)*y +  \
		6176898980896086441242372673783957092104341878897009648586*pow(x,195,p)*y +  \
		1196760439606378431033246431371964208578857190209991348578*pow(x,192,p)*y +  \
		3390362980616307155446906982703514332350107282096947910595*pow(x,189,p)*y +  \
		3461872161376585718367949075376597313984994359641101660583*pow(x,186,p)*y +  \
		1583855680531498486296744162695177437769833962358532449126*pow(x,183,p)*y +  \
		3865249423325697234427216925107364706123664196314475525732*pow(x,180,p)*y +  \
		3866068565397341900126755850565202817133878968085602437638*pow(x,177,p)*y +  \
		1093324882698301403582424436118156807714547259686293116539*pow(x,174,p)*y +  \
		5128772324233451747295960807648102611985778612952695922389*pow(x,171,p)*y +  \
		2364427060833147885726513384218827510687407960431241474948*pow(x,168,p)*y +  \
		3948025356504562663314963000845969562762827709410202680816*pow(x,165,p)*y +  \
		1691554103478172548878077217917479427938347630005827148582*pow(x,162,p)*y +  \
		762137919090060041728020886173595826727562989618530417020*pow(x,159,p)*y +  \
		3985092519436764472422110321612314396119031834655042234789*pow(x,156,p)*y +  \
		3264931183207369347546061052821261171144831558937586901043*pow(x,153,p)*y +  \
		3424272326743428259400364119611615040020371526531442573754*pow(x,150,p)*y +  \
		5067583219649328926549143440921605014971728765539667195620*pow(x,147,p)*y +  \
		5546123198064218873555452462238524437981454121517192235457*pow(x,144,p)*y +  \
		2459533436636555105376929872845735703644665657730444679229*pow(x,141,p)*y +  \
		3503479194776376727935367993158505036612556014780256632885*pow(x,138,p)*y +  \
		6121059831938755213464693129368462250845456786178018249693*pow(x,135,p)*y +  \
		4602220077341885913687665827577144900688095401654892789238*pow(x,132,p)*y +  \
		238207736637190532286852706746181755547414093950044415231*pow(x,129,p)*y +  \
		2472077778990948826632322948447535401204089963529513965868*pow(x,126,p)*y +  \
		852763409049166631104358773325000356286070108115381233803*pow(x,123,p)*y +  \
		3046898914602798470240435200701326671105282524381896589955*pow(x,120,p)*y +  \
		2745385091462871084081296155797759670626850894202001341748*pow(x,117,p)*y +  \
		5430042288133458182992817658795125937564078035829719600812*pow(x,114,p)*y +  \
		3721469901586634390748121486859369154091794163894729232768*pow(x,111,p)*y +  \
		5441493000223511102376464001822838715150313215891913587681*pow(x,108,p)*y +  \
		843700161693476834880226361221817686174251762340125302386*pow(x,105,p)*y +  \
		2542898143710509762573065103731480749749332421887946203116*pow(x,102,p)*y +  \
		4671864974955992312049292682845909724086725490828658406480*pow(x,99,p)*y +  \
		3863184765365384752209387128564489160140719559836180064844*pow(x,96,p)*y +  \
		1183271988231385772158914847805023630232806067395716412459*pow(x,93,p)*y +  \
		5436927516807047659451291181153233169689607531040678357203*pow(x,90,p)*y +  \
		2611785460628919790198937671969179247148392130214996055903*pow(x,87,p)*y +  \
		5262509633408298530736951342948293080804554165599627041097*pow(x,84,p)*y +  \
		1924240536960676666964936819640237210145989103579225653252*pow(x,81,p)*y +  \
		2797814975432721164138872176698455399672985939110904694419*pow(x,78,p)*y +  \
		2173725141267469532207268239905010979610987763186444943901*pow(x,75,p)*y +  \
		2453080288420024913987381701629163836804263023110504874695*pow(x,72,p)*y +  \
		1256881716507250988587596825069443667848538518842917237911*pow(x,69,p)*y +  \
		5192345667110249077759757256075812396238963314263918700149*pow(x,66,p)*y +  \
		3516067398462596352138971117957775280640734905902689245308*pow(x,63,p)*y +  \
		1553973039917130211631468248312786011533676840616110160035*pow(x,60,p)*y +  \
		2846499602351813727084605572075030803053618793881240975689*pow(x,57,p)*y +  \
		6118939738225838490476914399702879649617078203117740725766*pow(x,54,p)*y +  \
		4844224138962072799438317165175126743072814301537144112188*pow(x,51,p)*y +  \
		4387357746273526588546837091549592110112827972345344779970*pow(x,48,p)*y +  \
		2094425856008169669349783329747977262329719968438656350238*pow(x,45,p)*y +  \
		4104979209598169225582082489316577056622617579642326636350*pow(x,42,p)*y +  \
		5630528075026896777822978179558270909375723565480586195109*pow(x,39,p)*y +  \
		5562338978750068964768739187284166932784333144086947894260*pow(x,36,p)*y +  \
		1639305418542287486367026025133584643421429070666283534232*pow(x,33,p)*y +  \
		2045999423250580883298432234996301325597893823784200721732*pow(x,30,p)*y +  \
		3624364921704249728020559335951952382782641843559878987153*pow(x,27,p)*y +  \
		2151989473474466874944669159680722537437610820321290982422*pow(x,24,p)*y +  \
		4083956272803858062043173272010145206710141245610525940756*pow(x,21,p)*y +  \
		3615842309794240286929563666052279466390246070950024082512*pow(x,18,p)*y +  \
		5940980969478679386761544333599504667741874104598386962137*pow(x,15,p)*y +  \
		2874254170236828197906120211296240754956167623523650848118*pow(x,12,p)*y +  \
		1522770842114367293273272128133987320416955320159323667285*pow(x,9,p)*y +  \
		2803990057190056439499137040026101193375378162974098421412*pow(x,6,p)*y +  \
		2929280341480826069026196701552720199976484637512749539570*pow(x,3,p)*y +  \
		4884576138029715959039729407627870192237262060715506023469*y

	bottom = \
		742586*pow(x,336,p) +  \
		204918091872*pow(x,333,p) +  \
		20866280215824576*pow(x,330,p) +  \
		904527419740095370752*pow(x,327,p) +  \
		11918357976161481874997760*pow(x,324,p) +  \
		6277101735386680763835789423096327238900991673620615474743*pow(x,321,p) +  \
		110513074960136097315619010445312*pow(x,318,p) +  \
		644801839447841211125387505073913856*pow(x,315,p) +  \
		6277101735386680763104540422984943367515425912685522054711*pow(x,312,p) +  \
		6277101735386678986621503713129599328482618295875188813367*pow(x,309,p) +  \
		967211734919094804662721543859777663508938752*pow(x,306,p) +  \
		2341108462843412208692213806410249921989758156800*pow(x,303,p) +  \
		580141636489398384821191307706508555102664062402560*pow(x,300,p) +  \
		6277096841507134543966193947731386563905742348279238094391*pow(x,297,p) +  \
		149154014286833247345856108878479511267908493827458990080*pow(x,294,p) +  \
		3978143376551902157711482031866069709297654596022606753335*pow(x,291,p) +  \
		1006364976397402562576288716536517867965827664061438315772*pow(x,288,p) +  \
		361310374732543695731718882753534568446951112621634368808*pow(x,285,p) +  \
		5168242535241298394970023611087354110241198222859968042408*pow(x,282,p) +  \
		3144374741157823365504567735863057608100905946843022529015*pow(x,279,p) +  \
		3061373725123488756188075899827082356787480396524742324731*pow(x,276,p) +  \
		5015636709284869848824635662841068804105142243896124716752*pow(x,273,p) +  \
		3851866567761466971083418542112808950904369928131489876209*pow(x,270,p) +  \
		3399944769141563223563473768099680828956300015706404122762*pow(x,267,p) +  \
		5612715555836790701040234803366476942650003720246714321230*pow(x,264,p) +  \
		5227235261686525579052552841728844420928291257310079777575*pow(x,261,p) +  \
		4487673477716408406178844876498248380842432985424915773441*pow(x,258,p) +  \
		2285268894277854204169647641785928783793007587354196874135*pow(x,255,p) +  \
		1111314071172762025110707885266338929120379648903301743355*pow(x,252,p) +  \
		5993554146078724525352773262567073669998364554853552951883*pow(x,249,p) +  \
		2636810042480868544815521264886198764907210566926868525082*pow(x,246,p) +  \
		4124946388817281084888073833048608095032365059138842176264*pow(x,243,p) +  \
		4276184837660400303543410401159069654360382788255180100669*pow(x,240,p) +  \
		3089690768977251702500664083383447955214360902657566782750*pow(x,237,p) +  \
		3712972307649875570134638334798226811253792944713600297687*pow(x,234,p) +  \
		2414467693108670546685471770698159001549754275424057856931*pow(x,231,p) +  \
		3347021660874275077930669089469435242548160453893635717305*pow(x,228,p) +  \
		1874449779406553235775378502499966191864182538529626799172*pow(x,225,p) +  \
		2149166074698885811596951628207781008588661361495373032318*pow(x,222,p) +  \
		362688166644041794950367234894254791012198776483243653468*pow(x,219,p) +  \
		2909924199039369522074030776087857909586502915484342752877*pow(x,216,p) +  \
		622925870028676120469033192995897314511378214359386110776*pow(x,213,p) +  \
		2599582521869559997869288646675265424648949570676004647393*pow(x,210,p) +  \
		2257489886285623998655397855515997625274034673718067938578*pow(x,207,p) +  \
		1571112821317468962076357964965457388401996167075923951671*pow(x,204,p) +  \
		5744740763228553893759986045202401636601676705402995550282*pow(x,201,p) +  \
		4506884760311185724551459461600904654761217737379672229874*pow(x,198,p) +  \
		1778343388043645282405225244649591872336113123427790757901*pow(x,195,p) +  \
		5136722525293275168048936479525277511631426647147212066590*pow(x,192,p) +  \
		5210210681842685160427315559998062602869930549293595701108*pow(x,189,p) +  \
		520258010080245722930279144185317640819214902127885354223*pow(x,186,p) +  \
		3081853898818223703498062702657879009950868933476269765685*pow(x,183,p) +  \
		806521807600528504746964617321600891831911776285262742158*pow(x,180,p) +  \
		3444397019531026154185787577968983230869030593909585568477*pow(x,177,p) +  \
		2293559889207247180178938982121853673924774344381918384846*pow(x,174,p) +  \
		2994793747899827516727318964417134853626297007469097507071*pow(x,171,p) +  \
		2242785572095539764870651332311473804103319497409200098801*pow(x,168,p) +  \
		4950772969764962107745124268968170351983279967467964993698*pow(x,165,p) +  \
		6017316166149546604456618499532883719394075937481432339928*pow(x,162,p) +  \
		6262284346826782134516787583291059745053445323163494077682*pow(x,159,p) +  \
		375857084366456094061185084637436030765858300662971689626*pow(x,156,p) +  \
		2744461493169028983936277851885836393825342361439585141935*pow(x,153,p) +  \
		1458148383877854377760544747756139736310361470100353951917*pow(x,150,p) +  \
		4335878468081320064900454996281899025180308185775109593899*pow(x,147,p) +  \
		4671808155007439799224180440221051123955951580876028850599*pow(x,144,p) +  \
		1120401527223069801105915854931712084639748677804308413789*pow(x,141,p) +  \
		1329307489702181263459749125845260620008149590872460516431*pow(x,138,p) +  \
		4118744495194528257766582873078821189570105600584905984739*pow(x,135,p) +  \
		1747632541996445211081178458447913734702590883632403146327*pow(x,132,p) +  \
		4138058259455207016678926841362976180453714179587491305*pow(x,129,p) +  \
		5783167960062698748586587382534578801671214237171398858798*pow(x,126,p) +  \
		3786079679393365523666677150892734426924368533778104004861*pow(x,123,p) +  \
		1290097627010133517568938591212734474721175203772102377795*pow(x,120,p) +  \
		4535830067033722624771502352109488304770863704909493846451*pow(x,117,p) +  \
		6049942577812162211908113553622816515422997468412836745667*pow(x,114,p) +  \
		1433554657020850878027637667755134024652644794920172732173*pow(x,111,p) +  \
		2947170821235107205215562417220175482633606976198758009639*pow(x,108,p) +  \
		5594130743110669954969450948853917688196390288922636853163*pow(x,105,p) +  \
		1531124654225306089878644946503520148306164237443591467133*pow(x,102,p) +  \
		4339061252453662371644024497396679776805150131547198804606*pow(x,99,p) +  \
		5680308523971136965227615510899000911102090165388719631792*pow(x,96,p) +  \
		5126665350283437038618593253767393092238566648559996006721*pow(x,93,p) +  \
		4697404373091749726111234874611796954761787211597574839108*pow(x,90,p) +  \
		5899630733983090888210732729805410697686562820444997363687*pow(x,87,p) +  \
		1213267637624992900787310833331463118735729103036306746221*pow(x,84,p) +  \
		4174781497716424469703445209533471031910640822880981639078*pow(x,81,p) +  \
		3297452056262489419347499751121446126639385167132153224841*pow(x,78,p) +  \
		2712603109348375108441928331031769937553395268552000504903*pow(x,75,p) +  \
		2705977427611700183572161813216456061662578617327791287770*pow(x,72,p) +  \
		140561365478986203961507402639802321278840199201183425607*pow(x,69,p) +  \
		6187766479309911215562555105997030413977858550686818620685*pow(x,66,p) +  \
		5769735302529371636136055309212028203033679095001890783156*pow(x,63,p) +  \
		2857647775567583821969683443464458291866245563579594787387*pow(x,60,p) +  \
		2706245237635561567953516952999727445191559491733546737677*pow(x,57,p) +  \
		5464290690080473403221373795983422412632219283772002148025*pow(x,54,p) +  \
		1905008297080627342825467716882654638244057084155226349956*pow(x,51,p) +  \
		3810808898767888579518325971877557069085202167502486034806*pow(x,48,p) +  \
		709210986106152017107090969208550307016251821897697895009*pow(x,45,p) +  \
		3882807159688703870925271151547828504112797435759047562878*pow(x,42,p) +  \
		6243239814142418749451979661502314038315708951886830514418*pow(x,39,p) +  \
		2943491618077659626346501665774979672680348512506319108769*pow(x,36,p) +  \
		5795104694059990900593012479749432414996973445204085016754*pow(x,33,p) +  \
		5713313365550526529979846433900399965749784177831834885817*pow(x,30,p) +  \
		1886943358150118591021680127107658417670865359293551331478*pow(x,27,p) +  \
		4343281083831970942287147798889193490933260104331621243451*pow(x,24,p) +  \
		5459302197770938097464172523182400728377862018527532560145*pow(x,21,p) +  \
		2378638552041578460790025510663764052006523063607700966135*pow(x,18,p) +  \
		3667290039958426369932707202549331135485632492878171167396*pow(x,15,p) +  \
		2406684084803241491242318233373241722685934393278913142039*pow(x,12,p) +  \
		1150813273782473915663561226760960071273271856502532620943*pow(x,9,p) +  \
		2638172297899612955735164132290357986421437645777205516392*pow(x,6,p) +  \
		4148408407808802753685219123937158430309872086663314148311*pow(x,3,p) +  \
		4884576138029715959039729407627870192237262060715506023469

	b = top * invmod(bottom,p) % p

	return [a,b]

# args?
if len(sys.argv) != 3:
    print "usage: ", sys.argv[0], " <name> <serial>";
    quit()

# convert name to point (on curve) eg: "AAAA" -> (0x41414143, 0xe662156a98cd91e996c94473891707ba36dcc16702c65232)
name_x = 0;
for char in sys.argv[1]:
    name_x = name_x*256 + ord(char)
while 1:
	quadres = (name_x**3 + 3)%p
	name_y = pow(quadres, (p+1)/4, p)
	if pow(name_y, 2, p) == quadres:
		break;
	name_x += 1
P1 = [name_x, name_y]

# convert serial to point (no check if on curve) eg: "1234-5678" -> (1234, 5678)
try:
    sys.argv[2].rindex("-")
    [serial_x, serial_y] = sys.argv[2].split("-")
    P2 = [int(serial_x, 10), int(serial_y, 10)]
except ValueError:
    print "bad"
    quit()

# process, test serial
if P1 == encrypt(P2):
	print "good"
else:
	print "bad"

