# ShmooCon 2011 Crypto Challenges - Challenge 3
# 
# difficulty: 5/9
#
# example keys:
#
#          AcidBurn 01444672565034447382
#          ZeroCool 07682637095063599956
#      CerealKiller 01968629244248719558
#     CrashOverride 07432114611757458093
#     PhantomPhreak 17808072290391053435

import sys

# globals
sbox0 = [ 
      0,
    120,   9,   5, 217, 233, 133, 237, 134, 222,  64, 176, 248,  28, 195, 173, 286,
     18, 111, 136,  13, 282, 146, 211, 235,  50, 302, 294,  78, 130, 288,  88, 330,
    141,  79, 139, 100,  45, 274, 262, 206, 167, 207, 224,  31, 305, 182, 284, 164,
    225,  51, 290, 269, 277, 175, 232,  66, 255, 185, 103, 296,  82,   7, 319, 267,
    258, 311,  68,  70,  63,  99, 108, 295, 307, 154, 349, 297,  62, 259, 193, 326,
     32, 122, 303, 285, 186, 199, 353,  14, 144, 147, 159,  20, 321, 312, 165, 272,
     40,  86,   4, 220, 213,  93, 219, 309,  23, 212, 180, 318, 338, 241, 234,  53,
    335,   6, 112, 110, 228, 155, 121,  42, 345, 132, 245,  24, 350,   8, 324, 226,
    356, 310, 252, 106, 344, 135, 137, 119, 169, 170, 123, 204, 101,  89, 250, 128,
     69, 337,  81,   1, 107, 181, 357, 346, 179, 289, 242, 304, 253,  74,  33, 113,
    332,  15, 348, 300, 328, 215,  87, 216, 247, 254, 246, 178, 203,  54, 231, 127,
     57,  10,  37,  39,  27,  98,  76,  47,  41, 283, 333, 276, 109,  30, 329,  52,
     44, 298, 151,  90, 331, 190, 191, 273, 266,  59, 183, 149,  65, 140, 341,  29,
    275,  92,  61,  49, 355, 156, 314,  67, 223,  58, 209, 280, 188, 208, 118, 229,
     83,  72,  71,  19,  35,  84, 104, 299, 316, 336, 243, 163,  16, 301, 227, 351,
    158, 239, 236, 171, 306, 126, 138, 153, 343,  22,  48, 205, 160, 256, 238, 257,
    261, 291,  77,  75, 263,  91, 334, 264, 218,  46,  94,  38, 174, 194,  96, 152,
    340,  43, 270, 198, 161, 315,  36,  80, 150, 339, 260, 230, 265, 210, 189, 202,
     25, 214,   2,  34, 143, 142, 145, 102, 162, 271, 347, 221, 201, 292, 327, 131,
    172, 268, 354, 184, 196, 105, 342, 313,  95, 278,   3, 317, 168, 320, 279,  17,
    129, 325, 322,  12,  60, 281, 116, 200, 308, 323,  55,  56, 251, 157, 249, 115,
     26, 287,  85,  11, 192, 166, 114, 117, 124, 197,  73, 125,  21, 240, 244, 187,
    177, 352,  97, 148, 293
];

sbox1 = [
      0,
     90, 158,  18,  66, 111, 236,  16, 157,  74, 153, 313, 200,  78, 151, 203, 210,
    317, 168, 240,  28, 349, 337, 214,   8,  82, 292, 279, 259,  25, 232,  14,  42,
    355, 193, 245, 144, 176, 224,  33, 149, 255,  81,  35,  88, 127, 329, 218, 271,
    291, 122, 132, 322,   4, 296,  30, 155,  46, 177,  73, 269, 304, 237, 294, 179,
    116, 242, 277, 161,  27, 332,   3, 281, 103,  23, 260, 162,   7,  77,  44, 295,
    120, 131,   9,  41, 339,  47, 301, 195, 220, 148, 101,  13, 175,  45, 178, 300,
    204, 184,  56, 128,  40,  54, 307, 321, 290,  65,  91,   5, 338, 130, 216,  99,
    345, 243,  70,  29, 125, 166, 244, 147, 171, 252, 268, 126, 138, 334, 165,  80,
    104,  50,  83, 205, 163, 253, 160, 351, 113, 343, 306, 180,  97, 100,  22, 280,
    181,  26,   1, 196, 262,  63, 293, 188, 340, 211, 215,  49, 136, 105, 213, 121,
    223, 173, 169,  96,  10,  71, 238, 112, 335, 114, 261,  12, 183,  60, 102,  95,
    266, 248,  11, 159, 319, 308, 297, 265,  57,  85, 270, 346, 109,  55, 230, 323,
     31, 251, 357, 356, 198, 331, 284, 267, 199, 347,  76,  39, 327, 107,  32, 289,
    352,  20, 156, 258, 206, 212, 108,  53, 311, 353, 354, 226, 152, 154, 342, 139,
      2, 326, 315, 350, 123, 185,  93, 288, 234,  67, 134, 137, 286,  98, 278, 254,
    310, 314, 135, 257,  38, 263, 249, 273,  24, 146, 298, 303, 119,   6, 182, 133,
    344, 110,  62, 283, 117, 141, 228, 264,  87, 191,  37,  43, 325, 333, 164, 221,
     94, 229, 187, 197, 217, 320,  89,  72,  69,  21, 186,  58, 167,  92, 189, 299,
     61, 106, 241,  79, 250,  36, 150, 174,  15,  48, 202, 272,  86,  34, 222, 225,
    324, 274, 219, 285, 129,  51, 239, 305, 172, 318,  17, 336, 115, 233, 142, 316,
    231, 192, 341, 328,  52, 145, 208,  64,  84, 207, 190, 118, 194,  19, 124,  68,
    302, 287, 282, 312, 330, 227, 235, 348, 246, 276,  59, 247,  75, 170, 256, 275,
    201, 209, 140, 309, 143
];

def sbox_combine(s0, s1):
    temp = [0]*len(s0)
    for i in range(len(s0)):
        temp[i] = s0[s1[i]]
    return(temp)

def sbox_repeat(s, e):
    result = [x for x in range(len(s))];
    while e:
        if e % 2:
            result = sbox_combine(result, s)
        s = sbox_combine(s, s)
        e = e / 2
    return(result);

# args?
if len(sys.argv) != 3:
    print "usage: ", sys.argv[0], " <name> <serial>";
    quit()

# convert name to number eg: "AAAA" -> 0x41414141
name_num = 0;
for char in sys.argv[1]:
    name_num = name_num*256 + ord(char);

# convert serial to number eg: "1234" -> 1234
serial = int(sys.argv[2], 10);

# process the serial
temp0 = sbox_repeat(sbox0, name_num);
temp1 = sbox_repeat(sbox1, serial)

# compare
if temp0 == temp1:
    print "good"
else:
    print "bad"

