# ShmooCon 2011 Crypto Challenges - Challenge 2
# 
# difficulty: 2/9
#
# example keys:
#
#          AcidBurn 11615602099246585559
#          ZeroCool 03005825730626844278
#      CerealKiller 03581543448288065463
#     CrashOverride 13078556886864025323
#     PhantomPhreak 05539546088963323327

import sys

# globals
mask = 2**64-1

# args?
if len(sys.argv) != 3:
    print "usage: ", sys.argv[0], " <name> <serial>";
    quit()

# convert name to number eg: "AAAA" -> 0x41414141
name_num = 0;
for char in sys.argv[1]:
    name_num = name_num*256 + ord(char);

name_num &= mask;

# convert serial to number eg: "1234" -> 1234
serial = int(sys.argv[2], 10);

# process the serial
state = serial

for i in range(65537):
    temp = state & 0x800000000000000D
    sum = 1
    while temp:
        sum ^= (temp & 1);
        temp >>= 1;
    
    state = ((state << 1) & mask) | sum;

# compare
if state == name_num:
    print "good"
else:
    print "bad"

