# ShmooCon 2011 Crypto Challenges - Challenge 1
# 
# difficulty: 2/9
#
# example keys:
#
#          AcidBurn 1649481359549505402561479053043201900888184394021408719108972630913320748
#          ZeroCool 1364322106314494174530683074267648512025126826630653307188925198732775902
#      CerealKiller 0230358680502548311075632914452451574091356856923738049771699798267506015
#     CrashOverride 1793682617285276710563753026905554559584623114290979669780482272042697729
#     PhantomPhreak 1307448599787740140661139142795764643341043657634218416130360567853579819

import sys

# globals
d = 65537
n = 1821668788150059822966422307930288186476927434330004078983325993614616857

# args?
if len(sys.argv) != 3:
    print "usage: ", sys.argv[0], " <name> <serial>";
    quit()

# convert name to number eg: "AAAA" -> 0x41414141
m = 0;
for char in sys.argv[1]:
    m = m*256 + ord(char);

if m > n:
    m = m % n;

# convert serial to number eg: "1234" -> 1234
c = int(sys.argv[2], 10);

# process, check
if pow(c, d, n) == m:
    print "good"
else:
    print "bad"
