#include <stdlib.h>
#include <string.h>
#include "ende.h"

ende_key_t *ende_prepare(void *skey, unsigned int klen)
{
	ende_key_t *res;
	
	if((res = (ende_key_t *)malloc(sizeof(ende_key_t))) == NULL)
		return NULL;
	
	if((res->key = (unsigned char *)malloc(klen)) == NULL)
	{
		free(res);
		return NULL;
	}
	
	memcpy(res->key, skey, klen);
	res->klen = klen;

	return res;
}

void ende_release(ende_key_t *ekey)
{
	free(ekey->key);
	free(ekey);
}

int ende_process(void *data_dst, void *data_src, unsigned int dlen, ende_key_t *ekey)
{
	unsigned int ki = 0;
	unsigned char *dst, *src;
	
	if((data_dst == NULL) || (data_src == NULL))
		return 0;
	
	dst = (unsigned char *)data_dst;
	src = (unsigned char *)data_src;
	
	while(dlen > 0)
	{
		*dst = *src ^ ekey->key[ki % ekey->klen];
		dst++;
		src++;
		ki++;
		dlen--;
	}
	
	return 1;
}

void ende_mutate(ende_key_t *ekey, void *data, unsigned int dlen)
{
	unsigned int ki = 0, tki = 0;
	unsigned char a, b, *pdata;

	pdata = (unsigned char *)data;
	
	while(dlen > 0)
	{
		tki = ki % ekey->klen;
		a = ekey->key[tki];
		b = (a + *pdata) % 0xff;
		ekey->key[tki] = (a >> 1) ^ b;
		pdata++;
		ki++;
		dlen--;
	}
}
