# Awesome Data Format Reverse Engineering

A curated list of awesome reverse engineering resources to make you better! 

Managed by Reversing.ID for the reversing community.

## Introduction

`Data Format Reverse Engineering` focus on representation and interpretation of structured data in stored or transmitted form.

In some cases, format reversing is done in conjunction with software which generate the data.

## Table of Contents

- Resources
- Tools
    - [Hex Editors](#hex-editors)
    - [Format Identifier](#format-identifier)
    - [Structure Parser](#structure-parser)
    - [Binary Visualization](#binary-visualization)
    - [String Search](#string-search)
    - [Pattern Search](#pattern-search)
    - [Bundle Extractor](#bundle-extractor)

- - - 

## Hex Editors

Hex editor lets you view/edit the binary data of a file.

Multi/cross platform

* [010 Editor](http://www.sweetscape.com/010editor/)
* [Kaitai Struct](https://kaitai.io)
* [wxHexEditor](https://www.wxhexeditor.org/)

Windows 

* [HxD](https://mh-nexus.de/en/hxd/)
* [Hex Workshop](http://www.hexworkshop.com/)
* [Hexinator](https://hexinator.com/)

Mac OS X

* [HexFiend](http://ridiculousfish.com/hexfiend/)

## Format Identifier

* [Binwalk](https://github.com/ReFirmLabs/binwalk)

## Structure Parser

* [010 Editor](http://www.sweetscape.com/010editor/)
* [ImHex](https://github.com/WerWolv/ImHex)
* [Kaitai Struct](https://kaitai.io)

## Binary Visualization

* [Veles](https://codisec.com/veles/)
* [..cantor.dust..](https://sites.google.com/site/xxcantorxdustxx/home)
* [binglide](https://github.com/wapiflapi/binglide)

## String Search

- [bingrep](https://github.com/m4b/bingrep) - grep through binaries

## Pattern Search

- [YARA](https://github.com/virustotal/yara)

## Bundle Extractor

Game Assets

* [UABE](https://github.com/DerPopo/UABE) - Unity Assets Bundle Extractor
* [DevXUnityUnpacker](http://devxdevelopment.com/UnityUnpacker)
* [MultiEx Commander](http://multiex.xentax.com/) - multiple game resources archive.
