package yan.jiang.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import yan.jiang.bean.Command;
import yan.jiang.bean.CommandContent;
import yan.jiang.bean.Message;
import yan.jiang.dao.CommandDao;
import yan.jiang.dao.MessageDao;
import yan.jiang.entity.Page;
import yan.jiang.util.Iconst;

/**
 * ѯбصҵ
 * @author Yan_Jiang
 *
 */
public class QueryService {
	/**
	 *  daoѯ
	 * @param command
	 * @param description
	 * @return زѯ
	 */
	public List<Message> queryMessageList(String command,String description, Page page) {
		
		//֯Ϣ
		Message message = new Message();
		message.setCommand(command);
		message.setDescription(description);
		MessageDao messageDao = new MessageDao();
		//ѯ
		int totalNumber = messageDao.count(message);
		//֯ҳѯ
		page.setTotalNumber(totalNumber);
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("message", message);
		map.put("page",page);
		
		List<Message> queryMessageList = messageDao.queryMessageList(map);
		return queryMessageList;
	}
	
	/**
	 * ݲѯҳѯϢб ==>
	 */
	public List<Message> queryMessageListByPage(String command,String description,Page page) {
		Map<String,Object> map = new HashMap<String, Object>();
		// ֯Ϣ
		Message message = new Message();
		message.setCommand(command);
		message.setDescription(description);
		map.put("message", message);
		map.put("page", page);
		MessageDao messageDao = new MessageDao();
		// ҳѯؽ
		return messageDao.queryMessageListByPage(map);
	}
	
	/**
	 * ָͨѯԶظ
	 * @param command ָ
	 * @return Զظ
	 */
	public String queryByCommand(String command) {
		CommandDao commandDao = new CommandDao();
		List<Command> commandList;
		//ְָ ִָ Ȼڽƴ 
		if(Iconst.HELP_COMMAND.equals(command)) {
			//ȫΪ
			commandList = commandDao.queryMessageList(null, null);
			StringBuilder result = new StringBuilder();
			
			for(int i = 0; i < commandList.size(); i++) {
				//ӵڶпʼ <br/>ǩƴ
				if(i != 0) {
					result.append("<br/>");
				}
				result.append("ظ[" + commandList.get(i).getName() + "]Բ鿴" + commandList.get(i).getDescription());
			}
			return result.toString();
		}
		//б
		commandList = commandDao.queryMessageList(command, null);
		if(commandList.size() > 0) {
			//ָӦĶݼ
			List<CommandContent> contentList = commandList.get(0).getContentList();
			//һ  ضӦ
			int randomIndex = new Random().nextInt(contentList.size());
			return contentList.get(randomIndex).getContent();
			 
		}
		return Iconst.NO_MATCHING_CONTENT;
	}
}

