package yan.jiang.interceptor;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Properties;

import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

import com.mysql.jdbc.Connection;

import yan.jiang.entity.Page;

/**
 * ҳ
 * 		ʱstatement֮ǰ
 * 		ص㣺 MybatisԴ
 * @author Yan_Jiang
 */
//صľϢ
@Intercepts({@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class PageInterceptor implements Interceptor {

	//2 صԺ ִеҵ
	@Override
	public Object intercept(Invocation invocation) throws Throwable {
		//Ķ
		StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
		// MappedStatement ==> ȡ ʹMybatisзװõ
		MetaObject metaObject = MetaObject.forObject(statementHandler, SystemMetaObject.DEFAULT_OBJECT_FACTORY, SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY);
		//ȽRoutingStatementHandler ȻٲStatementHandler
		MappedStatement mappedStatement =(MappedStatement) metaObject.getValue("delegate.mappedStatement");
		//ȡļsqlid
		String id = mappedStatement.getId();
		/**ƥByPageβID
		 * $ַβıʾ
		 * . ǰٳһַ
		 */
		if(id.matches(".+ByPage$")) {
			BoundSql boundSql = statementHandler.getBoundSql();
			//Mybatis ԭʼsqlִ
			String sql = boundSql.getSql();
			
			//2.1 ȡѯ  ==> ֻԭʼjdbc
			String countSql = "select count(*) from ("+ sql +")a";
			//ȡصĲ
			Connection connection = (Connection) invocation.getArgs()[0];
			PreparedStatement countStatement = connection.prepareStatement(countSql);
			//ΪprepareStatementռλ ֵ
			ParameterHandler parameterHandler = (ParameterHandler) metaObject.getValue("delegate.parameterHandler");
			parameterHandler.setParameters(countStatement);
			//ִвѯ
			ResultSet rs = countStatement.executeQuery();
			int totalNumber = rs.getInt(1);
			
			//2.2 ȡҳ
			@SuppressWarnings("unchecked")
			Map<String,Object> map = (Map<String,Object>) boundSql.getParameterObject();
			Page page = (Page) map.get("page");
			if(rs.next()) {
				//ҳ
				page.setTotalNumber(totalNumber);
			}
			
			// зҳܵsql
			String pageSql = sql + " limit " +page.getDbIndex() + "," + page.getDbNumber();
			//滻޸ĵsql  ==> ͼ
			metaObject.setValue("delegate.boundSql.sql", pageSql);
		}
		// Դ룺return method.invoke(target, args); ==>
		return invocation.proceed();
	}
	
	//1 жǷҪ
	@Override
	public Object plugin(Object target) {
		/**target صĿ   this ʵ
		 *  return Plugin.wrap(target, this) ==> ؾдķҳʵ
		 *  wrap(target, this) ==> ԴжЩҪ
		 */
		return Plugin.wrap(target, this);
	}

	@Override
	public void setProperties(Properties properties) {
		// TODO Auto-generated method stub
		
	}

}
