# FontForge Font Discography

## Preamble

A list of open-source typefaces which are designed with FontForge and includes .sfd/.sfdir as source files. Mainly for FontForge users who want to quickly nagivate through different projects, examine them, and maybe contribute to some of them.

To contribute or request for a removal, you can make an issue or a pull request. Be sure to follow the same format.

## Criteria

- The fonts must be open-source, and the source should be accessible in some way.
- The fonts must be created or edited in FontForge.
- The source must include .sfd/.sfdir files. Other accompanying files can also be included.
- The license or the authors allow sharing/redistributing their fonts.

## Collection
| Designer/Foundry | Typeface | Link |
| :---: | --- | --- |
| [Altinn](https://github.com/Altinn) | Altinn-Din | https://github.com/Altinn/altinn-din |
| | | |
| [Bronnel721](https://github.com/Bronnel721) | Mahone Sans | https://github.com/Bronnel721/Mahone-Sans |
| | Rally Display | https://github.com/Bronnel721/Rally-Display |
| | Zamero Sans | https://github.com/Bronnel721/Zamero-Sans |
| | Joosper | https://github.com/Bronnel721/Joosper |
| | Cerk Sans | https://github.com/Bronnel721/Cerk-Sans |
| | Lubricantness | https://github.com/Bronnel721/Lubricantness |
| | Hookings | https://github.com/Bronnel721/Hookings |
| | Woodrun | https://github.com/Bronnel721/Woodrun |
| | Gunterick | https://github.com/Bronnel721/Gunterick |
| | Tapelt | https://github.com/Bronnel721/TapeIt |
| | Identical Gothic | https://github.com/Bronnel721/Identical-Gothic |
| | Florentine Sans | https://github.com/Bronnel721/Florentin-Sans |
| | ZT Eagle | https://github.com/Bronnel721/ZT-Eagle |
| | Ugarium Sans | https://github.com/Bronnel721/Ugarium-Sans |
| | Rooben | https://github.com/Bronnel721/Rooben |
| | Willias | https://github.com/Bronnel721/Willias |
| | Hendrix Gothic | https://github.com/Bronnel721/Hendrix-Gothic |
| | Berntique | https://github.com/Bronnel721/Berntiqua |
| | Architun | https://github.com/Bronnel721/Architun |
| | Estamate Sans | https://github.com/Bronnel721/Estamate-Sans |
| | Sayhone Grotesk | https://github.com/Bronnel721/Sayhone-Grotesk |
| | Parking Sans | https://github.com/Bronnel721/Parking-Sans |
| | | |
| [Bry10022](https://github.com/Bry10022) | Gewtymol | https://github.com/Bry10022/Gewtymol |
| | Lentariso | https://github.com/Bry10022/Lentariso |
| | Consettro | https://github.com/Bry10022/Consettro |
| | Yftoowhy | https://github.com/Bry10022/YftoowhyFont |
| | | |
| [Carl's Type](https://github.com/carlstype) | Techna Sans | https://github.com/carlstype/techna-sans |
| | Helmet | https://github.com/carlstype/helmet |
| | | |
| [Corne2Plum3](https://github.com/Corne2Plum3) | Giphurs | https://github.com/Corne2Plum3/Giphurs |
| | Pixel12x10 | https://github.com/Corne2Plum3/Pixel12x10 |
| | | |
| [Culmus Fonts](https://culmus.sourceforge.io/index.html) | Fancy fonts (15 typefaces) | https://culmus.sourceforge.io/fancy/index.html |
| | | |
| [Daniel Benjamin Miller](https://github.com/dbenjaminmiller) | Garamond Libre | https://github.com/dbenjaminmiller/garamond-libre |
| | Step | https://github.com/dbenjaminmiller/step |
| | Domitian | https://github.com/dbenjaminmiller/domitian |
| | Salieri | https://github.com/dbenjaminmiller/salieri |
| | NX Baskerville | https://github.com/dbenjaminmiller/NXBaskerville |
| | RW Garamond | https://github.com/dbenjaminmiller/rwgaramond |
| | Regis | https://github.com/dbenjaminmiller/regis |
| | XETBook | https://github.com/dbenjaminmiller/xetbook |
| | | |
| [Dave Crossland](https://github.com/davelab6) | Libre Moretus | https://github.com/davelab6/libre-moretus |
| | | |
| [DejaVu Fonts](https://github.com/dejavu-fonts) | DejaVu | https://github.com/dejavu-fonts/dejavu-fonts |
| | | |
| [Evolventa](https://github.com/evolventa) | Evolventa | https://github.com/evolventa/evolventa |
| | | |
| [Fuzzypeg](https://github.com/Fuzzypeg) | Coelacanth | https://github.com/Fuzzypeg/Coelacanth |
| | | |
| [Georg Mayr-Duffner](https://github.com/georgd) | EB Garamond | https://github.com/georgd/EB-Garamond |
| | | |
| [indestructible type*](https://github.com/indestructible-type) | Cooper | https://github.com/indestructible-type/Cooper |
| | Drafting | https://github.com/indestructible-type/Drafting |
| | Bodoni | https://github.com/indestructible-type/Bodoni |
| | MFEK-Sans | https://github.com/indestructible-type/MFEK-Sans |
| | Jost | https://github.com/indestructible-type/Jost |
| | Besley | https://github.com/indestructible-type/Besley |
| | Gnomon | https://github.com/indestructible-type/Gnomon |
| | Jones | https://github.com/indestructible-type/Jones |
| | Miedinger | https://github.com/indestructible-type/Miedinger |
| | | |
| [Interstices](https://github.com/Interstices-) | Manifont Grotesk | https://github.com/Interstices-/Manifont-Grotesk |
| | Manifont Serif | https://github.com/Interstices-/Manifont-Serif |
| | | |
| [Jacob Perez](https://github.com/jacobxperez) | Lexica Ultralegible | https://github.com/jacobxperez/lexica-ultralegible |
| | | |
| [LiberationFonts](https://github.com/liberationfonts) | Liberation Fonts | https://github.com/liberationfonts/liberation-fonts |
| | Liberation Sans Narrow | https://github.com/liberationfonts/liberation-sans-narrow |
| | | |
| [RandomMaerks](https://github.com/RandomMaerks) | Overused Grotesk | https://github.com/RandomMaerks/Overused-Grotesk |
| | Droide | https://github.com/RandomMaerks/Droide |
| | | |
| [Richard Sepši](https://github.com/RichardSepsi) | Unageo | https://github.com/RichardSepsi/Unageo |
| | | |
| [Sean Petykowski](https://github.com/petykowski) | London TFL Dot Matrix | https://github.com/petykowski/London-Underground-Dot-Matrix-Typeface |
| | | |
| [Slavfox](https://github.com/slavfox) | Cozette | https://github.com/slavfox/Cozette |
| | | |
| [Stefan Peev](https://github.com/StefanPeev) | Grazhdanskiy Shrift | https://github.com/StefanPeev/Grazhdanskiy-Shrift |
| | Libra Sans | https://github.com/StefanPeev/Libra-Sans |
| | | |
| [WeirdoOnTheBus](https://github.com/weirdoonthebus) | Kepler-452b | https://github.com/weirdoonthebus/Kepler-452b |
| | | |
| [Wojciech Kalinowski](https://github.com/wmk69) | Consola Mono | https://github.com/wmk69/Consola-Mono |
| | Square Antiqua | https://github.com/wmk69/Square-Antiqua |
| | Modern Antiqua | https://github.com/wmk69/Modern-Antiqua |
| | Medieval Sharp | https://github.com/wmk69/Medieval-Sharp |
| | Nova | https://github.com/wmk69/Nova |
| | Simply Serif | https://github.com/wmk69/Simply-Serif |
| | Simply Sans | https://github.com/wmk69/Simply-Sans |
| | Simply Mono | https://github.com/wmk69/Simply-Mono |
| | Round Style | https://github.com/wmk69/Round-Style |
| | Newest Shape | https://github.com/wmk69/Newest-Shape |
| | New Shape | https://github.com/wmk69/New-Shape |
| | Klaudia | https://github.com/wmk69/Klaudia |
| | Gothica | https://github.com/wmk69/Gothica |
| | Cursive | https://github.com/wmk69/Cursive |
| | Classica | https://github.com/wmk69/Classica |
| | Celtica | https://github.com/wmk69/Celtica |
| | Berenika | https://github.com/wmk69/Berenika |
