/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;

public class OracleTypeINTERVAL
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1394800182554224957L;
    final int LDIINTYEARMONTH = 7;
    final int LDIINTDAYSECOND = 10;
    final int SIZE_INTERVAL_YM = 5;
    final int SIZE_INTERVAL_DS = 11;
    byte typeId = 0;
    int scale = 0;
    int precision = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:32_PST_2006";

    protected OracleTypeINTERVAL() {
    }

    public OracleTypeINTERVAL(OracleConnection oracleConnection) {
    }

    public int getTypeCode() {
        if (this.typeId == 7) {
            return -103;
        }
        if (this.typeId == 10) {
            return -104;
        }
        return 1111;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.typeId = tDSReader.readByte();
        this.precision = tDSReader.readByte();
        this.scale = tDSReader.readByte();
    }

    public int getScale() throws SQLException {
        return this.scale;
    }

    public int getPrecision() throws SQLException {
        return this.precision;
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.typeId = objectInputStream.readByte();
        this.precision = objectInputStream.readByte();
        this.scale = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.typeId);
        objectOutputStream.writeByte(this.precision);
        objectOutputStream.writeByte(this.scale);
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                if (byArray.length == 5) {
                    return new INTERVALYM(byArray);
                }
                if (byArray.length != 11) break;
                return new INTERVALDS(byArray);
            }
            case 2: {
                if (byArray.length == 5) {
                    return INTERVALYM.toString(byArray);
                }
                if (byArray.length != 11) break;
                return INTERVALDS.toString(byArray);
            }
            case 3: {
                return byArray;
            }
            default: {
                DatabaseError.throwSqlException(59);
            }
        }
        return null;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        Datum datum = null;
        if (object != null) {
            if (object instanceof INTERVALYM || object instanceof INTERVALDS) {
                datum = (Datum)object;
            } else if (object instanceof String) {
                try {
                    datum = new INTERVALDS((String)object);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    datum = new INTERVALYM((String)object);
                }
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datum;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }
}

