﻿// Licensed under the MIT License. See LICENSE in the project root for license information.

using Newtonsoft.Json;
using System.Collections.Generic;
using UnityEngine.Scripting;

namespace OpenAI.Realtime
{
    [Preserve]
    public sealed class RealtimeResponseResource
    {
        [Preserve]
        [JsonConstructor]
        internal RealtimeResponseResource(
            [JsonProperty("id")] string id,
            [JsonProperty("object")] string @object,
            [JsonProperty("status")] RealtimeResponseStatus status,
            [JsonProperty("status_details")] StatusDetails statusDetails,
            [JsonProperty("output")] IReadOnlyList<ConversationItem> output,
            [JsonProperty("usage")] Usage usage)
        {
            Id = id;
            Object = @object;
            Status = status;
            StatusDetails = statusDetails;
            Output = output;
            Usage = usage;
        }

        /// <summary>
        /// The unique ID of the response.
        /// </summary>
        [Preserve]
        [JsonProperty("id")]
        public string Id { get; }

        /// <summary>
        /// The object type, must be "realtime.response".
        /// </summary>
        [Preserve]
        [JsonProperty("object")]
        public string Object { get; }

        /// <summary>
        /// The status of the response ("in_progress").
        /// </summary>
        [Preserve]
        [JsonProperty("status")]
        public RealtimeResponseStatus Status { get; }

        /// <summary>
        /// Additional details about the status.
        /// </summary>
        [Preserve]
        [JsonProperty("status_details")]
        public StatusDetails StatusDetails { get; }

        /// <summary>
        /// The list of output items generated by the response.
        /// </summary>
        [Preserve]
        [JsonProperty("output")]
        public IReadOnlyList<ConversationItem> Output { get; }

        /// <summary>
        /// Usage statistics for the Response, this will correspond to billing.
        /// A Realtime API session will maintain a conversation context and append new Items to the Conversation,
        /// thus output from previous turns (text and audio tokens) will become the input for later turns.
        /// </summary>
        [Preserve]
        [JsonProperty("usage")]
        public Usage Usage { get; }
    }
}
