/** Common mime types mapped to Content-Type headers */
export const MIME_TYPES: { [ext: string]: string } = {
  '3gp': 'video/3gpp',
  '3gpp': 'video/3gpp',
  asf: 'video/x-ms-asf',
  asx: 'video/x-ms-asf',
  avi: 'video/x-msvideo',
  avif: 'image/avif',
  bmp: 'image/x-ms-bmp',
  css: 'text/css',
  flv: 'video/x-flv',
  gif: 'image/gif',
  htm: 'text/html',
  html: 'text/html',
  ico: 'image/x-icon',
  jng: 'image/x-jng',
  jpeg: 'image/jpeg',
  jpg: 'image/jpeg',
  js: 'application/javascript',
  json: 'application/json',
  kar: 'audio/midi',
  m4a: 'audio/x-m4a',
  m4v: 'video/x-m4v',
  mid: 'audio/midi',
  midi: 'audio/midi',
  mng: 'video/x-mng',
  mov: 'video/quicktime',
  mp3: 'audio/mpeg',
  mp4: 'video/mp4',
  mpeg: 'video/mpeg',
  mpg: 'video/mpeg',
  ogg: 'audio/ogg',
  pdf: 'application/pdf',
  png: 'image/png',
  rar: 'application/x-rar-compressed',
  shtml: 'text/html',
  svg: 'image/svg+xml',
  svgz: 'image/svg+xml',
  tif: 'image/tiff',
  tiff: 'image/tiff',
  ts: 'video/mp2t',
  txt: 'text/plain',
  wbmp: 'image/vnd.wap.wbmp',
  webm: 'video/webm',
  webp: 'image/webp',
  wmv: 'video/x-ms-wmv',
  woff: 'font/woff',
  woff2: 'font/woff2',
  xml: 'text/xml',
  zip: 'application/zip',
};
