---
title: Welcome to Qwik Tutorials
---

### Welcome to Qwik!

Qwik is a front-end framework for building [**resumable**](/docs/(qwik)/concepts/resumable/index.mdx) applications that start-up **instantly** on the client. Qwik achieves this by focusing on its philosophy of **downloading and executing only the code that is strictly necessary** to perform the user-triggered action. Qwik is a fine-grained lazy-loading framework representing a fundamentally new approach to building web applications.

### Qwik Tutorials

What follows is a set of tutorials that will help you get started with Qwik. Each tutorial focuses on a single topic and contains a hands-on example that requires your participation to make it work.

The tutorials are broken up into these sections:

- [Introduction](/tutorial/introduction/component/index.mdx): A fast-paced introduction to Qwik where we focus more on building a simple application with server-side pre-rendering and client-side interactivity. This tutorial is designed to give you a feel over how Qwik applications are built rather than focusing on details of individual APIs.
- [Components](/tutorial/component/basic/index.mdx): All about declaring, binding, and composition of components.
- [Events](/tutorial/events/basic/index.mdx): Declaring, binding, and triggering events.
- [Stores](/tutorial/store/basic/index.mdx): Declaring stores, data-binding, reactivity, and serialization.
- [Props](/tutorial/props/basic/index.mdx): A deep dive into declaring and working with props and components and serialization constraints.
- [Reactivity](/tutorial/reactivity/template/index.mdx): A deep dive into how reactivity works and how it can be used to build a more complex application.
- [Context](/tutorial/context/basic/index.mdx): Making data globally available to your application through context.
- [Lifecycle Hooks](/tutorial/hooks/use-task/index.mdx): Component life-cycle hooks.
- [Slots](/tutorial/projection/slots/index.mdx): A deep dive into how content projection works and how to use it in more complex scenarios.
- [Styling](/tutorial/style/styles/index.mdx): Styling your application with CSS.
- [Optimizer](/tutorial/qrl/optimizer/index.mdx): Understanding the Optimizer constraints.
- [Composing new APIs](/tutorial/composing/dollar/index.mdx): Composing new `use___()` and `$` APIs for your application.
