# Qwik Guide

## Introduction

- [Overview](</docs/(qwik)/index.mdx>)
- [Getting Started](</docs/(qwik)/getting-started/index.mdx>)
- [Project structure](</docs/(qwikcity)/project-structure/index.mdx>)
- [FAQ](</docs/(qwik)/faq/index.mdx>)

## Components

- [Overview](</docs/(qwik)/components/overview/index.mdx>)
- [State](</docs/(qwik)/components/state/index.mdx>)
- [Events](</docs/(qwik)/components/events/index.mdx>)
- [Tasks & Lifecycle](</docs/(qwik)/components/tasks/index.mdx>)
- [Context](</docs/(qwik)/components/context/index.mdx>)
- [Slots](</docs/(qwik)/components/slots/index.mdx>)
- [Rendering](</docs/(qwik)/components/rendering/index.mdx>)
- [Styling](</docs/(qwik)/components/styles/index.mdx>)
- [API Reference](</api/qwik/>)

## Qwik City

- [Overview](</docs/(qwikcity)/qwikcity/index.mdx>)
- [Routing](</docs/(qwikcity)/routing/index.mdx>)
- [Pages](</docs/(qwikcity)/pages/index.mdx>)
- [Layouts](</docs/(qwikcity)/layout/index.mdx>)
- [Loaders](</docs/(qwikcity)/route-loader/index.mdx>)
- [Actions](</docs/(qwikcity)/action/index.mdx>)
- [Validators](</docs/(qwikcity)/validator/index.mdx>)
- [Endpoints](</docs/(qwikcity)/endpoints/index.mdx>)
- [Middleware](</docs/(qwikcity)/middleware/index.mdx>)
- [server$](</docs/(qwikcity)/server$/index.mdx>)
- [Re-exporting loaders](/docs/(qwikcity)/re-exporting-loaders/index.mdx)
- [Caching](</docs/(qwikcity)/caching/index.mdx>)
- [HTML attributes](</docs/(qwikcity)/html-attributes/index.mdx>)
- [API reference](</docs/(qwikcity)/api/index.mdx>)

## Cookbook

- [Overview](/docs/cookbook/index.mdx)
- [Algolia Search](/docs/cookbook/algolia-search/index.mdx)
- [Combine Handlers](/docs/cookbook/combine-request-handlers/index.mdx)
- [Debouncer](/docs/cookbook/debouncer/index.mdx)
- [Fonts](/docs/cookbook/fonts/index.mdx)
- [Glob Import](/docs/cookbook/glob-import/index.mdx)
- [Media Controller](/docs/cookbook/mediaController/index.mdx)
- [NavLink](/docs/cookbook/nav-link/index.mdx)
- [Node Docker deploy](/docs/cookbook/node-docker-deploy/index.mdx)
- [Portals](/docs/cookbook/portals/index.mdx)
- [Streaming loaders](/docs/cookbook/streaming-deferred-loaders/index.mdx)
- [Sync events w state](/docs/cookbook/sync-events/index.mdx)
- [Theme Management](/docs/cookbook/theme-management/index.mdx)
- [Drag & Drop](/docs/cookbook/drag&drop/index.mdx)

## Integrations

- [Overview](integrations/index.mdx)
- [Astro](integrations/astro/index.mdx)
- [Auth.js](integrations/authjs/index.mdx)
- [Bootstrap](integrations/bootstrap/index.mdx)
- [Builder.io](integrations/builderio/index.mdx)
- [Cypress](integrations/cypress/index.mdx)
- [Drizzle](integrations/drizzle/index.mdx)
- [i18n](integrations/i18n/index.mdx)
- [Icons](integrations/icons/index.mdx)
- [Image Optimization](integrations/image-optimization/index.mdx)
- [Leaflet Map](integrations/leaflet-map/index.mdx)
- [Modular Forms](integrations/modular-forms/index.mdx)
- [Nx Monorepos](integrations/nx/index.mdx)
- [OG Image](integrations/og-img/index.mdx)
- [Orama](integrations/orama/index.mdx)
- [Panda CSS](integrations/panda-css/index.mdx)
- [Partytown](integrations/partytown/index.mdx)
- [Playwright](integrations/playwright/index.mdx)
- [PostCSS](integrations/postcss/index.mdx)
- [Prisma](integrations/prisma/index.mdx)
- [React](integrations/react/index.mdx)
- [Storybook](integrations/storybook/index.mdx)
- [Styled Vanilla Extract](integrations/styled-vanilla-extract/index.mdx)
- [Supabase](integrations/supabase/index.mdx)
- [Tailwind](integrations/tailwind/index.mdx)
- [Tauri](integrations/tauri/index.mdx)
- [Turso](integrations/turso/index.mdx)
- [Vitest](integrations/vitest/index.mdx)

## Deployments

- [Overview](deployments/index.mdx)
- [Azure SWA](deployments/azure-swa/index.mdx)
- [AWS](deployments/aws-lambda/index.mdx)
- [Firebase](deployments/firebase/index.mdx)
- [Google Cloud Run](deployments/gcp-cloud-run/index.mdx)
- [Cloudflare Pages](deployments/cloudflare-pages/index.mdx)
- [Deno](deployments/deno/index.mdx)
- [Bun](deployments/bun/index.mdx)
- [Netlify Edge](deployments/netlify-edge/index.mdx)
- [Node](deployments/node/index.mdx)
- [Vercel Edge](deployments/vercel-edge/index.mdx)
- [Static Site](deployments/static/index.mdx)

## Guides

- [Qwik in a nutshell](</docs/(qwikcity)/guides/qwik-nutshell/index.mdx>)
- [Markdown & MDX](</docs/(qwikcity)/guides/mdx/index.mdx>)
- [SSG](</docs/(qwikcity)/guides/static-site-generation/index.mdx>)
- [Qwik Native Apps](</docs/(qwikcity)/guides/capacitor/index.mdx>)
- [React Cheat Sheet](</docs/(qwikcity)/guides/react-cheat-sheet/index.mdx>)
- [Best Practices](</docs/(qwikcity)/guides/best-practices/index.mdx>)
- [Bundle Optimization](</docs/(qwikcity)/guides/bundle/index.mdx>)
- [Env variables](</docs/(qwikcity)/guides/env-variables/index.mdx>)

## Concepts

- [Think Qwik](</docs/(qwik)/concepts/think-qwik/index.mdx>)
- [Resumable](</docs/(qwik)/concepts/resumable/index.mdx>)
- [Progressive](</docs/(qwik)/concepts/progressive/index.mdx>)
- [Reactivity](</docs/(qwik)/concepts/reactivity/index.mdx>)

## Advanced

- [The $ dollar sign](</docs/(qwik)/advanced/dollar/index.mdx>)
- [Containers](</docs/(qwik)/advanced/containers/index.mdx>)
- [QRL](</docs/(qwik)/advanced/qrl/index.mdx>)
- [Library mode](</docs/(qwik)/advanced/library/index.mdx>)
- [Qwikloader](</docs/(qwik)/advanced/qwikloader/index.mdx>)
- [Optimizer](</docs/(qwik)/advanced/optimizer/index.mdx>)
- [Modules Prefetching](</docs/(qwik)/advanced/modules-prefetching/index.mdx>)
- [Build Directory](</docs/(qwik)/advanced/custom-build-dir/index.mdx>)
- [Vite](</docs/(qwik)/advanced/vite/index.mdx>)
- [Advanced Routing](</docs/(qwikcity)/advanced/routing/index.mdx>)
- [Qwik Plugins](</docs/(qwikcity)/advanced/plugins/index.mdx>)
- [Request Handling](</docs/(qwikcity)/advanced/request-handling/index.mdx>)
- [Speculative Module Fetching](</docs/(qwikcity)/advanced/speculative-module-fetching/index.mdx>)
- [Menus](</docs/(qwikcity)/advanced/menu/index.mdx>)
- [Static Assets](</docs/(qwikcity)/advanced/static-assets/index.mdx>)
- [Sitemaps](</docs/(qwikcity)/advanced/sitemaps/index.mdx>)
- [ESLint-Rules](</docs/(qwik)/advanced/eslint/index.mdx>)
- [Content Security Policy](</docs/(qwikcity)/advanced/content-security-policy/index.mdx>)
- [Complex Forms](</docs/(qwikcity)/advanced/complex-forms/index.mdx>)

## Reference

- [API Reference](/api/)
- [Deprecated Features](</docs/(qwik)/deprecated-features/index.mdx>)

## Qwik Labs 🧪

- [Overview](/docs/labs/index.mdx)
- [Insights](/docs/labs/insights/index.mdx)
- [Typed Routes](/docs/labs/typed-routes/index.mdx)
- [Devtools](/docs/labs/devtools/index.mdx)
- [usePreventNavigate](/docs/labs/usePreventNavigate/index.mdx)

## Community

- [GitHub](https://github.com/QwikDev/qwik)
- [@QwikDev](https://twitter.com/QwikDev)
- [Discord](https://qwik.dev/chat)
- [Community Projects](/community/projects/index.mdx)
- [Values](/community/values/index.mdx)
