<br>
<p align="center">
  <img alt="Qwik Logo" width="400" src="https://raw.githubusercontent.com/QwikDev/qwik/main/.github/assets/qwik-logo.svg" />
</p>
<br>
<p align="center">
   <a href="https://github.com/QwikDev/qwik/actions/workflows/ci.yml"><img src="https://github.com/QwikDev/qwik/actions/workflows/ci.yml/badge.svg?event=push" alt="Qwik CI"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/azure.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/azure.yml/badge.svg" alt="Azure SWA Server"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/cloudflare.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/cloudflare.yml/badge.svg" alt="Cloudflare Pages Server"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/netlify.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/netlify.yml/badge.svg" alt="Netlify Server"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/node.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/node.yml/badge.svg" alt="Node Servers"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/vercel-edge.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/vercel-edge.yml/badge.svg" alt="Vercel Edge"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/vercel-serverless.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/vercel-serverless.yml/badge.svg" alt="Vercel Serverless"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/cli.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/cli.yml/badge.svg" alt="Create Qwik CLI"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/deno.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/deno.yml/badge.svg" alt="Deno Server"></a>
   <a href="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/aws.yml"><img src="https://github.com/QwikDev/qwik-city-e2e/actions/workflows/aws.yml/badge.svg" alt="AWS Server"></a>
</p>
<br>
<br>

<h1 align="center">Instant-loading web apps, without effort</h1>

Qwik offers the fastest possible page load times - regardless of the complexity of your website. Qwik is so fast because it allows fully interactive sites to load with almost no JavaScript and [pickup from where the server left off](https://qwik.dev/docs/concepts/resumable/).

As users interact with the site, only the necessary parts of the site load on-demand. This [precision lazy-loading](https://qwik.dev/docs/concepts/progressive/) is what makes Qwik so quick.

## Getting Started

```sh
npm create qwik@latest
# or
pnpm create qwik@latest
# or
yarn create qwik@latest
# or
bun create qwik@latest
```

- Understand the difference between [resumable and replayable](https://qwik.dev/docs/concepts/resumable/) applications.
- Learn about Qwik's high level [mental model](https://qwik.dev/docs/concepts/think-qwik/).

## Resources

- [Docs](https://qwik.dev/)
- [Examples](https://qwik.dev/examples/introduction/hello-world/)
- [Tutorials](https://qwik.dev/tutorial/welcome/overview/)
- [Videos](https://qwik.dev/media/#videos)
- [Podcasts](https://qwik.dev/media/#podcasts)
- [Presentations](https://qwik.dev/media/#presentations)
- [Blogs](https://qwik.dev/media/#blogs)

## Community

- Ping us at [@QwikDev](https://twitter.com/QwikDev)
- Join our [Discord](https://qwik.dev/chat) community
- Join all the [other community groups](https://qwik.dev/ecosystem/#community)

## Development

- See [Contributing.md](https://github.com/QwikDev/qwik/blob/main/CONTRIBUTING.md) for more information on how to build Qwik from the source and contribute!

## Related

- [Partytown](https://partytown.builder.io/): Relocate resource intensive third-party scripts off of the main thread and into a web worker 🎉.
- [Mitosis](https://github.com/BuilderIO/mitosis): Write components once, run everywhere. Compiles to Vue, React, Solid, Angular, Svelte, and more.
- [Builder](https://github.com/BuilderIO/builder): Drag and drop page builder and CMS for React, Vue, Angular, and more.

<br>
<br>

<table align="center">
  <tr align="center">
    <td>special sponsor</td>
  </tr>
  <tr>
    <td align="center">
      <a href="https://www.builder.io/m/developers">
        <picture>
          <source media="(prefers-color-scheme: dark)" srcset="https://i.imgur.com/eT9FjKT.png">
          <img width="250" alt="Special sponsor Builder.io" src="https://i.imgur.com/32mv01X.png">
        </picture>
      </a>
    </td>
  </tr>
</table>
