# Qwik Project Governance

This governance document reflects our dedication to maintaining Qwik as an open, fair, and collaborative project and is a continuation of our [community values](https://docs.google.com/document/d/1MrSp2caaREETHUL56C2fIIJeFJsBA_sWJ9raL6hWoo8/edit#heading=h.bpbzghkvfgrn).

Qwik is rooted in a commitment to innovation and community-driven development where the needs of the community drive the framework's evolution.

Our decisions are guided by what serves Qwik and the broader web ecosystem best, with a strong emphasis on seeking consensus.

The following outlines the structure of the project, including the roles and responsibilities of its members.

## Community Contributors

A Community contributor is any community member who contributes to the success of the framework.

Contributors usually are part of one or more of the following categories:

1. **Code Contributors** - Developers who contribute by identifying issues, submitting pull requests, or maintaining community-driven Qwik projects.
2. **Docs Contributors** - Members who enhance or correct the Qwik documentation, ensuring it remains accurate and accessible.
3. **Support Contributors** - Members who assist other developers by answering questions and offering support.
4. **Content Creators** - Those who produce educational content, tutorials, and other resources to help the community better understand and use Qwik.
5. **Local Community Leaders** - Members who organize and lead local Qwik communities, fostering in-person engagement and knowledge sharing.

## Qwik Heroes

Qwik Heroes are recognized as top contributors who have exceptional dedication and enthusiasm for Qwik.

Heroes have easier access to the core team and participate in monthly meetings to provide feedback, ask questions, and discuss internal topics together with the team.

#### Nomination

Any community contributor can be nominated as a Qwik Hero by an existing member or by any of the leadership teams. Selections are made by the Community Management Team (and in conjunction with the core team for cases of “code heroes”).

#### Status Change

Removal of Qwik Heroes is done by either a voluntary resignation or by a Community Management Team decision, or (in extreme cases) by a Stewardship Team motion.

Qwik Heroes who become inactive for 6 months are automatically reverted to regular community contributor status.

## Core Team

Core team members are contributors who have merging rights to the project and are actively involved in the ongoing development of Qwik. They are essential to the framework's evolution, participating in weekly sprint meetings and Core Leadership meetings (although only Core Leadership members can vote in these meetings).

The Core Team will have a Core Team Lead who will be in charge of the ongoing project management and development progress.

#### Nomination

A Qwik Hero member can be nominated as a Core Team member by any member of the Core Team. Nominations are decided upon by a standard Core Leadership motion.

#### Status Change

Removal of Core Team members is done by either a voluntary resignation or by a standard Core Leadership motion, or (in extreme cases) by a Stewardship Team motion.

A Core Team member will be automatically converted back to a "Qwik Hero" if they are not active in the project for over 3 months.

## Core Leadership Team

The Core Leadership Team includes Core Team members who are granted voting rights on strategic technical decisions.

These individuals are selected because of their experience, judgment, good faith, and alignment with Qwik's core values.

Members of this team are expected to participate in Core Leadership Team activities and meetings and can cast votes when consensus is not reached on a specific decision.

#### Nomination

Regular Core Team members can be nominated to the Core Leadership Team by any current Core Leadership member, with the final decision made through a standard Core Leadership motion.

#### Status Change

Removal of voting Core Leadership members is done by either a voluntary resignation or by a standard Core Leadership motion, or (in extreme cases) by a Stewardship Team motion.

A Core Leadership member will be automatically converted to a regular Core Team member if they do not participate in 3 consecutive votes or have been inactive for over 4 months.

## Docs Team

The Docs Team is responsible for maintaining and improving Qwik's documentation.

This team ensures that the documentation is up-to-date, accurate, and user-friendly, and also handles the triage of docs-related issues and the merging of related PRs.

#### Nomination

A Qwik Hero member can be nominated as a Docs Team member by any member of the Docs Team. Nominations need to be approved by the Growth Manager.

#### Status Change

Removal of Docs Team members is done by either a voluntary resignation or by a Growth Manager decision, or (in extreme cases) by a Stewardship Team motion.

A Docs Team member will be automatically converted back to a "Qwik Hero" if they are not active in the project for over 3 months.

## Community Management Team

The Community Management Team oversees the onboarding, safety, and overall vibe of the Qwik community.

They ensure that the community remains a friendly and inclusive space where members follow the Qwik community guidelines.

The team is responsible for managing "Local Community Leaders" and "Support Heroes" and helping them succeed in their roles and contributions.

#### Nomination

Qwik Heroes may be nominated to the Community Management Team by any current team member. Nominations need to be approved by the Growth Manager.

#### Status Change

Removal of Community Management Team members is done by either a voluntary resignation or by a Growth Manager decision, or (in extreme cases) by a Stewardship Team motion.

A Community Management Team member will be automatically converted back to a "Qwik Hero" if they are not active in the project for over 3 months.

## Outreach Team

The Outreach Team is responsible of spreading Qwik's message, ensuring that more developers are introduced to the framework and give it a try. Their responsibilities include managing social media, collaborating with content creators, representing Qwik at conferences, and more.

#### Nomination

Qwik Heroes may be nominated to the Outreach Team by any current team member. Nominations need to be approved by the Growth Manager.

#### Status Change

Removal of Outreach Team members is done by either a voluntary resignation or by a Growth Manager decision, or (in extreme cases) by a Stewardship Team motion.

An Outreach Team member will be automatically converted back to a "Qwik Hero" if they are not active in the project for over 3 months.

## Growth Manager

The Growth Manager is responsible for overseeing the Community Management, Outreach, and Docs Teams, ensuring that their efforts are aligned and that messaging across these teams remains consistent.

This role is crucial in driving the strategic direction of Qwik's growth and ensuring that all community-facing activities are cohesive and effective.

The Growth Manager is appointed or replaced by a standard Stewardship Team motion.

## Stewardship Team

The project's stewards are in charge of all aspects regarding the framework.

This includes the development, community, and growth of the framework, but also creating proper management processes, managing sponsorships and budgets, collaborations, and more.

The project stewards are: Misko Hevery and Shai Reznik.

The project stewards will be used as "tiebreakers" in votes and hold veto rights on decisions (to protect the framework from rare and extreme cases).

Because the framework can be forked by the community at any point, the project stewards must manage the project in a fair, honest, and thoughtful way, taking into account what's good for the community and resolving conflicting needs as much as possible.

---

inspired by [Node](https://github.com/nodejs/node/blob/main/GOVERNANCE.md), [Vue](https://github.com/vuejs/vue/wiki/Governance-Document), [Astro](https://github.com/withastro/.github/blob/main/GOVERNANCE.md) and [Nuxt](https://github.com/nuxt/governance)
