<!--
The Qwik Team and Community appreciate all PRs. Thank you for your effort! Not all PRs can be merged, but those that meet the following criteria will be prioritized:

a) Core fixes, and

b) Framework functionality achievable only by the core.

If this PR can be done as a 3rd-Party Community Add-On, we encourage that for quicker adoption.

If you believe your functionality is valuable to the entire Qwik Community, discuss it in the Qwik Discord channels for potential inclusion in the core.

First of all, make sure your PR title is descriptive and matches our commit title guidelines.

Also make sure your PR follows all the guidelines in the [CONTRIBUTING.md](./CONTRIBUTING.md) document.

-->

# What is it?

<!-- pick one and remove the others -->

- Feature / enhancement
- Bug
- Docs / tests / types / typos
- Infra

# Description

<!--
* Include a summary of the motivation and context for this PR
* Is it related to any opened issues? (please add them here)
-->

# Checklist

<!--
* delete the items that are not relevant, so it's easy to tell if the PR is ready to be merged
* add items that are relevant and need to be done before merging
-->

- [ ] My code follows the [developer guidelines of this project](https://github.com/QwikDev/qwik/blob/main/CONTRIBUTING.md)
- [ ] I performed a self-review of my own code
- [ ] I added a changeset with `pnpm change`
- [ ] I made corresponding changes to the Qwik docs
- [ ] I added new tests to cover the fix / functionality
