@echo off

rem Get the Windows Build number and save it to a variable
for /f "tokens=2 delims=[]" %%i in ('ver') do set "build=%%i"
set "build=%build:.=%"
set "build=%build:~11%"
set "build=%build:~0,5%.%build:~5%"

echo Windows build number is %build%

rem Create a folder with the Windows build number
set "build_folder=%~dp0%build%"
if not exist "%build_folder%" md "%build_folder%"
echo Folder created: %build_folder%

rem Create two folders inside the new folder
md "%build_folder%\x64" > nul
md "%build_folder%\x86" > nul
echo Folders created: %build_folder%\x64 and %build_folder%\x86

rem Copy the DLLs to the respective folders
echo Copying DLL files to %build_folder% folders...
copy "C:\Windows\System32\Windows.ApplicationModel.Store.dll" "%build_folder%\x64" > nul
copy "C:\Windows\SysWOW64\Windows.ApplicationModel.Store.dll" "%build_folder%\x86" > nul
echo DLL files copied to %build_folder% folders

rem Zipping
echo Zipping %build_folder%...
powershell -Command "Compress-Archive -Path '%build_folder%' -DestinationPath '%build_folder%.zip'"
echo zipped %build_folder%.zip
