/*
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
"use strict";
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Shumway;
(function (Shumway) {
    /*
     * HTML Parser By John Resig (ejohn.org)
     * Original code by Erik Arvidsson, Mozilla Public License
     * http://erik.eae.net/simplehtmlparser/simplehtmlparser.js
     *
     * // Use like so:
     * HTMLParser(htmlString, {
     *     start: function(tag, attrs, unary) {},
     *     end: function(tag) {},
     *     chars: function(text) {},
     *     comment: function(text) {}
     * });
     *
     */
    // Regular Expressions for parsing tags and attributes
    var startTag = /^<([-A-Za-z0-9_]+)((?:\s+[-A-Za-z0-9_]+(?:\s*=\s*(?:(?:"[^"]*")|(?:'[^']*')|[^>\s]+))?)*)\s*(\/?)>/, endTag = /^<\/([-A-Za-z0-9_]+)[^>]*>/, attr = /([-A-Za-z0-9_]+)(?:\s*=\s*(?:(?:"((?:\\.|[^"])*)")|(?:'((?:\\.|[^'])*)')|([^>\s]+)))?/g;
    // Empty Elements - HTML 4.01
    var empty = makeMap("area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed");
    // Block Elements - HTML 4.01
    var block = makeMap("address,applet,blockquote,button,center,dd,del,dir,div,dl,dt,fieldset,form,frameset,hr,iframe,ins,isindex,li,map,menu,noframes,noscript,object,ol,p,pre,script,table,tbody,td,tfoot,th,thead,tr,ul");
    // Inline Elements - HTML 4.01
    var inline = makeMap("a,abbr,acronym,applet,b,basefont,bdo,big,br,button,cite,code,del,dfn,em,font,i,iframe,img,input,ins,kbd,label,map,object,q,s,samp,script,select,small,span,strike,strong,sub,sup,textarea,tt,u,var");
    // Elements that you can, intentionally, leave open
    // (and which close themselves)
    var closeSelf = makeMap("colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr");
    // Attributes that have their values filled in disabled="disabled"
    var fillAttrs = makeMap("checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected");
    // Special Elements (can contain anything)
    var special = makeMap("script,style");
    function HTMLParser(html, handler) {
        var index, chars, match, stack = [], last = html;
        function top() {
            return stack[stack.length - 1];
        }
        while (html) {
            chars = true;
            // Make sure we're not in a script or style element
            if (!top() || !special[top()]) {
                // Comment
                if (html.indexOf("<!--") == 0) {
                    index = html.indexOf("-->");
                    if (index >= 0) {
                        if (handler.comment)
                            handler.comment(html.substring(4, index));
                        html = html.substring(index + 3);
                        chars = false;
                    }
                }
                else if (html.indexOf("</") == 0) {
                    match = html.match(endTag);
                    if (match) {
                        html = html.substring(match[0].length);
                        match[0].replace(endTag, parseEndTag);
                        chars = false;
                    }
                }
                else if (html.indexOf("<") == 0) {
                    match = html.match(startTag);
                    if (match) {
                        html = html.substring(match[0].length);
                        match[0].replace(startTag, parseStartTag);
                        chars = false;
                    }
                }
                if (chars) {
                    index = html.indexOf("<");
                    var text = index < 0 ? html : html.substring(0, index);
                    html = index < 0 ? "" : html.substring(index);
                    if (handler.chars)
                        handler.chars(text);
                }
            }
            else {
                html = html.replace(new RegExp("(.*)<\/" + top() + "[^>]*>"), function (all, text) {
                    text = text.replace(/<!--(.*?)-->/g, "$1")
                        .replace(/<!\[CDATA\[(.*?)]]>/g, "$1");
                    if (handler.chars)
                        handler.chars(text);
                    return "";
                });
                parseEndTag("", top());
            }
            if (html == last)
                throw "Parse Error: " + html;
            last = html;
        }
        // Clean up any remaining tags
        parseEndTag();
        function parseStartTag(tag, tagName, rest, unary) {
            tagName = tagName.toLowerCase();
            if (block[tagName]) {
                while (top() && inline[top()]) {
                    parseEndTag("", top());
                }
            }
            if (closeSelf[tagName] && top() == tagName) {
                parseEndTag("", tagName);
            }
            unary = empty[tagName] || !!unary;
            if (!unary)
                stack.push(tagName);
            if (handler.start) {
                var attrs = Object.create(null);
                rest.replace(attr, function (match, name) {
                    name = name.toLowerCase();
                    var value = arguments[2] ? arguments[2] :
                        arguments[3] ? arguments[3] :
                            arguments[4] ? arguments[4] :
                                fillAttrs[name] ? name : "";
                    attrs[name] = value;
                    return match;
                });
                if (handler.start)
                    handler.start(tagName, attrs, !!unary);
            }
        }
        function parseEndTag(tag, tagName) {
            // If no tag name is provided, clean shop
            if (!tagName)
                var pos = 0;
            else
                for (var pos = stack.length - 1; pos >= 0; pos--)
                    if (stack[pos] == tagName)
                        break;
            if (pos >= 0) {
                // Close all the open elements, up the stack
                for (var i = stack.length - 1; i >= pos; i--)
                    if (handler.end)
                        handler.end(stack[i]);
                // Remove the open elements from the stack
                stack.length = pos;
            }
        }
    }
    Shumway.HTMLParser = HTMLParser;
    ;
    function makeMap(str) {
        var obj = {}, items = str.split(",");
        for (var i = 0; i < items.length; i++)
            obj[items[i]] = true;
        return obj;
    }
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Shumway;
(function (Shumway) {
    var notImplemented = Shumway.Debug.notImplemented;
    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
    var Bounds = Shumway.Bounds;
    var DataBuffer = Shumway.ArrayUtilities.DataBuffer;
    var ColorUtilities = Shumway.ColorUtilities;
    var flash = Shumway.AVMX.AS.flash;
    var altTieBreakRound = Shumway.NumberUtilities.altTieBreakRound;
    var _decodeHTMLMap = {
        lt: '<',
        gt: '>',
        amp: '&',
        quot: '"',
        apos: "'",
        nbsp: "\u00A0"
    };
    /**
     * Decodes strings of the format:
     *
     * &#0000;
     * &#x0000;
     * &#x0000;
     * &amp;
     * &lthello
     *
     * This is complete enough to handle encoded HTML produced by the Flash IDE.
     */
    function decodeHTML(s) {
        var r = "";
        for (var i = 0; i < s.length; i++) {
            var c = s.charAt(i);
            if (c !== '&') {
                r += c;
            }
            else {
                // Look for the first '&' or ';', both of these can terminate
                // the current char code.
                var j = Shumway.StringUtilities.indexOfAny(s, ['&', ';'], i + 1);
                if (j > 0) {
                    var v = s.substring(i + 1, j);
                    if (v.length > 1 && v.charAt(0) === "#") {
                        var n = 0;
                        if (v.length > 2 && v.charAt(1) === "x") {
                            n = parseInt(v.substring(1));
                        }
                        else {
                            n = parseInt(v.substring(2), 16);
                        }
                        r += String.fromCharCode(n);
                    }
                    else {
                        if (_decodeHTMLMap[v] !== undefined) {
                            r += _decodeHTMLMap[v];
                        }
                        else {
                            Shumway.Debug.unexpected(v);
                        }
                    }
                    i = j;
                }
                else {
                    // Flash sometimes generates entities that don't have terminators,
                    // like &bthello. Strong bad sometimes encodes this that way.
                    for (var k in _decodeHTMLMap) {
                        if (s.indexOf(k, i + 1) === i + 1) {
                            r += _decodeHTMLMap[k];
                            i += k.length;
                            break;
                        }
                    }
                }
            }
        }
        return r;
    }
    var TextContent = (function () {
        function TextContent(sec, defaultTextFormat) {
            this.sec = sec;
            this._id = sec.flash.display.DisplayObject.axClass.getNextSyncID();
            this._bounds = new Bounds(0, 0, 0, 0);
            this._plainText = '';
            this._backgroundColor = 0;
            this._borderColor = 0;
            this._autoSize = 0;
            this._wordWrap = false;
            this._scrollV = 1;
            this._scrollH = 0;
            this.flags = 0 /* None */;
            this.defaultTextFormat = defaultTextFormat || new sec.flash.text.TextFormat();
            this.textRuns = [];
            this.textRunData = new DataBuffer();
            this.matrix = null;
            this.coords = null;
        }
        TextContent.prototype.parseHtml = function (htmlText, styleSheet, multiline) {
            var _this = this;
            var plainText = '';
            var textRuns = this.textRuns;
            textRuns.length = 0;
            var beginIndex = 0;
            var endIndex = 0;
            var textFormat = this.defaultTextFormat.clone();
            var prevTextRun = null;
            var stack = [];
            var handler;
            Shumway.HTMLParser(htmlText, handler = {
                chars: function (text) {
                    text = decodeHTML(text);
                    plainText += text;
                    endIndex += text.length;
                    if (endIndex - beginIndex) {
                        if (prevTextRun && prevTextRun.textFormat.equals(textFormat)) {
                            prevTextRun.endIndex = endIndex;
                        }
                        else {
                            prevTextRun = new _this.sec.flash.text.TextRun(beginIndex, endIndex, textFormat);
                            textRuns.push(prevTextRun);
                        }
                        beginIndex = endIndex;
                    }
                },
                start: function (tagName, attributes) {
                    var hasStyle = false;
                    if (styleSheet) {
                        hasStyle = styleSheet.hasStyle(tagName);
                        if (hasStyle) {
                            stack.push(textFormat);
                            textFormat = textFormat.clone();
                            styleSheet.applyStyle(textFormat, tagName);
                        }
                    }
                    switch (tagName) {
                        case 'a':
                            stack.push(textFormat);
                            somewhatImplemented('<a/>');
                            var target = attributes.target || textFormat.target;
                            var url = attributes.url || textFormat.url;
                            if (target !== textFormat.target || url !== textFormat.url) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.target = target;
                                textFormat.url = url;
                            }
                            break;
                        case 'b':
                            stack.push(textFormat);
                            if (!textFormat.bold) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.bold = true;
                            }
                            break;
                        case 'font':
                            stack.push(textFormat);
                            var color = ColorUtilities.isValidHexColor(attributes.color) ? ColorUtilities.hexToRGB(attributes.color) : textFormat.color;
                            var font = attributes.face || textFormat.font;
                            var size = isNaN(attributes.size) ? textFormat.size : +attributes.size;
                            var letterSpacing = isNaN(attributes.letterspacing) ? textFormat.letterSpacing : +attributes.letterspacing;
                            var kerning = isNaN(attributes.kerning) ? textFormat.kerning : +attributes.kerning;
                            if (color !== textFormat.color ||
                                font !== textFormat.font ||
                                size !== textFormat.size ||
                                letterSpacing !== textFormat.letterSpacing ||
                                kerning !== textFormat.kerning) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.color = color;
                                textFormat.font = font;
                                textFormat.size = size;
                                textFormat.letterSpacing = letterSpacing;
                                textFormat.kerning = kerning;
                            }
                            break;
                        case 'img':
                            notImplemented('<img/>');
                            break;
                        case 'i':
                            stack.push(textFormat);
                            if (!textFormat.italic) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.italic = true;
                            }
                            break;
                        case 'li':
                            stack.push(textFormat);
                            if (!textFormat.bullet) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.bullet = true;
                            }
                            if (plainText[plainText.length - 1] === '\r') {
                                break;
                            }
                        case 'br':
                        case 'sbr':
                            if (multiline) {
                                handler.chars('\r');
                            }
                            break;
                        case 'span':
                        case 'p':
                            var hasClassStyle = false;
                            stack.push(textFormat);
                            if (styleSheet && attributes.class) {
                                var cssClass = '.' + attributes.class;
                                hasClassStyle = styleSheet.hasStyle(cssClass);
                                if (hasClassStyle) {
                                    if (!hasStyle) {
                                        textFormat = textFormat.clone();
                                    }
                                    styleSheet.applyStyle(textFormat, cssClass);
                                }
                            }
                            if (tagName === 'span') {
                                break;
                            }
                            var align = attributes.align;
                            if (flash.text.TextFormatAlign.toNumber(align) > -1 && align !== textFormat.align) {
                                if (!(hasStyle || hasClassStyle)) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.align = align;
                            }
                            break;
                        case 'textformat':
                            stack.push(textFormat);
                            var blockIndent = isNaN(attributes.blockindent) ? textFormat.blockIndent : +attributes.blockindent;
                            var indent = isNaN(attributes.indent) ? textFormat.indent : +attributes.indent;
                            var leading = isNaN(attributes.leading) ? textFormat.leading : +attributes.leading;
                            var leftMargin = isNaN(attributes.leftmargin) ? textFormat.leftMargin : +attributes.leftmargin;
                            var rightMargin = isNaN(attributes.rightmargin) ? textFormat.rightMargin : +attributes.rightmargin;
                            //var tabStops = attributes.tabstops || textFormat.tabStops;
                            if (blockIndent !== textFormat.blockIndent ||
                                indent !== textFormat.indent ||
                                leading !== textFormat.leading ||
                                leftMargin !== textFormat.leftMargin ||
                                rightMargin !== textFormat.rightMargin /*||
                            tabStops !== textFormat.tabStops*/) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.blockIndent = blockIndent;
                                textFormat.indent = indent;
                                textFormat.leading = leading;
                                textFormat.leftMargin = leftMargin;
                                textFormat.rightMargin = rightMargin;
                            }
                            break;
                        case 'u':
                            stack.push(textFormat);
                            if (!textFormat.underline) {
                                if (!hasStyle) {
                                    textFormat = textFormat.clone();
                                }
                                textFormat.underline = true;
                            }
                            break;
                    }
                },
                end: function (tagName) {
                    switch (tagName) {
                        case 'li':
                        case 'p':
                            if (multiline) {
                                handler.chars('\r');
                            }
                        case 'a':
                        case 'b':
                        case 'font':
                        case 'i':
                        case 'textformat':
                        case 'u':
                            textFormat = stack.pop();
                            if (styleSheet && styleSheet.hasStyle(tagName)) {
                                textFormat = stack.pop();
                            }
                    }
                }
            });
            this._plainText = plainText;
            this._serializeTextRuns();
        };
        Object.defineProperty(TextContent.prototype, "plainText", {
            get: function () {
                return this._plainText;
            },
            set: function (value) {
                this._plainText = value.split('\n').join('\r');
                this.textRuns.length = 0;
                if (value) {
                    var textRun = new this.sec.flash.text.TextRun(0, value.length, this.defaultTextFormat);
                    this.textRuns[0] = textRun;
                }
                this._serializeTextRuns();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "bounds", {
            get: function () {
                return this._bounds;
            },
            set: function (bounds) {
                this._bounds.copyFrom(bounds);
                this.flags |= 1 /* DirtyBounds */;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "autoSize", {
            get: function () {
                return this._autoSize;
            },
            set: function (value) {
                if (value === this._autoSize) {
                    return;
                }
                this._autoSize = value;
                if (this._plainText) {
                    this.flags |= 8 /* DirtyFlow */;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "wordWrap", {
            get: function () {
                return this._wordWrap;
            },
            set: function (value) {
                if (value === this._wordWrap) {
                    return;
                }
                this._wordWrap = value;
                if (this._plainText) {
                    this.flags |= 8 /* DirtyFlow */;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "scrollV", {
            get: function () {
                return this._scrollV;
            },
            set: function (value) {
                if (value === this._scrollV) {
                    return;
                }
                this._scrollV = value;
                if (this._plainText) {
                    this.flags |= 8 /* DirtyFlow */;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "scrollH", {
            get: function () {
                return this._scrollH;
            },
            set: function (value) {
                if (value === this._scrollH) {
                    return;
                }
                this._scrollH = value;
                if (this._plainText) {
                    this.flags |= 8 /* DirtyFlow */;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "backgroundColor", {
            get: function () {
                return this._backgroundColor;
            },
            set: function (value) {
                if (value === this._backgroundColor) {
                    return;
                }
                this._backgroundColor = value;
                this.flags |= 4 /* DirtyStyle */;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TextContent.prototype, "borderColor", {
            get: function () {
                return this._borderColor;
            },
            set: function (value) {
                if (value === this._borderColor) {
                    return;
                }
                this._borderColor = value;
                this.flags |= 4 /* DirtyStyle */;
            },
            enumerable: true,
            configurable: true
        });
        TextContent.prototype._serializeTextRuns = function () {
            var textRuns = this.textRuns;
            this.textRunData.clear();
            for (var i = 0; i < textRuns.length; i++) {
                this._writeTextRun(textRuns[i]);
            }
            this.flags |= 2 /* DirtyContent */;
        };
        TextContent.prototype._writeTextRun = function (textRun) {
            var textRunData = this.textRunData;
            textRunData.writeInt(textRun.beginIndex);
            textRunData.writeInt(textRun.endIndex);
            var textFormat = textRun.textFormat;
            var size = +textFormat.size;
            textRunData.writeInt(size);
            var fontClass = this.sec.flash.text.Font.axClass;
            var font = fontClass.getByNameAndStyle(textFormat.font, textFormat.style) ||
                fontClass.getDefaultFont();
            if (font.fontType === flash.text.FontType.EMBEDDED) {
                textRunData.writeUTF('swffont' + font._id);
            }
            else {
                textRunData.writeUTF(font._fontFamily);
            }
            textRunData.writeInt(altTieBreakRound(font.ascent * size, true));
            textRunData.writeInt(altTieBreakRound(font.descent * size, false));
            textRunData.writeInt(textFormat.leading === null ? font.leading * size : +textFormat.leading);
            // For embedded fonts, always set bold and italic to false. They're fully identified by name.
            var bold = false;
            var italic = false;
            if (font.fontType === flash.text.FontType.DEVICE) {
                if (textFormat.bold === null) {
                    bold = font.fontStyle === flash.text.FontStyle.BOLD ||
                        font.fontType === flash.text.FontStyle.BOLD_ITALIC;
                }
                else {
                    bold = !!textFormat.bold;
                }
                if (textFormat.italic === null) {
                    italic = font.fontStyle === flash.text.FontStyle.ITALIC ||
                        font.fontType === flash.text.FontStyle.BOLD_ITALIC;
                }
                else {
                    italic = !!textFormat.italic;
                }
            }
            textRunData.writeBoolean(bold);
            textRunData.writeBoolean(italic);
            textRunData.writeInt(+textFormat.color);
            textRunData.writeInt(flash.text.TextFormatAlign.toNumber(textFormat.align));
            textRunData.writeBoolean(!!textFormat.bullet);
            //textRunData.writeInt(textFormat.display);
            textRunData.writeInt(+textFormat.indent);
            //textRunData.writeInt(textFormat.blockIndent);
            textRunData.writeInt(+textFormat.kerning);
            textRunData.writeInt(+textFormat.leftMargin);
            textRunData.writeInt(+textFormat.letterSpacing);
            textRunData.writeInt(+textFormat.rightMargin);
            //textRunData.writeInt(textFormat.tabStops);
            textRunData.writeBoolean(!!textFormat.underline);
        };
        TextContent.prototype.appendText = function (newText, format) {
            if (!format) {
                format = this.defaultTextFormat;
            }
            var plainText = this._plainText;
            var newRun = new this.sec.flash.text.TextRun(plainText.length, plainText.length + newText.length, format);
            this._plainText = plainText + newText;
            this.textRuns.push(newRun);
            this._writeTextRun(newRun);
        };
        TextContent.prototype.prependText = function (newText, format) {
            if (!format) {
                format = this.defaultTextFormat;
            }
            var plainText = this._plainText;
            this._plainText = newText + plainText;
            var textRuns = this.textRuns;
            var shift = newText.length;
            for (var i = 0; i < textRuns.length; i++) {
                var run = textRuns[i];
                run.beginIndex += shift;
                run.endIndex += shift;
            }
            textRuns.unshift(new this.sec.flash.text.TextRun(0, shift, format));
            this._serializeTextRuns();
        };
        TextContent.prototype.replaceText = function (beginIndex, endIndex, newText, format) {
            if (endIndex < beginIndex || !newText) {
                return;
            }
            if (endIndex === 0) {
                // Insert text at the beginning.
                this.prependText(newText, format);
                return;
            }
            var plainText = this._plainText;
            // When inserting text to the end, we can simply add a new text run without changing any
            // existing ones.
            if (beginIndex >= plainText.length) {
                this.appendText(newText, format);
                return;
            }
            var defaultTextFormat = this.defaultTextFormat;
            // A text format used for new text runs will have unset properties merged in from the default
            // text format.
            var newFormat = defaultTextFormat;
            if (format) {
                newFormat = newFormat.clone();
                newFormat.merge(format);
            }
            // If replacing the whole text, just regenerate runs by setting plainText.
            if (beginIndex <= 0 && endIndex >= plainText.length) {
                if (format) {
                    // Temporarily set the passed text format as default.
                    this.defaultTextFormat = newFormat;
                    this.plainText = newText;
                    // Restore the original default when finished.
                    this.defaultTextFormat = defaultTextFormat;
                }
                else {
                    this.plainText = newText;
                }
                return;
            }
            var textRuns = this.textRuns;
            var newTextRuns = [];
            var newEndIndex = beginIndex + newText.length;
            var shift = newEndIndex - endIndex;
            for (var i = 0; i < textRuns.length; i++) {
                var run = textRuns[i];
                var isLast = i >= textRuns.length - 1;
                if (beginIndex < run.endIndex) {
                    // Skip all following steps (including adding the current run to the new list of runs) if
                    // the inserted text overlaps the current run, which is not the last one.
                    if (!isLast && beginIndex <= run.beginIndex && newEndIndex >= run.endIndex) {
                        continue;
                    }
                    var containsBeginIndex = run.containsIndex(beginIndex);
                    var containsEndIndex = run.containsIndex(endIndex) ||
                        (isLast && endIndex >= run.endIndex);
                    if (containsBeginIndex && containsEndIndex) {
                        // The current run spans over the inserted text.
                        if (format) {
                            // Split up the current run.
                            var clone = run.clone();
                            clone.endIndex = beginIndex;
                            newTextRuns.push(clone);
                            i--;
                            run.beginIndex = beginIndex + 1;
                            continue;
                        }
                    }
                    else if (containsBeginIndex) {
                        // Run is intersecting on the left. Adjust its length.
                        run.endIndex = beginIndex;
                    }
                    else if (containsEndIndex) {
                        // If a a text format was passed, a new run needs to be inserted.
                        if (format) {
                            newTextRuns.push(new this.sec.flash.text.TextRun(beginIndex, newEndIndex, newFormat));
                            run.beginIndex = newEndIndex;
                        }
                        else {
                            // Otherwise make the current run span over the inserted text.
                            run.beginIndex = beginIndex;
                            run.endIndex += shift;
                        }
                    }
                    else {
                        // No intersection, shift entire run to the right.
                        run.beginIndex += shift;
                        run.endIndex += shift;
                    }
                }
                // Ignore empty runs.
                if (run.endIndex > run.beginIndex) {
                    newTextRuns.push(run);
                }
            }
            this._plainText = plainText.substring(0, beginIndex) + newText + plainText.substring(endIndex);
            this.textRuns = newTextRuns;
            this._serializeTextRuns();
        };
        return TextContent;
    })();
    Shumway.TextContent = TextContent;
})(Shumway || (Shumway = {}));
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var OptionSet = Shumway.Options.OptionSet;
            var shumwayOptions = Shumway.Settings.shumwayOptions;
            AS.flashOptions = shumwayOptions.register(new OptionSet("Flash Options"));
            AS.traceEventsOption = AS.flashOptions.register(new Shumway.Options.Option("te", "Trace Events", "boolean", false, "Trace dispatching of events."));
            AS.traceLoaderOption = AS.flashOptions.register(new Shumway.Options.Option("tp", "Trace Loader", "boolean", false, "Trace loader execution."));
            AS.disableAudioOption = AS.flashOptions.register(new Shumway.Options.Option("da", "Disable Audio", "boolean", false, "Disables audio."));
            AS.webAudioOption = AS.flashOptions.register(new Shumway.Options.Option(null, "Use WebAudio for Sound", "boolean", false, "Enables WebAudio API for MovieClip sound stream. (MP3 format is an exception)"));
            AS.webAudioMP3Option = AS.flashOptions.register(new Shumway.Options.Option(null, "Use MP3 decoding to WebAudio", "boolean", false, "Enables WebAudio API and software MP3 decoding and disables any AUDIO tag usage for MP3 format"));
            AS.mediaSourceOption = AS.flashOptions.register(new Shumway.Options.Option(null, "Use Media Source for Video", "boolean", false, "Enables Media Source Extension API for NetStream."));
            AS.mediaSourceMP3Option = AS.flashOptions.register(new Shumway.Options.Option(null, "Use Media Source for MP3", "boolean", true, "Enables Media Source Extension API for MP3 streams."));
            AS.flvOption = AS.flashOptions.register(new Shumway.Options.Option(null, "FLV support.", "string", "unsupported", "Defines how to deal with FLV streams."));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Shumway;
(function (Shumway) {
    var Timeline;
    (function (Timeline) {
        var isInteger = Shumway.isInteger;
        var assert = Shumway.Debug.assert;
        var warning = Shumway.Debug.warning;
        var Bounds = Shumway.Bounds;
        /**
         * TODO document
         */
        var Symbol = (function () {
            function Symbol(data, symbolDefaultClass) {
                release || assert(isInteger(data.id));
                this.data = data;
                if (data.className) {
                    var app = data.env.app;
                    try {
                        var symbolClass = app.getClass(Shumway.AVMX.Multiname.FromFQNString(data.className, 0 /* Public */));
                        this.symbolClass = symbolClass;
                        // The symbolClass should have received a lazy symbol resolver in Loader#_applyLoadUpdate.
                        release || assert(symbolClass.tPrototype.hasOwnProperty('_symbol'));
                        // Replace it by this symbol without triggering the resolver and causing an infinite
                        // recursion.
                        Object.defineProperty(symbolClass.tPrototype, '_symbol', { value: this });
                    }
                    catch (e) {
                        warning("Symbol " + data.id + " bound to non-existing class " + data.className);
                        this.symbolClass = symbolDefaultClass;
                    }
                }
                else {
                    this.symbolClass = symbolDefaultClass;
                }
                this.isAVM1Object = false;
            }
            Object.defineProperty(Symbol.prototype, "id", {
                get: function () {
                    return this.data.id;
                },
                enumerable: true,
                configurable: true
            });
            return Symbol;
        })();
        Timeline.Symbol = Symbol;
        var DisplaySymbol = (function (_super) {
            __extends(DisplaySymbol, _super);
            function DisplaySymbol(data, symbolClass, dynamic) {
                _super.call(this, data, symbolClass);
                this.dynamic = dynamic;
            }
            DisplaySymbol.prototype._setBoundsFromData = function (data) {
                this.fillBounds = data.fillBounds ? Bounds.FromUntyped(data.fillBounds) : null;
                this.lineBounds = data.lineBounds ? Bounds.FromUntyped(data.lineBounds) : null;
                if (!this.lineBounds && this.fillBounds) {
                    this.lineBounds = this.fillBounds.clone();
                }
            };
            return DisplaySymbol;
        })(Symbol);
        Timeline.DisplaySymbol = DisplaySymbol;
        var BinarySymbol = (function (_super) {
            __extends(BinarySymbol, _super);
            function BinarySymbol(data, sec) {
                _super.call(this, data, sec.flash.utils.ByteArray.axClass);
            }
            BinarySymbol.FromData = function (data, loaderInfo) {
                var symbol = new BinarySymbol(data, loaderInfo.app.sec);
                symbol.buffer = data.data;
                symbol.byteLength = data.data.byteLength;
                return symbol;
            };
            return BinarySymbol;
        })(Symbol);
        Timeline.BinarySymbol = BinarySymbol;
        var SoundStart = (function () {
            function SoundStart(soundId, soundInfo) {
                this.soundId = soundId;
                this.soundInfo = soundInfo;
            }
            return SoundStart;
        })();
        Timeline.SoundStart = SoundStart;
    })(Timeline = Shumway.Timeline || (Shumway.Timeline = {}));
})(Shumway || (Shumway = {}));
/*
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var Browser;
    (function (Browser) {
        var ShumwayComRtmpSocket = (function () {
            function ShumwayComRtmpSocket(host, port, params) {
                this._socket = ShumwayCom.createRtmpSocket({ host: host, port: port, ssl: params.useSecureTransport });
            }
            Object.defineProperty(ShumwayComRtmpSocket, "isAvailable", {
                get: function () {
                    return !!(typeof ShumwayCom !== 'undefined' && ShumwayCom.createRtmpSocket);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpSocket.prototype, "onopen", {
                get: function () {
                    return this._onopen;
                },
                set: function (callback) {
                    this._socket.setOpenCallback(this._onopen = callback);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpSocket.prototype, "ondata", {
                get: function () {
                    return this._ondata;
                },
                set: function (callback) {
                    this._socket.setDataCallback(this._ondata = callback);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpSocket.prototype, "ondrain", {
                get: function () {
                    return this._ondrain;
                },
                set: function (callback) {
                    this._socket.setDrainCallback(this._ondrain = callback);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpSocket.prototype, "onerror", {
                get: function () {
                    return this._onerror;
                },
                set: function (callback) {
                    this._socket.setErrorCallback(this._onerror = callback);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpSocket.prototype, "onclose", {
                get: function () {
                    return this._onclose;
                },
                set: function (callback) {
                    this._socket.setCloseCallback(this._onclose = callback);
                },
                enumerable: true,
                configurable: true
            });
            ShumwayComRtmpSocket.prototype.send = function (buffer, offset, count) {
                return this._socket.send(buffer, offset, count);
            };
            ShumwayComRtmpSocket.prototype.close = function () {
                this._socket.close();
            };
            return ShumwayComRtmpSocket;
        })();
        Browser.ShumwayComRtmpSocket = ShumwayComRtmpSocket;
        var ShumwayComRtmpXHR = (function () {
            function ShumwayComRtmpXHR() {
                this._xhr = ShumwayCom.createRtmpXHR();
            }
            Object.defineProperty(ShumwayComRtmpXHR, "isAvailable", {
                get: function () {
                    return !!(typeof ShumwayCom !== 'undefined' && ShumwayCom.createRtmpXHR);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpXHR.prototype, "status", {
                get: function () {
                    return this._xhr.status;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpXHR.prototype, "response", {
                get: function () {
                    return this._xhr.response;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpXHR.prototype, "responseType", {
                get: function () {
                    return this._xhr.responseType;
                },
                set: function (type) {
                    this._xhr.responseType = type;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpXHR.prototype, "onload", {
                get: function () {
                    return this._onload;
                },
                set: function (callback) {
                    this._xhr.setLoadCallback(this._onload = callback);
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ShumwayComRtmpXHR.prototype, "onerror", {
                get: function () {
                    return this._onload;
                },
                set: function (callback) {
                    this._xhr.setErrorCallback(this._onerror = callback);
                },
                enumerable: true,
                configurable: true
            });
            ShumwayComRtmpXHR.prototype.open = function (method, path, async) {
                if (async === void 0) { async = true; }
                this._xhr.open(method, path, async);
            };
            ShumwayComRtmpXHR.prototype.setRequestHeader = function (header, value) {
                this._xhr.setRequestHeader(header, value);
            };
            ShumwayComRtmpXHR.prototype.send = function (data) {
                this._xhr.send(data);
            };
            return ShumwayComRtmpXHR;
        })();
        Browser.ShumwayComRtmpXHR = ShumwayComRtmpXHR;
    })(Browser = RtmpJs.Browser || (RtmpJs.Browser = {}));
})(RtmpJs || (RtmpJs = {}));
/*
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var MAX_CHUNKED_CHANNEL_BUFFER = 0x80000;
    var RANDOM_DATA_SIZE = 1536;
    var PROTOCOL_VERSION = 3;
    var SET_CHUNK_SIZE_CONTROL_MESSAGE_ID = 1;
    var ABORT_MESSAGE_CONTROL_MESSAGE_ID = 2;
    var ACK_MESSAGE_ID = 3;
    var USER_CONTROL_MESSAGE_ID = 4;
    var ACK_WINDOW_SIZE_MESSAGE_ID = 5;
    var SET_PEER_BANDWIDTH_MESSAGE_ID = 6;
    var CONTROL_CHUNK_STREAM_ID = 2;
    var MIN_CHUNK_STREAM_ID = 3;
    var MAX_CHUNK_STREAM_ID = 65599;
    var MAX_CHUNK_HEADER_SIZE = 18;
    var ChunkedStream = (function () {
        function ChunkedStream(id) {
            this.onmessage = null;
            this.id = id;
            this.buffer = null;
            this.bufferLength = 0;
            this.lastStreamId = -1;
            this.lastTimestamp = 0;
            this.lastLength = 0;
            this.lastTypeId = 0;
            this.lastMessageComplete = false;
            this.waitingForBytes = 0;
            this.sentStreamId = -1;
            this.sentTimestamp = 0;
            this.sentLength = 0;
            this.sentTypeId = 0;
        }
        ChunkedStream.prototype.setBuffer = function (enabled) {
            if (enabled && !this.buffer) {
                this.buffer = new Uint8Array(128);
                this.bufferLength = 0;
            }
            if (!enabled && this.buffer) {
                this.buffer = null;
                this.bufferLength = 0;
            }
        };
        ChunkedStream.prototype.abort = function () {
            if (this.buffer) {
                this.bufferLength = 0;
            }
            else if (!this.lastMessageComplete) {
                this.lastMessageComplete = true;
                this.onmessage({
                    timestamp: this.lastTimestamp,
                    streamId: this.lastStreamId,
                    chunkedStreamId: this.id,
                    typeId: this.lastTypeId,
                    data: null,
                    firstChunk: false,
                    lastChunk: true
                });
            }
        };
        ChunkedStream.prototype._push = function (data, firstChunk, lastChunk) {
            if (!this.onmessage) {
                return;
            }
            if ((firstChunk && lastChunk) || !this.buffer) {
                this.onmessage({
                    timestamp: this.lastTimestamp,
                    streamId: this.lastStreamId,
                    chunkedStreamId: this.id,
                    typeId: this.lastTypeId,
                    data: data,
                    firstChunk: firstChunk,
                    lastChunk: lastChunk
                });
                return;
            }
            if (firstChunk) {
                this.bufferLength = 0;
                if (this.lastLength > this.buffer.length) {
                    this.buffer = new Uint8Array(this.lastLength);
                }
            }
            this.buffer.set(data, this.bufferLength);
            this.bufferLength += data.length;
            if (lastChunk) {
                this.onmessage({
                    timestamp: this.lastTimestamp,
                    streamId: this.lastStreamId,
                    chunkedStreamId: this.id,
                    typeId: this.lastTypeId,
                    data: this.buffer.subarray(0, this.bufferLength),
                    firstChunk: true,
                    lastChunk: true
                });
            }
        };
        return ChunkedStream;
    })();
    RtmpJs.ChunkedStream = ChunkedStream;
    var ChunkedChannel = (function () {
        function ChunkedChannel() {
            this.onusercontrolmessage = null;
            this.onack = null;
            this.ondata = function (data) { };
            this.onclose = function () { };
            this.oncreated = null;
            this.state = 'uninitialized';
            this.buffer = new Uint8Array(4092);
            this.bufferLength = 0;
            this.chunkSize = 128;
            this.chunkStreams = [];
            this.peerChunkSize = 128;
            this.peerAckWindowSize = 0;
            this.bandwidthLimitType = 0;
            this.windowAckSize = 0;
            this.bytesReceived = 0;
            this.lastAckSent = 0;
        }
        ChunkedChannel.prototype.push = function (data) {
            var newDataLength = data.length + this.bufferLength;
            if (newDataLength > this.buffer.length) {
                var newBufferLength = this.buffer.length * 2;
                while (newDataLength > newBufferLength) {
                    newBufferLength *= 2;
                }
                if (newBufferLength > MAX_CHUNKED_CHANNEL_BUFFER) {
                    this._fail('Buffer overflow');
                }
                var newBuffer = new Uint8Array(newBufferLength);
                newBuffer.set(this.buffer);
                this.buffer = newBuffer;
            }
            for (var i = 0, j = this.bufferLength; i < data.length; i++, j++) {
                this.buffer[j] = data[i];
            }
            this.bufferLength = newDataLength;
            this.bytesReceived += data.length;
            if (this.peerAckWindowSize &&
                (this.bytesReceived - this.lastAckSent) >= this.peerAckWindowSize) {
                this._sendAck();
            }
            while (this.bufferLength > 0) {
                // release || console.log('current bufferLength: ' + this.bufferLength + ' state:' + this.state);
                var shiftBy = 0;
                switch (this.state) {
                    case 'uninitialized':
                        if (this.bufferLength < 1) {
                            return;
                        }
                        this.serverVersion = this.buffer[0];
                        shiftBy = 1;
                        if (this.serverVersion !== PROTOCOL_VERSION) {
                            this._fail('Unsupported protocol version: ' + this.serverVersion);
                        }
                        this.state = 'version_received';
                        break;
                    case 'version_received':
                        if (this.bufferLength < RANDOM_DATA_SIZE) {
                            return;
                        }
                        shiftBy = RANDOM_DATA_SIZE;
                        var timestamp = (Date.now() - this.epochStart) | 0;
                        this.buffer[4] = (timestamp >>> 24) & 0xFF;
                        this.buffer[5] = (timestamp >>> 16) & 0xFF;
                        this.buffer[6] = (timestamp >>> 8) & 0xFF;
                        this.buffer[7] = timestamp & 0xFF;
                        this.ondata(this.buffer.subarray(0, RANDOM_DATA_SIZE));
                        this.state = 'ack_sent';
                        break;
                    case 'ack_sent':
                        if (this.bufferLength < RANDOM_DATA_SIZE) {
                            return;
                        }
                        shiftBy = RANDOM_DATA_SIZE;
                        for (var i = 8; i < RANDOM_DATA_SIZE; i++) {
                            if (this.buffer[i] !== this.randomData[i]) {
                                this._fail('Random data do not match @' + i);
                            }
                        }
                        this.state = 'handshake_done';
                        this.lastAckSent = this.bytesReceived;
                        this._initialize();
                        break;
                    case 'handshake_done':
                        shiftBy = this._parseChunkedData();
                        if (!shiftBy) {
                            return;
                        }
                        break;
                    default:
                        return;
                }
                this.buffer.set(this.buffer.subarray(shiftBy, this.bufferLength), 0);
                this.bufferLength -= shiftBy;
            }
        };
        ChunkedChannel.prototype._initialize = function () {
            var controlStream = this._getChunkStream(CONTROL_CHUNK_STREAM_ID);
            controlStream.setBuffer(true);
            controlStream.onmessage = function (e) {
                if (e.streamId !== 0) {
                    return;
                }
                release || console.log('Control message: ' + e.typeId);
                switch (e.typeId) {
                    case SET_CHUNK_SIZE_CONTROL_MESSAGE_ID:
                        var newChunkSize = (e.data[0] << 24) | (e.data[1] << 16) |
                            (e.data[2] << 8) | e.data[3];
                        if (newChunkSize >= 1 && newChunkSize <= 0x7FFFFFFF) {
                            this.peerChunkSize = newChunkSize;
                        }
                        break;
                    case ABORT_MESSAGE_CONTROL_MESSAGE_ID:
                        var chunkStreamId = (e.data[0] << 24) | (e.data[1] << 16) |
                            (e.data[2] << 8) | e.data[3];
                        if (MIN_CHUNK_STREAM_ID <= chunkStreamId &&
                            chunkStreamId <= MAX_CHUNK_STREAM_ID) {
                            var chunkStream = this._getChunkStream(chunkStreamId);
                            chunkStream.abort();
                        }
                        break;
                    case ACK_MESSAGE_ID:
                        if (this.onack) {
                            this.onack();
                        }
                        break;
                    case USER_CONTROL_MESSAGE_ID:
                        if (this.onusercontrolmessage) {
                            this.onusercontrolmessage({
                                type: (e.data[0] << 8) | e.data[1],
                                data: e.data.subarray(2)
                            });
                        }
                        break;
                    case ACK_WINDOW_SIZE_MESSAGE_ID:
                        var ackWindowSize = (e.data[0] << 24) | (e.data[1] << 16) |
                            (e.data[2] << 8) | e.data[3];
                        if (ackWindowSize < 0) {
                            break;
                        }
                        this.peerAckWindowSize = ackWindowSize;
                        break;
                    case SET_PEER_BANDWIDTH_MESSAGE_ID:
                        var ackWindowSize = (e.data[0] << 24) | (e.data[1] << 16) |
                            (e.data[2] << 8) | e.data[3];
                        var limitType = e.data[4];
                        if (ackWindowSize < 0 || limitType > 2) {
                            break;
                        }
                        if (limitType === 1 ||
                            (limitType === 2 && this.bandwidthLimitType === 1)) {
                            ackWindowSize = Math.min(this.windowAckSize, ackWindowSize);
                        }
                        if (ackWindowSize !== this.ackWindowSize) {
                            this.ackWindowSize = ackWindowSize;
                            var ackData = new Uint8Array([(ackWindowSize >>> 24) & 0xFF,
                                (ackWindowSize >>> 16) & 0xFF,
                                (ackWindowSize >>> 8) & 0xFF,
                                ackWindowSize & 0xFF]);
                            this._sendMessage(CONTROL_CHUNK_STREAM_ID, {
                                typeId: ACK_WINDOW_SIZE_MESSAGE_ID,
                                streamId: 0,
                                data: ackData
                            });
                            if (limitType !== 2) {
                                this.bandwidthLimitType = limitType;
                            }
                        }
                        break;
                }
            }.bind(this);
            if (this.oncreated) {
                this.oncreated();
            }
        };
        ChunkedChannel.prototype.setChunkSize = function (chunkSize) {
            if (chunkSize < 1 || chunkSize > 0x7FFFFFFF) {
                throw new Error('Invalid chunk size');
            }
            this._sendMessage(CONTROL_CHUNK_STREAM_ID, {
                streamId: 0,
                typeId: SET_CHUNK_SIZE_CONTROL_MESSAGE_ID,
                data: new Uint8Array([(chunkSize >>> 24) & 0xFF,
                    (chunkSize >>> 16) & 0xFF,
                    (chunkSize >>> 8) & 0xFF,
                    chunkSize & 0xFF])
            });
            this.chunkSize = chunkSize;
        };
        ChunkedChannel.prototype.send = function (chunkStreamId, message) {
            if (chunkStreamId < MIN_CHUNK_STREAM_ID ||
                chunkStreamId > MAX_CHUNK_STREAM_ID) {
                throw new Error('Invalid chunkStreamId');
            }
            return this._sendMessage(chunkStreamId, message);
        };
        ChunkedChannel.prototype.sendUserControlMessage = function (type, data) {
            var eventData = new Uint8Array(2 + data.length);
            eventData[0] = (type >> 8) & 0xFF;
            eventData[1] = type & 0xFF;
            eventData.set(data, 2);
            this._sendMessage(CONTROL_CHUNK_STREAM_ID, {
                typeId: USER_CONTROL_MESSAGE_ID,
                streamId: 0,
                data: eventData
            });
        };
        ChunkedChannel.prototype._sendAck = function () {
            var ackData = new Uint8Array([(this.bytesReceived >>> 24) & 0xFF,
                (this.bytesReceived >>> 16) & 0xFF,
                (this.bytesReceived >>> 8) & 0xFF,
                this.bytesReceived & 0xFF]);
            this._sendMessage(CONTROL_CHUNK_STREAM_ID, {
                typeId: ACK_MESSAGE_ID,
                streamId: 0,
                data: ackData
            });
        };
        ChunkedChannel.prototype._sendMessage = function (chunkStreamId, message) {
            var data = message.data;
            var messageLength = data.length;
            var chunkStream = this._getChunkStream(chunkStreamId);
            var timestamp = ('timestamp' in message ? message.timestamp : (Date.now() - this.epochStart)) | 0;
            var timestampDelta = (timestamp - chunkStream.sentTimestamp) | 0;
            var buffer = new Uint8Array(this.chunkSize + MAX_CHUNK_HEADER_SIZE);
            var chunkStreamIdSize;
            if (chunkStreamId < 64) {
                chunkStreamIdSize = 1;
                buffer[0] = chunkStreamId;
            }
            else if (chunkStreamId < 320) {
                chunkStreamIdSize = 2;
                buffer[0] = 0;
                buffer[1] = chunkStreamId - 64;
            }
            else {
                chunkStreamIdSize = 3;
                buffer[0] = 1;
                buffer[1] = ((chunkStreamId - 64) >> 8) & 0xFF;
                buffer[2] = (chunkStreamId - 64) & 0xFF;
            }
            var position = chunkStreamIdSize;
            var extendTimestamp = 0;
            if (message.streamId !== chunkStream.sentStreamId || timestampDelta < 0) {
                // chunk type 0
                if ((timestamp & 0xFF000000) !== 0) {
                    extendTimestamp = timestamp;
                    buffer[position] = buffer[position + 1] = buffer[position + 2] = 0xFF;
                }
                else {
                    buffer[position] = (timestamp >> 16) & 0xFF;
                    buffer[position + 1] = (timestamp >> 8) & 0xFF;
                    buffer[position + 2] = timestamp & 0xFF;
                }
                position += 3;
                buffer[position++] = (messageLength >> 16) & 0xFF;
                buffer[position++] = (messageLength >> 8) & 0xFF;
                buffer[position++] = messageLength & 0xFF;
                buffer[position++] = message.typeId;
                buffer[position++] = message.streamId & 0xFF; // little-endian
                buffer[position++] = (message.streamId >> 8) & 0xFF;
                buffer[position++] = (message.streamId >> 16) & 0xFF;
                buffer[position++] = (message.streamId >> 24) & 0xFF;
            }
            else if (messageLength !== chunkStream.sentLength ||
                message.typeId !== chunkStream.sentTypeId) {
                // chunk type 1
                buffer[0] |= 0x40;
                if ((timestampDelta & 0xFF000000) !== 0) {
                    extendTimestamp = timestampDelta;
                    buffer[position] = buffer[position + 1] = buffer[position + 2] = 0xFF;
                }
                else {
                    buffer[position] = (timestampDelta >> 16) & 0xFF;
                    buffer[position + 1] = (timestampDelta >> 8) & 0xFF;
                    buffer[position + 2] = timestampDelta & 0xFF;
                }
                position += 3;
                buffer[position++] = (messageLength >> 16) & 0xFF;
                buffer[position++] = (messageLength >> 8) & 0xFF;
                buffer[position++] = messageLength & 0xFF;
                buffer[position++] = message.typeId;
            }
            else if (timestampDelta !== 0) {
                // chunk type 2
                buffer[0] |= 0x80;
                if ((timestampDelta & 0xFF000000) !== 0) {
                    extendTimestamp = timestampDelta;
                    buffer[position] = buffer[position + 1] = buffer[position + 2] = 0xFF;
                }
                else {
                    buffer[position] = (timestampDelta >> 16) & 0xFF;
                    buffer[position + 1] = (timestampDelta >> 8) & 0xFF;
                    buffer[position + 2] = timestampDelta & 0xFF;
                }
                position += 3;
            }
            else {
                // chunk type 3
                buffer[0] |= 0xC0;
            }
            if (extendTimestamp) {
                buffer[position++] = (extendTimestamp >>> 24) & 0xFF;
                buffer[position++] = (extendTimestamp >>> 16) & 0xFF;
                buffer[position++] = (extendTimestamp >>> 8) & 0xFF;
                buffer[position++] = extendTimestamp & 0xFF;
            }
            chunkStream.sentTimestamp = timestamp;
            chunkStream.sentStreamId = message.streamId;
            chunkStream.sentTypeId = message.typeId;
            chunkStream.sentLength = messageLength;
            var sent = 0;
            while (sent < messageLength) {
                var currentChunkLength = Math.min(messageLength - sent, this.chunkSize);
                buffer.set(data.subarray(sent, sent + currentChunkLength), position);
                sent += currentChunkLength;
                this.ondata(buffer.subarray(0, position + currentChunkLength));
                // reset position and chunk type
                buffer[0] |= 0xC0;
                position = chunkStreamIdSize;
            }
            return timestamp;
        };
        ChunkedChannel.prototype._getChunkStream = function (id) {
            var chunkStream = this.chunkStreams[id];
            if (!chunkStream) {
                this.chunkStreams[id] = chunkStream = new ChunkedStream(id);
                chunkStream.setBuffer(true);
                chunkStream.onmessage = function (message) {
                    if (this.onmessage) {
                        this.onmessage(message);
                    }
                }.bind(this);
            }
            return chunkStream;
        };
        ChunkedChannel.prototype._parseChunkedData = function () {
            if (this.bufferLength < 1) {
                return;
            }
            var chunkType = (this.buffer[0] >> 6) & 3;
            var chunkHeaderPosition = 1;
            var chunkStreamId = this.buffer[0] & 0x3F;
            if (chunkStreamId === 0) {
                if (this.bufferLength < 2) {
                    return;
                }
                chunkStreamId = this.buffer[1] + 64;
                chunkHeaderPosition = 2;
            }
            else if (chunkStreamId === 1) {
                if (this.bufferLength < 2) {
                    return;
                }
                chunkStreamId = (this.buffer[1] << 8) + this.buffer[2] + 64;
                chunkHeaderPosition = 3;
            }
            var chunkHeaderSize = chunkType === 0 ? 11 : chunkType === 1 ? 7 :
                chunkType === 2 ? 3 : 0;
            if (this.bufferLength < chunkHeaderPosition + chunkHeaderSize) {
                return;
            }
            var extendTimestampSize = chunkType !== 3 &&
                this.buffer[chunkHeaderPosition] === 0xFF &&
                this.buffer[chunkHeaderPosition + 1] === 0xFF &&
                this.buffer[chunkHeaderPosition + 2] === 0xFF ? 4 : 0;
            var totalChunkHeaderSize = chunkHeaderPosition + chunkHeaderSize +
                extendTimestampSize;
            if (this.bufferLength < totalChunkHeaderSize) {
                return;
            }
            var chunkStream = this._getChunkStream(chunkStreamId);
            var chunkTimestamp;
            if (chunkType === 3) {
                chunkTimestamp = chunkStream.lastTimestamp;
            }
            else {
                chunkTimestamp = (this.buffer[chunkHeaderPosition] << 16) |
                    (this.buffer[chunkHeaderPosition + 1] << 8) |
                    this.buffer[chunkHeaderPosition + 2];
            }
            if (extendTimestampSize) {
                var chunkTimestampPosition = chunkHeaderPosition + chunkHeaderSize;
                chunkTimestamp = (this.buffer[chunkTimestampPosition] << 24) |
                    (this.buffer[chunkTimestampPosition + 1] << 16) |
                    (this.buffer[chunkTimestampPosition + 2] << 8) |
                    this.buffer[chunkTimestampPosition + 3];
            }
            if (chunkType === 1 || chunkType === 2) {
                chunkTimestamp = (chunkStream.lastTimestamp + chunkTimestamp) | 0;
            }
            var messageLength = chunkStream.lastLength;
            var messageTypeId = chunkStream.lastTypeId;
            var messageStreamId = chunkStream.lastStreamId;
            if (chunkType === 0 || chunkType === 1) {
                messageLength = (this.buffer[chunkHeaderPosition + 3] << 16) |
                    (this.buffer[chunkHeaderPosition + 4] << 8) |
                    this.buffer[chunkHeaderPosition + 5];
                messageTypeId = this.buffer[chunkHeaderPosition + 6];
            }
            if (chunkType === 0) {
                // little-endian
                messageStreamId = (this.buffer[chunkHeaderPosition + 10] << 24) |
                    (this.buffer[chunkHeaderPosition + 9] << 16) |
                    (this.buffer[chunkHeaderPosition + 8] << 8) |
                    this.buffer[chunkHeaderPosition + 7];
            }
            var read, tailLength, firstChunk;
            if (chunkType === 3 && chunkStream.waitingForBytes) {
                firstChunk = false;
                read = Math.min(chunkStream.waitingForBytes, this.peerChunkSize);
                tailLength = chunkStream.waitingForBytes - read;
            }
            else {
                firstChunk = true;
                read = Math.min(messageLength, this.peerChunkSize);
                tailLength = messageLength - read;
            }
            if (this.bufferLength < totalChunkHeaderSize + read) {
                return;
            }
            release || (!firstChunk && tailLength) ||
                console.log('Chunk received: cs:' + chunkStreamId + '; ' +
                    'f/l:' + firstChunk + '/' + (!tailLength) + ';  len:' + messageLength);
            chunkStream.lastTimestamp = chunkTimestamp;
            chunkStream.lastLength = messageLength;
            chunkStream.lastTypeId = messageTypeId;
            chunkStream.lastStreamId = messageStreamId;
            chunkStream.lastMessageComplete = !tailLength;
            chunkStream.waitingForBytes = tailLength;
            chunkStream._push(this.buffer.subarray(totalChunkHeaderSize, totalChunkHeaderSize + read), firstChunk, !tailLength);
            return totalChunkHeaderSize + read;
        };
        ChunkedChannel.prototype.start = function () {
            this.epochStart = Date.now();
            this.ondata(new Uint8Array([PROTOCOL_VERSION])); // c0
            this.randomData = new Uint8Array(RANDOM_DATA_SIZE);
            this.randomData[0] = 0;
            this.randomData[1] = 0;
            this.randomData[2] = 0;
            this.randomData[3] = 0;
            for (var i = 8; i < RANDOM_DATA_SIZE; i++) {
                this.randomData[i] = (Math.random() * 256) | 0;
            }
            this.ondata(this.randomData); // c1
            console.log('## connected');
        };
        ChunkedChannel.prototype.stop = function (error) {
            if (error) {
                console.error('socket error!!!');
            }
            console.log('## closed');
        };
        ChunkedChannel.prototype._fail = function (message) {
            console.error('failed: ' + message);
            this.state = 'failed';
            this.onclose();
            throw new Error(message);
        };
        return ChunkedChannel;
    })();
    RtmpJs.ChunkedChannel = ChunkedChannel;
})(RtmpJs || (RtmpJs = {}));
/*
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var flash = Shumway.AVMX.AS.flash;
    var TRANSPORT_ENCODING = 0;
    var MAIN_CHUNKED_STREAM_ID = 3;
    var CONNECT_TRANSACTION_ID = 1;
    var DEFAULT_STREAM_ID = 0;
    var COMMAND_MESSAGE_AMF0_ID = 20;
    var COMMAND_MESSAGE_AMF3_ID = 17;
    var SET_BUFFER_CONTROL_MESSAGE_ID = 3;
    var PING_REQUEST_CONTROL_MESSAGE_ID = 6;
    var PING_RESPONSE_CONTROL_MESSAGE_ID = 7;
    var BaseTransport = (function () {
        function BaseTransport() {
            this._streams = [];
        }
        BaseTransport.prototype.connect = function (properties, args) {
            throw new Error('Abstract BaseTransport.connect method');
        };
        BaseTransport.prototype._initChannel = function (properties, args) {
            var channel = new RtmpJs.ChunkedChannel();
            var transport = this;
            channel.oncreated = function () {
                var ba = new flash.utils.ByteArray();
                ba.objectEncoding = TRANSPORT_ENCODING;
                ba.writeObject('connect');
                ba.writeObject(CONNECT_TRANSACTION_ID);
                ba.writeObject(properties);
                ba.writeObject(args || null);
                release || console.log('.. Connect sent');
                channel.send(MAIN_CHUNKED_STREAM_ID, {
                    streamId: DEFAULT_STREAM_ID,
                    typeId: TRANSPORT_ENCODING ? COMMAND_MESSAGE_AMF3_ID : COMMAND_MESSAGE_AMF0_ID,
                    data: new Uint8Array(ba._buffer, 0, ba.length)
                });
            };
            channel.onmessage = function (message) {
                release || console.log('.. Data received: typeId:' + message.typeId +
                    ', streamId:' + message.streamId +
                    ', cs: ' + message.chunkedStreamId);
                if (message.streamId !== 0) {
                    transport._streams[message.streamId]._push(message);
                    return;
                }
                if (message.typeId === COMMAND_MESSAGE_AMF0_ID ||
                    message.typeId === COMMAND_MESSAGE_AMF3_ID) {
                    var ba = new flash.utils.ByteArray();
                    ba.writeRawBytes(message.data);
                    ba.position = 0;
                    ba.objectEncoding = message.typeId === COMMAND_MESSAGE_AMF0_ID ? 0 : 3;
                    var commandName = ba.readObject();
                    if (commandName === undefined) {
                        ba.objectEncoding = 0;
                        commandName = ba.readObject();
                    }
                    var transactionId = ba.readObject();
                    if (commandName === '_result' || commandName === '_error') {
                        var isError = commandName === '_error';
                        if (transactionId === CONNECT_TRANSACTION_ID) {
                            var properties = ba.readObject();
                            var information = ba.readObject();
                            if (transport.onconnected) {
                                transport.onconnected({ properties: properties, information: information, isError: isError });
                            }
                        }
                        else {
                            var commandObject = ba.readObject();
                            var streamId = ba.readObject();
                            if (transport.onstreamcreated) {
                                var stream = new NetStream(transport, streamId);
                                transport._streams[streamId] = stream;
                                transport.onstreamcreated({ transactionId: transactionId, commandObject: commandObject, streamId: streamId, stream: stream, isError: isError });
                            }
                        }
                    }
                    else if (commandName === 'onBWCheck' || commandName === 'onBWDone') {
                        // TODO skipping those for now
                        transport.sendCommandOrResponse('_error', transactionId, null, { code: 'NetConnection.Call.Failed', level: 'error' });
                    }
                    else {
                        var commandObject = ba.readObject();
                        var response = ba.position < ba.length ? ba.readObject() : undefined;
                        if (transport.onresponse) {
                            transport.onresponse({ commandName: commandName, transactionId: transactionId, commandObject: commandObject, response: response });
                        }
                    }
                    return;
                }
                // TODO misc messages
            };
            channel.onusercontrolmessage = function (e) {
                release || console.log('.. Event ' + e.type + ' +' + e.data.length + ' bytes');
                if (e.type === PING_REQUEST_CONTROL_MESSAGE_ID) {
                    channel.sendUserControlMessage(PING_RESPONSE_CONTROL_MESSAGE_ID, e.data);
                }
                if (transport.onevent) {
                    transport.onevent({ type: e.type, data: e.data });
                }
            };
            return (this.channel = channel);
        };
        BaseTransport.prototype.call = function (procedureName, transactionId, commandObject, args) {
            var channel = this.channel;
            var ba = new flash.utils.ByteArray();
            ba.objectEncoding = TRANSPORT_ENCODING;
            ba.writeObject(procedureName);
            ba.writeObject(transactionId);
            ba.writeObject(commandObject);
            ba.writeObject(args);
            channel.send(MAIN_CHUNKED_STREAM_ID, {
                streamId: DEFAULT_STREAM_ID,
                typeId: TRANSPORT_ENCODING ? COMMAND_MESSAGE_AMF3_ID : COMMAND_MESSAGE_AMF0_ID,
                data: new Uint8Array(ba._buffer, 0, ba.length)
            });
        };
        BaseTransport.prototype.createStream = function (transactionId, commandObject) {
            this.sendCommandOrResponse('createStream', transactionId, commandObject);
        };
        BaseTransport.prototype.sendCommandOrResponse = function (commandName, transactionId, commandObject, response) {
            var channel = this.channel;
            var ba = new flash.utils.ByteArray();
            ba.writeByte(0); // ???
            ba.objectEncoding = 0; // TRANSPORT_ENCODING;
            ba.writeObject(commandName);
            ba.writeObject(transactionId);
            ba.writeObject(commandObject || null);
            if (arguments.length > 3) {
                ba.writeObject(response);
            }
            channel.send(MAIN_CHUNKED_STREAM_ID, {
                streamId: DEFAULT_STREAM_ID,
                typeId: COMMAND_MESSAGE_AMF3_ID,
                data: new Uint8Array(ba._buffer, 0, ba.length)
            });
            /*     // really weird that this does not work
             var ba = new flash.utils.ByteArray();
             ba.objectEncoding = TRANSPORT_ENCODING;
             ba.writeObject('createStream');
             ba.writeObject(transactionId);
             ba.writeObject(commandObject || null);
             channel.send(MAIN_CHUNKED_STREAM_ID, {
             streamId: DEFAULT_STREAM_ID,
             typeId: TRANSPORT_ENCODING ? COMMAND_MESSAGE_AMF3_ID : COMMAND_MESSAGE_AMF0_ID,
             data: new Uint8Array((<any> ba)._buffer, 0, (<any> ba).length)
             });
             */
        };
        BaseTransport.prototype._setBuffer = function (streamId, ms) {
            this.channel.sendUserControlMessage(SET_BUFFER_CONTROL_MESSAGE_ID, new Uint8Array([
                (streamId >> 24) & 0xFF,
                (streamId >> 16) & 0xFF,
                (streamId >> 8) & 0xFF,
                streamId & 0xFF,
                (ms >> 24) & 0xFF,
                (ms >> 16) & 0xFF,
                (ms >> 8) & 0xFF,
                ms & 0xFF
            ]));
        };
        BaseTransport.prototype._sendCommand = function (streamId, data) {
            this.channel.send(8, {
                streamId: streamId,
                typeId: TRANSPORT_ENCODING ? COMMAND_MESSAGE_AMF3_ID : COMMAND_MESSAGE_AMF0_ID,
                data: data
            });
        };
        return BaseTransport;
    })();
    RtmpJs.BaseTransport = BaseTransport;
    var DEFAULT_BUFFER_LENGTH = 100; // ms
    var NetStream = (function () {
        function NetStream(transport, streamId) {
            this.transport = transport;
            this.streamId = streamId;
        }
        NetStream.prototype.play = function (name, start, duration, reset) {
            var ba = new flash.utils.ByteArray();
            ba.objectEncoding = TRANSPORT_ENCODING;
            ba.writeObject('play');
            ba.writeObject(0);
            ba.writeObject(null);
            ba.writeObject(name);
            if (arguments.length > 1) {
                ba.writeObject(start);
            }
            if (arguments.length > 2) {
                ba.writeObject(duration);
            }
            if (arguments.length > 3) {
                ba.writeObject(reset);
            }
            this.transport._sendCommand(this.streamId, new Uint8Array(ba._buffer, 0, ba.length));
            // set the buffer, otherwise it will stop in ~15 sec
            this.transport._setBuffer(this.streamId, DEFAULT_BUFFER_LENGTH);
        };
        NetStream.prototype._push = function (message) {
            switch (message.typeId) {
                case 8:
                case 9:
                    if (this.ondata) {
                        this.ondata(message);
                    }
                    break;
                case 18:
                case 20:
                    var args = [];
                    var ba = new flash.utils.ByteArray();
                    ba.writeRawBytes(message.data);
                    ba.position = 0;
                    ba.objectEncoding = 0;
                    while (ba.position < ba.length) {
                        args.push(ba.readObject());
                    }
                    if (message.typeId === 18 && this.onscriptdata) {
                        this.onscriptdata.apply(this, args);
                    }
                    if (message.typeId === 20 && this.oncallback) {
                        this.oncallback.apply(this, args);
                    }
                    break;
            }
        };
        return NetStream;
    })();
    function parseConnectionString(s) {
        // The s has to have the following format:
        //   protocol:[//host][:port]/appname[/instanceName]
        var protocolSeparatorIndex = s.indexOf(':');
        if (protocolSeparatorIndex < 0) {
            return null; // no protocol
        }
        if (s[protocolSeparatorIndex + 1] !== '/') {
            return null; // shall have '/' after protocol
        }
        var protocol = s.substring(0, protocolSeparatorIndex).toLocaleLowerCase();
        if (protocol !== 'rtmp' && protocol !== 'rtmpt' && protocol !== 'rtmps' &&
            protocol !== 'rtmpe' && protocol !== 'rtmpte' && protocol !== 'rtmfp') {
            return null;
        }
        var host, port;
        var appnameSeparator = protocolSeparatorIndex + 1;
        if (s[protocolSeparatorIndex + 2] === '/') {
            // has host
            appnameSeparator = s.indexOf('/', protocolSeparatorIndex + 3);
            if (appnameSeparator < 0) {
                return undefined; // has host but no appname
            }
            var portSeparator = s.indexOf(':', protocolSeparatorIndex + 1);
            if (portSeparator >= 0 && portSeparator < appnameSeparator) {
                host = s.substring(protocolSeparatorIndex + 3, portSeparator);
                port = +s.substring(portSeparator + 1, appnameSeparator);
            }
            else {
                host = s.substring(protocolSeparatorIndex + 3, appnameSeparator);
            }
        }
        var app = s.substring(appnameSeparator + 1);
        return {
            protocol: protocol,
            host: host,
            port: port,
            app: app
        };
    }
    RtmpJs.parseConnectionString = parseConnectionString;
})(RtmpJs || (RtmpJs = {}));
/*
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var Browser;
    (function (Browser) {
        var DEFAULT_RTMP_PORT = 1935;
        var COMBINE_RTMPT_DATA = true;
        var RtmpTransport = (function (_super) {
            __extends(RtmpTransport, _super);
            function RtmpTransport(connectionSettings) {
                _super.call(this);
                if (typeof connectionSettings === 'string') {
                    connectionSettings = { host: connectionSettings };
                }
                this.host = connectionSettings.host || 'localhost';
                this.port = connectionSettings.port || DEFAULT_RTMP_PORT;
                this.ssl = !!connectionSettings.ssl || false;
            }
            RtmpTransport.prototype.connect = function (properties, args) {
                var TCPSocket = typeof navigator !== 'undefined' &&
                    navigator.mozTCPSocket;
                if (!TCPSocket) {
                    throw new Error('Your browser does not support socket communication.\n' +
                        'Currenly only Firefox with enabled mozTCPSocket is allowed (see README.md).');
                }
                var channel = this._initChannel(properties, args);
                var writeQueue = [], socketError = false;
                var socket = typeof Browser.ShumwayComRtmpSocket !== 'undefined' && Browser.ShumwayComRtmpSocket.isAvailable ?
                    new Browser.ShumwayComRtmpSocket(this.host, this.port, { useSecureTransport: this.ssl, binaryType: 'arraybuffer' }) :
                    TCPSocket.open(this.host, this.port, { useSecureTransport: this.ssl, binaryType: 'arraybuffer' });
                var sendData = function (data) {
                    return socket.send(data.buffer, data.byteOffset, data.byteLength);
                };
                socket.onopen = function (e) {
                    channel.ondata = function (data) {
                        var buf = new Uint8Array(data);
                        writeQueue.push(buf);
                        if (writeQueue.length > 1) {
                            return;
                        }
                        release || console.log('Bytes written: ' + buf.length);
                        if (sendData(buf)) {
                            writeQueue.shift();
                        }
                    };
                    channel.onclose = function () {
                        socket.close();
                    };
                    channel.start();
                };
                socket.ondrain = function (e) {
                    writeQueue.shift();
                    release || console.log('Write completed');
                    while (writeQueue.length > 0) {
                        release || console.log('Bytes written: ' + writeQueue[0].length);
                        if (!sendData(writeQueue[0])) {
                            break;
                        }
                        writeQueue.shift();
                    }
                };
                socket.onclose = function (e) {
                    channel.stop(socketError);
                };
                socket.onerror = function (e) {
                    socketError = true;
                    console.error('socket error: ' + e.data);
                };
                socket.ondata = function (e) {
                    release || console.log('Bytes read: ' + e.data.byteLength);
                    channel.push(new Uint8Array(e.data));
                };
            };
            return RtmpTransport;
        })(RtmpJs.BaseTransport);
        Browser.RtmpTransport = RtmpTransport;
        /*
         * RtmptTransport uses systemXHR to send HTTP requests.
         * See https://developer.mozilla.org/en-US/docs/DOM/XMLHttpRequest#XMLHttpRequest%28%29 and
         * https://github.com/mozilla-b2g/gaia/blob/master/apps/email/README.md#running-in-firefox
         *
         * Spec at http://red5.electroteque.org/dev/doc/html/rtmpt.html
         */
        var RtmptTransport = (function (_super) {
            __extends(RtmptTransport, _super);
            function RtmptTransport(connectionSettings) {
                _super.call(this);
                var host = connectionSettings.host || 'localhost';
                var url = (connectionSettings.ssl ? 'https' : 'http') + '://' + host;
                if (connectionSettings.port) {
                    url += ':' + connectionSettings.port;
                }
                this.baseUrl = url;
                this.stopped = false;
                this.sessionId = null;
                this.requestId = 0;
                this.data = [];
            }
            RtmptTransport.prototype.connect = function (properties, args) {
                var channel = this._initChannel(properties, args);
                channel.ondata = function (data) {
                    release || console.log('Bytes written: ' + data.length);
                    this.data.push(new Uint8Array(data));
                }.bind(this);
                channel.onclose = function () {
                    this.stopped = true;
                }.bind(this);
                post(this.baseUrl + '/fcs/ident2', null, function (data, status) {
                    if (status !== 404) {
                        throw new Error('Unexpected response: ' + status);
                    }
                    post(this.baseUrl + '/open/1', null, function (data, status) {
                        this.sessionId = String.fromCharCode.apply(null, data).slice(0, -1); // - '\n'
                        console.log('session id: ' + this.sessionId);
                        this.tick();
                        channel.start();
                    }.bind(this));
                }.bind(this));
            };
            RtmptTransport.prototype.tick = function () {
                var continueSend = function (data, status) {
                    if (status !== 200) {
                        throw new Error('Invalid HTTP status');
                    }
                    var idle = data[0];
                    if (data.length > 1) {
                        this.channel.push(data.subarray(1));
                    }
                    setTimeout(this.tick.bind(this), idle * 16);
                }.bind(this);
                if (this.stopped) {
                    post(this.baseUrl + '/close/2', null, function () {
                        // do nothing
                    });
                    return;
                }
                if (this.data.length > 0) {
                    var data;
                    if (COMBINE_RTMPT_DATA) {
                        var length = 0;
                        this.data.forEach(function (i) {
                            length += i.length;
                        });
                        var pos = 0;
                        data = new Uint8Array(length);
                        this.data.forEach(function (i) {
                            data.set(i, pos);
                            pos += i.length;
                        });
                        this.data.length = 0;
                    }
                    else {
                        data = this.data.shift();
                    }
                    post(this.baseUrl + '/send/' + this.sessionId + '/' + (this.requestId++), data, continueSend);
                }
                else {
                    post(this.baseUrl + '/idle/' + this.sessionId + '/' + (this.requestId++), null, continueSend);
                }
            };
            return RtmptTransport;
        })(RtmpJs.BaseTransport);
        Browser.RtmptTransport = RtmptTransport;
        var emptyPostData = new Uint8Array([0]);
        function post(path, data, onload) {
            data || (data = emptyPostData);
            var xhr = typeof Browser.ShumwayComRtmpXHR !== 'undefined' && Browser.ShumwayComRtmpXHR.isAvailable ?
                new Browser.ShumwayComRtmpXHR() : new XMLHttpRequest({ mozSystem: true });
            xhr.open('POST', path, true);
            xhr.responseType = 'arraybuffer';
            xhr.setRequestHeader('Content-Type', 'application/x-fcs');
            xhr.onload = function (e) {
                onload(new Uint8Array(xhr.response), xhr.status);
            };
            xhr.onerror = function (e) {
                console.log('error');
                throw new Error('HTTP error');
            };
            xhr.send(data);
        }
    })(Browser = RtmpJs.Browser || (RtmpJs.Browser = {}));
})(RtmpJs || (RtmpJs = {}));
/**
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var MP4;
    (function (MP4) {
        var Iso;
        (function (Iso) {
            var utf8decode = Shumway.StringUtilities.utf8decode;
            var START_DATE = -2082844800000; /* midnight after Jan. 1, 1904 */
            var DEFAULT_MOVIE_MATRIX = [1.0, 0, 0, 0, 1.0, 0, 0, 0, 1.0];
            var DEFAULT_OP_COLOR = [0, 0, 0];
            function concatArrays(arg0) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                return Array.prototype.concat.apply(arg0, args);
            }
            function writeInt32(data, offset, value) {
                data[offset] = (value >> 24) & 255;
                data[offset + 1] = (value >> 16) & 255;
                data[offset + 2] = (value >> 8) & 255;
                data[offset + 3] = value & 255;
            }
            function decodeInt32(s) {
                return (s.charCodeAt(0) << 24) | (s.charCodeAt(1) << 16) |
                    (s.charCodeAt(2) << 8) | s.charCodeAt(3);
            }
            function encodeDate(d) {
                return ((d - START_DATE) / 1000) | 0;
            }
            function encodeFloat_16_16(f) {
                return (f * 0x10000) | 0;
            }
            function encodeFloat_2_30(f) {
                return (f * 0x40000000) | 0;
            }
            function encodeFloat_8_8(f) {
                return (f * 0x100) | 0;
            }
            function encodeLang(s) {
                return ((s.charCodeAt(0) & 0x1F) << 10) | ((s.charCodeAt(1) & 0x1F) << 5) | (s.charCodeAt(2) & 0x1F);
            }
            var Box = (function () {
                function Box(boxtype, extendedType) {
                    this.boxtype = boxtype;
                    if (boxtype === 'uuid') {
                        this.userType = extendedType;
                    }
                }
                /**
                 * @param offset Position where writing will start in the output array
                 * @returns {number} Size of the written data
                 */
                Box.prototype.layout = function (offset) {
                    this.offset = offset;
                    var size = 8;
                    if (this.userType) {
                        size += 16;
                    }
                    this.size = size;
                    return size;
                };
                /**
                 * @param data Output array
                 * @returns {number} Amount of written bytes by this Box and its children only.
                 */
                Box.prototype.write = function (data) {
                    writeInt32(data, this.offset, this.size);
                    writeInt32(data, this.offset + 4, decodeInt32(this.boxtype));
                    if (!this.userType) {
                        return 8;
                    }
                    data.set(this.userType, this.offset + 8);
                    return 24;
                };
                Box.prototype.toUint8Array = function () {
                    var size = this.layout(0);
                    var data = new Uint8Array(size);
                    this.write(data);
                    return data;
                };
                return Box;
            })();
            Iso.Box = Box;
            var FullBox = (function (_super) {
                __extends(FullBox, _super);
                function FullBox(boxtype, version, flags) {
                    if (version === void 0) { version = 0; }
                    if (flags === void 0) { flags = 0; }
                    _super.call(this, boxtype);
                    this.version = version;
                    this.flags = flags;
                }
                FullBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 4;
                    return this.size;
                };
                FullBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, (this.version << 24) | this.flags);
                    return offset + 4;
                };
                return FullBox;
            })(Box);
            Iso.FullBox = FullBox;
            var FileTypeBox = (function (_super) {
                __extends(FileTypeBox, _super);
                function FileTypeBox(majorBrand, minorVersion, compatibleBrands) {
                    _super.call(this, 'ftype');
                    this.majorBrand = majorBrand;
                    this.minorVersion = minorVersion;
                    this.compatibleBrands = compatibleBrands;
                }
                FileTypeBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 4 * (2 + this.compatibleBrands.length);
                    return this.size;
                };
                FileTypeBox.prototype.write = function (data) {
                    var _this = this;
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, decodeInt32(this.majorBrand));
                    writeInt32(data, this.offset + offset + 4, this.minorVersion);
                    offset += 8;
                    this.compatibleBrands.forEach(function (brand) {
                        writeInt32(data, _this.offset + offset, decodeInt32(brand));
                        offset += 4;
                    }, this);
                    return offset;
                };
                return FileTypeBox;
            })(Box);
            Iso.FileTypeBox = FileTypeBox;
            var BoxContainerBox = (function (_super) {
                __extends(BoxContainerBox, _super);
                function BoxContainerBox(type, children) {
                    _super.call(this, type);
                    this.children = children;
                }
                BoxContainerBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset);
                    this.children.forEach(function (child) {
                        if (!child) {
                            return; // skipping undefined
                        }
                        size += child.layout(offset + size);
                    });
                    return (this.size = size);
                };
                BoxContainerBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    this.children.forEach(function (child) {
                        if (!child) {
                            return; // skipping undefined
                        }
                        offset += child.write(data);
                    });
                    return offset;
                };
                return BoxContainerBox;
            })(Box);
            Iso.BoxContainerBox = BoxContainerBox;
            var MovieBox = (function (_super) {
                __extends(MovieBox, _super);
                function MovieBox(header, tracks, extendsBox, userData) {
                    _super.call(this, 'moov', concatArrays([header], tracks, [extendsBox, userData]));
                    this.header = header;
                    this.tracks = tracks;
                    this.extendsBox = extendsBox;
                    this.userData = userData;
                }
                return MovieBox;
            })(BoxContainerBox);
            Iso.MovieBox = MovieBox;
            var MovieHeaderBox = (function (_super) {
                __extends(MovieHeaderBox, _super);
                function MovieHeaderBox(timescale, duration, nextTrackId, rate, volume, matrix, creationTime, modificationTime) {
                    if (rate === void 0) { rate = 1.0; }
                    if (volume === void 0) { volume = 1.0; }
                    if (matrix === void 0) { matrix = DEFAULT_MOVIE_MATRIX; }
                    if (creationTime === void 0) { creationTime = START_DATE; }
                    if (modificationTime === void 0) { modificationTime = START_DATE; }
                    _super.call(this, 'mvhd', 0, 0);
                    this.timescale = timescale;
                    this.duration = duration;
                    this.nextTrackId = nextTrackId;
                    this.rate = rate;
                    this.volume = volume;
                    this.matrix = matrix;
                    this.creationTime = creationTime;
                    this.modificationTime = modificationTime;
                }
                MovieHeaderBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 16 + 4 + 2 + 2 + 8 + 36 + 24 + 4;
                    return this.size;
                };
                MovieHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    // Only version 0
                    writeInt32(data, this.offset + offset, encodeDate(this.creationTime));
                    writeInt32(data, this.offset + offset + 4, encodeDate(this.modificationTime));
                    writeInt32(data, this.offset + offset + 8, this.timescale);
                    writeInt32(data, this.offset + offset + 12, this.duration);
                    offset += 16;
                    writeInt32(data, this.offset + offset, encodeFloat_16_16(this.rate));
                    writeInt32(data, this.offset + offset + 4, encodeFloat_8_8(this.volume) << 16);
                    writeInt32(data, this.offset + offset + 8, 0);
                    writeInt32(data, this.offset + offset + 12, 0);
                    offset += 16;
                    writeInt32(data, this.offset + offset, encodeFloat_16_16(this.matrix[0]));
                    writeInt32(data, this.offset + offset + 4, encodeFloat_16_16(this.matrix[1]));
                    writeInt32(data, this.offset + offset + 8, encodeFloat_16_16(this.matrix[2]));
                    writeInt32(data, this.offset + offset + 12, encodeFloat_16_16(this.matrix[3]));
                    writeInt32(data, this.offset + offset + 16, encodeFloat_16_16(this.matrix[4]));
                    writeInt32(data, this.offset + offset + 20, encodeFloat_16_16(this.matrix[5]));
                    writeInt32(data, this.offset + offset + 24, encodeFloat_2_30(this.matrix[6]));
                    writeInt32(data, this.offset + offset + 28, encodeFloat_2_30(this.matrix[7]));
                    writeInt32(data, this.offset + offset + 32, encodeFloat_2_30(this.matrix[8]));
                    offset += 36;
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, 0);
                    writeInt32(data, this.offset + offset + 8, 0);
                    writeInt32(data, this.offset + offset + 12, 0);
                    writeInt32(data, this.offset + offset + 16, 0);
                    writeInt32(data, this.offset + offset + 20, 0);
                    offset += 24;
                    writeInt32(data, this.offset + offset, this.nextTrackId);
                    offset += 4;
                    return offset;
                };
                return MovieHeaderBox;
            })(FullBox);
            Iso.MovieHeaderBox = MovieHeaderBox;
            var TrackHeaderBox = (function (_super) {
                __extends(TrackHeaderBox, _super);
                function TrackHeaderBox(flags, trackId, duration, width, height, volume, alternateGroup, layer, matrix, creationTime, modificationTime) {
                    if (alternateGroup === void 0) { alternateGroup = 0; }
                    if (layer === void 0) { layer = 0; }
                    if (matrix === void 0) { matrix = DEFAULT_MOVIE_MATRIX; }
                    if (creationTime === void 0) { creationTime = START_DATE; }
                    if (modificationTime === void 0) { modificationTime = START_DATE; }
                    _super.call(this, 'tkhd', 0, flags);
                    this.trackId = trackId;
                    this.duration = duration;
                    this.width = width;
                    this.height = height;
                    this.volume = volume;
                    this.alternateGroup = alternateGroup;
                    this.layer = layer;
                    this.matrix = matrix;
                    this.creationTime = creationTime;
                    this.modificationTime = modificationTime;
                }
                TrackHeaderBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 20 + 8 + 6 + 2 + 36 + 8;
                    return this.size;
                };
                TrackHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    // Only version 0
                    writeInt32(data, this.offset + offset, encodeDate(this.creationTime));
                    writeInt32(data, this.offset + offset + 4, encodeDate(this.modificationTime));
                    writeInt32(data, this.offset + offset + 8, this.trackId);
                    writeInt32(data, this.offset + offset + 12, 0);
                    writeInt32(data, this.offset + offset + 16, this.duration);
                    offset += 20;
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, 0);
                    writeInt32(data, this.offset + offset + 8, (this.layer << 16) | this.alternateGroup);
                    writeInt32(data, this.offset + offset + 12, encodeFloat_8_8(this.volume) << 16);
                    offset += 16;
                    writeInt32(data, this.offset + offset, encodeFloat_16_16(this.matrix[0]));
                    writeInt32(data, this.offset + offset + 4, encodeFloat_16_16(this.matrix[1]));
                    writeInt32(data, this.offset + offset + 8, encodeFloat_16_16(this.matrix[2]));
                    writeInt32(data, this.offset + offset + 12, encodeFloat_16_16(this.matrix[3]));
                    writeInt32(data, this.offset + offset + 16, encodeFloat_16_16(this.matrix[4]));
                    writeInt32(data, this.offset + offset + 20, encodeFloat_16_16(this.matrix[5]));
                    writeInt32(data, this.offset + offset + 24, encodeFloat_2_30(this.matrix[6]));
                    writeInt32(data, this.offset + offset + 28, encodeFloat_2_30(this.matrix[7]));
                    writeInt32(data, this.offset + offset + 32, encodeFloat_2_30(this.matrix[8]));
                    offset += 36;
                    writeInt32(data, this.offset + offset, encodeFloat_16_16(this.width));
                    writeInt32(data, this.offset + offset + 4, encodeFloat_16_16(this.height));
                    offset += 8;
                    return offset;
                };
                return TrackHeaderBox;
            })(FullBox);
            Iso.TrackHeaderBox = TrackHeaderBox;
            var MediaHeaderBox = (function (_super) {
                __extends(MediaHeaderBox, _super);
                function MediaHeaderBox(timescale, duration, language, creationTime, modificationTime) {
                    if (language === void 0) { language = 'unk'; }
                    if (creationTime === void 0) { creationTime = START_DATE; }
                    if (modificationTime === void 0) { modificationTime = START_DATE; }
                    _super.call(this, 'mdhd', 0, 0);
                    this.timescale = timescale;
                    this.duration = duration;
                    this.language = language;
                    this.creationTime = creationTime;
                    this.modificationTime = modificationTime;
                }
                MediaHeaderBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 16 + 4;
                    return this.size;
                };
                MediaHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    // Only version 0
                    writeInt32(data, this.offset + offset, encodeDate(this.creationTime));
                    writeInt32(data, this.offset + offset + 4, encodeDate(this.modificationTime));
                    writeInt32(data, this.offset + offset + 8, this.timescale);
                    writeInt32(data, this.offset + offset + 12, this.duration);
                    writeInt32(data, this.offset + offset + 16, encodeLang(this.language) << 16);
                    return offset + 20;
                };
                return MediaHeaderBox;
            })(FullBox);
            Iso.MediaHeaderBox = MediaHeaderBox;
            var HandlerBox = (function (_super) {
                __extends(HandlerBox, _super);
                function HandlerBox(handlerType, name) {
                    _super.call(this, 'hdlr', 0, 0);
                    this.handlerType = handlerType;
                    this.name = name;
                    this._encodedName = utf8decode(this.name);
                }
                HandlerBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 8 + 12 + (this._encodedName.length + 1);
                    return this.size;
                };
                HandlerBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, decodeInt32(this.handlerType));
                    writeInt32(data, this.offset + offset + 8, 0);
                    writeInt32(data, this.offset + offset + 12, 0);
                    writeInt32(data, this.offset + offset + 16, 0);
                    offset += 20;
                    data.set(this._encodedName, this.offset + offset);
                    data[this.offset + offset + this._encodedName.length] = 0;
                    offset += this._encodedName.length + 1;
                    return offset;
                };
                return HandlerBox;
            })(FullBox);
            Iso.HandlerBox = HandlerBox;
            var SoundMediaHeaderBox = (function (_super) {
                __extends(SoundMediaHeaderBox, _super);
                function SoundMediaHeaderBox(balance) {
                    if (balance === void 0) { balance = 0.0; }
                    _super.call(this, 'smhd', 0, 0);
                    this.balance = balance;
                }
                SoundMediaHeaderBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 4;
                    return this.size;
                };
                SoundMediaHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, encodeFloat_8_8(this.balance) << 16);
                    return offset + 4;
                };
                return SoundMediaHeaderBox;
            })(FullBox);
            Iso.SoundMediaHeaderBox = SoundMediaHeaderBox;
            var VideoMediaHeaderBox = (function (_super) {
                __extends(VideoMediaHeaderBox, _super);
                function VideoMediaHeaderBox(graphicsMode, opColor) {
                    if (graphicsMode === void 0) { graphicsMode = 0; }
                    if (opColor === void 0) { opColor = DEFAULT_OP_COLOR; }
                    _super.call(this, 'vmhd', 0, 0);
                    this.graphicsMode = graphicsMode;
                    this.opColor = opColor;
                }
                VideoMediaHeaderBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 8;
                    return this.size;
                };
                VideoMediaHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, (this.graphicsMode << 16) | this.opColor[0]);
                    writeInt32(data, this.offset + offset + 4, (this.opColor[1] << 16) | this.opColor[2]);
                    return offset + 8;
                };
                return VideoMediaHeaderBox;
            })(FullBox);
            Iso.VideoMediaHeaderBox = VideoMediaHeaderBox;
            Iso.SELF_CONTAINED_DATA_REFERENCE_FLAG = 0x000001;
            var DataEntryUrlBox = (function (_super) {
                __extends(DataEntryUrlBox, _super);
                function DataEntryUrlBox(flags, location) {
                    if (location === void 0) { location = null; }
                    _super.call(this, 'url ', 0, flags);
                    this.location = location;
                    if (!(flags & Iso.SELF_CONTAINED_DATA_REFERENCE_FLAG)) {
                        this._encodedLocation = utf8decode(location);
                    }
                }
                DataEntryUrlBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset);
                    if (this._encodedLocation) {
                        size += this._encodedLocation.length + 1;
                    }
                    return (this.size = size);
                };
                DataEntryUrlBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    if (this._encodedLocation) {
                        data.set(this._encodedLocation, this.offset + offset);
                        data[this.offset + offset + this._encodedLocation.length] = 0;
                        offset += this._encodedLocation.length;
                    }
                    return offset;
                };
                return DataEntryUrlBox;
            })(FullBox);
            Iso.DataEntryUrlBox = DataEntryUrlBox;
            var DataReferenceBox = (function (_super) {
                __extends(DataReferenceBox, _super);
                function DataReferenceBox(entries) {
                    _super.call(this, 'dref', 0, 0);
                    this.entries = entries;
                }
                DataReferenceBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset) + 4;
                    this.entries.forEach(function (entry) {
                        size += entry.layout(offset + size);
                    });
                    return (this.size = size);
                };
                DataReferenceBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, this.entries.length);
                    this.entries.forEach(function (entry) {
                        offset += entry.write(data);
                    });
                    return offset;
                };
                return DataReferenceBox;
            })(FullBox);
            Iso.DataReferenceBox = DataReferenceBox;
            var DataInformationBox = (function (_super) {
                __extends(DataInformationBox, _super);
                function DataInformationBox(dataReference) {
                    _super.call(this, 'dinf', [dataReference]);
                    this.dataReference = dataReference;
                }
                return DataInformationBox;
            })(BoxContainerBox);
            Iso.DataInformationBox = DataInformationBox;
            var SampleDescriptionBox = (function (_super) {
                __extends(SampleDescriptionBox, _super);
                function SampleDescriptionBox(entries) {
                    _super.call(this, 'stsd', 0, 0);
                    this.entries = entries;
                }
                SampleDescriptionBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset);
                    size += 4;
                    this.entries.forEach(function (entry) {
                        size += entry.layout(offset + size);
                    });
                    return (this.size = size);
                };
                SampleDescriptionBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, this.entries.length);
                    offset += 4;
                    this.entries.forEach(function (entry) {
                        offset += entry.write(data);
                    });
                    return offset;
                };
                return SampleDescriptionBox;
            })(FullBox);
            Iso.SampleDescriptionBox = SampleDescriptionBox;
            var SampleTableBox = (function (_super) {
                __extends(SampleTableBox, _super);
                function SampleTableBox(sampleDescriptions, timeToSample, sampleToChunk, sampleSizes, // optional?
                    chunkOffset) {
                    _super.call(this, 'stbl', [sampleDescriptions, timeToSample, sampleToChunk, sampleSizes, chunkOffset]);
                    this.sampleDescriptions = sampleDescriptions;
                    this.timeToSample = timeToSample;
                    this.sampleToChunk = sampleToChunk;
                    this.sampleSizes = sampleSizes;
                    this.chunkOffset = chunkOffset;
                }
                return SampleTableBox;
            })(BoxContainerBox);
            Iso.SampleTableBox = SampleTableBox;
            var MediaInformationBox = (function (_super) {
                __extends(MediaInformationBox, _super);
                function MediaInformationBox(header, // SoundMediaHeaderBox|VideoMediaHeaderBox
                    info, sampleTable) {
                    _super.call(this, 'minf', [header, info, sampleTable]);
                    this.header = header;
                    this.info = info;
                    this.sampleTable = sampleTable;
                }
                return MediaInformationBox;
            })(BoxContainerBox);
            Iso.MediaInformationBox = MediaInformationBox;
            var MediaBox = (function (_super) {
                __extends(MediaBox, _super);
                function MediaBox(header, handler, info) {
                    _super.call(this, 'mdia', [header, handler, info]);
                    this.header = header;
                    this.handler = handler;
                    this.info = info;
                }
                return MediaBox;
            })(BoxContainerBox);
            Iso.MediaBox = MediaBox;
            var TrackBox = (function (_super) {
                __extends(TrackBox, _super);
                function TrackBox(header, media) {
                    _super.call(this, 'trak', [header, media]);
                    this.header = header;
                    this.media = media;
                }
                return TrackBox;
            })(BoxContainerBox);
            Iso.TrackBox = TrackBox;
            var TrackExtendsBox = (function (_super) {
                __extends(TrackExtendsBox, _super);
                function TrackExtendsBox(trackId, defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags) {
                    _super.call(this, 'trex', 0, 0);
                    this.trackId = trackId;
                    this.defaultSampleDescriptionIndex = defaultSampleDescriptionIndex;
                    this.defaultSampleDuration = defaultSampleDuration;
                    this.defaultSampleSize = defaultSampleSize;
                    this.defaultSampleFlags = defaultSampleFlags;
                }
                TrackExtendsBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 20;
                    return this.size;
                };
                TrackExtendsBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, this.trackId);
                    writeInt32(data, this.offset + offset + 4, this.defaultSampleDescriptionIndex);
                    writeInt32(data, this.offset + offset + 8, this.defaultSampleDuration);
                    writeInt32(data, this.offset + offset + 12, this.defaultSampleSize);
                    writeInt32(data, this.offset + offset + 16, this.defaultSampleFlags);
                    return offset + 20;
                };
                return TrackExtendsBox;
            })(FullBox);
            Iso.TrackExtendsBox = TrackExtendsBox;
            var MovieExtendsBox = (function (_super) {
                __extends(MovieExtendsBox, _super);
                function MovieExtendsBox(header, tracDefaults, levels) {
                    _super.call(this, 'mvex', concatArrays([header], tracDefaults, [levels]));
                    this.header = header;
                    this.tracDefaults = tracDefaults;
                    this.levels = levels;
                }
                return MovieExtendsBox;
            })(BoxContainerBox);
            Iso.MovieExtendsBox = MovieExtendsBox;
            var MetaBox = (function (_super) {
                __extends(MetaBox, _super);
                function MetaBox(handler, otherBoxes) {
                    _super.call(this, 'meta', 0, 0);
                    this.handler = handler;
                    this.otherBoxes = otherBoxes;
                }
                MetaBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset);
                    size += this.handler.layout(offset + size);
                    this.otherBoxes.forEach(function (box) {
                        size += box.layout(offset + size);
                    });
                    return (this.size = size);
                };
                MetaBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    offset += this.handler.write(data);
                    this.otherBoxes.forEach(function (box) {
                        offset += box.write(data);
                    });
                    return offset;
                };
                return MetaBox;
            })(FullBox);
            Iso.MetaBox = MetaBox;
            var MovieFragmentHeaderBox = (function (_super) {
                __extends(MovieFragmentHeaderBox, _super);
                function MovieFragmentHeaderBox(sequenceNumber) {
                    _super.call(this, 'mfhd', 0, 0);
                    this.sequenceNumber = sequenceNumber;
                }
                MovieFragmentHeaderBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 4;
                    return this.size;
                };
                MovieFragmentHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, this.sequenceNumber);
                    return offset + 4;
                };
                return MovieFragmentHeaderBox;
            })(FullBox);
            Iso.MovieFragmentHeaderBox = MovieFragmentHeaderBox;
            var TrackFragmentHeaderBox = (function (_super) {
                __extends(TrackFragmentHeaderBox, _super);
                function TrackFragmentHeaderBox(flags, trackId, baseDataOffset, sampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags) {
                    _super.call(this, 'tfhd', 0, flags);
                    this.trackId = trackId;
                    this.baseDataOffset = baseDataOffset;
                    this.sampleDescriptionIndex = sampleDescriptionIndex;
                    this.defaultSampleDuration = defaultSampleDuration;
                    this.defaultSampleSize = defaultSampleSize;
                    this.defaultSampleFlags = defaultSampleFlags;
                }
                TrackFragmentHeaderBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset) + 4;
                    var flags = this.flags;
                    if (!!(flags & 1 /* BASE_DATA_OFFSET_PRESENT */)) {
                        size += 8;
                    }
                    if (!!(flags & 2 /* SAMPLE_DESCRIPTION_INDEX_PRESENT */)) {
                        size += 4;
                    }
                    if (!!(flags & 8 /* DEFAULT_SAMPLE_DURATION_PRESENT */)) {
                        size += 4;
                    }
                    if (!!(flags & 16 /* DEFAULT_SAMPLE_SIZE_PRESENT */)) {
                        size += 4;
                    }
                    if (!!(flags & 32 /* DEFAULT_SAMPLE_FLAGS_PRESENT */)) {
                        size += 4;
                    }
                    return (this.size = size);
                };
                TrackFragmentHeaderBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    var flags = this.flags;
                    writeInt32(data, this.offset + offset, this.trackId);
                    offset += 4;
                    if (!!(flags & 1 /* BASE_DATA_OFFSET_PRESENT */)) {
                        writeInt32(data, this.offset + offset, 0);
                        writeInt32(data, this.offset + offset + 4, this.baseDataOffset);
                        offset += 8;
                    }
                    if (!!(flags & 2 /* SAMPLE_DESCRIPTION_INDEX_PRESENT */)) {
                        writeInt32(data, this.offset + offset, this.sampleDescriptionIndex);
                        offset += 4;
                    }
                    if (!!(flags & 8 /* DEFAULT_SAMPLE_DURATION_PRESENT */)) {
                        writeInt32(data, this.offset + offset, this.defaultSampleDuration);
                        offset += 4;
                    }
                    if (!!(flags & 16 /* DEFAULT_SAMPLE_SIZE_PRESENT */)) {
                        writeInt32(data, this.offset + offset, this.defaultSampleSize);
                        offset += 4;
                    }
                    if (!!(flags & 32 /* DEFAULT_SAMPLE_FLAGS_PRESENT */)) {
                        writeInt32(data, this.offset + offset, this.defaultSampleFlags);
                        offset += 4;
                    }
                    return offset;
                };
                return TrackFragmentHeaderBox;
            })(FullBox);
            Iso.TrackFragmentHeaderBox = TrackFragmentHeaderBox;
            var TrackFragmentBaseMediaDecodeTimeBox = (function (_super) {
                __extends(TrackFragmentBaseMediaDecodeTimeBox, _super);
                function TrackFragmentBaseMediaDecodeTimeBox(baseMediaDecodeTime) {
                    _super.call(this, 'tfdt', 0, 0);
                    this.baseMediaDecodeTime = baseMediaDecodeTime;
                }
                TrackFragmentBaseMediaDecodeTimeBox.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 4;
                    return this.size;
                };
                TrackFragmentBaseMediaDecodeTimeBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, this.baseMediaDecodeTime);
                    return offset + 4;
                };
                return TrackFragmentBaseMediaDecodeTimeBox;
            })(FullBox);
            Iso.TrackFragmentBaseMediaDecodeTimeBox = TrackFragmentBaseMediaDecodeTimeBox;
            var TrackFragmentBox = (function (_super) {
                __extends(TrackFragmentBox, _super);
                function TrackFragmentBox(header, decodeTime, // move after run?
                    run) {
                    _super.call(this, 'traf', [header, decodeTime, run]);
                    this.header = header;
                    this.decodeTime = decodeTime;
                    this.run = run;
                }
                return TrackFragmentBox;
            })(BoxContainerBox);
            Iso.TrackFragmentBox = TrackFragmentBox;
            var TrackRunBox = (function (_super) {
                __extends(TrackRunBox, _super);
                function TrackRunBox(flags, samples, dataOffset, firstSampleFlags) {
                    _super.call(this, 'trun', 1, flags);
                    this.samples = samples;
                    this.dataOffset = dataOffset;
                    this.firstSampleFlags = firstSampleFlags;
                }
                TrackRunBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset) + 4;
                    var samplesCount = this.samples.length;
                    var flags = this.flags;
                    if (!!(flags & 1 /* DATA_OFFSET_PRESENT */)) {
                        size += 4;
                    }
                    if (!!(flags & 4 /* FIRST_SAMPLE_FLAGS_PRESENT */)) {
                        size += 4;
                    }
                    if (!!(flags & 256 /* SAMPLE_DURATION_PRESENT */)) {
                        size += 4 * samplesCount;
                    }
                    if (!!(flags & 512 /* SAMPLE_SIZE_PRESENT */)) {
                        size += 4 * samplesCount;
                    }
                    if (!!(flags & 1024 /* SAMPLE_FLAGS_PRESENT */)) {
                        size += 4 * samplesCount;
                    }
                    if (!!(flags & 2048 /* SAMPLE_COMPOSITION_TIME_OFFSET */)) {
                        size += 4 * samplesCount;
                    }
                    return (this.size = size);
                };
                TrackRunBox.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    var samplesCount = this.samples.length;
                    var flags = this.flags;
                    writeInt32(data, this.offset + offset, samplesCount);
                    offset += 4;
                    if (!!(flags & 1 /* DATA_OFFSET_PRESENT */)) {
                        writeInt32(data, this.offset + offset, this.dataOffset);
                        offset += 4;
                    }
                    if (!!(flags & 4 /* FIRST_SAMPLE_FLAGS_PRESENT */)) {
                        writeInt32(data, this.offset + offset, this.firstSampleFlags);
                        offset += 4;
                    }
                    for (var i = 0; i < samplesCount; i++) {
                        var sample = this.samples[i];
                        if (!!(flags & 256 /* SAMPLE_DURATION_PRESENT */)) {
                            writeInt32(data, this.offset + offset, sample.duration);
                            offset += 4;
                        }
                        if (!!(flags & 512 /* SAMPLE_SIZE_PRESENT */)) {
                            writeInt32(data, this.offset + offset, sample.size);
                            offset += 4;
                        }
                        if (!!(flags & 1024 /* SAMPLE_FLAGS_PRESENT */)) {
                            writeInt32(data, this.offset + offset, sample.flags);
                            offset += 4;
                        }
                        if (!!(flags & 2048 /* SAMPLE_COMPOSITION_TIME_OFFSET */)) {
                            writeInt32(data, this.offset + offset, sample.compositionTimeOffset);
                            offset += 4;
                        }
                    }
                    return offset;
                };
                return TrackRunBox;
            })(FullBox);
            Iso.TrackRunBox = TrackRunBox;
            var MovieFragmentBox = (function (_super) {
                __extends(MovieFragmentBox, _super);
                function MovieFragmentBox(header, trafs) {
                    _super.call(this, 'moof', concatArrays([header], trafs));
                    this.header = header;
                    this.trafs = trafs;
                }
                return MovieFragmentBox;
            })(BoxContainerBox);
            Iso.MovieFragmentBox = MovieFragmentBox;
            var MediaDataBox = (function (_super) {
                __extends(MediaDataBox, _super);
                function MediaDataBox(chunks) {
                    _super.call(this, 'mdat');
                    this.chunks = chunks;
                }
                MediaDataBox.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset);
                    this.chunks.forEach(function (chunk) { size += chunk.length; });
                    return (this.size = size);
                };
                MediaDataBox.prototype.write = function (data) {
                    var _this = this;
                    var offset = _super.prototype.write.call(this, data);
                    this.chunks.forEach(function (chunk) {
                        data.set(chunk, _this.offset + offset);
                        offset += chunk.length;
                    }, this);
                    return offset;
                };
                return MediaDataBox;
            })(Box);
            Iso.MediaDataBox = MediaDataBox;
            var SampleEntry = (function (_super) {
                __extends(SampleEntry, _super);
                function SampleEntry(format, dataReferenceIndex) {
                    _super.call(this, format);
                    this.dataReferenceIndex = dataReferenceIndex;
                }
                SampleEntry.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + 8;
                    return this.size;
                };
                SampleEntry.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, this.dataReferenceIndex);
                    return offset + 8;
                };
                return SampleEntry;
            })(Box);
            Iso.SampleEntry = SampleEntry;
            var AudioSampleEntry = (function (_super) {
                __extends(AudioSampleEntry, _super);
                function AudioSampleEntry(codingName, dataReferenceIndex, channelCount, sampleSize, sampleRate, otherBoxes) {
                    if (channelCount === void 0) { channelCount = 2; }
                    if (sampleSize === void 0) { sampleSize = 16; }
                    if (sampleRate === void 0) { sampleRate = 44100; }
                    if (otherBoxes === void 0) { otherBoxes = null; }
                    _super.call(this, codingName, dataReferenceIndex);
                    this.channelCount = channelCount;
                    this.sampleSize = sampleSize;
                    this.sampleRate = sampleRate;
                    this.otherBoxes = otherBoxes;
                }
                AudioSampleEntry.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset) + 20;
                    this.otherBoxes && this.otherBoxes.forEach(function (box) {
                        size += box.layout(offset + size);
                    });
                    return (this.size = size);
                };
                AudioSampleEntry.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, 0);
                    writeInt32(data, this.offset + offset + 8, (this.channelCount << 16) | this.sampleSize);
                    writeInt32(data, this.offset + offset + 12, 0);
                    writeInt32(data, this.offset + offset + 16, (this.sampleRate << 16));
                    offset += 20;
                    this.otherBoxes && this.otherBoxes.forEach(function (box) {
                        offset += box.write(data);
                    });
                    return offset;
                };
                return AudioSampleEntry;
            })(SampleEntry);
            Iso.AudioSampleEntry = AudioSampleEntry;
            Iso.COLOR_NO_ALPHA_VIDEO_SAMPLE_DEPTH = 0x0018;
            var VideoSampleEntry = (function (_super) {
                __extends(VideoSampleEntry, _super);
                function VideoSampleEntry(codingName, dataReferenceIndex, width, height, compressorName, horizResolution, vertResolution, frameCount, depth, otherBoxes) {
                    if (compressorName === void 0) { compressorName = ''; }
                    if (horizResolution === void 0) { horizResolution = 72; }
                    if (vertResolution === void 0) { vertResolution = 72; }
                    if (frameCount === void 0) { frameCount = 1; }
                    if (depth === void 0) { depth = Iso.COLOR_NO_ALPHA_VIDEO_SAMPLE_DEPTH; }
                    if (otherBoxes === void 0) { otherBoxes = null; }
                    _super.call(this, codingName, dataReferenceIndex);
                    this.width = width;
                    this.height = height;
                    this.compressorName = compressorName;
                    this.horizResolution = horizResolution;
                    this.vertResolution = vertResolution;
                    this.frameCount = frameCount;
                    this.depth = depth;
                    this.otherBoxes = otherBoxes;
                    if (compressorName.length > 31) {
                        throw new Error('invalid compressor name');
                    }
                }
                VideoSampleEntry.prototype.layout = function (offset) {
                    var size = _super.prototype.layout.call(this, offset) + 16 + 12 + 4 + 2 + 32 + 2 + 2;
                    this.otherBoxes && this.otherBoxes.forEach(function (box) {
                        size += box.layout(offset + size);
                    });
                    return (this.size = size);
                };
                VideoSampleEntry.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, 0);
                    writeInt32(data, this.offset + offset + 8, 0);
                    writeInt32(data, this.offset + offset + 12, 0);
                    offset += 16;
                    writeInt32(data, this.offset + offset, (this.width << 16) | this.height);
                    writeInt32(data, this.offset + offset + 4, encodeFloat_16_16(this.horizResolution));
                    writeInt32(data, this.offset + offset + 8, encodeFloat_16_16(this.vertResolution));
                    offset += 12;
                    writeInt32(data, this.offset + offset, 0);
                    writeInt32(data, this.offset + offset + 4, (this.frameCount << 16));
                    offset += 6; // weird offset
                    data[this.offset + offset] = this.compressorName.length;
                    for (var i = 0; i < 31; i++) {
                        data[this.offset + offset + i + 1] = i < this.compressorName.length ? (this.compressorName.charCodeAt(i) & 127) : 0;
                    }
                    offset += 32;
                    writeInt32(data, this.offset + offset, (this.depth << 16) | 0xFFFF);
                    offset += 4;
                    this.otherBoxes && this.otherBoxes.forEach(function (box) {
                        offset += box.write(data);
                    });
                    return offset;
                };
                return VideoSampleEntry;
            })(SampleEntry);
            Iso.VideoSampleEntry = VideoSampleEntry;
            var RawTag = (function (_super) {
                __extends(RawTag, _super);
                function RawTag(type, data) {
                    _super.call(this, type);
                    this.data = data;
                }
                RawTag.prototype.layout = function (offset) {
                    this.size = _super.prototype.layout.call(this, offset) + this.data.length;
                    return this.size;
                };
                RawTag.prototype.write = function (data) {
                    var offset = _super.prototype.write.call(this, data);
                    data.set(this.data, this.offset + offset);
                    return offset + this.data.length;
                };
                return RawTag;
            })(Box);
            Iso.RawTag = RawTag;
        })(Iso = MP4.Iso || (MP4.Iso = {}));
    })(MP4 = RtmpJs.MP4 || (RtmpJs.MP4 = {}));
})(RtmpJs || (RtmpJs = {}));
/**
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var MP4;
    (function (MP4) {
        function hex(s) {
            var len = s.length >> 1;
            var arr = new Uint8Array(len);
            for (var i = 0; i < len; i++) {
                arr[i] = parseInt(s.substr(i * 2, 2), 16);
            }
            return arr;
        }
        var SOUNDRATES = [5500, 11025, 22050, 44100];
        var SOUNDFORMATS = ['PCM', 'ADPCM', 'MP3', 'PCM le', 'Nellymouser16', 'Nellymouser8', 'Nellymouser', 'G.711 A-law', 'G.711 mu-law', null, 'AAC', 'Speex', 'MP3 8khz'];
        var MP3_SOUND_CODEC_ID = 2;
        var AAC_SOUND_CODEC_ID = 10;
        var AudioPacketType;
        (function (AudioPacketType) {
            AudioPacketType[AudioPacketType["HEADER"] = 0] = "HEADER";
            AudioPacketType[AudioPacketType["RAW"] = 1] = "RAW";
        })(AudioPacketType || (AudioPacketType = {}));
        function parseAudiodata(data) {
            var i = 0;
            var packetType = AudioPacketType.RAW;
            var flags = data[i];
            var codecId = flags >> 4;
            var soundRateId = (flags >> 2) & 3;
            var sampleSize = flags & 2 ? 16 : 8;
            var channels = flags & 1 ? 2 : 1;
            var samples;
            i++;
            switch (codecId) {
                case AAC_SOUND_CODEC_ID:
                    var type = data[i++];
                    packetType = type;
                    samples = 1024; // AAC implementations typically represent 1024 PCM audio samples
                    break;
                case MP3_SOUND_CODEC_ID:
                    var version = (data[i + 1] >> 3) & 3; // 3 - MPEG 1
                    var layer = (data[i + 1] >> 1) & 3; // 3 - Layer I, 2 - II, 1 - III
                    samples = layer === 1 ? (version === 3 ? 1152 : 576) :
                        (layer === 3 ? 384 : 1152);
                    break;
            }
            return {
                codecDescription: SOUNDFORMATS[codecId],
                codecId: codecId,
                data: data.subarray(i),
                rate: SOUNDRATES[soundRateId],
                size: sampleSize,
                channels: channels,
                samples: samples,
                packetType: packetType
            };
        }
        var VIDEOCODECS = [null, 'JPEG', 'Sorenson', 'Screen', 'VP6', 'VP6 alpha', 'Screen2', 'AVC'];
        var VP6_VIDEO_CODEC_ID = 4;
        var AVC_VIDEO_CODEC_ID = 7;
        var VideoFrameType;
        (function (VideoFrameType) {
            VideoFrameType[VideoFrameType["KEY"] = 1] = "KEY";
            VideoFrameType[VideoFrameType["INNER"] = 2] = "INNER";
            VideoFrameType[VideoFrameType["DISPOSABLE"] = 3] = "DISPOSABLE";
            VideoFrameType[VideoFrameType["GENERATED"] = 4] = "GENERATED";
            VideoFrameType[VideoFrameType["INFO"] = 5] = "INFO";
        })(VideoFrameType || (VideoFrameType = {}));
        var VideoPacketType;
        (function (VideoPacketType) {
            VideoPacketType[VideoPacketType["HEADER"] = 0] = "HEADER";
            VideoPacketType[VideoPacketType["NALU"] = 1] = "NALU";
            VideoPacketType[VideoPacketType["END"] = 2] = "END";
        })(VideoPacketType || (VideoPacketType = {}));
        function parseVideodata(data) {
            var i = 0;
            var frameType = data[i] >> 4;
            var codecId = data[i] & 15;
            i++;
            var result = {
                frameType: frameType,
                codecId: codecId,
                codecDescription: VIDEOCODECS[codecId]
            };
            switch (codecId) {
                case AVC_VIDEO_CODEC_ID:
                    var type = data[i++];
                    result.packetType = type;
                    result.compositionTime = ((data[i] << 24) | (data[i + 1] << 16) | (data[i + 2] << 8)) >> 8;
                    i += 3;
                    break;
                case VP6_VIDEO_CODEC_ID:
                    result.packetType = VideoPacketType.NALU;
                    result.horizontalOffset = (data[i] >> 4) & 15;
                    result.verticalOffset = data[i] & 15;
                    result.compositionTime = 0;
                    i++;
                    break;
            }
            result.data = data.subarray(i);
            return result;
        }
        var AUDIO_PACKET = 8;
        var VIDEO_PACKET = 9;
        var MAX_PACKETS_IN_CHUNK = 200;
        var SPLIT_AT_KEYFRAMES = false;
        var MP4MuxState;
        (function (MP4MuxState) {
            MP4MuxState[MP4MuxState["CAN_GENERATE_HEADER"] = 0] = "CAN_GENERATE_HEADER";
            MP4MuxState[MP4MuxState["NEED_HEADER_DATA"] = 1] = "NEED_HEADER_DATA";
            MP4MuxState[MP4MuxState["MAIN_PACKETS"] = 2] = "MAIN_PACKETS";
        })(MP4MuxState || (MP4MuxState = {}));
        var MP4Mux = (function () {
            function MP4Mux(metadata) {
                var _this = this;
                this.oncodecinfo = function (codecs) {
                    //
                };
                this.ondata = function (data) {
                    throw new Error('MP4Mux.ondata is not set');
                };
                this.metadata = metadata;
                this.trackStates = this.metadata.tracks.map(function (t, index) {
                    var state = {
                        trackId: index + 1,
                        trackInfo: t,
                        cachedDuration: 0,
                        samplesProcessed: 0,
                        initializationData: []
                    };
                    if (_this.metadata.audioTrackId === index) {
                        _this.audioTrackState = state;
                    }
                    if (_this.metadata.videoTrackId === index) {
                        _this.videoTrackState = state;
                    }
                    return state;
                }, this);
                this._checkIfNeedHeaderData();
                this.filePos = 0;
                this.cachedPackets = [];
                this.chunkIndex = 0;
            }
            MP4Mux.prototype.pushPacket = function (type, data, timestamp) {
                if (this.state === MP4MuxState.CAN_GENERATE_HEADER) {
                    this._tryGenerateHeader();
                }
                switch (type) {
                    case AUDIO_PACKET:
                        var audioTrack = this.audioTrackState;
                        var audioPacket = parseAudiodata(data);
                        if (!audioTrack || audioTrack.trackInfo.codecId !== audioPacket.codecId) {
                            throw new Error('Unexpected audio packet codec: ' + audioPacket.codecDescription);
                        }
                        switch (audioPacket.codecId) {
                            default:
                                throw new Error('Unsupported audio codec: ' + audioPacket.codecDescription);
                            case MP3_SOUND_CODEC_ID:
                                break; // supported codec
                            case AAC_SOUND_CODEC_ID:
                                if (audioPacket.packetType === AudioPacketType.HEADER) {
                                    audioTrack.initializationData.push(audioPacket.data);
                                    return;
                                }
                                break;
                        }
                        this.cachedPackets.push({ packet: audioPacket, timestamp: timestamp, trackId: audioTrack.trackId });
                        break;
                    case VIDEO_PACKET:
                        var videoTrack = this.videoTrackState;
                        var videoPacket = parseVideodata(data);
                        if (!videoTrack || videoTrack.trackInfo.codecId !== videoPacket.codecId) {
                            throw new Error('Unexpected video packet codec: ' + videoPacket.codecDescription);
                        }
                        switch (videoPacket.codecId) {
                            default:
                                throw new Error('unsupported video codec: ' + videoPacket.codecDescription);
                            case VP6_VIDEO_CODEC_ID:
                                break; // supported
                            case AVC_VIDEO_CODEC_ID:
                                if (videoPacket.packetType === VideoPacketType.HEADER) {
                                    videoTrack.initializationData.push(videoPacket.data);
                                    return;
                                }
                                break;
                        }
                        this.cachedPackets.push({ packet: videoPacket, timestamp: timestamp, trackId: videoTrack.trackId });
                        break;
                    default:
                        throw new Error('unknown packet type: ' + type);
                }
                if (this.state === MP4MuxState.NEED_HEADER_DATA) {
                    this._tryGenerateHeader();
                }
                if (this.cachedPackets.length >= MAX_PACKETS_IN_CHUNK &&
                    this.state === MP4MuxState.MAIN_PACKETS) {
                    this._chunk();
                }
            };
            MP4Mux.prototype.flush = function () {
                if (this.cachedPackets.length > 0) {
                    this._chunk();
                }
            };
            MP4Mux.prototype._checkIfNeedHeaderData = function () {
                if (this.trackStates.some(function (ts) {
                    return ts.trackInfo.codecId === AAC_SOUND_CODEC_ID || ts.trackInfo.codecId === AVC_VIDEO_CODEC_ID;
                })) {
                    this.state = MP4MuxState.NEED_HEADER_DATA;
                }
                else {
                    this.state = MP4MuxState.CAN_GENERATE_HEADER;
                }
            };
            MP4Mux.prototype._tryGenerateHeader = function () {
                var allInitializationDataExists = this.trackStates.every(function (ts) {
                    switch (ts.trackInfo.codecId) {
                        case AAC_SOUND_CODEC_ID:
                        case AVC_VIDEO_CODEC_ID:
                            return ts.initializationData.length > 0;
                        default:
                            return true;
                    }
                });
                if (!allInitializationDataExists) {
                    return; // not enough data, waiting more
                }
                var brands = ['isom'];
                var audioDataReferenceIndex = 1, videoDataReferenceIndex = 1;
                var traks = [];
                for (var i = 0; i < this.trackStates.length; i++) {
                    var trackState = this.trackStates[i];
                    var trackInfo = trackState.trackInfo;
                    var sampleEntry;
                    switch (trackInfo.codecId) {
                        case AAC_SOUND_CODEC_ID:
                            var audioSpecificConfig = trackState.initializationData[0];
                            sampleEntry = new MP4.Iso.AudioSampleEntry('mp4a', audioDataReferenceIndex, trackInfo.channels, trackInfo.samplesize, trackInfo.samplerate);
                            var esdsData = new Uint8Array(41 + audioSpecificConfig.length);
                            esdsData.set(hex('0000000003808080'), 0);
                            esdsData[8] = 32 + audioSpecificConfig.length;
                            esdsData.set(hex('00020004808080'), 9);
                            esdsData[16] = 18 + audioSpecificConfig.length;
                            esdsData.set(hex('40150000000000FA000000000005808080'), 17);
                            esdsData[34] = audioSpecificConfig.length;
                            esdsData.set(audioSpecificConfig, 35);
                            esdsData.set(hex('068080800102'), 35 + audioSpecificConfig.length);
                            sampleEntry.otherBoxes = [
                                new MP4.Iso.RawTag('esds', esdsData)
                            ];
                            var objectType = (audioSpecificConfig[0] >> 3); // TODO 31
                            // mp4a.40.objectType
                            trackState.mimeTypeCodec = 'mp4a.40.' + objectType;
                            break;
                        case MP3_SOUND_CODEC_ID:
                            sampleEntry = new MP4.Iso.AudioSampleEntry('.mp3', audioDataReferenceIndex, trackInfo.channels, trackInfo.samplesize, trackInfo.samplerate);
                            trackState.mimeTypeCodec = 'mp3';
                            break;
                        case AVC_VIDEO_CODEC_ID:
                            var avcC = trackState.initializationData[0];
                            sampleEntry = new MP4.Iso.VideoSampleEntry('avc1', videoDataReferenceIndex, trackInfo.width, trackInfo.height);
                            sampleEntry.otherBoxes = [
                                new MP4.Iso.RawTag('avcC', avcC)
                            ];
                            var codecProfile = (avcC[1] << 16) | (avcC[2] << 8) | avcC[3];
                            // avc1.XXYYZZ -- XX - profile + YY - constraints + ZZ - level
                            trackState.mimeTypeCodec = 'avc1.' + (0x1000000 | codecProfile).toString(16).substr(1);
                            brands.push('iso2', 'avc1', 'mp41');
                            break;
                        case VP6_VIDEO_CODEC_ID:
                            sampleEntry = new MP4.Iso.VideoSampleEntry('VP6F', videoDataReferenceIndex, trackInfo.width, trackInfo.height);
                            sampleEntry.otherBoxes = [
                                new MP4.Iso.RawTag('glbl', hex('00'))
                            ];
                            // TODO to lie about codec to get it playing in MSE?
                            trackState.mimeTypeCodec = 'avc1.42001E';
                            break;
                        default:
                            throw new Error('not supported track type');
                    }
                    var trak;
                    var trakFlags = 1 /* TRACK_ENABLED */ | 2 /* TRACK_IN_MOVIE */;
                    if (trackState === this.audioTrackState) {
                        trak = new MP4.Iso.TrackBox(new MP4.Iso.TrackHeaderBox(trakFlags, trackState.trackId, -1, 0 /*width*/, 0 /*height*/, 1.0, i), new MP4.Iso.MediaBox(new MP4.Iso.MediaHeaderBox(trackInfo.timescale, -1, trackInfo.language), new MP4.Iso.HandlerBox('soun', 'SoundHandler'), new MP4.Iso.MediaInformationBox(new MP4.Iso.SoundMediaHeaderBox(), new MP4.Iso.DataInformationBox(new MP4.Iso.DataReferenceBox([new MP4.Iso.DataEntryUrlBox(MP4.Iso.SELF_CONTAINED_DATA_REFERENCE_FLAG)])), new MP4.Iso.SampleTableBox(new MP4.Iso.SampleDescriptionBox([sampleEntry]), new MP4.Iso.RawTag('stts', hex('0000000000000000')), new MP4.Iso.RawTag('stsc', hex('0000000000000000')), new MP4.Iso.RawTag('stsz', hex('000000000000000000000000')), new MP4.Iso.RawTag('stco', hex('0000000000000000'))))));
                    }
                    else if (trackState === this.videoTrackState) {
                        trak = new MP4.Iso.TrackBox(new MP4.Iso.TrackHeaderBox(trakFlags, trackState.trackId, -1, trackInfo.width, trackInfo.height, 0 /* volume */, i), new MP4.Iso.MediaBox(new MP4.Iso.MediaHeaderBox(trackInfo.timescale, -1, trackInfo.language), new MP4.Iso.HandlerBox('vide', 'VideoHandler'), new MP4.Iso.MediaInformationBox(new MP4.Iso.VideoMediaHeaderBox(), new MP4.Iso.DataInformationBox(new MP4.Iso.DataReferenceBox([new MP4.Iso.DataEntryUrlBox(MP4.Iso.SELF_CONTAINED_DATA_REFERENCE_FLAG)])), new MP4.Iso.SampleTableBox(new MP4.Iso.SampleDescriptionBox([sampleEntry]), new MP4.Iso.RawTag('stts', hex('0000000000000000')), new MP4.Iso.RawTag('stsc', hex('0000000000000000')), new MP4.Iso.RawTag('stsz', hex('000000000000000000000000')), new MP4.Iso.RawTag('stco', hex('0000000000000000'))))));
                    }
                    traks.push(trak);
                }
                var mvex = new MP4.Iso.MovieExtendsBox(null, [
                    new MP4.Iso.TrackExtendsBox(1, 1, 0, 0, 0),
                    new MP4.Iso.TrackExtendsBox(2, 1, 0, 0, 0)
                ], null);
                var udat = new MP4.Iso.BoxContainerBox('udat', [
                    new MP4.Iso.MetaBox(new MP4.Iso.RawTag('hdlr', hex('00000000000000006D6469726170706C000000000000000000')), [new MP4.Iso.RawTag('ilst', hex('00000025A9746F6F0000001D6461746100000001000000004C61766635342E36332E313034'))])
                ]);
                var mvhd = new MP4.Iso.MovieHeaderBox(1000, 0 /* unknown duration */, this.trackStates.length + 1);
                var moov = new MP4.Iso.MovieBox(mvhd, traks, mvex, udat);
                var ftype = new MP4.Iso.FileTypeBox('isom', 0x00000200, brands);
                var ftypeSize = ftype.layout(0);
                var moovSize = moov.layout(ftypeSize);
                var header = new Uint8Array(ftypeSize + moovSize);
                ftype.write(header);
                moov.write(header);
                this.oncodecinfo(this.trackStates.map(function (ts) { return ts.mimeTypeCodec; }));
                this.ondata(header);
                this.filePos += header.length;
                this.state = MP4MuxState.MAIN_PACKETS;
            };
            MP4Mux.prototype._chunk = function () {
                var cachedPackets = this.cachedPackets;
                if (SPLIT_AT_KEYFRAMES) {
                    var j = cachedPackets.length - 1;
                    var videoTrackId = this.videoTrackState.trackId;
                    // Finding last video keyframe.
                    while (j > 0 &&
                        (cachedPackets[j].trackId !== videoTrackId || cachedPackets[j].packet.frameType !== VideoFrameType.KEY)) {
                        j--;
                    }
                    if (j > 0) {
                        // We have keyframes and not only the first frame is a keyframe...
                        cachedPackets = cachedPackets.slice(0, j);
                    }
                }
                if (cachedPackets.length === 0) {
                    return; // No data to produce.
                }
                var tdatParts = [];
                var tdatPosition = 0;
                var trafs = [];
                var trafDataStarts = [];
                for (var i = 0; i < this.trackStates.length; i++) {
                    var trackState = this.trackStates[i];
                    var trackInfo = trackState.trackInfo;
                    var trackId = trackState.trackId;
                    // Finding all packets for this track.
                    var trackPackets = cachedPackets.filter(function (cp) { return cp.trackId === trackId; });
                    if (trackPackets.length === 0) {
                        continue;
                    }
                    //var currentTimestamp = (trackPackets[0].timestamp * trackInfo.timescale / 1000) | 0;
                    var tfdt = new MP4.Iso.TrackFragmentBaseMediaDecodeTimeBox(trackState.cachedDuration);
                    var tfhd;
                    var trun;
                    var trunSamples;
                    trafDataStarts.push(tdatPosition);
                    switch (trackInfo.codecId) {
                        case AAC_SOUND_CODEC_ID:
                        case MP3_SOUND_CODEC_ID:
                            trunSamples = [];
                            for (var j = 0; j < trackPackets.length; j++) {
                                var audioPacket = trackPackets[j].packet;
                                var audioFrameDuration = Math.round(audioPacket.samples * trackInfo.timescale / trackInfo.samplerate);
                                tdatParts.push(audioPacket.data);
                                tdatPosition += audioPacket.data.length;
                                trunSamples.push({ duration: audioFrameDuration, size: audioPacket.data.length });
                                trackState.samplesProcessed += audioPacket.samples;
                            }
                            var tfhdFlags = 32 /* DEFAULT_SAMPLE_FLAGS_PRESENT */;
                            tfhd = new MP4.Iso.TrackFragmentHeaderBox(tfhdFlags, trackId, 0 /* offset */, 0 /* index */, 0 /* duration */, 0 /* size */, 33554432 /* SAMPLE_DEPENDS_ON_NO_OTHERS */);
                            var trunFlags = 1 /* DATA_OFFSET_PRESENT */ |
                                256 /* SAMPLE_DURATION_PRESENT */ | 512 /* SAMPLE_SIZE_PRESENT */;
                            trun = new MP4.Iso.TrackRunBox(trunFlags, trunSamples, 0 /* data offset */, 0 /* first flags */);
                            trackState.cachedDuration = Math.round(trackState.samplesProcessed * trackInfo.timescale / trackInfo.samplerate);
                            break;
                        case AVC_VIDEO_CODEC_ID:
                        case VP6_VIDEO_CODEC_ID:
                            trunSamples = [];
                            var samplesProcessed = trackState.samplesProcessed;
                            var decodeTime = samplesProcessed * trackInfo.timescale / trackInfo.framerate;
                            var lastTime = Math.round(decodeTime);
                            for (var j = 0; j < trackPackets.length; j++) {
                                var videoPacket = trackPackets[j].packet;
                                samplesProcessed++;
                                var nextTime = Math.round(samplesProcessed * trackInfo.timescale / trackInfo.framerate);
                                var videoFrameDuration = nextTime - lastTime;
                                lastTime = nextTime;
                                var compositionTime = Math.round(samplesProcessed * trackInfo.timescale / trackInfo.framerate +
                                    videoPacket.compositionTime * trackInfo.timescale / 1000);
                                tdatParts.push(videoPacket.data);
                                tdatPosition += videoPacket.data.length;
                                var frameFlags = videoPacket.frameType === VideoFrameType.KEY ?
                                    33554432 /* SAMPLE_DEPENDS_ON_NO_OTHERS */ :
                                    (16777216 /* SAMPLE_DEPENDS_ON_OTHER */ | 65536 /* SAMPLE_IS_NOT_SYNC */);
                                trunSamples.push({ duration: videoFrameDuration, size: videoPacket.data.length,
                                    flags: frameFlags, compositionTimeOffset: (compositionTime - nextTime) });
                            }
                            var tfhdFlags = 32 /* DEFAULT_SAMPLE_FLAGS_PRESENT */;
                            tfhd = new MP4.Iso.TrackFragmentHeaderBox(tfhdFlags, trackId, 0 /* offset */, 0 /* index */, 0 /* duration */, 0 /* size */, 33554432 /* SAMPLE_DEPENDS_ON_NO_OTHERS */);
                            var trunFlags = 1 /* DATA_OFFSET_PRESENT */ |
                                256 /* SAMPLE_DURATION_PRESENT */ | 512 /* SAMPLE_SIZE_PRESENT */ |
                                1024 /* SAMPLE_FLAGS_PRESENT */ | 2048 /* SAMPLE_COMPOSITION_TIME_OFFSET */;
                            trun = new MP4.Iso.TrackRunBox(trunFlags, trunSamples, 0 /* data offset */, 0 /* first flag */);
                            trackState.cachedDuration = lastTime;
                            trackState.samplesProcessed = samplesProcessed;
                            break;
                        default:
                            throw new Error('Un codec');
                    }
                    var traf = new MP4.Iso.TrackFragmentBox(tfhd, tfdt, trun);
                    trafs.push(traf);
                }
                this.cachedPackets.splice(0, cachedPackets.length);
                var moofHeader = new MP4.Iso.MovieFragmentHeaderBox(++this.chunkIndex);
                var moof = new MP4.Iso.MovieFragmentBox(moofHeader, trafs);
                var moofSize = moof.layout(0);
                var mdat = new MP4.Iso.MediaDataBox(tdatParts);
                var mdatSize = mdat.layout(moofSize);
                var tdatOffset = moofSize + 8;
                for (var i = 0; i < trafs.length; i++) {
                    trafs[i].run.dataOffset = tdatOffset + trafDataStarts[i];
                }
                var chunk = new Uint8Array(moofSize + mdatSize);
                moof.write(chunk);
                mdat.write(chunk);
                this.ondata(chunk);
                this.filePos += chunk.length;
            };
            return MP4Mux;
        })();
        MP4.MP4Mux = MP4Mux;
        function parseFLVMetadata(metadata) {
            var tracks = [];
            var audioTrackId = -1;
            var videoTrackId = -1;
            var duration = +metadata.axGetPublicProperty('duration');
            var audioCodec, audioCodecId;
            var audioCodecCode = metadata.axGetPublicProperty('audiocodecid');
            switch (audioCodecCode) {
                case MP3_SOUND_CODEC_ID:
                case 'mp3':
                    audioCodec = 'mp3';
                    audioCodecId = MP3_SOUND_CODEC_ID;
                    break;
                case AAC_SOUND_CODEC_ID:
                case 'mp4a':
                    audioCodec = 'mp4a';
                    audioCodecId = AAC_SOUND_CODEC_ID;
                    break;
                default:
                    if (!isNaN(audioCodecCode)) {
                        throw new Error('Unsupported audio codec: ' + audioCodecCode);
                    }
                    audioCodec = null;
                    audioCodecId = -1;
                    break;
            }
            var videoCodec, videoCodecId;
            var videoCodecCode = metadata.axGetPublicProperty('videocodecid');
            switch (videoCodecCode) {
                case VP6_VIDEO_CODEC_ID:
                case 'vp6f':
                    videoCodec = 'vp6f';
                    videoCodecId = VP6_VIDEO_CODEC_ID;
                    break;
                case AVC_VIDEO_CODEC_ID:
                case 'avc1':
                    videoCodec = 'avc1';
                    videoCodecId = AVC_VIDEO_CODEC_ID;
                    break;
                default:
                    if (!isNaN(videoCodecCode)) {
                        throw new Error('Unsupported video codec: ' + videoCodecCode);
                    }
                    videoCodec = null;
                    videoCodecId = -1;
                    break;
            }
            var audioTrack = (audioCodec === null) ? null : {
                codecDescription: audioCodec,
                codecId: audioCodecId,
                language: 'und',
                timescale: +metadata.axGetPublicProperty('audiosamplerate') || 44100,
                samplerate: +metadata.axGetPublicProperty('audiosamplerate') || 44100,
                channels: +metadata.axGetPublicProperty('audiochannels') || 2,
                samplesize: 16
            };
            var videoTrack = (videoCodec === null) ? null : {
                codecDescription: videoCodec,
                codecId: videoCodecId,
                language: 'und',
                timescale: 60000,
                framerate: +metadata.axGetPublicProperty('videoframerate') ||
                    +metadata.axGetPublicProperty('framerate'),
                width: +metadata.axGetPublicProperty('width'),
                height: +metadata.axGetPublicProperty('height')
            };
            var trackInfos = metadata.axGetPublicProperty('trackinfo');
            if (trackInfos) {
                // Not in the Adobe's references, red5 specific?
                for (var i = 0; i < trackInfos.length; i++) {
                    var info = trackInfos[i];
                    var sampleDescription = info.axGetPublicProperty('sampledescription')[0];
                    if (sampleDescription.axGetPublicProperty('sampletype') === audioCodecCode) {
                        audioTrack.language = info.axGetPublicProperty('language');
                        audioTrack.timescale = +info.axGetPublicProperty('timescale');
                    }
                    else if (sampleDescription.axGetPublicProperty('sampletype') === videoCodecCode) {
                        videoTrack.language = info.axGetPublicProperty('language');
                        videoTrack.timescale = +info.axGetPublicProperty('timescale');
                    }
                }
            }
            if (videoTrack) {
                videoTrackId = tracks.length;
                tracks.push(videoTrack);
            }
            if (audioTrack) {
                audioTrackId = tracks.length;
                tracks.push(audioTrack);
            }
            return {
                tracks: tracks,
                duration: duration,
                audioTrackId: audioTrackId,
                videoTrackId: videoTrackId
            };
        }
        MP4.parseFLVMetadata = parseFLVMetadata;
    })(MP4 = RtmpJs.MP4 || (RtmpJs.MP4 = {}));
})(RtmpJs || (RtmpJs = {}));
/**
 * Copyright 2015 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var RtmpJs;
(function (RtmpJs) {
    var FLV;
    (function (FLV) {
        var FLVParser = (function () {
            function FLVParser() {
                this.state = 0;
                this.state = 0;
                this.buffer = new ArrayBuffer(1024);
                this.bufferSize = 0;
                this.previousTagSize = 0;
                this.onError = null;
                this.onHeader = null;
                this.onTag = null;
                this.onClose = null;
            }
            FLVParser.prototype.push = function (data) {
                var parseBuffer;
                if (this.bufferSize > 0) {
                    var needLength = this.bufferSize + data.length;
                    if (this.buffer.byteLength < needLength) {
                        var tmp = new Uint8Array(this.buffer, 0, this.bufferSize);
                        this.buffer = new ArrayBuffer(needLength);
                        parseBuffer = new Uint8Array(this.buffer);
                        parseBuffer.set(tmp);
                    }
                    else {
                        parseBuffer = new Uint8Array(this.buffer, 0, needLength);
                    }
                    parseBuffer.set(data, this.bufferSize);
                }
                else {
                    parseBuffer = data;
                }
                var parsed = 0, end = parseBuffer.length;
                while (parsed < end) {
                    var chunkParsed = 0;
                    switch (this.state) {
                        case 0:
                            if (parsed + 9 > end) {
                                break;
                            }
                            var headerLength = (parseBuffer[parsed + 5] << 24) | (parseBuffer[parsed + 6] << 16) |
                                (parseBuffer[parsed + 7] << 8) | parseBuffer[parsed + 8];
                            if (headerLength < 9) {
                                this._error('Invalid header length');
                                break;
                            }
                            if (parsed + headerLength > end) {
                                break;
                            }
                            if (parseBuffer[parsed] !== 0x46 /* F */ ||
                                parseBuffer[parsed + 1] !== 0x4C /* L */ ||
                                parseBuffer[parsed + 2] !== 0x56 /* V */ ||
                                parseBuffer[parsed + 3] !== 1 /* version 1 */ ||
                                (parseBuffer[parsed + 4] & 0xFA) !== 0) {
                                this._error('Invalid FLV header');
                                break;
                            }
                            var flags = parseBuffer[parsed + 4];
                            var extra = headerLength > 9 ? parseBuffer.subarray(parsed + 9, parsed + headerLength) : null;
                            this.onHeader && this.onHeader({
                                hasAudio: !!(flags & 4),
                                hasVideo: !!(flags & 1),
                                extra: extra
                            });
                            this.state = 2;
                            chunkParsed = headerLength;
                            break;
                        case 2:
                            if (parsed + 4 + 11 > end) {
                                break;
                            }
                            var previousTagSize = (parseBuffer[parsed + 0] << 24) | (parseBuffer[parsed + 1] << 16) |
                                (parseBuffer[parsed + 2] << 8) | parseBuffer[parsed + 3];
                            if (previousTagSize !== this.previousTagSize) {
                                this._error('Invalid PreviousTagSize');
                                break;
                            }
                            var dataSize = (parseBuffer[parsed + 5] << 16) |
                                (parseBuffer[parsed + 6] << 8) | parseBuffer[parsed + 7];
                            var dataOffset = parsed + 4 + 11;
                            if (dataOffset + dataSize > end) {
                                break;
                            }
                            var flags = parseBuffer[parsed + 4];
                            var streamID = (parseBuffer[parsed + 12] << 16) |
                                (parseBuffer[parsed + 13] << 8) | parseBuffer[parsed + 14];
                            if (streamID !== 0 || (flags & 0xC0) !== 0) {
                                this._error('Invalid FLV tag');
                                break;
                            }
                            var dataType = flags & 0x1F;
                            if (dataType !== 8 && dataType !== 9 && dataType !== 18) {
                                this._error('Invalid FLV tag type');
                                break;
                            }
                            var needPreprocessing = !!(flags & 0x20);
                            var timestamp = (parseBuffer[parsed + 8] << 16) |
                                (parseBuffer[parsed + 9] << 8) | parseBuffer[parsed + 10] |
                                (parseBuffer[parseBuffer + 11] << 24);
                            this.onTag && this.onTag({
                                type: dataType,
                                needPreprocessing: needPreprocessing,
                                timestamp: timestamp,
                                data: parseBuffer.subarray(dataOffset, dataOffset + dataSize)
                            });
                            chunkParsed += 4 + 11 + dataSize;
                            this.previousTagSize = dataSize + 11;
                            this.state = 2;
                            break;
                        default:
                            throw new Error('invalid state');
                    }
                    if (chunkParsed === 0) {
                        break; // not enough data
                    }
                    parsed += chunkParsed;
                }
                if (parsed < parseBuffer.length) {
                    this.bufferSize = parseBuffer.length - parsed;
                    if (this.buffer.byteLength < this.bufferSize) {
                        this.buffer = new ArrayBuffer(this.bufferSize);
                    }
                    new Uint8Array(this.buffer).set(parseBuffer.subarray(parsed));
                }
                else {
                    this.bufferSize = 0;
                }
            };
            FLVParser.prototype._error = function (message) {
                this.state = -1;
                this.onError && this.onError(message);
            };
            FLVParser.prototype.close = function () {
                this.onClose && this.onClose();
            };
            return FLVParser;
        })();
        FLV.FLVParser = FLVParser;
    })(FLV = RtmpJs.FLV || (RtmpJs.FLV = {}));
})(RtmpJs || (RtmpJs = {}));
/// <reference path='../../build/ts/avm2.d.ts' />
///<reference path='external.ts' />
///<reference path='rtmp.ts' />
///<reference path='transport.ts' />
///<reference path='transport-browser.ts' />
///<reference path='mp4iso.ts' />
///<reference path='mp4mux.ts' />
///<reference path='flvparser.ts' />
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Matrix
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var PI = Math.PI;
                    var HalfPI = PI / 2;
                    var PacPI = PI + HalfPI;
                    var TwoPI = PI * 2;
                    function cos(angle) {
                        switch (angle) {
                            case HalfPI:
                            case -PacPI: return 0;
                            case PI:
                            case -PI: return -1;
                            case PacPI:
                            case -HalfPI: return 0;
                            default:
                                return Math.cos(angle);
                        }
                    }
                    function sin(angle) {
                        switch (angle) {
                            case HalfPI:
                            case -PacPI: return 1;
                            case PI:
                            case -PI: return 0;
                            case PacPI:
                            case -HalfPI: return -1;
                            default:
                                return Math.sin(angle);
                        }
                    }
                    var Matrix = (function (_super) {
                        __extends(Matrix, _super);
                        // "invert", "identity", "createBox",
                        // "createGradientBox", "rotate", "translate",
                        // "scale", "deltaTransformPoint", "transformPoint",
                        // "copyFrom", "setTo", "copyRowTo", "copyColumnTo",
                        // "copyRowFrom", "copyColumnFrom", "clone",
                        // "toString"];
                        function Matrix(a, b, c, d, tx, ty) {
                            if (a === void 0) { a = 1; }
                            if (b === void 0) { b = 0; }
                            if (c === void 0) { c = 0; }
                            if (d === void 0) { d = 1; }
                            if (tx === void 0) { tx = 0; }
                            if (ty === void 0) { ty = 0; }
                            _super.call(this);
                            var m = this._data = new Float64Array(6);
                            m[0] = a;
                            m[1] = b;
                            m[2] = c;
                            m[3] = d;
                            m[4] = tx;
                            m[5] = ty;
                        }
                        Matrix.classInitializer = function () {
                            this.FROZEN_IDENTITY_MATRIX = Object.freeze(this.axConstruct([]));
                            this.TEMP_MATRIX = this.axConstruct([]);
                        };
                        Matrix.FromUntyped = function (object) {
                            return new this.sec.flash.geom.Matrix(object.a, object.b, object.c, object.d, object.tx, object.ty);
                        };
                        // Keep in sync with writeExternal below!
                        Matrix.FromDataBuffer = function (input) {
                            return new this.sec.flash.geom.Matrix(input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat());
                        };
                        Object.defineProperty(Matrix.prototype, "a", {
                            get: function () {
                                return this._data[0];
                            },
                            set: function (a) {
                                this._data[0] = a;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix.prototype, "b", {
                            get: function () {
                                return this._data[1];
                            },
                            set: function (b) {
                                this._data[1] = b;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix.prototype, "c", {
                            get: function () {
                                return this._data[2];
                            },
                            set: function (c) {
                                this._data[2] = c;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix.prototype, "d", {
                            get: function () {
                                return this._data[3];
                            },
                            set: function (d) {
                                this._data[3] = d;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix.prototype, "tx", {
                            get: function () {
                                return this._data[4];
                            },
                            set: function (tx) {
                                this._data[4] = tx;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix.prototype, "ty", {
                            get: function () {
                                return this._data[5];
                            },
                            set: function (ty) {
                                this._data[5] = ty;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * this = this * other
                         */
                        Matrix.prototype.concat = function (other) {
                            var m = this._data, n = other._data;
                            var a = m[0] * n[0];
                            var b = 0.0;
                            var c = 0.0;
                            var d = m[3] * n[3];
                            var tx = m[4] * n[0] + n[4];
                            var ty = m[5] * n[3] + n[5];
                            if (m[1] !== 0.0 || m[2] !== 0.0 || n[1] !== 0.0 || n[2] !== 0.0) {
                                a += m[1] * n[2];
                                d += m[2] * n[1];
                                b += m[0] * n[1] + m[1] * n[3];
                                c += m[2] * n[0] + m[3] * n[2];
                                tx += m[5] * n[2];
                                ty += m[4] * n[1];
                            }
                            m[0] = a;
                            m[1] = b;
                            m[2] = c;
                            m[3] = d;
                            m[4] = tx;
                            m[5] = ty;
                        };
                        /**
                         * this = other * this
                         */
                        Matrix.prototype.preMultiply = function (other) {
                            this.preMultiplyInto(other, this);
                        };
                        /**
                         * target = other * this
                         */
                        Matrix.prototype.preMultiplyInto = function (other, target) {
                            var m = this._data, n = other._data, t = target._data;
                            var a = n[0] * m[0];
                            var b = 0.0;
                            var c = 0.0;
                            var d = n[3] * m[3];
                            var tx = n[4] * m[0] + m[4];
                            var ty = n[5] * m[3] + m[5];
                            if (n[1] !== 0.0 || n[2] !== 0.0 || m[1] !== 0.0 || m[2] !== 0.0) {
                                a += n[1] * m[2];
                                d += n[2] * m[1];
                                b += n[0] * m[1] + n[1] * m[3];
                                c += n[2] * m[0] + n[3] * m[2];
                                tx += n[5] * m[2];
                                ty += n[4] * m[1];
                            }
                            t[0] = a;
                            t[1] = b;
                            t[2] = c;
                            t[3] = d;
                            t[4] = tx;
                            t[5] = ty;
                        };
                        Matrix.prototype.invert = function () {
                            this.invertInto(this);
                        };
                        Matrix.prototype.invertInto = function (target) {
                            var m = this._data, t = target._data;
                            var b = m[1];
                            var c = m[2];
                            var tx = m[4];
                            var ty = m[5];
                            if (b === 0 && c === 0) {
                                var a = t[0] = 1 / m[0];
                                var d = t[3] = 1 / m[3];
                                t[1] = t[2] = 0;
                                t[4] = -a * tx;
                                t[5] = -d * ty;
                                return;
                            }
                            var a = m[0];
                            var d = m[3];
                            var determinant = a * d - b * c;
                            if (determinant === 0) {
                                target.identity();
                                return;
                            }
                            /**
                             * Multiplying by reciprocal of the |determinant| is only accurate if the reciprocal is
                             * representable without loss of precision. This is usually only the case for powers of
                             * two: 1/2, 1/4 ...
                             */
                            determinant = 1 / determinant;
                            var k = 0;
                            k = t[0] = d * determinant;
                            b = t[1] = -b * determinant;
                            c = t[2] = -c * determinant;
                            d = t[3] = a * determinant;
                            t[4] = -(k * tx + c * ty);
                            t[5] = -(b * tx + d * ty);
                        };
                        Matrix.prototype.identity = function () {
                            var m = this._data;
                            m[0] = m[3] = 1;
                            m[1] = m[2] = m[4] = m[5] = 0;
                        };
                        Matrix.prototype.createBox = function (scaleX, scaleY, rotation, tx, ty) {
                            if (rotation === void 0) { rotation = 0; }
                            if (tx === void 0) { tx = 0; }
                            if (ty === void 0) { ty = 0; }
                            var m = this._data;
                            if (rotation !== 0) {
                                var u = cos(rotation);
                                var v = sin(rotation);
                                m[0] = u * scaleX;
                                m[1] = v * scaleY;
                                m[2] = -v * scaleX;
                                m[3] = u * scaleY;
                            }
                            else {
                                m[0] = scaleX;
                                m[1] = 0;
                                m[2] = 0;
                                m[3] = scaleY;
                            }
                            m[4] = tx;
                            m[5] = ty;
                        };
                        Matrix.prototype.createGradientBox = function (width, height, rotation, tx, ty) {
                            if (rotation === void 0) { rotation = 0; }
                            if (tx === void 0) { tx = 0; }
                            if (ty === void 0) { ty = 0; }
                            this.createBox(width / 1638.4, height / 1638.4, rotation, tx + width / 2, ty + height / 2);
                        };
                        Matrix.prototype.rotate = function (angle) {
                            angle = +angle;
                            if (angle !== 0) {
                                var m = this._data;
                                var u = cos(angle);
                                var v = sin(angle);
                                var ta = m[0];
                                var tb = m[1];
                                var tc = m[2];
                                var td = m[3];
                                var ttx = m[4];
                                var tty = m[5];
                                m[0] = ta * u - tb * v;
                                m[1] = ta * v + tb * u;
                                m[2] = tc * u - td * v;
                                m[3] = tc * v + td * u;
                                m[4] = ttx * u - tty * v;
                                m[5] = ttx * v + tty * u;
                            }
                        };
                        Matrix.prototype.translate = function (dx, dy) {
                            var m = this._data;
                            m[4] += dx;
                            m[5] += dy;
                        };
                        Matrix.prototype.scale = function (sx, sy) {
                            var m = this._data;
                            if (sx !== 1) {
                                m[0] *= sx;
                                m[2] *= sx;
                                m[4] *= sx;
                            }
                            if (sy !== 1) {
                                m[1] *= sy;
                                m[3] *= sy;
                                m[5] *= sy;
                            }
                        };
                        Matrix.prototype.deltaTransformPoint = function (point) {
                            var x = this._data[0] * point.x + this._data[2] * point.y;
                            var y = this._data[1] * point.x + this._data[3] * point.y;
                            return new this.sec.flash.geom.Point(x, y);
                        };
                        Matrix.prototype.transformX = function (x, y) {
                            var m = this._data;
                            return m[0] * x + m[2] * y + m[4];
                        };
                        Matrix.prototype.transformY = function (x, y) {
                            var m = this._data;
                            return m[1] * x + m[3] * y + m[5];
                        };
                        Matrix.prototype.transformPoint = function (point) {
                            var m = this._data;
                            return new this.sec.flash.geom.Point(m[0] * point.x + m[2] * point.y + m[4], m[1] * point.x + m[3] * point.y + m[5]);
                        };
                        Matrix.prototype.transformPointInPlace = function (point) {
                            var m = this._data;
                            point.setTo(m[0] * point.x + m[2] * point.y + m[4], m[1] * point.x + m[3] * point.y + m[5]);
                            return point;
                        };
                        Matrix.prototype.transformBounds = function (bounds) {
                            var m = this._data;
                            var a = m[0];
                            var b = m[1];
                            var c = m[2];
                            var d = m[3];
                            var tx = m[4];
                            var ty = m[5];
                            var x = bounds.xMin;
                            var y = bounds.yMin;
                            var w = bounds.width;
                            var h = bounds.height;
                            var x0 = Math.round(a * x + c * y + tx);
                            var y0 = Math.round(b * x + d * y + ty);
                            var x1 = Math.round(a * (x + w) + c * y + tx);
                            var y1 = Math.round(b * (x + w) + d * y + ty);
                            var x2 = Math.round(a * (x + w) + c * (y + h) + tx);
                            var y2 = Math.round(b * (x + w) + d * (y + h) + ty);
                            var x3 = Math.round(a * x + c * (y + h) + tx);
                            var y3 = Math.round(b * x + d * (y + h) + ty);
                            var tmp = 0;
                            // Manual Min/Max is a lot faster than calling Math.min/max
                            // X Min-Max
                            if (x0 > x1) {
                                tmp = x0;
                                x0 = x1;
                                x1 = tmp;
                            }
                            if (x2 > x3) {
                                tmp = x2;
                                x2 = x3;
                                x3 = tmp;
                            }
                            bounds.xMin = x0 < x2 ? x0 : x2;
                            bounds.xMax = x1 > x3 ? x1 : x3;
                            // Y Min-Max
                            if (y0 > y1) {
                                tmp = y0;
                                y0 = y1;
                                y1 = tmp;
                            }
                            if (y2 > y3) {
                                tmp = y2;
                                y2 = y3;
                                y3 = tmp;
                            }
                            bounds.yMin = y0 < y2 ? y0 : y2;
                            bounds.yMax = y1 > y3 ? y1 : y3;
                        };
                        Matrix.prototype.getDeterminant = function () {
                            var m = this._data;
                            return m[0] * m[3] - m[1] * m[2];
                        };
                        Matrix.prototype.getScaleX = function () {
                            var m = this._data;
                            if (m[0] === 1 && m[1] === 0) {
                                return 1;
                            }
                            var result = Math.sqrt(m[0] * m[0] + m[1] * m[1]);
                            return this.getDeterminant() < 0 ? -result : result;
                        };
                        Matrix.prototype.getScaleY = function () {
                            var m = this._data;
                            if (m[2] === 0 && m[3] === 1) {
                                return 1;
                            }
                            var result = Math.sqrt(m[2] * m[2] + m[3] * m[3]);
                            return this.getDeterminant() < 0 ? -result : result;
                        };
                        Matrix.prototype.getAbsoluteScaleX = function () {
                            return Math.abs(this.getScaleX());
                        };
                        Matrix.prototype.getAbsoluteScaleY = function () {
                            return Math.abs(this.getScaleY());
                        };
                        Matrix.prototype.getSkewX = function () {
                            return Math.atan2(this._data[3], this._data[2]) - (Math.PI / 2);
                        };
                        Matrix.prototype.getSkewY = function () {
                            return Math.atan2(this._data[1], this._data[0]);
                        };
                        Matrix.prototype.copyFrom = function (other) {
                            var m = this._data, n = other._data;
                            m[0] = n[0];
                            m[1] = n[1];
                            m[2] = n[2];
                            m[3] = n[3];
                            m[4] = n[4];
                            m[5] = n[5];
                        };
                        Matrix.prototype.copyFromUntyped = function (object) {
                            var m = this._data;
                            m[0] = object.a;
                            m[1] = object.b;
                            m[2] = object.c;
                            m[3] = object.d;
                            m[4] = object.tx;
                            m[5] = object.ty;
                        };
                        Matrix.prototype.setTo = function (a, b, c, d, tx, ty) {
                            var m = this._data;
                            m[0] = a;
                            m[1] = b;
                            m[2] = c;
                            m[3] = d;
                            m[4] = tx;
                            m[5] = ty;
                        };
                        Matrix.prototype.toTwipsInPlace = function () {
                            var m = this._data;
                            m[4] = (m[4] * 20) | 0;
                            m[5] = (m[5] * 20) | 0;
                            return this;
                        };
                        Matrix.prototype.toPixelsInPlace = function () {
                            var m = this._data;
                            m[4] /= 20;
                            m[5] /= 20;
                            return this;
                        };
                        Matrix.prototype.toSerializedScaleInPlace = function () {
                            var m = this._data;
                            m[0] *= 819.2;
                            m[1] *= 819.2;
                            m[2] *= 819.2;
                            m[3] *= 819.2;
                            return this;
                        };
                        Matrix.prototype.copyRowTo = function (row, vector3D) {
                            var m = this._data;
                            row = row >>> 0;
                            if (row === 0) {
                                vector3D.x = m[0];
                                vector3D.y = m[2];
                                vector3D.z = m[4];
                            }
                            else if (row === 1) {
                                vector3D.x = m[1];
                                vector3D.y = m[3];
                                vector3D.z = m[5];
                            }
                            else if (row === 2) {
                                vector3D.x = 0;
                                vector3D.y = 0;
                                vector3D.z = 1;
                            }
                        };
                        Matrix.prototype.copyColumnTo = function (column, vector3D) {
                            var m = this._data;
                            column = column >>> 0;
                            if (column === 0) {
                                vector3D.x = m[0];
                                vector3D.y = m[1];
                                vector3D.z = 0;
                            }
                            else if (column === 1) {
                                vector3D.x = m[2];
                                vector3D.y = m[3];
                                vector3D.z = 0;
                            }
                            else if (column === 2) {
                                vector3D.x = m[4];
                                vector3D.y = m[5];
                                vector3D.z = 1;
                            }
                        };
                        Matrix.prototype.copyRowFrom = function (row, vector3D) {
                            var m = this._data;
                            row = row >>> 0;
                            if (row === 0) {
                                m[0] = vector3D.x;
                                m[2] = vector3D.y;
                                m[4] = vector3D.z;
                            }
                            else if (row === 1) {
                                m[1] = vector3D.x;
                                m[3] = vector3D.y;
                                m[5] = vector3D.z;
                            }
                        };
                        Matrix.prototype.copyColumnFrom = function (column, vector3D) {
                            var m = this._data;
                            column = column >>> 0;
                            if (column === 0) {
                                m[0] = vector3D.x;
                                m[2] = vector3D.y;
                                m[4] = vector3D.z;
                            }
                            else if (column === 1) {
                                m[1] = vector3D.x;
                                m[3] = vector3D.y;
                                m[5] = vector3D.z;
                            }
                        };
                        /**
                         * Updates the scale and skew componenets of the matrix.
                         */
                        Matrix.prototype.updateScaleAndRotation = function (scaleX, scaleY, skewX, skewY) {
                            var m = this._data;
                            // The common case.
                            if ((skewX === 0 || skewX === TwoPI) && (skewY === 0 || skewY === TwoPI)) {
                                m[0] = scaleX;
                                m[1] = m[2] = 0;
                                m[3] = scaleY;
                                return;
                            }
                            var u = cos(skewX);
                            var v = sin(skewX);
                            if (skewX === skewY) {
                                m[0] = u * scaleX;
                                m[1] = v * scaleX;
                            }
                            else {
                                m[0] = cos(skewY) * scaleX;
                                m[1] = sin(skewY) * scaleX;
                            }
                            m[2] = -v * scaleY;
                            m[3] = u * scaleY;
                        };
                        Matrix.prototype.clone = function () {
                            var m = this._data;
                            return new this.sec.flash.geom.Matrix(m[0], m[1], m[2], m[3], m[4], m[5]);
                        };
                        Matrix.prototype.equals = function (other) {
                            var m = this._data, n = other._data;
                            return m[0] === n[0] && m[1] === n[1] &&
                                m[2] === n[2] && m[3] === n[3] &&
                                m[4] === n[4] && m[5] === n[5];
                        };
                        Matrix.prototype.toString = function () {
                            var m = this._data;
                            return "(a=" + m[0] + ", b=" + m[1] + ", c=" + m[2] + ", d=" + m[3] + ", tx=" + m[4] + ", ty=" + m[5] + ")";
                        };
                        // Keep in sync with static FromDataBuffer above!
                        Matrix.prototype.writeExternal = function (output) {
                            var m = this._data;
                            output.writeFloat(m[0]);
                            output.writeFloat(m[1]);
                            output.writeFloat(m[2]);
                            output.writeFloat(m[3]);
                            output.writeFloat(m[4]);
                            output.writeFloat(m[5]);
                        };
                        Matrix.classSymbols = null; // [];
                        Matrix.instanceSymbols = null; // ["a", "b", "c", "d", "tx", "ty", "concat",
                        return Matrix;
                    })(AS.ASObject);
                    geom.Matrix = Matrix;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Matrix3D
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    /*
                     * _matrix stores data by columns
                     *  | 0  4  8  12 |
                     *  | 1  5  9  13 |
                     *  | 2  6 10  14 |
                     *  | 3  7 11  15 |
                     */
                    var precision = 1e-7;
                    var transposeTransform = new Uint32Array([
                        0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15
                    ]);
                    function getRotationMatrix(theta, u, v, w, a, b, c, sec) {
                        // http://inside.mines.edu/~gmurray/ArbitraryAxisRotation/
                        var u2 = u * u, v2 = v * v, w2 = w * w;
                        var L2 = u2 + v2 + w2, L = Math.sqrt(L2);
                        u /= L;
                        v /= L;
                        w /= L;
                        u2 /= L2;
                        v2 /= L2;
                        w2 /= L2;
                        var cos = Math.cos(theta), sin = Math.sin(theta);
                        return sec.flash.geom.Matrix3D.axClass.FromArray([
                            u2 + (v2 + w2) * cos,
                            u * v * (1 - cos) + w * sin,
                            u * w * (1 - cos) - v * sin,
                            0,
                            u * v * (1 - cos) - w * sin,
                            v2 + (u2 + w2) * cos,
                            v * w * (1 - cos) + u * sin,
                            0,
                            u * w * (1 - cos) + v * sin,
                            v * w * (1 - cos) - u * sin,
                            w2 + (u2 + v2) * cos,
                            0,
                            (a * (v2 + w2) - u * (b * v + c * w)) * (1 - cos) + (b * w - c * v) * sin,
                            (b * (u2 + w2) - v * (a * u + c * w)) * (1 - cos) + (c * u - a * w) * sin,
                            (c * (u2 + v2) - w * (a * u + b * v)) * (1 - cos) + (a * v - b * u) * sin,
                            1
                        ]);
                    }
                    var Matrix3D = (function (_super) {
                        __extends(Matrix3D, _super);
                        function Matrix3D(v) {
                            if (v === void 0) { v = null; }
                            _super.call(this);
                            this._matrix = new Float32Array(16);
                            if (v && v.length >= 16) {
                                this.copyRawDataFrom(v, 0, false);
                            }
                            else {
                                this.identity();
                            }
                        }
                        Matrix3D.FromArray = function (matrix) {
                            var result = Object.create(this.tPrototype);
                            result._matrix = new Float32Array(matrix);
                            return result;
                        };
                        Matrix3D.interpolate = function (thisMat, toMat, percent) {
                            thisMat = thisMat;
                            toMat = toMat;
                            percent = +percent;
                            release || notImplemented("public flash.geom.Matrix3D::static interpolate");
                            return;
                        };
                        Matrix3D.prototype.setTargetDisplayObject = function (object) {
                            if (this._displayObject) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.Matrix3DRefCannontBeShared);
                            }
                            this._displayObject = object;
                        };
                        Matrix3D.prototype.resetTargetDisplayObject = function () {
                            release || Shumway.Debug.assert(this._displayObject);
                            this._displayObject = null;
                        };
                        Object.defineProperty(Matrix3D.prototype, "rawData", {
                            get: function () {
                                var result = new this.sec.Float64Vector();
                                this.copyRawDataTo(result, 0, false);
                                return result;
                            },
                            set: function (v) {
                                this.copyRawDataFrom(v, 0, false);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix3D.prototype, "position", {
                            get: function () {
                                var m = this._matrix;
                                return new this.sec.flash.geom.Vector3D(m[12], m[13], m[14]);
                            },
                            set: function (pos) {
                                var m = this._matrix;
                                m[12] = pos.x;
                                m[13] = pos.y;
                                m[14] = pos.z;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Matrix3D.prototype, "determinant", {
                            get: function () {
                                var m = this._matrix;
                                var m11 = m[0], m12 = m[4], m13 = m[8], m14 = m[12], m21 = m[1], m22 = m[5], m23 = m[9], m24 = m[13], m31 = m[2], m32 = m[6], m33 = m[10], m34 = m[14], m41 = m[3], m42 = m[7], m43 = m[11], m44 = m[15];
                                var d;
                                d = m11 * (m22 * (m33 * m44 - m43 * m34) - m32 * (m23 * m44 - m43 * m24) + m42 * (m23 * m34 - m33 * m24)) -
                                    m21 * (m12 * (m33 * m44 - m43 * m34) - m32 * (m13 * m44 - m43 * m14) + m42 * (m13 * m34 - m33 * m14)) +
                                    m31 * (m12 * (m23 * m44 - m43 * m24) - m22 * (m13 * m44 - m43 * m14) + m42 * (m13 * m24 - m23 * m14)) -
                                    m41 * (m12 * (m23 * m34 - m33 * m24) - m22 * (m13 * m34 - m33 * m14) + m32 * (m13 * m24 - m23 * m14));
                                return d;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Matrix3D.prototype.clone = function () {
                            return this.sec.flash.geom.Matrix3D.axClass.FromArray(this._matrix);
                        };
                        Matrix3D.prototype.copyToMatrix3D = function (dest) {
                            dest = dest;
                            dest._matrix.set(this._matrix);
                        };
                        Matrix3D.prototype.append = function (lhs) {
                            var ma = lhs._matrix, mb = this._matrix, m = this._matrix;
                            var ma11 = ma[0], ma12 = ma[4], ma13 = ma[8], ma14 = ma[12], ma21 = ma[1], ma22 = ma[5], ma23 = ma[9], ma24 = ma[13], ma31 = ma[2], ma32 = ma[6], ma33 = ma[10], ma34 = ma[14], ma41 = ma[3], ma42 = ma[7], ma43 = ma[11], ma44 = ma[15];
                            var mb11 = mb[0], mb12 = mb[4], mb13 = mb[8], mb14 = mb[12], mb21 = mb[1], mb22 = mb[5], mb23 = mb[9], mb24 = mb[13], mb31 = mb[2], mb32 = mb[6], mb33 = mb[10], mb34 = mb[14], mb41 = mb[3], mb42 = mb[7], mb43 = mb[11], mb44 = mb[15];
                            m[0] = ma11 * mb11 + ma12 * mb21 + ma13 * mb31 + ma14 * mb41;
                            m[1] = ma21 * mb11 + ma22 * mb21 + ma23 * mb31 + ma24 * mb41;
                            m[2] = ma31 * mb11 + ma32 * mb21 + ma33 * mb31 + ma34 * mb41;
                            m[3] = ma41 * mb11 + ma42 * mb21 + ma43 * mb31 + ma44 * mb41;
                            m[4] = ma11 * mb12 + ma12 * mb22 + ma13 * mb32 + ma14 * mb42;
                            m[5] = ma21 * mb12 + ma22 * mb22 + ma23 * mb32 + ma24 * mb42;
                            m[6] = ma31 * mb12 + ma32 * mb22 + ma33 * mb32 + ma34 * mb42;
                            m[7] = ma41 * mb12 + ma42 * mb22 + ma43 * mb32 + ma44 * mb42;
                            m[8] = ma11 * mb13 + ma12 * mb23 + ma13 * mb33 + ma14 * mb43;
                            m[9] = ma21 * mb13 + ma22 * mb23 + ma23 * mb33 + ma24 * mb43;
                            m[10] = ma31 * mb13 + ma32 * mb23 + ma33 * mb33 + ma34 * mb43;
                            m[11] = ma41 * mb13 + ma42 * mb23 + ma43 * mb33 + ma44 * mb43;
                            m[12] = ma11 * mb14 + ma12 * mb24 + ma13 * mb34 + ma14 * mb44;
                            m[13] = ma21 * mb14 + ma22 * mb24 + ma23 * mb34 + ma24 * mb44;
                            m[14] = ma31 * mb14 + ma32 * mb24 + ma33 * mb34 + ma34 * mb44;
                            m[15] = ma41 * mb14 + ma42 * mb24 + ma43 * mb34 + ma44 * mb44;
                        };
                        Matrix3D.prototype.prepend = function (rhs) {
                            var ma = this._matrix, mb = rhs._matrix, m = this._matrix;
                            var ma11 = ma[0], ma12 = ma[4], ma13 = ma[8], ma14 = ma[12], ma21 = ma[1], ma22 = ma[5], ma23 = ma[9], ma24 = ma[13], ma31 = ma[2], ma32 = ma[6], ma33 = ma[10], ma34 = ma[14], ma41 = ma[3], ma42 = ma[7], ma43 = ma[11], ma44 = ma[15];
                            var mb11 = mb[0], mb12 = mb[4], mb13 = mb[8], mb14 = mb[12], mb21 = mb[1], mb22 = mb[5], mb23 = mb[9], mb24 = mb[13], mb31 = mb[2], mb32 = mb[6], mb33 = mb[10], mb34 = mb[14], mb41 = mb[3], mb42 = mb[7], mb43 = mb[11], mb44 = mb[15];
                            m[0] = ma11 * mb11 + ma12 * mb21 + ma13 * mb31 + ma14 * mb41;
                            m[1] = ma21 * mb11 + ma22 * mb21 + ma23 * mb31 + ma24 * mb41;
                            m[2] = ma31 * mb11 + ma32 * mb21 + ma33 * mb31 + ma34 * mb41;
                            m[3] = ma41 * mb11 + ma42 * mb21 + ma43 * mb31 + ma44 * mb41;
                            m[4] = ma11 * mb12 + ma12 * mb22 + ma13 * mb32 + ma14 * mb42;
                            m[5] = ma21 * mb12 + ma22 * mb22 + ma23 * mb32 + ma24 * mb42;
                            m[6] = ma31 * mb12 + ma32 * mb22 + ma33 * mb32 + ma34 * mb42;
                            m[7] = ma41 * mb12 + ma42 * mb22 + ma43 * mb32 + ma44 * mb42;
                            m[8] = ma11 * mb13 + ma12 * mb23 + ma13 * mb33 + ma14 * mb43;
                            m[9] = ma21 * mb13 + ma22 * mb23 + ma23 * mb33 + ma24 * mb43;
                            m[10] = ma31 * mb13 + ma32 * mb23 + ma33 * mb33 + ma34 * mb43;
                            m[11] = ma41 * mb13 + ma42 * mb23 + ma43 * mb33 + ma44 * mb43;
                            m[12] = ma11 * mb14 + ma12 * mb24 + ma13 * mb34 + ma14 * mb44;
                            m[13] = ma21 * mb14 + ma22 * mb24 + ma23 * mb34 + ma24 * mb44;
                            m[14] = ma31 * mb14 + ma32 * mb24 + ma33 * mb34 + ma34 * mb44;
                            m[15] = ma41 * mb14 + ma42 * mb24 + ma43 * mb34 + ma44 * mb44;
                        };
                        Matrix3D.prototype.invert = function () {
                            var d = this.determinant;
                            if (Math.abs(d) < precision) {
                                return false;
                            }
                            d = 1 / d;
                            var m = this._matrix;
                            // operating on transposed matrix
                            var m11 = m[0], m12 = m[1], m13 = m[2], m14 = m[3], m21 = m[4], m22 = m[5], m23 = m[6], m24 = m[7], m31 = m[8], m32 = m[9], m33 = m[10], m34 = m[11], m41 = m[12], m42 = m[13], m43 = m[14], m44 = m[15];
                            m[0] = d * (m22 * (m33 * m44 - m43 * m34) - m32 * (m23 * m44 - m43 * m24) + m42 * (m23 * m34 - m33 * m24));
                            m[1] = -d * (m12 * (m33 * m44 - m43 * m34) - m32 * (m13 * m44 - m43 * m14) + m42 * (m13 * m34 - m33 * m14));
                            m[2] = d * (m12 * (m23 * m44 - m43 * m24) - m22 * (m13 * m44 - m43 * m14) + m42 * (m13 * m24 - m23 * m14));
                            m[3] = -d * (m12 * (m23 * m34 - m33 * m24) - m22 * (m13 * m34 - m33 * m14) + m32 * (m13 * m24 - m23 * m14));
                            m[4] = -d * (m21 * (m33 * m44 - m43 * m34) - m31 * (m23 * m44 - m43 * m24) + m41 * (m23 * m34 - m33 * m24));
                            m[5] = d * (m11 * (m33 * m44 - m43 * m34) - m31 * (m13 * m44 - m43 * m14) + m41 * (m13 * m34 - m33 * m14));
                            m[6] = -d * (m11 * (m23 * m44 - m43 * m24) - m21 * (m13 * m44 - m43 * m14) + m41 * (m13 * m24 - m23 * m14));
                            m[7] = d * (m11 * (m23 * m34 - m33 * m24) - m21 * (m13 * m34 - m33 * m14) + m31 * (m13 * m24 - m23 * m14));
                            m[8] = d * (m21 * (m32 * m44 - m42 * m34) - m31 * (m22 * m44 - m42 * m24) + m41 * (m22 * m34 - m32 * m24));
                            m[9] = -d * (m11 * (m32 * m44 - m42 * m34) - m31 * (m12 * m44 - m42 * m14) + m41 * (m12 * m34 - m32 * m14));
                            m[10] = d * (m11 * (m22 * m44 - m42 * m24) - m21 * (m12 * m44 - m42 * m14) + m41 * (m12 * m24 - m22 * m14));
                            m[11] = -d * (m11 * (m22 * m34 - m32 * m24) - m21 * (m12 * m34 - m32 * m14) + m31 * (m12 * m24 - m22 * m14));
                            m[12] = -d * (m21 * (m32 * m43 - m42 * m33) - m31 * (m22 * m43 - m42 * m23) + m41 * (m22 * m33 - m32 * m23));
                            m[13] = d * (m11 * (m32 * m43 - m42 * m33) - m31 * (m12 * m43 - m42 * m13) + m41 * (m12 * m33 - m32 * m13));
                            m[14] = -d * (m11 * (m22 * m43 - m42 * m23) - m21 * (m12 * m43 - m42 * m13) + m41 * (m12 * m23 - m22 * m13));
                            m[15] = d * (m11 * (m22 * m33 - m32 * m23) - m21 * (m12 * m33 - m32 * m13) + m31 * (m12 * m23 - m22 * m13));
                            return true;
                        };
                        Matrix3D.prototype.identity = function () {
                            var m = this._matrix;
                            m[0] = m[5] = m[10] = m[15] = 1;
                            m[1] = m[2] = m[3] = m[4] = m[6] = m[7] = m[8] = m[9] = m[11] = m[12] = m[13] = m[14] = 0;
                        };
                        Matrix3D.prototype.decompose = function (orientationStyle) {
                            if (orientationStyle === void 0) { orientationStyle = "eulerAngles"; }
                            orientationStyle = axCoerceString(orientationStyle);
                            release || notImplemented("public flash.geom.Matrix3D::decompose");
                            return;
                        };
                        Matrix3D.prototype.recompose = function (components, orientationStyle) {
                            if (orientationStyle === void 0) { orientationStyle = "eulerAngles"; }
                            orientationStyle = axCoerceString(orientationStyle);
                            release || notImplemented("public flash.geom.Matrix3D::recompose");
                            return;
                        };
                        Matrix3D.prototype.appendTranslation = function (x, y, z) {
                            x = +x;
                            y = +y;
                            z = +z;
                            var m = this._matrix;
                            var m41 = m[3], m42 = m[7], m43 = m[11], m44 = m[15];
                            m[0] += x * m41;
                            m[1] += y * m41;
                            m[2] += z * m41;
                            m[4] += x * m42;
                            m[5] += y * m42;
                            m[6] += z * m42;
                            m[8] += x * m43;
                            m[9] += y * m43;
                            m[10] += z * m43;
                            m[12] += x * m44;
                            m[13] += y * m44;
                            m[14] += z * m44;
                        };
                        Matrix3D.prototype.appendRotation = function (degrees, axis, pivotPoint) {
                            if (pivotPoint === void 0) { pivotPoint = null; }
                            degrees = +degrees;
                            axis = axis;
                            pivotPoint = pivotPoint;
                            this.append(getRotationMatrix(degrees / 180 * Math.PI, axis.x, axis.y, axis.z, pivotPoint ? pivotPoint.x : 0, pivotPoint ? pivotPoint.y : 0, pivotPoint ? pivotPoint.z : 0, this.sec));
                        };
                        Matrix3D.prototype.appendScale = function (xScale, yScale, zScale) {
                            xScale = +xScale;
                            yScale = +yScale;
                            zScale = +zScale;
                            var m = this._matrix;
                            m[0] *= xScale;
                            m[1] *= yScale;
                            m[2] *= zScale;
                            m[4] *= xScale;
                            m[5] *= yScale;
                            m[6] *= zScale;
                            m[8] *= xScale;
                            m[9] *= yScale;
                            m[10] *= zScale;
                            m[12] *= xScale;
                            m[13] *= yScale;
                            m[14] *= zScale;
                        };
                        Matrix3D.prototype.prependTranslation = function (x, y, z) {
                            x = +x;
                            y = +y;
                            z = +z;
                            var m = this._matrix;
                            var m11 = m[0], m12 = m[4], m13 = m[8], m14 = m[12], m21 = m[1], m22 = m[5], m23 = m[9], m24 = m[13], m31 = m[2], m32 = m[6], m33 = m[10], m34 = m[14], m41 = m[3], m42 = m[7], m43 = m[11], m44 = m[15];
                            m[12] += m11 * x + m12 * y + m13 * z;
                            m[13] += m21 * x + m22 * y + m23 * z;
                            m[14] += m31 * x + m32 * y + m33 * z;
                            m[15] += m41 * x + m42 * y + m43 * z;
                        };
                        Matrix3D.prototype.prependRotation = function (degrees, axis, pivotPoint) {
                            if (pivotPoint === void 0) { pivotPoint = null; }
                            degrees = +degrees;
                            axis = axis;
                            pivotPoint = pivotPoint;
                            this.prepend(getRotationMatrix(degrees / 180 * Math.PI, axis.x, axis.y, axis.z, pivotPoint ? pivotPoint.x : 0, pivotPoint ? pivotPoint.y : 0, pivotPoint ? pivotPoint.z : 0, this.sec));
                        };
                        Matrix3D.prototype.prependScale = function (xScale, yScale, zScale) {
                            xScale = +xScale;
                            yScale = +yScale;
                            zScale = +zScale;
                            var m = this._matrix;
                            m[0] *= xScale;
                            m[1] *= xScale;
                            m[2] *= xScale;
                            m[3] *= xScale;
                            m[4] *= yScale;
                            m[5] *= yScale;
                            m[6] *= yScale;
                            m[7] *= yScale;
                            m[8] *= zScale;
                            m[9] *= zScale;
                            m[10] *= zScale;
                            m[11] *= zScale;
                        };
                        Matrix3D.prototype.transformVector = function (v) {
                            var m = this._matrix;
                            var x = v.x, y = v.y, z = v.z;
                            return new this.sec.flash.geom.Vector3D(m[0] * x + m[4] * y + m[8] * z + m[12], m[1] * x + m[5] * y + m[9] * z + m[13], m[2] * x + m[6] * y + m[10] * z + m[14]);
                        };
                        Matrix3D.prototype.deltaTransformVector = function (v) {
                            var m = this._matrix;
                            var x = v.x, y = v.y, z = v.z;
                            return new this.sec.flash.geom.Vector3D(m[0] * x + m[4] * y + m[8] * z, m[1] * x + m[5] * y + m[9] * z, m[2] * x + m[6] * y + m[10] * z);
                        };
                        Matrix3D.prototype.transformVectors = function (vin, vout) {
                            var m = this._matrix;
                            var m11 = m[0], m12 = m[4], m13 = m[8], m14 = m[12], m21 = m[1], m22 = m[5], m23 = m[9], m24 = m[13], m31 = m[2], m32 = m[6], m33 = m[10], m34 = m[14], m41 = m[3], m42 = m[7], m43 = m[11], m44 = m[15];
                            for (var i = 0; i < vin.length - 2; i += 3) {
                                var x = vin.axGetNumericProperty(i), y = vin.axGetNumericProperty(i + 1), z = vin.axGetNumericProperty(i + 2);
                                vout.push(m11 * x + m12 * y + m13 * z + m14);
                                vout.push(m21 * x + m22 * y + m23 * z + m24);
                                vout.push(m31 * x + m32 * y + m33 * z + m34);
                            }
                        };
                        Matrix3D.prototype.transpose = function () {
                            var m = this._matrix;
                            var tmp;
                            tmp = m[1];
                            m[1] = m[4];
                            m[4] = tmp;
                            tmp = m[2];
                            m[2] = m[8];
                            m[5] = tmp;
                            tmp = m[3];
                            m[3] = m[12];
                            m[12] = tmp;
                            tmp = m[6];
                            m[6] = m[9];
                            m[9] = tmp;
                            tmp = m[7];
                            m[7] = m[13];
                            m[13] = tmp;
                            tmp = m[11];
                            m[11] = m[14];
                            m[14] = tmp;
                        };
                        Matrix3D.prototype.pointAt = function (pos, at, up) {
                            if (at === void 0) { at = null; }
                            if (up === void 0) { up = null; }
                            pos = pos;
                            at = at;
                            up = up;
                            release || notImplemented("public flash.geom.Matrix3D::pointAt");
                            return;
                        };
                        Matrix3D.prototype.interpolateTo = function (toMat, percent) {
                            toMat = toMat;
                            percent = +percent;
                            release || notImplemented("public flash.geom.Matrix3D::interpolateTo");
                            return;
                        };
                        Matrix3D.prototype.copyFrom = function (sourceMatrix3D) {
                            sourceMatrix3D = sourceMatrix3D;
                            this._matrix.set(sourceMatrix3D._matrix);
                        };
                        Matrix3D.prototype.copyRawDataTo = function (vector, index, transpose) {
                            if (index === void 0) { index = 0; }
                            if (transpose === void 0) { transpose = false; }
                            vector = vector;
                            index = index >>> 0;
                            transpose = !!transpose;
                            var m = this._matrix;
                            if (transpose) {
                                for (var i = 0, j = index | 0; i < 16; i++, j++) {
                                    vector.axSetNumericProperty(j, m[transposeTransform[i]]);
                                }
                            }
                            else {
                                for (var i = 0, j = index | 0; i < 16; i++, j++) {
                                    vector.axSetNumericProperty(j, m[i]);
                                }
                            }
                        };
                        Matrix3D.prototype.copyRawDataFrom = function (vector, index, transpose) {
                            if (index === void 0) { index = 0; }
                            if (transpose === void 0) { transpose = false; }
                            vector = vector;
                            index = index >>> 0;
                            transpose = !!transpose;
                            var m = this._matrix;
                            if (transpose) {
                                for (var i = 0, j = index | 0; i < 16; i++, j++) {
                                    m[transposeTransform[i]] = vector.axGetNumericProperty(j) || 0; // removing NaN
                                }
                            }
                            else {
                                for (var i = 0, j = index | 0; i < 16; i++, j++) {
                                    m[i] = vector.axGetNumericProperty(j) || 0; // removing NaN
                                }
                            }
                        };
                        Matrix3D.prototype.copyRowTo = function (row /*uint*/, vector3D) {
                            row = row >>> 0;
                            vector3D = vector3D;
                            var offset = row | 0;
                            var m = this._matrix;
                            vector3D.x = m[offset];
                            vector3D.y = m[offset + 4];
                            vector3D.z = m[offset + 8];
                            vector3D.w = m[offset + 12];
                        };
                        Matrix3D.prototype.copyColumnTo = function (column /*uint*/, vector3D) {
                            column = column >>> 0;
                            vector3D = vector3D;
                            var offset = column << 2;
                            var m = this._matrix;
                            vector3D.x = m[offset];
                            vector3D.y = m[offset + 1];
                            vector3D.z = m[offset + 2];
                            vector3D.w = m[offset + 3];
                        };
                        Matrix3D.prototype.copyRowFrom = function (row /*uint*/, vector3D) {
                            row = row >>> 0;
                            vector3D = vector3D;
                            var offset = row | 0;
                            var m = this._matrix;
                            m[offset] = vector3D.x;
                            m[offset + 4] = vector3D.y;
                            m[offset + 8] = vector3D.z;
                            m[offset + 12] = vector3D.w;
                        };
                        Matrix3D.prototype.copyColumnFrom = function (column /*uint*/, vector3D) {
                            column = column >>> 0;
                            vector3D = vector3D;
                            var offset = column << 2;
                            var m = this._matrix;
                            m[offset] = vector3D.x;
                            m[offset + 1] = vector3D.y;
                            m[offset + 2] = vector3D.z;
                            m[offset + 3] = vector3D.w;
                        };
                        Matrix3D.classInitializer = null;
                        return Matrix3D;
                    })(AS.ASObject);
                    geom.Matrix3D = Matrix3D;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Orientation3D
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var Orientation3D = (function (_super) {
                        __extends(Orientation3D, _super);
                        function Orientation3D() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        Orientation3D.classInitializer = null;
                        // List of static symbols to link.
                        Orientation3D.classSymbols = null; // [];
                        // List of instance symbols to link.
                        Orientation3D.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        Orientation3D.EULER_ANGLES = "eulerAngles";
                        Orientation3D.AXIS_ANGLE = "axisAngle";
                        Orientation3D.QUATERNION = "quaternion";
                        return Orientation3D;
                    })(AS.ASObject);
                    geom.Orientation3D = Orientation3D;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: PerspectiveProjection
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var PerspectiveProjection = (function (_super) {
                        __extends(PerspectiveProjection, _super);
                        function PerspectiveProjection() {
                            _super.call(this);
                            this._fieldOfView = 55 /* FOV */;
                            this._centerX = 250 /* CenterX */;
                            this._centerY = 250 /* CenterY */;
                        }
                        PerspectiveProjection.FromDisplayObject = function (displayObject) {
                            release || Shumway.Debug.assert(displayObject);
                            var projection = this.axConstruct();
                            projection._displayObject = displayObject;
                            return projection;
                        };
                        Object.defineProperty(PerspectiveProjection.prototype, "fieldOfView", {
                            get: function () {
                                release || somewhatImplemented("public flash.geom.PerspectiveProjection::get fieldOfView");
                                return this._displayObject ?
                                    this._displayObject._perspectiveProjectionFOV :
                                    this._fieldOfView;
                            },
                            set: function (fieldOfViewAngleInDegrees) {
                                fieldOfViewAngleInDegrees = +fieldOfViewAngleInDegrees;
                                release || somewhatImplemented("public flash.geom.PerspectiveProjection::set fieldOfView");
                                if (this._displayObject) {
                                    this._displayObject._perspectiveProjectionFOV = fieldOfViewAngleInDegrees;
                                }
                                else {
                                    this._fieldOfView = fieldOfViewAngleInDegrees;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(PerspectiveProjection.prototype, "projectionCenter", {
                            get: function () {
                                release || somewhatImplemented("public flash.geom.PerspectiveProjection::get projectionCenter");
                                var centerX;
                                var centerY;
                                if (this._displayObject) {
                                    centerX = this._displayObject._perspectiveProjectionCenterX;
                                    centerY = this._displayObject._perspectiveProjectionCenterY;
                                }
                                else {
                                    centerX = this._centerX;
                                    centerY = this._centerY;
                                }
                                return new this.sec.flash.geom.Point(centerX, centerY);
                            },
                            set: function (p) {
                                release || somewhatImplemented("public flash.geom.PerspectiveProjection::set projectionCenter");
                                if (this._displayObject) {
                                    this._displayObject._perspectiveProjectionCenterX = +p.x;
                                    this._displayObject._perspectiveProjectionCenterY = +p.y;
                                }
                                else {
                                    this._centerX = +p.x;
                                    this._centerY = +p.y;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(PerspectiveProjection.prototype, "focalLength", {
                            get: function () {
                                release || somewhatImplemented("public flash.geom.PerspectiveProjection::get focalLength");
                                var fov;
                                var centerX;
                                if (this._displayObject) {
                                    fov = this._displayObject._perspectiveProjectionFOV;
                                    centerX = this._displayObject._perspectiveProjectionCenterX;
                                }
                                else {
                                    fov = this._fieldOfView;
                                    centerX = this._centerX;
                                }
                                return 1 / Math.tan(fov * Math.PI / 180 / 2) * centerX;
                            },
                            set: function (value) {
                                value = +value;
                                release || somewhatImplemented("public flash.geom.PerspectiveProjection::set focalLength");
                                var centerX = this._displayObject ?
                                    this._displayObject._perspectiveProjectionCenterX :
                                    this._centerX;
                                var fov = 2 * Math.atan(centerX / value);
                                if (this._displayObject) {
                                    this._displayObject._perspectiveProjectionFOV = fov;
                                }
                                else {
                                    this._fieldOfView = fov;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        PerspectiveProjection.prototype.toMatrix3D = function () {
                            release || somewhatImplemented("public flash.geom.PerspectiveProjection::toMatrix3D");
                            return new this.sec.flash.geom.Matrix3D();
                        };
                        PerspectiveProjection.prototype.clone = function () {
                            var clone = Object.create(this.axClass.tPrototype);
                            clone._fieldOfView = this._fieldOfView;
                            clone._centerX = this._centerX;
                            clone._centerY = this._centerY;
                            clone._displayObject = this._displayObject;
                            return clone;
                        };
                        PerspectiveProjection.classInitializer = null;
                        return PerspectiveProjection;
                    })(AS.ASObject);
                    geom.PerspectiveProjection = PerspectiveProjection;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Point
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var Point = (function (_super) {
                        __extends(Point, _super);
                        function Point(x, y) {
                            if (x === void 0) { x = 0; }
                            if (y === void 0) { y = 0; }
                            _super.call(this);
                            this.x = +x;
                            this.y = +y;
                        }
                        Object.defineProperty(Point.prototype, "native_x", {
                            get: function () {
                                return this.x;
                            },
                            set: function (x) {
                                this.x = x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Point.prototype, "native_y", {
                            get: function () {
                                return this.y;
                            },
                            set: function (y) {
                                this.y = y;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Point.prototype.Point = function (x, y) {
                            if (x === void 0) { x = 0; }
                            if (y === void 0) { y = 0; }
                            this.x = x;
                            this.y = y;
                        };
                        Object.defineProperty(Point.prototype, "length", {
                            get: function () {
                                return Math.sqrt(this.x * this.x + this.y * this.y);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Point.interpolate = function (p1, p2, f) {
                            var f1 = 1 - f;
                            return new this.sec.flash.geom.Point(p1.x * f + p2.x * f1, p1.y * f + p2.y * f1);
                        };
                        Point.distance = function (p1, p2) {
                            var dx = p2.x - p1.x;
                            var dy = p2.y - p1.y;
                            return (dx === 0) ? Math.abs(dy) : (dy === 0) ? Math.abs(dx) : Math.sqrt(dx * dx + dy * dy);
                        };
                        Point.polar = function (length, angle) {
                            length = +length;
                            angle = +angle;
                            return new this.sec.flash.geom.Point(length * Math.cos(angle), length * Math.sin(angle));
                        };
                        Point.prototype.clone = function () {
                            return new this.sec.flash.geom.Point(this.x, this.y);
                        };
                        Point.prototype.offset = function (dx, dy) {
                            this.x += +dx;
                            this.y += +dy;
                        };
                        Point.prototype.equals = function (toCompare) {
                            return this.x === toCompare.x && this.y === toCompare.y;
                        };
                        Point.prototype.subtract = function (v) {
                            return new this.sec.flash.geom.Point(this.x - v.x, this.y - v.y);
                        };
                        Point.prototype.add = function (v) {
                            return new this.sec.flash.geom.Point(this.x + v.x, this.y + v.y);
                        };
                        Point.prototype.normalize = function (thickness) {
                            if (this.x !== 0 || this.y !== 0) {
                                var relativeThickness = +thickness / this.length;
                                this.x *= relativeThickness;
                                this.y *= relativeThickness;
                            }
                        };
                        Point.prototype.copyFrom = function (sourcePoint) {
                            this.x = sourcePoint.x;
                            this.y = sourcePoint.y;
                        };
                        Point.prototype.setTo = function (x, y) {
                            this.x = +x;
                            this.y = +y;
                        };
                        Point.prototype.toTwips = function () {
                            this.x = (this.x * 20) | 0;
                            this.y = (this.y * 20) | 0;
                            return this;
                        };
                        Point.prototype.toPixels = function () {
                            this.x /= 20;
                            this.y /= 20;
                            return this;
                        };
                        Point.prototype.round = function () {
                            this.x = Math.round(this.x);
                            this.y = Math.round(this.y);
                            return this;
                        };
                        Point.prototype.toString = function () {
                            return "(x=" + this.x + ", y=" + this.y + ")";
                        };
                        // Called whenever the class is initialized.
                        Point.classInitializer = null;
                        // List of static symbols to link.
                        Point.classSymbols = null; // ["interpolate", "distance", "polar"];
                        // List of instance symbols to link.
                        Point.instanceSymbols = null; // ["x", "y", "length", "clone", "offset", "equals", "subtract", "add", "normalize", "copyFrom", "setTo", "toString"];
                        return Point;
                    })(AS.ASObject);
                    geom.Point = Point;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Rectangle
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var Rectangle = (function (_super) {
                        __extends(Rectangle, _super);
                        function Rectangle(x, y, width, height) {
                            if (x === void 0) { x = 0; }
                            if (y === void 0) { y = 0; }
                            if (width === void 0) { width = 0; }
                            if (height === void 0) { height = 0; }
                            _super.call(this);
                            x = +x;
                            y = +y;
                            width = +width;
                            height = +height;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                        }
                        Rectangle.FromBounds = function (bounds) {
                            var xMin = bounds.xMin;
                            var yMin = bounds.yMin;
                            return new this.sec.flash.geom.Rectangle(xMin / 20, yMin / 20, (bounds.xMax - xMin) / 20, (bounds.yMax - yMin) / 20);
                        };
                        Object.defineProperty(Rectangle.prototype, "native_x", {
                            get: function () {
                                return this.x;
                            },
                            set: function (x) {
                                this.x = x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "native_y", {
                            get: function () {
                                return this.y;
                            },
                            set: function (y) {
                                this.y = y;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "native_width", {
                            get: function () {
                                return this.width;
                            },
                            set: function (width) {
                                this.width = +width;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "native_height", {
                            get: function () {
                                return this.height;
                            },
                            set: function (height) {
                                this.height = +height;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "left", {
                            get: function () {
                                return this.x;
                            },
                            set: function (value) {
                                value = +value;
                                this.width += this.x - value;
                                this.x = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "right", {
                            get: function () {
                                return this.x + this.width;
                            },
                            set: function (value) {
                                value = +value;
                                this.width = value - this.x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "top", {
                            get: function () {
                                return this.y;
                            },
                            set: function (value) {
                                value = +value;
                                this.height += this.y - value;
                                this.y = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "bottom", {
                            get: function () {
                                return this.y + this.height;
                            },
                            set: function (value) {
                                value = +value;
                                this.height = value - this.y;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "topLeft", {
                            get: function () {
                                return new this.sec.flash.geom.Point(this.left, this.top);
                            },
                            set: function (value) {
                                this.top = value.y;
                                this.left = value.x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "bottomRight", {
                            get: function () {
                                return new this.sec.flash.geom.Point(this.right, this.bottom);
                            },
                            set: function (value) {
                                this.bottom = value.y;
                                this.right = value.x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "size", {
                            get: function () {
                                return new this.sec.flash.geom.Point(this.width, this.height);
                            },
                            set: function (value) {
                                this.width = value.x;
                                this.height = value.y;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Rectangle.prototype, "area", {
                            get: function () {
                                return this.width * this.height;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Rectangle.prototype.clone = function () {
                            return new this.sec.flash.geom.Rectangle(this.x, this.y, this.width, this.height);
                        };
                        Rectangle.prototype.isEmpty = function () {
                            return this.width <= 0 || this.height <= 0;
                        };
                        Rectangle.prototype.setEmpty = function () {
                            this.x = 0;
                            this.y = 0;
                            this.width = 0;
                            this.height = 0;
                            return this;
                        };
                        Rectangle.prototype.inflate = function (dx, dy) {
                            dx = +dx;
                            dy = +dy;
                            this.x -= dx;
                            this.y -= dy;
                            this.width += (dx * 2);
                            this.height += (dy * 2);
                        };
                        Rectangle.prototype.inflatePoint = function (point) {
                            this.inflate(point.x, point.y);
                        };
                        Rectangle.prototype.offset = function (dx, dy) {
                            this.x += +dx;
                            this.y += +dy;
                        };
                        Rectangle.prototype.offsetPoint = function (point) {
                            this.offset(point.x, point.y);
                        };
                        Rectangle.prototype.contains = function (x, y) {
                            x = +x;
                            y = +y;
                            return x >= this.x && x < this.right &&
                                y >= this.y && y < this.bottom;
                        };
                        Rectangle.prototype.containsPoint = function (point) {
                            return this.contains(point.x, point.y);
                        };
                        Rectangle.prototype.containsRect = function (rect) {
                            var r1 = rect.x + rect.width;
                            var b1 = rect.y + rect.height;
                            var r2 = this.x + this.width;
                            var b2 = this.y + this.height;
                            return (rect.x >= this.x) &&
                                (rect.x < r2) &&
                                (rect.y >= this.y) &&
                                (rect.y < b2) &&
                                (r1 > this.x) &&
                                (r1 <= r2) &&
                                (b1 > this.y) &&
                                (b1 <= b2);
                        };
                        Rectangle.prototype.intersection = function (toIntersect) {
                            return this.clone().intersectInPlace(toIntersect);
                        };
                        Rectangle.prototype.intersects = function (toIntersect) {
                            return Math.max(this.x, toIntersect.x) <= Math.min(this.right, toIntersect.right) &&
                                Math.max(this.y, toIntersect.y) <= Math.min(this.bottom, toIntersect.bottom);
                        };
                        Rectangle.prototype.intersectInPlace = function (clipRect) {
                            var x0 = this.x;
                            var y0 = this.y;
                            var x1 = clipRect.x;
                            var y1 = clipRect.y;
                            var l = Math.max(x0, x1);
                            var r = Math.min(x0 + this.width, x1 + clipRect.width);
                            if (l <= r) {
                                var t = Math.max(y0, y1);
                                var b = Math.min(y0 + this.height, y1 + clipRect.height);
                                if (t <= b) {
                                    this.setTo(l, t, r - l, b - t);
                                    return this;
                                }
                            }
                            this.setEmpty();
                            return this;
                        };
                        Rectangle.prototype.intersectInPlaceInt32 = function (clipRect) {
                            var x0 = this.x | 0;
                            var y0 = this.y | 0;
                            var w0 = this.width | 0;
                            var h0 = this.height | 0;
                            var x1 = clipRect.x | 0;
                            var w1 = clipRect.width | 0;
                            var l = Math.max(x0, x1) | 0;
                            var r = Math.min(x0 + w0 | 0, x1 + w1 | 0) | 0;
                            if (l <= r) {
                                var y1 = clipRect.y | 0;
                                var h1 = clipRect.height | 0;
                                var t = Math.max(y0, y1) | 0;
                                var b = Math.min(y0 + h0 | 0, y1 + h1 | 0);
                                if (t <= b) {
                                    this.setTo(l, t, r - l, b - t);
                                    return this;
                                }
                            }
                            this.setEmpty();
                            return this;
                        };
                        Rectangle.prototype.union = function (toUnion) {
                            return this.clone().unionInPlace(toUnion);
                        };
                        Rectangle.prototype.unionInPlace = function (toUnion) {
                            if (toUnion.isEmpty()) {
                                return this;
                            }
                            if (this.isEmpty()) {
                                this.copyFrom(toUnion);
                                return this;
                            }
                            var l = Math.min(this.x, toUnion.x);
                            var t = Math.min(this.y, toUnion.y);
                            this.setTo(l, t, Math.max(this.right, toUnion.right) - l, Math.max(this.bottom, toUnion.bottom) - t);
                            return this;
                        };
                        Rectangle.prototype.equals = function (toCompare) {
                            return this === toCompare ||
                                this.x === toCompare.x && this.y === toCompare.y
                                    && this.width === toCompare.width && this.height === toCompare.height;
                        };
                        Rectangle.prototype.copyFrom = function (sourceRect) {
                            this.x = sourceRect.x;
                            this.y = sourceRect.y;
                            this.width = sourceRect.width;
                            this.height = sourceRect.height;
                        };
                        Rectangle.prototype.setTo = function (x, y, width, height) {
                            this.x = +x;
                            this.y = +y;
                            this.width = +width;
                            this.height = +height;
                        };
                        Rectangle.prototype.toTwips = function () {
                            this.x = (this.x * 20) | 0;
                            this.y = (this.y * 20) | 0;
                            this.width = (this.width * 20) | 0;
                            this.height = (this.height * 20) | 0;
                            return this;
                        };
                        Rectangle.prototype.getBaseWidth = function (angle) {
                            var u = Math.abs(Math.cos(angle));
                            var v = Math.abs(Math.sin(angle));
                            return u * this.width + v * this.height;
                        };
                        Rectangle.prototype.getBaseHeight = function (angle) {
                            var u = Math.abs(Math.cos(angle));
                            var v = Math.abs(Math.sin(angle));
                            return v * this.width + u * this.height;
                        };
                        Rectangle.prototype.toPixels = function () {
                            this.x /= 20;
                            this.y /= 20;
                            this.width /= 20;
                            this.height /= 20;
                            return this;
                        };
                        Rectangle.prototype.snapInPlace = function () {
                            var x1 = Math.ceil(this.x + this.width);
                            var y1 = Math.ceil(this.y + this.height);
                            this.x = Math.floor(this.x);
                            this.y = Math.floor(this.y);
                            this.width = x1 - this.x;
                            this.height = y1 - this.y;
                            return this;
                        };
                        Rectangle.prototype.roundInPlace = function () {
                            var x1 = Math.round(this.x + this.width);
                            var y1 = Math.round(this.y + this.height);
                            this.x = Math.round(this.x);
                            this.y = Math.round(this.y);
                            this.width = x1 - this.x;
                            this.height = y1 - this.y;
                            return this;
                        };
                        Rectangle.prototype.toString = function () {
                            return "(x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height + ")";
                        };
                        Rectangle.prototype.hashCode = function () {
                            var hash = 0;
                            hash += this.x * 20 | 0;
                            hash *= 37;
                            hash += this.y * 20 | 0;
                            hash *= 37;
                            hash += this.width * 20 | 0;
                            hash *= 37;
                            hash += this.height * 20 | 0;
                            return hash;
                        };
                        Rectangle.prototype.writeExternal = function (output) {
                            output.writeFloat(this.x);
                            output.writeFloat(this.y);
                            output.writeFloat(this.width);
                            output.writeFloat(this.height);
                        };
                        Rectangle.prototype.readExternal = function (input) {
                            this.x = input.readFloat();
                            this.y = input.readFloat();
                            this.width = input.readFloat();
                            this.height = input.readFloat();
                        };
                        // Called whenever the class is initialized.
                        Rectangle.classInitializer = null;
                        // List of static symbols to link.
                        Rectangle.classSymbols = null; // [];
                        // List of instance symbols to link.
                        Rectangle.instanceSymbols = null;
                        return Rectangle;
                    })(AS.ASObject);
                    geom.Rectangle = Rectangle;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Transform
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var checkNullParameter = Shumway.AVMX.checkNullParameter;
                    var Transform = (function (_super) {
                        __extends(Transform, _super);
                        function Transform(displayObject) {
                            _super.call(this);
                            if (!displayObject) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.NullPointerError, "displayObject");
                            }
                            this._displayObject = displayObject;
                        }
                        Object.defineProperty(Transform.prototype, "matrix", {
                            get: function () {
                                if (this._displayObject._matrix3D) {
                                    return null;
                                }
                                return this._displayObject._getMatrix().clone().toPixelsInPlace();
                            },
                            set: function (value) {
                                if (this._displayObject._matrix3D) {
                                    this._displayObject._matrix3D.resetTargetDisplayObject();
                                    this._displayObject._matrix3D = null;
                                }
                                this._displayObject._setMatrix(value, true);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Transform.prototype, "colorTransform", {
                            get: function () {
                                return this._displayObject._colorTransform.clone();
                            },
                            set: function (value) {
                                this._displayObject._setColorTransform(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Transform.prototype, "concatenatedMatrix", {
                            get: function () {
                                var matrix = this._displayObject._getConcatenatedMatrix().clone().toPixelsInPlace();
                                // For some reason, all dimensions are scale 5x for off-stage objects.
                                if (!this._displayObject._stage) {
                                    matrix.scale(5, 5);
                                }
                                return matrix;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Transform.prototype, "concatenatedColorTransform", {
                            get: function () {
                                return this._displayObject._getConcatenatedColorTransform();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Transform.prototype, "pixelBounds", {
                            get: function () {
                                // Only somewhat implemented because this is largely untested.
                                release || somewhatImplemented("public flash.geom.Transform::get pixelBounds");
                                var stage = this._displayObject.stage;
                                var targetCoordinateSpace = stage || this._displayObject;
                                var rect = this._displayObject.getRect(targetCoordinateSpace);
                                // For some reason, all dimensions are scale 5x for off-stage objects.
                                if (!stage) {
                                    rect.width *= 5;
                                    rect.height *= 5;
                                }
                                return rect;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Transform.prototype, "matrix3D", {
                            get: function () {
                                release || somewhatImplemented("public flash.geom.Transform::get matrix3D");
                                // Note: matrix3D returns the original object, *not* a clone.
                                return this._displayObject._matrix3D;
                            },
                            set: function (m) {
                                if (!(this.sec.flash.geom.Matrix3D.axIsType(m))) {
                                    this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, m, 'flash.geom.Matrix3D');
                                }
                                release || somewhatImplemented("public flash.geom.Transform::set matrix3D");
                                // Setting the displayObject on the matrix can throw an error, so do that first.
                                m.setTargetDisplayObject(this._displayObject);
                                // Note: matrix3D stores the original object, *not* a clone.
                                this._displayObject._matrix3D = m;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Transform.prototype.getRelativeMatrix3D = function (relativeTo) {
                            checkNullParameter(relativeTo, "relativeTo", this.sec);
                            release || somewhatImplemented("public flash.geom.Transform::getRelativeMatrix3D");
                            var matrix3D = this._displayObject._matrix3D;
                            // TODO: actually calculate the relative matrix.
                            return matrix3D ? matrix3D.clone() : null;
                        };
                        Object.defineProperty(Transform.prototype, "perspectiveProjection", {
                            get: function () {
                                release || somewhatImplemented("public flash.geom.Transform::get perspectiveProjection");
                                if (!this._displayObject._hasFlags(262144 /* HasPerspectiveProjection */)) {
                                    return null;
                                }
                                var PerspectiveProjectionClass = this.sec.flash.geom.PerspectiveProjection.axClass;
                                return PerspectiveProjectionClass.FromDisplayObject(this._displayObject);
                            },
                            set: function (projection) {
                                release || somewhatImplemented("public flash.geom.Transform::set perspectiveProjection");
                                if (!projection) {
                                    this._displayObject._removeFlags(262144 /* HasPerspectiveProjection */);
                                    return;
                                }
                                this._displayObject._setFlags(262144 /* HasPerspectiveProjection */);
                                this._displayObject._perspectiveProjectionCenterX = +projection._centerX;
                                this._displayObject._perspectiveProjectionCenterY = +projection._centerY;
                                this._displayObject._perspectiveProjectionFOV = +projection._fieldOfView;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Transform.classInitializer = null;
                        return Transform;
                    })(AS.ASObject);
                    geom.Transform = Transform;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Utils3D
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var Utils3D = (function (_super) {
                        __extends(Utils3D, _super);
                        function Utils3D() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        Utils3D.projectVector = function (m, v) {
                            m = m;
                            v = v;
                            release || notImplemented("public flash.geom.Utils3D::static projectVector");
                            return;
                        };
                        Utils3D.projectVectors = function (m, verts, projectedVerts, uvts) {
                            m = m;
                            verts = verts;
                            projectedVerts = projectedVerts;
                            uvts = uvts;
                            release || notImplemented("public flash.geom.Utils3D::static projectVectors");
                            return;
                        };
                        Utils3D.pointTowards = function (percent, mat, pos, at, up) {
                            if (at === void 0) { at = null; }
                            if (up === void 0) { up = null; }
                            percent = +percent;
                            mat = mat;
                            pos = pos;
                            at = at;
                            up = up;
                            release || notImplemented("public flash.geom.Utils3D::static pointTowards");
                            return;
                        };
                        // Called whenever the class is initialized.
                        Utils3D.classInitializer = null;
                        // List of static symbols to link.
                        Utils3D.classSymbols = null; // [];
                        // List of instance symbols to link.
                        Utils3D.instanceSymbols = null; // [];
                        return Utils3D;
                    })(AS.ASObject);
                    geom.Utils3D = Utils3D;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Vector3D
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var geom;
                (function (geom) {
                    var Vector3D = (function (_super) {
                        __extends(Vector3D, _super);
                        function Vector3D(x, y, z, w) {
                            if (x === void 0) { x = 0; }
                            if (y === void 0) { y = 0; }
                            if (z === void 0) { z = 0; }
                            if (w === void 0) { w = 0; }
                            _super.call(this);
                            this.x = +x;
                            this.y = +y;
                            this.z = +z;
                            this.w = +w;
                        }
                        Vector3D.classInitializer = function () {
                            this.X_AXIS = Object.freeze(this.Create(1, 0, 0, 0));
                            this.Y_AXIS = Object.freeze(this.Create(1, 0, 0, 0));
                            this.Z_AXIS = Object.freeze(this.Create(1, 0, 0, 0));
                        };
                        Vector3D.Create = function (x, y, z, w) {
                            var v = Object.create(this.tPrototype);
                            v.x = x;
                            v.y = y;
                            v.z = z;
                            v.w = w;
                            return v;
                        };
                        Object.defineProperty(Vector3D.prototype, "native_x", {
                            get: function () {
                                return this.x;
                            },
                            set: function (x) {
                                this.x = x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Vector3D.prototype, "native_y", {
                            get: function () {
                                return this.y;
                            },
                            set: function (y) {
                                this.y = y;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Vector3D.prototype, "native_z", {
                            get: function () {
                                return this.z;
                            },
                            set: function (z) {
                                this.z = z;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Vector3D.prototype, "native_w", {
                            get: function () {
                                return this.w;
                            },
                            set: function (w) {
                                this.w = w;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Vector3D.prototype, "length", {
                            get: function () {
                                return Math.sqrt(this.lengthSquared);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Vector3D.prototype, "lengthSquared", {
                            get: function () {
                                return this.x * this.x +
                                    this.y * this.y +
                                    this.z * this.z;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Vector3D.angleBetween = function (a, b) {
                            // http://chemistry.about.com/od/workedchemistryproblems/a/scalar-product-vectors-problem.htm
                            return Math.acos(a.dotProduct(b) / (a.length * b.length));
                        };
                        Vector3D.distance = function (pt1, pt2) {
                            // http://en.wikipedia.org/wiki/Euclidean_distance#Three_dimensions
                            return pt1.subtract(pt2).length;
                        };
                        Vector3D.prototype.dotProduct = function (a) {
                            return this.x * a.x +
                                this.y * a.y +
                                this.z * a.z;
                        };
                        Vector3D.prototype.crossProduct = function (a) {
                            return new this.sec.flash.geom.Vector3D(this.y * a.z - this.z * a.y, this.z * a.x - this.x * a.z, this.x * a.y - this.y * a.x, 1.0);
                        };
                        Vector3D.prototype.normalize = function () {
                            var length = this.length;
                            if (length !== 0) {
                                this.x /= length;
                                this.y /= length;
                                this.z /= length;
                            }
                            else {
                                this.x = this.y = this.z = 0;
                            }
                            return length;
                        };
                        Vector3D.prototype.scaleBy = function (s) {
                            s = +s;
                            this.x *= s;
                            this.y *= s;
                            this.z *= s;
                        };
                        Vector3D.prototype.incrementBy = function (a) {
                            this.x += a.x;
                            this.y += a.y;
                            this.z += a.z;
                        };
                        Vector3D.prototype.decrementBy = function (a) {
                            this.x -= a.x;
                            this.y -= a.y;
                            this.z -= a.z;
                        };
                        Vector3D.prototype.add = function (a) {
                            return new this.sec.flash.geom.Vector3D(this.x + a.x, this.y + a.y, this.z + a.z);
                        };
                        Vector3D.prototype.subtract = function (a) {
                            return new this.sec.flash.geom.Vector3D(this.x - a.x, this.y - a.y, this.z - a.z);
                        };
                        Vector3D.prototype.negate = function () {
                            this.x = -this.x;
                            this.y = -this.y;
                            this.z = -this.z;
                        };
                        Vector3D.prototype.equals = function (toCompare, allFour) {
                            return (this.x === toCompare.x)
                                && (this.y === toCompare.y)
                                && (this.z === toCompare.z)
                                && (!allFour || (this.w === toCompare.w));
                        };
                        Vector3D.prototype.nearEquals = function (toCompare, tolerance, allFour) {
                            return (Math.abs(this.x - toCompare.x) < tolerance)
                                && (Math.abs(this.y - toCompare.y) < tolerance)
                                && (Math.abs(this.z - toCompare.z) < tolerance)
                                && (!allFour || (Math.abs(this.w - toCompare.w) < tolerance));
                        };
                        Vector3D.prototype.project = function () {
                            this.x /= this.w;
                            this.y /= this.w;
                            this.z /= this.w;
                        };
                        Vector3D.prototype.copyFrom = function (sourceVector3D) {
                            this.x = sourceVector3D.x;
                            this.y = sourceVector3D.y;
                            this.z = sourceVector3D.z;
                        };
                        Vector3D.prototype.setTo = function (xa, ya, za) {
                            this.x = +xa;
                            this.y = +ya;
                            this.z = +za;
                        };
                        Vector3D.prototype.clone = function () {
                            return new this.sec.flash.geom.Vector3D(this.x, this.y, this.z, this.w);
                        };
                        Vector3D.prototype.toString = function () {
                            return "Vector3D(" + this.x + ", " + this.y + ", " + this.z + ")";
                        };
                        return Vector3D;
                    })(AS.ASObject);
                    geom.Vector3D = Vector3D;
                })(geom = flash.geom || (flash.geom = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Accessibility
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var accessibility;
                (function (accessibility) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var Accessibility = (function (_super) {
                        __extends(Accessibility, _super);
                        function Accessibility() {
                            _super.call(this);
                        }
                        Object.defineProperty(Accessibility, "active", {
                            get: function () {
                                release || somewhatImplemented("public flash.accessibility.Accessibility::get active");
                                return Accessibility._active;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Accessibility.sendEvent = function (source, childID /*uint*/, eventType /*uint*/, nonHTML) {
                            if (nonHTML === void 0) { nonHTML = false; }
                            source = source;
                            childID = childID >>> 0;
                            eventType = eventType >>> 0;
                            nonHTML = !!nonHTML;
                            release || release || notImplemented("public flash.accessibility.Accessibility::static sendEvent");
                            return;
                        };
                        Accessibility.updateProperties = function () {
                            release || release || notImplemented("public flash.accessibility.Accessibility::static updateProperties");
                            return;
                        };
                        // Called whenever the class is initialized.
                        Accessibility.classInitializer = null;
                        // List of static symbols to link.
                        Accessibility.classSymbols = null; // [];
                        // List of instance symbols to link.
                        Accessibility.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        // AS -> JS Bindings
                        Accessibility._active = false;
                        return Accessibility;
                    })(AS.ASObject);
                    accessibility.Accessibility = Accessibility;
                })(accessibility = flash.accessibility || (flash.accessibility = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: AccessibilityImplementation
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var accessibility;
                (function (accessibility) {
                    var AccessibilityImplementation = (function (_super) {
                        __extends(AccessibilityImplementation, _super);
                        function AccessibilityImplementation() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        AccessibilityImplementation.classInitializer = null;
                        // List of static symbols to link.
                        AccessibilityImplementation.classSymbols = null; // [];
                        // List of instance symbols to link.
                        AccessibilityImplementation.instanceSymbols = null; // ["stub", "errno", "get_accRole", "get_accName", "get_accValue", "get_accState", "get_accDefaultAction", "accDoDefaultAction", "isLabeledBy", "getChildIDArray", "accLocation", "get_accSelection", "get_accFocus", "accSelect", "get_selectionAnchorIndex", "get_selectionActiveIndex"];
                        return AccessibilityImplementation;
                    })(AS.ASObject);
                    accessibility.AccessibilityImplementation = AccessibilityImplementation;
                })(accessibility = flash.accessibility || (flash.accessibility = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: AccessibilityProperties
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var accessibility;
                (function (accessibility) {
                    var AccessibilityProperties = (function (_super) {
                        __extends(AccessibilityProperties, _super);
                        function AccessibilityProperties() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        AccessibilityProperties.classInitializer = null;
                        // List of static symbols to link.
                        AccessibilityProperties.classSymbols = null; // [];
                        // List of instance symbols to link.
                        AccessibilityProperties.instanceSymbols = null; // ["name", "description", "shortcut", "silent", "forceSimple", "noAutoLabeling"];
                        return AccessibilityProperties;
                    })(AS.ASObject);
                    accessibility.AccessibilityProperties = AccessibilityProperties;
                })(accessibility = flash.accessibility || (flash.accessibility = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Event
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var assert = Shumway.Debug.assert;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var Event = (function (_super) {
                        __extends(Event, _super);
                        function Event(type, bubbles, cancelable) {
                            _super.call(this);
                            this._type = axCoerceString(type);
                            this._bubbles = !!bubbles;
                            this._cancelable = !!cancelable;
                            this._target = null;
                            this._currentTarget = null;
                            this._eventPhase = events.EventPhase.AT_TARGET;
                            this._stopPropagation = false;
                            this._stopImmediatePropagation = false;
                            this._isDefaultPrevented = false;
                        }
                        Event.getInstance = function (type, bubbles, cancelable) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            var instance = this._instances[type];
                            if (!instance) {
                                instance = new this.sec.flash.events.Event(type, bubbles, cancelable);
                                this._instances[type] = instance;
                            }
                            instance._bubbles = bubbles;
                            instance._cancelable = cancelable;
                            return instance;
                        };
                        Event.getBroadcastInstance = function (type, bubbles, cancelable) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            var instance = this._instances[type];
                            if (!instance) {
                                instance = new this.sec.flash.events.Event(type, bubbles, cancelable);
                                this._instances[type] = instance;
                                // Some events are documented as broadcast event in the AS3 docs. We can't set |_isBroadcastEvent| flag in the
                                // constructor because if you create custom events with these types they do capture and bubble.
                                release || assert(Event.isBroadcastEventType(type));
                            }
                            instance._isBroadcastEvent = true;
                            instance._bubbles = bubbles;
                            instance._cancelable = cancelable;
                            return instance;
                        };
                        /**
                         * http://stackoverflow.com/questions/16900176/as3enterframe-event-propagation-understanding-issue
                         */
                        Event.isBroadcastEventType = function (type) {
                            switch (type) {
                                case Event.ENTER_FRAME:
                                case Event.EXIT_FRAME:
                                case Event.FRAME_CONSTRUCTED:
                                case Event.RENDER:
                                case Event.ACTIVATE:
                                case Event.DEACTIVATE:
                                    return true;
                            }
                            return false;
                        };
                        Object.defineProperty(Event.prototype, "type", {
                            get: function () {
                                return this._type;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Event.prototype, "bubbles", {
                            get: function () {
                                return this._bubbles;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Event.prototype, "cancelable", {
                            get: function () {
                                return this._cancelable;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Event.prototype, "target", {
                            get: function () {
                                return this._target;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Event.prototype, "currentTarget", {
                            get: function () {
                                return this._currentTarget;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Event.prototype, "eventPhase", {
                            get: function () {
                                return this._eventPhase;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Event.prototype.stopPropagation = function () {
                            this._stopPropagation = true;
                        };
                        Event.prototype.stopImmediatePropagation = function () {
                            this._stopImmediatePropagation = this._stopPropagation = true;
                        };
                        Event.prototype.preventDefault = function () {
                            if (this._cancelable) {
                                this._isDefaultPrevented = true;
                            }
                        };
                        Event.prototype.isDefaultPrevented = function () {
                            return this._isDefaultPrevented;
                        };
                        Event.prototype.isBroadcastEvent = function () {
                            return !!this._isBroadcastEvent;
                        };
                        Event.prototype.clone = function () {
                            return new this.sec.flash.events.Event(this._type, this._bubbles, this._cancelable);
                        };
                        Event.prototype.toString = function () {
                            return this.formatToString('Event', 'type', 'bubbles', 'cancelable', 'eventPhase');
                        };
                        Event.prototype.formatToString = function (className) {
                            var args = [];
                            for (var _i = 1; _i < arguments.length; _i++) {
                                args[_i - 1] = arguments[_i];
                            }
                            var str = '[' + className;
                            for (var i = 0; i < args.length; i++) {
                                var field = args[i];
                                var value = this.axGetPublicProperty(field);
                                if (typeof value === 'string') {
                                    value = '"' + value + '"';
                                }
                                str += ' ' + field + '=' + value;
                            }
                            return str + ']';
                        };
                        Event.classInitializer = function () {
                            var self = this;
                            self._instances = Shumway.ObjectUtilities.createMap();
                        };
                        // JS -> AS Bindings
                        Event.ACTIVATE = "activate";
                        Event.ADDED = "added";
                        Event.ADDED_TO_STAGE = "addedToStage";
                        Event.CANCEL = "cancel";
                        Event.CHANGE = "change";
                        Event.CLEAR = "clear";
                        Event.CLOSE = "close";
                        Event.COMPLETE = "complete";
                        Event.CONNECT = "connect";
                        Event.COPY = "copy";
                        Event.CUT = "cut";
                        Event.DEACTIVATE = "deactivate";
                        Event.ENTER_FRAME = "enterFrame";
                        Event.FRAME_CONSTRUCTED = "frameConstructed";
                        Event.EXIT_FRAME = "exitFrame";
                        Event.FRAME_LABEL = "frameLabel";
                        Event.ID3 = "id3";
                        Event.INIT = "init";
                        Event.MOUSE_LEAVE = "mouseLeave";
                        Event.OPEN = "open";
                        Event.PASTE = "paste";
                        Event.REMOVED = "removed";
                        Event.REMOVED_FROM_STAGE = "removedFromStage";
                        Event.RENDER = "render";
                        Event.RESIZE = "resize";
                        Event.SCROLL = "scroll";
                        Event.TEXT_INTERACTION_MODE_CHANGE = "textInteractionModeChange";
                        Event.SELECT = "select";
                        Event.SELECT_ALL = "selectAll";
                        Event.SOUND_COMPLETE = "soundComplete";
                        Event.TAB_CHILDREN_CHANGE = "tabChildrenChange";
                        Event.TAB_ENABLED_CHANGE = "tabEnabledChange";
                        Event.TAB_INDEX_CHANGE = "tabIndexChange";
                        Event.UNLOAD = "unload";
                        Event.FULLSCREEN = "fullScreen";
                        Event.CONTEXT3D_CREATE = "context3DCreate";
                        Event.TEXTURE_READY = "textureReady";
                        Event.VIDEO_FRAME = "videoFrame";
                        Event.SUSPEND = "suspend";
                        Event.AVM1_INIT = "initialize";
                        Event.AVM1_CONSTRUCT = "construct";
                        Event.AVM1_LOAD = "load";
                        return Event;
                    })(AS.ASObject);
                    events.Event = Event;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: EventDispatcher
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var isNullOrUndefined = Shumway.isNullOrUndefined;
                    var assert = Shumway.Debug.assert;
                    var EventListenerEntry = (function () {
                        function EventListenerEntry(listener, useCapture, priority) {
                            this.listener = listener;
                            this.useCapture = useCapture;
                            this.priority = priority;
                        }
                        return EventListenerEntry;
                    })();
                    /**
                     * Implements Copy-On-Write for event listener lists. Event handlers can add and/or remove
                     * event handlers while the events are processed. The easiest way to implement this is to
                     * clone the event listener list before executing the event listeners. This however can be
                     * wasteful, since most of the time, event handlers don't mutate the event list. Here we
                     * implement a simple copy-on-write strategy that clones the entry list if it's been
                     * snapshotted and it's about to be mutated.
                     */
                    var EventListenerList = (function () {
                        function EventListenerList() {
                            /**
                             * The number of times the current entry list has been aliased (or snapshotted).
                             */
                            this._aliasCount = 0;
                            this._entries = [];
                        }
                        EventListenerList.prototype.isEmpty = function () {
                            return this._entries.length === 0;
                        };
                        EventListenerList.prototype.insert = function (listener, useCapture, priority) {
                            var entries = this._entries;
                            var index = entries.length;
                            for (var i = index - 1; i >= 0; i--) {
                                var entry = entries[i];
                                if (entry.listener === listener) {
                                    return;
                                }
                                if (priority > entry.priority) {
                                    index = i;
                                }
                                else {
                                    break;
                                }
                            }
                            entries = this.ensureNonAliasedEntries();
                            entries.splice(index, 0, new EventListenerEntry(listener, useCapture, priority));
                        };
                        /**
                         * Make sure we get a fresh list if it's been aliased.
                         */
                        EventListenerList.prototype.ensureNonAliasedEntries = function () {
                            var entries = this._entries;
                            if (this._aliasCount > 0) {
                                entries = this._entries = entries.slice();
                                this._aliasCount = 0;
                            }
                            return entries;
                        };
                        EventListenerList.prototype.remove = function (listener) {
                            var entries = this._entries;
                            for (var i = 0; i < entries.length; i++) {
                                var item = entries[i];
                                if (item.listener === listener) {
                                    this.ensureNonAliasedEntries().splice(i, 1);
                                    return;
                                }
                            }
                        };
                        /**
                         * Get a snapshot of the current entry list.
                         */
                        EventListenerList.prototype.snapshot = function () {
                            this._aliasCount++;
                            return this._entries;
                        };
                        /**
                         * Release the snapshot, hopefully no other mutations occured so we can reuse the entry list.
                         */
                        EventListenerList.prototype.releaseSnapshot = function (snapshot) {
                            // We ignore any non current snapshots.
                            if (this._entries !== snapshot) {
                                return;
                            }
                            if (this._aliasCount > 0) {
                                this._aliasCount--;
                            }
                        };
                        return EventListenerList;
                    })();
                    /**
                     * Broadcast Events
                     *
                     * The logic here is pretty much copied from:
                     * http://www.senocular.com/flash/tutorials/orderofoperations/
                     */
                    var BroadcastEventDispatchQueue = (function () {
                        function BroadcastEventDispatchQueue() {
                            this.reset();
                        }
                        BroadcastEventDispatchQueue.prototype.reset = function () {
                            this._queues = Object.create(null);
                        };
                        BroadcastEventDispatchQueue.prototype.add = function (type, target) {
                            release || assert(events.Event.isBroadcastEventType(type), "Can only register broadcast events.");
                            var queue = this._queues[type] || (this._queues[type] = []);
                            if (queue.indexOf(target) >= 0) {
                                return;
                            }
                            queue.push(target);
                        };
                        BroadcastEventDispatchQueue.prototype.remove = function (type, target) {
                            release || assert(events.Event.isBroadcastEventType(type), "Can only unregister broadcast events.");
                            var queue = this._queues[type];
                            release || assert(queue, "There should already be a queue for this.");
                            var index = queue.indexOf(target);
                            release || assert(index >= 0, "Target should be somewhere in this queue.");
                            queue[index] = null;
                            release || assert(queue.indexOf(target) < 0, "Target shouldn't be in this queue anymore.");
                        };
                        BroadcastEventDispatchQueue.prototype.dispatchEvent = function (event) {
                            release || assert(event.isBroadcastEvent(), "Cannot dispatch non-broadcast events.");
                            var queue = this._queues[event._type];
                            if (!queue) {
                                return;
                            }
                            if (!release && AS.traceEventsOption.value) {
                                console.log('Broadcast event of type ' + event._type + ' to ' + queue.length +
                                    ' listeners');
                            }
                            var nullCount = 0;
                            for (var i = 0; i < queue.length; i++) {
                                var target = queue[i];
                                if (target === null) {
                                    nullCount++;
                                }
                                else {
                                    target.dispatchEvent(event);
                                }
                            }
                            // Compact the queue if there are too many holes in it.
                            if (nullCount > 16 && nullCount > (queue.length >> 1)) {
                                var compactedQueue = [];
                                for (var i = 0; i < queue.length; i++) {
                                    if (queue[i]) {
                                        compactedQueue.push(queue[i]);
                                    }
                                }
                                this._queues[event.type] = compactedQueue;
                            }
                        };
                        BroadcastEventDispatchQueue.prototype.getQueueLength = function (type) {
                            return this._queues[type] ? this._queues[type].length : 0;
                        };
                        return BroadcastEventDispatchQueue;
                    })();
                    events.BroadcastEventDispatchQueue = BroadcastEventDispatchQueue;
                    /**
                     * The EventDispatcher class is the base class for all classes that dispatch events.
                     * The EventDispatcher class implements the IEventDispatcher interface and is the base class for
                     * the DisplayObject class. The EventDispatcher class allows any object on the display list to be
                     * an event target and as such, to use the methods of the IEventDispatcher interface.
                     */
                    var EventDispatcher = (function (_super) {
                        __extends(EventDispatcher, _super);
                        function EventDispatcher(target) {
                            if (target === void 0) { target = null; }
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields(target || this);
                            }
                        }
                        EventDispatcher.classInitializer = function () {
                            this.broadcastEventDispatchQueue = new BroadcastEventDispatchQueue();
                        };
                        EventDispatcher.prototype._initializeFields = function (target) {
                            release || assert(!this._fieldsInitialized);
                            this._fieldsInitialized = true;
                            this._target = target;
                            this._captureListeners = null;
                            this._targetOrBubblingListeners = null;
                        };
                        EventDispatcher.prototype.toString = function () {
                            // EventDispatcher's toString doesn't actually do anything. It just introduces a trait that
                            // forwards to Object.prototype's toString method.
                            return this.sec.AXObject.dPrototype.$BgtoString.axCall(this);
                        };
                        /**
                         * Don't lazily construct listener lists if all we're doing is looking for listener types that
                         * don't exist yet.
                         */
                        EventDispatcher.prototype._getListenersForType = function (useCapture, type) {
                            var listeners = useCapture ? this._captureListeners : this._targetOrBubblingListeners;
                            if (listeners) {
                                return listeners[type];
                            }
                            return null;
                        };
                        /**
                         * Lazily construct listeners lists to avoid object allocation.
                         */
                        EventDispatcher.prototype._getListeners = function (useCapture) {
                            if (useCapture) {
                                return this._captureListeners || (this._captureListeners = Object.create(null));
                            }
                            return this._targetOrBubblingListeners || (this._targetOrBubblingListeners = Object.create(null));
                        };
                        EventDispatcher.prototype.addEventListener = function (type, listener, useCapture, priority, useWeakReference) {
                            if (useCapture === void 0) { useCapture = false; }
                            if (priority === void 0) { priority = 0; }
                            if (useWeakReference === void 0) { useWeakReference = false; }
                            // The error message always says "2", even though up to five arguments are valid.
                            if (arguments.length < 2 || arguments.length > 5) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.WrongArgumentCountError, "flash.events::EventDispatcher/addEventListener()", 2, arguments.length);
                            }
                            // The type of `listener` is checked before that of `type`.
                            if (!AVMX.axIsCallable(listener)) {
                                // TODO: The Player unevals the `listener`. To some extend, we could, too.
                                this.sec.throwError("TypeError", AVMX.Errors.CheckTypeFailedError, listener, "Function");
                            }
                            if (isNullOrUndefined(type)) {
                                this.sec.throwError("TypeError", AVMX.Errors.NullPointerError, "type");
                            }
                            type = axCoerceString(type);
                            useCapture = !!useCapture;
                            priority |= 0;
                            useWeakReference = !!useWeakReference;
                            var listeners = this._getListeners(useCapture);
                            var list = listeners[type] || (listeners[type] = new EventListenerList());
                            list.insert(listener, useCapture, priority);
                            // Notify the broadcast event queue. If |useCapture| is set then the Flash player
                            // doesn't seem to register this target.
                            if (!useCapture && events.Event.isBroadcastEventType(type)) {
                                this.sec.flash.events.EventDispatcher.axClass.broadcastEventDispatchQueue.add(type, this);
                            }
                        };
                        EventDispatcher.prototype.removeEventListener = function (type, listener, useCapture) {
                            if (useCapture === void 0) { useCapture = false; }
                            // The error message always says "2", even though 3 arguments are valid.
                            if (arguments.length < 2 || arguments.length > 3) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.WrongArgumentCountError, "flash.events::EventDispatcher/removeEventListener()", 2, arguments.length);
                            }
                            // The type of `listener` is checked before that of `type`.
                            if (!AVMX.axIsCallable(listener)) {
                                // TODO: The Player unevals the `listener`. To some extend, we could, too.
                                this.sec.throwError("TypeError", AVMX.Errors.CheckTypeFailedError, listener, "Function");
                            }
                            if (isNullOrUndefined(type)) {
                                this.sec.throwError("TypeError", AVMX.Errors.NullPointerError, "type");
                            }
                            type = axCoerceString(type);
                            var listeners = this._getListeners(!!useCapture);
                            var list = listeners[type];
                            if (list) {
                                list.remove(listener);
                                if (list.isEmpty()) {
                                    // Notify the broadcast event queue of the removal.
                                    if (!useCapture && events.Event.isBroadcastEventType(type)) {
                                        this.sec.flash.events.EventDispatcher.axClass.broadcastEventDispatchQueue.remove(type, this);
                                    }
                                    listeners[type] = null;
                                }
                            }
                        };
                        EventDispatcher.prototype._hasTargetOrBubblingEventListener = function (type) {
                            return !!(this._targetOrBubblingListeners && this._targetOrBubblingListeners[type]);
                        };
                        EventDispatcher.prototype._hasCaptureEventListener = function (type) {
                            return !!(this._captureListeners && this._captureListeners[type]);
                        };
                        /**
                         * Faster internal version of |hasEventListener| that doesn't do any argument checking.
                         */
                        EventDispatcher.prototype._hasEventListener = function (type) {
                            return this._hasTargetOrBubblingEventListener(type) || this._hasCaptureEventListener(type);
                        };
                        EventDispatcher.prototype.hasEventListener = function (type) {
                            if (arguments.length !== 1) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.WrongArgumentCountError, "flash.events::EventDispatcher/hasEventListener()", 1, arguments.length);
                            }
                            if (isNullOrUndefined(type)) {
                                this.sec.throwError("TypeError", AVMX.Errors.NullPointerError, "type");
                            }
                            type = axCoerceString(type);
                            return this._hasEventListener(type);
                        };
                        EventDispatcher.prototype.willTrigger = function (type) {
                            if (arguments.length !== 1) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.WrongArgumentCountError, "flash.events::EventDispatcher/hasEventListener()", 1, arguments.length);
                            }
                            if (isNullOrUndefined(type)) {
                                this.sec.throwError("TypeError", AVMX.Errors.NullPointerError, "type");
                            }
                            type = axCoerceString(type);
                            if (this._hasEventListener(type)) {
                                return true;
                            }
                            if (this.sec.flash.display.DisplayObject.axIsType(this)) {
                                var node = this._parent;
                                do {
                                    if (node._hasEventListener(type)) {
                                        return true;
                                    }
                                } while ((node = node._parent));
                            }
                            return false;
                        };
                        /**
                         * Check to see if we can skip event dispatching in case there are no event listeners
                         * for this |event|.
                         */
                        EventDispatcher.prototype._skipDispatchEvent = function (event) {
                            if (this._hasEventListener(event.type)) {
                                return false;
                            }
                            // Broadcast events don't have capturing or bubbling phases so it's a simple check.
                            if (event.isBroadcastEvent()) {
                                return true;
                            }
                            else if (event._bubbles && this.sec.flash.display.DisplayObject.axIsType(this)) {
                                // Check to see if there are any event listeners on the path to the root.
                                for (var node = this._parent; node; node = node._parent) {
                                    if (node._hasEventListener(event.type)) {
                                        return false;
                                    }
                                }
                            }
                            return true;
                        };
                        EventDispatcher.prototype.dispatchEvent = function (event) {
                            if (arguments.length !== 1) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.WrongArgumentCountError, "flash.events::EventDispatcher/dispatchEvent()", 1, arguments.length);
                            }
                            if (this._skipDispatchEvent(event)) {
                                return true;
                            }
                            if (!release && AS.traceEventsOption.value) {
                                console.log('Dispatch event of type ' + event._type);
                            }
                            release || AVMX.counter.count("EventDispatcher::dispatchEvent");
                            var type = event._type;
                            var target = this._target;
                            release || AVMX.counter.count("EventDispatcher::dispatchEvent(" + type + ")");
                            /**
                             * 1. Capturing Phase
                             */
                            var keepPropagating = true;
                            var ancestors = [];
                            if (!event.isBroadcastEvent() && this.sec.flash.display.DisplayObject.axIsType(this)) {
                                var node = this._parent;
                                // Gather all parent display objects that have event listeners for this event type.
                                while (node) {
                                    if (node._hasEventListener(type)) {
                                        ancestors.push(node);
                                    }
                                    node = node._parent;
                                }
                                for (var i = ancestors.length - 1; i >= 0 && keepPropagating; i--) {
                                    var ancestor = ancestors[i];
                                    if (!ancestor._hasCaptureEventListener(type)) {
                                        continue;
                                    }
                                    var list = ancestor._getListenersForType(true, type);
                                    release || assert(list);
                                    keepPropagating = EventDispatcher.callListeners(list, event, target, ancestor, events.EventPhase.CAPTURING_PHASE);
                                }
                            }
                            /**
                             * 2. At Target
                             */
                            if (keepPropagating) {
                                var list = this._getListenersForType(false, type);
                                if (list) {
                                    keepPropagating = EventDispatcher.callListeners(list, event, target, target, events.EventPhase.AT_TARGET);
                                }
                            }
                            /**
                             * 3. Bubbling Phase
                             */
                            if (!event.isBroadcastEvent() && keepPropagating && event.bubbles) {
                                for (var i = 0; i < ancestors.length && keepPropagating; i++) {
                                    var ancestor = ancestors[i];
                                    if (!ancestor._hasTargetOrBubblingEventListener(type)) {
                                        continue;
                                    }
                                    var list = ancestor._getListenersForType(false, type);
                                    keepPropagating = EventDispatcher.callListeners(list, event, target, ancestor, events.EventPhase.BUBBLING_PHASE);
                                }
                            }
                            return !event._isDefaultPrevented;
                        };
                        EventDispatcher.callListeners = function (list, event, target, currentTarget, eventPhase) {
                            if (list.isEmpty()) {
                                return true;
                            }
                            /**
                             * If the target is already set then we must clone the event. We can reuse the event object
                             * for all listener callbacks but not when bubbling.
                             */
                            if (event._target) {
                                event = event.axCallPublicProperty('clone', null);
                            }
                            var snapshot = list.snapshot();
                            try {
                                for (var i = 0; i < snapshot.length; i++) {
                                    var entry = snapshot[i];
                                    event._target = target;
                                    event._currentTarget = currentTarget;
                                    event._eventPhase = eventPhase;
                                    typeof entry.listener === 'function' ?
                                        entry.listener(event) :
                                        entry.listener.call(entry.listener, event);
                                    if (event._stopImmediatePropagation) {
                                        break;
                                    }
                                }
                            }
                            catch (e) {
                                Shumway.Debug.warning('Uncaught error in handler for event ' + event._type + ': ', e);
                            }
                            list.releaseSnapshot(snapshot);
                            return !event._stopPropagation;
                        };
                        return EventDispatcher;
                    })(AS.ASObject);
                    events.EventDispatcher = EventDispatcher;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: EventPhase
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var EventPhase = (function (_super) {
                        __extends(EventPhase, _super);
                        function EventPhase() {
                            _super.call(this);
                        }
                        EventPhase.classInitializer = null;
                        EventPhase.classSymbols = null;
                        EventPhase.instanceSymbols = null;
                        // JS -> AS Bindings
                        EventPhase.CAPTURING_PHASE = 1;
                        EventPhase.AT_TARGET = 2;
                        EventPhase.BUBBLING_PHASE = 3;
                        return EventPhase;
                    })(AS.ASObject);
                    events.EventPhase = EventPhase;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: TextEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var TextEvent = (function (_super) {
                        __extends(TextEvent, _super);
                        function TextEvent(type, bubbles, cancelable, text) {
                            _super.call(this, type, bubbles, cancelable);
                            this._text = text;
                        }
                        Object.defineProperty(TextEvent.prototype, "text", {
                            get: function () {
                                return this._text;
                            },
                            set: function (value) {
                                this._text = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        TextEvent.prototype.clone = function () {
                            var textEvent = new this.sec.flash.events.TextEvent(this.type, this.bubbles, this.cancelable, this.text);
                            //this.copyNativeData(textEvent);
                            return textEvent;
                        };
                        TextEvent.prototype.toString = function () {
                            return this.formatToString('TextEvent', 'type', 'bubbles', 'cancelable', 'text');
                        };
                        TextEvent.prototype.copyNativeData = function (event) {
                            release || notImplemented("public flash.events.TextEvent::copyNativeData");
                        };
                        TextEvent.classInitializer = null;
                        TextEvent.classSymbols = null;
                        TextEvent.instanceSymbols = null;
                        TextEvent.LINK = "link";
                        TextEvent.TEXT_INPUT = "textInput";
                        return TextEvent;
                    })(flash.events.Event);
                    events.TextEvent = TextEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: ErrorEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var ErrorEvent = (function (_super) {
                        __extends(ErrorEvent, _super);
                        function ErrorEvent(type, bubbles, cancelable, text, id) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (text === void 0) { text = ""; }
                            if (id === void 0) { id = 0; }
                            _super.call(this, type, bubbles, cancelable, text);
                            this.setID(id);
                        }
                        ErrorEvent.prototype.setID = function (id) {
                            this._id = id;
                        };
                        Object.defineProperty(ErrorEvent.prototype, "errorID", {
                            get: function () {
                                return this._id;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        ErrorEvent.prototype.clone = function () {
                            return new this.sec.flash.events.ErrorEvent(this.type, this.bubbles, this.cancelable, this.text, this.errorID);
                        };
                        ErrorEvent.prototype.toString = function () {
                            return this.formatToString('ErrorEvent', 'type', 'bubbles', 'cancelable', 'text', 'errorID');
                        };
                        ErrorEvent.classInitializer = null;
                        ErrorEvent.classSymbols = null;
                        ErrorEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        ErrorEvent.ERROR = "error";
                        return ErrorEvent;
                    })(flash.events.TextEvent);
                    events.ErrorEvent = ErrorEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: AsyncErrorEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var AsyncErrorEvent = (function (_super) {
                        __extends(AsyncErrorEvent, _super);
                        function AsyncErrorEvent(type, bubbles, cancelable, text, error) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (text === void 0) { text = ""; }
                            if (error === void 0) { error = null; }
                            _super.call(this, type, bubbles, cancelable, text);
                            this.$Bgerror = error;
                        }
                        Object.defineProperty(AsyncErrorEvent.prototype, "error", {
                            get: function () {
                                return this.$Bgerror;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        AsyncErrorEvent.prototype.clone = function () {
                            return new this.sec.flash.events.AsyncErrorEvent(this._type, this._bubbles, this._cancelable, this._text, this.$Bgerror);
                        };
                        AsyncErrorEvent.prototype.toString = function () {
                            return this.formatToString('AsyncErrorEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'text', 'error');
                        };
                        AsyncErrorEvent.ASYNC_ERROR = "asyncError";
                        AsyncErrorEvent.classInitializer = null;
                        return AsyncErrorEvent;
                    })(flash.events.ErrorEvent);
                    events.AsyncErrorEvent = AsyncErrorEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GameInputEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var GameInputEvent = (function (_super) {
                        __extends(GameInputEvent, _super);
                        function GameInputEvent(type, bubbles, cancelable, device) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (device === void 0) { device = null; }
                            _super.call(this, type, bubbles, cancelable);
                            // TODO: coerce
                            this.device = device;
                        }
                        GameInputEvent.classInitializer = null;
                        GameInputEvent.classSymbols = null;
                        GameInputEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        GameInputEvent.DEVICE_ADDED = "deviceAdded";
                        GameInputEvent.DEVICE_REMOVED = "deviceRemoved";
                        return GameInputEvent;
                    })(flash.events.Event);
                    events.GameInputEvent = GameInputEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GestureEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var GestureEvent = (function (_super) {
                        __extends(GestureEvent, _super);
                        function GestureEvent(type, bubbles, cancelable, phase, localX, localY, ctrlKey, altKey, shiftKey) {
                            if (bubbles === void 0) { bubbles = true; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (phase === void 0) { phase = null; }
                            if (localX === void 0) { localX = 0; }
                            if (localY === void 0) { localY = 0; }
                            if (ctrlKey === void 0) { ctrlKey = false; }
                            if (altKey === void 0) { altKey = false; }
                            if (shiftKey === void 0) { shiftKey = false; }
                            _super.call(this, type, bubbles, cancelable);
                            this._phase = axCoerceString(phase);
                            this._localX = +localX;
                            this._localY = +localY;
                            this._ctrlKey = !!ctrlKey;
                            this._altKey = !!altKey;
                            this._shiftKey = !!shiftKey;
                        }
                        Object.defineProperty(GestureEvent.prototype, "localX", {
                            // AS -> JS Bindings
                            get: function () {
                                return this._localX;
                            },
                            set: function (value) {
                                this._localX = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "localY", {
                            get: function () {
                                return this._localY;
                            },
                            set: function (value) {
                                this._localY = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "stageX", {
                            get: function () {
                                release || somewhatImplemented("public flash.events.GestureEvent::stageX");
                                return 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "stageY", {
                            get: function () {
                                release || somewhatImplemented("public flash.events.GestureEvent::stageY");
                                return 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "ctrlKey", {
                            get: function () {
                                return this._ctrlKey;
                            },
                            set: function (value) {
                                this._ctrlKey = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "altKey", {
                            get: function () {
                                return this._altKey;
                            },
                            set: function (value) {
                                this._altKey = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "shiftKey", {
                            get: function () {
                                return this._shiftKey;
                            },
                            set: function (value) {
                                this._shiftKey = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(GestureEvent.prototype, "phase", {
                            get: function () {
                                return this._phase;
                            },
                            set: function (value) {
                                this._phase = axCoerceString(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        GestureEvent.prototype.updateAfterEvent = function () {
                            release || somewhatImplemented("public flash.events.GestureEvent::updateAfterEvent");
                        };
                        GestureEvent.prototype.NativeCtor = function (phase, localX, localY, ctrlKey, altKey, shiftKey) {
                            this._phase = axCoerceString(phase);
                            this._localX = +localX;
                            this._localY = +localY;
                            this._ctrlKey = !!ctrlKey;
                            this._altKey = !!altKey;
                            this._shiftKey = !!shiftKey;
                        };
                        GestureEvent.prototype.clone = function () {
                            return new this.sec.flash.events.GestureEvent(this.type, this.bubbles, this.cancelable, this.phase, this.localX, this.localY, this.ctrlKey, this.altKey, this.shiftKey);
                        };
                        GestureEvent.prototype.toString = function () {
                            return this.formatToString('GestureEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'localX', 'localY', 'ctrlKey', 'altKey', 'shiftKey');
                        };
                        GestureEvent.classInitializer = null;
                        GestureEvent.classSymbols = null;
                        GestureEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        GestureEvent.GESTURE_TWO_FINGER_TAP = "gestureTwoFingerTap";
                        return GestureEvent;
                    })(flash.events.Event);
                    events.GestureEvent = GestureEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: HTTPStatusEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var HTTPStatusEvent = (function (_super) {
                        __extends(HTTPStatusEvent, _super);
                        function HTTPStatusEvent(type, bubbles, cancelable, status) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (status === void 0) { status = 0; }
                            _super.call(this, type, bubbles, cancelable);
                            this._status = status | 0;
                        }
                        HTTPStatusEvent.prototype._setStatus = function (value) {
                            this._status = value;
                        };
                        Object.defineProperty(HTTPStatusEvent.prototype, "status", {
                            get: function () {
                                return this._status;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        HTTPStatusEvent.prototype.clone = function () {
                            return new this.sec.flash.events.HTTPStatusEvent(this.type, this.bubbles, this.cancelable, this.status);
                        };
                        HTTPStatusEvent.prototype.toString = function () {
                            return this.formatToString('HTTPStatusEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'status');
                        };
                        HTTPStatusEvent.classInitializer = null;
                        HTTPStatusEvent.HTTP_STATUS = "httpStatus";
                        HTTPStatusEvent.HTTP_RESPONSE_STATUS = "httpResponseStatus";
                        return HTTPStatusEvent;
                    })(flash.events.Event);
                    events.HTTPStatusEvent = HTTPStatusEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: IOErrorEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var IOErrorEvent = (function (_super) {
                        __extends(IOErrorEvent, _super);
                        function IOErrorEvent(type, bubbles, cancelable, text, id) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (text === void 0) { text = ""; }
                            if (id === void 0) { id = 0; }
                            _super.call(this, type, bubbles, cancelable, text, id);
                        }
                        IOErrorEvent.prototype.clone = function () {
                            var event = new this.sec.flash.events.IOErrorEvent(this.type, this.bubbles, this.cancelable, this.text, this.errorID);
                            //this.copyNativeData(event);
                            return event;
                        };
                        IOErrorEvent.prototype.toString = function () {
                            return this.formatToString('IOErrorEvent', 'type', 'bubbles', 'cancelable', 'text', 'errorID');
                        };
                        IOErrorEvent.classInitializer = null;
                        IOErrorEvent.classSymbols = null;
                        IOErrorEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        IOErrorEvent.IO_ERROR = "ioError";
                        IOErrorEvent.NETWORK_ERROR = "networkError";
                        IOErrorEvent.DISK_ERROR = "diskError";
                        IOErrorEvent.VERIFY_ERROR = "verifyError";
                        return IOErrorEvent;
                    })(flash.events.ErrorEvent);
                    events.IOErrorEvent = IOErrorEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: KeyboardEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var KeyboardEvent = (function (_super) {
                        __extends(KeyboardEvent, _super);
                        function KeyboardEvent(type, bubbles, cancelable, charCodeValue, keyCodeValue, keyLocationValue, ctrlKeyValue, altKeyValue, shiftKeyValue) {
                            if (bubbles === void 0) { bubbles = true; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (charCodeValue === void 0) { charCodeValue = 0; }
                            if (keyCodeValue === void 0) { keyCodeValue = 0; }
                            if (keyLocationValue === void 0) { keyLocationValue = 0; }
                            if (ctrlKeyValue === void 0) { ctrlKeyValue = false; }
                            if (altKeyValue === void 0) { altKeyValue = false; }
                            if (shiftKeyValue === void 0) { shiftKeyValue = false; }
                            _super.call(this, type, bubbles, cancelable);
                            this._charCode = charCodeValue >>> 0;
                            this._keyCode = keyCodeValue >>> 0;
                            this._keyLocation = keyLocationValue >>> 0;
                            this._ctrlKey = !!ctrlKeyValue;
                            this._altKey = !!altKeyValue;
                            this._shiftKey = !!shiftKeyValue;
                        }
                        Object.defineProperty(KeyboardEvent.prototype, "charCode", {
                            get: function () {
                                return this._charCode;
                            },
                            set: function (value) {
                                this._charCode = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(KeyboardEvent.prototype, "keyCode", {
                            get: function () {
                                return this._keyCode;
                            },
                            set: function (value) {
                                this._keyCode = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(KeyboardEvent.prototype, "keyLocation", {
                            get: function () {
                                return this._keyLocation;
                            },
                            set: function (value) {
                                this._keyLocation = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(KeyboardEvent.prototype, "ctrlKey", {
                            get: function () {
                                return this._ctrlKey;
                            },
                            set: function (value) {
                                this._ctrlKey = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(KeyboardEvent.prototype, "altKey", {
                            get: function () {
                                return this._altKey;
                            },
                            set: function (value) {
                                this._altKey = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(KeyboardEvent.prototype, "shiftKey", {
                            get: function () {
                                return this._shiftKey;
                            },
                            set: function (value) {
                                this._shiftKey = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        KeyboardEvent.prototype.clone = function () {
                            return new this.sec.flash.events.KeyboardEvent(this.type, this.bubbles, this.cancelable, this.charCode, this.keyCode, this.keyLocation, this.ctrlKey, this.altKey, this.shiftKey);
                        };
                        KeyboardEvent.prototype.toString = function () {
                            return this.formatToString('KeyboardEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'charCode', 'keyCode', 'keyLocation', 'ctrlKey', 'altKey', 'shiftKey');
                        };
                        KeyboardEvent.prototype.updateAfterEvent = function () {
                            this.sec.player.requestRendering();
                        };
                        KeyboardEvent.classInitializer = null;
                        KeyboardEvent.classSymbols = null;
                        KeyboardEvent.instanceSymbols = null;
                        KeyboardEvent.KEY_DOWN = "keyDown";
                        KeyboardEvent.KEY_UP = "keyUp";
                        return KeyboardEvent;
                    })(flash.events.Event);
                    events.KeyboardEvent = KeyboardEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: MouseEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var MouseEvent = (function (_super) {
                        __extends(MouseEvent, _super);
                        function MouseEvent(type, bubbles, cancelable, localX, localY, relatedObject, ctrlKey, altKey, shiftKey, buttonDown, delta) {
                            if (bubbles === void 0) { bubbles = true; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (localX === void 0) { localX = undefined; }
                            if (localY === void 0) { localY = undefined; }
                            if (relatedObject === void 0) { relatedObject = null; }
                            if (ctrlKey === void 0) { ctrlKey = false; }
                            if (altKey === void 0) { altKey = false; }
                            if (shiftKey === void 0) { shiftKey = false; }
                            if (buttonDown === void 0) { buttonDown = false; }
                            if (delta === void 0) { delta = 0; }
                            _super.call(this, type, bubbles, cancelable);
                            this._localX = localX;
                            this._localY = localY;
                            this._relatedObject = relatedObject;
                            this._ctrlKey = ctrlKey;
                            this._altKey = altKey;
                            this._shiftKey = shiftKey;
                            this._buttonDown = buttonDown;
                            this._delta = delta;
                        }
                        /**
                         * AS3 mouse event names don't match DOM even names, so map them here.
                         */
                        MouseEvent.typeFromDOMType = function (name) {
                            switch (name) {
                                case "click":
                                    return MouseEvent.CLICK;
                                case "dblclick":
                                    return MouseEvent.DOUBLE_CLICK;
                                case "mousedown":
                                    return MouseEvent.MOUSE_DOWN;
                                case "mouseout":
                                case "mouseover":
                                case "mousemove":
                                    return MouseEvent.MOUSE_MOVE;
                                case "mouseup":
                                    return MouseEvent.MOUSE_UP;
                                default:
                                    notImplemented(name);
                            }
                        };
                        Object.defineProperty(MouseEvent.prototype, "localX", {
                            get: function () {
                                return (this._localX / 20) | 0;
                            },
                            set: function (value) {
                                this._localX = (value * 20) | 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "localY", {
                            get: function () {
                                return (this._localY / 20) | 0;
                            },
                            set: function (value) {
                                this._localY = (value * 20) | 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "stageX", {
                            get: function () {
                                if (isNaN(this.localX + this.localY)) {
                                    return Number.NaN;
                                }
                                return (this._getGlobalPoint().x / 20) | 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "stageY", {
                            get: function () {
                                if (isNaN(this.localX + this.localY)) {
                                    return Number.NaN;
                                }
                                return (this._getGlobalPoint().y / 20) | 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "movementX", {
                            get: function () {
                                return this._movementX || 0;
                            },
                            set: function (value) {
                                this._movementX = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "movementY", {
                            get: function () {
                                return this._movementY || 0;
                            },
                            set: function (value) {
                                this._movementY = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "delta", {
                            get: function () {
                                return this._delta;
                            },
                            set: function (value) {
                                this._delta = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "ctrlKey", {
                            get: function () {
                                return this._ctrlKey;
                            },
                            set: function (value) {
                                this._ctrlKey = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "altKey", {
                            get: function () {
                                return this._altKey;
                            },
                            set: function (value) {
                                this._altKey = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "shiftKey", {
                            get: function () {
                                return this._shiftKey;
                            },
                            set: function (value) {
                                this._shiftKey = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "buttonDown", {
                            get: function () {
                                return this._buttonDown;
                            },
                            set: function (value) {
                                this._buttonDown = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "relatedObject", {
                            get: function () {
                                return this._relatedObject;
                            },
                            set: function (value) {
                                this._relatedObject = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MouseEvent.prototype, "isRelatedObjectInaccessible", {
                            get: function () {
                                return this._isRelatedObjectInaccessible;
                            },
                            set: function (value) {
                                this._isRelatedObjectInaccessible = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        MouseEvent.prototype.updateAfterEvent = function () {
                            this.sec.player.requestRendering();
                        };
                        MouseEvent.prototype._getGlobalPoint = function () {
                            var point = this._position;
                            if (!point) {
                                point = this._position = new this.sec.flash.geom.Point();
                            }
                            if (this.target) {
                                point.setTo(this._localX, this._localY);
                                var m = this._target._getConcatenatedMatrix();
                                m.transformPointInPlace(point);
                            }
                            else {
                                point.setTo(0, 0);
                            }
                            return point;
                        };
                        MouseEvent.prototype.clone = function () {
                            return new this.sec.flash.events.MouseEvent(this.type, this.bubbles, this.cancelable, this.localX, this.localY, this.relatedObject, this.ctrlKey, this.altKey, this.shiftKey, this.buttonDown, this.delta);
                        };
                        MouseEvent.prototype.toString = function () {
                            return this.formatToString('MouseEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'localX', "localY", 'relatedObject', 'ctrlKey', 'altKey', 'shiftKey', 'buttonDown', 'delta');
                        };
                        MouseEvent.classInitializer = null;
                        MouseEvent.classSymbols = null;
                        MouseEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        MouseEvent.CLICK = "click";
                        MouseEvent.DOUBLE_CLICK = "doubleClick";
                        MouseEvent.MOUSE_DOWN = "mouseDown";
                        MouseEvent.MOUSE_MOVE = "mouseMove";
                        MouseEvent.MOUSE_OUT = "mouseOut";
                        MouseEvent.MOUSE_OVER = "mouseOver";
                        MouseEvent.MOUSE_UP = "mouseUp";
                        MouseEvent.RELEASE_OUTSIDE = "releaseOutside";
                        MouseEvent.MOUSE_WHEEL = "mouseWheel";
                        MouseEvent.ROLL_OUT = "rollOut";
                        MouseEvent.ROLL_OVER = "rollOver";
                        MouseEvent.MIDDLE_CLICK = "middleClick";
                        MouseEvent.MIDDLE_MOUSE_DOWN = "middleMouseDown";
                        MouseEvent.MIDDLE_MOUSE_UP = "middleMouseUp";
                        MouseEvent.RIGHT_CLICK = "rightClick";
                        MouseEvent.RIGHT_MOUSE_DOWN = "rightMouseDown";
                        MouseEvent.RIGHT_MOUSE_UP = "rightMouseUp";
                        MouseEvent.CONTEXT_MENU = "contextMenu";
                        return MouseEvent;
                    })(flash.events.Event);
                    events.MouseEvent = MouseEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: NetStatusEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var NetStatusEvent = (function (_super) {
                        __extends(NetStatusEvent, _super);
                        function NetStatusEvent(type, bubbles, cancelable, info) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (info === void 0) { info = null; }
                            _super.call(this, type, bubbles, cancelable);
                            this._info = info;
                        }
                        Object.defineProperty(NetStatusEvent.prototype, "info", {
                            get: function () {
                                return this._info;
                            },
                            set: function (value) {
                                this._info = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        NetStatusEvent.prototype.clone = function () {
                            return new this.sec.flash.events.NetStatusEvent(this.type, this.bubbles, this.cancelable, this.info);
                        };
                        NetStatusEvent.prototype.toString = function () {
                            return this.formatToString('NetStatusEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'info');
                        };
                        NetStatusEvent.classInitializer = null;
                        NetStatusEvent.classSymbols = null;
                        NetStatusEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        NetStatusEvent.NET_STATUS = "netStatus";
                        return NetStatusEvent;
                    })(flash.events.Event);
                    events.NetStatusEvent = NetStatusEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: ProgressEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var ProgressEvent = (function (_super) {
                        __extends(ProgressEvent, _super);
                        function ProgressEvent(type, bubbles, cancelable, bytesLoaded, bytesTotal) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (bytesLoaded === void 0) { bytesLoaded = 0; }
                            if (bytesTotal === void 0) { bytesTotal = 0; }
                            _super.call(this, type, bubbles, cancelable);
                            this._bytesLoaded = bytesLoaded;
                            this._bytesTotal = bytesTotal;
                        }
                        Object.defineProperty(ProgressEvent.prototype, "bytesLoaded", {
                            get: function () {
                                return this._bytesLoaded;
                            },
                            set: function (value) {
                                this._bytesLoaded = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(ProgressEvent.prototype, "bytesTotal", {
                            get: function () {
                                return this._bytesTotal;
                            },
                            set: function (value) {
                                this._bytesTotal = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        ProgressEvent.prototype.clone = function () {
                            return new this.sec.flash.events.ProgressEvent(this._type, this._bubbles, this._cancelable, this._bytesLoaded, this._bytesTotal);
                        };
                        ProgressEvent.prototype.toString = function () {
                            return this.formatToString('ProgressEvent', 'bubbles', 'cancelable', 'eventPhase', 'bytesLoaded', 'bytesTotal');
                        };
                        ProgressEvent.classInitializer = null;
                        ProgressEvent.classSymbols = null;
                        ProgressEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        ProgressEvent.PROGRESS = "progress";
                        ProgressEvent.SOCKET_DATA = "socketData";
                        return ProgressEvent;
                    })(flash.events.Event);
                    events.ProgressEvent = ProgressEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: SecurityErrorEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var SecurityErrorEvent = (function (_super) {
                        __extends(SecurityErrorEvent, _super);
                        function SecurityErrorEvent(type, bubbles, cancelable, text, id) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (text === void 0) { text = ""; }
                            if (id === void 0) { id = 0; }
                            _super.call(this, type, bubbles, cancelable, text, id);
                        }
                        SecurityErrorEvent.classInitializer = null;
                        SecurityErrorEvent.classSymbols = null;
                        SecurityErrorEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        SecurityErrorEvent.SECURITY_ERROR = "securityError";
                        return SecurityErrorEvent;
                    })(flash.events.ErrorEvent);
                    events.SecurityErrorEvent = SecurityErrorEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: StatusEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var StatusEvent = (function (_super) {
                        __extends(StatusEvent, _super);
                        function StatusEvent(type, bubbles, cancelable, code, level) {
                            if (bubbles === void 0) { bubbles = false; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (code === void 0) { code = ""; }
                            if (level === void 0) { level = ""; }
                            _super.call(this, type, bubbles, cancelable);
                            this._code = AVMX.axCoerceString(code);
                            this._level = AVMX.axCoerceString(level);
                        }
                        Object.defineProperty(StatusEvent.prototype, "level", {
                            get: function () {
                                return this._level;
                            },
                            set: function (value) {
                                this._level = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(StatusEvent.prototype, "code", {
                            get: function () {
                                return this._code;
                            },
                            set: function (value) {
                                this._code = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        StatusEvent.prototype.clone = function () {
                            return new this.sec.flash.events.StatusEvent(this._type, this._bubbles, this._cancelable, this._code, this._level);
                        };
                        StatusEvent.prototype.toString = function () {
                            return this.formatToString('StatusEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'code', 'level');
                        };
                        StatusEvent.classInitializer = null;
                        StatusEvent.STATUS = "status";
                        return StatusEvent;
                    })(flash.events.Event);
                    events.StatusEvent = StatusEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: TimerEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var TimerEvent = (function (_super) {
                        __extends(TimerEvent, _super);
                        function TimerEvent(type, bubbles, cancelable) {
                            _super.call(this, type, bubbles, cancelable);
                        }
                        TimerEvent.prototype.clone = function () {
                            return new this.sec.flash.events.TimerEvent(this.type, this.bubbles, this.cancelable);
                        };
                        TimerEvent.prototype.toString = function () {
                            return this.formatToString('TimerEvent', 'type', 'bubbles', 'cancelable', 'eventPhase');
                        };
                        TimerEvent.prototype.updateAfterEvent = function () {
                            this.sec.player.requestRendering();
                        };
                        TimerEvent.classInitializer = null;
                        TimerEvent.classSymbols = null;
                        TimerEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        TimerEvent.TIMER = "timer";
                        TimerEvent.TIMER_COMPLETE = "timerComplete";
                        return TimerEvent;
                    })(flash.events.Event);
                    events.TimerEvent = TimerEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: TouchEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var TouchEvent = (function (_super) {
                        __extends(TouchEvent, _super);
                        function TouchEvent(type, bubbles, cancelable, touchPointID, isPrimaryTouchPoint, localX, localY, sizeX, sizeY, pressure, relatedObject, ctrlKey, altKey, shiftKey) {
                            if (bubbles === void 0) { bubbles = true; }
                            if (cancelable === void 0) { cancelable = false; }
                            if (touchPointID === void 0) { touchPointID = 0; }
                            if (isPrimaryTouchPoint === void 0) { isPrimaryTouchPoint = false; }
                            if (localX === void 0) { localX = NaN; }
                            if (localY === void 0) { localY = NaN; }
                            if (sizeX === void 0) { sizeX = NaN; }
                            if (sizeY === void 0) { sizeY = NaN; }
                            if (pressure === void 0) { pressure = NaN; }
                            if (relatedObject === void 0) { relatedObject = null; }
                            if (ctrlKey === void 0) { ctrlKey = false; }
                            if (altKey === void 0) { altKey = false; }
                            if (shiftKey === void 0) { shiftKey = false; }
                            _super.call(this, type, bubbles, cancelable);
                        }
                        Object.defineProperty(TouchEvent.prototype, "touchPointID", {
                            get: function () {
                                return this._touchPointID;
                            },
                            set: function (value) {
                                this._touchPointID = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "isPrimaryTouchPoint", {
                            get: function () {
                                return this._isPrimaryTouchPoint;
                            },
                            set: function (value) {
                                this._isPrimaryTouchPoint = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "localX", {
                            get: function () {
                                return this._localX;
                            },
                            set: function (value) {
                                this._localX = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "localY", {
                            get: function () {
                                return this._localY;
                            },
                            set: function (value) {
                                this._localY = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "sizeX", {
                            get: function () {
                                return this._sizeX;
                            },
                            set: function (value) {
                                this._sizeX = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "sizeY", {
                            get: function () {
                                return this._sizeY;
                            },
                            set: function (value) {
                                this._sizeY = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "pressure", {
                            get: function () {
                                return this._pressure;
                            },
                            set: function (value) {
                                this._pressure = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "relatedObject", {
                            get: function () {
                                return this._relatedObject;
                            },
                            set: function (value) {
                                this._relatedObject = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "ctrlKey", {
                            get: function () {
                                return this._ctrlKey;
                            },
                            set: function (value) {
                                this._ctrlKey = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "altKey", {
                            get: function () {
                                return this._altKey;
                            },
                            set: function (value) {
                                this._altKey = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "shiftKey", {
                            get: function () {
                                return this._shiftKey;
                            },
                            set: function (value) {
                                this._shiftKey = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "stageX", {
                            get: function () {
                                somewhatImplemented('TouchEvent::get stageX');
                                return this._localX;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "stageY", {
                            get: function () {
                                somewhatImplemented('TouchEvent::get stageY');
                                return this._localY;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(TouchEvent.prototype, "isRelatedObjectInaccessible", {
                            get: function () {
                                return this._isRelatedObjectInaccessible;
                            },
                            set: function (value) {
                                this._isRelatedObjectInaccessible = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        TouchEvent.prototype.clone = function () {
                            return new this.sec.flash.events.TouchEvent(this.type, this.bubbles, this.cancelable, this.touchPointID, this.isPrimaryTouchPoint, this.localX, this.localY, this.sizeX, this.sizeY, this.pressure, this.relatedObject, this.ctrlKey, this.altKey, this.shiftKey);
                        };
                        TouchEvent.prototype.toString = function () {
                            return this.formatToString('TouchEvent', 'type', 'bubbles', 'cancelable', 'eventPhase', 'touchPointID', 'isPrimaryTouchPoint', 'localX', 'localY', 'sizeX', 'sizeY', 'pressure', 'relatedObject', 'ctrlKey', 'altKey', 'shiftKey');
                        };
                        TouchEvent.prototype.updateAfterEvent = function () {
                            this.sec.player.requestRendering();
                        };
                        TouchEvent.classInitializer = null;
                        TouchEvent.classSymbols = null;
                        TouchEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        TouchEvent.TOUCH_BEGIN = "touchBegin";
                        TouchEvent.TOUCH_END = "touchEnd";
                        TouchEvent.TOUCH_MOVE = "touchMove";
                        TouchEvent.TOUCH_OVER = "touchOver";
                        TouchEvent.TOUCH_OUT = "touchOut";
                        TouchEvent.TOUCH_ROLL_OVER = "touchRollOver";
                        TouchEvent.TOUCH_ROLL_OUT = "touchRollOut";
                        TouchEvent.TOUCH_TAP = "touchTap";
                        TouchEvent.PROXIMITY_BEGIN = "proximityBegin";
                        TouchEvent.PROXIMITY_END = "proximityEnd";
                        TouchEvent.PROXIMITY_MOVE = "proximityMove";
                        TouchEvent.PROXIMITY_OUT = "proximityOut";
                        TouchEvent.PROXIMITY_OVER = "proximityOver";
                        TouchEvent.PROXIMITY_ROLL_OUT = "proximityRollOut";
                        TouchEvent.PROXIMITY_ROLL_OVER = "proximityRollOver";
                        return TouchEvent;
                    })(flash.events.Event);
                    events.TouchEvent = TouchEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: UncaughtErrorEvent
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var UncaughtErrorEvent = (function (_super) {
                        __extends(UncaughtErrorEvent, _super);
                        function UncaughtErrorEvent(type, bubbles, cancelable, error_in) {
                            if (type === void 0) { type = "uncaughtError"; }
                            if (bubbles === void 0) { bubbles = true; }
                            if (cancelable === void 0) { cancelable = true; }
                            if (error_in === void 0) { error_in = null; }
                            _super.call(this, type, bubbles, cancelable, error_in);
                        }
                        UncaughtErrorEvent.classInitializer = null;
                        UncaughtErrorEvent.classSymbols = null;
                        UncaughtErrorEvent.instanceSymbols = null;
                        // JS -> AS Bindings
                        UncaughtErrorEvent.UNCAUGHT_ERROR = "uncaughtError";
                        return UncaughtErrorEvent;
                    })(flash.events.ErrorEvent);
                    events.UncaughtErrorEvent = UncaughtErrorEvent;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: UncaughtErrorEvents
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var events;
                (function (events) {
                    var UncaughtErrorEvents = (function (_super) {
                        __extends(UncaughtErrorEvents, _super);
                        function UncaughtErrorEvents() {
                            _super.call(this);
                        }
                        UncaughtErrorEvents.classInitializer = null;
                        UncaughtErrorEvents.classSymbols = null;
                        UncaughtErrorEvents.instanceSymbols = null;
                        return UncaughtErrorEvents;
                    })(flash.events.EventDispatcher);
                    events.UncaughtErrorEvents = UncaughtErrorEvents;
                })(events = flash.events || (flash.events = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Flash bugs to keep in mind:
 *
 * http://aaronhardy.com/flex/displayobject-quirks-and-tips/
 * http://blog.anselmbradford.com/2009/02/12/flash-movie-clip-transformational-properties-explorer-x-y-width-height-more/
 * http://gskinner.com/blog/archives/2007/08/annoying_as3_bu.html
 * http://blog.dennisrobinson.name/getbounds-getrect-unexpected-results/
 *
 */
// Class: DisplayObject
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var isNullOrUndefined = Shumway.isNullOrUndefined;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var checkNullParameter = Shumway.AVMX.checkNullParameter;
                    var assert = Shumway.Debug.assert;
                    var Bounds = Shumway.Bounds;
                    var geom = flash.geom;
                    var events = flash.events;
                    var displayObjectSyncID = 0;
                    var DisplayObject = (function (_super) {
                        __extends(DisplayObject, _super);
                        function DisplayObject() {
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                            this._addReference();
                            this._setFlags(256 /* Constructed */);
                        }
                        /**
                         * Every displayObject is assigned an unique integer ID.
                         */
                        DisplayObject.getNextSyncID = function () {
                            return displayObjectSyncID++;
                        };
                        // Called whenever the class is initialized.
                        DisplayObject.classInitializer = function () {
                            this.reset();
                        };
                        DisplayObject.reset = function () {
                            this._advancableInstances = new Shumway.WeakList();
                        };
                        /**
                         * Creates a new display object from a symbol and initializes its animated display properties.
                         * Calling its constructor is optional at this point, since that can happen in a later frame
                         * phase.
                         */
                        DisplayObject.prototype.createAnimatedDisplayObject = function (symbol, placeObjectTag, callConstructor) {
                            var symbolClass = symbol.symbolClass;
                            var bitmapDataClass = this.sec.flash.display.BitmapData.axClass;
                            if (symbolClass === bitmapDataClass ||
                                bitmapDataClass.dPrototype.isPrototypeOf(symbolClass.dPrototype)) {
                                symbolClass = this.sec.flash.display.Bitmap.axClass;
                            }
                            var instance = AS.constructClassFromSymbol(symbol, symbolClass);
                            if (placeObjectTag.flags & 32 /* HasName */) {
                                instance._name = placeObjectTag.name;
                            }
                            instance._setFlags(4096 /* AnimatedByTimeline */);
                            instance._animate(placeObjectTag);
                            if (callConstructor) {
                                instance.axInitializer();
                            }
                            return instance;
                        };
                        /**
                         * Runs one full turn of the frame events cycle.
                         *
                         * Frame navigation methods on MovieClip can trigger nested frame events cycles. These nested
                         * cycles do everything the outermost cycle does, except for broadcasting the ENTER_FRAME
                         * event.
                         *
                         * If runScripts is true, no events are dispatched and Movieclip frame scripts are run. This
                         * is true for nested cycles, too. (We keep static state for that.)
                         */
                        DisplayObject.performFrameNavigation = function (mainLoop, runScripts) {
                            if (mainLoop) {
                                this._runScripts = runScripts;
                            }
                            else {
                                runScripts = this._runScripts;
                            }
                            release || assert(this._advancableInstances.length < 1024 * 16, "Too many advancable instances.");
                            // Step 1: Remove timeline objects that don't exist on new frame, update existing ones with
                            // new properties, and declare, but not create, new ones, update numChildren.
                            // NOTE: the Order Of Operations senocular article is wrong on this: timeline objects are
                            // removed from stage at the beginning of a frame, just as new objects are declared at that
                            // point.
                            // Also, changed properties of existing objects are updated here instead of during frame
                            // construction after ENTER_FRAME.
                            // Thus, all these can be done together.
                            AVMX.enterTimeline("DisplayObject.InitFrame");
                            this._advancableInstances.forEach(function (value) {
                                value._initFrame(mainLoop);
                            });
                            AVMX.leaveTimeline();
                            // Step 2: Dispatch ENTER_FRAME, only called in outermost invocation.
                            AVMX.enterTimeline("DisplayObject.EnterFrame");
                            if (mainLoop && runScripts) {
                                this._broadcastFrameEvent(events.Event.ENTER_FRAME);
                            }
                            AVMX.leaveTimeline();
                            // Step 3: Create new timeline objects.
                            AVMX.enterTimeline("DisplayObject.ConstructFrame");
                            this._advancableInstances.forEach(function (value) {
                                value._constructFrame();
                            });
                            AVMX.leaveTimeline();
                            // Step 4: Dispatch FRAME_CONSTRUCTED.
                            if (runScripts) {
                                AVMX.enterTimeline("DisplayObject.FrameConstructed");
                                this._broadcastFrameEvent(events.Event.FRAME_CONSTRUCTED);
                                AVMX.leaveTimeline();
                                // Step 5: Run frame scripts
                                // Flash seems to enqueue all frame scripts recursively, starting at the root of each
                                // independent object graph. That can be the stage or a container that isn't itself on
                                // stage, but has (grand-)children.
                                // The order in which these independent graphs are processed seems not to follow a
                                // specific system: in some testing scenarios all independent graphs are processes before
                                // the stage, in others the first-created such graph is processes *after* the stage, all
                                // others before the stage. There might be other permutations of this, but it seems
                                // doubtful anybody could reasonably rely on the exact details of all this.
                                // Of course, nothing guarantees that there isn't content that accidentally does, so it'd
                                // be nice to eventually get this right.
                                AVMX.enterTimeline("DisplayObject.EnqueueFrameScripts");
                                var displayObjectContainerClass = this.sec.flash.display.DisplayObjectContainer.axClass;
                                this._advancableInstances.forEach(function (value) {
                                    var container = value;
                                    if (displayObjectContainerClass.axIsType(container) && !container.parent) {
                                        container._enqueueFrameScripts();
                                    }
                                });
                                this._stage._enqueueFrameScripts();
                                AVMX.leaveTimeline();
                                AVMX.enterTimeline("DisplayObject.RunFrameScript");
                                var movieClipClass = this.sec.flash.display.MovieClip.axClass;
                                if (movieClipClass.frameNavigationModel === 1 /* SWF1 */) {
                                    movieClipClass.runAvm1FrameScripts();
                                }
                                else {
                                    movieClipClass.runFrameScripts();
                                }
                                AVMX.leaveTimeline();
                                // Step 6: Dispatch EXIT_FRAME.
                                AVMX.enterTimeline("DisplayObject.ExitFrame");
                                this._broadcastFrameEvent(events.Event.EXIT_FRAME);
                                AVMX.leaveTimeline();
                            }
                            else {
                                display.MovieClip.reset();
                            }
                            if (mainLoop) {
                                this._runScripts = true;
                            }
                        };
                        /**
                         * Dispatches a frame event on all instances of DisplayObjects.
                         */
                        DisplayObject._broadcastFrameEvent = function (type) {
                            var eventsPackage = this.sec.flash.events;
                            var event = eventsPackage.Event.axClass.getBroadcastInstance(type);
                            eventsPackage.EventDispatcher.axClass.broadcastEventDispatchQueue.dispatchEvent(event);
                        };
                        DisplayObject.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this, this);
                            this._id = this.sec.flash.display.DisplayObject.axClass.getNextSyncID();
                            this._flags = 1 /* Visible */ |
                                2 /* InvalidLineBounds */ |
                                4 /* InvalidFillBounds */ |
                                32 /* InvalidConcatenatedMatrix */ |
                                64 /* InvalidInvertedConcatenatedMatrix */ |
                                536870912 /* DirtyDescendents */;
                            this._dirtyFlags = 4 /* DirtyGraphics */ |
                                1 /* DirtyMatrix */ |
                                64 /* DirtyColorTransform */ |
                                128 /* DirtyMask */ |
                                256 /* DirtyClipDepth */ |
                                512 /* DirtyMiscellaneousProperties */;
                            this._root = null;
                            this._stage = null;
                            this._setInitialName();
                            this._parent = null;
                            this._mask = null;
                            this._z = 0;
                            this._scaleX = 1;
                            this._scaleY = 1;
                            this._skewX = 0;
                            this._skewY = 0;
                            this._scaleZ = 1;
                            this._rotation = 0;
                            this._rotationX = 0;
                            this._rotationY = 0;
                            this._rotationZ = 0;
                            this._width = 0;
                            this._height = 0;
                            this._opaqueBackground = null;
                            this._scrollRect = null;
                            this._filters = null;
                            this._blendMode = display.BlendMode.NORMAL;
                            // No need to take ownership: scale9Grid is never changed.
                            this._scale9Grid = this._symbol ? this._symbol.scale9Grid : null;
                            this._loaderInfo = null;
                            this._accessibilityProperties = null;
                            this._fillBounds = new Bounds(0, 0, 0, 0);
                            this._lineBounds = new Bounds(0, 0, 0, 0);
                            this._clipDepth = -1;
                            var matrixClass = this.sec.flash.geom.Matrix;
                            this._concatenatedMatrix = new matrixClass();
                            this._invertedConcatenatedMatrix = new matrixClass();
                            this._matrix = new matrixClass();
                            this._invertedMatrix = new matrixClass();
                            this._matrix3D = null;
                            this._perspectiveProjectionFOV = 55 /* FOV */;
                            this._perspectiveProjectionCenterX = 250 /* CenterX */;
                            this._perspectiveProjectionCenterY = 250 /* CenterY */;
                            var colorTransformClass = this.sec.flash.geom.ColorTransform;
                            this._colorTransform = new colorTransformClass();
                            this._concatenatedColorTransform = new colorTransformClass();
                            this._depth = -1;
                            this._ratio = 0;
                            this._index = -1;
                            this._maskedObject = null;
                            this._mouseOver = false;
                            this._mouseDown = false;
                            this._graphics = null;
                            this._children = null;
                            this._referenceCount = 0;
                        };
                        /**
                         * Sets the object's initial name to adhere to the 'instanceN' naming scheme.
                         */
                        DisplayObject.prototype._setInitialName = function () {
                            this._name = 'instance' +
                                (this.sec.flash.display.DisplayObject.axClass._instanceID++);
                        };
                        DisplayObject.prototype._setParent = function (parent, depth) {
                            var oldParent = this._parent;
                            release || assert(parent !== this);
                            this._parent = parent;
                            this._setDepth(depth);
                            if (parent) {
                                this._addReference();
                                var bubblingFlags = 0 /* None */;
                                if (this._hasFlags(8192 /* HasFrameScriptPending */)) {
                                    bubblingFlags |= 16384 /* ContainsFrameScriptPendingChildren */;
                                }
                                if (this._hasAnyDirtyFlags(1023 /* Dirty */)) {
                                    bubblingFlags |= 536870912 /* DirtyDescendents */;
                                }
                                if (this._hasAnyFlags(536920064 /* Bubbling */)) {
                                    bubblingFlags |= this._flags & 536920064 /* Bubbling */;
                                }
                                if (bubblingFlags) {
                                    parent._propagateFlagsUp(bubblingFlags);
                                }
                            }
                            if (oldParent) {
                                this._removeReference();
                            }
                        };
                        DisplayObject.prototype._setDepth = function (value) {
                            if (value > -1) {
                                this._setFlags(2048 /* OwnedByTimeline */);
                            }
                            else {
                                this._removeFlags(2048 /* OwnedByTimeline */);
                            }
                            this._depth = value;
                        };
                        DisplayObject.prototype._setFillAndLineBoundsFromWidthAndHeight = function (width, height) {
                            this._fillBounds.width = width;
                            this._fillBounds.height = height;
                            this._lineBounds.width = width;
                            this._lineBounds.height = height;
                            this._removeFlags(2 /* InvalidLineBounds */ | 4 /* InvalidFillBounds */);
                            this._invalidateParentFillAndLineBounds(true, true);
                        };
                        DisplayObject.prototype._setFillAndLineBoundsFromSymbol = function (symbol) {
                            release || assert(symbol.fillBounds || symbol.lineBounds, "Fill or Line bounds are not defined in the symbol.");
                            if (symbol.fillBounds) {
                                this._fillBounds.copyFrom(symbol.fillBounds);
                                this._removeFlags(4 /* InvalidFillBounds */);
                            }
                            if (symbol.lineBounds) {
                                this._lineBounds.copyFrom(symbol.lineBounds);
                                this._removeFlags(2 /* InvalidLineBounds */);
                            }
                            this._invalidateParentFillAndLineBounds(!!symbol.fillBounds, !!symbol.lineBounds);
                        };
                        DisplayObject.prototype._setFlags = function (flags) {
                            this._flags |= flags;
                        };
                        /**
                         * Use this to set dirty flags so that we can also propagate the dirty child bit.
                         */
                        DisplayObject.prototype._setDirtyFlags = function (flags) {
                            this._dirtyFlags |= flags;
                            if (this._parent) {
                                // Notify parent that it has a dirty descendent.
                                this._parent._propagateFlagsUp(536870912 /* DirtyDescendents */);
                            }
                        };
                        DisplayObject.prototype._removeDirtyFlags = function (flags) {
                            this._dirtyFlags &= ~flags;
                        };
                        DisplayObject.prototype._hasDirtyFlags = function (flags) {
                            return (this._dirtyFlags & flags) === flags;
                        };
                        DisplayObject.prototype._hasAnyDirtyFlags = function (flags) {
                            return !!(this._dirtyFlags & flags);
                        };
                        DisplayObject.prototype._toggleFlags = function (flags, on) {
                            if (on) {
                                this._flags |= flags;
                            }
                            else {
                                this._flags &= ~flags;
                            }
                        };
                        DisplayObject.prototype._removeFlags = function (flags) {
                            this._flags &= ~flags;
                        };
                        DisplayObject.prototype._hasFlags = function (flags) {
                            return (this._flags & flags) === flags;
                        };
                        DisplayObject.prototype._hasAnyFlags = function (flags) {
                            return !!(this._flags & flags);
                        };
                        /**
                         * Propagates flags up the display list. Propagation stops if all flags are already set.
                         */
                        DisplayObject.prototype._propagateFlagsUp = function (flags) {
                            if (this._hasFlags(flags)) {
                                return;
                            }
                            this._setFlags(flags);
                            var parent = this._parent;
                            if (parent) {
                                parent._propagateFlagsUp(flags);
                            }
                        };
                        /**
                         * Propagates flags down the display list. Non-containers just set the flags on themselves.
                         *
                         * Overridden in DisplayObjectContainer.
                         */
                        DisplayObject.prototype._propagateFlagsDown = function (flags) {
                            this._setFlags(flags);
                        };
                        /**
                         * Finds the nearest ancestor with a given set of flags that are either turned on or off.
                         */
                        DisplayObject.prototype._findNearestAncestor = function (flags, on) {
                            var node = this;
                            while (node) {
                                if (node._hasFlags(flags) === on) {
                                    return node;
                                }
                                node = node._parent;
                            }
                            return null;
                        };
                        DisplayObject.prototype._findFurthestAncestorOrSelf = function () {
                            var node = this;
                            while (node) {
                                if (!node._parent) {
                                    return node;
                                }
                                node = node._parent;
                            }
                        };
                        /**
                         * Tests if this display object is an ancestor of the specified display object.
                         */
                        DisplayObject.prototype._isAncestor = function (child) {
                            var node = child;
                            while (node) {
                                if (node === this) {
                                    return true;
                                }
                                node = node._parent;
                            }
                            return false;
                        };
                        /**
                         * Clamps the rotation value to the range (-180, 180).
                         */
                        DisplayObject._clampRotation = function (value) {
                            value %= 360;
                            if (value > 180) {
                                value -= 360;
                            }
                            else if (value < -180) {
                                value += 360;
                            }
                            return value;
                        };
                        /**
                         * Return's a list of ancestors excluding the |last|, the return list is reused.
                         */
                        DisplayObject._getAncestors = function (node, last) {
                            var path = DisplayObject._path;
                            path.length = 0;
                            while (node && node !== last) {
                                path.push(node);
                                node = node._parent;
                            }
                            release || assert(node === last, "Last ancestor is not an ancestor.");
                            return path;
                        };
                        /**
                         * Computes the combined transformation matrixes of this display object and all of its parents.
                         * It is not the same as |transform.concatenatedMatrix|, the latter also includes the screen
                         * space matrix.
                         */
                        DisplayObject.prototype._getConcatenatedMatrix = function () {
                            if (this._hasFlags(32 /* InvalidConcatenatedMatrix */)) {
                                if (this._parent) {
                                    this._parent._getConcatenatedMatrix().preMultiplyInto(this._getMatrix(), this._concatenatedMatrix);
                                }
                                else {
                                    this._concatenatedMatrix.copyFrom(this._getMatrix());
                                }
                                this._removeFlags(32 /* InvalidConcatenatedMatrix */);
                            }
                            return this._concatenatedMatrix;
                        };
                        DisplayObject.prototype._getInvertedConcatenatedMatrix = function () {
                            if (this._hasFlags(64 /* InvalidInvertedConcatenatedMatrix */)) {
                                this._getConcatenatedMatrix().invertInto(this._invertedConcatenatedMatrix);
                                this._removeFlags(64 /* InvalidInvertedConcatenatedMatrix */);
                            }
                            return this._invertedConcatenatedMatrix;
                        };
                        DisplayObject.prototype._setMatrix = function (matrix, toTwips) {
                            if (!toTwips && this._matrix.equals(matrix)) {
                                // No need to dirty the matrix if it's equal to the current matrix.
                                return;
                            }
                            var m = this._matrix;
                            m.copyFrom(matrix);
                            if (toTwips) {
                                m.toTwipsInPlace();
                            }
                            this._scaleX = m.getScaleX();
                            this._scaleY = m.getScaleY();
                            this._skewX = matrix.getSkewX();
                            this._skewY = matrix.getSkewY();
                            this._rotation = DisplayObject._clampRotation(this._skewY * 180 / Math.PI);
                            this._removeFlags(8 /* InvalidMatrix */);
                            this._setFlags(16 /* InvalidInvertedMatrix */);
                            this._setDirtyFlags(1 /* DirtyMatrix */);
                            this._invalidatePosition();
                        };
                        /**
                         * Returns an updated matrix if the current one is invalid.
                         */
                        DisplayObject.prototype._getMatrix = function () {
                            if (this._hasFlags(8 /* InvalidMatrix */)) {
                                this._matrix.updateScaleAndRotation(this._scaleX, this._scaleY, this._skewX, this._skewY);
                                this._removeFlags(8 /* InvalidMatrix */);
                            }
                            return this._matrix;
                        };
                        DisplayObject.prototype._getInvertedMatrix = function () {
                            if (this._hasFlags(16 /* InvalidInvertedMatrix */)) {
                                this._getMatrix().invertInto(this._invertedMatrix);
                                this._removeFlags(16 /* InvalidInvertedMatrix */);
                            }
                            return this._invertedMatrix;
                        };
                        /**
                         * Computes the combined transformation color matrixes of this display object and all of its
                         * ancestors.
                         */
                        DisplayObject.prototype._getConcatenatedColorTransform = function () {
                            if (!this.stage) {
                                return this._colorTransform.clone();
                            }
                            // Compute the concatenated color transforms for this node and all of its ancestors.
                            if (this._hasFlags(128 /* InvalidConcatenatedColorTransform */)) {
                                var ancestor = this._findNearestAncestor(128 /* InvalidConcatenatedColorTransform */, false);
                                var path = DisplayObject._getAncestors(this, ancestor);
                                var i = path.length - 1;
                                var stageClass = this.sec.flash.display.Stage;
                                if (stageClass.axIsType(path[i])) {
                                    i--;
                                }
                                var m = ancestor && !stageClass.axIsType(ancestor) ?
                                    ancestor._concatenatedColorTransform.clone() :
                                    new this.sec.flash.geom.ColorTransform();
                                while (i >= 0) {
                                    ancestor = path[i--];
                                    release || assert(ancestor._hasFlags(128 /* InvalidConcatenatedColorTransform */));
                                    m.preMultiply(ancestor._colorTransform);
                                    m.convertToFixedPoint();
                                    ancestor._concatenatedColorTransform.copyFrom(m);
                                    ancestor._removeFlags(128 /* InvalidConcatenatedColorTransform */);
                                }
                            }
                            return this._concatenatedColorTransform;
                        };
                        DisplayObject.prototype._setColorTransform = function (colorTransform) {
                            if (this._colorTransform.equals(colorTransform)) {
                                return;
                            }
                            this._colorTransform.copyFrom(colorTransform);
                            this._colorTransform.convertToFixedPoint();
                            this._propagateFlagsDown(128 /* InvalidConcatenatedColorTransform */);
                            this._setDirtyFlags(64 /* DirtyColorTransform */);
                        };
                        /**
                         * Invalidates the fill- and lineBounds of this display object along with all of its ancestors.
                         */
                        DisplayObject.prototype._invalidateFillAndLineBounds = function (fill, line) {
                            /* TODO: We should only propagate this bit if the bounds are actually changed. We can do the
                             * bounds computation eagerly if the number of children is low. If there are no changes in the
                             * bounds we don't need to propagate the bit. */
                            this._propagateFlagsUp((line ? 2 /* InvalidLineBounds */ : 0) |
                                (fill ? 4 /* InvalidFillBounds */ : 0));
                        };
                        DisplayObject.prototype._invalidateParentFillAndLineBounds = function (fill, line) {
                            if (this._parent) {
                                this._parent._invalidateFillAndLineBounds(fill, line);
                            }
                        };
                        /**
                         * Computes the bounding box for all of this display object's content, its graphics and all of
                         * its children.
                         */
                        DisplayObject.prototype._getContentBounds = function (includeStrokes) {
                            if (includeStrokes === void 0) { includeStrokes = true; }
                            // Tobias: What about filters?
                            var invalidFlag;
                            var bounds;
                            if (includeStrokes) {
                                invalidFlag = 2 /* InvalidLineBounds */;
                                bounds = this._lineBounds;
                            }
                            else {
                                invalidFlag = 4 /* InvalidFillBounds */;
                                bounds = this._fillBounds;
                            }
                            if (this._hasFlags(invalidFlag)) {
                                var graphics = this._getGraphics();
                                if (graphics) {
                                    bounds.copyFrom(graphics._getContentBounds(includeStrokes));
                                }
                                else {
                                    bounds.setToSentinels();
                                }
                                this._getChildBounds(bounds, includeStrokes);
                                this._removeFlags(invalidFlag);
                            }
                            return bounds;
                        };
                        /**
                         * Empty base case: DisplayObject cannot have children, but several distinct subclasses can.
                         * Overridden in DisplayObjectContainer, SimpleButton, and AVM1Movie.
                         */
                        DisplayObject.prototype._getChildBounds = function (bounds, includeStrokes) {
                            // TSLint thinks empty methods are uncool. I think TSLint is uncool.
                        };
                        /**
                         * Gets the bounds of this display object relative to another coordinate space. The
                         * transformation matrix from the local coordinate space to the target coordinate space is
                         * computed using:
                         *
                         *   this.concatenatedMatrix * inverse(target.concatenatedMatrix)
                         *
                         * If the |targetCoordinateSpace| is |null| then assume the identity coordinate space.
                         */
                        DisplayObject.prototype._getTransformedBounds = function (targetCoordinateSpace, includeStroke) {
                            var bounds = this._getContentBounds(includeStroke).clone();
                            if (targetCoordinateSpace === this || bounds.isEmpty()) {
                                return bounds;
                            }
                            var m;
                            if (targetCoordinateSpace) {
                                m = this.sec.flash.geom.Matrix.axClass.TEMP_MATRIX;
                                var invertedTargetMatrix = targetCoordinateSpace._getInvertedConcatenatedMatrix();
                                invertedTargetMatrix.preMultiplyInto(this._getConcatenatedMatrix(), m);
                            }
                            else {
                                m = this._getConcatenatedMatrix();
                            }
                            m.transformBounds(bounds);
                            return bounds;
                        };
                        /**
                         * Detaches this object from being animated by the timeline. This happens whenever a display
                         * property of this object is changed by user code.
                         */
                        DisplayObject.prototype._stopTimelineAnimation = function () {
                            this._removeFlags(4096 /* AnimatedByTimeline */);
                        };
                        /**
                         * Marks this object as having its matrix changed.
                         *
                         * Propagates flags both up- and (via invalidatePosition) downwards, so is quite costly.
                         * TODO: check if we can usefully combine all upwards-propagated flags here.
                         */
                        DisplayObject.prototype._invalidateMatrix = function () {
                            this._setDirtyFlags(1 /* DirtyMatrix */);
                            this._setFlags(8 /* InvalidMatrix */ | 16 /* InvalidInvertedMatrix */);
                            this._invalidatePosition();
                        };
                        /**
                         * Marks this object as having been moved in its parent display object.
                         */
                        DisplayObject.prototype._invalidatePosition = function () {
                            this._propagateFlagsDown(32 /* InvalidConcatenatedMatrix */ |
                                64 /* InvalidInvertedConcatenatedMatrix */);
                            this._invalidateParentFillAndLineBounds(true, true);
                        };
                        /**
                         * Animates this object's display properties.
                         */
                        DisplayObject.prototype._animate = function (placeObjectTag) {
                            release || assert(this._hasFlags(4096 /* AnimatedByTimeline */));
                            var reset = !(placeObjectTag.flags & 1 /* Move */) &&
                                placeObjectTag.flags & 2 /* HasCharacter */;
                            var matrixClass = this.sec.flash.geom.Matrix.axClass;
                            if (placeObjectTag.flags & 4 /* HasMatrix */) {
                                matrixClass.TEMP_MATRIX.copyFromUntyped(placeObjectTag.matrix);
                                this._setMatrix(matrixClass.TEMP_MATRIX, false);
                            }
                            else if (reset) {
                                this._setMatrix(matrixClass.FROZEN_IDENTITY_MATRIX, false);
                            }
                            var colorTransformClass = this.sec.flash.geom.ColorTransform.axClass;
                            if (placeObjectTag.flags & 8 /* HasColorTransform */) {
                                colorTransformClass.TEMP_COLOR_TRANSFORM.copyFromUntyped(placeObjectTag.cxform);
                                this._setColorTransform(colorTransformClass.TEMP_COLOR_TRANSFORM);
                            }
                            else if (reset) {
                                this._setColorTransform(colorTransformClass.FROZEN_IDENTITY_COLOR_TRANSFORM);
                            }
                            if (placeObjectTag.flags & 16 /* HasRatio */ || reset) {
                                var ratio = placeObjectTag.ratio | 0;
                                if (ratio !== this._ratio) {
                                    release || assert(ratio >= 0 && ratio <= 0xffff);
                                    this._ratio = ratio;
                                    this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                                }
                            }
                            if (placeObjectTag.flags & 64 /* HasClipDepth */ || reset) {
                                var clipDepth = placeObjectTag.clipDepth === undefined ? -1 : placeObjectTag.clipDepth;
                                if (clipDepth !== this._clipDepth) {
                                    this._clipDepth = clipDepth;
                                    this._setDirtyFlags(256 /* DirtyClipDepth */);
                                }
                            }
                            if (placeObjectTag.flags & 256 /* HasFilterList */) {
                                var filtersPackage = this.sec.flash.filters;
                                var filters = [];
                                var swfFilters = placeObjectTag.filters;
                                for (var i = 0; i < swfFilters.length; i++) {
                                    var obj = swfFilters[i];
                                    var filter;
                                    switch (obj.type) {
                                        case 0:
                                            filter = filtersPackage.DropShadowFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 1:
                                            filter = filtersPackage.BlurFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 2:
                                            filter = filtersPackage.GlowFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 3:
                                            filter = filtersPackage.BevelFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 4:
                                            filter = filtersPackage.GradientGlowFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 5:
                                            filter = filtersPackage.ConvolutionFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 6:
                                            filter = filtersPackage.ColorMatrixFilter.axClass.FromUntyped(obj);
                                            break;
                                        case 7:
                                            filter = filtersPackage.GradientBevelFilter.axClass.FromUntyped(obj);
                                            break;
                                        default:
                                            release || assert(filter, "Unknown filter type.");
                                    }
                                    filters.push(filter);
                                }
                                this._filters = filters;
                                this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                            }
                            else if (reset && this._filters) {
                                this._filters = null;
                                this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                            }
                            if (placeObjectTag.flags & 512 /* HasBlendMode */ || reset) {
                                var blendMode = flash.display.BlendMode.fromNumber(placeObjectTag.blendMode === undefined ?
                                    1 : placeObjectTag.blendMode);
                                if (blendMode !== this._blendMode) {
                                    this._blendMode = blendMode;
                                    this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                                }
                            }
                            if (placeObjectTag.flags & 1024 /* HasCacheAsBitmap */ || reset) {
                                var cacheAsBitmap = placeObjectTag.bmpCache > 0;
                                if (cacheAsBitmap !== this._hasFlags(65536 /* CacheAsBitmap */)) {
                                    this._toggleFlags(65536 /* CacheAsBitmap */, cacheAsBitmap);
                                    this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                                }
                            }
                            if (placeObjectTag.flags & 8192 /* HasVisible */ || reset) {
                                var visible = placeObjectTag.visibility === undefined || placeObjectTag.visibility;
                                if (visible !== this._hasFlags(1 /* Visible */)) {
                                    this._toggleFlags(1 /* Visible */, visible);
                                    this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                                }
                            }
                        };
                        /**
                         * Dispatches an event on this object and all its descendants.
                         */
                        DisplayObject.prototype._propagateEvent = function (event) {
                            this.visit(function (node) {
                                node.dispatchEvent(event);
                                return 0 /* Continue */;
                            }, 0 /* None */);
                        };
                        Object.defineProperty(DisplayObject.prototype, "x", {
                            get: function () {
                                return this._getX();
                            },
                            set: function (value) {
                                value = (value * 20) | 0;
                                this._stopTimelineAnimation();
                                if (this._canHaveTextContent()) {
                                    var bounds = this._getContentBounds();
                                    value -= bounds.xMin;
                                }
                                if (value === this._matrix.tx) {
                                    return;
                                }
                                this._matrix.tx = value;
                                this._invertedMatrix.tx = -value;
                                this._invalidatePosition();
                                this._setDirtyFlags(1 /* DirtyMatrix */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getX = function () {
                            var value = this._matrix.tx;
                            if (this._canHaveTextContent()) {
                                var bounds = this._getContentBounds();
                                value += bounds.xMin;
                            }
                            return value / 20;
                        };
                        Object.defineProperty(DisplayObject.prototype, "y", {
                            get: function () {
                                return this._getY();
                            },
                            set: function (value) {
                                value = (value * 20) | 0;
                                this._stopTimelineAnimation();
                                if (this._canHaveTextContent()) {
                                    var bounds = this._getContentBounds();
                                    value -= bounds.yMin;
                                }
                                if (value === this._matrix.ty) {
                                    return;
                                }
                                this._matrix.ty = value;
                                this._invertedMatrix.ty = -value;
                                this._invalidatePosition();
                                this._setDirtyFlags(1 /* DirtyMatrix */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getY = function () {
                            var value = this._matrix.ty;
                            if (this._canHaveTextContent()) {
                                var bounds = this._getContentBounds();
                                value += bounds.yMin;
                            }
                            return value / 20;
                        };
                        Object.defineProperty(DisplayObject.prototype, "scaleX", {
                            /**
                             * In Flash player, this always returns a positive number for some reason. This however, is not
                             * the case for scaleY.
                             */
                            get: function () {
                                return Math.abs(this._scaleX);
                            },
                            set: function (value) {
                                value = +value;
                                this._stopTimelineAnimation();
                                if (value === this._scaleX) {
                                    return;
                                }
                                this._scaleX = value;
                                this._invalidateMatrix();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "scaleY", {
                            get: function () {
                                return this._scaleY;
                            },
                            set: function (value) {
                                value = +value;
                                this._stopTimelineAnimation();
                                if (value === this._scaleY) {
                                    return;
                                }
                                this._scaleY = value;
                                this._invalidateMatrix();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "scaleZ", {
                            get: function () {
                                return this._scaleZ;
                            },
                            set: function (value) {
                                value = +value;
                                release || somewhatImplemented("public DisplayObject::set scaleZ");
                                this._scaleZ = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "rotation", {
                            get: function () {
                                return this._rotation;
                            },
                            set: function (value) {
                                value = +value;
                                this._stopTimelineAnimation();
                                value = DisplayObject._clampRotation(value);
                                if (value === this._rotation) {
                                    return;
                                }
                                var delta = value - this._rotation;
                                var angle = delta / 180 * Math.PI;
                                this._skewX += angle;
                                this._skewY += angle;
                                this._rotation = value;
                                this._invalidateMatrix();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "rotationX", {
                            get: function () {
                                return this._rotationX;
                            },
                            set: function (value) {
                                value = +value;
                                release || somewhatImplemented("public DisplayObject::set rotationX");
                                this._rotationZ = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "rotationY", {
                            get: function () {
                                return this._rotationY;
                            },
                            set: function (value) {
                                value = +value;
                                release || somewhatImplemented("public DisplayObject::set rotationY");
                                this._rotationY = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "rotationZ", {
                            get: function () {
                                return this._rotationZ;
                            },
                            set: function (value) {
                                value = +value;
                                release || somewhatImplemented("public DisplayObject::set rotationZ");
                                this._rotationZ = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "width", {
                            /**
                             * The width of this display object in its parent coordinate space.
                             */
                            get: function () {
                                return this._getWidth();
                            },
                            /**
                             * Attempts to change the width of this display object by changing its scaleX / scaleY
                             * properties. The scaleX property is set to the specified |width| value / baseWidth
                             * of the object in its parent cooridnate space with rotation applied.
                             */
                            set: function (value) {
                                this._setWidth(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        // `get width` is overriden in `Stage` and has to be able to call this.
                        DisplayObject.prototype._getWidth = function () {
                            return this._getTransformedBounds(this._parent, true).width / 20;
                        };
                        // `set width` is overriden in `Stage` and has to be able to call this.
                        DisplayObject.prototype._setWidth = function (value) {
                            value = (value * 20) | 0;
                            this._stopTimelineAnimation();
                            if (value < 0) {
                                return;
                            }
                            var contentBounds = this._getContentBounds(true);
                            if (this._canHaveTextContent()) {
                                var bounds = this._getContentBounds();
                                this._setFillAndLineBoundsFromWidthAndHeight(value, contentBounds.height);
                                return;
                            }
                            var bounds = this._getTransformedBounds(this._parent, true);
                            var angle = this._rotation / 180 * Math.PI;
                            var baseWidth = contentBounds.getBaseWidth(angle);
                            if (!baseWidth) {
                                return;
                            }
                            var baseHeight = contentBounds.getBaseHeight(angle);
                            this._scaleY = bounds.height / baseHeight;
                            this._scaleX = value / baseWidth;
                            this._invalidateMatrix();
                        };
                        Object.defineProperty(DisplayObject.prototype, "height", {
                            /**
                             * The height of this display object in its parent coordinate space.
                             */
                            get: function () {
                                return this._getHeight();
                            },
                            /**
                             * Attempts to change the height of this display object by changing its scaleY / scaleX
                             * properties. The scaleY property is set to the specified |height| value / baseHeight
                             * of the object in its parent cooridnate space with rotation applied.
                             */
                            set: function (value) {
                                this._setHeight(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        // `get height` is overriden in `Stage` and has to be able to call this.
                        DisplayObject.prototype._getHeight = function () {
                            var bounds = this._getTransformedBounds(this._parent, true);
                            return bounds.height / 20;
                        };
                        // `set height` is overriden in `Stage` and has to be able to call this.
                        DisplayObject.prototype._setHeight = function (value) {
                            value = (value * 20) | 0;
                            this._stopTimelineAnimation();
                            if (value < 0) {
                                return;
                            }
                            var contentBounds = this._getContentBounds(true);
                            if (this._canHaveTextContent()) {
                                var bounds = this._getContentBounds();
                                this._setFillAndLineBoundsFromWidthAndHeight(contentBounds.width, value);
                                return;
                            }
                            var bounds = this._getTransformedBounds(this._parent, true);
                            var angle = this._rotation / 180 * Math.PI;
                            var baseHeight = contentBounds.getBaseHeight(angle);
                            if (!baseHeight) {
                                return;
                            }
                            var baseWidth = contentBounds.getBaseWidth(angle);
                            this._scaleY = value / baseHeight;
                            this._scaleX = bounds.width / baseWidth;
                            this._invalidateMatrix();
                        };
                        Object.defineProperty(DisplayObject.prototype, "mask", {
                            get: function () {
                                return this._mask;
                            },
                            /**
                             * Sets the mask for this display object. This does not affect the bounds.
                             */
                            set: function (value) {
                                if (this._mask === value || value === this) {
                                    return;
                                }
                                if (value && value._maskedObject) {
                                    value._maskedObject.mask = null;
                                }
                                if (this._mask) {
                                    this._mask._maskedObject = null;
                                }
                                this._mask = value;
                                if (value) {
                                    value._maskedObject = this;
                                }
                                this._setDirtyFlags(128 /* DirtyMask */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "transform", {
                            get: function () {
                                return this._getTransform();
                            },
                            set: function (value) {
                                this._stopTimelineAnimation();
                                if (value.matrix3D) {
                                    this._matrix3D = value.matrix3D;
                                }
                                else {
                                    this._setMatrix(value.matrix, true);
                                }
                                this._setColorTransform(value.colorTransform);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getTransform = function () {
                            return new this.sec.flash.geom.Transform(this);
                        };
                        DisplayObject.prototype.destroy = function () {
                            this._setFlags(512 /* Destroyed */);
                        };
                        Object.defineProperty(DisplayObject.prototype, "root", {
                            /**
                             * Walks up the tree to find this display object's root. An object is classified
                             * as a root if its _root property points to itself. Root objects are the Stage,
                             * the main timeline object and a Loader's content.
                             */
                            get: function () {
                                var node = this;
                                do {
                                    if (node._root === node) {
                                        return node;
                                    }
                                    node = node._parent;
                                } while (node);
                                return null;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "stage", {
                            /**
                             * Walks up the tree to find this display object's stage, the first object whose
                             * |_stage| property points to itself.
                             */
                            get: function () {
                                var node = this;
                                do {
                                    if (node._stage === node) {
                                        release || assert(this.sec.flash.display.Stage.axIsType(node));
                                        return node;
                                    }
                                    node = node._parent;
                                } while (node);
                                return null;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "name", {
                            get: function () {
                                return this._name;
                            },
                            set: function (value) {
                                checkNullParameter(value, "name", this.sec);
                                if (this._hasFlags(2048 /* OwnedByTimeline */)) {
                                    // In AVM2, setting the name of a timline-placed DisplayObject throws.
                                    if (this._symbol && !this._symbol.isAVM1Object) {
                                        this.sec.throwError('IllegalOperationError', AVMX.Errors.TimelineObjectNameSealedError);
                                    }
                                    return;
                                }
                                this._name = axCoerceString(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "parent", {
                            get: function () {
                                return this._parent;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "alpha", {
                            get: function () {
                                return this._colorTransform.alphaMultiplier;
                            },
                            set: function (value) {
                                this._stopTimelineAnimation();
                                value = +value;
                                if (value === this._colorTransform.alphaMultiplier) {
                                    return;
                                }
                                this._colorTransform.alphaMultiplier = value;
                                this._colorTransform.convertToFixedPoint();
                                this._propagateFlagsDown(128 /* InvalidConcatenatedColorTransform */);
                                this._setDirtyFlags(64 /* DirtyColorTransform */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "blendMode", {
                            get: function () {
                                return this._blendMode;
                            },
                            set: function (value) {
                                this._stopTimelineAnimation();
                                value = axCoerceString(value);
                                if (value === this._blendMode) {
                                    return;
                                }
                                if (display.BlendMode.toNumber(value) < 0) {
                                    this.sec.throwError("ArgumentError", AVMX.Errors.InvalidEnumError, "blendMode");
                                }
                                this._blendMode = value;
                                this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "scale9Grid", {
                            get: function () {
                                return this._getScale9Grid();
                            },
                            set: function (innerRectangle) {
                                this._stopTimelineAnimation();
                                this._scale9Grid = Bounds.FromRectangle(innerRectangle);
                                this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getScale9Grid = function () {
                            var rectangleClass = this.sec.flash.geom.Rectangle.axClass;
                            return this._scale9Grid ? rectangleClass.FromBounds(this._scale9Grid) : null;
                        };
                        Object.defineProperty(DisplayObject.prototype, "cacheAsBitmap", {
                            /**
                             * This is always true if a filter is applied.
                             */
                            get: function () {
                                return this._getCacheAsBitmap();
                            },
                            set: function (value) {
                                if (this._hasFlags(65536 /* CacheAsBitmap */)) {
                                    return;
                                }
                                this._toggleFlags(65536 /* CacheAsBitmap */, !!value);
                                this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getCacheAsBitmap = function () {
                            return (this._filters && this._filters.length > 0) || this._hasFlags(65536 /* CacheAsBitmap */);
                        };
                        Object.defineProperty(DisplayObject.prototype, "filters", {
                            /**
                             * References to the internal |_filters| array and its BitmapFilter objects are never leaked
                             * outside of this class. The get/set filters accessors always return deep clones of this
                             * array.
                             */
                            get: function () {
                                return this._getFilters();
                            },
                            set: function (value_) {
                                var value = value_ ? value_.value : null;
                                if (!this._filters) {
                                    this._filters = [];
                                }
                                var changed = false;
                                if (isNullOrUndefined(value)) {
                                    changed = this._filters.length > 0;
                                    this._filters.length = 0;
                                }
                                else {
                                    var bitmapFilterClass = this.sec.flash.filters.BitmapFilter.axClass;
                                    this._filters = value.map(function (x) {
                                        if (!bitmapFilterClass.axIsType(x)) {
                                            this.sec.throwError('TypeError', AVMX.Errors.ParamTypeError, '0', 'Filter');
                                        }
                                        return x.clone();
                                    });
                                    changed = true;
                                }
                                if (changed) {
                                    this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getFilters = function () {
                            var filters = this._filters ? this._filters.map(function (x) {
                                return x.clone();
                            }) : [];
                            return this.sec.createArray(filters);
                        };
                        Object.defineProperty(DisplayObject.prototype, "visible", {
                            get: function () {
                                return this._hasFlags(1 /* Visible */);
                            },
                            /**
                             * Marks this display object as visible / invisible. This does not affect the bounds.
                             */
                            set: function (value) {
                                value = !!value;
                                if (value === this._hasFlags(1 /* Visible */)) {
                                    return;
                                }
                                this._toggleFlags(1 /* Visible */, value);
                                this._setDirtyFlags(512 /* DirtyMiscellaneousProperties */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "z", {
                            get: function () {
                                return this._z;
                            },
                            set: function (value) {
                                value = +value;
                                this._z = value;
                                release || somewhatImplemented("public DisplayObject::set z");
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype.getBounds = function (targetCoordinateSpace) {
                            targetCoordinateSpace = targetCoordinateSpace || this;
                            var rectangleClass = this.sec.flash.geom.Rectangle.axClass;
                            return rectangleClass.FromBounds(this._getTransformedBounds(targetCoordinateSpace, true));
                        };
                        DisplayObject.prototype.getRect = function (targetCoordinateSpace) {
                            targetCoordinateSpace = targetCoordinateSpace || this;
                            var rectangleClass = this.sec.flash.geom.Rectangle.axClass;
                            return rectangleClass.FromBounds(this._getTransformedBounds(targetCoordinateSpace, false));
                        };
                        /**
                         * Converts a point from the global coordinate space into the local coordinate space.
                         */
                        DisplayObject.prototype.globalToLocal = function (point) {
                            var m = this._getInvertedConcatenatedMatrix();
                            var p = m.transformPointInPlace(point.clone().toTwips()).round();
                            return p.toPixels();
                        };
                        /**
                         * Converts a point form the local coordinate sapce into the global coordinate space.
                         */
                        DisplayObject.prototype.localToGlobal = function (point) {
                            var m = this._getConcatenatedMatrix();
                            var p = m.transformPointInPlace(point.clone().toTwips()).round();
                            return p.toPixels();
                        };
                        DisplayObject.prototype.globalToLocal3D = function (point) {
                            release || notImplemented("public DisplayObject::globalToLocal3D");
                            return null;
                        };
                        DisplayObject.prototype.localToGlobal3D = function (point) {
                            release || notImplemented("public DisplayObject::localToGlobal3D");
                            return null;
                        };
                        DisplayObject.prototype.local3DToGlobal = function (point3d) {
                            release || notImplemented("public DisplayObject::local3DToGlobal");
                            return null;
                        };
                        /**
                         * Tree visitor that lets you skip nodes or return early.
                         */
                        DisplayObject.prototype.visit = function (visitor, visitorFlags, displayObjectFlags) {
                            if (displayObjectFlags === void 0) { displayObjectFlags = 0 /* None */; }
                            var stack;
                            var displayObject;
                            var displayObjectContainer;
                            var frontToBack = visitorFlags & 8 /* FrontToBack */;
                            stack = [this];
                            while (stack.length > 0) {
                                displayObject = stack.pop();
                                var flags = 0 /* None */;
                                if (visitorFlags & 16 /* Filter */ && !displayObject._hasAnyFlags(displayObjectFlags)) {
                                    flags = 2 /* Skip */;
                                }
                                else {
                                    flags = visitor(displayObject);
                                }
                                if (flags === 0 /* Continue */) {
                                    var children = displayObject._children;
                                    if (children) {
                                        var length = children.length;
                                        for (var i = 0; i < length; i++) {
                                            var child = children[frontToBack ? i : length - 1 - i];
                                            stack.push(child);
                                        }
                                    }
                                }
                                else if (flags === 1 /* Stop */) {
                                    return;
                                }
                            }
                        };
                        Object.defineProperty(DisplayObject.prototype, "loaderInfo", {
                            /**
                             * Returns the loader info for this display object's root.
                             */
                            get: function () {
                                var root = this.root;
                                if (root) {
                                    release || assert(root._loaderInfo, "No LoaderInfo object found on root.");
                                    return root._loaderInfo;
                                }
                                return null;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * Only these objects can have graphics.
                         */
                        DisplayObject.prototype._canHaveGraphics = function () {
                            return false;
                        };
                        /**
                         * Gets the graphics object of this object. Shapes, MorphShapes, and Sprites override this.
                         */
                        DisplayObject.prototype._getGraphics = function () {
                            return null;
                        };
                        /**
                         * Only these objects can have text content.
                         */
                        DisplayObject.prototype._canHaveTextContent = function () {
                            return false;
                        };
                        /**
                         * Gets the text content of this object. StaticTexts and TextFields override this.
                         */
                        DisplayObject.prototype._getTextContent = function () {
                            return null;
                        };
                        /**
                         * Lazily construct a graphics object.
                         */
                        DisplayObject.prototype._ensureGraphics = function () {
                            release || assert(this._canHaveGraphics());
                            if (this._graphics) {
                                return this._graphics;
                            }
                            this._graphics = new this.sec.flash.display.Graphics();
                            this._graphics._setParent(this);
                            this._invalidateFillAndLineBounds(true, true);
                            this._setDirtyFlags(4 /* DirtyGraphics */);
                            return this._graphics;
                        };
                        /**
                         * Sets this object's graphics or text content. Happens when an animated Shape or StaticText
                         * object is initialized from a symbol or replaced by a timeline command using the same symbol
                         * as this object was initialized from.
                         */
                        DisplayObject.prototype._setStaticContentFromSymbol = function (symbol) {
                            release || assert(!symbol.dynamic);
                            if (symbol instanceof flash.display.ShapeSymbol) {
                                release || assert(this._canHaveGraphics());
                                var newGraphics = symbol.graphics;
                                if (this._graphics === newGraphics) {
                                    return;
                                }
                                this._graphics = newGraphics;
                                this._setDirtyFlags(4 /* DirtyGraphics */);
                            }
                            else if (symbol instanceof flash.text.TextSymbol) {
                                release || assert(this.sec.flash.text.StaticText.axIsType(this));
                                var newTextContent = symbol.textContent;
                                if (this._textContent === newTextContent) {
                                    return;
                                }
                                this._textContent = newTextContent;
                                this._setDirtyFlags(8 /* DirtyTextContent */);
                            }
                            this._symbol = symbol;
                            this._setFillAndLineBoundsFromSymbol(symbol);
                        };
                        /**
                         * Checks if the bounding boxes of two display objects overlap, this happens in the global
                         * coordinate coordinate space.
                         *
                         * Two objects overlap even if one or both are not on the stage, as long as their bounds
                         * in the global coordinate space overlap.
                         */
                        DisplayObject.prototype.hitTestObject = function (other) {
                            release || assert(other && this.sec.flash.display.DisplayObject.axIsType(other));
                            var a = this, b = other;
                            var aBounds = a._getContentBounds(false).clone();
                            var bBounds = b._getContentBounds(false).clone();
                            a._getConcatenatedMatrix().transformBounds(aBounds);
                            b._getConcatenatedMatrix().transformBounds(bBounds);
                            return aBounds.intersects(bBounds);
                        };
                        /**
                         * The |globalX| and |globalY| arguments are in global coordinates. The |shapeFlag| indicates
                         * whether the hit test should be on the actual shape of the object or just its bounding box.
                         *
                         * Note: shapeFlag is optional, but the type coercion will do the right thing for it, so we
                         * don't need to take the overhead from being explicit about that.
                         */
                        DisplayObject.prototype.hitTestPoint = function (globalX, globalY, shapeFlag) {
                            globalX = +globalX * 20 | 0;
                            globalY = +globalY * 20 | 0;
                            shapeFlag = !!shapeFlag;
                            var testingType = shapeFlag ?
                                2 /* HitTestShape */ :
                                0 /* HitTestBounds */;
                            return !!this._containsGlobalPoint(globalX, globalY, testingType, null);
                        };
                        /**
                         * Internal implementation of all point intersection checks.
                         *
                         * _containsPoint is used for
                         *  - mouse/drop target finding
                         *  - getObjectsUnderPoint
                         *  - hitTestPoint
                         *
                         * Mouse/Drop target finding and getObjectsUnderPoint require checking against the exact shape,
                         * and making sure that the checked coordinates aren't hidden through masking or clipping.
                         *
                         * hitTestPoint never checks for clipping, and masking only for testingType HitTestShape.
                         *
                         * The `objects` object is used for collecting objects for `getObjectsUnderPoint` or looking
                         * for a drop target. If it is supplied, objects for which `_containsPointDirectly` is true are
                         * added to it.
                         *
                         * Overridden in DisplayObjectContainer, Sprite and SimpleButton.
                         */
                        DisplayObject.prototype._containsPoint = function (globalX, globalY, localX, localY, testingType, objects) {
                            var result = this._boundsAndMaskContainPoint(globalX, globalY, localX, localY, testingType);
                            // We're done if either we don't have a hit, or if we're only interested in matching bounds
                            // or bounds + mask. That is true for HitTestPoint without shapeFlag set.
                            if (result === 0 /* None */ || testingType < 2 /* HitTestShape */) {
                                return result;
                            }
                            var containsPoint = this._containsPointDirectly(localX, localY, globalX, globalY);
                            if (containsPoint && objects) {
                                if (testingType === 5 /* Drop */) {
                                    // For Drop, replace previous hit with current one.
                                    objects[0] = this;
                                }
                                else if (testingType === 4 /* ObjectsUnderPoint */ ||
                                    this.sec.flash.display.InteractiveObject.axIsType(this) &&
                                        this._mouseEnabled) {
                                    // For getObjectsUnderPoint, push all direct hits, for mouse target finding
                                    // InteractiveObjects only.
                                    objects.push(this);
                                }
                            }
                            return containsPoint ? 2 /* Shape */ : result;
                        };
                        DisplayObject.prototype._containsGlobalPoint = function (globalX, globalY, testingType, objects) {
                            var matrix = this._getInvertedConcatenatedMatrix();
                            var localX = matrix.transformX(globalX, globalY);
                            var localY = matrix.transformY(globalX, globalY);
                            return this._containsPoint(globalX, globalY, localX, localY, testingType, objects);
                        };
                        /**
                         * Fast check if a point can intersect the receiver object. Returns true if
                         * - the object is visible OR hit testing is performed for one of the `hitTest{Point,Object}`
                         *   methods.
                         * - the point is within the receiver's bounds
                         * - for testingType values other than HitTestBounds, the point intersects with the a mask,
                         *   if the object has one.
                         *
                         * Note that the callers are expected to have both local and global coordinates available
                         * anyway, so _boundsAndMaskContainPoint takes both to avoid recalculating them.
                         */
                        DisplayObject.prototype._boundsAndMaskContainPoint = function (globalX, globalY, localX, localY, testingType) {
                            if (testingType >= 1 /* HitTestBoundsAndMask */ &&
                                this._hasFlags(32768 /* ContainsMorph */)) {
                                // If this display object is a MorphShape or contains at least one descendant that is, then
                                // bailing out too early might lead to a wrong hit test result, since the reported bounds
                                // of MorphShapes are always the one of their start shapes and don't take the current morph
                                // ratio into account. We have to make sure we always hit test MorphShape instances on
                                // graphics level.
                                return 1 /* Bounds */;
                            }
                            if (testingType >= 3 /* Mouse */ && !this._hasFlags(1 /* Visible */) ||
                                !this._getContentBounds().contains(localX, localY)) {
                                return 0 /* None */;
                            }
                            if (testingType === 0 /* HitTestBounds */ || !this._mask) {
                                return 1 /* Bounds */;
                            }
                            return this._mask._containsGlobalPoint(globalX, globalY, 1 /* HitTestBoundsAndMask */, null);
                        };
                        /**
                         * Tests if the receiver's own visual content intersects with the given point.
                         * In the base implementation, this just returns false, because not all DisplayObjects can
                         * ever match.
                         * Overridden in Shape, MorphShape, Sprite, Bitmap, Video, and TextField.
                         */
                        DisplayObject.prototype._containsPointDirectly = function (localX, localY, globalX, globalY) {
                            return false;
                        };
                        Object.defineProperty(DisplayObject.prototype, "scrollRect", {
                            get: function () {
                                return this._getScrollRect();
                            },
                            set: function (value) {
                                value = value;
                                this._scrollRect = value ? value.clone() : null;
                                /* TODO: Figure out how to deal with the bounds and hit testing when scroll rects are applied.
                                 * The Flash implementation appears to be broken. */
                                release || somewhatImplemented("public DisplayObject::set scrollRect");
                                return;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype._getScrollRect = function () {
                            return this._scrollRect ? this._scrollRect.clone() : null;
                        };
                        Object.defineProperty(DisplayObject.prototype, "opaqueBackground", {
                            get: function () {
                                return this._opaqueBackground;
                            },
                            /**
                             * Sets the opaque background color. By default this is |null|, which indicates that no opaque
                             * color is set. Otherwise this is an unsinged number.
                             */
                            set: function (value) {
                                release || assert(value === null || Shumway.isInteger(value));
                                this._opaqueBackground = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * Returns the distance between this object and a given ancestor.
                         */
                        DisplayObject.prototype._getDistance = function (ancestor) {
                            var d = 0;
                            var node = this;
                            while (node && node !== ancestor) {
                                d++;
                                node = node._parent;
                            }
                            return d;
                        };
                        /**
                         * Finds the nearest common ancestor with a given node.
                         */
                        DisplayObject.prototype.findNearestCommonAncestor = function (node) {
                            if (!node) {
                                return null;
                            }
                            var ancestor = this;
                            var d1 = ancestor._getDistance(null);
                            var d2 = node._getDistance(null);
                            while (d1 > d2) {
                                ancestor = ancestor._parent;
                                d1--;
                            }
                            while (d2 > d1) {
                                node = node._parent;
                                d2--;
                            }
                            while (ancestor !== node) {
                                ancestor = ancestor._parent;
                                node = node._parent;
                            }
                            return ancestor;
                        };
                        /**
                         * Returns the current mouse position relative to this object.
                         */
                        DisplayObject.prototype._getLocalMousePosition = function () {
                            var position = this.sec.flash.ui.Mouse.axClass._currentPosition;
                            return this.globalToLocal(position);
                        };
                        Object.defineProperty(DisplayObject.prototype, "mouseX", {
                            get: function () {
                                return this._getLocalMousePosition().x;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "mouseY", {
                            get: function () {
                                return this._getLocalMousePosition().y;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        DisplayObject.prototype.debugName = function (withFlags) {
                            if (withFlags === void 0) { withFlags = false; }
                            var name = this._id + " [" + this._depth + "]: (" + this._referenceCount + ") " + this;
                            if (withFlags) {
                                var flagNames = [];
                                for (var i = 0; i < 32; i++) {
                                    if (this._hasFlags(1 << i)) {
                                        flagNames.push(String([1 << i]));
                                    }
                                }
                                name += " " + flagNames.join("|");
                            }
                            return name;
                        };
                        DisplayObject.prototype.debugNameShort = function () {
                            return "[" + this._depth + ":" + this._id + "]: (" + this._referenceCount + ") {" + this._flags + "} " + this;
                        };
                        DisplayObject.prototype.hashCode = function () {
                            return this.getBounds(null).hashCode();
                        };
                        DisplayObject.prototype.getAncestorCount = function () {
                            return 0;
                        };
                        DisplayObject.prototype.debugTrace = function (writer, maxDistance, name) {
                            if (writer === void 0) { writer = new Shumway.IndentingWriter(); }
                            if (maxDistance === void 0) { maxDistance = 1024; }
                            if (name === void 0) { name = ""; }
                            var self = this;
                            this.visit(function (node) {
                                var distance = node._getDistance(self);
                                if (distance > maxDistance) {
                                    return 2 /* Skip */;
                                }
                                var prefix = name + Shumway.StringUtilities.multiple(" ", distance);
                                writer.writeLn(prefix + node.debugNameShort() + ", bounds: " + node.getBounds(null).toString());
                                return 0 /* Continue */;
                            }, 0 /* None */);
                        };
                        DisplayObject.prototype._addReference = function () {
                            this._referenceCount++;
                        };
                        DisplayObject.prototype._removeReference = function () {
                            // TODO: Uncomment this assertion once we're sure reference counting works correctly.
                            // assert (this._referenceCount > 0);
                            this._referenceCount--;
                            if (this._referenceCount !== 0 || !this._children) {
                                return;
                            }
                            var children = this._children;
                            for (var i = 0; i < children.length; i++) {
                                children[i]._removeReference();
                            }
                        };
                        /**
                         * Returns script precedence sequence based on placeObjectTag. Creates every
                         * time a new array, so it's safe to modify it.
                         * @private
                         */
                        DisplayObject.prototype._getScriptPrecedence = function () {
                            if (!this._parent) {
                                return [];
                            }
                            var result = this._parent._getScriptPrecedence();
                            if (this._placeObjectTag) {
                                result.push(this._placeObjectTag.actionBlocksPrecedence);
                            }
                            return result;
                        };
                        Object.defineProperty(DisplayObject.prototype, "accessibilityProperties", {
                            get: function () {
                                return this._accessibilityProperties;
                            },
                            set: function (value) {
                                // In Flash this does not do copying.
                                // TODO: coerce to the correct type.
                                this._accessibilityProperties = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObject.prototype, "blendShader", {
                            set: function (value /* flash.display.Shader */) {
                                release || somewhatImplemented("public DisplayObject::set blendShader");
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * DisplayObject#name is set to an initial value of 'instanceN', where N is auto-incremented.
                         * This is true for all DisplayObjects except for Stage, so it happens in an overrideable
                         * method.
                         */
                        DisplayObject._instanceID = 1;
                        // List of static symbols to link.
                        DisplayObject.classSymbols = null; // [];
                        // List of instance symbols to link.
                        DisplayObject.instanceSymbols = null; // ["hitTestObject", "hitTestPoint"];
                        DisplayObject._runScripts = true;
                        /**
                         * Used as a temporary array to avoid allocations.
                         */
                        DisplayObject._path = [];
                        return DisplayObject;
                    })(flash.events.EventDispatcher);
                    display.DisplayObject = DisplayObject;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Bitmap
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var assert = Shumway.Debug.assert;
                    var Bitmap = (function (_super) {
                        __extends(Bitmap, _super);
                        function Bitmap(bitmapData, pixelSnapping, smoothing) {
                            if (bitmapData === void 0) { bitmapData = null; }
                            if (pixelSnapping === void 0) { pixelSnapping = "auto"; }
                            if (smoothing === void 0) { smoothing = false; }
                            if (this._symbol && !this._fieldsInitialized) {
                                this.applySymbol();
                            }
                            _super.call(this);
                            if (!this._symbol) {
                                this.bitmapData = bitmapData;
                                this._pixelSnapping = axCoerceString(pixelSnapping);
                                this._smoothing = !!smoothing;
                            }
                        }
                        Bitmap.prototype.applySymbol = function () {
                            release || assert(this._symbol);
                            this._initializeFields();
                            var symbol = this._symbol;
                            var symbolClass = symbol.symbolClass;
                            // If the symbol class inherits from Bitmap, we are already within its initializer.
                            // Make sure to create a BitmapData instance here to avoid recursively calling the
                            // initializer again.
                            var bitmapClass = this.sec.flash.display.Bitmap.axClass;
                            if (bitmapClass.dPrototype.isPrototypeOf(symbolClass.dPrototype)) {
                                symbolClass = this.sec.flash.display.BitmapData.axClass;
                            }
                            // TODO: I don't think BitmapData symbol objects can change, so they don't need back
                            // references to this Bitmap.
                            this._bitmapData = AS.constructClassFromSymbol(symbol, symbolClass);
                            this._pixelSnapping = null;
                            this._smoothing = null;
                            this._setFillAndLineBoundsFromWidthAndHeight(symbol.width * 20 | 0, symbol.height * 20 | 0);
                        };
                        Object.defineProperty(Bitmap.prototype, "pixelSnapping", {
                            get: function () {
                                return this._pixelSnapping;
                            },
                            set: function (value) {
                                if (display.PixelSnapping.toNumber(value) < 0) {
                                    this.sec.throwError("ArgumentError", AVMX.Errors.InvalidEnumError, "pixelSnapping");
                                }
                                this._pixelSnapping = axCoerceString(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Bitmap.prototype, "smoothing", {
                            get: function () {
                                return this._smoothing;
                            },
                            set: function (value) {
                                this._smoothing = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Bitmap.prototype, "bitmapData", {
                            get: function () {
                                return this._bitmapData;
                            },
                            set: function (value) {
                                if (this._bitmapData !== value) {
                                    if (this._bitmapData) {
                                        this._bitmapData._removeBitmapReferrer(this);
                                    }
                                    if (value) {
                                        value._addBitmapReferrer(this);
                                    }
                                }
                                this._bitmapData = value;
                                if (value) {
                                    this._setFillAndLineBoundsFromWidthAndHeight(value.width * 20 | 0, value.height * 20 | 0);
                                }
                                this._invalidateParentFillAndLineBounds(true, true);
                                this._setDirtyFlags(16 /* DirtyBitmapData */);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Bitmap.prototype._getContentBounds = function (includeStrokes) {
                            if (includeStrokes === void 0) { includeStrokes = true; }
                            if (this._bitmapData) {
                                return this._bitmapData._getContentBounds();
                            }
                            return new Shumway.Bounds(0, 0, 0, 0);
                        };
                        Bitmap.prototype._containsPointDirectly = function (localX, localY, globalX, globalY) {
                            // If this override is reached, the content bounds have already been checked, which is all
                            // we need to do.
                            release || assert(this._getContentBounds().contains(localX, localY));
                            return true;
                        };
                        // Called whenever the class is initialized.
                        Bitmap.classInitializer = null;
                        // List of static symbols to link.
                        Bitmap.classSymbols = null; // [];
                        // List of instance symbols to link.
                        Bitmap.instanceSymbols = null; // [];
                        return Bitmap;
                    })(flash.display.DisplayObject);
                    display.Bitmap = Bitmap;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Shape
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var assert = Shumway.Debug.assert;
                    var warning = Shumway.Debug.warning;
                    var Shape = (function (_super) {
                        __extends(Shape, _super);
                        function Shape() {
                            if (this._symbol && !this._fieldsInitialized) {
                                this.applySymbol();
                            }
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                        }
                        Shape.prototype.applySymbol = function () {
                            this._initializeFields();
                            release || assert(this._symbol);
                            // TODO: Check what do do if the computed bounds of the graphics object don't
                            // match those given by the symbol.
                            this._setStaticContentFromSymbol(this._symbol);
                        };
                        Shape.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this);
                            this._graphics = null;
                        };
                        Shape.prototype._canHaveGraphics = function () {
                            return true;
                        };
                        Shape.prototype._getGraphics = function () {
                            return this._graphics;
                        };
                        Object.defineProperty(Shape.prototype, "graphics", {
                            get: function () {
                                return this._ensureGraphics();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Shape.prototype._containsPointDirectly = function (localX, localY, globalX, globalY) {
                            var graphics = this._getGraphics();
                            return !!graphics && graphics._containsPoint(localX, localY, true, 0);
                        };
                        Shape.classInitializer = null;
                        return Shape;
                    })(flash.display.DisplayObject);
                    display.Shape = Shape;
                    var ShapeSymbol = (function (_super) {
                        __extends(ShapeSymbol, _super);
                        function ShapeSymbol(data, symbolClass) {
                            _super.call(this, data, symbolClass, false);
                            this.graphics = null;
                        }
                        ShapeSymbol.FromData = function (data, loaderInfo) {
                            var symbol = new ShapeSymbol(data, loaderInfo.sec.flash.display.Shape.axClass);
                            symbol._setBoundsFromData(data);
                            symbol.graphics = flash.display.Graphics.FromData(data, loaderInfo);
                            symbol.processRequires(data.require, loaderInfo);
                            return symbol;
                        };
                        ShapeSymbol.prototype.processRequires = function (dependencies, loaderInfo) {
                            if (!dependencies) {
                                return;
                            }
                            var textures = this.graphics.getUsedTextures();
                            for (var i = 0; i < dependencies.length; i++) {
                                var symbol = loaderInfo.getSymbolById(dependencies[i]);
                                if (!symbol) {
                                    if (dependencies[i] !== 65535) {
                                        // Id 65535 is somehow used invalidly in lots of embedded shapes created by the
                                        // authoring tool, so don't warn about that.
                                        warning("Bitmap symbol " + dependencies[i] + " required by shape, but not defined.");
                                    }
                                    textures.push(null);
                                    // TODO: handle null-textures from invalid SWFs correctly.
                                    continue;
                                }
                                textures.push(symbol.getSharedInstance());
                            }
                        };
                        return ShapeSymbol;
                    })(Shumway.Timeline.DisplaySymbol);
                    display.ShapeSymbol = ShapeSymbol;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: InteractiveObject
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var events = flash.events;
                    var InteractiveObject = (function (_super) {
                        __extends(InteractiveObject, _super);
                        function InteractiveObject() {
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                        }
                        InteractiveObject.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this);
                            this._tabEnabled = false;
                            this._tabIndex = -1;
                            this._focusRect = null;
                            this._mouseEnabled = true;
                            this._doubleClickEnabled = false;
                            this._accessibilityImplementation = null;
                            this._softKeyboardInputAreaOfInterest = null;
                            this._needsSoftKeyboard = false;
                            this._contextMenu = null;
                        };
                        Object.defineProperty(InteractiveObject.prototype, "tabEnabled", {
                            get: function () {
                                return this._tabEnabled;
                            },
                            set: function (enabled) {
                                enabled = !!enabled;
                                var old = this._tabEnabled;
                                this._tabEnabled = enabled;
                                if (old !== enabled) {
                                    this.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.TAB_ENABLED_CHANGE, true));
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "tabIndex", {
                            get: function () {
                                return this._tabIndex;
                            },
                            set: function (index /*int*/) {
                                index = index | 0;
                                var old = this._tabIndex;
                                this._tabIndex = index;
                                if (old !== index) {
                                    this.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.TAB_INDEX_CHANGE, true));
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "focusRect", {
                            get: function () {
                                return this._focusRect;
                            },
                            /**
                             * The given |focusRect| can be one of: |true|, |false| or |null|.
                             */
                            set: function (focusRect) {
                                release || somewhatImplemented("public flash.display.InteractiveObject::set focusRect");
                                this._focusRect = focusRect;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "mouseEnabled", {
                            get: function () {
                                return this._mouseEnabled;
                            },
                            set: function (enabled) {
                                this._mouseEnabled = !!enabled;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "doubleClickEnabled", {
                            get: function () {
                                return this._doubleClickEnabled;
                            },
                            set: function (enabled) {
                                this._doubleClickEnabled = !!enabled;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "accessibilityImplementation", {
                            get: function () {
                                return this._accessibilityImplementation;
                            },
                            set: function (value) {
                                release || somewhatImplemented("public flash.display.InteractiveObject::set" +
                                    " accessibilityImplementation");
                                this._accessibilityImplementation = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "softKeyboardInputAreaOfInterest", {
                            get: function () {
                                return this._softKeyboardInputAreaOfInterest;
                            },
                            set: function (value) {
                                release || somewhatImplemented("public flash.display.InteractiveObject::set" +
                                    " softKeyboardInputAreaOfInterest");
                                this._softKeyboardInputAreaOfInterest = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "needsSoftKeyboard", {
                            get: function () {
                                return this._needsSoftKeyboard;
                            },
                            set: function (value) {
                                value = !!value;
                                release || somewhatImplemented("public flash.display.InteractiveObject::set needsSoftKeyboard");
                                this._needsSoftKeyboard = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(InteractiveObject.prototype, "contextMenu", {
                            get: function () {
                                return this._contextMenu;
                            },
                            set: function (cm) {
                                cm = cm;
                                release || somewhatImplemented("public flash.display.InteractiveObject::set contextMenu");
                                this._contextMenu = cm;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        InteractiveObject.prototype.requestSoftKeyboard = function () {
                            release || somewhatImplemented("public flash.display.InteractiveObject::requestSoftKeyboard");
                            return false;
                        };
                        InteractiveObject.classInitializer = null;
                        return InteractiveObject;
                    })(flash.display.DisplayObject);
                    display.InteractiveObject = InteractiveObject;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: SimpleButton
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var assert = Shumway.Debug.assert;
                    var SimpleButton = (function (_super) {
                        __extends(SimpleButton, _super);
                        function SimpleButton(upState, overState, downState, hitTestState) {
                            if (this._symbol && !this._fieldsInitialized) {
                                this.applySymbol();
                            }
                            _super.call(this);
                            this.sec.flash.display.DisplayObject.axClass._advancableInstances.push(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                            if (!this._symbol) {
                                if (upState) {
                                    this.upState = upState;
                                }
                                if (overState) {
                                    this.overState = overState;
                                }
                                if (downState) {
                                    this.downState = downState;
                                }
                                if (hitTestState) {
                                    this.hitTestState = hitTestState;
                                }
                                this._updateButton();
                            }
                        }
                        SimpleButton.prototype.applySymbol = function () {
                            release || assert(this._symbol);
                            this._initializeFields();
                            var symbol = this._symbol;
                            if (symbol.upState) {
                                this._upState = this.createAnimatedDisplayObject(symbol.upState.symbol, symbol.upState.placeObjectTag, true);
                            }
                            if (symbol.overState) {
                                this._overState = this.createAnimatedDisplayObject(symbol.overState.symbol, symbol.overState.placeObjectTag, true);
                            }
                            if (symbol.downState) {
                                this._downState = this.createAnimatedDisplayObject(symbol.downState.symbol, symbol.downState.placeObjectTag, true);
                            }
                            if (symbol.hitTestState) {
                                this._hitTestState = this.createAnimatedDisplayObject(symbol.hitTestState.symbol, symbol.hitTestState.placeObjectTag, true);
                            }
                            this._updateButton();
                        };
                        SimpleButton.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this);
                            this._useHandCursor = true;
                            this._enabled = true;
                            this._trackAsMenu = false;
                            this._upState = null;
                            this._overState = null;
                            this._downState = null;
                            this._hitTestState = null;
                            this._currentState = null;
                            this._children = [];
                        };
                        SimpleButton.prototype._initFrame = function (advance) {
                            if (advance) {
                                this._updateButton();
                            }
                        };
                        SimpleButton.prototype._constructFrame = function () {
                            // ...
                        };
                        Object.defineProperty(SimpleButton.prototype, "useHandCursor", {
                            get: function () {
                                return this._useHandCursor;
                            },
                            set: function (value) {
                                this._useHandCursor = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "enabled", {
                            get: function () {
                                return this._enabled;
                            },
                            set: function (value) {
                                this._enabled = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "trackAsMenu", {
                            get: function () {
                                return this._trackAsMenu;
                            },
                            set: function (value) {
                                value = !!value;
                                release || notImplemented("public flash.display.SimpleButton::set trackAsMenu");
                                return;
                                // this._trackAsMenu = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "upState", {
                            get: function () {
                                return this._upState;
                            },
                            set: function (value) {
                                var old = this._upState;
                                if (value._parent) {
                                    value._parent.removeChild(value);
                                }
                                this._upState = value;
                                if (this._currentState === old) {
                                    this._updateButton();
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "overState", {
                            get: function () {
                                return this._overState;
                            },
                            set: function (value) {
                                var old = this._overState;
                                if (value._parent) {
                                    value._parent.removeChild(value);
                                }
                                this._overState = value;
                                if (this._currentState === old) {
                                    this._updateButton();
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "downState", {
                            get: function () {
                                return this._downState;
                            },
                            set: function (value) {
                                var old = this._downState;
                                if (value._parent) {
                                    value._parent.removeChild(value);
                                }
                                this._downState = value;
                                if (this._currentState === old) {
                                    this._updateButton();
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "hitTestState", {
                            get: function () {
                                return this._hitTestState;
                            },
                            set: function (value) {
                                this._hitTestState = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(SimpleButton.prototype, "soundTransform", {
                            get: function () {
                                release || notImplemented("public flash.display.SimpleButton::get soundTransform");
                                return;
                                // return this._soundTransform;
                            },
                            set: function (sndTransform) {
                                sndTransform = sndTransform;
                                release || notImplemented("public flash.display.SimpleButton::set soundTransform");
                                return;
                                // this._soundTransform = sndTransform;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * Override of DisplayObject#_containsPoint that applies the test on hitTestState if
                         * that is defined.
                         */
                        SimpleButton.prototype._containsPoint = function (globalX, globalY, localX, localY, testingType, objects) {
                            var target = testingType === 3 /* Mouse */ ? this._hitTestState : this._currentState;
                            if (!target) {
                                return 0 /* None */;
                            }
                            // Hit testing relies on being able to get combined transforms and all that, so, a parent.
                            target._parent = this;
                            var result = target._containsGlobalPoint(globalX, globalY, testingType, objects);
                            target._parent = null;
                            // For mouse target finding, SimpleButtons always return themselves as the hit.
                            if (result !== 0 /* None */ && testingType === 3 /* Mouse */ &&
                                objects && this._mouseEnabled) {
                                objects[0] = this;
                                release || assert(objects.length === 1);
                            }
                            return result;
                        };
                        /**
                         * Override of DisplayObject#_getChildBounds that retrieves the current hitTestState's bounds.
                         */
                        SimpleButton.prototype._getChildBounds = function (bounds, includeStrokes) {
                            if (!this._currentState) {
                                return;
                            }
                            this._currentState._parent = this;
                            bounds.unionInPlace(this._currentState._getTransformedBounds(this, includeStrokes));
                            this._currentState._parent = null;
                        };
                        SimpleButton.prototype._propagateFlagsDown = function (flags) {
                            if (this._hasFlags(flags)) {
                                return;
                            }
                            this._setFlags(flags);
                            this._upState && this._upState._propagateFlagsDown(flags);
                            this._overState && this._overState._propagateFlagsDown(flags);
                            this._downState && this._downState._propagateFlagsDown(flags);
                            this._hitTestState && this._hitTestState._propagateFlagsDown(flags);
                        };
                        SimpleButton.prototype._updateButton = function () {
                            var state;
                            if (this._mouseOver) {
                                state = this._mouseDown ? this._downState : this._overState;
                            }
                            else {
                                state = this._upState;
                            }
                            if (state === this._currentState) {
                                return;
                            }
                            if (this._currentState) {
                            }
                            this._currentState = state;
                            if (this._stage) {
                            }
                            if (state) {
                                this._children[0] = state;
                            }
                            else {
                                this._children.length = 0;
                            }
                            this._setDirtyFlags(2 /* DirtyChildren */);
                            this._invalidateFillAndLineBounds(true, true);
                        };
                        // Called whenever the class is initialized.
                        SimpleButton.classInitializer = null;
                        // List of static symbols to link.
                        SimpleButton.classSymbols = null; // [];
                        // List of instance symbols to link.
                        SimpleButton.instanceSymbols = null; // [];
                        return SimpleButton;
                    })(flash.display.InteractiveObject);
                    display.SimpleButton = SimpleButton;
                    var ButtonState = (function () {
                        function ButtonState(symbol, placeObjectTag) {
                            this.symbol = symbol;
                            this.placeObjectTag = placeObjectTag;
                        }
                        return ButtonState;
                    })();
                    display.ButtonState = ButtonState;
                    var ButtonSymbol = (function (_super) {
                        __extends(ButtonSymbol, _super);
                        function ButtonSymbol(data, loaderInfo) {
                            _super.call(this, data, loaderInfo.sec.flash.display.SimpleButton.axClass, true);
                            this.upState = null;
                            this.overState = null;
                            this.downState = null;
                            this.hitTestState = null;
                            this.loaderInfo = loaderInfo;
                        }
                        ButtonSymbol.FromData = function (data, loaderInfo) {
                            var symbol = new ButtonSymbol(data, loaderInfo);
                            if (loaderInfo.actionScriptVersion === display.ActionScriptVersion.ACTIONSCRIPT2) {
                                symbol.isAVM1Object = true;
                            }
                            var states = data.states;
                            var character = null;
                            var placeObjectTag;
                            for (var stateName in states) {
                                var controlTags = states[stateName];
                                if (controlTags.length === 1) {
                                    placeObjectTag = controlTags[0];
                                    character = loaderInfo.getSymbolById(placeObjectTag.symbolId);
                                    if (!character) {
                                        continue;
                                    }
                                }
                                else {
                                    placeObjectTag = {
                                        code: 4 /* CODE_PLACE_OBJECT */,
                                        flags: 1 /* Move */,
                                        depth: 1
                                    };
                                    character = new flash.display.SpriteSymbol({ id: -1, className: null, env: null }, loaderInfo);
                                    character.frames.push(new Shumway.SWF.SWFFrame(controlTags));
                                }
                                symbol[stateName + 'State'] = new ButtonState(character, placeObjectTag);
                            }
                            return symbol;
                        };
                        return ButtonSymbol;
                    })(Shumway.Timeline.DisplaySymbol);
                    display.ButtonSymbol = ButtonSymbol;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
///<reference path='../references.ts' />
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var assert = Shumway.Debug.assert;
                    var notImplemented = Shumway.Debug.notImplemented;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var mixHash = Shumway.HashUtilities.mixHash;
                    var checkParameterType = Shumway.AVMX.checkParameterType;
                    var clamp = Shumway.NumberUtilities.clamp;
                    var events = flash.events;
                    var DisplayObjectContainer = (function (_super) {
                        __extends(DisplayObjectContainer, _super);
                        function DisplayObjectContainer() {
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                            this._setDirtyFlags(2 /* DirtyChildren */);
                        }
                        DisplayObjectContainer.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this);
                            this._tabChildren = true;
                            this._mouseChildren = true;
                            // Might already have been initialized from a symbol.
                            this._children = this._children || [];
                        };
                        /**
                         * This object's children have changed.
                         */
                        DisplayObjectContainer.prototype._invalidateChildren = function () {
                            this._setDirtyFlags(2 /* DirtyChildren */);
                            this._invalidateFillAndLineBounds(true, true);
                        };
                        /**
                         * Propagates flags down the display list. Propagation stops if all flags are already set.
                         */
                        DisplayObjectContainer.prototype._propagateFlagsDown = function (flags) {
                            if (this._hasFlags(flags)) {
                                return;
                            }
                            this._setFlags(flags);
                            var children = this._children;
                            for (var i = 0; i < children.length; i++) {
                                children[i]._propagateFlagsDown(flags);
                            }
                        };
                        /**
                         * Calls the constructors of new children placed by timeline commands.
                         */
                        DisplayObjectContainer.prototype._constructChildren = function () {
                            release || AVMX.counter.count("DisplayObjectContainer::_constructChildren");
                            var children = this._children;
                            for (var i = 0; i < children.length; i++) {
                                var child = children[i];
                                if (child._hasFlags(256 /* Constructed */)) {
                                    continue;
                                }
                                try {
                                    child.axInitializer();
                                }
                                catch (e) {
                                    Shumway.Debug.warning('caught error executing child constructor in constructChildren: ', e);
                                }
                                //child.class.instanceConstructorNoInitialize.call(child);
                                child._removeReference();
                                if (child._name) {
                                    this.axSetPublicProperty(child._name, child);
                                }
                                child._setFlags(256 /* Constructed */);
                                var eventClass = this.sec.flash.events.Event.axClass;
                                if (child._hasFlags(131072 /* HasPlaceObjectInitPending */)) {
                                    child._removeFlags(131072 /* HasPlaceObjectInitPending */);
                                    var avm1Context = child._symbol.avm1Context;
                                    Shumway.AVM1.Lib.initializeAVM1Object(child, avm1Context, child._placeObjectTag);
                                    try {
                                        child.dispatchEvent(eventClass.getInstance(events.Event.AVM1_INIT));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under DisplayObjectContainer AVM1_INIT event: ', e);
                                    }
                                    try {
                                        child.dispatchEvent(eventClass.getInstance(events.Event.AVM1_CONSTRUCT));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under DisplayObjectContainer AVM1_CONSTRUCT event: ', e);
                                    }
                                    if (child.hasEventListener(events.Event.AVM1_LOAD)) {
                                        child._setFlags(1024 /* NeedsLoadEvent */);
                                        this._propagateFlagsUp(16384 /* ContainsFrameScriptPendingChildren */);
                                    }
                                }
                                try {
                                    child.dispatchEvent(eventClass.getInstance(events.Event.ADDED, true));
                                }
                                catch (e) {
                                    Shumway.Debug.warning('caught error under DisplayObject ADDED event: ', e);
                                }
                                if (child.stage) {
                                    try {
                                        child.dispatchEvent(eventClass.getInstance(events.Event.ADDED_TO_STAGE));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under DisplayObject ADDED_TO_STAGE event: ', e);
                                    }
                                }
                            }
                        };
                        DisplayObjectContainer.prototype._enqueueFrameScripts = function () {
                            if (this._hasFlags(16384 /* ContainsFrameScriptPendingChildren */)) {
                                this._removeFlags(16384 /* ContainsFrameScriptPendingChildren */);
                                var children = this._children;
                                for (var i = 0; i < children.length; i++) {
                                    var child = children[i];
                                    if (this.sec.flash.display.DisplayObjectContainer.axIsType(child) ||
                                        this.sec.flash.display.AVM1Movie.axIsType(child)) {
                                        child._enqueueFrameScripts();
                                    }
                                }
                            }
                        };
                        Object.defineProperty(DisplayObjectContainer.prototype, "numChildren", {
                            get: function () {
                                return this._getNumChildren();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        // `get numChildren` is overridden in `Stage` and has to be able to call this.
                        DisplayObjectContainer.prototype._getNumChildren = function () {
                            return this._children.length;
                        };
                        Object.defineProperty(DisplayObjectContainer.prototype, "textSnapshot", {
                            get: function () {
                                release || notImplemented("public DisplayObjectContainer::get textSnapshot");
                                return;
                                // return this._textSnapshot;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(DisplayObjectContainer.prototype, "tabChildren", {
                            get: function () {
                                return this._getTabChildren();
                            },
                            set: function (enable) {
                                this._setTabChildren(enable);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        // `get tabChildren` is overridden in `Stage` and has to be able to call this.
                        DisplayObjectContainer.prototype._getTabChildren = function () {
                            return this._tabChildren;
                        };
                        // `set tabChildren` is overridden in `Stage` and has to be able to call this.
                        DisplayObjectContainer.prototype._setTabChildren = function (enable) {
                            enable = !!enable;
                            var old = this._tabChildren;
                            this._tabChildren = enable;
                            if (old !== enable) {
                                this.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.TAB_CHILDREN_CHANGE, true));
                            }
                        };
                        Object.defineProperty(DisplayObjectContainer.prototype, "mouseChildren", {
                            get: function () {
                                return this._getMouseChildren();
                            },
                            set: function (enable) {
                                this._setMouseChildren(enable);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        // `get mouseChildren` is overridden in `Stage` and has to be able to call this.
                        DisplayObjectContainer.prototype._getMouseChildren = function () {
                            return this._mouseChildren;
                        };
                        // `set mouseChildren` is overridden in `Stage` and has to be able to call this.
                        DisplayObjectContainer.prototype._setMouseChildren = function (enable) {
                            this._mouseChildren = !!enable;
                        };
                        DisplayObjectContainer.prototype.addChild = function (child) {
                            return this.addChildAt(child, this._children.length);
                        };
                        /**
                         * Adds a child at a given index. The index must be within the range [0 ... children.length].
                         * Note that this is different than the range setChildIndex expects.
                         */
                        DisplayObjectContainer.prototype.addChildAt = function (child, index /*int*/) {
                            checkParameterType(child, "child", this.sec.flash.display.DisplayObject.axClass);
                            release || AVMX.counter.count("DisplayObjectContainer::addChildAt");
                            index = index | 0;
                            release || assert(child._hasFlags(256 /* Constructed */), "Child is not fully constructed.");
                            if (child === this) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.CantAddSelfError);
                            }
                            if (this.sec.flash.display.DisplayObjectContainer.axIsType(child) &&
                                child.contains(this)) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.CantAddParentError);
                            }
                            var children = this._children;
                            if (index < 0 || index > children.length) {
                                this.sec.throwError('RangeError', AVMX.Errors.ParamRangeError);
                            }
                            if (child._parent === this) {
                                this.setChildIndex(child, clamp(index, 0, children.length - 1));
                                return child;
                            }
                            // TODO: check what happens if a listener for REMOVE throws an error. Does the element get
                            // reparented nevertheless?
                            if (child._parent) {
                                // Loader overrides removeChildAt to throw an exception. We still want to use it, so we
                                // always call the original version here.
                                DisplayObjectContainer.prototype.removeChildAt.call(child._parent, child._parent.getChildIndex(child));
                                // The children list could have been mutated as a result of |removeChild|.
                                index = clamp(index, 0, children.length);
                            }
                            for (var i = children.length - 1; i >= index; i--) {
                                children[i]._index++;
                            }
                            children.splice(index, 0, child);
                            child._setParent(this, -1);
                            child._index = index;
                            child._invalidatePosition();
                            this._invalidateChildren();
                            child._addReference();
                            child.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.ADDED, true));
                            // ADDED event handlers may remove the child from the stage, in such cases
                            // we should not dispatch the ADDED_TO_STAGE event.
                            if (child.stage) {
                                child._propagateEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.ADDED_TO_STAGE));
                            }
                            return child;
                        };
                        /**
                         * Adds a timeline object to this container. The new child is added after the last object that
                         * exists at a smaller depth, or before the first object that exists at a greater depth. If no
                         * other timeline object is found, the new child is added to the front(top) of all other
                         * children.
                         *
                         * Note that this differs from `addChildAt` in that the depth isn't an index in the `children`
                         * array, and doesn't have to be in the dense range [0..children.length].
                         */
                        DisplayObjectContainer.prototype.addTimelineObjectAtDepth = function (child, depth /*int*/) {
                            release || AVMX.counter.count("DisplayObjectContainer::addTimelineObjectAtDepth");
                            depth = depth | 0;
                            var children = this._children;
                            var maxIndex = children.length - 1;
                            var index = maxIndex + 1;
                            for (var i = maxIndex; i >= 0; i--) {
                                var current = children[i];
                                if (current._depth > -1) {
                                    if (current._depth < depth) {
                                        index = i + 1;
                                        break;
                                    }
                                    index = i;
                                }
                            }
                            if (index > maxIndex) {
                                children.push(child);
                                child._index = index;
                            }
                            else {
                                children.splice(index, 0, child);
                                for (var i = index; i < children.length; i++) {
                                    children[i]._index = i;
                                }
                            }
                            child._setParent(this, depth);
                            child._invalidatePosition();
                            this._invalidateChildren();
                        };
                        DisplayObjectContainer.prototype.removeChild = function (child) {
                            checkParameterType(child, "child", this.sec.flash.display.DisplayObject.axClass);
                            return this.removeChildAt(this.getChildIndex(child));
                        };
                        DisplayObjectContainer.prototype.removeChildAt = function (index) {
                            release || AVMX.counter.count("DisplayObjectContainer::removeChildAt");
                            index = index | 0;
                            var children = this._children;
                            if (index < 0 || index >= children.length) {
                                this.sec.throwError('RangeError', AVMX.Errors.ParamRangeError);
                            }
                            var child = children[index];
                            if (child._hasFlags(256 /* Constructed */)) {
                                child.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.REMOVED, true));
                                if (this.stage) {
                                    child._propagateEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.REMOVED_FROM_STAGE));
                                }
                                // Children list might have been mutated by the REMOVED or REMOVED_FROM_STAGE event,
                                // we may need to operate on the new index of the child.
                                index = this.getChildIndex(child);
                            }
                            children.splice(index, 1);
                            for (var i = children.length - 1; i >= index; i--) {
                                children[i]._index--;
                            }
                            child._setParent(null, -1);
                            child._index = -1;
                            child._invalidatePosition();
                            this._invalidateChildren();
                            return child;
                        };
                        DisplayObjectContainer.prototype.getChildIndex = function (child) {
                            checkParameterType(child, "child", this.sec.flash.display.DisplayObject.axClass);
                            if (child._parent !== this) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.NotAChildError);
                            }
                            return child._index;
                        };
                        /**
                         * Sets the index of a child. The index must be within the range [0 ... children.length - 1].
                         */
                        DisplayObjectContainer.prototype.setChildIndex = function (child, index /*int*/) {
                            index = index | 0;
                            checkParameterType(child, "child", this.sec.flash.display.DisplayObject.axClass);
                            var children = this._children;
                            if (index < 0 || index >= children.length) {
                                this.sec.throwError('RangeError', AVMX.Errors.ParamRangeError);
                            }
                            if (child._parent !== this) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.NotAChildError);
                            }
                            child._setDepth(-1);
                            var currentIndex = this.getChildIndex(child);
                            if (children.length === 1 || currentIndex === index) {
                                return;
                            }
                            if (index === currentIndex + 1 || index === currentIndex - 1) {
                                // We can't call |swapChildrenAt| here because we don't want to affect the depth value.
                                this._swapChildrenAt(currentIndex, index);
                            }
                            else {
                                children.splice(currentIndex, 1);
                                children.splice(index, 0, child);
                                var i = currentIndex < index ? currentIndex : index;
                                while (i < children.length) {
                                    children[i]._index = i++;
                                }
                            }
                            this._invalidateChildren();
                        };
                        DisplayObjectContainer.prototype.getChildAt = function (index) {
                            index = index | 0;
                            var children = this._children;
                            if (index < 0 || index >= children.length) {
                                this.sec.throwError('RangeError', AVMX.Errors.ParamRangeError);
                            }
                            var child = this._lookupChildByIndex(index, 0 /* DEFAULT */);
                            if (!child) {
                                return null;
                            }
                            child._addReference();
                            return child;
                        };
                        /**
                         * Returns the timeline object that exists at the specified depth.
                         */
                        DisplayObjectContainer.prototype.getTimelineObjectAtDepth = function (depth /*int*/) {
                            depth = depth | 0;
                            var children = this._children;
                            for (var i = 0; i < children.length; i++) {
                                var child = children[i];
                                if (child._depth > depth) {
                                    break;
                                }
                                if (child._depth === depth) {
                                    return child;
                                }
                            }
                            return null;
                        };
                        /**
                         * Returns the last child index that is covered by the clip depth.
                         */
                        DisplayObjectContainer.prototype.getClipDepthIndex = function (depth) {
                            depth = depth | 0;
                            var children = this._children;
                            var index = this._children.length - 1;
                            var first = true;
                            for (var i = index; i >= 0; i--) {
                                var child = children[i];
                                // Ignore children that don't have a depth value.
                                if (child._depth < 0) {
                                    continue;
                                }
                                // Usually we return the index of the first child that has a depth value less than or
                                // equal to the specified depth. However, Flash seems to clip all remaining children,
                                // including those that don't have a depth value if the clip appears at the end.
                                if (child._depth <= depth) {
                                    return first ? index : i;
                                }
                                first = false;
                            }
                            return 0;
                        };
                        DisplayObjectContainer.prototype.getChildByName = function (name) {
                            name = axCoerceString(name);
                            var child = this._lookupChildByName(name, 0 /* DEFAULT */);
                            if (child) {
                                child._addReference();
                                return child;
                            }
                            return null;
                        };
                        /**
                         * Returns the child display object instance that exists at given index without creating a
                         * reference nor taking ownership.
                         */
                        DisplayObjectContainer.prototype._lookupChildByIndex = function (index, options) {
                            var child = this._children[index];
                            if (child && (child._hasFlags(256 /* Constructed */) ||
                                options & 2 /* INCLUDE_NON_INITIALIZED */)) {
                                return child;
                            }
                            return null;
                        };
                        /**
                         * Returns the child display object that exists with given name without creating a reference
                         * nor taking ownership.
                         */
                        DisplayObjectContainer.prototype._lookupChildByName = function (name, options) {
                            var children = this._children;
                            if (children.length === 0) {
                                return null;
                            }
                            for (var i = 0; i < children.length; i++) {
                                var child = children[i];
                                if (!child._hasFlags(256 /* Constructed */) &&
                                    !(options & 2 /* INCLUDE_NON_INITIALIZED */)) {
                                    continue;
                                }
                                if (child._name === name) {
                                    return child;
                                }
                            }
                            if (!(options & 1 /* IGNORE_CASE */)) {
                                return null;
                            }
                            // Trying again in non-case sensitive mode (mostly for AVM1).
                            name = name.toLowerCase();
                            for (var i = 0; i < children.length; i++) {
                                var child = children[i];
                                if (!child._hasFlags(256 /* Constructed */) &&
                                    !(options & 2 /* INCLUDE_NON_INITIALIZED */)) {
                                    continue;
                                }
                                if (child._name.toLowerCase() === name) {
                                    return child;
                                }
                            }
                            return null;
                        };
                        /**
                         * Override of DisplayObject#_containsPoint that takes children into consideration.
                         */
                        DisplayObjectContainer.prototype._containsPoint = function (globalX, globalY, localX, localY, testingType, objects) {
                            return this._containsPointImpl(globalX, globalY, localX, localY, testingType, objects, false);
                        };
                        DisplayObjectContainer.prototype._containsPointImpl = function (globalX, globalY, localX, localY, testingType, objects, skipBoundsCheck) {
                            var result;
                            if (!skipBoundsCheck) {
                                result = this._boundsAndMaskContainPoint(globalX, globalY, localX, localY, testingType);
                                // Same as in the DisplayObject base case, we're done if we don't have a hit or are only
                                // looking for bounds + mask checks.
                                if (result === 0 /* None */ || testingType < 2 /* HitTestShape */) {
                                    return result;
                                }
                            }
                            var anyChildHit = false;
                            var children = this._getUnclippedChildren(testingType, globalX, globalY);
                            for (var i = children ? children.length : 0; i--;) {
                                var child = children[i];
                                if (child._maskedObject) {
                                    continue;
                                }
                                result = child._containsGlobalPoint(globalX, globalY, testingType, objects);
                                if (result !== 2 /* Shape */) {
                                    continue;
                                }
                                // For hit testing, a single match suffices.
                                if (testingType < 3 /* Mouse */) {
                                    return result;
                                }
                                anyChildHit = true;
                                if (testingType >= 4 /* ObjectsUnderPoint */) {
                                    continue;
                                }
                                release || assert(testingType === 3 /* Mouse */);
                                release || assert(objects.length <= 1);
                                // If this object itself is mouse-disabled, we have to ensure that no nested object is
                                // returned as a result.
                                if (!this._mouseEnabled) {
                                    objects.length = 0;
                                    return result;
                                }
                                // If this container disables mouseChildren, any matched child establish the container as
                                // the match.
                                if (!this._mouseChildren) {
                                    objects[0] = this;
                                }
                                if (objects.length !== 0) {
                                    release || assert(this.sec.flash.display.InteractiveObject.axIsType(objects[0]));
                                    return 2 /* Shape */;
                                }
                            }
                            // We need to always test the container itself for getObjectsUnderPoint or when looking for a
                            // drop target. Otherwise, it's only required if no child (interactive or not) was hit.
                            if (anyChildHit && testingType < 4 /* ObjectsUnderPoint */) {
                                if (testingType === 3 /* Mouse */ && objects.length === 0) {
                                    objects[0] = this;
                                }
                                return 2 /* Shape */;
                            }
                            var selfHit = this._containsPointDirectly(localX, localY, globalX, globalY);
                            if (selfHit) {
                                if (testingType === 5 /* Drop */) {
                                    // For Drop, replace previous hit with current one.
                                    objects[0] = this;
                                }
                                else if (testingType === 4 /* ObjectsUnderPoint */ || objects && this._mouseEnabled) {
                                    objects.push(this);
                                }
                            }
                            return anyChildHit || selfHit ? 2 /* Shape */ : 0 /* None */;
                        };
                        DisplayObjectContainer.prototype._getUnclippedChildren = function (testingType, globalX, globalY) {
                            // Clipping masks complicate hit testing: for mouse target finding, where performance is
                            // most important, we want to test highest children first, then go down. OTOH, we want to
                            // test clipping masks before the elements they clip, potentially saving costly tests against
                            // lots of elements. However, clipping masks affect siblings with higher child indices, so
                            // by going top-to-bottom, we discover them after the clipped content. To get around that,
                            // we iterate over the children once and detect any clipping masks. If we find at least one,
                            // we copy all the non-clipped elements into a new array, over which we then iterate without
                            // having to test clipping.
                            // Note: if speed is an issue, we could set a flag on containers that have at least one
                            // clipping mask and do this step only if that flag is set.
                            var children = this._children;
                            if (!children) {
                                return null;
                            }
                            var unclippedChildren; // Lazily created.
                            for (var i = 0; children && i < children.length; i++) {
                                var child = children[i];
                                if (child._clipDepth !== -1) {
                                    if (!unclippedChildren) {
                                        unclippedChildren = children.slice(0, i);
                                    }
                                    // Clipping masks are simply ignored for HitTestPoint purposes.
                                    if (testingType === 2 /* HitTestShape */) {
                                        continue;
                                    }
                                    release || assert(testingType >= 3 /* Mouse */);
                                    // If the point isn't contained in the clipping mask, we can skip all the clipped objects.
                                    // We pass HitTestShape here because we never want to collect hit objects, which the
                                    // higher testing types would attempt to do.
                                    var containsPoint = child._containsGlobalPoint(globalX, globalY, 2 /* HitTestShape */, null);
                                    if (!containsPoint) {
                                        i = this.getClipDepthIndex(child._clipDepth);
                                    }
                                    continue;
                                }
                                if (unclippedChildren) {
                                    unclippedChildren.push(child);
                                }
                            }
                            return unclippedChildren || children;
                        };
                        /**
                         * Override of DisplayObject#_getChildBounds that union all childrens's
                         * bounds into the bounds.
                         */
                        DisplayObjectContainer.prototype._getChildBounds = function (bounds, includeStrokes) {
                            var children = this._children;
                            for (var i = 0; i < children.length; i++) {
                                bounds.unionInPlace(children[i]._getTransformedBounds(this, includeStrokes));
                            }
                        };
                        /**
                         * Returns an array of all leaf objects under the given point in global coordinates.
                         * A leaf node in this context is an object that itself contains visual content, so it can be
                         * any of Shape, Sprite, MovieClip, Bitmap, Video, and TextField.
                         * Note that, while the Flash documentation makes it sound like it doesn't, the result also
                         * contains the receiver object if that matches the criteria above.
                         */
                        DisplayObjectContainer.prototype.getObjectsUnderPoint = function (globalPoint) {
                            release || AVMX.counter.count("DisplayObjectContainer::getObjectsUnderPoint");
                            var globalX = globalPoint.x * 20 | 0;
                            var globalY = globalPoint.y * 20 | 0;
                            var objects = [];
                            this._containsGlobalPoint(globalX, globalY, 4 /* ObjectsUnderPoint */, objects);
                            // getObjectsUnderPoint returns results in exactly the opposite order we collect them in.
                            return this.sec.createArrayUnsafe(objects.reverse());
                        };
                        DisplayObjectContainer.prototype.areInaccessibleObjectsUnderPoint = function (point) {
                            point = point;
                            release || notImplemented("public DisplayObjectContainer::areInaccessibleObjectsUnderPoint");
                            return;
                        };
                        DisplayObjectContainer.prototype.contains = function (child) {
                            checkParameterType(child, "child", this.sec.flash.display.DisplayObject.axClass);
                            return this._isAncestor(child);
                        };
                        DisplayObjectContainer.prototype.swapChildrenAt = function (index1 /*int*/, index2 /*int*/) {
                            index1 = index1 | 0;
                            index2 = index2 | 0;
                            var children = this._children;
                            if (index1 < 0 || index1 >= children.length ||
                                index2 < 0 || index2 >= children.length) {
                                this.sec.throwError('RangeError', AVMX.Errors.ParamRangeError);
                            }
                            // Always call _swapChildrenAt to make sure _setDepth(-1) is called on both children.
                            this._swapChildrenAt(index1, index2);
                            if (index1 !== index2) {
                                this._invalidateChildren();
                            }
                        };
                        DisplayObjectContainer.prototype._swapChildrenAt = function (index1, index2) {
                            var children = this._children;
                            var child1 = children[index1];
                            var child2 = children[index2];
                            children[index2] = child1;
                            child1._setDepth(-1);
                            child1._index = index2;
                            children[index1] = child2;
                            child2._setDepth(-1);
                            child2._index = index1;
                        };
                        DisplayObjectContainer.prototype.swapChildren = function (child1, child2) {
                            // Flash prints out 'child' for both non-null |child1| and |child2|.
                            checkParameterType(child1, "child", this.sec.flash.display.DisplayObject.axClass);
                            checkParameterType(child2, "child", this.sec.flash.display.DisplayObject.axClass);
                            this.swapChildrenAt(this.getChildIndex(child1), this.getChildIndex(child2));
                        };
                        DisplayObjectContainer.prototype.removeChildren = function (beginIndex, endIndex) {
                            if (beginIndex === void 0) { beginIndex = 0; }
                            if (endIndex === void 0) { endIndex = 2147483647; }
                            beginIndex = beginIndex | 0;
                            endIndex = endIndex | 0;
                            if (beginIndex < 0 || endIndex < 0 || endIndex < beginIndex || endIndex >= this._children.length) {
                                this.sec.throwError('RangeError', AVMX.Errors.ParamRangeError);
                            }
                            var count = endIndex - beginIndex + 1;
                            if (count > 0) {
                                while (count--) {
                                    this.removeChildAt(beginIndex);
                                }
                            }
                        };
                        DisplayObjectContainer.prototype.hashCode = function () {
                            var hash = 0;
                            for (var i = 0; i < this.numChildren; i++) {
                                var child = this.getChildAt(i);
                                if (child) {
                                    hash = mixHash(hash, this.getChildAt(i).hashCode());
                                }
                            }
                            return mixHash(hash, this.getBounds(null).hashCode());
                        };
                        /**
                         * This is a very slow recursive function that should not be used in performance critical code.
                         */
                        DisplayObjectContainer.prototype.getAncestorCount = function () {
                            var count = 0;
                            for (var i = 0; i < this.numChildren; i++) {
                                var child = this.getChildAt(i);
                                if (child) {
                                    count += 1 + this.getChildAt(i).getAncestorCount();
                                }
                            }
                            return count;
                        };
                        DisplayObjectContainer.bindings = null;
                        DisplayObjectContainer.classSymbols = null;
                        DisplayObjectContainer.classInitializer = null;
                        return DisplayObjectContainer;
                    })(flash.display.InteractiveObject);
                    display.DisplayObjectContainer = DisplayObjectContainer;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: JointStyle
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var JointStyle = (function (_super) {
                        __extends(JointStyle, _super);
                        function JointStyle() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        JointStyle.fromNumber = function (n) {
                            switch (n) {
                                case 0:
                                    return JointStyle.ROUND;
                                case 1:
                                    return JointStyle.BEVEL;
                                case 2:
                                    return JointStyle.MITER;
                                default:
                                    return null;
                            }
                        };
                        JointStyle.toNumber = function (value) {
                            switch (value) {
                                case JointStyle.ROUND:
                                    return 0;
                                case JointStyle.BEVEL:
                                    return 1;
                                case JointStyle.MITER:
                                    return 2;
                                default:
                                    return -1;
                            }
                        };
                        // Called whenever the class is initialized.
                        JointStyle.classInitializer = null;
                        // List of static symbols to link.
                        JointStyle.classSymbols = null; // [];
                        // List of instance symbols to link.
                        JointStyle.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        JointStyle.ROUND = "round";
                        JointStyle.BEVEL = "bevel";
                        JointStyle.MITER = "miter";
                        return JointStyle;
                    })(AS.ASObject);
                    display.JointStyle = JointStyle;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: CapsStyle
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var CapsStyle = (function (_super) {
                        __extends(CapsStyle, _super);
                        function CapsStyle() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        CapsStyle.fromNumber = function (n) {
                            switch (n) {
                                case 0:
                                    return CapsStyle.ROUND;
                                case 1:
                                    return CapsStyle.NONE;
                                case 2:
                                    return CapsStyle.SQUARE;
                                default:
                                    return null;
                            }
                        };
                        CapsStyle.toNumber = function (value) {
                            switch (value) {
                                case CapsStyle.ROUND:
                                    return 0;
                                case CapsStyle.NONE:
                                    return 1;
                                case CapsStyle.SQUARE:
                                    return 2;
                                default:
                                    return -1;
                            }
                        };
                        // Called whenever the class is initialized.
                        CapsStyle.classInitializer = null;
                        // List of static symbols to link.
                        CapsStyle.classSymbols = null; // [];
                        // List of instance symbols to link.
                        CapsStyle.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        CapsStyle.ROUND = "round";
                        CapsStyle.NONE = "none";
                        CapsStyle.SQUARE = "square";
                        return CapsStyle;
                    })(AS.ASObject);
                    display.CapsStyle = CapsStyle;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: LineScaleMode
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var LineScaleMode = (function (_super) {
                        __extends(LineScaleMode, _super);
                        function LineScaleMode() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        LineScaleMode.fromNumber = function (n) {
                            switch (n) {
                                case 0:
                                    return LineScaleMode.NONE;
                                case 1:
                                    return LineScaleMode.NORMAL;
                                case 2:
                                    return LineScaleMode.VERTICAL;
                                case 3:
                                    return LineScaleMode.HORIZONTAL;
                                default:
                                    return null;
                            }
                        };
                        LineScaleMode.toNumber = function (value) {
                            switch (value) {
                                case LineScaleMode.NONE:
                                    return 0;
                                case LineScaleMode.NORMAL:
                                    return 1;
                                case LineScaleMode.VERTICAL:
                                    return 2;
                                case LineScaleMode.HORIZONTAL:
                                    return 3;
                                default:
                                    return -1;
                            }
                        };
                        // Called whenever the class is initialized.
                        LineScaleMode.classInitializer = null;
                        // List of static symbols to link.
                        LineScaleMode.classSymbols = null; // [];
                        // List of instance symbols to link.
                        LineScaleMode.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        LineScaleMode.NORMAL = "normal";
                        LineScaleMode.VERTICAL = "vertical";
                        LineScaleMode.HORIZONTAL = "horizontal";
                        LineScaleMode.NONE = "none";
                        return LineScaleMode;
                    })(AS.ASObject);
                    display.LineScaleMode = LineScaleMode;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GradientType
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var GradientType = (function (_super) {
                        __extends(GradientType, _super);
                        function GradientType() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        GradientType.fromNumber = function (n) {
                            switch (n) {
                                case 16 /* Linear */:
                                    return GradientType.LINEAR;
                                case 18 /* Radial */:
                                    return GradientType.RADIAL;
                                default:
                                    return null;
                            }
                        };
                        GradientType.toNumber = function (value) {
                            switch (value) {
                                case GradientType.LINEAR:
                                    return 16 /* Linear */;
                                case GradientType.RADIAL:
                                    return 18 /* Radial */;
                                default:
                                    return -1;
                            }
                        };
                        GradientType.classInitializer = null;
                        GradientType.classSymbols = null; // [];
                        GradientType.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        GradientType.LINEAR = "linear";
                        GradientType.RADIAL = "radial";
                        return GradientType;
                    })(AS.ASObject);
                    display.GradientType = GradientType;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: SpreadMethod
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var SpreadMethod = (function (_super) {
                        __extends(SpreadMethod, _super);
                        function SpreadMethod() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        SpreadMethod.fromNumber = function (n) {
                            switch (n) {
                                case 0 /* Pad */:
                                    return SpreadMethod.PAD;
                                case 1 /* Reflect */:
                                    return SpreadMethod.REFLECT;
                                case 2 /* Repeat */:
                                    return SpreadMethod.REPEAT;
                                default:
                                    return null;
                            }
                        };
                        SpreadMethod.toNumber = function (value) {
                            switch (value) {
                                case SpreadMethod.PAD:
                                    return 0 /* Pad */;
                                case SpreadMethod.REFLECT:
                                    return 1 /* Reflect */;
                                case SpreadMethod.REPEAT:
                                    return 2 /* Repeat */;
                                default:
                                    return -1;
                            }
                        };
                        SpreadMethod.classInitializer = null;
                        SpreadMethod.classSymbols = null; // [];
                        SpreadMethod.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        SpreadMethod.PAD = "pad";
                        SpreadMethod.REFLECT = "reflect";
                        SpreadMethod.REPEAT = "repeat";
                        return SpreadMethod;
                    })(AS.ASObject);
                    display.SpreadMethod = SpreadMethod;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: InterpolationMethod
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var InterpolationMethod = (function (_super) {
                        __extends(InterpolationMethod, _super);
                        function InterpolationMethod() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        InterpolationMethod.fromNumber = function (n) {
                            switch (n) {
                                case 0 /* RGB */:
                                    return InterpolationMethod.RGB;
                                case 1 /* LinearRGB */:
                                    return InterpolationMethod.LINEAR_RGB;
                                default:
                                    return null;
                            }
                        };
                        InterpolationMethod.toNumber = function (value) {
                            switch (value) {
                                case InterpolationMethod.RGB:
                                    return 0 /* RGB */;
                                case InterpolationMethod.LINEAR_RGB:
                                    return 1 /* LinearRGB */;
                                default:
                                    return -1;
                            }
                        };
                        InterpolationMethod.classInitializer = null;
                        InterpolationMethod.classSymbols = null; // [];
                        InterpolationMethod.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        InterpolationMethod.RGB = "rgb";
                        InterpolationMethod.LINEAR_RGB = "linearRGB";
                        return InterpolationMethod;
                    })(AS.ASObject);
                    display.InterpolationMethod = InterpolationMethod;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsBitmapFill
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var GraphicsBitmapFill = (function (_super) {
                        __extends(GraphicsBitmapFill, _super);
                        function GraphicsBitmapFill(bitmapData, matrix, repeat, smooth) {
                            if (bitmapData === void 0) { bitmapData = null; }
                            if (matrix === void 0) { matrix = null; }
                            if (repeat === void 0) { repeat = true; }
                            if (smooth === void 0) { smooth = false; }
                            _super.call(this);
                            this.bitmapData = bitmapData;
                            this.matrix = matrix;
                            this.repeat = !!repeat;
                            this.smooth = !!smooth;
                        }
                        // Called whenever the class is initialized.
                        GraphicsBitmapFill.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsBitmapFill.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsBitmapFill.instanceSymbols = null; // ["bitmapData", "matrix", "repeat", "smooth"];
                        return GraphicsBitmapFill;
                    })(AS.ASObject);
                    display.GraphicsBitmapFill = GraphicsBitmapFill;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsEndFill
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var GraphicsEndFill = (function (_super) {
                        __extends(GraphicsEndFill, _super);
                        function GraphicsEndFill() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        GraphicsEndFill.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsEndFill.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsEndFill.instanceSymbols = null; // [];
                        return GraphicsEndFill;
                    })(AS.ASObject);
                    display.GraphicsEndFill = GraphicsEndFill;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsGradientFill
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var GraphicsGradientFill = (function (_super) {
                        __extends(GraphicsGradientFill, _super);
                        function GraphicsGradientFill(type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio) {
                            if (type === void 0) { type = "linear"; }
                            if (colors === void 0) { colors = null; }
                            if (alphas === void 0) { alphas = null; }
                            if (ratios === void 0) { ratios = null; }
                            if (matrix === void 0) { matrix = null; }
                            if (spreadMethod === void 0) { spreadMethod = "pad"; }
                            if (interpolationMethod === void 0) { interpolationMethod = "rgb"; }
                            if (focalPointRatio === void 0) { focalPointRatio = 0; }
                            _super.call(this);
                            this.type = axCoerceString(type);
                            this.colors = colors;
                            this.alphas = alphas;
                            this.ratios = ratios;
                            this.matrix = matrix;
                            this.spreadMethod = spreadMethod;
                            this.interpolationMethod = axCoerceString(interpolationMethod);
                            this.focalPointRatio = +focalPointRatio;
                        }
                        GraphicsGradientFill.classInitializer = null;
                        return GraphicsGradientFill;
                    })(AS.ASObject);
                    display.GraphicsGradientFill = GraphicsGradientFill;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsPath
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var GraphicsPath = (function (_super) {
                        __extends(GraphicsPath, _super);
                        function GraphicsPath(commands, data, winding) {
                            if (commands === void 0) { commands = null; }
                            if (data === void 0) { data = null; }
                            if (winding === void 0) { winding = "evenOdd"; }
                            _super.call(this);
                            this.commands = commands;
                            this.data = data;
                            this.winding = axCoerceString(winding);
                        }
                        // Called whenever the class is initialized.
                        GraphicsPath.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsPath.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsPath.instanceSymbols = null; // ["commands", "data", "_winding", "winding", "winding", "moveTo", "lineTo", "curveTo", "cubicCurveTo", "wideLineTo", "wideMoveTo", "ensureLists"];
                        return GraphicsPath;
                    })(AS.ASObject);
                    display.GraphicsPath = GraphicsPath;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsPathCommand
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var GraphicsPathCommand = (function (_super) {
                        __extends(GraphicsPathCommand, _super);
                        function GraphicsPathCommand() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        GraphicsPathCommand.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsPathCommand.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsPathCommand.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        GraphicsPathCommand.NO_OP = undefined;
                        GraphicsPathCommand.MOVE_TO = 1;
                        GraphicsPathCommand.LINE_TO = 2;
                        GraphicsPathCommand.CURVE_TO = 3;
                        GraphicsPathCommand.WIDE_MOVE_TO = 4;
                        GraphicsPathCommand.WIDE_LINE_TO = 5;
                        GraphicsPathCommand.CUBIC_CURVE_TO = 6;
                        return GraphicsPathCommand;
                    })(AS.ASObject);
                    display.GraphicsPathCommand = GraphicsPathCommand;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsPathWinding
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var GraphicsPathWinding = (function (_super) {
                        __extends(GraphicsPathWinding, _super);
                        function GraphicsPathWinding() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        GraphicsPathWinding.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsPathWinding.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsPathWinding.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        GraphicsPathWinding.EVEN_ODD = "evenOdd";
                        GraphicsPathWinding.NON_ZERO = "nonZero";
                        return GraphicsPathWinding;
                    })(AS.ASObject);
                    display.GraphicsPathWinding = GraphicsPathWinding;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsSolidFill
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var GraphicsSolidFill = (function (_super) {
                        __extends(GraphicsSolidFill, _super);
                        function GraphicsSolidFill(color, alpha) {
                            if (color === void 0) { color = 0; }
                            if (alpha === void 0) { alpha = 1; }
                            _super.call(this);
                            this.color = color >>> 0;
                            this.alpha = +alpha;
                        }
                        // Called whenever the class is initialized.
                        GraphicsSolidFill.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsSolidFill.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsSolidFill.instanceSymbols = null; // ["color", "alpha"];
                        return GraphicsSolidFill;
                    })(AS.ASObject);
                    display.GraphicsSolidFill = GraphicsSolidFill;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsStroke
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var GraphicsStroke = (function (_super) {
                        __extends(GraphicsStroke, _super);
                        function GraphicsStroke(thickness, pixelHinting, scaleMode, caps, joints, miterLimit, fill) {
                            if (thickness === void 0) { thickness = NaN; }
                            if (pixelHinting === void 0) { pixelHinting = false; }
                            if (scaleMode === void 0) { scaleMode = "normal"; }
                            if (caps === void 0) { caps = "none"; }
                            if (joints === void 0) { joints = "round"; }
                            if (miterLimit === void 0) { miterLimit = 3; }
                            if (fill === void 0) { fill = null; }
                            _super.call(this);
                            this.thickness = +thickness;
                            this.pixelHinting = !!pixelHinting;
                            this.scaleMode = axCoerceString(scaleMode);
                            this.caps = axCoerceString(caps);
                            this.joints = axCoerceString(joints);
                            this.miterLimit = +miterLimit;
                            this.fill = fill;
                        }
                        // Called whenever the class is initialized.
                        GraphicsStroke.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsStroke.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsStroke.instanceSymbols = null; // ["thickness", "pixelHinting", "miterLimit", "fill", "_scaleMode", "_caps", "_joints", "scaleMode", "scaleMode", "caps", "caps", "joints", "joints"];
                        return GraphicsStroke;
                    })(AS.ASObject);
                    display.GraphicsStroke = GraphicsStroke;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: GraphicsTrianglePath
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var GraphicsTrianglePath = (function (_super) {
                        __extends(GraphicsTrianglePath, _super);
                        function GraphicsTrianglePath(vertices, indices, uvtData, culling) {
                            if (vertices === void 0) { vertices = null; }
                            if (indices === void 0) { indices = null; }
                            if (uvtData === void 0) { uvtData = null; }
                            if (culling === void 0) { culling = "none"; }
                            _super.call(this);
                            // TODO: coerce to vector types
                            this.vertices = vertices;
                            this.indices = indices;
                            this.uvtData = uvtData;
                            this.culling = axCoerceString(culling);
                        }
                        // Called whenever the class is initialized.
                        GraphicsTrianglePath.classInitializer = null;
                        // List of static symbols to link.
                        GraphicsTrianglePath.classSymbols = null; // [];
                        // List of instance symbols to link.
                        GraphicsTrianglePath.instanceSymbols = null; // ["indices", "vertices", "uvtData", "_culling", "culling", "culling"];
                        return GraphicsTrianglePath;
                    })(AS.ASObject);
                    display.GraphicsTrianglePath = GraphicsTrianglePath;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Graphics
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var clamp = Shumway.NumberUtilities.clamp;
                    var Bounds = Shumway.Bounds;
                    var assert = Shumway.Debug.assert;
                    var assertUnreachable = Shumway.Debug.assertUnreachable;
                    var GradientType = flash.display.GradientType;
                    var SpreadMethod = flash.display.SpreadMethod;
                    var InterpolationMethod = flash.display.InterpolationMethod;
                    var LineScaleMode = flash.display.LineScaleMode;
                    var CapsStyle = flash.display.CapsStyle;
                    var JointStyle = flash.display.JointStyle;
                    var ShapeData = Shumway.ShapeData;
                    function distanceSq(x1, y1, x2, y2) {
                        var dX = x2 - x1;
                        var dY = y2 - y1;
                        return dX * dX + dY * dY;
                    }
                    function quadraticBezier(from, cp, to, t) {
                        var inverseT = 1 - t;
                        return from * inverseT * inverseT + 2 * cp * inverseT * t + to * t * t;
                    }
                    function quadraticBezierExtreme(from, cp, to) {
                        var t = (from - cp) / (from - 2 * cp + to);
                        if (t < 0) {
                            return from;
                        }
                        if (t > 1) {
                            return to;
                        }
                        return quadraticBezier(from, cp, to, t);
                    }
                    function cubicBezier(from, cp, cp2, to, t) {
                        var tSq = t * t;
                        var inverseT = 1 - t;
                        var inverseTSq = inverseT * inverseT;
                        return from * inverseT * inverseTSq + 3 * cp * t * inverseTSq +
                            3 * cp2 * inverseT * tSq + to * t * tSq;
                    }
                    function cubicBezierExtremes(from, cp, cp2, to) {
                        var d1 = cp - from;
                        var d2 = cp2 - cp;
                        // We only ever need d2 * 2
                        d2 *= 2;
                        var d3 = to - cp2;
                        // Prevent division by zero by very slightly changing d3 if that would happen
                        if (d1 + d3 === d2) {
                            d3 *= 1.0001;
                        }
                        var fHead = 2 * d1 - d2;
                        var part1 = d2 - 2 * d1;
                        var fCenter = Math.sqrt(part1 * part1 - 4 * d1 * (d1 - d2 + d3));
                        var fTail = 2 * (d1 - d2 + d3);
                        var t1 = (fHead + fCenter) / fTail;
                        var t2 = (fHead - fCenter) / fTail;
                        var result = [];
                        if (t1 >= 0 && t1 <= 1) {
                            result.push(Math.round(cubicBezier(from, cp, cp2, to, t1)));
                        }
                        if (t2 >= 0 && t2 <= 1) {
                            result.push(Math.round(cubicBezier(from, cp, cp2, to, t2)));
                        }
                        return result;
                    }
                    function cubicXAtY(x0, y0, cx, cy, cx1, cy1, x1, y1, y) {
                        var dX = 3.0 * (cx - x0);
                        var dY = 3.0 * (cy - y0);
                        var bX = 3.0 * (cx1 - cx) - dX;
                        var bY = 3.0 * (cy1 - cy) - dY;
                        var c3X = x1 - x0 - dX - bX;
                        var c3Y = y1 - y0 - dY - bY;
                        // Find one root - any root - then factor out (t-r) to get a quadratic poly.
                        function f(t) {
                            return t * (dY + t * (bY + t * c3Y)) + y0 - y;
                        }
                        function pointAt(t) {
                            if (t < 0) {
                                t = 0;
                            }
                            else if (t > 1) {
                                t = 1;
                            }
                            return x0 + t * (dX + t * (bX + t * c3X));
                        }
                        // Bisect the specified range to isolate an interval with a root.
                        function bisectCubicBezierRange(f, l, r, limit) {
                            if (Math.abs(r - l) <= limit) {
                                return;
                            }
                            var middle = 0.5 * (l + r);
                            if (f(l) * f(r) <= 0) {
                                left = l;
                                right = r;
                                return;
                            }
                            bisectCubicBezierRange(f, l, middle, limit);
                            bisectCubicBezierRange(f, middle, r, limit);
                        }
                        // some curves that loop around on themselves may require bisection
                        var left = 0;
                        var right = 1;
                        bisectCubicBezierRange(f, 0, 1, 0.05);
                        // experiment with tolerance - but not too tight :)
                        var t0 = findRoot(left, right, f, 50, 0.000001);
                        var evalResult = Math.abs(f(t0));
                        if (evalResult > 0.00001) {
                            return [];
                        }
                        var result = [];
                        if (t0 <= 1) {
                            result.push(pointAt(t0));
                        }
                        // Factor theorem: t-r is a factor of the cubic polynomial if r is a root.
                        // Use this to reduce to a quadratic poly. using synthetic division
                        var a = c3Y;
                        var b = t0 * a + bY;
                        var c = t0 * b + dY;
                        // Process the quadratic for the remaining two possible roots
                        var d = b * b - 4 * a * c;
                        if (d < 0) {
                            return result;
                        }
                        d = Math.sqrt(d);
                        a = 1 / (a + a);
                        var t1 = (d - b) * a;
                        var t2 = (-b - d) * a;
                        if (t1 >= 0 && t1 <= 1) {
                            result.push(pointAt(t1));
                        }
                        if (t2 >= 0 && t2 <= 1) {
                            result.push(pointAt(t2));
                        }
                        return result;
                    }
                    function findRoot(x0, x2, f, maxIterations, epsilon) {
                        var x1;
                        var y0;
                        var y1;
                        var y2;
                        var b;
                        var c;
                        var y10;
                        var y20;
                        var y21;
                        var xm;
                        var ym;
                        var temp;
                        var xmlast = x0;
                        y0 = f(x0);
                        if (y0 === 0) {
                            return x0;
                        }
                        y2 = f(x2);
                        if (y2 === 0) {
                            return x2;
                        }
                        if (y2 * y0 > 0) {
                            // dispatchEvent( new Event(ERROR) );
                            return x0;
                        }
                        var __iter = 0;
                        for (var i = 0; i < maxIterations; ++i) {
                            __iter++;
                            x1 = 0.5 * (x2 + x0);
                            y1 = f(x1);
                            if (y1 === 0) {
                                return x1;
                            }
                            if (Math.abs(x1 - x0) < epsilon) {
                                return x1;
                            }
                            if (y1 * y0 > 0) {
                                temp = x0;
                                x0 = x2;
                                x2 = temp;
                                temp = y0;
                                y0 = y2;
                                y2 = temp;
                            }
                            y10 = y1 - y0;
                            y21 = y2 - y1;
                            y20 = y2 - y0;
                            if (y2 * y20 < 2 * y1 * y10) {
                                x2 = x1;
                                y2 = y1;
                            }
                            else {
                                b = (x1 - x0) / y10;
                                c = (y10 - y21) / (y21 * y20);
                                xm = x0 - b * y0 * (1 - c * y1);
                                ym = f(xm);
                                if (ym === 0) {
                                    return xm;
                                }
                                if (Math.abs(xm - xmlast) < epsilon) {
                                    return xm;
                                }
                                xmlast = xm;
                                if (ym * y0 < 0) {
                                    x2 = xm;
                                    y2 = ym;
                                }
                                else {
                                    x0 = xm;
                                    y0 = ym;
                                    x2 = x1;
                                    y2 = y1;
                                }
                            }
                        }
                        return x1;
                    }
                    // See http://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html
                    function rayIntersectsLine(x, y, x1, y1, x2, y2) {
                        return (y2 > y) !== (y1 > y) && x < (x1 - x2) * (y - y2) / (y1 - y2) + x2;
                    }
                    function rayFullyCrossesCurve(x, y, fromX, fromY, cpX, cpY, toX, toY) {
                        if ((cpY > y) === (fromY > y) && (toY > y) === (fromY > y)) {
                            return false;
                        }
                        if (fromX >= x && cpX >= x && toX >= x) {
                            return true;
                        }
                        // Finding the intersections with our ray means solving a quadratic
                        // equation of the form y = ax^2 + bx + c for y.
                        // See http://en.wikipedia.org/wiki/Quadratic_equation and
                        // http://code.google.com/p/degrafa/source/browse/trunk/Degrafa/com/degrafa/geometry/AdvancedQuadraticBezier.as?r=613#394
                        var a = fromY - 2 * cpY + toY;
                        var c = fromY - y;
                        var b = 2 * (cpY - fromY);
                        var d = b * b - 4 * a * c;
                        if (d < 0) {
                            return false;
                        }
                        d = Math.sqrt(d);
                        a = 1 / (a + a);
                        var t1 = (d - b) * a;
                        var t2 = (-b - d) * a;
                        var crosses = false;
                        if (t1 >= 0 && t1 <= 1 && quadraticBezier(fromX, cpX, toX, t1) > x) {
                            crosses = !crosses;
                        }
                        if (t2 >= 0 && t2 <= 1 && quadraticBezier(fromX, cpX, toX, t2) > x) {
                            crosses = !crosses;
                        }
                        return crosses;
                    }
                    function rayFullyCrossesCubicCurve(x, y, fromX, fromY, cpX, cpY, cp2X, cp2Y, toX, toY) {
                        var curveStartsAfterY = fromY > y;
                        if ((cpY > y) === curveStartsAfterY && (cp2Y > y) === curveStartsAfterY &&
                            (toY > y) === curveStartsAfterY) {
                            return false;
                        }
                        if (fromX < x && cpX < x && cp2X < x && toX < x) {
                            return false;
                        }
                        var crosses = false;
                        var roots = cubicXAtY(fromX, fromY, cpX, cpY, cp2X, cp2Y, toX, toY, y);
                        for (var i = roots.length; i; i--) {
                            if (roots[i] >= x) {
                                crosses = !crosses;
                            }
                        }
                        return crosses;
                    }
                    // end of GFX geometry.ts
                    var Graphics = (function (_super) {
                        __extends(Graphics, _super);
                        function Graphics() {
                            _super.call(this);
                            this._id = flash.display.DisplayObject.getNextSyncID();
                            this._graphicsData = new ShapeData();
                            this._textures = [];
                            this._fillBounds = new Bounds(0x8000000, 0x8000000, 0x8000000, 0x8000000);
                            this._lineBounds = new Bounds(0x8000000, 0x8000000, 0x8000000, 0x8000000);
                            this._lastX = this._lastY = 0;
                            this._boundsIncludeLastCoordinates = true;
                            this._parent = null;
                            this._topLeftStrokeWidth = this._bottomRightStrokeWidth = 0;
                            this._isDirty = true;
                        }
                        Graphics.FromData = function (data, loaderInfo) {
                            var graphics = new loaderInfo.sec.flash.display.Graphics();
                            graphics._graphicsData = ShapeData.FromPlainObject(data.shape);
                            if (data.lineBounds) {
                                graphics._lineBounds.copyFrom(data.lineBounds);
                                graphics._fillBounds.copyFrom(data.fillBounds || data.lineBounds);
                            }
                            return graphics;
                        };
                        Graphics.prototype.getGraphicsData = function () {
                            return this._graphicsData;
                        };
                        Graphics.prototype.getUsedTextures = function () {
                            return this._textures;
                        };
                        /**
                         * Flash special-cases lines that are 1px and 3px wide.
                         * They're offset by 0.5px to the bottom-right.
                         */
                        Graphics.prototype._setStrokeWidth = function (width) {
                            switch (width) {
                                case 1:
                                    this._topLeftStrokeWidth = 0;
                                    this._bottomRightStrokeWidth = 1;
                                    break;
                                case 3:
                                    this._topLeftStrokeWidth = 1;
                                    this._bottomRightStrokeWidth = 2;
                                    break;
                                default:
                                    var half = Math.ceil(width * 0.5) | 0;
                                    this._topLeftStrokeWidth = half;
                                    this._bottomRightStrokeWidth = half;
                                    break;
                            }
                        };
                        Graphics.prototype._setParent = function (parent) {
                            release || assert(!this._parent);
                            this._parent = parent;
                        };
                        Graphics.prototype._invalidate = function () {
                            release || assert(this._parent, "Graphics instances must have a parent.");
                            this._parent._invalidateFillAndLineBounds(true, true);
                            this._parent._propagateFlagsUp(536870912 /* DirtyDescendents */);
                            this._isDirty = true;
                        };
                        Graphics.prototype._getContentBounds = function (includeStrokes) {
                            if (includeStrokes === void 0) { includeStrokes = true; }
                            return includeStrokes ? this._lineBounds : this._fillBounds;
                        };
                        Graphics.prototype.clear = function () {
                            if (this._graphicsData.isEmpty()) {
                                return;
                            }
                            this._graphicsData.clear();
                            this._textures.length = 0;
                            this._fillBounds.setToSentinels();
                            this._lineBounds.setToSentinels();
                            this._lastX = this._lastY = 0;
                            this._boundsIncludeLastCoordinates = false;
                            this._invalidate();
                        };
                        /**
                         * Sets a solid color and opacity as the fill for subsequent drawing commands.
                         *
                         * @see http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/display/Graphics.html#beginFill%28%29
                         * @param color
                         * @param alpha While any Number is a valid input, the value is clamped to [0,1] and then scaled
                         * to an integer in the interval [0,0xff].
                         */
                        Graphics.prototype.beginFill = function (color /*uint*/, alpha) {
                            if (alpha === void 0) { alpha = 1; }
                            color = color >>> 0 & 0xffffff;
                            alpha = Math.round(clamp(+alpha, -1, 1) * 0xff) | 0;
                            this._graphicsData.beginFill((color << 8) | alpha);
                        };
                        Graphics.prototype.beginGradientFill = function (type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio) {
                            if (matrix === void 0) { matrix = null; }
                            if (spreadMethod === void 0) { spreadMethod = "pad"; }
                            if (interpolationMethod === void 0) { interpolationMethod = "rgb"; }
                            if (focalPointRatio === void 0) { focalPointRatio = 0; }
                            this._writeGradientStyle(2 /* BeginGradientFill */, type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio, false);
                        };
                        Graphics.prototype.beginBitmapFill = function (bitmap, matrix, repeat, smooth) {
                            if (matrix === void 0) { matrix = null; }
                            if (repeat === void 0) { repeat = true; }
                            if (smooth === void 0) { smooth = false; }
                            this._writeBitmapStyle(3 /* BeginBitmapFill */, bitmap, matrix, repeat, smooth, false);
                        };
                        Graphics.prototype.endFill = function () {
                            this._graphicsData.endFill();
                        };
                        //    beginShaderFill(shader: flash.display.Shader, matrix: flash.geom.Matrix = null): void {
                        //      //shader = shader; matrix = matrix;
                        //      release || notImplemented("public flash.display.Graphics::beginShaderFill"); return;
                        //    }
                        Graphics.prototype.lineStyle = function (thickness, color, alpha, pixelHinting, scaleMode, caps, joints, miterLimit) {
                            if (color === void 0) { color = 0; }
                            if (alpha === void 0) { alpha = 1; }
                            if (pixelHinting === void 0) { pixelHinting = false; }
                            if (scaleMode === void 0) { scaleMode = "normal"; }
                            if (caps === void 0) { caps = null; }
                            if (joints === void 0) { joints = null; }
                            if (miterLimit === void 0) { miterLimit = 3; }
                            thickness = +thickness;
                            color = color >>> 0 & 0xffffff;
                            alpha = Math.round(clamp(+alpha, -1, 1) * 0xff);
                            pixelHinting = !!pixelHinting;
                            scaleMode = axCoerceString(scaleMode);
                            caps = axCoerceString(caps);
                            joints = axCoerceString(joints);
                            miterLimit = clamp(+miterLimit | 0, 0, 0xff);
                            // Flash stops drawing strokes whenever a thickness is supplied that can't be coerced to a
                            // number.
                            if (isNaN(thickness)) {
                                this._setStrokeWidth(0);
                                this._graphicsData.endLine();
                                return;
                            }
                            thickness = clamp(+thickness, 0, 0xff) * 20 | 0;
                            this._setStrokeWidth(thickness);
                            // If `scaleMode` is invalid, "normal" is used.
                            var lineScaleMode = LineScaleMode.toNumber(axCoerceString(scaleMode));
                            if (lineScaleMode < 0) {
                                lineScaleMode = LineScaleMode.toNumber(LineScaleMode.NORMAL);
                            }
                            // If `caps` is invalid, "normal" is used.
                            var capsStyle = CapsStyle.toNumber(axCoerceString(caps));
                            if (capsStyle < 0) {
                                capsStyle = CapsStyle.toNumber(CapsStyle.ROUND);
                            }
                            // If `joints` is invalid, "normal" is used.
                            var jointStyle = JointStyle.toNumber(axCoerceString(joints));
                            if (jointStyle < 0) {
                                jointStyle = JointStyle.toNumber(JointStyle.ROUND);
                            }
                            this._graphicsData.lineStyle(thickness, (color << 8) | alpha, pixelHinting, lineScaleMode, capsStyle, jointStyle, miterLimit);
                        };
                        Graphics.prototype.lineGradientStyle = function (type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio) {
                            if (matrix === void 0) { matrix = null; }
                            if (spreadMethod === void 0) { spreadMethod = "pad"; }
                            if (interpolationMethod === void 0) { interpolationMethod = "rgb"; }
                            if (focalPointRatio === void 0) { focalPointRatio = 0; }
                            this._writeGradientStyle(6 /* LineStyleGradient */, type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio, !this._graphicsData.hasLines);
                        };
                        Graphics.prototype.lineBitmapStyle = function (bitmap, matrix, repeat, smooth) {
                            if (matrix === void 0) { matrix = null; }
                            if (repeat === void 0) { repeat = true; }
                            if (smooth === void 0) { smooth = false; }
                            this._writeBitmapStyle(7 /* LineStyleBitmap */, bitmap, matrix, repeat, smooth, !this._graphicsData.hasLines);
                        };
                        Graphics.prototype.drawRect = function (x, y, width, height) {
                            x = x * 20 | 0;
                            y = y * 20 | 0;
                            var x2 = x + (width * 20 | 0);
                            var y2 = y + (height * 20 | 0);
                            if (x !== this._lastX || y !== this._lastY) {
                                this._graphicsData.moveTo(x, y);
                            }
                            this._graphicsData.lineTo(x2, y);
                            this._graphicsData.lineTo(x2, y2);
                            this._graphicsData.lineTo(x, y2);
                            this._graphicsData.lineTo(x, y);
                            this._extendBoundsByPoint(x2, y2);
                            this._applyLastCoordinates(x, y);
                            this._invalidate();
                        };
                        Graphics.prototype.drawRoundRect = function (x, y, width, height, ellipseWidth, ellipseHeight) {
                            x = +x;
                            y = +y;
                            width = +width;
                            height = +height;
                            ellipseWidth = +ellipseWidth;
                            ellipseHeight = +ellipseHeight;
                            if (!ellipseHeight || !ellipseWidth) {
                                this.drawRect(x, y, width, height);
                                return;
                            }
                            var radiusX = (ellipseWidth / 2) | 0;
                            var radiusY = (ellipseHeight / 2) | 0;
                            var hw = width / 2;
                            var hh = height / 2;
                            if (radiusX > hw) {
                                radiusX = hw;
                            }
                            if (radiusY > hh) {
                                radiusY = hh;
                            }
                            if (hw === radiusX && hh === radiusY) {
                                if (radiusX === radiusY) {
                                    this.drawCircle(x + radiusX, y + radiusY, radiusX);
                                }
                                else {
                                    this.drawEllipse(x, y, radiusX * 2, radiusY * 2);
                                }
                                return;
                            }
                            //    A-----B
                            //  H         C
                            //  G         D
                            //    F-----E
                            //
                            // Drawing starts and stops at `D`. This is visible when the drawn shape forms part of a
                            // larger shape, with which it is then connected at `D`.
                            var right = x + width;
                            var bottom = y + height;
                            var xlw = x + radiusX;
                            var xrw = right - radiusX;
                            var ytw = y + radiusY;
                            var ybw = bottom - radiusY;
                            this.moveTo(right, ybw);
                            this.curveTo(right, bottom, xrw, bottom);
                            this.lineTo(xlw, bottom);
                            this.curveTo(x, bottom, x, ybw);
                            this.lineTo(x, ytw);
                            this.curveTo(x, y, xlw, y);
                            this.lineTo(xrw, y);
                            this.curveTo(right, y, right, ytw);
                            this.lineTo(right, ybw);
                        };
                        Graphics.prototype.drawRoundRectComplex = function (x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius) {
                            x = +x;
                            y = +y;
                            width = +width;
                            height = +height;
                            topLeftRadius = +topLeftRadius;
                            topRightRadius = +topRightRadius;
                            bottomLeftRadius = +bottomLeftRadius;
                            bottomRightRadius = +bottomRightRadius;
                            if (!(topLeftRadius | topRightRadius | bottomLeftRadius | bottomRightRadius)) {
                                this.drawRect(x, y, width, height);
                                return;
                            }
                            var right = x + width;
                            var bottom = y + height;
                            var xtl = x + topLeftRadius;
                            this.moveTo(right, bottom - bottomRightRadius);
                            this.curveTo(right, bottom, right - bottomRightRadius, bottom);
                            this.lineTo(x + bottomLeftRadius, bottom);
                            this.curveTo(x, bottom, x, bottom - bottomLeftRadius);
                            this.lineTo(x, y + topLeftRadius);
                            this.curveTo(x, y, xtl, y);
                            this.lineTo(right - topRightRadius, y);
                            this.curveTo(right, y, right, y + topRightRadius);
                            this.lineTo(right, bottom - bottomRightRadius);
                        };
                        Graphics.prototype.drawCircle = function (x, y, radius) {
                            // TODO: Implement these using arcs not ellipses. The latter is not
                            // visually correct when the stroke is very thick and the circle is
                            // very small.
                            radius = +radius;
                            this.drawEllipse(+x - radius, +y - radius, radius * 2, radius * 2);
                        };
                        /**
                         * Here x and y are the top-left coordinates of the bounding box of the
                         * ellipse not the center as is the case for circles.
                         */
                        Graphics.prototype.drawEllipse = function (x, y, width, height) {
                            x = +x;
                            y = +y;
                            width = +width;
                            height = +height;
                            /*
                             *          , - ~ 3 ~ - ,
                             *      , '               ' ,
                             *    ,                       ,
                             *   ,                         ,
                             *  ,                           ,
                             *  2             o             0
                             *  ,                           ,
                             *   ,                         ,
                             *    ,                       ,
                             *      ,                  , '
                             *        ' - , _ 1 _ ,  '
                             */
                            var rx = width / 2;
                            var ry = height / 2;
                            // Move x, y to the middle of the ellipse.
                            x += rx;
                            y += ry;
                            var currentX = x + rx;
                            var currentY = y;
                            this.moveTo(currentX, currentY); // 0
                            var startAngle = 0;
                            var u = 1;
                            var v = 0;
                            for (var i = 0; i < 4; i++) {
                                var endAngle = startAngle + Math.PI / 2;
                                var kappa = (4 / 3) * Math.tan((endAngle - startAngle) / 4);
                                var cp1x = currentX - v * kappa * rx;
                                var cp1y = currentY + u * kappa * ry;
                                u = Math.cos(endAngle);
                                v = Math.sin(endAngle);
                                currentX = x + u * rx;
                                currentY = y + v * ry;
                                var cp2x = currentX + v * kappa * rx;
                                var cp2y = currentY - u * kappa * ry;
                                this.cubicCurveTo(cp1x, cp1y, cp2x, cp2y, currentX, currentY);
                                startAngle = endAngle;
                            }
                        };
                        Graphics.prototype.moveTo = function (x, y) {
                            x = x * 20 | 0;
                            y = y * 20 | 0;
                            this._graphicsData.moveTo(x, y);
                            // Don't use _applyLastCoordinates because that extends the bounds objects, too.
                            this._lastX = x;
                            this._lastY = y;
                            this._boundsIncludeLastCoordinates = false;
                        };
                        Graphics.prototype.lineTo = function (x, y) {
                            x = x * 20 | 0;
                            y = y * 20 | 0;
                            this._graphicsData.lineTo(x, y);
                            this._applyLastCoordinates(x, y);
                            this._invalidate();
                        };
                        Graphics.prototype.curveTo = function (controlX, controlY, anchorX, anchorY) {
                            controlX = controlX * 20 | 0;
                            controlY = controlY * 20 | 0;
                            anchorX = anchorX * 20 | 0;
                            anchorY = anchorY * 20 | 0;
                            this._graphicsData.curveTo(controlX, controlY, anchorX, anchorY);
                            if (controlX < this._lastX || controlX > anchorX) {
                                this._extendBoundsByX(quadraticBezierExtreme(this._lastX, controlX, anchorX) | 0);
                            }
                            if (controlY < this._lastY || controlY > anchorY) {
                                this._extendBoundsByY(quadraticBezierExtreme(this._lastY, controlY, anchorY) | 0);
                            }
                            this._applyLastCoordinates(anchorX, anchorY);
                            this._invalidate();
                        };
                        Graphics.prototype.cubicCurveTo = function (controlX1, controlY1, controlX2, controlY2, anchorX, anchorY) {
                            controlX1 = controlX1 * 20 | 0;
                            controlY1 = controlY1 * 20 | 0;
                            controlX2 = controlX2 * 20 | 0;
                            controlY2 = controlY2 * 20 | 0;
                            anchorX = anchorX * 20 | 0;
                            anchorY = anchorY * 20 | 0;
                            this._graphicsData.cubicCurveTo(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY);
                            var extremes;
                            var i;
                            var fromX = this._lastX;
                            var fromY = this._lastY;
                            if (controlX1 < fromX || controlX2 < fromX || controlX1 > anchorX || controlX2 > anchorX) {
                                extremes = cubicBezierExtremes(fromX, controlX1, controlX2, anchorX);
                                for (i = extremes.length; i--;) {
                                    this._extendBoundsByX(extremes[i] | 0);
                                }
                            }
                            if (controlY1 < fromY || controlY2 < fromY || controlY1 > anchorY || controlY2 > anchorY) {
                                extremes = cubicBezierExtremes(fromY, controlY1, controlY2, anchorY);
                                for (i = extremes.length; i--;) {
                                    this._extendBoundsByY(extremes[i] | 0);
                                }
                            }
                            this._applyLastCoordinates(anchorX, anchorY);
                            this._invalidate();
                        };
                        Graphics.prototype.copyFrom = function (sourceGraphics) {
                            this._graphicsData = sourceGraphics._graphicsData.clone();
                            this._fillBounds = sourceGraphics._fillBounds.clone();
                            this._lineBounds = sourceGraphics._lineBounds.clone();
                            this._textures = sourceGraphics._textures.concat();
                            this._lastX = sourceGraphics._lastX;
                            this._lastY = sourceGraphics._lastY;
                            this._boundsIncludeLastCoordinates = sourceGraphics._boundsIncludeLastCoordinates;
                            this._invalidate();
                        };
                        //    lineShaderStyle(shader: flash.display.Shader, matrix: flash.geom.Matrix = null): void {
                        //      //shader = shader; matrix = matrix;
                        //      release || notImplemented("public flash.display.Graphics::lineShaderStyle"); return;
                        //    }
                        Graphics.prototype.drawPath = function (commands, data, winding) {
                            if (winding === void 0) { winding = "evenOdd"; }
                            commands = commands;
                            data = data;
                            winding = axCoerceString(winding);
                            release || notImplemented("public flash.display.Graphics::drawPath");
                            return;
                        };
                        Graphics.prototype.drawTriangles = function (vertices, indices, uvtData, culling) {
                            if (indices === void 0) { indices = null; }
                            if (uvtData === void 0) { uvtData = null; }
                            if (culling === void 0) { culling = "none"; }
                            vertices = vertices;
                            indices = indices;
                            uvtData = uvtData;
                            culling = axCoerceString(culling);
                            release || notImplemented("public flash.display.Graphics::drawTriangles");
                            return;
                        };
                        Graphics.prototype.drawGraphicsData = function (graphicsData) {
                            graphicsData = graphicsData;
                            release || notImplemented("public flash.display.Graphics::drawGraphicsData");
                            return;
                        };
                        /**
                         * Tests if the specified point is within this graphics path.
                         */
                        Graphics.prototype._containsPoint = function (x, y, includeLines, ratio) {
                            var hasLines = this._graphicsData.hasLines;
                            if (!ratio && !(includeLines && hasLines ? this._lineBounds : this._fillBounds).contains(x, y)) {
                                return false;
                            }
                            //      enterTimeline("Graphics._containsPoint");
                            var containsPoint = false;
                            // If we have any fills at all, tt's vastly more likely that the point is in a fill,
                            // so test that first.
                            if (this._graphicsData.hasFills) {
                                containsPoint = this._fillContainsPoint(x, y, ratio);
                            }
                            else {
                                release || assert(hasLines, "Can't have non-empty bounds without line or fill set.");
                            }
                            if (!containsPoint && includeLines) {
                                containsPoint = this._linesContainsPoint(x, y, ratio);
                            }
                            //      leaveTimeline();
                            return containsPoint;
                        };
                        Graphics.prototype._fillContainsPoint = function (x, y, ratio) {
                            //      enterTimeline("Graphics._fillContainsPoint");
                            var data = this._graphicsData;
                            var commands = data.commands;
                            var commandsCount = data.commandsPosition;
                            var coordinates = data.coordinates;
                            var morphCoordinates = data.morphCoordinates;
                            var coordinatesIndex = 0;
                            var fromX = 0;
                            var fromY = 0;
                            var toX = 0;
                            var toY = 0;
                            var cpX;
                            var cpY;
                            var formOpen = false;
                            var fillActive = false;
                            var formOpenX = 0;
                            var formOpenY = 0;
                            var inside = false;
                            // Description of serialization format can be found in ShapeData.
                            // Rough outline of the algorithm's mode of operation:
                            // from x,y an infinite ray to the right is "cast". All operations are then
                            // tested for intersections with this ray, where each intersection means
                            // switching between being outside and inside the shape.
                            for (var commandIndex = 0; commandIndex < commandsCount; commandIndex++) {
                                var command = commands[commandIndex];
                                switch (command) {
                                    case 9 /* MoveTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 2);
                                        if (formOpen && fillActive &&
                                            rayIntersectsLine(x, y, fromX, fromY, formOpenX, formOpenY)) {
                                            inside = !inside;
                                        }
                                        formOpen = true;
                                        fromX = formOpenX = coordinates[coordinatesIndex++];
                                        fromY = formOpenY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            fromX = formOpenX += (morphCoordinates[coordinatesIndex - 2] - formOpenX) * ratio;
                                            fromY = formOpenY += (morphCoordinates[coordinatesIndex - 2] - formOpenY) * ratio;
                                        }
                                        // Continue outer loop.
                                        continue;
                                    case 10 /* LineTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 2);
                                        toX = coordinates[coordinatesIndex++];
                                        toY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            toX += (morphCoordinates[coordinatesIndex - 2] - toX) * ratio;
                                            toY += (morphCoordinates[coordinatesIndex - 1] - toY) * ratio;
                                        }
                                        if (fillActive && rayIntersectsLine(x, y, fromX, fromY, toX, toY)) {
                                            inside = !inside;
                                        }
                                        break;
                                    case 11 /* CurveTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 4);
                                        cpX = coordinates[coordinatesIndex++];
                                        cpY = coordinates[coordinatesIndex++];
                                        toX = coordinates[coordinatesIndex++];
                                        toY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            cpX += (morphCoordinates[coordinatesIndex - 4] - cpX) * ratio;
                                            cpY += (morphCoordinates[coordinatesIndex - 3] - cpY) * ratio;
                                            toX += (morphCoordinates[coordinatesIndex - 2] - toX) * ratio;
                                            toY += (morphCoordinates[coordinatesIndex - 1] - toY) * ratio;
                                        }
                                        if (fillActive && rayFullyCrossesCurve(x, y, fromX, fromY, cpX, cpY, toX, toY)) {
                                            inside = !inside;
                                        }
                                        break;
                                    case 12 /* CubicCurveTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 6);
                                        cpX = coordinates[coordinatesIndex++];
                                        cpY = coordinates[coordinatesIndex++];
                                        var cp2X = coordinates[coordinatesIndex++];
                                        var cp2Y = coordinates[coordinatesIndex++];
                                        toX = coordinates[coordinatesIndex++];
                                        toY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            cpX += (morphCoordinates[coordinatesIndex - 6] - cpX) * ratio;
                                            cpY += (morphCoordinates[coordinatesIndex - 5] - cpY) * ratio;
                                            cp2X += (morphCoordinates[coordinatesIndex - 4] - cp2X) * ratio;
                                            cp2Y += (morphCoordinates[coordinatesIndex - 3] - cp2Y) * ratio;
                                            toX += (morphCoordinates[coordinatesIndex - 2] - toX) * ratio;
                                            toY += (morphCoordinates[coordinatesIndex - 1] - toY) * ratio;
                                        }
                                        if (fillActive &&
                                            rayFullyCrossesCubicCurve(x, y, fromX, fromY, cpX, cpY, cp2X, cp2Y, toX, toY)) {
                                            inside = !inside;
                                        }
                                        break;
                                    case 1 /* BeginSolidFill */:
                                    case 2 /* BeginGradientFill */:
                                    case 3 /* BeginBitmapFill */:
                                    case 4 /* EndFill */:
                                        if (formOpen && fillActive &&
                                            rayIntersectsLine(x, y, fromX, fromY, formOpenX, formOpenY)) {
                                            inside = !inside;
                                        }
                                        // If we close a sub-shape, we can return earlier if our point was inside of its path.
                                        if (inside) {
                                            return true;
                                        }
                                        formOpen = false;
                                        fillActive = command !== 4 /* EndFill */;
                                        break;
                                    case 5 /* LineStyleSolid */:
                                        coordinatesIndex++; // Skip thickness
                                        break;
                                    case 6 /* LineStyleGradient */:
                                    case 7 /* LineStyleBitmap */:
                                    case 8 /* LineEnd */:
                                        break;
                                    default:
                                        release || assertUnreachable('Invalid command ' + command + ' encountered at index' +
                                            (commandIndex - 1) + ' of ' + commandsCount);
                                }
                                fromX = toX;
                                fromY = toY;
                            }
                            release || assert(commandIndex === commandsCount);
                            release || assert(coordinatesIndex === data.coordinatesPosition);
                            if (formOpen && fillActive &&
                                rayIntersectsLine(x, y, fromX, fromY, formOpenX, formOpenY)) {
                                inside = !inside;
                            }
                            //      leaveTimeline();
                            return inside;
                        };
                        Graphics.prototype._linesContainsPoint = function (x, y, ratio) {
                            //      enterTimeline("Graphics._lineContainsPoint");
                            var data = this._graphicsData;
                            var commands = data.commands;
                            var commandsCount = data.commandsPosition;
                            var coordinates = data.coordinates;
                            var morphCoordinates = data.morphCoordinates;
                            var coordinatesIndex = 0;
                            var fromX = 0;
                            var fromY = 0;
                            var toX = 0;
                            var toY = 0;
                            var cpX;
                            var cpY;
                            var curveX;
                            var curveY;
                            var t;
                            var width = 0;
                            var halfWidth = 0;
                            var halfWidthSq = 0;
                            var minX = 0;
                            var maxX = 0;
                            var minY = 0;
                            var maxY = 0;
                            // Description of serialization format can be found in ShapeData.
                            for (var commandIndex = 0; commandIndex < commandsCount; commandIndex++) {
                                var command = commands[commandIndex];
                                switch (command) {
                                    case 9 /* MoveTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 2);
                                        fromX = coordinates[coordinatesIndex++];
                                        fromY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            fromX += (morphCoordinates[coordinatesIndex - 2] - fromX) * ratio;
                                            fromY += (morphCoordinates[coordinatesIndex - 1] - fromY) * ratio;
                                        }
                                        // Continue outer loop.
                                        continue;
                                    case 10 /* LineTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 2);
                                        if (width === 0) {
                                            fromX = coordinates[coordinatesIndex++];
                                            fromY = coordinates[coordinatesIndex++];
                                            if (ratio) {
                                                fromX += (morphCoordinates[coordinatesIndex - 2] - fromX) * ratio;
                                                fromY += (morphCoordinates[coordinatesIndex - 1] - fromY) * ratio;
                                            }
                                            continue;
                                        }
                                        toX = coordinates[coordinatesIndex++];
                                        toY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            toX += (morphCoordinates[coordinatesIndex - 2] - toX) * ratio;
                                            toY += (morphCoordinates[coordinatesIndex - 1] - toY) * ratio;
                                        }
                                        // Lines with length == 0 aren't rendered.
                                        if (fromX === toX && fromY === toY) {
                                            break;
                                        }
                                        // Eliminate based on bounds.
                                        if (maxX < fromX && maxX < toX || minX > fromX && minX > toX ||
                                            maxY < fromY && maxY < toY || minY > fromY && minY > toY) {
                                            break;
                                        }
                                        // Vertical and horizontal lines are a certain hit at this point
                                        if (toX === fromX || toY === fromY) {
                                            return true;
                                        }
                                        // http://stackoverflow.com/a/1501725/517791
                                        t = ((x - fromX) * (toX - fromX) + (y - fromY) * (toY - fromY)) /
                                            distanceSq(fromX, fromY, toX, toY);
                                        if (t < 0) {
                                            if (distanceSq(x, y, fromX, fromY) <= halfWidthSq) {
                                                return true;
                                            }
                                            break;
                                        }
                                        if (t > 1) {
                                            if (distanceSq(x, y, toX, toY) <= halfWidthSq) {
                                                return true;
                                            }
                                            break;
                                        }
                                        if (distanceSq(x, y, fromX + t * (toX - fromX), fromY + t * (toY - fromY)) <= halfWidthSq) {
                                            return true;
                                        }
                                        break;
                                    case 11 /* CurveTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 4);
                                        if (width === 0) {
                                            coordinatesIndex += 2;
                                            fromX = coordinates[coordinatesIndex++];
                                            fromY = coordinates[coordinatesIndex++];
                                            if (ratio) {
                                                fromX += (morphCoordinates[coordinatesIndex - 2] - fromX) * ratio;
                                                fromY += (morphCoordinates[coordinatesIndex - 1] - fromY) * ratio;
                                            }
                                            continue;
                                        }
                                        cpX = coordinates[coordinatesIndex++];
                                        cpY = coordinates[coordinatesIndex++];
                                        toX = coordinates[coordinatesIndex++];
                                        toY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            cpX += (morphCoordinates[coordinatesIndex - 4] - cpX) * ratio;
                                            cpY += (morphCoordinates[coordinatesIndex - 3] - cpY) * ratio;
                                            toX += (morphCoordinates[coordinatesIndex - 2] - toX) * ratio;
                                            toY += (morphCoordinates[coordinatesIndex - 1] - toY) * ratio;
                                        }
                                        // Eliminate based on bounds
                                        var extremeX = quadraticBezierExtreme(fromX, cpX, toX);
                                        if (maxX < fromX && maxX < extremeX && maxX < toX ||
                                            minX > fromX && minX > extremeX && minX > toX) {
                                            break;
                                        }
                                        var extremeY = quadraticBezierExtreme(fromY, cpY, toY);
                                        if (maxY < fromY && maxY < extremeY && maxY < toY ||
                                            minY > fromY && minY > extremeY && minY > toY) {
                                            break;
                                        }
                                        // So, this is very much not ideal, but I'll punt on proper curve
                                        // hit-testing for now and just sample an amount of points that seems
                                        // sufficient.
                                        for (t = 0; t < 1; t += 0.02) {
                                            curveX = quadraticBezier(fromX, cpX, toX, t);
                                            if (curveX < minX || curveX > maxX) {
                                                continue;
                                            }
                                            curveY = quadraticBezier(fromY, cpY, toY, t);
                                            if (curveY < minY || curveY > maxY) {
                                                continue;
                                            }
                                            if ((x - curveX) * (x - curveX) + (y - curveY) * (y - curveY) < halfWidthSq) {
                                                return true;
                                            }
                                        }
                                        break;
                                    case 12 /* CubicCurveTo */:
                                        release || assert(coordinatesIndex <= data.coordinatesPosition - 6);
                                        if (width === 0) {
                                            coordinatesIndex += 4;
                                            fromX = coordinates[coordinatesIndex++];
                                            fromX = coordinates[coordinatesIndex++];
                                            if (ratio) {
                                                fromX += (morphCoordinates[coordinatesIndex - 2] - fromX) * ratio;
                                                fromY += (morphCoordinates[coordinatesIndex - 1] - fromY) * ratio;
                                            }
                                            continue;
                                        }
                                        cpX = coordinates[coordinatesIndex++];
                                        cpY = coordinates[coordinatesIndex++];
                                        var cp2X = coordinates[coordinatesIndex++];
                                        var cp2Y = coordinates[coordinatesIndex++];
                                        toX = coordinates[coordinatesIndex++];
                                        toY = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            cpX += (morphCoordinates[coordinatesIndex - 6] - cpX) * ratio;
                                            cpY += (morphCoordinates[coordinatesIndex - 5] - cpY) * ratio;
                                            cp2X += (morphCoordinates[coordinatesIndex - 4] - cp2X) * ratio;
                                            cp2Y += (morphCoordinates[coordinatesIndex - 3] - cp2Y) * ratio;
                                            toX += (morphCoordinates[coordinatesIndex - 2] - toX) * ratio;
                                            toY += (morphCoordinates[coordinatesIndex - 1] - toY) * ratio;
                                        }
                                        // Eliminate based on bounds
                                        var extremesX = cubicBezierExtremes(fromX, cpX, cp2X, toX);
                                        while (extremesX.length < 2) {
                                            extremesX.push(toX);
                                        }
                                        if (maxX < fromX && maxX < toX && maxX < extremesX[0] &&
                                            maxX < extremesX[1] ||
                                            minX > fromX && minX > toX && minX > extremesX[0] &&
                                                minX > extremesX[1]) {
                                            break;
                                        }
                                        var extremesY = cubicBezierExtremes(fromY, cpY, cp2Y, toY);
                                        while (extremesY.length < 2) {
                                            extremesY.push(toY);
                                        }
                                        if (maxY < fromY && maxY < toY && maxY < extremesY[0] &&
                                            maxY < extremesY[1] ||
                                            minY > fromY && minY > toY && minY > extremesY[0] &&
                                                minY > extremesY[1]) {
                                            break;
                                        }
                                        // So, this is very much not ideal, but I'll punt on proper curve
                                        // hit-testing for now and just sample an amount of points that seems
                                        // sufficient.
                                        for (t = 0; t < 1; t += 0.02) {
                                            curveX = cubicBezier(fromX, cpX, cp2X, toX, t);
                                            if (curveX < minX || curveX > maxX) {
                                                continue;
                                            }
                                            curveY = cubicBezier(fromY, cpY, cp2Y, toY, t);
                                            if (curveY < minY || curveY > maxY) {
                                                continue;
                                            }
                                            if ((x - curveX) * (x - curveX) + (y - curveY) * (y - curveY) < halfWidthSq) {
                                                return true;
                                            }
                                        }
                                        break;
                                    case 5 /* LineStyleSolid */:
                                        width = coordinates[coordinatesIndex++];
                                        if (ratio) {
                                            width += (morphCoordinates[coordinatesIndex - 1] - width) * ratio;
                                        }
                                        halfWidth = width >> 2;
                                        halfWidthSq = halfWidth * halfWidth;
                                        minX = x - halfWidth;
                                        maxX = x + halfWidth;
                                        minY = y - halfWidth;
                                        maxY = y + halfWidth;
                                        break;
                                    case 1 /* BeginSolidFill */:
                                    case 2 /* BeginGradientFill */:
                                    case 3 /* BeginBitmapFill */:
                                    case 4 /* EndFill */:
                                    case 6 /* LineStyleGradient */:
                                    case 7 /* LineStyleBitmap */:
                                    case 8 /* LineEnd */:
                                        break;
                                    default:
                                        release || assertUnreachable('Invalid command ' + command + ' encountered at index' +
                                            (commandIndex - 1) + ' of ' + commandsCount);
                                }
                                fromX = toX;
                                fromY = toY;
                            }
                            release || assert(commandIndex === commandsCount);
                            release || assert(coordinatesIndex === data.coordinatesPosition);
                            //      leaveTimeline();
                            return false;
                        };
                        /**
                         * Bitmaps are specified the same for fills and strokes, so we only need to serialize them
                         * once. The Parameter `pathCommand` is treated as the actual command to serialize, and must
                         * be one of PathCommand.BeginBitmapFill and PathCommand.LineStyleBitmap.
                         *
                         * This method doesn't actually write anything if the `skipWrite` argument is true. In that
                         * case, it only does arguments checks so the right exceptions are thrown.
                         */
                        Graphics.prototype._writeBitmapStyle = function (pathCommand, bitmap, matrix, repeat, smooth, skipWrite) {
                            if (Shumway.isNullOrUndefined(bitmap)) {
                                this.sec.throwError('TypeError', AVMX.Errors.NullPointerError, 'bitmap');
                            }
                            if (!(this.sec.flash.display.BitmapData.axIsType(bitmap))) {
                                this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, 'bitmap', 'flash.display.BitmapData');
                            }
                            if (Shumway.isNullOrUndefined(matrix)) {
                                matrix = this.sec.flash.geom.Matrix.axClass.FROZEN_IDENTITY_MATRIX;
                            }
                            else if (!(this.sec.flash.geom.Matrix.axIsType(matrix))) {
                                this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, 'matrix', 'flash.geom.Matrix');
                            }
                            repeat = !!repeat;
                            smooth = !!smooth;
                            if (skipWrite) {
                                return;
                            }
                            var index = this._textures.length;
                            this._textures.push(bitmap);
                            this._graphicsData.beginBitmap(pathCommand, index, matrix, repeat, smooth);
                        };
                        /**
                         * Gradients are specified the same for fills and strokes, so we only need to serialize them
                         * once. The Parameter `pathCommand` is treated as the actual command to serialize, and must
                         * be one of PathCommand.BeginGradientFill and PathCommand.LineStyleGradient.
                         *
                         * This method doesn't actually write anything if the `skipWrite` argument is true. In that
                         * case, it only does arguments checks so the right exceptions are thrown.
                         */
                        Graphics.prototype._writeGradientStyle = function (pathCommand, type, colors_, alphas_, ratios_, matrix, spreadMethod, interpolationMethod, focalPointRatio, skipWrite) {
                            if (Shumway.isNullOrUndefined(type)) {
                                this.sec.throwError('TypeError', AVMX.Errors.NullPointerError, 'type');
                            }
                            var gradientType = GradientType.toNumber(axCoerceString(type));
                            if (gradientType < 0) {
                                this.sec.throwError("ArgumentError", AVMX.Errors.InvalidEnumError, "type");
                            }
                            if (Shumway.isNullOrUndefined(colors_)) {
                                this.sec.throwError('TypeError', AVMX.Errors.NullPointerError, 'colors');
                            }
                            var arrayClass = this.sec.AXArray;
                            if (!arrayClass.axIsInstanceOf(colors_)) {
                                this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, 'colors', 'Array');
                            }
                            var colors = colors_.value;
                            if (Shumway.isNullOrUndefined(alphas_)) {
                                this.sec.throwError('TypeError', AVMX.Errors.NullPointerError, 'alphas');
                            }
                            if (!arrayClass.axIsInstanceOf(alphas_)) {
                                this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, 'alphas', 'Array');
                            }
                            var alphas = alphas_.value;
                            if (Shumway.isNullOrUndefined(ratios_)) {
                                this.sec.throwError('TypeError', AVMX.Errors.NullPointerError, 'ratios');
                            }
                            if (!arrayClass.axIsInstanceOf(ratios_)) {
                                this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, 'ratios', 'Array');
                            }
                            var ratios = ratios_.value;
                            var colorsRGBA = [];
                            var coercedRatios = [];
                            var colorStops = colors.length;
                            var recordsValid = colorStops === alphas.length && colorStops === ratios.length;
                            if (recordsValid) {
                                for (var i = 0; i < colorStops; i++) {
                                    var ratio = +ratios[i];
                                    if (ratio > 0xff || ratio < 0) {
                                        recordsValid = false;
                                        break;
                                    }
                                    colorsRGBA[i] = (colors[i] << 8 & 0xffffff00) | clamp(+alphas[i], 0, 1) * 0xff;
                                    coercedRatios[i] = ratio;
                                }
                            }
                            // If the colors, alphas and ratios arrays don't all have the same length or if any of the
                            // given ratios falls outside [0,0xff], Flash just ignores the gradient style.
                            if (!recordsValid) {
                                return;
                            }
                            if (Shumway.isNullOrUndefined(matrix)) {
                                matrix = this.sec.flash.geom.Matrix.axClass.FROZEN_IDENTITY_MATRIX;
                            }
                            else if (!(this.sec.flash.geom.Matrix.axIsType(matrix))) {
                                this.sec.throwError('TypeError', AVMX.Errors.CheckTypeFailedError, 'matrix', 'flash.geom.Matrix');
                            }
                            if (skipWrite) {
                                return;
                            }
                            // If `spreadMethod` is invalid, "pad" is used.
                            var spread = SpreadMethod.toNumber(axCoerceString(spreadMethod));
                            if (spread < 0) {
                                spread = SpreadMethod.toNumber(SpreadMethod.PAD);
                            }
                            // If `interpolationMethod` is invalid, "rgb" is used.
                            var interpolation = InterpolationMethod.toNumber(axCoerceString(interpolationMethod));
                            if (interpolation < 0) {
                                interpolation = InterpolationMethod.toNumber(InterpolationMethod.RGB);
                            }
                            // Matrix has to be transformed to ShapeMatrix because the scaling is totally different.
                            var scaledMatrix = {
                                a: matrix.a * 819.2, b: matrix.b * 819.2, c: matrix.c * 819.2,
                                d: matrix.d * 819.2, tx: matrix.tx, ty: matrix.ty
                            };
                            // Focal point is scaled by 0xff, divided by 2, rounded and stored as a signed short.
                            focalPointRatio = clamp(+focalPointRatio, -1, 1) / 2 * 0xff | 0;
                            this._graphicsData.beginGradient(pathCommand, colorsRGBA, coercedRatios, gradientType, scaledMatrix, spread, interpolation, focalPointRatio);
                        };
                        Graphics.prototype._extendBoundsByPoint = function (x, y) {
                            this._extendBoundsByX(x);
                            this._extendBoundsByY(y);
                        };
                        Graphics.prototype._extendBoundsByX = function (x) {
                            this._fillBounds.extendByX(x);
                            var bounds = this._lineBounds;
                            if (bounds.xMin === 0x8000000) {
                                bounds.xMin = x - this._topLeftStrokeWidth;
                                bounds.xMax = x + this._bottomRightStrokeWidth;
                            }
                            else {
                                bounds.xMin = Math.min(x - this._topLeftStrokeWidth, bounds.xMin);
                                bounds.xMax = Math.max(x + this._bottomRightStrokeWidth, bounds.xMax);
                            }
                        };
                        Graphics.prototype._extendBoundsByY = function (y) {
                            this._fillBounds.extendByY(y);
                            var bounds = this._lineBounds;
                            if (bounds.yMin === 0x8000000) {
                                bounds.yMin = y - this._topLeftStrokeWidth;
                                bounds.yMax = y + this._bottomRightStrokeWidth;
                            }
                            else {
                                bounds.yMin = Math.min(y - this._topLeftStrokeWidth, bounds.yMin);
                                bounds.yMax = Math.max(y + this._bottomRightStrokeWidth, bounds.yMax);
                            }
                        };
                        Graphics.prototype._applyLastCoordinates = function (x, y) {
                            if (!this._boundsIncludeLastCoordinates) {
                                this._extendBoundsByPoint(this._lastX, this._lastY);
                            }
                            this._boundsIncludeLastCoordinates = true;
                            this._lastX = x;
                            this._lastY = y;
                            this._extendBoundsByPoint(x, y);
                        };
                        Graphics.classInitializer = null;
                        return Graphics;
                    })(AS.ASObject);
                    display.Graphics = Graphics;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Sprite
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var assert = Shumway.Debug.assert;
                    var notImplemented = Shumway.Debug.notImplemented;
                    var Timeline = Shumway.Timeline;
                    var clamp = Shumway.NumberUtilities.clamp;
                    var DragMode;
                    (function (DragMode) {
                        DragMode[DragMode["Inactive"] = 0] = "Inactive";
                        // Indicates that the dragged object is locked to the center of the mouse position.
                        DragMode[DragMode["LockToPointer"] = 1] = "LockToPointer";
                        // Indicates that the dragged object is locked to the point where the dragging process started.
                        DragMode[DragMode["PreserveDistance"] = 2] = "PreserveDistance";
                    })(DragMode || (DragMode = {}));
                    var Sprite = (function (_super) {
                        __extends(Sprite, _super);
                        function Sprite() {
                            if (this._symbol && !this._fieldsInitialized) {
                                this.applySymbol();
                            }
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                            this._constructChildren();
                        }
                        Sprite.prototype.applySymbol = function () {
                            release || assert(this._symbol);
                            this._initializeFields();
                            var symbol = this._symbol;
                            if (symbol.isRoot) {
                                this._root = this;
                            }
                            this._children = [];
                            if (symbol.numFrames && symbol.frames.length > 0) {
                                // For a SWF's root symbol, all frames are added after initialization, with
                                // _initializeChildren called after the first frame is added.
                                this._initializeChildren(symbol.frames[0]);
                            }
                        };
                        Sprite.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this);
                            this._graphics = null;
                            this._buttonMode = false;
                            this._dropTarget = null;
                            this._hitArea = null;
                            this._useHandCursor = true;
                            this._dragMode = DragMode.Inactive;
                            this._dragDeltaX = 0;
                            this._dragDeltaY = 0;
                            this._dragBounds = null;
                            this._hitTarget = null;
                        };
                        Sprite.prototype._addFrame = function (frame) {
                            var frames = this._symbol.frames;
                            frames.push(frame);
                            if (frames.length === 1) {
                                this._initializeChildren(frame);
                            }
                        };
                        Sprite.prototype._initializeChildren = function (frame) {
                            if (frame.controlTags) {
                                this._processControlTags(frame.controlTags, false);
                            }
                        };
                        Sprite.prototype._processControlTags = function (tags, backwards) {
                            // When seeking backwards all timeline objects will be removed unless they are placed again.
                            if (backwards) {
                                var children = this._children.slice();
                                for (var i = 0; i < children.length; i++) {
                                    var child = children[i];
                                    if (child._depth < 0) {
                                        continue;
                                    }
                                    // For AVM1 objects, children with depth 16384 (0 from API point of view)
                                    // are not removed.
                                    if ('_as2Object' in child && child._depth >= 16384) {
                                        continue;
                                    }
                                    var tag = null;
                                    // Look for a control tag tag that places an object at the same depth as the current
                                    // child.
                                    for (var j = 0; j < tags.length; j++) {
                                        if (tags[j].depth === child._depth) {
                                            tag = tags[j];
                                            break;
                                        }
                                    }
                                    // If no such tag was found or a different object is placed, remove the current child.
                                    if (!tag || child._symbol.id !== tag.symbolId || child._ratio !== (tag.ratio | 0)) {
                                        this._removeAnimatedChild(child);
                                    }
                                }
                            }
                            var loaderInfo = this._symbol.loaderInfo;
                            for (var i = 0; i < tags.length; i++) {
                                // We may have a mix of the parsed and unparsed tags.
                                var parsedOrUnparsedTag = tags[i];
                                var tag = parsedOrUnparsedTag.tagCode === undefined ?
                                    parsedOrUnparsedTag : loaderInfo._file.getParsedTag(parsedOrUnparsedTag);
                                switch (tag.code) {
                                    case 5 /* CODE_REMOVE_OBJECT */:
                                    case 28 /* CODE_REMOVE_OBJECT2 */:
                                        var child = this.getTimelineObjectAtDepth(tag.depth | 0);
                                        if (child) {
                                            this._removeAnimatedChild(child);
                                        }
                                        break;
                                    case 4 /* CODE_PLACE_OBJECT */:
                                    case 26 /* CODE_PLACE_OBJECT2 */:
                                    case 70 /* CODE_PLACE_OBJECT3 */:
                                        var placeObjectTag = tag;
                                        var depth = placeObjectTag.depth;
                                        var child = this.getTimelineObjectAtDepth(depth);
                                        var hasCharacter = placeObjectTag.symbolId > -1;
                                        // Check for invalid flag constellations.
                                        if (placeObjectTag.flags & 1 /* Move */) {
                                            // Invalid case 1: Move flag set but no child found at given depth.
                                            if (!child) {
                                                //  Ignore the current tag.
                                                break;
                                            }
                                        }
                                        else if (!hasCharacter || (child && !(backwards && hasCharacter))) {
                                            // Invalid case 2: Neither Move nor HasCharacter flag set.
                                            // Invalid case 3: HasCharacter flag set but given depth is already occupied by a
                                            // another object (only if seeking forward).
                                            Shumway.Debug.warning("Warning: Failed to place object at depth " + depth + ".");
                                            break;
                                        }
                                        var symbol = null;
                                        if (hasCharacter) {
                                            symbol = loaderInfo.getSymbolById(placeObjectTag.symbolId);
                                            // The Flash Player ignores references to undefined symbols here. So should we.
                                            if (!symbol) {
                                                break;
                                            }
                                        }
                                        if (child) {
                                            if (symbol && !symbol.dynamic) {
                                                // If the current object is of a simple type (for now Shapes, MorphShapes and
                                                // StaticText) only its static content is updated instead of replacing it with a
                                                // new instance. TODO: Handle
                                                // http://wahlers.com.br/claus/blog/hacking-swf-2-placeobject-and-ratio/.
                                                child._setStaticContentFromSymbol(symbol);
                                            }
                                            // We animate the object only if a user script didn't touch any of the properties
                                            // this would affect.
                                            if (child._hasFlags(4096 /* AnimatedByTimeline */)) {
                                                child._animate(tag);
                                            }
                                        }
                                        else {
                                            // Place a new instance of the symbol.
                                            child = this.createAnimatedDisplayObject(symbol, placeObjectTag, false);
                                            this.addTimelineObjectAtDepth(child, depth);
                                            if (symbol.isAVM1Object) {
                                                child._placeObjectTag = placeObjectTag;
                                                child._setFlags(131072 /* HasPlaceObjectInitPending */);
                                            }
                                        }
                                        break;
                                }
                            }
                        };
                        Sprite.prototype._removeAnimatedChild = function (child) {
                            this.removeChild(child);
                            if (child._name) {
                                if (this.axGetPublicProperty(child._name) === child) {
                                    this.axSetPublicProperty(child._name, null);
                                }
                            }
                            if (child._maskedObject) {
                                child._maskedObject.mask = null;
                            }
                        };
                        Sprite.prototype._canHaveGraphics = function () {
                            return true;
                        };
                        Sprite.prototype._getGraphics = function () {
                            return this._graphics;
                        };
                        Object.defineProperty(Sprite.prototype, "graphics", {
                            get: function () {
                                return this._ensureGraphics();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Sprite.prototype, "buttonMode", {
                            get: function () {
                                return this._buttonMode;
                            },
                            set: function (value) {
                                this._buttonMode = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Sprite.prototype, "dropTarget", {
                            get: function () {
                                return this._dropTarget;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Sprite.prototype, "hitArea", {
                            get: function () {
                                return this._hitArea;
                            },
                            set: function (value) {
                                value = value;
                                if (this._hitArea === value) {
                                    return;
                                }
                                if (value && value._hitTarget) {
                                    value._hitTarget._hitArea = null;
                                }
                                this._hitArea = value;
                                if (value) {
                                    value._hitTarget = this;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Sprite.prototype, "useHandCursor", {
                            get: function () {
                                return this._useHandCursor;
                            },
                            set: function (value) {
                                this._useHandCursor = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Sprite.prototype, "soundTransform", {
                            get: function () {
                                release || notImplemented("public flash.display.Sprite::get soundTransform");
                                return;
                                // return this._soundTransform;
                            },
                            set: function (sndTransform) {
                                sndTransform = sndTransform;
                                release || notImplemented("public flash.display.Sprite::set soundTransform");
                                return;
                                // this._soundTransform = sndTransform;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * Returns the current mouse position relative to this object.
                         */
                        Sprite.prototype._getDragMousePosition = function () {
                            var position = this.sec.flash.ui.Mouse.axClass._currentPosition;
                            if (this._parent) {
                                position = this._parent.globalToLocal(position);
                            }
                            return position;
                        };
                        Sprite.prototype.startDrag = function (lockCenter, bounds) {
                            if (lockCenter === void 0) { lockCenter = false; }
                            if (bounds === void 0) { bounds = null; }
                            lockCenter = !!lockCenter;
                            if (lockCenter) {
                                this._dragMode = DragMode.LockToPointer;
                            }
                            else {
                                this._dragMode = DragMode.PreserveDistance;
                                var mousePosition = this._getDragMousePosition();
                                this._dragDeltaX = this.x - mousePosition.x;
                                this._dragDeltaY = this.y - mousePosition.y;
                            }
                            this._dragBounds = bounds;
                            // TODO: Our mouse handling logic looks up draggableObject on stage.sec.flash.ui.Mouse.axClass
                            // to update its position. Could there be a case where stage.sec !== this.sec?
                            this.sec.flash.ui.Mouse.axClass.draggableObject = this;
                        };
                        Sprite.prototype.stopDrag = function () {
                            if (this.sec.flash.ui.Mouse.axClass.draggableObject === this) {
                                this.sec.flash.ui.Mouse.axClass.draggableObject = null;
                                this._dragMode = DragMode.Inactive;
                                this._dragDeltaX = 0;
                                this._dragDeltaY = 0;
                                this._dragBounds = null;
                            }
                        };
                        Sprite.prototype._updateDragState = function (dropTarget) {
                            if (dropTarget === void 0) { dropTarget = null; }
                            var mousePosition = this._getDragMousePosition();
                            var newX = mousePosition.x;
                            var newY = mousePosition.y;
                            if (this._dragMode === DragMode.PreserveDistance) {
                                // Preserve the distance to the point where the dragging process started.
                                newX += this._dragDeltaX;
                                newY += this._dragDeltaY;
                            }
                            if (this._dragBounds) {
                                // Clamp new position to constraint bounds.
                                var bounds = this._dragBounds;
                                newX = clamp(newX, bounds.left, bounds.right);
                                newY = clamp(newY, bounds.top, bounds.bottom);
                            }
                            this.x = newX;
                            this.y = newY;
                            this._dropTarget = dropTarget;
                        };
                        Sprite.prototype.startTouchDrag = function (touchPointID /*int*/, lockCenter, bounds) {
                            if (lockCenter === void 0) { lockCenter = false; }
                            if (bounds === void 0) { bounds = null; }
                            touchPointID = touchPointID | 0;
                            lockCenter = !!lockCenter;
                            bounds = bounds;
                            release || notImplemented("public flash.display.Sprite::startTouchDrag");
                            return;
                        };
                        Sprite.prototype.stopTouchDrag = function (touchPointID /*int*/) {
                            touchPointID = touchPointID | 0;
                            release || notImplemented("public flash.display.Sprite::stopTouchDrag");
                            return;
                        };
                        Sprite.prototype._containsPoint = function (globalX, globalY, localX, localY, testingType, objects) {
                            // If looking for a drop target, ignore this object if it is the one being dragged.
                            if (testingType === 5 /* Drop */ && this._dragMode > DragMode.Inactive) {
                                return;
                            }
                            var result = this._boundsAndMaskContainPoint(globalX, globalY, localX, localY, testingType);
                            if (!result && testingType === 3 /* Mouse */ && this._hitArea && this._mouseEnabled) {
                                var matrix = this._hitArea._getInvertedConcatenatedMatrix();
                                var hitAreaLocalX = matrix.transformX(globalX, globalY);
                                var hitAreaLocalY = matrix.transformY(globalX, globalY);
                                result = this._hitArea._boundsAndMaskContainPoint(globalX, globalY, hitAreaLocalX, hitAreaLocalY, testingType);
                            }
                            if (result === 0 /* None */ || testingType < 2 /* HitTestShape */) {
                                return result;
                            }
                            return this._containsPointImpl(globalX, globalY, localX, localY, testingType, objects, true);
                        };
                        Sprite.prototype._containsPointDirectly = function (localX, localY, globalX, globalY) {
                            if (this._hitArea) {
                                return !!this._hitArea._containsGlobalPoint(globalX, globalY, 2 /* HitTestShape */, null);
                            }
                            var graphics = this._getGraphics();
                            return !!graphics && graphics._containsPoint(localX, localY, true, 0);
                        };
                        Sprite.classInitializer = null;
                        // List of static symbols to link.
                        Sprite.classSymbols = null; // [];
                        // List of instance symbols to link.
                        Sprite.instanceSymbols = null; // [];
                        return Sprite;
                    })(flash.display.DisplayObjectContainer);
                    display.Sprite = Sprite;
                    var SpriteSymbol = (function (_super) {
                        __extends(SpriteSymbol, _super);
                        function SpriteSymbol(data, loaderInfo) {
                            _super.call(this, data, loaderInfo.app.sec.flash.display.MovieClip.axClass, true);
                            this.numFrames = 1;
                            this.frames = [];
                            this.labels = [];
                            this.loaderInfo = loaderInfo;
                        }
                        SpriteSymbol.FromData = function (data, loaderInfo) {
                            var symbol = new SpriteSymbol(data, loaderInfo);
                            symbol.numFrames = data.frameCount;
                            if (loaderInfo.actionScriptVersion === display.ActionScriptVersion.ACTIONSCRIPT2) {
                                symbol.isAVM1Object = true;
                                symbol.avm1Context = loaderInfo._avm1Context;
                            }
                            var frames = data.frames;
                            var frameLabelCtor = loaderInfo.app.sec.flash.display.FrameLabel;
                            for (var i = 0; i < frames.length; i++) {
                                var frame = loaderInfo.getFrame(data, i);
                                if (frame.labelName) {
                                    symbol.labels.push(new frameLabelCtor(frame.labelName, i + 1));
                                }
                                symbol.frames.push(frame);
                            }
                            return symbol;
                        };
                        return SpriteSymbol;
                    })(Timeline.DisplaySymbol);
                    display.SpriteSymbol = SpriteSymbol;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: MovieClip
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var assert = Shumway.Debug.assert;
                    var assertUnreachable = Shumway.Debug.assertUnreachable;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var Telemetry = Shumway.Telemetry;
                    var events = flash.events;
                    var MovieClipSoundsManager = (function () {
                        function MovieClipSoundsManager(mc) {
                            this._mc = mc;
                            this._startSoundRegistrations = null;
                            this._soundStream = null;
                        }
                        MovieClipSoundsManager.prototype.registerStartSounds = function (frameNum, soundStartInfo) {
                            if (this._startSoundRegistrations === null) {
                                this._startSoundRegistrations = {};
                            }
                            this._startSoundRegistrations[frameNum] = soundStartInfo;
                        };
                        MovieClipSoundsManager.prototype.initSoundStream = function (streamInfo) {
                            this._soundStream = new display.MovieClipSoundStream(streamInfo, this._mc);
                        };
                        MovieClipSoundsManager.prototype.addSoundStreamBlock = function (frameNum, streamBlock) {
                            if (this._soundStream) {
                                this._soundStream.appendBlock(frameNum, streamBlock);
                            }
                        };
                        MovieClipSoundsManager.prototype._startSounds = function (frameNum) {
                            var starts = this._startSoundRegistrations[frameNum];
                            if (starts) {
                                var sounds = this._soundClips || (this._soundClips = {});
                                var loaderInfo = this._mc.loaderInfo;
                                for (var i = 0; i < starts.length; i++) {
                                    var start = starts[i];
                                    var symbolId = start.soundId;
                                    var info = start.soundInfo;
                                    var sound = sounds[symbolId];
                                    if (!sound) {
                                        var symbolInfo = loaderInfo.getSymbolById(symbolId);
                                        if (!symbolInfo) {
                                            continue;
                                        }
                                        var symbolClass = symbolInfo.symbolClass;
                                        var soundObj = AS.constructClassFromSymbol(symbolInfo, symbolClass);
                                        sounds[symbolId] = sound = { object: soundObj };
                                    }
                                    var stop = info.flags & 32 /* Stop */;
                                    if (sound.channel && stop) {
                                        sound.channel.stop();
                                        sound.channel = null;
                                    }
                                    if (!stop && (!sound.channel || !sound.channel.playing)) {
                                        // TODO envelope, in/out point
                                        var loops = info.flags & 4 /* HasLoops */ ? info.loopCount : 0;
                                        sound.channel = sound.object.play(0, loops);
                                    }
                                }
                            }
                        };
                        MovieClipSoundsManager.prototype.syncSounds = function (frameNum) {
                            if (this._startSoundRegistrations !== null) {
                                this._startSounds(frameNum);
                            }
                            if (this._soundStream) {
                                this._soundStream.playFrame(frameNum);
                            }
                        };
                        return MovieClipSoundsManager;
                    })();
                    function compareFrameScripts(a, b) {
                        if (!a.precedence) {
                            return !b.precedence ? 0 : -1;
                        }
                        else if (!b.precedence) {
                            return 1;
                        }
                        var i = 0;
                        while (i < a.precedence.length && i < b.precedence.length &&
                            a.precedence[i] === b.precedence[i]) {
                            i++;
                        }
                        if (i >= a.precedence.length) {
                            return a.precedence.length === b.precedence.length ? 0 : -1;
                        }
                        else {
                            return i >= b.precedence.length ? 1 : a.precedence[i] - b.precedence[i];
                        }
                    }
                    var MovieClip = (function (_super) {
                        __extends(MovieClip, _super);
                        function MovieClip() {
                            _super.call(this);
                            if (!this._fieldsInitialized) {
                                this._initializeFields();
                            }
                        }
                        // Called whenever the class is initialized.
                        MovieClip.classInitializer = function () {
                            this.reset();
                        };
                        MovieClip.reset = function () {
                            this.frameNavigationModel = 10 /* SWF10 */;
                            this._callQueue = [];
                        };
                        MovieClip.runFrameScripts = function () {
                            AVMX.enterTimeline("MovieClip.executeFrame");
                            var movieClipClass = this.sec.flash.display.MovieClip.axClass;
                            var displayObjectClass = this.sec.flash.display.DisplayObject.axClass;
                            var queue = movieClipClass._callQueue;
                            movieClipClass._callQueue = [];
                            for (var i = 0; i < queue.length; i++) {
                                var instance = queue[i];
                                instance._allowFrameNavigation = false;
                                instance.callFrame(instance._currentFrame);
                                instance._allowFrameNavigation = true;
                                // If the destination frame isn't the same as before the `callFrame` operation, a frame
                                // navigation has happened inside the frame script. In that case, we didn't immediately
                                // run frame navigation as described in `_gotoFrameAbs`. Instead, we have to do it here.
                                if (instance._nextFrame !== instance._currentFrame) {
                                    if (movieClipClass.frameNavigationModel === 9 /* SWF9 */) {
                                        instance._advanceFrame();
                                        instance._constructFrame();
                                        instance._removeFlags(8192 /* HasFrameScriptPending */);
                                        instance.callFrame(instance._currentFrame);
                                    }
                                    else {
                                        displayObjectClass.performFrameNavigation(false, true);
                                    }
                                }
                            }
                            AVMX.leaveTimeline();
                        };
                        MovieClip.runAvm1FrameScripts = function () {
                            AVMX.enterTimeline("MovieClip.runAvm1FrameScripts");
                            var movieClipClass = this.sec.flash.display.MovieClip.axClass;
                            var displayObjectClass = this.sec.flash.display.DisplayObject.axClass;
                            var queue = movieClipClass._callQueue;
                            movieClipClass._callQueue = [];
                            var unsortedScripts = [];
                            for (var i = 0; i < queue.length; i++) {
                                var instance = queue[i];
                                instance.queueAvm1FrameScripts(instance._currentFrame, unsortedScripts);
                            }
                            if (unsortedScripts.length) {
                                unsortedScripts.sort(compareFrameScripts);
                                for (var i = 0; i < queue.length; i++) {
                                    var instance = queue[i];
                                    instance._allowFrameNavigation = false;
                                }
                                var frameScripts = unsortedScripts;
                                for (var i = 0; i < frameScripts.length; i++) {
                                    var script = frameScripts[i];
                                    var mc = script.context;
                                    release || assert(mc);
                                    script.call(mc);
                                }
                                for (var i = 0; i < queue.length; i++) {
                                    var instance = queue[i];
                                    instance._allowFrameNavigation = true;
                                    if (instance._nextFrame !== instance._currentFrame) {
                                        displayObjectClass.performFrameNavigation(false, true);
                                    }
                                }
                            }
                            AVMX.leaveTimeline();
                        };
                        MovieClip.prototype.applySymbol = function () {
                            _super.prototype.applySymbol.call(this);
                            this.sec.flash.display.DisplayObject.axClass._advancableInstances.push(this);
                            var symbol = this._symbol;
                            this._totalFrames = symbol.numFrames;
                            this._currentFrame = 1;
                            if (!symbol.isRoot) {
                                this.addScene('', symbol.labels, 0, symbol.numFrames);
                            }
                            this._frames = symbol.frames;
                            if (symbol.isAVM1Object) {
                                if (symbol.avm1Name) {
                                    this.name = symbol.avm1Name;
                                }
                            }
                        };
                        // This method is called when children are being constructed and AVM1 scripts
                        // is about to be run.
                        MovieClip.prototype._initAvm1Data = function () {
                            var symbol = this._symbol;
                            var frames = symbol.frames;
                            if (frames) {
                                for (var i = 0; i < frames.length; i++) {
                                    var frameInfo = frames[i];
                                    this._initAvm1FrameData(i, frameInfo);
                                }
                            }
                        };
                        // Adds missing AVM1 scripts data to the AS3 object frameScripts and events.
                        MovieClip.prototype._initAvm1FrameData = function (frameIndex, frameInfo) {
                            var symbol = this._symbol;
                            var avm1Context = symbol.avm1Context;
                            if (frameInfo.exports) {
                                var exports = frameInfo.exports;
                                for (var i = 0; i < exports.length; i++) {
                                    var asset = exports[i];
                                    avm1Context.addAsset(asset.className, asset.symbolId, null);
                                }
                            }
                            var initActionBlocks = frameInfo.initActionBlocks;
                            if (initActionBlocks) {
                                this._addAvm1InitActionBlocks(frameIndex, initActionBlocks);
                            }
                            var actionBlocks = frameInfo.actionBlocks;
                            if (actionBlocks) {
                                this._addAvm1FrameScripts(frameIndex, actionBlocks);
                            }
                        };
                        MovieClip.prototype._addAvm1FrameScripts = function (frameIndex, actionsBlocks) {
                            for (var i = 0; i < actionsBlocks.length; i++) {
                                var actionsBlock = actionsBlocks[i];
                                var symbol = this._symbol;
                                var avm1Context = symbol.avm1Context;
                                var actionsData = avm1Context.actionsDataFactory.createActionsData(actionsBlock.actionsData, 's' + symbol.id + 'f' + frameIndex + 'i' + i);
                                var script = function (actionsData) {
                                    var as2MovieClip = Shumway.AVM1.Lib.getAVM1Object(this, avm1Context);
                                    avm1Context.executeActions(actionsData, as2MovieClip);
                                }.bind(this, actionsData);
                                script.precedence = this._getScriptPrecedence().concat(actionsBlock.precedence);
                                this.addFrameScript(frameIndex, script);
                            }
                        };
                        /**
                         * AVM1 InitActionBlocks are executed once, before the children are initialized for a frame.
                         * That matches AS3's enterFrame event, so we can add an event listener that just bails
                         * as long as the target frame isn't reached, and executes the InitActionBlock once it is.
                         *
                         * After that, the listener removes itself.
                         */
                        MovieClip.prototype._addAvm1InitActionBlocks = function (frameIndex, actionsBlocks) {
                            function executeInitActions() {
                                var symbol = self._symbol;
                                var avm1Context = symbol.avm1Context;
                                var as2MovieClip = Shumway.AVM1.Lib.getAVM1Object(self, avm1Context);
                                for (var i = 0; i < actionsBlocks.length; i++) {
                                    var actionsData = avm1Context.actionsDataFactory.createActionsData(actionsBlocks[i].actionsData, 's' + symbol.id + 'f' + frameIndex + 'i' + i);
                                    avm1Context.executeActions(actionsData, as2MovieClip);
                                }
                            }
                            var self = this;
                            if (this.currentFrame === frameIndex + 1) {
                                executeInitActions();
                                return;
                            }
                            var enterFrameListener = function () {
                                if (self.currentFrame !== frameIndex + 1) {
                                    return;
                                }
                                self.removeEventListener('enterFrame', enterFrameListener);
                                executeInitActions();
                            };
                            this.addEventListener('enterFrame', enterFrameListener);
                        };
                        MovieClip.prototype.removeChildAt = function (index) {
                            var child = _super.prototype.removeChildAt.call(this, index);
                            if (this._as2Object && child._name) {
                                var avm1Child = Shumway.AVM1.Lib.getAVM1Object(child, this._as2Object.context);
                                // Not all display objects are reflected in AVM1, so not all need to be removed.
                                avm1Child && this._as2Object._removeChildName(avm1Child, child._name);
                            }
                            return child;
                        };
                        MovieClip.prototype._initializeFields = function () {
                            _super.prototype._initializeFields.call(this);
                            this._currentFrame = 0;
                            this._totalFrames = 1;
                            this._trackAsMenu = false;
                            this._scenes = [];
                            if (!this._symbol) {
                                this.addScene('', [], 0, 1);
                            }
                            this._enabled = true;
                            this._isPlaying = false;
                            this._frames = [];
                            this._frameScripts = [];
                            this._nextFrame = 1;
                            this._stopped = false;
                            this._allowFrameNavigation = true;
                            this._sounds = null;
                            this._buttonFrames = Object.create(null);
                            this._currentButtonState = null;
                        };
                        MovieClip.prototype._addFrame = function (frameInfo) {
                            var spriteSymbol = this._symbol;
                            var frames = spriteSymbol.frames;
                            frames.push(frameInfo);
                            if (frameInfo.labelName) {
                                // Frame indices are 1-based, so use frames.length after pushing the frame.
                                this.addFrameLabel(frameInfo.labelName, frames.length);
                            }
                            if (frameInfo.soundStreamHead) {
                                this._initSoundStream(frameInfo.soundStreamHead);
                            }
                            if (frameInfo.soundStreamBlock) {
                                // Frame indices are 1-based, so use frames.length after pushing the frame.
                                this._addSoundStreamBlock(frames.length, frameInfo.soundStreamBlock);
                            }
                            if (spriteSymbol.isAVM1Object && this._hasFlags(256 /* Constructed */)) {
                                var avm1Context = spriteSymbol.avm1Context;
                                this._initAvm1FrameData(frames.length - 1, frameInfo);
                            }
                            if (frames.length === 1) {
                                this._initializeChildren(frames[0]);
                            }
                        };
                        MovieClip.prototype._initFrame = function (advance) {
                            if (advance) {
                                if (this.buttonMode) {
                                    var state = null;
                                    if (this._mouseOver) {
                                        state = this._mouseDown ? '_down' : '_over';
                                    }
                                    else if (this._currentButtonState !== null) {
                                        state = '_up';
                                    }
                                    if (state !== this._currentButtonState && this._buttonFrames[state]) {
                                        this.stop();
                                        this._gotoFrame(state, null);
                                        this._currentButtonState = state;
                                        this._advanceFrame();
                                        return;
                                    }
                                }
                                if (this._totalFrames > 1 && !this._stopped &&
                                    this._hasFlags(256 /* Constructed */)) {
                                    this._nextFrame++;
                                }
                            }
                            this._advanceFrame();
                            if (this._symbol && this._symbol.isAVM1Object &&
                                !this._hasFlags(256 /* Constructed */)) {
                                this._initAvm1Data();
                            }
                        };
                        MovieClip.prototype._constructFrame = function () {
                            this._constructChildren();
                        };
                        MovieClip.prototype._enqueueFrameScripts = function () {
                            var addToCallQueue = false;
                            if (this._hasFlags(1024 /* NeedsLoadEvent */)) {
                                addToCallQueue = true;
                            }
                            if (this._hasFlags(8192 /* HasFrameScriptPending */)) {
                                this._removeFlags(8192 /* HasFrameScriptPending */);
                                addToCallQueue = true;
                            }
                            if (addToCallQueue) {
                                this.sec.flash.display.MovieClip.axClass._callQueue.push(this);
                            }
                            _super.prototype._enqueueFrameScripts.call(this);
                        };
                        Object.defineProperty(MovieClip.prototype, "currentFrame", {
                            get: function () {
                                var frame = this._currentFrame;
                                if (!this._allowFrameNavigation &&
                                    this.sec.flash.display.MovieClip.axClass.frameNavigationModel === 1 /* SWF1 */) {
                                    // AVM1 needs to return a frame we already navigated during scripts execution.
                                    frame = this._nextFrame;
                                }
                                return frame - this._sceneForFrameIndex(frame).offset;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "framesLoaded", {
                            get: function () {
                                return this._frames.length;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "totalFrames", {
                            get: function () {
                                return this._totalFrames;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "trackAsMenu", {
                            get: function () {
                                return this._trackAsMenu;
                            },
                            set: function (value) {
                                this._trackAsMenu = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "scenes", {
                            get: function () {
                                var scenes = this._scenes ? this._scenes.map(function (x) {
                                    return x.clone();
                                }) : [];
                                return this.sec.createArrayUnsafe(scenes);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "currentScene", {
                            get: function () {
                                var scene = this._sceneForFrameIndex(this._currentFrame);
                                return scene.clone();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "currentLabel", {
                            get: function () {
                                var label = this._labelForFrame(this._currentFrame);
                                return label ? label.name : null;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "currentLabels", {
                            get: function () {
                                return this._sceneForFrameIndex(this._currentFrame).labels;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "currentFrameLabel", {
                            get: function () {
                                var scene = this._sceneForFrameIndex(this._currentFrame);
                                var label = scene.getLabelByFrame(this._currentFrame - scene.offset);
                                return label && label.name;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "enabled", {
                            get: function () {
                                return this._enabled;
                            },
                            set: function (value) {
                                this._enabled = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(MovieClip.prototype, "isPlaying", {
                            get: function () {
                                return this._isPlaying;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        MovieClip.prototype.play = function () {
                            if (this._totalFrames > 1) {
                                this._isPlaying = true;
                            }
                            this._stopped = false;
                        };
                        MovieClip.prototype.stop = function () {
                            this._isPlaying = false;
                            this._stopped = true;
                        };
                        /**
                         * Resolves frame and scene into absolute frame number. If scene is not specified,
                         * the current scene is used. In legacy mode, it might return `undefined` if frame/scene
                         * was not found.
                         */
                        MovieClip.prototype._getAbsFrameNumber = function (frame, sceneName) {
                            var navigationModel = this.sec.flash.display.MovieClip.axClass.frameNavigationModel;
                            var legacyMode = navigationModel !== 10 /* SWF10 */;
                            var scene;
                            if (sceneName !== null) {
                                sceneName = axCoerceString(sceneName);
                                var scenes = this._scenes;
                                release || assert(scenes.length, "There should be at least one scene defined.");
                                for (var i = 0; i < scenes.length; i++) {
                                    scene = scenes[i];
                                    if (scene.name === sceneName) {
                                        break;
                                    }
                                }
                                if (i === scenes.length) {
                                    if (legacyMode) {
                                        return undefined; // noop for SWF9 and below
                                    }
                                    this.sec.throwError('ArgumentError', AVMX.Errors.SceneNotFoundError, sceneName);
                                }
                            }
                            else {
                                scene = this._sceneForFrameIndex(this._currentFrame);
                            }
                            // Amazingly, the `frame` argument, while first coerced to string, is then interpreted as a
                            // frame index even if a label with the same name exists.
                            /* tslint:disable */
                            var frameNum = parseInt(frame, 10);
                            if (frameNum != frame) {
                                var label = scene.getLabelByName(frame, legacyMode);
                                if (!label) {
                                    if (legacyMode) {
                                        return undefined; // noop for SWF9 and below
                                    }
                                    this.sec.throwError('ArgumentError', AVMX.Errors.FrameLabelNotFoundError, frame, sceneName);
                                }
                                frameNum = label.frame;
                            }
                            /* tslint:enable */
                            return scene.offset + frameNum;
                        };
                        /**
                         * Implementation for both gotoAndPlay and gotoAndStop.
                         *
                         * Technically, we should throw all errors from those functions directly so the stack is
                         * correct.
                         * We might at some point do that by explicitly inlining this function using some build step.
                         */
                        MovieClip.prototype._gotoFrame = function (frame, sceneName) {
                            var frameNum = this._getAbsFrameNumber(frame, sceneName);
                            if (frameNum === undefined) {
                                return;
                            }
                            this._gotoFrameAbs(frameNum);
                        };
                        MovieClip.prototype._gotoFrameAbs = function (frame) {
                            if (frame < 1) {
                                frame = 1;
                            }
                            else if (frame > this._totalFrames) {
                                frame = this._totalFrames;
                            }
                            if (frame === this._nextFrame) {
                                return;
                            }
                            this._nextFrame = frame;
                            // Frame navigation only happens immediately if not triggered from under a frame script.
                            if (this._allowFrameNavigation) {
                                if (this.sec.flash.display.MovieClip.axClass.frameNavigationModel === 9 /* SWF9 */) {
                                    // In FP 9, the only thing that happens on inter-frame navigation is advancing the frame
                                    // and constructing new timeline objects.
                                    this._advanceFrame();
                                    this._constructFrame();
                                }
                                else {
                                    // Frame navigation in an individual timeline triggers an iteration of the whole
                                    // frame navigation cycle in FP 10+. This includes broadcasting frame events to *all*
                                    // display objects.
                                    this.sec.flash.display.DisplayObject.axClass.performFrameNavigation(false, true);
                                }
                            }
                        };
                        MovieClip.prototype._advanceFrame = function () {
                            var currentFrame = this._currentFrame;
                            var nextFrame = this._nextFrame;
                            if (nextFrame > this._totalFrames) {
                                nextFrame = 1;
                            }
                            if (currentFrame === nextFrame) {
                                // If nextFrame was > this._totalFrames, it has to be written back here, otherwise it'll
                                // just be incremented ever further.
                                this._nextFrame = nextFrame;
                                return;
                            }
                            if (nextFrame > this.framesLoaded) {
                                // If nextFrame was > this._totalFrames, it has to be written back here, otherwise it'll
                                // just be incremented ever further.
                                this._nextFrame = nextFrame;
                                // TODO
                                return;
                            }
                            var currentSwfFrame = this._frames[currentFrame - 1];
                            var nextSwfFrame = this._frames[nextFrame - 1];
                            if (nextSwfFrame !== currentSwfFrame) {
                                this._seekToFrame(nextFrame);
                                if (nextSwfFrame.controlTags) {
                                    var tags = nextSwfFrame.controlTags;
                                    var soundStarts;
                                    for (var i = 0; i < tags.length; i++) {
                                        var tag = tags[i];
                                        // controlTags might contain parsed and unparsed tags.
                                        if (tag.tagCode === 15 /* CODE_START_SOUND */ ||
                                            tag.tagCode === 61 /* CODE_VIDEO_FRAME */) {
                                            var loaderInfo = this._symbol.loaderInfo;
                                            tag = loaderInfo._file.getParsedTag(tag);
                                        }
                                        if (tag.code === 15 /* CODE_START_SOUND */) {
                                            if (!soundStarts) {
                                                soundStarts = [];
                                            }
                                            soundStarts.push(new Shumway.Timeline.SoundStart(tag.soundId, tag.soundInfo));
                                        }
                                        else if (tag.tagCode === 61 /* CODE_VIDEO_FRAME */) {
                                        }
                                    }
                                    if (soundStarts) {
                                        this._registerStartSounds(nextFrame, soundStarts);
                                    }
                                }
                            }
                            if (this._frameScripts[nextFrame]) {
                                this._setFlags(8192 /* HasFrameScriptPending */);
                                this._parent && this._propagateFlagsUp(16384 /* ContainsFrameScriptPendingChildren */);
                            }
                            this._currentFrame = this._nextFrame = nextFrame;
                            this._syncSounds(nextFrame);
                        };
                        MovieClip.prototype._seekToFrame = function (frame) {
                            var currentFrame = this._currentFrame;
                            var frames = this._frames;
                            if (frame === currentFrame + 1) {
                                var nextSwfFrame = frames[frame - 1];
                                if (nextSwfFrame.controlTags) {
                                    this._processControlTags(nextSwfFrame.controlTags, false);
                                }
                                return;
                            }
                            var currentSwfFrame = frames[currentFrame - 1];
                            var loaderInfo = this._symbol.loaderInfo;
                            var backwards = frame < currentFrame;
                            var controlTags = [];
                            var removedObjects;
                            // We scan all control tags in reverse order and make sure we only apply those related to
                            // objects that exist in the new frame.
                            var i = frame;
                            var n = backwards ? 0 : currentFrame;
                            while (i-- > n) {
                                var swfFrame = frames[i];
                                if (swfFrame === currentSwfFrame) {
                                    continue;
                                }
                                currentSwfFrame = swfFrame;
                                var tags = swfFrame.controlTags;
                                if (!tags) {
                                    continue;
                                }
                                var j = tags.length;
                                while (j--) {
                                    // We may have a mix of the parsed and unparsed tags.
                                    var parsedOrUnparsedTag = tags[j];
                                    var tag = parsedOrUnparsedTag.tagCode === undefined ?
                                        parsedOrUnparsedTag : loaderInfo._file.getParsedTag(parsedOrUnparsedTag);
                                    switch (tag.code) {
                                        case 5 /* CODE_REMOVE_OBJECT */:
                                        case 28 /* CODE_REMOVE_OBJECT2 */:
                                            if (!removedObjects) {
                                                removedObjects = Object.create(null);
                                            }
                                            removedObjects[tag.depth] = true;
                                            if (!backwards) {
                                                controlTags.push(tag);
                                            }
                                            break;
                                        case 4 /* CODE_PLACE_OBJECT */:
                                        case 26 /* CODE_PLACE_OBJECT2 */:
                                        case 70 /* CODE_PLACE_OBJECT3 */:
                                            if (!(removedObjects && removedObjects[tag.depth])) {
                                                controlTags.push(tag);
                                            }
                                            break;
                                        default:
                                            controlTags.push(tag);
                                    }
                                }
                            }
                            // Bring the order back to normal.
                            controlTags.reverse();
                            this._processControlTags(controlTags, backwards);
                        };
                        /**
                         * Because that's how it's mostly used, the current frame is stored as an offset into the
                         * entire timeline. Sometimes, we need to know which scene it falls into. This utility
                         * function answers that.
                         */
                        MovieClip.prototype._sceneForFrameIndex = function (frameIndex) {
                            var scenes = this._scenes;
                            // A gotoAnd* might be invoked by script before the first advanceFrame call. In that case,
                            // _currentFrame is 0, which means this function is called with frameIndex being 0.
                            // We just return the first scene in that case.
                            if (frameIndex === 0) {
                                return scenes[0];
                            }
                            for (var i = 0; i < scenes.length; i++) {
                                var scene = scenes[i];
                                if (scene.offset < frameIndex && scene.offset + scene.numFrames >= frameIndex) {
                                    return scene;
                                }
                            }
                            release || assertUnreachable("Must have at least one scene covering all frames.");
                        };
                        /**
                         * Frame indices are stored as offsets into the entire timline, whereas labels are stored
                         * in their scenes. This utility function iterates over scenes and their labels to find
                         * the label clostest to, but not after the target frame.
                         */
                        MovieClip.prototype._labelForFrame = function (frame) {
                            var scenes = this._scenes;
                            var label = null;
                            for (var i = 0; i < scenes.length; i++) {
                                var scene = scenes[i];
                                if (scene.offset > frame) {
                                    return label;
                                }
                                var labels = scene.labels.value;
                                for (var j = 0; j < labels.length; j++) {
                                    var currentLabel = labels[j];
                                    if (currentLabel.frame > frame - scene.offset) {
                                        return label;
                                    }
                                    label = currentLabel;
                                }
                            }
                            return label;
                        };
                        MovieClip.prototype.callFrame = function (frame) {
                            frame = frame | 0;
                            var frameScripts = this._frameScripts[frame];
                            if (!frameScripts) {
                                return;
                            }
                            for (var i = 0; i < frameScripts.length; i++) {
                                var script = frameScripts[i];
                                try {
                                    script.call(this); // REDUX ? why it was frameScript.$Bgcall(thisArg);
                                }
                                catch (e) {
                                    Telemetry.instance.reportTelemetry({ topic: 'error', error: 2 /* AVM2_ERROR */ });
                                    //if ($DEBUG) {
                                    //  console.error('error ' + e + ', stack: \n' + e.stack);
                                    //}
                                    this.stop();
                                    throw e;
                                }
                            }
                        };
                        MovieClip.prototype.queueAvm1FrameScripts = function (frame, queue) {
                            // AVM1 action blocks must be executed exactly in the same order they appear in the SWF
                            // file. We keep track of the position for each action block at parsing time and carry that
                            // information on to their wrapping functions (via the precedence property). Here we queue
                            // up all such functions so we can sort and execute them after this loop.
                            if (this._hasFlags(1024 /* NeedsLoadEvent */)) {
                                this._removeFlags(1024 /* NeedsLoadEvent */);
                                release || assert(this._symbol);
                                var handler = function () {
                                    var eventClass = this.sec.flash.events.Event.axClass;
                                    this.dispatchEvent(eventClass.getInstance(events.Event.AVM1_LOAD));
                                }.bind(this);
                                handler.precedence = this._getScriptPrecedence();
                                handler.context = this;
                                queue.push(handler);
                            }
                            var frameScripts = this._frameScripts[frame];
                            if (frameScripts) {
                                for (var j = 0; j < frameScripts.length; j++) {
                                    var script = frameScripts[j];
                                    script.context = this;
                                    queue.push(script);
                                }
                            }
                        };
                        MovieClip.prototype.nextFrame = function () {
                            this.gotoAndStop(this._currentFrame + 1);
                        };
                        MovieClip.prototype.prevFrame = function () {
                            this.gotoAndStop(this._currentFrame - 1);
                        };
                        MovieClip.prototype.gotoAndPlay = function (frame, scene) {
                            if (scene === void 0) { scene = null; }
                            // Argument handling for gotoAnd* is a bit peculiar:
                            // - too many arguments throw just as too few do
                            // - the `sceneName` argument is coerced first
                            // - the `frame` argument is coerced to string, but `undefined` results in `"null"`
                            if (arguments.length === 0 || arguments.length > 2) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.WrongArgumentCountError, 'flash.display::MovieClip/gotoAndPlay()', 1, arguments.length);
                            }
                            scene = axCoerceString(scene);
                            frame = axCoerceString(frame) + ''; // The axCoerceString returns `null` for `undefined`.
                            this.play();
                            this._gotoFrame(frame, scene);
                        };
                        MovieClip.prototype.gotoAndStop = function (frame, scene) {
                            if (scene === void 0) { scene = null; }
                            // See comment in gotoAndPlay for an explanation of the arguments handling stuff.
                            if (arguments.length === 0 || arguments.length > 2) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.WrongArgumentCountError, 'flash.display::MovieClip/gotoAndPlay()', 1, arguments.length);
                            }
                            scene = axCoerceString(scene);
                            frame = axCoerceString(frame) + ''; // The axCoerceString returns `null` for `undefined`.
                            this.stop();
                            this._gotoFrame(frame, scene);
                        };
                        /**
                         * Takes pairs of `frameIndex`, `script` arguments and adds the `script`s to the `_frameScripts`
                         * Array.
                         *
                         * Undocumented method used to implement the old timeline concept in AS3.
                         */
                        MovieClip.prototype.addFrameScript = function (frameIndex, script /*, ...*/) {
                            if (!this._currentFrame) {
                                return;
                            }
                            // arguments are pairs of frameIndex and script/function
                            // frameIndex is in range 0..totalFrames-1
                            var numArgs = arguments.length;
                            if (numArgs & 1) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.TooFewArgumentsError, numArgs, numArgs + 1);
                            }
                            var frameScripts = this._frameScripts;
                            var totalFrames = this._totalFrames;
                            for (var i = 0; i < numArgs; i += 2) {
                                var frameNum = (arguments[i] | 0) + 1;
                                if (frameNum < 1 || frameNum > totalFrames) {
                                    continue;
                                }
                                var fn = arguments[i + 1];
                                var list = frameScripts[frameNum];
                                if (list) {
                                    if (fn.precedence) {
                                        list.push(fn);
                                    }
                                    else {
                                        list[0] = fn;
                                    }
                                }
                                else {
                                    frameScripts[frameNum] = [fn];
                                }
                                if (frameNum === this._currentFrame) {
                                    this._setFlags(8192 /* HasFrameScriptPending */);
                                    this._parent && this._propagateFlagsUp(16384 /* ContainsFrameScriptPendingChildren */);
                                }
                            }
                        };
                        Object.defineProperty(MovieClip.prototype, "_isFullyLoaded", {
                            get: function () {
                                return this.framesLoaded >= this.totalFrames;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        MovieClip.prototype._registerStartSounds = function (frameNum, soundStartInfo) {
                            if (this._sounds === null) {
                                this._sounds = new MovieClipSoundsManager(this);
                            }
                            this._sounds.registerStartSounds(frameNum, soundStartInfo);
                        };
                        MovieClip.prototype._initSoundStream = function (streamInfo) {
                            if (this._sounds === null) {
                                this._sounds = new MovieClipSoundsManager(this);
                            }
                            this._sounds.initSoundStream(streamInfo);
                        };
                        MovieClip.prototype._addSoundStreamBlock = function (frameNum, streamBlock) {
                            if (this._sounds === null) {
                                this._sounds = new MovieClipSoundsManager(this);
                            }
                            this._sounds.addSoundStreamBlock(frameNum, streamBlock);
                        };
                        MovieClip.prototype._syncSounds = function (frameNum) {
                            if (this._sounds !== null) {
                                this._sounds.syncSounds(frameNum);
                            }
                        };
                        MovieClip.prototype.addScene = function (name, labels_, offset, numFrames) {
                            var labels = this.sec.createArrayUnsafe(labels_);
                            this._scenes.push(new this.sec.flash.display.Scene(name, labels, offset, numFrames));
                        };
                        MovieClip.prototype.addFrameLabel = function (name, frame) {
                            var scene = this._sceneForFrameIndex(frame);
                            if (!scene.getLabelByName(name, false)) {
                                scene.labels.value.push(new this.sec.flash.display.FrameLabel(name, frame - scene.offset));
                            }
                        };
                        MovieClip.prototype.prevScene = function () {
                            var currentScene = this._sceneForFrameIndex(this._currentFrame);
                            if (currentScene.offset === 0) {
                                return;
                            }
                            // Since scene offsets are 0-based, the current scene's offset, treated as a frame index,
                            // is the previous scene's last frame.
                            this._gotoFrameAbs(this._sceneForFrameIndex(currentScene.offset).offset + 1);
                        };
                        MovieClip.prototype.nextScene = function () {
                            var currentScene = this._sceneForFrameIndex(this._currentFrame);
                            if (currentScene.offset + currentScene.numFrames === this._totalFrames) {
                                return;
                            }
                            this._gotoFrameAbs(currentScene.offset + currentScene.numFrames + 1);
                        };
                        MovieClip.prototype._containsPointImpl = function (globalX, globalY, localX, localY, testingType, objects, skipBoundsCheck) {
                            var result = _super.prototype._containsPointImpl.call(this, globalX, globalY, localX, localY, testingType, objects, true);
                            // In AVM1 SWFs, MovieClips are transparent to the mouse as long as they don't have a handler
                            // attached to them for any of the button-related events.
                            if (result === 2 /* Shape */ && testingType === 3 /* Mouse */ &&
                                '_as2Object' in this && !this.buttonMode && objects[0] === this) {
                                objects.length = 0;
                            }
                            return result;
                        };
                        // List of static symbols to link.
                        MovieClip.classSymbols = null; // [];
                        // List of instance symbols to link.
                        MovieClip.instanceSymbols = null; // ["currentLabels"];
                        return MovieClip;
                    })(flash.display.Sprite);
                    display.MovieClip = MovieClip;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: MovieClip
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var MP3DecoderSession = Shumway.SWF.MP3DecoderSession;
                    var MP3_MIME_TYPE = 'audio/mpeg';
                    var HTMLAudioElementAdapter = (function () {
                        function HTMLAudioElementAdapter(sec, element) {
                            this._sec = sec;
                            this._element = element;
                        }
                        Object.defineProperty(HTMLAudioElementAdapter.prototype, "isReady", {
                            get: function () {
                                return !!this._channel;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(HTMLAudioElementAdapter.prototype, "element", {
                            get: function () {
                                return this._element;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(HTMLAudioElementAdapter.prototype, "currentTime", {
                            get: function () {
                                return this._element.currentTime;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        HTMLAudioElementAdapter.prototype.playFrom = function (time) {
                            var element = this._element;
                            if (element.paused) {
                                element.play();
                                element.addEventListener('playing', function setTime(e) {
                                    element.removeEventListener('playing', setTime);
                                    element.currentTime = time;
                                });
                            }
                            else {
                                element.currentTime = time;
                            }
                        };
                        Object.defineProperty(HTMLAudioElementAdapter.prototype, "paused", {
                            get: function () {
                                return this._element.paused;
                            },
                            set: function (value) {
                                var element = this._element;
                                if (value) {
                                    if (!element.paused) {
                                        element.pause();
                                    }
                                }
                                else {
                                    if (element.paused) {
                                        element.play();
                                    }
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        HTMLAudioElementAdapter.prototype.createChannel = function () {
                            this._channel = flash.media.SoundChannel.initializeFromAudioElement(this._sec, this._element);
                        };
                        HTMLAudioElementAdapter.prototype.queueData = function (frame) {
                            Shumway.Debug.abstractMethod('HTMLAudioElementAdapter::queueData');
                        };
                        HTMLAudioElementAdapter.prototype.finish = function () {
                            Shumway.Debug.abstractMethod('HTMLAudioElementAdapter::finish');
                        };
                        return HTMLAudioElementAdapter;
                    })();
                    var MediaSourceStreamAdapter = (function (_super) {
                        __extends(MediaSourceStreamAdapter, _super);
                        function MediaSourceStreamAdapter(sec, element) {
                            _super.call(this, sec, element);
                            this._mediaSource = new MediaSource();
                            this._sourceBuffer = null;
                            this._updating = false;
                            this._loading = true;
                            this._rawFrames = [];
                            this._isReady = false;
                            this._mediaSource.addEventListener('sourceopen', this._openMediaSource.bind(this));
                            this.element.src = URL.createObjectURL(this._mediaSource);
                        }
                        MediaSourceStreamAdapter.prototype._appendSoundData = function () {
                            if (this._rawFrames.length === 0 || this._updating || !this._sourceBuffer) {
                                return;
                            }
                            if (!this._loading) {
                                this._mediaSource.endOfStream();
                                return;
                            }
                            this._updating = true;
                            // There is an issue when multiple appendBuffers are added in a sequence,
                            // pushing frames one-by-one.
                            this._sourceBuffer.appendBuffer(this._rawFrames.shift());
                            // Making MediaSourceStreamAdapter be ready on first packet.
                            if (!this._isReady) {
                                this._isReady = true;
                                this.createChannel();
                            }
                        };
                        MediaSourceStreamAdapter.prototype._openMediaSource = function () {
                            var sourceBuffer = this._mediaSource.addSourceBuffer(MP3_MIME_TYPE);
                            sourceBuffer.addEventListener('update', function () {
                                this._updating = false;
                                this._appendSoundData();
                            }.bind(this));
                            this._sourceBuffer = sourceBuffer;
                            this._appendSoundData();
                        };
                        MediaSourceStreamAdapter.prototype.queueData = function (frame) {
                            this._rawFrames.push(frame.data);
                            this._appendSoundData();
                        };
                        MediaSourceStreamAdapter.prototype.finish = function () {
                            this._loading = false;
                            this._appendSoundData();
                        };
                        return MediaSourceStreamAdapter;
                    })(HTMLAudioElementAdapter);
                    var BlobStreamAdapter = (function (_super) {
                        __extends(BlobStreamAdapter, _super);
                        function BlobStreamAdapter(sec, element) {
                            _super.call(this, sec, element);
                            this._rawFrames = [];
                        }
                        BlobStreamAdapter.prototype.queueData = function (frame) {
                            this._rawFrames.push(frame.data);
                        };
                        BlobStreamAdapter.prototype.finish = function () {
                            var blob = new Blob(this._rawFrames);
                            this.element.src = URL.createObjectURL(blob);
                            this.createChannel();
                        };
                        return BlobStreamAdapter;
                    })(HTMLAudioElementAdapter);
                    function syncTime(element, movieClip) {
                        var initialized = false;
                        var startMediaTime, startRealTime;
                        element.addEventListener('timeupdate', function (e) {
                            if (!initialized) {
                                startMediaTime = element.currentTime;
                                startRealTime = performance.now();
                                initialized = true;
                                //movieClip._stage._frameScheduler.startTrackDelta();
                                return;
                            }
                            var mediaDelta = element.currentTime - startMediaTime;
                            var realDelta = performance.now() - startRealTime;
                            //movieClip._stage._frameScheduler.setDelta(realDelta - mediaDelta * 1000);
                        });
                        element.addEventListener('pause', function (e) {
                            //movieClip._stage._frameScheduler.endTrackDelta();
                            initialized = false;
                        });
                        element.addEventListener('seeking', function (e) {
                            //movieClip._stage._frameScheduler.endTrackDelta();
                            initialized = false;
                        });
                    }
                    var WebAudioAdapter = (function () {
                        function WebAudioAdapter(sec, data) {
                            this._sec = sec;
                            this._channel = null;
                            this._sound = null;
                            this._data = data;
                            this._position = 0;
                        }
                        Object.defineProperty(WebAudioAdapter.prototype, "currentTime", {
                            get: function () {
                                return NaN;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        WebAudioAdapter.prototype.playFrom = function (time) {
                            // tslint, noop
                        };
                        Object.defineProperty(WebAudioAdapter.prototype, "paused", {
                            get: function () {
                                return false;
                            },
                            set: function (value) {
                                // tslint, noop
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(WebAudioAdapter.prototype, "isReady", {
                            get: function () {
                                return !!this._channel;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        WebAudioAdapter.prototype.queueData = function (frame) {
                            this._data.pcm.set(frame.pcm, this._position);
                            this._position += frame.pcm.length;
                        };
                        WebAudioAdapter.prototype.finish = function () {
                            // TODO Start from some seek offset, stopping
                            var sound = flash.media.Sound.initializeFromPCMData(this._sec, this._data);
                            var channel = sound.play();
                            this._sound = sound;
                            this._channel = channel;
                        };
                        return WebAudioAdapter;
                    })();
                    var WebAudioMP3Adapter = (function (_super) {
                        __extends(WebAudioMP3Adapter, _super);
                        function WebAudioMP3Adapter(sec, data) {
                            _super.call(this, sec, data);
                            this._decoderPosition = 0;
                            this._decoderSession = new MP3DecoderSession();
                            this._decoderSession.onframedata = function (frameData) {
                                var position = this._decoderPosition;
                                data.pcm.set(frameData, position);
                                this._decoderPosition = position + frameData.length;
                            }.bind(this);
                            this._decoderSession.onclosed = function () {
                                WebAudioAdapter.prototype.finish.call(this);
                            }.bind(this);
                            this._decoderSession.onerror = function (error) {
                                Shumway.Debug.warning('MP3DecoderSession error: ' + error);
                            };
                        }
                        WebAudioMP3Adapter.prototype.queueData = function (frame) {
                            this._decoderSession.pushAsync(frame.data);
                        };
                        WebAudioMP3Adapter.prototype.finish = function () {
                            this._decoderSession.close();
                        };
                        return WebAudioMP3Adapter;
                    })(WebAudioAdapter);
                    var MovieClipSoundStream = (function () {
                        function MovieClipSoundStream(streamInfo, movieClip) {
                            this.movieClip = movieClip;
                            this.decode = streamInfo.decode.bind(streamInfo);
                            this.data = {
                                sampleRate: streamInfo.sampleRate,
                                channels: streamInfo.channels
                            };
                            this.seekIndex = [];
                            this.position = 0;
                            this.wasFullyLoaded = false;
                            this.expectedFrame = 0;
                            this.waitFor = 0;
                            var sec = movieClip.sec;
                            var isMP3 = streamInfo.format === 'mp3';
                            if (isMP3 && !AS.webAudioMP3Option.value) {
                                var element = document.createElement('audio');
                                element.preload = 'metadata'; // for mobile devices
                                element.loop = false;
                                syncTime(element, movieClip);
                                if (element.canPlayType(MP3_MIME_TYPE)) {
                                    this.element = element;
                                    if (!AS.mediaSourceMP3Option.value) {
                                        this.soundStreamAdapter = new BlobStreamAdapter(sec, element);
                                    }
                                    else if (typeof MediaSource !== 'undefined' &&
                                        MediaSource.isTypeSupported(MP3_MIME_TYPE)) {
                                        this.soundStreamAdapter = new MediaSourceStreamAdapter(sec, element);
                                    }
                                    else {
                                        // Falls back to blob playback.
                                        Shumway.Debug.warning('MediaSource is not supported');
                                        this.soundStreamAdapter = new BlobStreamAdapter(sec, element);
                                    }
                                    return;
                                }
                            }
                            // TODO fix streamInfo.samplesCount name -- its actually average value
                            var totalSamples = (streamInfo.samplesCount + 1) * this.movieClip.totalFrames * streamInfo.channels;
                            this.data.pcm = new Float32Array(totalSamples);
                            this.soundStreamAdapter = !isMP3 ? new WebAudioAdapter(sec, this.data) :
                                new WebAudioMP3Adapter(sec, this.data);
                        }
                        MovieClipSoundStream.prototype.appendBlock = function (frameNum, streamBlock) {
                            var decodedBlock = this.decode(streamBlock);
                            var streamPosition = this.position;
                            this.seekIndex[frameNum] = streamPosition + decodedBlock.seek * this.data.channels;
                            this.position = streamPosition + decodedBlock.samplesCount * this.data.channels;
                            this.soundStreamAdapter.queueData(decodedBlock);
                        };
                        MovieClipSoundStream.prototype.playFrame = function (frameNum) {
                            if (isNaN(this.seekIndex[frameNum])) {
                                return;
                            }
                            var PAUSE_WHEN_OF_SYNC_GREATER = 1.0;
                            var PLAYBACK_ADJUSTMENT = 0.25;
                            if (!this.wasFullyLoaded && this.movieClip._isFullyLoaded) {
                                this.wasFullyLoaded = true;
                                this.soundStreamAdapter.finish();
                            }
                            if (this.soundStreamAdapter.isReady &&
                                !isNaN(this.soundStreamAdapter.currentTime)) {
                                var soundStreamData = this.data;
                                var time = this.seekIndex[frameNum] /
                                    soundStreamData.sampleRate / soundStreamData.channels;
                                var elementTime = this.soundStreamAdapter.currentTime;
                                if (this.expectedFrame !== frameNum) {
                                    this.soundStreamAdapter.playFrom(time);
                                }
                                else if (this.waitFor > 0) {
                                    if (this.waitFor <= time) {
                                        this.soundStreamAdapter.paused = false;
                                        this.waitFor = 0;
                                    }
                                }
                                else if (elementTime - time > PAUSE_WHEN_OF_SYNC_GREATER) {
                                    Shumway.Debug.warning('Sound is faster than frames by ' + (elementTime - time));
                                    this.waitFor = elementTime - PLAYBACK_ADJUSTMENT;
                                    this.soundStreamAdapter.paused = true;
                                }
                                else if (time - elementTime > PAUSE_WHEN_OF_SYNC_GREATER) {
                                    Shumway.Debug.warning('Sound is slower than frames by ' + (time - elementTime));
                                    this.soundStreamAdapter.playFrom(time + PLAYBACK_ADJUSTMENT);
                                }
                                this.expectedFrame = frameNum + 1;
                            }
                        };
                        return MovieClipSoundStream;
                    })();
                    display.MovieClipSoundStream = MovieClipSoundStream;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: Stage
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var assert = Shumway.Debug.assert;
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var Stage = (function (_super) {
                        __extends(Stage, _super);
                        function Stage() {
                            _super.call(this);
                            this._root = this;
                            this._stage = this;
                            this._frameRate = 24;
                            this._scaleMode = display.StageScaleMode.SHOW_ALL;
                            this._align = "";
                            this._stageWidth = 0;
                            this._stageHeight = 0;
                            this._showDefaultContextMenu = true;
                            this._focus = null;
                            this._colorCorrection = display.ColorCorrection.DEFAULT;
                            this._colorCorrectionSupport = display.ColorCorrectionSupport.DEFAULT_OFF;
                            this._stageFocusRect = true;
                            this._quality = display.StageQuality.HIGH;
                            this._displayState = null;
                            this._fullScreenSourceRect = null;
                            this._mouseLock = false;
                            var objectVectorClass = this.sec.getVectorClass(this.sec.AXObject);
                            this._stageVideos = objectVectorClass.axConstruct([0, true]);
                            this._stage3Ds = objectVectorClass.axConstruct([0, true]);
                            this._colorARGB = 0xFFFFFFFF;
                            this._fullScreenWidth = 0;
                            this._fullScreenHeight = 0;
                            this._wmodeGPU = false;
                            this._softKeyboardRect = new this.sec.flash.geom.Rectangle();
                            this._allowsFullScreen = false;
                            this._allowsFullScreenInteractive = false;
                            this._contentsScaleFactor = 1;
                            this._displayContextInfo = null;
                            this._timeout = -1;
                            this._stageContainerWidth = -1;
                            this._stageContainerHeight = -1;
                            this._setFlags(262144 /* HasPerspectiveProjection */);
                            /**
                             * Indicates if a Render event was requested by calling the |invalid| function.
                             */
                            this._invalidated = false;
                        }
                        Stage.prototype.setRoot = function (root) {
                            this.addTimelineObjectAtDepth(root, 0);
                        };
                        Object.defineProperty(Stage.prototype, "frameRate", {
                            get: function () {
                                return this._frameRate;
                            },
                            set: function (value) {
                                this._frameRate = +value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "scaleMode", {
                            get: function () {
                                return this._scaleMode;
                            },
                            set: function (value) {
                                value = axCoerceString(value);
                                if (flash.display.StageScaleMode.toNumber(value) < 0) {
                                    this.sec.throwError("ArgumentError", AVMX.Errors.InvalidEnumError, "scaleMode");
                                }
                                if (this._scaleMode !== value) {
                                    this._isDirty = true;
                                    this._scaleMode = value;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "align", {
                            get: function () {
                                return this._align;
                            },
                            set: function (value) {
                                value = axCoerceString(value);
                                var n = flash.display.StageAlign.toNumber(value);
                                release || assert(n >= 0);
                                var newValue = flash.display.StageAlign.fromNumber(n);
                                if (this._align !== newValue) {
                                    this._isDirty = true;
                                    this._align = newValue;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "stageWidth", {
                            get: function () {
                                if (this.scaleMode !== display.StageScaleMode.NO_SCALE) {
                                    return this._stageWidth / 20 | 0;
                                }
                                release || assert(this._stageContainerWidth >= 0);
                                return this._stageContainerWidth;
                            },
                            set: function (value /*int*/) {
                                // While the setter doesn't change the stored value, it still coerces the `value` parameter.
                                // This is script-visible if the value is something like `{valueOf: function(){throw 1}}`.
                                value = value | 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Stage.prototype._setInitialName = function () {
                            this._name = null;
                        };
                        /**
                         * Non-AS3-available setter. In AS3, the `stageWidth` setter is silently ignored.
                         */
                        Stage.prototype.setStageWidth = function (value) {
                            release || assert((value | 0) === value);
                            var newValue = (value * 20) | 0;
                            if (this._stageWidth !== newValue) {
                                this._isDirty = true;
                                this._stageWidth = newValue;
                            }
                        };
                        Object.defineProperty(Stage.prototype, "stageHeight", {
                            get: function () {
                                if (this.scaleMode !== display.StageScaleMode.NO_SCALE) {
                                    return this._stageHeight / 20 | 0;
                                }
                                release || assert(this._stageContainerHeight >= 0);
                                return this._stageContainerHeight;
                            },
                            set: function (value /*int*/) {
                                // While the setter doesn't change the stored value, it still coerces the `value` parameter.
                                // This is script-visible if the value is something like `{valueOf: function(){throw 1}}`.
                                value = value | 0;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        /**
                         * Non-AS3-available setter. In AS3, the `stageHeight` setter is silently ignored.
                         */
                        Stage.prototype.setStageHeight = function (value) {
                            release || assert((value | 0) === value);
                            var newValue = (value * 20) | 0;
                            if (this._stageHeight !== newValue) {
                                this._isDirty = true;
                                this._stageHeight = newValue;
                            }
                        };
                        /**
                         * Almost the same as color setter, except it preserves alpha channel.
                         * @param value
                         */
                        Stage.prototype.setStageColor = function (value) {
                            if (this._colorARGB !== value) {
                                this._isDirty = true;
                                this._colorARGB = value;
                            }
                        };
                        /**
                         * Non-AS3-available setter. Notifies the stage that the dimensions of the stage container have changed.
                         */
                        Stage.prototype.setStageContainerSize = function (width, height, pixelRatio) {
                            // Flash doesn't fire a resize event if the pixel ratio has changed, but it needs to be set if
                            // a resize event gets dispatched as a result of a size change.
                            this._contentsScaleFactor = pixelRatio;
                            var sizeHasChanged = this._stageContainerWidth !== width || this._stageContainerHeight !== height;
                            if (sizeHasChanged) {
                                this._stageContainerWidth = width;
                                this._stageContainerHeight = height;
                                if (this.scaleMode === display.StageScaleMode.NO_SCALE) {
                                    this.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(flash.events.Event.RESIZE));
                                }
                            }
                        };
                        Object.defineProperty(Stage.prototype, "showDefaultContextMenu", {
                            get: function () {
                                return this._showDefaultContextMenu;
                            },
                            set: function (value) {
                                this._showDefaultContextMenu = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "focus", {
                            get: function () {
                                return this._focus;
                            },
                            set: function (newFocus) {
                                this._focus = newFocus;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "colorCorrection", {
                            get: function () {
                                return this._colorCorrection;
                            },
                            set: function (value) {
                                //this._colorCorrection = axCoerceString(value);
                                release || notImplemented("public flash.display.Stage::set colorCorrection");
                                return;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "colorCorrectionSupport", {
                            get: function () {
                                return this._colorCorrectionSupport;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "stageFocusRect", {
                            get: function () {
                                return this._stageFocusRect;
                            },
                            set: function (on) {
                                this._stageFocusRect = !!on;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "quality", {
                            get: function () {
                                return this._quality.toUpperCase(); // Return value is always uppercase
                            },
                            set: function (value) {
                                // TODO: The *linear versions return just *, stripping the "linear" part
                                // Value is compared case-insensitively, and has default handling, so '' is ok.
                                value = (axCoerceString(value) || '').toLowerCase();
                                if (flash.display.StageQuality.toNumber(value) < 0) {
                                    value = flash.display.StageQuality.HIGH;
                                }
                                this._quality = value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "displayState", {
                            get: function () {
                                return this._displayState;
                            },
                            set: function (value) {
                                value = axCoerceString(value);
                                // TODO: This should only be allowed if the embedding page allows full screen mode.
                                if (flash.display.StageDisplayState.toNumber(value) < 0) {
                                    value = flash.display.StageDisplayState.NORMAL;
                                }
                                if (this._displayState !== value) {
                                    this._isDirty = true;
                                    this._displayState = value;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "fullScreenSourceRect", {
                            get: function () {
                                return this._fullScreenSourceRect;
                            },
                            set: function (value) {
                                //this._fullScreenSourceRect = value;
                                release || notImplemented("public flash.display.Stage::set fullScreenSourceRect");
                                return;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "mouseLock", {
                            get: function () {
                                return this._mouseLock;
                            },
                            set: function (value) {
                                release || somewhatImplemented("public flash.display.Stage::set mouseLock");
                                this._mouseLock = !!value;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "stageVideos", {
                            get: function () {
                                release || somewhatImplemented("public flash.display.Stage::get stageVideos");
                                return this._stageVideos;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "stage3Ds", {
                            get: function () {
                                release || somewhatImplemented("public flash.display.Stage::get stage3Ds");
                                return this._stage3Ds;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "color", {
                            get: function () {
                                return this._colorARGB;
                            },
                            set: function (rgb /*uint*/) {
                                var newValue = rgb | 0xff000000;
                                // Flash player forces the alpha channel to 0xff.
                                if (this._colorARGB !== newValue) {
                                    this._isDirty = true;
                                    this._colorARGB = newValue;
                                }
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "alpha", {
                            get: function () {
                                return this._colorTransform.alphaMultiplier;
                            },
                            set: function (alpha) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "fullScreenWidth", {
                            get: function () {
                                return this._fullScreenWidth;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "fullScreenHeight", {
                            get: function () {
                                return this._fullScreenHeight;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "wmodeGPU", {
                            get: function () {
                                return this._wmodeGPU;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "softKeyboardRect", {
                            get: function () {
                                return this._softKeyboardRect;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "allowsFullScreen", {
                            get: function () {
                                return this._allowsFullScreen;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "allowsFullScreenInteractive", {
                            get: function () {
                                return this._allowsFullScreenInteractive;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "contentsScaleFactor", {
                            get: function () {
                                return this._contentsScaleFactor;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "displayContextInfo", {
                            get: function () {
                                return this._displayContextInfo;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Stage.prototype.removeChildAt = function (index) {
                            this.requireOwnerPermissions();
                            return _super.prototype.removeChildAt.call(this, index);
                        };
                        Stage.prototype.swapChildrenAt = function (index1 /*int*/, index2 /*int*/) {
                            this.requireOwnerPermissions();
                            _super.prototype.swapChildrenAt.call(this, index1, index2);
                        };
                        Object.defineProperty(Stage.prototype, "width", {
                            get: function () {
                                this.requireOwnerPermissions();
                                return this._getWidth();
                            },
                            set: function (value) {
                                this.requireOwnerPermissions();
                                this._setWidth(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "height", {
                            get: function () {
                                this.requireOwnerPermissions();
                                return this._getHeight();
                            },
                            set: function (value) {
                                this.requireOwnerPermissions();
                                this._setHeight(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "mouseChildren", {
                            get: function () {
                                this.requireOwnerPermissions();
                                return this._getMouseChildren();
                            },
                            set: function (value) {
                                this.requireOwnerPermissions();
                                this._setMouseChildren(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "numChildren", {
                            get: function () {
                                this.requireOwnerPermissions();
                                return this._getNumChildren();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "tabChildren", {
                            get: function () {
                                this.requireOwnerPermissions();
                                return this._getTabChildren();
                            },
                            set: function (value) {
                                this.requireOwnerPermissions();
                                this._setTabChildren(value);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Stage.prototype.addChild = function (child) {
                            this.requireOwnerPermissions();
                            return _super.prototype.addChild.call(this, child);
                        };
                        Stage.prototype.addChildAt = function (child, index) {
                            this.requireOwnerPermissions();
                            return _super.prototype.addChildAt.call(this, child, index);
                        };
                        Stage.prototype.setChildIndex = function (child, index) {
                            this.requireOwnerPermissions();
                            _super.prototype.setChildIndex.call(this, child, index);
                        };
                        Stage.prototype.addEventListener = function (type, listener, useCapture, priority, useWeakReference) {
                            this.requireOwnerPermissions();
                            _super.prototype.addEventListener.call(this, type, listener, useCapture, priority, useWeakReference);
                        };
                        Stage.prototype.hasEventListener = function (type) {
                            this.requireOwnerPermissions();
                            return _super.prototype.hasEventListener.call(this, type);
                        };
                        Stage.prototype.willTrigger = function (type) {
                            this.requireOwnerPermissions();
                            return _super.prototype.willTrigger.call(this, type);
                        };
                        Stage.prototype.dispatchEvent = function (event) {
                            this.requireOwnerPermissions();
                            return _super.prototype.dispatchEvent.call(this, event);
                        };
                        Stage.prototype.invalidate = function () {
                            this._invalidated = true;
                        };
                        Stage.prototype.isFocusInaccessible = function () {
                            release || notImplemented("public flash.display.Stage::isFocusInaccessible");
                            return;
                        };
                        Stage.prototype.requireOwnerPermissions = function () {
                            // TODO: implement requireOwnerPermissions
                        };
                        Stage.prototype.render = function () {
                            if (!this._invalidated) {
                                return;
                            }
                            this.sec.flash.display.DisplayObject.axClass._broadcastFrameEvent(flash.events.Event.RENDER);
                            this._invalidated = false;
                        };
                        Object.defineProperty(Stage.prototype, "name", {
                            get: function () {
                                return this._name;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "mask", {
                            get: function () {
                                return this._mask;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "visible", {
                            get: function () {
                                return this._hasFlags(1 /* Visible */);
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "x", {
                            get: function () {
                                return this._getX();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "y", {
                            get: function () {
                                return this._getY();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "z", {
                            get: function () {
                                return this._z;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "scaleX", {
                            get: function () {
                                return Math.abs(this._scaleX);
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "scaleY", {
                            get: function () {
                                return this._scaleY;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "scaleZ", {
                            get: function () {
                                return this._scaleZ;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "rotation", {
                            get: function () {
                                return this._rotation;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "rotationX", {
                            get: function () {
                                return this._rotationX;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "rotationY", {
                            get: function () {
                                return this._rotationX;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "rotationZ", {
                            get: function () {
                                return this._rotationX;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "cacheAsBitmap", {
                            get: function () {
                                return this._getCacheAsBitmap();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "opaqueBackground", {
                            get: function () {
                                return this._opaqueBackground;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "scrollRect", {
                            get: function () {
                                return this._getScrollRect();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "filters", {
                            get: function () {
                                return this._getFilters();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "blendMode", {
                            get: function () {
                                return this._blendMode;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "transform", {
                            get: function () {
                                return this._getTransform();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "accessibilityProperties", {
                            get: function () {
                                return this._accessibilityProperties;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "scale9Grid", {
                            get: function () {
                                return this._getScale9Grid();
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "tabEnabled", {
                            get: function () {
                                return this._tabEnabled;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "tabIndex", {
                            get: function () {
                                return this._tabIndex;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "focusRect", {
                            get: function () {
                                return this._focusRect;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "mouseEnabled", {
                            get: function () {
                                return this._mouseEnabled;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "accessibilityImplementation", {
                            get: function () {
                                return this._accessibilityImplementation;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "textSnapshot", {
                            get: function () {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                                return null;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Stage.prototype, "contextMenu", {
                            get: function () {
                                return this._contextMenu;
                            },
                            set: function (value) {
                                this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidStageMethodError);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Stage.classInitializer = null;
                        Stage.classSymbols = null; // [];
                        Stage.instanceSymbols = null;
                        return Stage;
                    })(flash.display.DisplayObjectContainer);
                    display.Stage = Stage;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: ActionScriptVersion
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var ActionScriptVersion = (function (_super) {
                        __extends(ActionScriptVersion, _super);
                        function ActionScriptVersion() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        ActionScriptVersion.classInitializer = null;
                        // List of static symbols to link.
                        ActionScriptVersion.classSymbols = null; // [];
                        // List of instance symbols to link.
                        ActionScriptVersion.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        ActionScriptVersion.ACTIONSCRIPT2 = 2;
                        ActionScriptVersion.ACTIONSCRIPT3 = 3;
                        return ActionScriptVersion;
                    })(AS.ASObject);
                    display.ActionScriptVersion = ActionScriptVersion;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: BlendMode
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var BlendMode = (function (_super) {
                        __extends(BlendMode, _super);
                        function BlendMode() {
                            _super.call(this);
                        }
                        /**
                         * Returns the blend mode string from the numeric value that appears in the
                         * swf file.
                         */
                        BlendMode.fromNumber = function (n) {
                            switch (n) {
                                case 0:
                                case 1:
                                    return BlendMode.NORMAL;
                                case 2:
                                    return BlendMode.LAYER;
                                case 3:
                                    return BlendMode.MULTIPLY;
                                case 4:
                                    return BlendMode.SCREEN;
                                case 5:
                                    return BlendMode.LIGHTEN;
                                case 6:
                                    return BlendMode.DARKEN;
                                case 7:
                                    return BlendMode.DIFFERENCE;
                                case 8:
                                    return BlendMode.ADD;
                                case 9:
                                    return BlendMode.SUBTRACT;
                                case 10:
                                    return BlendMode.INVERT;
                                case 11:
                                    return BlendMode.ALPHA;
                                case 12:
                                    return BlendMode.ERASE;
                                case 13:
                                    return BlendMode.OVERLAY;
                                case 14:
                                    return BlendMode.HARDLIGHT;
                                default:
                                    return null;
                            }
                        };
                        BlendMode.toNumber = function (value) {
                            switch (value) {
                                case BlendMode.NORMAL:
                                    return 1;
                                case BlendMode.LAYER:
                                    return 2;
                                case BlendMode.MULTIPLY:
                                    return 3;
                                case BlendMode.SCREEN:
                                    return 4;
                                case BlendMode.LIGHTEN:
                                    return 5;
                                case BlendMode.DARKEN:
                                    return 6;
                                case BlendMode.DIFFERENCE:
                                    return 7;
                                case BlendMode.ADD:
                                    return 8;
                                case BlendMode.SUBTRACT:
                                    return 9;
                                case BlendMode.INVERT:
                                    return 10;
                                case BlendMode.ALPHA:
                                    return 11;
                                case BlendMode.ERASE:
                                    return 12;
                                case BlendMode.OVERLAY:
                                    return 13;
                                case BlendMode.HARDLIGHT:
                                    return 14;
                                default:
                                    return -1;
                            }
                        };
                        // Called whenever the class is initialized.
                        BlendMode.classInitializer = null;
                        // List of static symbols to link.
                        BlendMode.classSymbols = null; // [];
                        // List of instance symbols to link.
                        BlendMode.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        BlendMode.NORMAL = "normal";
                        BlendMode.LAYER = "layer";
                        BlendMode.MULTIPLY = "multiply";
                        BlendMode.SCREEN = "screen";
                        BlendMode.LIGHTEN = "lighten";
                        BlendMode.DARKEN = "darken";
                        BlendMode.ADD = "add";
                        BlendMode.SUBTRACT = "subtract";
                        BlendMode.DIFFERENCE = "difference";
                        BlendMode.INVERT = "invert";
                        BlendMode.OVERLAY = "overlay";
                        BlendMode.HARDLIGHT = "hardlight";
                        BlendMode.ALPHA = "alpha";
                        BlendMode.ERASE = "erase";
                        BlendMode.SHADER = "shader";
                        return BlendMode;
                    })(AS.ASObject);
                    display.BlendMode = BlendMode;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: ColorCorrection
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var ColorCorrection = (function (_super) {
                        __extends(ColorCorrection, _super);
                        function ColorCorrection() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        ColorCorrection.fromNumber = function (n) {
                            switch (n) {
                                case 0:
                                    return ColorCorrection.DEFAULT;
                                case 1:
                                    return ColorCorrection.ON;
                                case 2:
                                    return ColorCorrection.OFF;
                                default:
                                    return null;
                            }
                        };
                        ColorCorrection.toNumber = function (value) {
                            switch (value) {
                                case ColorCorrection.DEFAULT:
                                    return 0;
                                case ColorCorrection.ON:
                                    return 1;
                                case ColorCorrection.OFF:
                                    return 2;
                                default:
                                    return -1;
                            }
                        };
                        // Called whenever the class is initialized.
                        ColorCorrection.classInitializer = null;
                        // List of static symbols to link.
                        ColorCorrection.classSymbols = null; // [];
                        // List of instance symbols to link.
                        ColorCorrection.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        ColorCorrection.DEFAULT = "default";
                        ColorCorrection.ON = "on";
                        ColorCorrection.OFF = "off";
                        return ColorCorrection;
                    })(AS.ASObject);
                    display.ColorCorrection = ColorCorrection;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: ColorCorrectionSupport
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var ColorCorrectionSupport = (function (_super) {
                        __extends(ColorCorrectionSupport, _super);
                        function ColorCorrectionSupport() {
                            _super.call(this);
                        }
                        // AS -> JS Bindings
                        ColorCorrectionSupport.fromNumber = function (n) {
                            switch (n) {
                                case 0:
                                    return ColorCorrectionSupport.UNSUPPORTED;
                                case 1:
                                    return ColorCorrectionSupport.DEFAULT_ON;
                                case 2:
                                    return ColorCorrectionSupport.DEFAULT_OFF;
                                default:
                                    return null;
                            }
                        };
                        ColorCorrectionSupport.toNumber = function (value) {
                            switch (value) {
                                case ColorCorrectionSupport.UNSUPPORTED:
                                    return 0;
                                case ColorCorrectionSupport.DEFAULT_ON:
                                    return 1;
                                case ColorCorrectionSupport.DEFAULT_OFF:
                                    return 2;
                                default:
                                    return -1;
                            }
                        };
                        // Called whenever the class is initialized.
                        ColorCorrectionSupport.classInitializer = null;
                        // List of static symbols to link.
                        ColorCorrectionSupport.classSymbols = null; // [];
                        // List of instance symbols to link.
                        ColorCorrectionSupport.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        ColorCorrectionSupport.UNSUPPORTED = "unsupported";
                        ColorCorrectionSupport.DEFAULT_ON = "defaultOn";
                        ColorCorrectionSupport.DEFAULT_OFF = "defaultOff";
                        return ColorCorrectionSupport;
                    })(AS.ASObject);
                    display.ColorCorrectionSupport = ColorCorrectionSupport;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: FocusDirection
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var FocusDirection = (function (_super) {
                        __extends(FocusDirection, _super);
                        function FocusDirection() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        FocusDirection.classInitializer = null;
                        // List of static symbols to link.
                        FocusDirection.classSymbols = null; // [];
                        // List of instance symbols to link.
                        FocusDirection.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        FocusDirection.TOP = "top";
                        FocusDirection.BOTTOM = "bottom";
                        FocusDirection.NONE = "none";
                        return FocusDirection;
                    })(AS.ASObject);
                    display.FocusDirection = FocusDirection;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: FrameLabel
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var FrameLabel = (function (_super) {
                        __extends(FrameLabel, _super);
                        function FrameLabel(name, frame /*int*/) {
                            _super.call(this);
                            this._name = axCoerceString(name);
                            this._frame = frame | 0;
                        }
                        Object.defineProperty(FrameLabel.prototype, "name", {
                            get: function () {
                                return this._name;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(FrameLabel.prototype, "frame", {
                            get: function () {
                                return this._frame;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        FrameLabel.prototype.clone = function () {
                            return new this.sec.flash.display.FrameLabel(this._name, this._frame);
                        };
                        // Called whenever the class is initialized.
                        FrameLabel.classInitializer = null;
                        return FrameLabel;
                    })(flash.events.EventDispatcher);
                    display.FrameLabel = FrameLabel;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: BitmapData
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var notImplemented = Shumway.Debug.notImplemented;
                    var assert = Shumway.Debug.assert;
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var DataBuffer = Shumway.ArrayUtilities.DataBuffer;
                    var axCoerceString = Shumway.AVMX.axCoerceString;
                    var swap32 = Shumway.IntegerUtilities.swap32;
                    var premultiplyARGB = Shumway.ColorUtilities.premultiplyARGB;
                    var unpremultiplyARGB = Shumway.ColorUtilities.unpremultiplyARGB;
                    var RGBAToARGB = Shumway.ColorUtilities.RGBAToARGB;
                    var indexOf = Shumway.ArrayUtilities.indexOf;
                    /**
                     * Holds blobs of bitmap data in various formats and lets you do basic pixel operations. When
                     * data is unpacked, it is stored as premultiplied ARGB since it's what the SWF encodes bitmaps
                     * as.  This way we don't have to do unecessary byte conversions.
                     */
                    var BitmapData = (function (_super) {
                        __extends(BitmapData, _super);
                        function BitmapData(width /*int*/, height /*int*/, transparent, fillColorARGB) {
                            if (transparent === void 0) { transparent = true; }
                            if (fillColorARGB === void 0) { fillColorARGB = 4294967295; }
                            width = width | 0;
                            height = height | 0;
                            transparent = !!transparent;
                            fillColorARGB = fillColorARGB | 0;
                            _super.call(this);
                            if (this._symbol) {
                                this.applySymbol();
                                return;
                            }
                            if (width > BitmapData.MAXIMUM_WIDTH || width <= 0 ||
                                height > BitmapData.MAXIMUM_HEIGHT || height <= 0 ||
                                width * height > BitmapData.MAXIMUM_DIMENSION) {
                                this.sec.throwError('ArgumentError', AVMX.Errors.InvalidBitmapData);
                            }
                            this._rect = new this.sec.flash.geom.Rectangle(0, 0, width, height);
                            this._transparent = transparent;
                            this._id = flash.display.DisplayObject.getNextSyncID();
                            this._setData(new Uint8Array(width * height * 4), Shumway.ImageType.PremultipliedAlphaARGB);
                            var alpha = fillColorARGB >> 24;
                            if (alpha === 0 && transparent) {
                                // No need to do an initial fill since this would all be zeros anyway.
                                this._solidFillColorPBGRA = 0;
                            }
                            else {
                                this.fillRect(this._rect, fillColorARGB);
                            }
                            this._bitmapReferrers = [];
                            release || assert(this._isDirty === !!this._data);
                            release || assert(this._isRemoteDirty === !this._data);
                        }
                        BitmapData.classInitializer = function () {
                            this._temporaryRectangle = new this.sec.flash.geom.Rectangle();
                        };
                        BitmapData.prototype.applySymbol = function () {
                            release || assert(this._symbol);
                            var symbol = this._symbol;
                            release || assert(symbol.syncId);
                            this._rect = new this.sec.flash.geom.Rectangle(0, 0, symbol.width, symbol.height);
                            this._transparent = true;
                            this._id = symbol.syncId;
                            if (symbol.type === Shumway.ImageType.PremultipliedAlphaARGB ||
                                symbol.type === Shumway.ImageType.StraightAlphaARGB ||
                                symbol.type === Shumway.ImageType.StraightAlphaRGBA) {
                                release || assert(symbol.data);
                                this._setData(symbol.data, symbol.type);
                            }
                            else {
                                this._isDirty = false;
                                this._isRemoteDirty = true;
                            }
                            this._solidFillColorPBGRA = null;
                            this._bitmapReferrers = [];
                        };
                        BitmapData.prototype._setData = function (data, type) {
                            // Alpha images are parsed to Uint8Clamped array. Easiest to just handle here.
                            if (data instanceof Uint8ClampedArray) {
                                data = new Uint8Array(data.buffer);
                            }
                            release || assert(data instanceof Uint8Array);
                            this._data = data;
                            this._type = type;
                            this._view = new Int32Array(data.buffer);
                            this._dataBuffer = DataBuffer.FromArrayBuffer(data.buffer);
                            this._isDirty = true;
                            this._isRemoteDirty = false;
                        };
                        BitmapData.prototype._addBitmapReferrer = function (bitmap) {
                            var index = indexOf(this._bitmapReferrers, bitmap);
                            release || assert(index < 0);
                            this._bitmapReferrers.push(bitmap);
                        };
                        BitmapData.prototype._removeBitmapReferrer = function (bitmap) {
                            var index = indexOf(this._bitmapReferrers, bitmap);
                            release || assert(index >= 0);
                            this._bitmapReferrers[index] = null;
                        };
                        /**
                         * Called whenever the contents of this bitmap data changes.
                         */
                        BitmapData.prototype._invalidate = function () {
                            if (this._isDirty) {
                                return;
                            }
                            this._isDirty = true;
                            this._isRemoteDirty = false;
                            // TODO: We probably don't need to propagate any flags if |_locked| is true.
                            for (var i = 0; i < this._bitmapReferrers.length; i++) {
                                var bitmap = this._bitmapReferrers[i];
                                if (bitmap) {
                                    bitmap._setDirtyFlags(16 /* DirtyBitmapData */);
                                }
                            }
                        };
                        BitmapData.prototype._getTemporaryRectangleFrom = function (rect) {
                            var r = this.sec.flash.display.BitmapData.axClass._temporaryRectangle;
                            r.copyFrom(rect);
                            return r;
                        };
                        BitmapData.prototype.getDataBuffer = function () {
                            return this._dataBuffer;
                        };
                        BitmapData.prototype._getContentBounds = function () {
                            return Shumway.Bounds.FromRectangle(this._rect);
                        };
                        /**
                         * TODO: Not tested.
                         */
                        BitmapData.prototype._getPixelData = function (rect) {
                            var r = this._getTemporaryRectangleFrom(this._rect).intersectInPlace(rect);
                            if (r.isEmpty()) {
                                return;
                            }
                            var xMin = r.x;
                            var xMax = r.x + r.width;
                            var yMin = r.y;
                            var yMax = r.y + r.height;
                            this._ensureBitmapData();
                            var view = this._view;
                            var width = this._rect.width;
                            var output = new Int32Array(r.area);
                            var p = 0;
                            for (var y = yMin; y < yMax; y++) {
                                var offset = y * width;
                                for (var x = xMin; x < xMax; x++) {
                                    var colorBGRA = view[offset + x];
                                    var alpha = colorBGRA & 0xff;
                                    var colorBGR = colorBGRA >>> 8;
                                    colorBGRA = ((255 * colorBGR) / alpha) << 8 | alpha;
                                    output[p++] = colorBGRA;
                                }
                            }
                            return output;
                        };
                        /**
                         * TODO: Not tested.
                         */
                        BitmapData.prototype._putPixelData = function (rect, input) {
                            var r = this._getTemporaryRectangleFrom(this._rect).intersectInPlace(rect);
                            if (r.isEmpty()) {
                                return;
                            }
                            var xMin = r.x;
                            var xMax = r.x + r.width;
                            var yMin = r.y;
                            var yMax = r.y + r.height;
                            this._ensureBitmapData();
                            var view = this._view;
                            var width = this._rect.width;
                            var p = (rect.width * rect.height - r.height) + (xMin - rect.x);
                            var padding = rect.width - r.width;
                            var alphaMask = this._transparent ? 0x00 : 0xff;
                            for (var y = yMin; y < yMax; y++) {
                                var offset = y * width;
                                for (var x = xMin; x < xMax; x++) {
                                    var colorBGRA = input[p++];
                                    var alpha = colorBGRA & alphaMask;
                                    var colorBGR = colorBGRA >>> 8;
                                    view[offset + x] = (((colorBGR * alpha + 254) / 255) & 0x00ffffff) << 8 | alpha;
                                }
                                p += padding;
                            }
                            this._invalidate();
                        };
                        Object.defineProperty(BitmapData.prototype, "width", {
                            get: function () {
                                return this._rect.width;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(BitmapData.prototype, "height", {
                            get: function () {
                                return this._rect.height;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(BitmapData.prototype, "rect", {
                            get: function () {
                                return this._rect.clone();
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(BitmapData.prototype, "transparent", {
                            get: function () {
                                return this._transparent;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        BitmapData.prototype.clone = function () {
                            var bd = Object.create(this.sec.flash.display.BitmapData.axClass.tPrototype);
                            bd._rect = this._rect.clone();
                            bd._transparent = this._transparent;
                            bd._solidFillColorPBGRA = this._solidFillColorPBGRA;
                            bd._bitmapReferrers = [];
                            // TODO: clone without reading back bitmapdata. There's no need for that.
                            this._ensureBitmapData();
                            bd._id = flash.display.DisplayObject.getNextSyncID();
                            bd._setData(new Uint8Array(this._data), this._type);
                            return bd;
                        };
                        /**
                         * Returns an straight alpha RGB pixel value 0x00RRGGBB.
                         */
                        BitmapData.prototype.getPixel = function (x /*int*/, y /*int*/) {
                            x = x | 0;
                            y = y | 0;
                            return this.getPixel32(x, y) & 0x00ffffff;
                        };
                        /**
                         * Returns an straight alpha ARGB pixel value 0xAARRGGBB.
                         */
                        BitmapData.prototype.getPixel32 = function (x /*int*/, y /*int*/) {
                            x = x | 0;
                            y = y | 0;
                            if (!this._rect.contains(x, y)) {
                                return 0;
                            }
                            this._ensureBitmapData();
                            var value = this._view[y * this._rect.width + x];
                            switch (this._type) {
                                case Shumway.ImageType.PremultipliedAlphaARGB:
                                    var pARGB = swap32(value);
                                    var uARGB = unpremultiplyARGB(pARGB);
                                    return uARGB >>> 0;
                                case Shumway.ImageType.StraightAlphaRGBA:
                                    return RGBAToARGB(swap32(value));
                                default:
                                    Shumway.Debug.notImplemented(Shumway.ImageType[this._type]);
                                    return 0;
                            }
                        };
                        BitmapData.prototype.setPixel = function (x /*int*/, y /*int*/, uARGB /*uint*/) {
                            // TODO: implement this as a wrapper for setPixel32.
                            x = x | 0;
                            y = y | 0;
                            uARGB = uARGB | 0;
                            if (!this._rect.contains(x, y)) {
                                return;
                            }
                            this._ensureBitmapData();
                            var i = y * this._rect.width + x;
                            var a = this._view[i] & 0xff;
                            uARGB = uARGB & 0x00ffffff | a << 24;
                            var pARGB = premultiplyARGB(uARGB);
                            this._view[i] = swap32(pARGB);
                            this._invalidate();
                            this._solidFillColorPBGRA = null;
                        };
                        BitmapData.prototype.setPixel32 = function (x /*int*/, y /*int*/, uARGB /*uint*/) {
                            x = x | 0;
                            y = y | 0;
                            if (!this._rect.contains(x, y)) {
                                return;
                            }
                            this._ensureBitmapData();
                            var a = uARGB >>> 24;
                            var uRGB = uARGB & 0x00ffffff;
                            if (this._transparent) {
                                var uARGB = uRGB | a << 24;
                                var pARGB = premultiplyARGB(uARGB);
                            }
                            else {
                                var pARGB = uRGB | 0xff000000;
                            }
                            this._view[y * this._rect.width + x] = swap32(pARGB);
                            this._invalidate();
                            this._solidFillColorPBGRA = null;
                        };
                        BitmapData.prototype.applyFilter = function (sourceBitmapData, sourceRect, destPoint, filter) {
                            sourceBitmapData = sourceBitmapData;
                            sourceRect = sourceRect;
                            destPoint = destPoint;
                            filter = filter;
                            release || somewhatImplemented("public flash.display.BitmapData::applyFilter " + filter);
                            return;
                        };
                        BitmapData.prototype.colorTransform = function (rect, colorTransform) {
                            rect = rect;
                            colorTransform = colorTransform;
                            release || somewhatImplemented("public flash.display.BitmapData::colorTransform");
                            return;
                        };
                        BitmapData.prototype.compare = function (otherBitmapData) {
                            otherBitmapData = otherBitmapData;
                            release || notImplemented("public flash.display.BitmapData::compare");
                            return;
                        };
                        BitmapData.prototype.copyChannel = function (sourceBitmapData, sourceRect, destPoint, sourceChannel /*uint*/, destChannel) {
                            sourceBitmapData = sourceBitmapData;
                            sourceRect = sourceRect;
                            destPoint = destPoint;
                            sourceChannel = sourceChannel >>> 0;
                            destChannel = destChannel >>> 0;
                            release || somewhatImplemented("public flash.display.BitmapData::copyChannel");
                            return;
                        };
                        /**
                         * Copies a rectangular region of pixels into the current bitmap data.
                         */
                        BitmapData.prototype.copyPixels = function (sourceBitmapData, sourceRect, destPoint, alphaBitmapData, alphaPoint, mergeAlpha) {
                            if (alphaBitmapData === void 0) { alphaBitmapData = null; }
                            if (alphaPoint === void 0) { alphaPoint = null; }
                            mergeAlpha = !!mergeAlpha;
                            if (alphaBitmapData || alphaPoint) {
                                release || somewhatImplemented("public flash.display.BitmapData::copyPixels - Alpha");
                                return;
                            }
                            // Deal with fractional pixel coordinates, looks like Flash "rounds" the corners of
                            // the source rect, however a width of |0.5| rounds down rather than up so we're not
                            // quite correct here.
                            var sRect;
                            if (sourceRect) {
                                sRect = this._getTemporaryRectangleFrom(sourceRect).roundInPlace();
                            }
                            else {
                                sRect = this.sec.flash.display.BitmapData.axClass._temporaryRectangle.setEmpty();
                            }
                            var tBRect = this._rect;
                            var sBRect = sourceBitmapData._rect;
                            // Clip sRect against SBRect.
                            var sL = Math.max(sRect.x, 0);
                            var sT = Math.max(sRect.y, 0);
                            var sR = Math.min(sRect.x + sRect.width, sBRect.width);
                            var sB = Math.min(sRect.y + sRect.height, sBRect.height);
                            // Compute source rect offsets (in case the source rect had negative x, y coordinates).
                            var oX = sL - sRect.x;
                            var oY = sT - sRect.y;
                            var tL = (destPoint.x | 0) + oX;
                            var tT = (destPoint.y | 0) + oY;
                            if (tL < 0) {
                                sL -= tL;
                                tL = 0;
                            }
                            if (tT < 0) {
                                sT -= tT;
                                tT = 0;
                            }
                            var tW = Math.min(sR - sL, tBRect.width - tL);
                            var tH = Math.min(sB - sT, tBRect.height - tT);
                            if (tW <= 0 || tH <= 0) {
                                return;
                            }
                            var sX = sL;
                            var sY = sT;
                            var tX = tL;
                            var tY = tT;
                            var sStride = sourceBitmapData._rect.width;
                            var tStride = this._rect.width;
                            this._ensureBitmapData();
                            sourceBitmapData._ensureBitmapData();
                            var s = sourceBitmapData._view;
                            var t = this._view;
                            if (sourceBitmapData._type !== this._type) {
                                release || somewhatImplemented("public flash.display.BitmapData::copyPixels - Color Format Conversion");
                            }
                            if (mergeAlpha && this._type !== Shumway.ImageType.PremultipliedAlphaARGB) {
                                release || somewhatImplemented("public flash.display.BitmapData::copyPixels - Merge Alpha");
                                return;
                            }
                            // No reason to copy pixels since since both source and target are the same solid fill,
                            // regardless of alpha blending. (TODO: I think the math works out for mergeAlpha also.)
                            if (this._solidFillColorPBGRA !== null &&
                                this._solidFillColorPBGRA === sourceBitmapData._solidFillColorPBGRA) {
                                return;
                            }
                            // Source has a solid fill but is fully opaque, we can get away without alpha blending here.
                            if (sourceBitmapData._solidFillColorPBGRA !== null &&
                                (sourceBitmapData._solidFillColorPBGRA & 0xFF) === 0xFF) {
                                mergeAlpha = false;
                            }
                            // Finally do the copy. All the math above is needed just so we don't do any branches inside
                            // this hot loop.
                            if (mergeAlpha) {
                                this._copyPixelsAndMergeAlpha(s, sX, sY, sStride, t, tX, tY, tStride, tW, tH);
                            }
                            else {
                                var sP = (sY * sStride + sX) | 0;
                                var tP = (tY * tStride + tX) | 0;
                                if ((tW & 3) === 0) {
                                    for (var y = 0; y < tH; y = y + 1 | 0) {
                                        for (var x = 0; x < tW; x = x + 4 | 0) {
                                            t[(tP + x + 0) | 0] = s[(sP + x + 0) | 0];
                                            t[(tP + x + 1) | 0] = s[(sP + x + 1) | 0];
                                            t[(tP + x + 2) | 0] = s[(sP + x + 2) | 0];
                                            t[(tP + x + 3) | 0] = s[(sP + x + 3) | 0];
                                        }
                                        sP = sP + sStride | 0;
                                        tP = tP + tStride | 0;
                                    }
                                }
                                else {
                                    for (var y = 0; y < tH; y = y + 1 | 0) {
                                        for (var x = 0; x < tW; x = x + 1 | 0) {
                                            t[tP + x | 0] = s[sP + x | 0];
                                        }
                                        sP = sP + sStride | 0;
                                        tP = tP + tStride | 0;
                                    }
                                }
                            }
                            this._solidFillColorPBGRA = null;
                            this._invalidate();
                        };
                        BitmapData.prototype._copyPixelsAndMergeAlpha = function (s, sX, sY, sStride, t, tX, tY, tStride, tW, tH) {
                            var sP = (sY * sStride + sX) | 0;
                            var tP = (tY * tStride + tX) | 0;
                            for (var y = 0; y < tH; y = y + 1 | 0) {
                                for (var x = 0; x < tW; x = x + 1 | 0) {
                                    var spBGRA = s[sP + x | 0];
                                    var sA = spBGRA & 0xff;
                                    // Optimize for the case where the source pixel is fully opaque or transparent. This
                                    // pays off if the source image has many such pixels but slows down the normal case.
                                    if (sA === 0xff) {
                                        t[tP + x | 0] = spBGRA; // Opaque, just copy value over.
                                    }
                                    else if (sA === 0) {
                                    }
                                    else {
                                        // Compute the blending equation: src.rgb + (dst.rgb * (1 - src.a)). The trick here
                                        // is to compute GA and BR at the same time without pulling apart each channel.
                                        // We use the "double blend trick" (http://stereopsis.com/doubleblend.html) to
                                        // compute GA and BR without unpacking them.
                                        var sGA = spBGRA & 0x00ff00ff;
                                        var sBR = spBGRA >> 8 & 0x00ff00ff;
                                        var tpBGRA = t[tP + x | 0];
                                        var tGA = tpBGRA & 0x00ff00ff;
                                        var tBR = tpBGRA >> 8 & 0x00ff00ff;
                                        var A = 256 - sA;
                                        tGA = Math.imul(tGA, A) >> 8;
                                        tBR = Math.imul(tBR, A) >> 8;
                                        // TODO: Not sure if target alpha is computed correctly.
                                        t[tP + x | 0] = ((sBR + tBR & 0x00ff00ff) << 8) | (sGA + tGA & 0x00ff00ff);
                                    }
                                }
                                sP = sP + sStride | 0;
                                tP = tP + tStride | 0;
                            }
                        };
                        BitmapData.prototype.dispose = function () {
                            this._rect.setEmpty();
                            this._view = null;
                            this._invalidate();
                        };
                        BitmapData.prototype.draw = function (source, matrix, colorTransform, blendMode, clipRect, smoothing) {
                            if (matrix === void 0) { matrix = null; }
                            if (colorTransform === void 0) { colorTransform = null; }
                            if (blendMode === void 0) { blendMode = null; }
                            if (clipRect === void 0) { clipRect = null; }
                            if (smoothing === void 0) { smoothing = false; }
                            blendMode = axCoerceString(blendMode);
                            smoothing = !!smoothing;
                            release || somewhatImplemented("public flash.display.BitmapData::draw");
                            var serializer = this.sec.player;
                            if (matrix) {
                                matrix = matrix.clone().toTwipsInPlace();
                            }
                            serializer.drawToBitmap(this, source, matrix, colorTransform, blendMode, clipRect, smoothing);
                            this._isRemoteDirty = true;
                        };
                        BitmapData.prototype.drawWithQuality = function (source, matrix, colorTransform, blendMode, clipRect, smoothing, quality) {
                            if (matrix === void 0) { matrix = null; }
                            if (colorTransform === void 0) { colorTransform = null; }
                            if (blendMode === void 0) { blendMode = null; }
                            if (clipRect === void 0) { clipRect = null; }
                            if (smoothing === void 0) { smoothing = false; }
                            if (quality === void 0) { quality = null; }
                            quality = axCoerceString(quality);
                            release || somewhatImplemented("public flash.display.BitmapData::drawWithQuality");
                            this.draw(source, matrix, colorTransform, blendMode, clipRect, smoothing);
                        };
                        BitmapData.prototype.fillRect = function (rect, uARGB /*uint*/) {
                            this._ensureBitmapData();
                            // TODO: what guarantees this, and why do we even need it?
                            release || assert(this._type === Shumway.ImageType.PremultipliedAlphaARGB);
                            if (this._transparent) {
                                var pARGB = premultiplyARGB(uARGB);
                            }
                            else {
                                var pARGB = uARGB | 0xff000000;
                            }
                            var pBGRA = swap32(pARGB);
                            var r = this._getTemporaryRectangleFrom(this._rect).intersectInPlace(rect);
                            if (r.isEmpty()) {
                                return;
                            }
                            // Filling with the same color?
                            if (this._solidFillColorPBGRA === pBGRA) {
                                return;
                            }
                            var view = this._view;
                            // If we are filling the entire buffer, we can do a little better ~ 25% faster.
                            if (r.equals(this._rect)) {
                                var length = view.length | 0;
                                // Unroll 4 iterations, ~ 5% faster.
                                if ((length & 0x3) === 0) {
                                    for (var i = 0; i < length; i += 4) {
                                        view[i] = pBGRA;
                                        view[i + 1] = pBGRA;
                                        view[i + 2] = pBGRA;
                                        view[i + 3] = pBGRA;
                                    }
                                }
                                else {
                                    for (var i = 0; i < length; i++) {
                                        view[i] = pBGRA;
                                    }
                                }
                                this._solidFillColorPBGRA = pBGRA;
                            }
                            else {
                                var xMin = r.x | 0;
                                var xMax = r.x + r.width | 0;
                                var yMin = r.y | 0;
                                var yMax = r.y + r.height | 0;
                                var width = this._rect.width | 0;
                                for (var y = yMin; y < yMax; y++) {
                                    var offset = y * width | 0;
                                    for (var x = xMin; x < xMax; x++) {
                                        view[offset + x] = pBGRA;
                                    }
                                }
                                this._solidFillColorPBGRA = null;
                            }
                            this._invalidate();
                        };
                        BitmapData.prototype.floodFill = function (x /*int*/, y /*int*/, color /*uint*/) {
                            x = x | 0;
                            y = y | 0;
                            color = color >>> 0;
                            release || somewhatImplemented("public flash.display.BitmapData::floodFill");
                            return;
                        };
                        BitmapData.prototype.generateFilterRect = function (sourceRect, filter) {
                            sourceRect = sourceRect;
                            filter = filter;
                            release || somewhatImplemented("public flash.display.BitmapData::generateFilterRect");
                            return;
                        };
                        BitmapData.prototype.getColorBoundsRect = function (mask /*uint*/, color /*uint*/, findColor) {
                            if (findColor === void 0) { findColor = true; }
                            mask = mask >>> 0;
                            color = color >>> 0;
                            findColor = !!findColor;
                            release || somewhatImplemented("public flash.display.BitmapData::getColorBoundsRect");
                            return new this.sec.flash.geom.Rectangle();
                        };
                        BitmapData.prototype.getPixels = function (rect) {
                            var outputByteArray = new this.sec.flash.utils.ByteArray();
                            this.copyPixelsToByteArray(rect, outputByteArray);
                            return outputByteArray;
                        };
                        BitmapData.prototype.copyPixelsToByteArray = function (rect, data) {
                            var pixelData = this._getPixelData(rect);
                            if (!pixelData) {
                                return;
                            }
                            data.writeRawBytes(new Uint8Array(pixelData));
                        };
                        BitmapData.prototype.getVector = function (rect) {
                            var outputVector = new this.sec.Uint32Vector(pixelData.length);
                            var pixelData = this._getPixelData(rect);
                            if (!pixelData) {
                                return outputVector;
                            }
                            outputVector.length = pixelData.length;
                            outputVector._view().set(pixelData);
                            return outputVector;
                        };
                        BitmapData.prototype.hitTest = function (firstPoint, firstAlphaThreshold /*uint*/, secondObject, secondBitmapDataPoint, secondAlphaThreshold) {
                            if (secondBitmapDataPoint === void 0) { secondBitmapDataPoint = null; }
                            if (secondAlphaThreshold === void 0) { secondAlphaThreshold = 1; }
                            firstPoint = firstPoint;
                            firstAlphaThreshold = firstAlphaThreshold >>> 0;
                            secondObject = secondObject;
                            secondBitmapDataPoint = secondBitmapDataPoint;
                            secondAlphaThreshold = secondAlphaThreshold >>> 0;
                            release || somewhatImplemented("public flash.display.BitmapData::hitTest");
                            return true;
                        };
                        BitmapData.prototype.merge = function (sourceBitmapData, sourceRect, destPoint, redMultiplier /*uint*/, greenMultiplier, blueMultiplier /*uint*/, alphaMultiplier /*uint*/) {
                            sourceBitmapData = sourceBitmapData;
                            sourceRect = sourceRect;
                            destPoint = destPoint;
                            redMultiplier = redMultiplier >>> 0;
                            greenMultiplier = greenMultiplier >>> 0;
                            blueMultiplier = blueMultiplier >>> 0;
                            alphaMultiplier = alphaMultiplier >>> 0;
                            release || somewhatImplemented("public flash.display.BitmapData::merge");
                        };
                        BitmapData.prototype.noise = function (randomSeed /*int*/, low, high, channelOptions, grayScale) {
                            if (low === void 0) { low = 0; }
                            if (high === void 0) { high = 255; }
                            if (channelOptions === void 0) { channelOptions = 7; }
                            if (grayScale === void 0) { grayScale = false; }
                            randomSeed = randomSeed | 0;
                            low = low >>> 0;
                            high = high >>> 0;
                            channelOptions = channelOptions >>> 0;
                            grayScale = !!grayScale;
                            release || somewhatImplemented("public flash.display.BitmapData::noise");
                        };
                        BitmapData.prototype.paletteMap = function (sourceBitmapData, sourceRect, destPoint, redArray, greenArray, blueArray, alphaArray) {
                            if (redArray === void 0) { redArray = null; }
                            if (greenArray === void 0) { greenArray = null; }
                            if (blueArray === void 0) { blueArray = null; }
                            if (alphaArray === void 0) { alphaArray = null; }
                            sourceBitmapData = sourceBitmapData;
                            sourceRect = sourceRect;
                            destPoint = destPoint;
                            redArray = redArray;
                            greenArray = greenArray;
                            blueArray = blueArray;
                            alphaArray = alphaArray;
                            release || somewhatImplemented("public flash.display.BitmapData::paletteMap");
                        };
                        BitmapData.prototype.perlinNoise = function (baseX, baseY, numOctaves /*uint*/, randomSeed, stitch, fractalNoise, channelOptions, grayScale, offsets) {
                            if (channelOptions === void 0) { channelOptions = 7; }
                            if (grayScale === void 0) { grayScale = false; }
                            if (offsets === void 0) { offsets = null; }
                            baseX = +baseX;
                            baseY = +baseY;
                            numOctaves = numOctaves >>> 0;
                            randomSeed = randomSeed | 0;
                            stitch = !!stitch;
                            fractalNoise = !!fractalNoise;
                            channelOptions = channelOptions >>> 0;
                            grayScale = !!grayScale;
                            offsets = offsets;
                            release || somewhatImplemented("public flash.display.BitmapData::perlinNoise");
                        };
                        BitmapData.prototype.pixelDissolve = function (sourceBitmapData, sourceRect, destPoint, randomSeed, numPixels, fillColor) {
                            if (randomSeed === void 0) { randomSeed = 0; }
                            if (numPixels === void 0) { numPixels = 0; }
                            if (fillColor === void 0) { fillColor = 0; }
                            sourceBitmapData = sourceBitmapData;
                            sourceRect = sourceRect;
                            destPoint = destPoint;
                            randomSeed = randomSeed | 0;
                            numPixels = numPixels | 0;
                            fillColor = fillColor >>> 0;
                            release || somewhatImplemented("public flash.display.BitmapData::pixelDissolve");
                            return;
                        };
                        BitmapData.prototype.scroll = function (x /*int*/, y /*int*/) {
                            x = x | 0;
                            y = y | 0;
                            release || somewhatImplemented("public flash.display.BitmapData::scroll");
                            return;
                        };
                        BitmapData.prototype.setPixels = function (rect, inputByteArray) {
                            this._putPixelData(rect, new Int32Array(inputByteArray.readRawBytes()));
                        };
                        BitmapData.prototype.setVector = function (rect, inputVector) {
                            this._putPixelData(rect, inputVector._view());
                        };
                        BitmapData.prototype.threshold = function (sourceBitmapData, sourceRect, destPoint, operation, threshold /*uint*/, color, mask, copySource) {
                            if (color === void 0) { color = 0; }
                            if (mask === void 0) { mask = 4294967295; }
                            if (copySource === void 0) { copySource = false; }
                            sourceBitmapData = sourceBitmapData;
                            sourceRect = sourceRect;
                            destPoint = destPoint;
                            operation = axCoerceString(operation);
                            threshold = threshold >>> 0;
                            color = color >>> 0;
                            mask = mask >>> 0;
                            copySource = !!copySource;
                            release || somewhatImplemented("public flash.display.BitmapData::threshold");
                            return;
                        };
                        BitmapData.prototype.lock = function () {
                            this._locked = true;
                        };
                        BitmapData.prototype.unlock = function (changeRect) {
                            if (changeRect === void 0) { changeRect = null; }
                            //changeRect = changeRect;
                            this._locked = false;
                        };
                        BitmapData.prototype.histogram = function (hRect) {
                            if (hRect === void 0) { hRect = null; }
                            hRect = hRect;
                            release || notImplemented("public flash.display.BitmapData::histogram");
                            return;
                        };
                        BitmapData.prototype.encode = function (rect, compressor, byteArray) {
                            if (byteArray === void 0) { byteArray = null; }
                            rect = rect;
                            compressor = compressor;
                            byteArray = byteArray;
                            release || notImplemented("public flash.display.BitmapData::encode");
                            return;
                        };
                        /**
                         * Ensures that we have the most up-to-date version of the bitmap data. If a call to
                         * |BitmpaData.draw| was made since the last time this method was called, then we need to send
                         * a synchronous message to the GFX remote requesting the latest image data.
                         *
                         * Here we also normalize the image format to |ImageType.StraightAlphaRGBA|. We only need the
                         * normalized pixel data for pixel operations, so we defer image decoding as late as possible.
                         */
                        BitmapData.prototype._ensureBitmapData = function () {
                            if (this._isRemoteDirty) {
                                var data = this.sec.player.requestBitmapData(this);
                                this._setData(data.getBytes(), Shumway.ImageType.StraightAlphaRGBA);
                                this._isRemoteDirty = false;
                                this._isDirty = false;
                                this._solidFillColorPBGRA = null;
                            }
                            release || assert(!(this._type === Shumway.ImageType.JPEG || this._type === Shumway.ImageType.PNG ||
                                this._type === Shumway.ImageType.GIF));
                            if (this._type !== Shumway.ImageType.PremultipliedAlphaARGB) {
                                Shumway.ColorUtilities.convertImage(this._type, Shumway.ImageType.PremultipliedAlphaARGB, this._view, this._view);
                                this._type = Shumway.ImageType.PremultipliedAlphaARGB;
                                this._solidFillColorPBGRA = null;
                            }
                            release || assert(this._data);
                            release || assert(this._dataBuffer);
                            release || assert(this._view);
                        };
                        BitmapData.MAXIMUM_WIDTH = 8191;
                        BitmapData.MAXIMUM_HEIGHT = 8191;
                        BitmapData.MAXIMUM_DIMENSION = 16777215;
                        return BitmapData;
                    })(AS.ASObject);
                    display.BitmapData = BitmapData;
                    var BitmapSymbol = (function (_super) {
                        __extends(BitmapSymbol, _super);
                        function BitmapSymbol(data, sec) {
                            _super.call(this, data, sec.flash.display.BitmapData.axClass, false);
                            this.ready = false;
                        }
                        BitmapSymbol.FromData = function (data, loaderInfo) {
                            var symbol = new BitmapSymbol(data, loaderInfo.sec);
                            // For non-decoded images, we don't yet have dimensions.
                            symbol.width = data.width || -1;
                            symbol.height = data.height || -1;
                            symbol.syncId = loaderInfo.sec.flash.display.DisplayObject.axClass.getNextSyncID();
                            symbol.data = data.data;
                            switch (data.mimeType) {
                                case "application/octet-stream":
                                    symbol.type = data.dataType;
                                    symbol.ready = true;
                                    break;
                                case "image/jpeg":
                                    symbol.type = Shumway.ImageType.JPEG;
                                    break;
                                case "image/png":
                                    symbol.type = Shumway.ImageType.PNG;
                                    break;
                                case "image/gif":
                                    symbol.type = Shumway.ImageType.GIF;
                                    break;
                                default:
                                    notImplemented(data.mimeType);
                            }
                            return symbol;
                        };
                        BitmapSymbol.prototype.getSharedInstance = function () {
                            return this.sharedInstance || this.createSharedInstance();
                        };
                        BitmapSymbol.prototype.createSharedInstance = function () {
                            release || assert(this.ready);
                            return this.sharedInstance = AS.constructClassFromSymbol(this, this.symbolClass);
                        };
                        Object.defineProperty(BitmapSymbol.prototype, "resolveAssetCallback", {
                            get: function () {
                                return this._unboundResolveAssetCallback.bind(this);
                            },
                            enumerable: true,
                            configurable: true
                        });
                        BitmapSymbol.prototype._unboundResolveAssetCallback = function (data) {
                            release || assert(!this.ready);
                            this.ready = true;
                            if (!data) {
                                release || Shumway.Debug.error("Error while decoding image");
                                return;
                            }
                            release || assert(data.width);
                            release || assert(data.height);
                            this.width = data.width;
                            this.height = data.height;
                        };
                        return BitmapSymbol;
                    })(Shumway.Timeline.DisplaySymbol);
                    display.BitmapSymbol = BitmapSymbol;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: BitmapDataChannel
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var BitmapDataChannel = (function (_super) {
                        __extends(BitmapDataChannel, _super);
                        function BitmapDataChannel() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        BitmapDataChannel.classInitializer = null;
                        // List of static symbols to link.
                        BitmapDataChannel.classSymbols = null; // [];
                        // List of instance symbols to link.
                        BitmapDataChannel.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        BitmapDataChannel.RED = 1;
                        BitmapDataChannel.GREEN = 2;
                        BitmapDataChannel.BLUE = 4;
                        BitmapDataChannel.ALPHA = 8;
                        return BitmapDataChannel;
                    })(AS.ASObject);
                    display.BitmapDataChannel = BitmapDataChannel;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: BitmapEncodingColorSpace
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var BitmapEncodingColorSpace = (function (_super) {
                        __extends(BitmapEncodingColorSpace, _super);
                        function BitmapEncodingColorSpace() {
                            _super.call(this);
                        }
                        // Called whenever the class is initialized.
                        BitmapEncodingColorSpace.classInitializer = null;
                        // List of static symbols to link.
                        BitmapEncodingColorSpace.classSymbols = null; // [];
                        // List of instance symbols to link.
                        BitmapEncodingColorSpace.instanceSymbols = null; // [];
                        // JS -> AS Bindings
                        BitmapEncodingColorSpace.COLORSPACE_AUTO = "auto";
                        BitmapEncodingColorSpace.COLORSPACE_4_4_4 = "4:4:4";
                        BitmapEncodingColorSpace.COLORSPACE_4_2_2 = "4:2:2";
                        BitmapEncodingColorSpace.COLORSPACE_4_2_0 = "4:2:0";
                        return BitmapEncodingColorSpace;
                    })(AS.ASObject);
                    display.BitmapEncodingColorSpace = BitmapEncodingColorSpace;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Class: JPEGEncoderOptions
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display) {
                    var JPEGEncoderOptions = (function (_super) {
                        __extends(JPEGEncoderOptions, _super);
                        function JPEGEncoderOptions(quality) {
                            if (quality === void 0) { quality = 80; }
                            _super.call(this);
                            this.quality = quality >>> 0;
                        }
                        // Called whenever the class is initialized.
                        JPEGEncoderOptions.classInitializer = null;
                        // List of static symbols to link.
                        JPEGEncoderOptions.classSymbols = null; // [];
                        // List of instance symbols to link.
                        JPEGEncoderOptions.instanceSymbols = null; // ["quality"];
                        return JPEGEncoderOptions;
                    })(AS.ASObject);
                    display.JPEGEncoderOptions = JPEGEncoderOptions;
                })(display = flash.display || (flash.display = {}));
            })(flash = AS.flash || (AS.flash = {}));
        })(AS = AVMX.AS || (AVMX.AS = {}));
    })(AVMX = Shumway.AVMX || (Shumway.AVMX = {}));
})(Shumway || (Shumway = {}));
/**
 * Copyright 2014 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Shumway;
(function (Shumway) {
    var AVMX;
    (function (AVMX) {
        var AS;
        (function (AS) {
            var flash;
            (function (flash) {
                var display;
                (function (display_1) {
                    var assert = Shumway.Debug.assert;
                    var assertUnreachable = Shumway.Debug.assertUnreachable;
                    var somewhatImplemented = Shumway.Debug.somewhatImplemented;
                    var events = flash.events;
                    var FileLoader = Shumway.FileLoader;
                    var SWFFile = Shumway.SWF.SWFFile;
                    var enterTimeline = Shumway.AVMX.enterTimeline;
                    var leaveTimeline = Shumway.AVMX.leaveTimeline;
                    var LoadStatus;
                    (function (LoadStatus) {
                        LoadStatus[LoadStatus["Unloaded"] = 0] = "Unloaded";
                        LoadStatus[LoadStatus["Opened"] = 1] = "Opened";
                        LoadStatus[LoadStatus["Initialized"] = 2] = "Initialized";
                        LoadStatus[LoadStatus["Complete"] = 3] = "Complete";
                    })(LoadStatus || (LoadStatus = {}));
                    var LoadingType;
                    (function (LoadingType) {
                        LoadingType[LoadingType["External"] = 0] = "External";
                        LoadingType[LoadingType["Bytes"] = 1] = "Bytes";
                    })(LoadingType || (LoadingType = {}));
                    var Loader = (function (_super) {
                        __extends(Loader, _super);
                        function Loader() {
                            _super.call(this);
                            var displayObjectClass = this.sec.flash.display.DisplayObject.axClass;
                            displayObjectClass._advancableInstances.push(this);
                            this._content = null;
                            if (this.axClass._rootLoader) {
                                // Loader reserves the next instance ID to use for the loaded content.
                                // This isn't needed for the first, root, loader, because that uses "root1" as the name.
                                this._contentID = displayObjectClass._instanceID++;
                            }
                            else {
                                // The root loader gets a default name, but it's not visible and hence
                                // the instance id must not be used up.
                                displayObjectClass._instanceID--;
                            }
                            var loaderInfoCtor = this.sec.flash.display.LoaderInfo;
                            this._contentLoaderInfo = new loaderInfoCtor(loaderInfoCtor.axClass.CtorToken);
                            this._contentLoaderInfo._loader = this;
                            var currentAbc = AVMX.getCurrentABC();
                            if (currentAbc) {
                                this._contentLoaderInfo._loaderUrl = currentAbc.env.url;
                            }
                            this._fileLoader = null;
                            this._loadStatus = LoadStatus.Unloaded;
                        }
                        /**
                         * Creates or returns the root Loader instance. The loader property of that instance's
                         * LoaderInfo object is always null. Also, no OPEN event ever gets dispatched.
                         */
                        Loader.getRootLoader = function () {
                            if (this._rootLoader) {
                                return this._rootLoader;
                            }
                            var loader = new this.sec.flash.display.Loader();
                            // The root loaderInfo's `loader` property is always null.
                            loader._contentLoaderInfo._loader = null;
                            this._rootLoader = loader;
                            return loader;
                        };
                        Loader.reset = function () {
                            this.sec.flash.display.Loader.axClass._loadQueue.forEach(function (loader) { return loader.unload(); });
                            Loader.classInitializer();
                        };
                        Loader.classInitializer = function () {
                            this._rootLoader = null;
                            this._loadQueue = [];
                            this.runtimeStartTime = 0;
                            this._embeddedContentLoadCount = 0;
                        };
                        /**
                         * In each turn of the event loop, Loader events are processed in two batches:
                         * first INIT and COMPLETE events are dispatched for all active Loaders, then
                         * OPEN and PROGRESS.
                         *
                         * A slightly weird result of this is that INIT and COMPLETE are dispatched at
                         * least one turn later than the other events: INIT is dispatched after the
                         * content has been created. That, in turn, happens under
                         * `DisplayObject.performFrameNavigation` in reaction to enough data being
                         * marked as available - which happens in the second batch of Loader event
                         * processing.
                         */
                        Loader.processEvents = function () {
                            var loaderClass = this.sec.flash.display.Loader.axClass;
                            loaderClass.processEarlyEvents();
                            loaderClass.processLateEvents();
                        };
                        Loader.processEarlyEvents = function () {
                            var loaderClass = this.sec.flash.display.Loader.axClass;
                            var queue = loaderClass._loadQueue;
                            for (var i = 0; i < queue.length; i++) {
                                var instance = queue[i];
                                release || assert(instance._loadStatus !== LoadStatus.Complete);
                                var loaderInfo = instance._contentLoaderInfo;
                                var imageSymbol = instance._imageSymbol;
                                // For images, only dispatch INIT and COMPLETE once the image has been decoded.
                                if (loaderInfo._file instanceof Shumway.ImageFile) {
                                    if (!imageSymbol || !imageSymbol.ready || instance._queuedLoadUpdate) {
                                        continue;
                                    }
                                    release || assert(loaderInfo.bytesLoaded === loaderInfo.bytesTotal);
                                    instance._applyDecodedImage(imageSymbol);
                                    release || assert(instance._content);
                                }
                                if (instance._loadStatus === LoadStatus.Opened && instance._content) {
                                    enterTimeline("Loader.INIT");
                                    try {
                                        loaderInfo.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.INIT));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under loaderInfo INIT event:', e);
                                    }
                                    leaveTimeline();
                                    instance._loadStatus = LoadStatus.Initialized;
                                    // Only for the root loader, progress events for the data loaded up until now are
                                    // dispatched here.
                                    if (instance === this.sec.flash.display.Loader.axClass._rootLoader) {
                                        enterTimeline("Loader.Progress", 'rootLoader');
                                        try {
                                            loaderInfo.dispatchEvent(new this.sec.flash.events.ProgressEvent(events.ProgressEvent.PROGRESS, false, false, loaderInfo.bytesLoaded, loaderInfo.bytesTotal));
                                        }
                                        catch (e) {
                                            Shumway.Debug.warning('caught error under loaderInfo PROGRESS event:', e);
                                        }
                                        leaveTimeline();
                                    }
                                }
                                if (instance._loadStatus === LoadStatus.Initialized &&
                                    loaderInfo.bytesLoaded === loaderInfo.bytesTotal) {
                                    queue.splice(i--, 1);
                                    release || assert(queue.indexOf(instance) === -1);
                                    instance._loadStatus = LoadStatus.Complete;
                                    enterTimeline("Loader.Complete");
                                    try {
                                        loaderInfo.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.COMPLETE));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under loaderInfo COMPLETE event: ', e);
                                    }
                                    leaveTimeline();
                                }
                            }
                        };
                        Loader.processLateEvents = function () {
                            var queue = this.sec.flash.display.Loader.axClass._loadQueue;
                            for (var i = 0; i < queue.length; i++) {
                                var instance = queue[i];
                                release || assert(instance._loadStatus !== LoadStatus.Complete);
                                var loaderInfo = instance._contentLoaderInfo;
                                var update = instance._queuedLoadUpdate;
                                var bytesTotal = loaderInfo._bytesTotal;
                                if ((!update || !bytesTotal) && instance._loadStatus !== LoadStatus.Opened) {
                                    continue;
                                }
                                instance._queuedLoadUpdate = null;
                                var progressEventCtor = this.sec.flash.events.ProgressEvent;
                                if (instance._loadStatus === LoadStatus.Unloaded) {
                                    // OPEN is only dispatched when loading external resources, not for loadBytes.
                                    if (instance._loadingType === LoadingType.External) {
                                        enterTimeline("Loader.Open");
                                        try {
                                            loaderInfo.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.OPEN));
                                        }
                                        catch (e) {
                                            Shumway.Debug.warning('caught error under loaderInfo OPEN event: ', e);
                                        }
                                        leaveTimeline();
                                    }
                                    // The first time any progress is made at all, a progress event with bytesLoaded = 0
                                    // is dispatched.
                                    enterTimeline("Loader.Progress");
                                    try {
                                        loaderInfo.dispatchEvent(new progressEventCtor(events.ProgressEvent.PROGRESS, false, false, 0, bytesTotal));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under loaderInfo PROGRESS event: ', e);
                                    }
                                    leaveTimeline();
                                    instance._loadStatus = LoadStatus.Opened;
                                }
                                // TODO: The Flash player reports progress in 16kb chunks, in a tight loop right here.
                                if (update) {
                                    instance._applyLoadUpdate(update);
                                    enterTimeline("Loader.Progress");
                                    try {
                                        loaderInfo.dispatchEvent(new progressEventCtor(events.ProgressEvent.PROGRESS, false, false, update.bytesLoaded, bytesTotal));
                                    }
                                    catch (e) {
                                        Shumway.Debug.warning('caught error under loaderInfo PROGRESS event: ', e);
                                    }
                                    leaveTimeline();
                                }
                            }
                        };
                        Loader.prototype._setStage = function (stage) {
                            release || assert(this === this.sec.flash.display.Loader.axClass.getRootLoader());
                            this._stage = stage;
                        };
                        Loader.prototype._initFrame = function (advance) {
                            // ...
                        };
                        Loader.prototype._constructFrame = function () {
                            if (this === this.sec.flash.display.Loader.axClass.getRootLoader() && this._content) {
                                this.sec.flash.display.DisplayObject.axClass._advancableInstances.remove(this);
                                this._children[0] = this._content;
                                this._constructChildren();
                                this._children.length = 0;
                                return;
                            }
                            this._constructChildren();
                        };
                        Loader.prototype.addChild = function (child) {
                            this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidLoaderMethodError);
                            return null;
                        };
                        Loader.prototype.addChildAt = function (child, index) {
                            this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidLoaderMethodError);
                            return null;
                        };
                        Loader.prototype.removeChild = function (child) {
                            this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidLoaderMethodError);
                            return null;
                        };
                        Loader.prototype.removeChildAt = function (index) {
                            this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidLoaderMethodError);
                            return null;
                        };
                        Loader.prototype.setChildIndex = function (child, index) {
                            this.sec.throwError('IllegalOperationError', AVMX.Errors.InvalidLoaderMethodError);
                        };
                        /**
                         * No way of knowing what's in |data|, so do a best effort to print out some meaninfgul debug
                         * info.
                         */
                        Loader.prototype._describeData = function (data) {
                            var keyValueParis = [];
                            for (var k in data) {
                                keyValueParis.push(k + ":" + Shumway.StringUtilities.toSafeString(data[k]));
                            }
                            return "{" + keyValueParis.join(", ") + "}";
                        };
                        Object.defineProperty(Loader.prototype, "content", {
                            get: function () {
                                if (this._loadStatus === LoadStatus.Unloaded) {
                                    return null;
                                }
                                return this._content;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Object.defineProperty(Loader.prototype, "contentLoaderInfo", {
                            get: function () {
                                return this._contentLoaderInfo;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Loader.prototype._getJPEGLoaderContextdeblockingfilter = function (context) {
                            if (this.sec.flash.system.JPEGLoaderContext.axClass.axIsType(context)) {
                                return context.deblockingFilter;
                            }
                            return 0.0;
                        };
                        Object.defineProperty(Loader.prototype, "uncaughtErrorEvents", {
                            get: function () {
                                release || somewhatImplemented("public flash.display.Loader::uncaughtErrorEvents");
                                if (!this._uncaughtErrorEvents) {
                                    this._uncaughtErrorEvents = new events.UncaughtErrorEvents();
                                }
                                return this._uncaughtErrorEvents;
                            },
                            enumerable: true,
                            configurable: true
                        });
                        Loader.prototype._canLoadSWFFromDomain = function (url) {
                            url = Shumway.FileLoadingService.instance.resolveUrl(url);
                            var whitelist = this.sec.player;
                            return whitelist.checkDomainForSWFLoading(url);
                        };
                        Loader.prototype.load = function (request, context) {
                            this.close();
                            // TODO: clean up contentloaderInfo.
                            var resolvedURL = Shumway.FileLoadingService.instance.resolveUrl(request.url);
                            this._contentLoaderInfo._url = resolvedURL;
                            this._applyLoaderContext(context);
                            this._loadingType = LoadingType.External;
                            var fileLoader = this._fileLoader = new FileLoader(this, this._contentLoaderInfo);
                            if (!release && AS.traceLoaderOption.value) {
                                console.log("Loading url " + request.url);
                            }
                            fileLoader.loadFile(request._toFileRequest());
                            this._queuedLoadUpdate = null;
                            var loaderClass = this.sec.flash.display.Loader.axClass;
                            release || assert(loaderClass._loadQueue.indexOf(this) === -1);
                            loaderClass._loadQueue.push(this);
                        };
                        Loader.prototype.loadBytes = function (data, context) {
                            this.close();
                            // TODO: properly coerce object arguments to their types.
                            var loaderClass = this.sec.flash.display.Loader.axClass;
                            // In case this is the initial root loader, we won't have a loaderInfo object. That should
                            // only happen in the inspector when a file is loaded from a Blob, though.
                            this._contentLoaderInfo._url = (this.loaderInfo ? this.loaderInfo._url : '') +
                                '/[[DYNAMIC]]/' + (++loaderClass._embeddedContentLoadCount);
                            this._applyLoaderContext(context);
                            this._loadingType = LoadingType.Bytes;
                            this._fileLoader = new FileLoader(this, this._contentLoaderInfo);
                            this._queuedLoadUpdate = null;
                            if (!release && AS.traceLoaderOption.value) {
                                console.log("Loading embedded symbol " + this._contentLoaderInfo._url);
                            }
                            // Just passing in the bytes won't do, because the buffer can contain slop at the end.
                            this._fileLoader.loadBytes(new Uint8Array(data.bytes, 0, data.length));
                            release || assert(loaderClass._loadQueue.indexOf(this) === -1);
                            loaderClass._loadQueue.push(this);
                        };
                        Loader.prototype.close = function () {
                            var queueIndex = this.sec.flash.display.Loader.axClass._loadQueue.indexOf(this);
                            if (queueIndex > -1) {
                                this.sec.flash.display.Loader.axClass._loadQueue.splice(queueIndex, 1);
                            }
                            this._contentLoaderInfo.reset();
                            if (!this._fileLoader) {
                                return;
                            }
                            this._fileLoader.abortLoad();
                            this._fileLoader = null;
                        };
                        Loader.prototype._unload = function (stopExecution, gc) {
                            if (this._loadStatus < LoadStatus.Initialized) {
                                this._loadStatus = LoadStatus.Unloaded;
                                return;
                            }
                            this.close();
                            this._content = null;
                            this._contentLoaderInfo._loader = null;
                            this._loadStatus = LoadStatus.Unloaded;
                            this.dispatchEvent(this.sec.flash.events.Event.axClass.getInstance(events.Event.UNLOAD));
                        };
                        Loader.prototype.unload = function () {
                            this._unload(false, false);
                        };
                        Loader.prototype.unloadAndStop = function (gc) {
                            // TODO: remove all DisplayObjects originating from the unloaded SWF from all lists and stop
                            // them.
                            this._unload(true, !!gc);
                        };
                        Loader.prototype._applyLoaderContext = function (context) {
                            var parameters = context && context.parameters ?
                                AS.transformASValueToJS(this.sec, context.parameters, false) :
                                {};
                            if (context && context.applicationDomain) {
                                this._contentLoaderInfo._applicationDomain = context.applicationDomain;
                            }
                            else if (this._loaderInfo && this._loaderInfo._applicationDomain) {
                                this._contentLoaderInfo._applicationDomain = this._loaderInfo._applicationDomain;
                            }
                            else {
                                this._contentLoaderInfo._applicationDomain = new this.sec.flash.system.ApplicationDomain();
                            }
                            this._contentLoaderInfo._parameters = parameters;
                            this._contentLoaderInfo._allowCodeImport = context ? context.allowCodeImport : true;
                            this._contentLoaderInfo._checkPolicyFile = context ? context.checkPolicyFile : false;
                            this._contentLoaderInfo._avm1Context = context ? context._avm1Context : null;
                        };
                        Loader.prototype.onLoadOpen = function (file) {
                            if (!file) {
                                this._contentLoaderInfo.dispatchEvent(new this.sec.flash.events.IOErrorEvent(events.IOErrorEvent.IO_ERROR, false, false, AVMX.Errors.UnknownFileTypeError.message, AVMX.Errors.UnknownFileTypeError.code));
                                return;
                            }
                            // For child SWF files, only continue loading and interpreting the loaded data if the
                            // either
                            // - it is loaded from the same origin as the parent, or
                            // - the parent has called `system.Security.allowDomain` with the loadees origin whitelisted
                            // This is a mitigation against the loadee breaking our SecurityDomain sandbox and
                            // reaching into the parent's SecurityDomain, reading data it's not supposed to have
                            // access to.
                            //
                            // We perform this check only once loading has started for two reasons: one is that only
                            // at that point do we know that we're loading a SWF instead of an image (or some invalid
                            // file, in which case none of this matters). The other is that the parent might call
                            // `allowDomain` only after the load has started, in which case we still want to allow the
                            // operation to continue.
                            //
                            // Additionally, all the normal cross-domain checks apply as per usual.
                            if (file._file instanceof SWFFile) {
                                var whitelistResult = this._canLoadSWFFromDomain(this._fileLoader._url);
                                var resultType;
                                switch (whitelistResult) {
                                    case 0 /* OwnDomain */:
                                        resultType = 0 /* LoadSource */;
                                        break;
                                    case 1 /* Remote */:
                                        resultType = 1 /* LoadWhitelistAllowed */;
                                        break;
                                    case 2 /* Failed */:
                                        resultType = 2 /* LoadWhitelistDenied */;
                                        break;
                                    default:
                                        assertUnreachable("Invalid whitelistResult");
                                }
                                Shumway.Telemetry.instance.reportTelemetry({ topic: 'loadResource', resultType: resultType });
                                if (whitelistResult === 2 /* Failed */) {
                                    console.error('Loading of SWF file from ' + this._fileLoader._url +
                                        ' was rejected based on allowDomain heuristic.');
                                    this._fileLoader.abortLoad();
                                    var message = "Security sandbox violation: SWF " + this._loaderInfo._url +
                                        " cannot load SWF " + this._fileLoader._url + ". This may be worked" +
                                        " around by calling Security.allowDomain.";
                                    try {
                                        this._contentLoaderInfo.dispatchEvent(new this.sec.flash.events.IOErrorEvent(events.SecurityErrorEvent.SECURITY_ERROR, false, false, message, AVMX.Errors.SecuritySwfNotAllowedError.code));
                                    }
                                    catch (_) {
                                    }
                                    return;
                                }
                                if (!this._contentLoaderInfo._allowCodeImport) {
                                    this._fileLoader.abortLoad();
                                    try {
                                        this._contentLoaderInfo.dispatchEvent(new this.sec.flash.events.IOErrorEvent(events.SecurityErrorEvent.SECURITY_ERROR, false, false, AVMX.Errors.AllowCodeImportError.message, AVMX.Errors.AllowCodeImportError.code));
                                    }
                                    catch (_) {
                                    }
                                    return;
                                }
                            }
                            this._contentLoaderInfo.setFile(file);
                        };
                        Loader.prototype.onLoadProgress = function (update) {
                            release || assert(update);
                            this._queuedLoadUpdate = update;
                        };
                        Loader.prototype.onNewEagerlyParsedSymbols = function (dictionaryEntries, delta) {
                            var promises = [];
                            for (var i = dictionaryEntries.length - delta; i < dictionaryEntries.length; i++) {
                                var dictionaryEntry = dictionaryEntries[i];
                                var symbol = this._contentLoaderInfo.getSymbolById(dictionaryEntry.id);
                                // JPEGs with alpha channel are parsed with our JS parser for now. They're ready
                                // immediately, so don't need any more work here. We'll change them to using the system
                                // parser, but for now, just skip further processing here.
                                if (symbol.ready) {
                                    continue;
                                }
                                release || assert(symbol.resolveAssetPromise);
                                release || assert(symbol.ready === false);
                                promises.push(symbol.resolveAssetPromise.promise);
                            }
                            return Promise.all(promises);
                        };
                        Loader.prototype.onImageBytesLoaded = function () {
                            var file = this._contentLoaderInfo._file;
                            release || assert(file instanceof Shumway.ImageFile);
                            var data = {
                                id: -1,
                                data: file.data,
                                mimeType: file.mimeType,
                                dataType: file.type,
                                type: 'image'
                            };
                            var symbol = display_1.BitmapSymbol.FromData(data, this._contentLoaderInfo);
                            this._imageSymbol = symbol;
                            this.sec.player.registerImage(symbol, file.type, file.data, null);
                            release || assert(symbol.resolveAssetPromise);
                        };
                        Loader.prototype._applyDecodedImage = function (symbol) {
                            var bitmapData = symbol.createSharedInstance();
                            this._content = new this.sec.flash.display.Bitmap(bitmapData);
                            this._contentLoaderInfo._width = this._content.width * 20;
                            this._contentLoaderInfo._height = this._content.height * 20;
                            this.addTimelineObjectAtDepth(this._content, 0);
                        };
                        Loader.prototype._applyLoadUpdate = function (update) {
                            var loaderInfo = this._contentLoaderInfo;
                            loaderInfo._bytesLoaded = update.bytesLoaded;
                            var file = loaderInfo._file;
                            if (!(file instanceof SWFFile)) {
                                return;
                            }
                            if (file.framesLoaded === 0) {
                                return;
                            }
                            if (loaderInfo._allowCodeExecution) {
                                var app = loaderInfo.app;
                                var abcBlocksLoaded = file.abcBlocks.length;
                                var abcBlocksLoadedDelta = abcBlocksLoaded - loaderInfo._abcBlocksLoaded;
                                if (abcBlocksLoadedDelta > 0) {
                                    for (var i = loaderInfo._abcBlocksLoaded; i < abcBlocksLoaded; i++) {
                                        var abcBlock = file.abcBlocks[i];
                                        var abc = new AVMX.ABCFile(loaderInfo, abcBlock.data);
                                        if (abcBlock.flags) {
                                            // kDoAbcLazyInitializeFlag = 1 Indicates that the ABC block should not be executed
                                            // immediately.
                                            app.loadABC(abc);
                                        }
                                        else {
                                            // TODO: probably delay execution until playhead reaches the frame.
                                            app.loadAndExecuteABC(abc);
                                        }
                                    }
                                    loaderInfo._abcBlocksLoaded = abcBlocksLoaded;
                                }
                                var mappedSymbolsLoaded = file.symbolClassesList.length;
                                var mappedSymbolsLoadedDelta = mappedSymbolsLoaded - loaderInfo._mappedSymbolsLoaded;
                                if (mappedSymbolsLoadedDelta > 0) {
                                    for (var i = loaderInfo._mappedSymbolsLoaded; i < mappedSymbolsLoaded; i++) {
                                        var symbolMapping = file.symbolClassesList[i];
                                        var symbolClass = app.getClass(AVMX.Multiname.FromFQNString(symbolMapping.className, 0 /* Public */));
                                        Object.defineProperty(symbolClass.tPrototype, "_symbol", { get: loaderInfo.getSymbolResolver(symbolClass, symbolMapping.id),
                                            configurable: true });
                                    }
                                    loaderInfo._mappedSymbolsLoaded = mappedSymbolsLoaded;
                                }
                            }
                            // In browsers that can't synchronously decode fonts, we have already registered all
                            // embedded fonts at this point.
                            if (inFirefox) {
                                var fontsLoaded = file.fonts.length;
                                var fontsLoadedDelta = fontsLoaded - loaderInfo._fontsLoaded;
                                if (fontsLoadedDelta > 0) {
                                    for (var i = loaderInfo._fontsLoaded; i < fontsLoaded; i++) {
                                        this.sec.flash.text.Font.axClass.registerFontSymbol(file.fonts[i], loaderInfo);
                                    }
                                    loaderInfo._fontsLoaded = fontsLoaded;
                                }
                            }
                            var rootSymbol = loaderInfo.getRootSymbol();
                            var framesLoadedDelta = file.framesLoaded - rootSymbol.frames.length;
                            if (framesLoadedDelta === 0) {
                                return;
                            }
                            var root = this._content;
                            if (!root) {
                                root = this.createContentRoot(rootSymbol, file.sceneAndFrameLabelData);
                            }
                            var rootSprite = root;
                            for (var i = 0; i < framesLoadedDelta; i++) {
                                var frameInfo = loaderInfo.getFrame(null, rootSymbol.frames.length);
                                rootSprite._addFrame(frameInfo);
                            }
                        };
                        Loader.prototype.onLoadComplete = function () {
                            // Go away, tslint.
                        };
                        Loader.prototype.onLoadError = function () {
                            release || Shumway.Debug.warning('Not implemented: flash.display.Loader loading-error handling');
                        };
                        Loader.prototype._addScenesToMovieClip = function (mc, sceneData, numFrames) {
                            // Creating scenes so we will always have frames assigned to some scene.
                            if (!sceneData) {
                                mc.addScene('Scene 1', [], 0, numFrames);
                                return;
                            }
                            // Sorting scenes by offset
                            var sceneInfos = [];
                            var scenes = sceneData.scenes;
                            for (var i = 0; i < scenes.length; i++) {
                                sceneInfos.push({ offset: scenes[i].offset, name: scenes[i].name });
                            }
                            sceneInfos.sort(function (a, b) { return a.offset - b.offset; });
                            var n = sceneInfos.length;
                            var offset, endFrame;
                            if (n > 0 && sceneInfos[0].offset > 0) {
                                // Starting from non-zero frame, we need to create a fake scene.
                                offset = sceneInfos[0].offset;
                                endFrame = Math.min(offset, numFrames);
                                mc.addScene('Scene 0', [], 0, endFrame);
                            }
                            for (var i = 0, n = sceneInfos.length; i < n; i++) {
                                var sceneInfo = sceneInfos[i];
                                offset = sceneInfo.offset;
                                if (offset >= numFrames) {
                                    break; // out of the movie clip timeline range
                                }
                                endFrame = i < n - 1 ? Math.min(scenes[i + 1].offset, numFrames) : numFrames;
                                mc.addScene(sceneInfo.name, [], offset, endFrame - offset);
                            }
                            var labels = sceneData.labels;
                            for (var i = 0; i < labels.length; i++) {
                                var labelInfo = labels[i];
                                mc.addFrameLabel(labelInfo.name, labelInfo.frame + 1);
                            }
                        };
                        Loader.prototype.createContentRoot = function (symbol, sceneData) {
                            var isAS2LoadedFromAS3 = false;
                            if (symbol.isAVM1Object && !this._contentLoaderInfo._avm1Context) {
                                // For outermost AVM1 SWF we need to create AVM1Context.
                                isAS2LoadedFromAS3 = true;
                                this._createAVM1Context();
                                // Re-sync the AVM1Context for the symbol.
                                symbol.avm1Context = this._contentLoaderInfo._avm1Context;
                            }
                            var root = AS.constructClassFromSymbol(symbol, symbol.symbolClass);
                            // The initial SWF's root object gets a default of 'root1', which doesn't use up a
                            // DisplayObject instance ID. For the others, we have reserved one in `_contentID`.
                            this.sec.flash.display.DisplayObject.axClass._instanceID--;
                            var loaderClass = this.sec.flash.display.Loader.axClass;
                            if (this === loaderClass._rootLoader) {
                                root._name = 'root1';
                            }
                            else {
                                root._name = 'instance' + this._contentID;
                            }
                            if (this.sec.flash.display.MovieClip.axClass.axIsType(root)) {
                                this._addScenesToMovieClip(root, sceneData, symbol.numFrames);
                            }
                            var loaderInfo = this._contentLoaderInfo;
                            root._loaderInfo = loaderInfo;
                            var rootTimeline = root;
                            var isTopLevelMovie = this === loaderClass.getRootLoader();
                            if (isAS2LoadedFromAS3) {
                                root = this._createAVM1Movie(root);
                            }
                            else if (isTopLevelMovie) {
                                var movieClipClass = this.sec.flash.display.MovieClip.axClass;
                                movieClipClass.frameNavigationModel = loaderInfo.swfVersion < 10 ?
                                    9 /* SWF9 */ :
                                    10 /* SWF10 */;
                                root._perspectiveProjectionCenterX = this._stage.stageWidth / 2;
                                root._perspectiveProjectionCenterY = this._stage.stageHeight / 2;
                                root._setFlags(262144 /* HasPerspectiveProjection */);
                            }
                            this._content = root;
                            if (isTopLevelMovie) {
                                this.sec.flash.display.Loader.runtimeStartTime = Date.now();
                                this._stage.setRoot(root);
                            }
                            else {
                                this.addTimelineObjectAtDepth(root, 0);
                            }
                            // Always return the non-wrapped MovieClip instead of AVM1Movie for AVM1 SWFs.
                            return rootTimeline;
                        };
                        Loader.prototype._createAVM1Context = function () {
                            var contentLoaderInfo = this._contentLoaderInfo;
                            var avm1Context = Shumway.AVM1.AVM1Context.create(contentLoaderInfo);
                            var display = this.sec.flash.display;
                            var rootLoader = display.Loader.axClass.getRootLoader();
                            avm1Context.setStage(rootLoader._stage);
                            // FIXME make frameNavigationModel non-global
                            if (this === rootLoader) {
                                display.MovieClip.axClass.frameNavigationModel = 1 /* SWF1 */;
                            }
                            contentLoaderInfo._avm1Context = avm1Context;
                        };
                   