var RELOOPER_BUFFER_SIZE = 1024 * 1024;
// Relooper, (C) 2012 Alon Zakai, MIT license, https://github.com/kripken/Relooper
var Relooper = (function(Module) {
var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function";var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}))}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}this["Module"]=Module}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WEB){window["Module"]=Module}else{Module["load"]=importScripts}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){assert(args.length==sig.length-1);if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);assert("dynCall_"+sig in Module,"bad function pointer type - no table for sig '"+sig+"'");return Module["dynCall_"+sig].apply(null,args)}else{assert(sig.length==1);assert("dynCall_"+sig in Module,"bad function pointer type - no table for sig '"+sig+"'");return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),getAsmConst:(function(code,numArgs){if(!Runtime.asmConstCache)Runtime.asmConstCache={};var func=Runtime.asmConstCache[code];if(func)return func;var args=[];for(var i=0;i<numArgs;i++){args.push(String.fromCharCode(36)+i)}var source=Pointer_stringify(code);if(source[0]==='"'){if(source.indexOf('"',1)===source.length-1){source=source.substr(1,source.length-2)}else{abort("invalid EM_ASM input |"+source+"|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")}}try{var evalled=eval("(function(Module, FS) { return function("+args.join(",")+"){ "+source+" } })")(Module,typeof FS!=="undefined"?FS:null)}catch(e){Module.printErr("error in executing inline EM_ASM code: "+e+" on: \n\n"+source+"\n\nwith args |"+args+"| (make sure to use the right one out of EM_ASM, EM_ASM_ARGS, etc.)");throw e}return Runtime.asmConstCache[code]=evalled}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),UTF8Processor:(function(){var buffer=[];var needed=0;this.processCChar=(function(code){code=code&255;if(buffer.length==0){if((code&128)==0){return String.fromCharCode(code)}buffer.push(code);if((code&224)==192){needed=1}else if((code&240)==224){needed=2}else{needed=3}return""}if(needed){buffer.push(code);needed--;if(needed>0)return""}var c1=buffer[0];var c2=buffer[1];var c3=buffer[2];var c4=buffer[3];var ret;if(buffer.length==2){ret=String.fromCharCode((c1&31)<<6|c2&63)}else if(buffer.length==3){ret=String.fromCharCode((c1&15)<<12|(c2&63)<<6|c3&63)}else{var codePoint=(c1&7)<<18|(c2&63)<<12|(c3&63)<<6|c4&63;ret=String.fromCharCode(((codePoint-65536)/1024|0)+55296,(codePoint-65536)%1024+56320)}buffer.length=0;return ret});this.processJSString=function processJSString(string){string=unescape(encodeURIComponent(string));var ret=[];for(var i=0;i<string.length;i++){ret.push(string.charCodeAt(i))}return ret}}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;assert((STACKTOP|0)<(STACK_MAX|0)|0)|0;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+(assert(!staticSealed),size)|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+(assert(DYNAMICTOP>0),size)|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY)enlargeMemory();return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args){var func=getCFunc(ident);var cArgs=[];var stack=0;assert(returnType!=="array",'Return type should not be "array".');if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0)Runtime.stackRestore(stack);return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["cwrap"]=cwrap;Module["ccall"]=ccall;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}assert(type,"Must know what type to store in allocate!");if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=false;var t;var i=0;while(1){assert(ptr+i<TOTAL_MEMORY);t=HEAPU8[ptr+i>>0];if(t>=128)hasUtf=true;else if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(!hasUtf){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}var utf8=new Runtime.UTF8Processor;for(i=0;i<length;i++){assert(ptr+i<TOTAL_MEMORY);t=HEAPU8[ptr+i>>0];ret+=utf8.processCChar(t)}return ret}Module["Pointer_stringify"]=Pointer_stringify;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr){for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr+i*2>>1]=codeUnit}HEAP16[outPtr+str.length*2>>1]=0}Module["stringToUTF16"]=stringToUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr){var iChar=0;for(var iCodeUnit=0;iCodeUnit<str.length;++iCodeUnit){var codeUnit=str.charCodeAt(iCodeUnit);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++iCodeUnit);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr+iChar*4>>2]=codeUnit;++iChar}HEAP32[outPtr+iChar*4>>2]=0}Module["stringToUTF32"]=stringToUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){return x+4095&-4096}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value "+TOTAL_MEMORY+", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")}var TOTAL_STACK=Module["TOTAL_STACK"]||131072;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||4194304;var FAST_MEMORY=Module["FAST_MEMORY"]||2097152;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be compliant with the asm.js spec");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=Module.addOnPreRun=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=Module.addOnInit=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=Module.addOnPreMain=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=Module.addOnExit=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=Module.addOnPostRun=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var ret=(new Runtime.UTF8Processor).processJSString(stringy);if(length){ret.length=length}if(!dontAddNull){ret.push(0)}return ret}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.");chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer+i>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;i++){assert(str.charCodeAt(i)===str.charCodeAt(i)&255);HEAP8[buffer+i>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer+str.length>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;var runDependencyTracking={};function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(id){assert(!runDependencyTracking[id]);runDependencyTracking[id]=1;if(runDependencyWatcher===null&&typeof setInterval!=="undefined"){runDependencyWatcher=setInterval((function(){if(ABORT){clearInterval(runDependencyWatcher);runDependencyWatcher=null;return}var shown=false;for(var dep in runDependencyTracking){if(!shown){shown=true;Module.printErr("still waiting on run dependencies:")}Module.printErr("dependency: "+dep)}if(shown){Module.printErr("(end of list)")}}),1e4)}}else{Module.printErr("warning: run dependency added without ID")}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(id){assert(runDependencyTracking[id]);delete runDependencyTracking[id]}else{Module.printErr("warning: run dependency removed without ID")}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;STATIC_BASE=8;STATICTOP=STATIC_BASE+3376;__ATINIT__.push({func:(function(){__GLOBAL__I_a()})});allocate([1,0,0,0,0,0,0,0,37,115,10,0,0,0,0,0,108,97,98,101,108,32,61,32,37,100,59,10,0,0,0,0,37,115,32,76,37,100,59,10,0,0,0,0,0,0,0,0,98,114,101,97,107,0,0,0,99,111,110,116,105,110,117,101,0,0,0,0,0,0,0,0,37,115,59,10,0,0,0,0,33,99,111,110,116,97,105,110,115,40,66,114,97,110,99,104,101,115,79,117,116,44,32,84,97,114,103,101,116,41,0,0,82,101,108,111,111,112,101,114,46,99,112,112,0,0,0,0,65,100,100,66,114,97,110,99,104,84,111,0,0,0,0,0,108,97,98,101,108,32,61,32,48,59,10,0,0,0,0,0,33,68,101,102,97,117,108,116,84,97,114,103,101,116,0,0,82,101,110,100,101,114,0,0,68,101,102,97,117,108,116,84,97,114,103,101,116,0,0,0,115,119,105,116,99,104,32,40,37,115,41,32,123,10,0,0,68,101,116,97,105,108,115,45,62,67,111,110,100,105,116,105,111,110,0,0,0,0,0,0,37,115,32,123,10,0,0,0,37,115,105,102,32,40,37,115,41,32,123,10,0,0,0,0,0,0,0,0,0,0,0,0,125,32,101,108,115,101,32,0,32,38,38,32,0,0,0,0,33,40,0,0,0,0,0,0,32,61,61,32,0,0,0,0,41,0,0,0,0,0,0,0,100,101,102,97,117,108,116,58,32,123,10,0,0,0,0,0,105,102,32,40,37,115,41,32,123,10,0,0,0,0,0,0,125,32,101,108,115,101,32,105,102,32,40,37,115,41,32,123,10,0,0,0,0,0,0,0,125,32,101,108,115,101,32,123,10,0,0,0,0,0,0,0,80,97,114,101,110,116,45,62,78,101,120,116,0,0,0,0,98,114,101,97,107,59,10,0,125,10,0,0,0,0,0,0,76,37,100,58,32,0,0,0,76,37,100,58,32,100,111,32,123,10,0,0,0,0,0,0,100,111,32,123,10,0,0,0,125,32,119,104,105,108,101,40,48,41,59,10,0,0,0,0,0,0,0,0,0,0,0,0,37,115,105,102,32,40,40,108,97,98,101,108,124,48,41,32,61,61,32,37,100,41,32,123,10,0,0,0,0,0,0,0,101,108,115,101,32,0,0,0,37,115,105,102,32,40,108,97,98,101,108,32,61,61,32,37,100,41,32,123,10,0,0,0,115,119,105,116,99,104,32,40,108,97,98,101,108,124,48,41,32,123,10,0,0,0,0,0,115,119,105,116,99,104,32,40,108,97,98,101,108,41,32,123,10,0,0,0,0,0,0,0,99,97,115,101,32,37,100,58,32,123,10,0,0,0,0,0,76,37,100,58,32,119,104,105,108,101,40,49,41,32,123,10,0,0,0,0,0,0,0,0,119,104,105,108,101,40,49,41,32,123,10,0,0,0,0,0,115,119,105,116,99,104,40,108,97,98,101,108,124,48,41,32,123,10,0,0,0,0,0,0,82,111,111,116,0,0,0,0,67,97,108,99,117,108,97,116,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,3,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,49,51,77,117,108,116,105,112,108,101,83,104,97,112,101,0,49,50,76,97,98,101,108,101,100,83,104,97,112,101,0,0,53,83,104,97,112,101,0,0,24,8,0,0,32,3,0,0,64,8,0,0,16,3,0,0,40,3,0,0,0,0,0,0,64,8,0,0,0,3,0,0,48,3,0,0,0,0,0,0,0,0,0,0,120,3,0,0,3,0,0,0,4,0,0,0,2,0,0,0,0,0,0,0,57,76,111,111,112,83,104,97,112,101,0,0,0,0,0,0,64,8,0,0,104,3,0,0,48,3,0,0,0,0,0,0,0,0,0,0,176,3,0,0,5,0,0,0,6,0,0,0,3,0,0,0,0,0,0,0,49,51,69,109,117,108,97,116,101,100,83,104,97,112,101,0,64,8,0,0,160,3,0,0,48,3,0,0,0,0,0,0,76,111,111,112,83,116,97,99,107,46,115,105,122,101,40,41,32,62,32,48,0,0,0,0,70,105,110,100,76,97,98,101,108,101,100,76,111,111,112,115,0,0,0,0,0,0,0,0,68,101,116,97,105,108,115,45,62,84,121,112,101,32,61,61,32,66,114,97,110,99,104,58,58,68,105,114,101,99,116,0,82,101,109,111,118,101,85,110,110,101,101,100,101,100,70,108,111,119,115,0,0,0,0,0,73,110,110,101,114,66,108,111,99,107,115,46,115,105,122,101,40,41,32,62,32,48,0,0,77,97,107,101,76,111,111,112,0,0,0,0,0,0,0,0,0,0,0,0,120,4,0,0,7,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,49,49,83,105,109,112,108,101,83,104,97,112,101,0,0,0,64,8,0,0,104,4,0,0,40,3,0,0,0,0,0,0,79,117,116,112,117,116,66,117,102,102,101,114,0,0,0,0,80,117,116,73,110,100,101,110,116,101,100,0,0,0,0,0,78,101,101,100,101,100,32,60,32,76,101,102,116,0,0,0,69,110,115,117,114,101,79,117,116,112,117,116,66,117,102,102,101,114,0,0,0,0,0,0,80,114,105,110,116,73,110,100,101,110,116,101,100,0,0,0,1,0,0,0,0,0,0,0,240,4,0,0,0,0,0,0,117,110,99,97,117,103,104,116,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,0,0,116,101,114,109,105,110,97,116,105,110,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,0,136,6,0,0,9,0,0,0,10,0,0,0,1,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,64,8,0,0,120,6,0,0,16,7,0,0,0,0,0,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,116,104,114,101,119,32,97,110,32,101,120,99,101,112,116,105,111,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,24,8,0,0,0,7,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,24,8,0,0,24,7,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,64,8,0,0,48,7,0,0,40,7,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,64,8,0,0,104,7,0,0,88,7,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,64,8,0,0,200,7,0,0,88,7,0,0,0,0,0,0,64,8,0,0,160,7,0,0,240,7,0,0,0,0,0,0,0,0,0,0,144,7,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,136,8,0,0,11,0,0,0,15,0,0,0,13,0,0,0,14,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,64,8,0,0,96,8,0,0,144,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,45,43,32,32,32,48,88,48,120,0,0,0,0,0,0,0,40,110,117,108,108,41,0,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,0,0,0,0,0,105,110,102,0,0,0,0,0,73,78,70,0,0,0,0,0,110,97,110,0,0,0,0,0,78,65,78,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_i64Subtract"]=_i64Subtract;function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;var _BDtoILow=true;var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var ___errno_state=0;function ___setErrNo(value){HEAP32[___errno_state>>2]=value;return value}function _strerror_r(errnum,strerrbuf,buflen){if(errnum in ERRNO_MESSAGES){if(ERRNO_MESSAGES[errnum].length>buflen-1){return ___setErrNo(ERRNO_CODES.ERANGE)}else{var msg=ERRNO_MESSAGES[errnum];writeAsciiToMemory(msg,strerrbuf);return 0}}else{return ___setErrNo(ERRNO_CODES.EINVAL)}}function _strerror(errnum){if(!_strerror.buffer)_strerror.buffer=_malloc(256);_strerror_r(errnum,_strerror.buffer,256);return _strerror.buffer}Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}Module["_strlen"]=_strlen;var FS=undefined;var SOCKFS=undefined;function _send(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _write(fd,buf,len)}function _pwrite(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _write(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fileno(stream){stream=FS.getStreamFromPtr(stream);if(!stream)return-1;return stream.fd}function _fputc(c,stream){var chr=unSign(c&255);HEAP8[_fputc.ret>>0]=chr;var fd=_fileno(stream);var ret=_write(fd,_fputc.ret,1);if(ret==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return-1}else{return chr}}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 79:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function _fputs(s,stream){var fd=_fileno(stream);return _write(fd,s,_strlen(s))}var _stdout=allocate(1,"i32*",ALLOC_STATIC);function _puts(s){var result=Pointer_stringify(s);var string=result.substr(0);if(string[string.length-1]==="\n")string=string.substr(0,string.length-1);Module.print(string);return result.length}var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}Module["_i64Add"]=_i64Add;Module["_bitshift64Lshr"]=_bitshift64Lshr;var _BDtoIHigh=true;function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var fd=_fileno(stream);var bytesWritten=_write(fd,ptr,bytesToWrite);if(bytesWritten==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return 0}else{return bytesWritten/size|0}}function __reallyNegative(x){return x<0||x===0&&1/x===-Infinity}function __formatString(format,varargs){var textIndex=format;var argIndex=0;function getNextArg(type){var ret;if(type==="double"){ret=(HEAP32[tempDoublePtr>>2]=HEAP32[varargs+argIndex>>2],HEAP32[tempDoublePtr+4>>2]=HEAP32[varargs+(argIndex+4)>>2],+HEAPF64[tempDoublePtr>>3])}else if(type=="i64"){ret=[HEAP32[varargs+argIndex>>2],HEAP32[varargs+(argIndex+4)>>2]]}else{type="i32";ret=HEAP32[varargs+argIndex>>2]}argIndex+=Runtime.getNativeFieldSize(type);return ret}var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[textIndex>>0];if(curr===0)break;next=HEAP8[textIndex+1>>0];if(curr==37){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;var flagPadSign=false;flagsLoop:while(1){switch(next){case 43:flagAlwaysSigned=true;break;case 45:flagLeftAlign=true;break;case 35:flagAlternative=true;break;case 48:if(flagZeroPad){break flagsLoop}else{flagZeroPad=true;break};case 32:flagPadSign=true;break;default:break flagsLoop}textIndex++;next=HEAP8[textIndex+1>>0]}var width=0;if(next==42){width=getNextArg("i32");textIndex++;next=HEAP8[textIndex+1>>0]}else{while(next>=48&&next<=57){width=width*10+(next-48);textIndex++;next=HEAP8[textIndex+1>>0]}}var precisionSet=false,precision=-1;if(next==46){precision=0;precisionSet=true;textIndex++;next=HEAP8[textIndex+1>>0];if(next==42){precision=getNextArg("i32");textIndex++}else{while(1){var precisionChr=HEAP8[textIndex+1>>0];if(precisionChr<48||precisionChr>57)break;precision=precision*10+(precisionChr-48);textIndex++}}next=HEAP8[textIndex+1>>0]}if(precision<0){precision=6;precisionSet=false}var argSize;switch(String.fromCharCode(next)){case"h":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==104){textIndex++;argSize=1}else{argSize=2}break;case"l":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==108){textIndex++;argSize=8}else{argSize=4}break;case"L":case"q":case"j":argSize=8;break;case"z":case"t":case"I":argSize=4;break;default:argSize=null}if(argSize)textIndex++;next=HEAP8[textIndex+1>>0];switch(String.fromCharCode(next)){case"d":case"i":case"u":case"o":case"x":case"X":case"p":{var signed=next==100||next==105;argSize=argSize||4;var currArg=getNextArg("i"+argSize*8);var origArg=currArg;var argText;if(argSize==8){currArg=Runtime.makeBigInt(currArg[0],currArg[1],next==117)}if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8)}var currAbsArg=Math.abs(currArg);var prefix="";if(next==100||next==105){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],null);else argText=reSign(currArg,8*argSize,1).toString(10)}else if(next==117){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],true);else argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg)}else if(next==111){argText=(flagAlternative?"0":"")+currAbsArg.toString(8)}else if(next==120||next==88){prefix=flagAlternative&&currArg!=0?"0x":"";if(argSize==8&&i64Math){if(origArg[1]){argText=(origArg[1]>>>0).toString(16);var lower=(origArg[0]>>>0).toString(16);while(lower.length<8)lower="0"+lower;argText+=lower}else{argText=(origArg[0]>>>0).toString(16)}}else if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((15-parseInt(argText[i],16)).toString(16))}argText=buffer.join("");while(argText.length<argSize*2)argText="f"+argText}else{argText=currAbsArg.toString(16)}if(next==88){prefix=prefix.toUpperCase();argText=argText.toUpperCase()}}else if(next==112){if(currAbsArg===0){argText="(nil)"}else{prefix="0x";argText=currAbsArg.toString(16)}}if(precisionSet){while(argText.length<precision){argText="0"+argText}}if(currArg>=0){if(flagAlwaysSigned){prefix="+"+prefix}else if(flagPadSign){prefix=" "+prefix}}if(argText.charAt(0)=="-"){prefix="-"+prefix;argText=argText.substr(1)}while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad){argText="0"+argText}else{prefix=" "+prefix}}}argText=prefix+argText;argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"f":case"F":case"e":case"E":case"g":case"G":{var currArg=getNextArg("double");var argText;if(isNaN(currArg)){argText="nan";flagZeroPad=false}else if(!isFinite(currArg)){argText=(currArg<0?"-":"")+"inf";flagZeroPad=false}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next==103||next==71){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split("e")[1],10);if(precision>exponent&&exponent>=-4){next=(next==103?"f":"F").charCodeAt(0);precision-=exponent+1}else{next=(next==103?"e":"E").charCodeAt(0);precision--}effectivePrecision=Math.min(precision,20)}if(next==101||next==69){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+"0"+argText.slice(-1)}}else if(next==102||next==70){argText=currArg.toFixed(effectivePrecision);if(currArg===0&&__reallyNegative(currArg)){argText="-"+argText}}var parts=argText.split("e");if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf(".")!=-1&&(parts[0].slice(-1)=="0"||parts[0].slice(-1)==".")){parts[0]=parts[0].slice(0,-1)}}else{if(flagAlternative&&argText.indexOf(".")==-1)parts[0]+=".";while(precision>effectivePrecision++)parts[0]+="0"}argText=parts[0]+(parts.length>1?"e"+parts[1]:"");if(next==69)argText=argText.toUpperCase();if(currArg>=0){if(flagAlwaysSigned){argText="+"+argText}else if(flagPadSign){argText=" "+argText}}}while(argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad&&(argText[0]=="-"||argText[0]=="+")){argText=argText[0]+"0"+argText.slice(1)}else{argText=(flagZeroPad?"0":" ")+argText}}}if(next<97)argText=argText.toUpperCase();argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"s":{var arg=getNextArg("i8*");var argLength=arg?_strlen(arg):"(null)".length;if(precisionSet)argLength=Math.min(argLength,precision);if(!flagLeftAlign){while(argLength<width--){ret.push(32)}}if(arg){for(var i=0;i<argLength;i++){ret.push(HEAPU8[arg++>>0])}}else{ret=ret.concat(intArrayFromString("(null)".substr(0,argLength),true))}if(flagLeftAlign){while(argLength<width--){ret.push(32)}}break};case"c":{if(flagLeftAlign)ret.push(getNextArg("i8"));while(--width>0){ret.push(32)}if(!flagLeftAlign)ret.push(getNextArg("i8"));break};case"n":{var ptr=getNextArg("i32*");HEAP32[ptr>>2]=ret.length;break};case"%":{ret.push(curr);break};default:{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[i>>0])}}}textIndex+=2}else{ret.push(curr);textIndex+=1}}return ret}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,"i8",ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret}function _vfprintf(s,f,va_arg){return _fprintf(s,f,HEAP32[va_arg>>2])}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0)self.alloc(bytes);return ret}Module["_memmove"]=_memmove;function ___errno_location(){return ___errno_state}var _BItoD=true;Module["_strcpy"]=_strcpy;function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);___errno_state=Runtime.staticAlloc(4);HEAP32[___errno_state>>2]=0;_fputc.ret=allocate([0],"i8",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var ctlz_i8=allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_DYNAMIC);var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function nullFunc_iiii(x){Module["printErr"]("Invalid function pointer called with signature 'iiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_viiiii(x){Module["printErr"]("Invalid function pointer called with signature 'viiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_vi(x){Module["printErr"]("Invalid function pointer called with signature 'vi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_vii(x){Module["printErr"]("Invalid function pointer called with signature 'vii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_ii(x){Module["printErr"]("Invalid function pointer called with signature 'ii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_v(x){Module["printErr"]("Invalid function pointer called with signature 'v'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_viiiiii(x){Module["printErr"]("Invalid function pointer called with signature 'viiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function nullFunc_viiii(x){Module["printErr"]("Invalid function pointer called with signature 'viiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x)}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array};Module.asmLibraryArg={"abort":abort,"assert":assert,"min":Math_min,"nullFunc_iiii":nullFunc_iiii,"nullFunc_viiiii":nullFunc_viiiii,"nullFunc_vi":nullFunc_vi,"nullFunc_vii":nullFunc_vii,"nullFunc_ii":nullFunc_ii,"nullFunc_v":nullFunc_v,"nullFunc_viiiiii":nullFunc_viiiiii,"nullFunc_viiii":nullFunc_viiii,"invoke_iiii":invoke_iiii,"invoke_viiiii":invoke_viiiii,"invoke_vi":invoke_vi,"invoke_vii":invoke_vii,"invoke_ii":invoke_ii,"invoke_v":invoke_v,"invoke_viiiiii":invoke_viiiiii,"invoke_viiii":invoke_viiii,"_send":_send,"___setErrNo":___setErrNo,"_vfprintf":_vfprintf,"___assert_fail":___assert_fail,"___cxa_allocate_exception":___cxa_allocate_exception,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_pwrite":_pwrite,"_strerror_r":_strerror_r,"__reallyNegative":__reallyNegative,"_sbrk":_sbrk,"___cxa_begin_catch":___cxa_begin_catch,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_fileno":_fileno,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_sysconf":_sysconf,"_pthread_getspecific":_pthread_getspecific,"_atexit":_atexit,"_pthread_once":_pthread_once,"_puts":_puts,"_pthread_key_create":_pthread_key_create,"_write":_write,"___errno_location":___errno_location,"_pthread_setspecific":_pthread_setspecific,"___cxa_atexit":___cxa_atexit,"_fputc":_fputc,"___cxa_throw":___cxa_throw,"_abort":_abort,"_fwrite":_fwrite,"_time":_time,"_fprintf":_fprintf,"_strerror":_strerror,"__formatString":__formatString,"_fputs":_fputs,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"ctlz_i8":ctlz_i8,"NaN":NaN,"Infinity":Infinity,"___dso_handle":___dso_handle,"_stderr":_stderr};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env.___dso_handle|0;var p=env._stderr|0;var q=0;var r=0;var s=0;var t=0;var u=+env.NaN,v=+env.Infinity;var w=0,x=0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0.0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=0;var P=global.Math.floor;var Q=global.Math.abs;var R=global.Math.sqrt;var S=global.Math.pow;var T=global.Math.cos;var U=global.Math.sin;var V=global.Math.tan;var W=global.Math.acos;var X=global.Math.asin;var Y=global.Math.atan;var Z=global.Math.atan2;var _=global.Math.exp;var $=global.Math.log;var aa=global.Math.ceil;var ba=global.Math.imul;var ca=env.abort;var da=env.assert;var ea=env.min;var fa=env.nullFunc_iiii;var ga=env.nullFunc_viiiii;var ha=env.nullFunc_vi;var ia=env.nullFunc_vii;var ja=env.nullFunc_ii;var ka=env.nullFunc_v;var la=env.nullFunc_viiiiii;var ma=env.nullFunc_viiii;var na=env.invoke_iiii;var oa=env.invoke_viiiii;var pa=env.invoke_vi;var qa=env.invoke_vii;var ra=env.invoke_ii;var sa=env.invoke_v;var ta=env.invoke_viiiiii;var ua=env.invoke_viiii;var va=env._send;var wa=env.___setErrNo;var xa=env._vfprintf;var ya=env.___assert_fail;var za=env.___cxa_allocate_exception;var Aa=env.__ZSt18uncaught_exceptionv;var Ba=env._pwrite;var Ca=env._strerror_r;var Da=env.__reallyNegative;var Ea=env._sbrk;var Fa=env.___cxa_begin_catch;var Ga=env._emscripten_memcpy_big;var Ha=env._fileno;var Ia=env.___resumeException;var Ja=env.___cxa_find_matching_catch;var Ka=env._sysconf;var La=env._pthread_getspecific;var Ma=env._atexit;var Na=env._pthread_once;var Oa=env._puts;var Pa=env._pthread_key_create;var Qa=env._write;var Ra=env.___errno_location;var Sa=env._pthread_setspecific;var Ta=env.___cxa_atexit;var Ua=env._fputc;var Va=env.___cxa_throw;var Wa=env._abort;var Xa=env._fwrite;var Ya=env._time;var Za=env._fprintf;var _a=env._strerror;var $a=env.__formatString;var ab=env._fputs;var bb=0.0;
// EMSCRIPTEN_START_FUNCS
function kb(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;if((i|0)>=(j|0))ca();return b|0}function lb(){return i|0}function mb(a){a=a|0;i=a}function nb(a,b){a=a|0;b=b|0;if(!q){q=a;r=b}}function ob(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function pb(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function qb(a){a=a|0;F=a}function rb(){return F|0}function sb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;f=i;c[b>>2]=0;a[b+8>>0]=1;if(!d)d=0;else d=ie(d)|0;c[b+12>>2]=d;if(!e)d=0;else d=ie(e)|0;c[b+16>>2]=d;i=f;return}function tb(a){a=a|0;var b=0,d=0;d=i;b=c[a+12>>2]|0;if(b)Qe(b);b=c[a+16>>2]|0;if(!b){i=d;return}Qe(b);i=d;return}function ub(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;h=i;i=i+16|0;if((i|0)>=(j|0))ca();g=h;f=c[b+16>>2]|0;if(f){c[g>>2]=f;vb(16,g)}if(e){c[g>>2]=c[d+52>>2];vb(24,g)}e=c[b>>2]|0;if(!e){i=h;return}f=c[b+4>>2]|0;if((f+-1|0)>>>0>=2){i=h;return}f=(f|0)==1?56:64;if(!(a[b+8>>0]|0)){c[g>>2]=f;vb(80,g);i=h;return}else{b=c[e+4>>2]|0;c[g>>2]=f;c[g+4>>2]=b;vb(40,g);i=h;return}}function vb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+16|0;if((i|0)>=(j|0))ca();g=h;if(!(c[176]|0))ya(1160,120,80,1232);ce(c[2]|0)|0;if((c[2]|0)>0){e=c[176]|0;f=0;do{a[e>>0]=32;f=f+1|0;e=(c[176]|0)+1|0;c[176]=e}while((f|0)<(c[2]|0))}do{e=(c[178]|0)-(c[176]|0)+(c[174]|0)|0;c[g>>2]=d;e=af(c[176]|0,e,b,g)|0}while(!(ce(e)|0));c[176]=(c[176]|0)+e;i=h;return}function wb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;f=i;c[b+4>>2]=0;c[b+8>>2]=0;c[b>>2]=b+4;c[b+16>>2]=0;c[b+20>>2]=0;c[b+12>>2]=b+16;c[b+28>>2]=0;c[b+32>>2]=0;c[b+24>>2]=b+28;c[b+40>>2]=0;c[b+44>>2]=0;c[b+36>>2]=b+40;c[b+48>>2]=0;c[b+52>>2]=-1;a[b+64>>0]=0;if(!d)d=0;else d=ie(d)|0;c[b+56>>2]=d;if(!e){e=0;b=b+60|0;c[b>>2]=e;i=f;return}e=ie(e)|0;b=b+60|0;c[b>>2]=e;i=f;return}function xb(a){a=a|0;Fa(a|0)|0;ue()}function yb(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;g=i;b=c[a+56>>2]|0;if(b)Qe(b);b=c[a+60>>2]|0;if(b)Qe(b);e=a+24|0;b=c[e>>2]|0;f=a+28|0;if((b|0)!=(f|0))do{d=c[b+20>>2]|0;if(d){tb(d);pe(d)}b=Ac(b)|0}while((b|0)!=(f|0));Od(a+36|0);de(e);Od(a+12|0);de(a);i=g;return}function zb(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=a+56|0;d=c[a>>2]|0;if(d)Qe(d);c[a>>2]=ie(b)|0;i=e;return}function Ab(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+16|0;if((i|0)>=(j|0))ca();f=g;c[f>>2]=b;if(!(Hc(a,f)|0)){b=oe(20)|0;sb(b,d,e);c[(Bb(a,f)|0)>>2]=b;i=g;return}else ya(88,120,161,136)}function Bb(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;if((i|0)>=(j|0))ca();g=h+12|0;d=h;e=Ec(a,g,b)|0;f=c[e>>2]|0;if(f){a=f;a=a+20|0;i=h;return a|0}Fc(d,a,b);b=c[d>>2]|0;c[d>>2]=0;Gc(a,c[g>>2]|0,e,b);a=b;a=a+20|0;i=h;return a|0}function Cb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=i;i=i+32|0;if((i|0)>=(j|0))ca();D=E;B=E+24|0;C=E+12|0;A=E+8|0;if(!((a[b+64>>0]|0)==0|d^1))vb(152,D);e=c[b+56>>2]|0;a:do if((e|0)!=0?(a[e>>0]|0)!=0:0){while(1){f=ge(e,10)|0;if(!f)break;a[f>>0]=0;Db(e);a[f>>0]=10;e=f+1|0;if(!(a[e>>0]|0))break a}Db(e)}while(0);u=b+24|0;f=b+32|0;if(!(c[f>>2]|0)){i=E;return}v=b+48|0;e=c[v>>2]|0;w=(Eb(e)|0)!=0;e=e+8|0;g=c[e>>2]|0;x=Fb(g)|0;y=(x|0)!=0;if(y){c[e>>2]=c[g+8>>2];a[x+40>>0]=0;Gb(x);t=(c[x+32>>2]|0)!=(c[f>>2]|0)}else t=1;c[B>>2]=0;g=c[u>>2]|0;s=b+28|0;if((g|0)==(s|0))ya(192,120,233,184);else{k=g;h=0}while(1){if(!(c[(c[k+20>>2]|0)+12>>2]|0)){if(h){z=14;break}l=c[k+16>>2]|0;c[B>>2]=l}else l=h;k=Ac(k)|0;if((k|0)==(s|0))break;else h=l}if((z|0)==14)ya(168,120,229,184);if(!l)ya(192,120,233,184);q=b+60|0;f=c[q>>2]|0;r=(f|0)!=0;if(r){c[D>>2]=f;vb(208,D);f=c[u>>2]|0}else f=g;c[C>>2]=0;o=C+4|0;c[o>>2]=0;c[C+8>>2]=0;p=x+24|0;g=r^1;while(1){n=(f|0)!=(s|0);if(n){h=c[f+16>>2]|0;if((h|0)!=(c[B>>2]|0)){e=c[f+20>>2]|0;if(!(c[e+12>>2]|0)){z=25;break}else z=27}}else{h=c[B>>2]|0;e=c[(Bb(u,B)|0)>>2]|0;z=27}if((z|0)==27){z=0;if(t?(a[h+64>>0]|0)!=0:0)m=1;else m=w;if(y)b=(Dc(p,h+52|0)|0)!=0;else b=0;if(!m?!((c[e+4>>2]|0)!=0|b):0)k=(c[e+16>>2]|0)!=0;else k=1;do if(n){if(r){c[D>>2]=c[e+12>>2];vb(248,D);z=54;break}if(k){z=c[e+12>>2]|0;c[D>>2]=g?272:280;c[D+4>>2]=z;vb(256,D);z=55;break}if((c[C>>2]|0)>0)Hb(C,288)|0;Hb(C,296)|0;l=c[q>>2]|0;if(l){Hb(C,l)|0;Hb(C,304)|0}Hb(C,c[e+12>>2]|0)|0;Hb(C,312)|0;if(g)g=1;else z=55}else{if(r){vb(320,D);z=54;break}if(k){if((c[C>>2]|0)<=0){if(g){g=1;break}vb(376,D);z=55;break}k=c[o>>2]|0;if(g){c[D>>2]=k;vb(336,D);z=55;break}else{c[D>>2]=k;vb(352,D);z=55;break}}else z=54}while(0);if((z|0)==54){z=0;if(g)g=1;else z=55}if((z|0)==55){z=0;c[2]=(c[2]|0)+1;g=0}ub(e,h,m);if(!b){if((c[e+4>>2]|0)==3){e=c[(c[v>>2]|0)+8>>2]|0;if(!e){z=60;break}fb[c[(c[e>>2]|0)+8>>2]&7](e,d);c[(c[v>>2]|0)+8>>2]=0}}else{Bc(A,p,h+52|0);m=c[(c[A>>2]|0)+20>>2]|0;fb[c[(c[m>>2]|0)+8>>2]&7](m,d)}if(r&n)vb(408,D);if(!g)c[2]=(c[2]|0)+-1;if(r)vb(416,D);if((f|0)==(s|0)){z=70;break}}f=Ac(f)|0}if((z|0)==25)ya(224,120,250,184);else if((z|0)==60)ya(392,120,302,184);else if((z|0)==70){if(!g)vb(416,D);if(y)Ib(x);be(C);i=E;return}}function Db(b){b=b|0;var d=0,e=0,f=0;f=i;if(!(c[176]|0))ya(1160,120,96,1176);ce(c[2]|0)|0;if((c[2]|0)>0){d=c[176]|0;e=0;do{a[d>>0]=32;e=e+1|0;d=(c[176]|0)+1|0;c[176]=d}while((e|0)<(c[2]|0))}ce((hf(b|0)|0)+1|0)|0;nf(c[176]|0,b|0)|0;e=hf(b|0)|0;b=c[176]|0;c[176]=b+(e+1);a[b+e>>0]=10;a[c[176]>>0]=0;i=f;return}function Eb(a){a=a|0;var b=0;b=i;if(!((a|0)!=0?(c[a+16>>2]|0)==3:0))a=0;i=b;return a|0}function Fb(a){a=a|0;var b=0;b=i;if(!((a|0)!=0?(c[a+16>>2]|0)==1:0))a=0;i=b;return a|0}function Gb(b){b=b|0;var d=0,e=0,f=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();e=f;if(!(c[b+36>>2]|0)){i=f;return}d=(a[b+20>>0]|0)!=0;if(a[b+40>>0]|0){if(!d){i=f;return}c[e>>2]=c[b+4>>2];vb(424,e);i=f;return}if(d){c[e>>2]=c[b+4>>2];vb(432,e)}else vb(448,e);c[2]=(c[2]|0)+1;i=f;return}function Hb(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;h=hf(b|0)|0;d=c[a>>2]|0;f=a+8|0;e=c[f>>2]|0;if((h+2+d|0)>(e|0)){g=e+h<<1;g=1024-((g|0)%1024|0)+g|0;c[f>>2]=g;f=a+4|0;e=c[f>>2]|0;if(!e)e=Pe(g)|0;else{e=Re(e,g)|0;d=c[a>>2]|0}c[f>>2]=e}else e=c[a+4>>2]|0;nf(e+d|0,b|0)|0;c[a>>2]=(c[a>>2]|0)+h;i=j;return a|0}function Ib(b){b=b|0;var d=0;d=i;i=i+16|0;if((i|0)>=(j|0))ca();if(!(c[b+36>>2]|0)){i=d;return}if(a[b+40>>0]|0){i=d;return}c[2]=(c[2]|0)+-1;vb(456,d);i=d;return}function Jb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,k=0,l=0;l=i;i=i+16|0;if((i|0)>=(j|0))ca();k=l;Gb(b);if(!(a[b+40>>0]|0)){e=c[b+24>>2]|0;h=b+28|0;if((e|0)!=(h|0)){g=272;while(1){f=c[e+16>>2]|0;if(!(c[118]|0)){c[k>>2]=g;c[k+4>>2]=f;vb(520,k)}else{c[k>>2]=g;c[k+4>>2]=f;vb(480,k)}c[2]=(c[2]|0)+1;g=c[e+20>>2]|0;fb[c[(c[g>>2]|0)+8>>2]&7](g,d);c[2]=(c[2]|0)+-1;vb(416,k);e=Ac(e)|0;if((e|0)==(h|0))break;else g=512}}}else{if(!(c[118]|0))vb(568,k);else vb(544,k);e=(c[2]|0)+1|0;c[2]=e;f=c[b+24>>2]|0;g=b+28|0;if((f|0)!=(g|0)){e=f;do{c[k>>2]=c[e+16>>2];vb(592,k);c[2]=(c[2]|0)+1;h=c[e+20>>2]|0;fb[c[(c[h>>2]|0)+8>>2]&7](h,d);vb(408,k);c[2]=(c[2]|0)+-1;vb(416,k);e=Ac(e)|0}while((e|0)!=(g|0));e=c[2]|0}c[2]=e+-1;vb(416,k)}Ib(b);e=c[b+8>>2]|0;if(!e){i=l;return}fb[c[(c[e>>2]|0)+8>>2]&7](e,d);i=l;return}function Kb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();e=f;if(!(a[b+20>>0]|0))vb(632,e);else{c[e>>2]=c[b+4>>2];vb(608,e)}c[2]=(c[2]|0)+1;g=c[b+24>>2]|0;fb[c[(c[g>>2]|0)+8>>2]&7](g,1);c[2]=(c[2]|0)+-1;vb(416,e);b=c[b+8>>2]|0;if(!b){i=f;return}fb[c[(c[b>>2]|0)+8>>2]&7](b,d);i=f;return}function Lb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,k=0;k=i;i=i+16|0;if((i|0)>=(j|0))ca();h=k;c[h>>2]=c[(c[b+24>>2]|0)+52>>2];vb(24,h);if(a[b+20>>0]|0){c[h>>2]=c[b+4>>2];vb(424,h)}vb(632,h);c[2]=(c[2]|0)+1;vb(648,h);e=(c[2]|0)+1|0;c[2]=e;f=c[b+28>>2]|0;g=b+32|0;if((f|0)!=(g|0)){e=f;do{f=c[e+16>>2]|0;c[h>>2]=c[f+52>>2];vb(592,h);c[2]=(c[2]|0)+1;Cb(f,d);vb(408,h);c[2]=(c[2]|0)+-1;vb(416,h);e=Ac(e)|0}while((e|0)!=(g|0));e=c[2]|0}c[2]=e+-1;vb(416,h);c[2]=(c[2]|0)+-1;vb(416,h);e=c[b+8>>2]|0;if(!e){i=k;return}fb[c[(c[e>>2]|0)+8>>2]&7](e,d);i=k;return}function Mb(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;j=i;f=a+20|0;b=c[f>>2]|0;if(b){g=a+16|0;h=a+4|0;e=0;do{d=(c[g>>2]|0)+e|0;d=c[(c[(c[h>>2]|0)+(d>>>10<<2)>>2]|0)+((d&1023)<<2)>>2]|0;if(d){yb(d);pe(d);b=c[f>>2]|0}e=e+1|0}while(e>>>0<b>>>0)}h=a+44|0;b=c[h>>2]|0;if(!b){h=a+24|0;Xd(h);_d(a);i=j;return}g=a+40|0;f=a+28|0;e=0;do{d=(c[g>>2]|0)+e|0;d=c[(c[(c[f>>2]|0)+(d>>>10<<2)>>2]|0)+((d&1023)<<2)>>2]|0;if(d){eb[c[(c[d>>2]|0)+4>>2]&31](d);b=c[h>>2]|0}e=e+1|0}while(e>>>0<b>>>0);h=a+24|0;Xd(h);_d(a);i=j;return}function Nb(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();e=f;c[e>>2]=b;if((d|0)==-1){g=a+56|0;d=c[g>>2]|0;c[g>>2]=d+1}c[b+52>>2]=d;Ob(a,e);i=f;return}function Ob(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+16|0;if((i|0)>=(j|0))ca();f=g;d=c[a+8>>2]|0;e=c[a+4>>2]|0;if((d|0)==(e|0))d=0;else d=(d-e<<8)+-1|0;e=a+20|0;if((d-(c[a+16>>2]|0)|0)==(c[e>>2]|0))rc(a);sc(f,a);d=c[f+4>>2]|0;if(!d){b=c[e>>2]|0;b=b+1|0;c[e>>2]=b;i=g;return}c[d>>2]=c[b>>2];b=c[e>>2]|0;b=b+1|0;c[e>>2]=b;i=g;return}function Pb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;E=i;i=i+128|0;if((i|0)>=(j|0))ca();v=E+112|0;u=E+92|0;t=E+40|0;o=E+36|0;q=E+28|0;r=E+88|0;p=E+104|0;w=E+120|0;D=E+56|0;n=E+24|0;B=E+12|0;z=E+72|0;C=E;x=E+32|0;A=E+80|0;c[w>>2]=d;c[D>>2]=b;c[D+8>>2]=0;c[D+12>>2]=0;y=D+8|0;s=D+4|0;c[s>>2]=y;c[u>>2]=d;c[t>>2]=t;f=t+4|0;c[f>>2]=t;g=t+8|0;c[g>>2]=0;Dd(t,u);if(c[g>>2]|0){e=D+4|0;do{c[o>>2]=c[(c[f>>2]|0)+8>>2];Ed(t);if((qc(e,o)|0)==0?(jc(v,e,o),l=c[o>>2]|0,h=c[l>>2]|0,(h|0)!=(l+4|0)):0){d=h;do{Dd(t,d+16|0);d=Ac(d)|0}while((d|0)!=((c[o>>2]|0)+4|0))}}while((c[g>>2]|0)!=0)}Id(t);f=b+20|0;e=c[f>>2]|0;if(e){d=b+16|0;k=b+4|0;l=D+4|0;g=0;do{h=(c[d>>2]|0)+g|0;h=c[(c[(c[k>>2]|0)+(h>>>10<<2)>>2]|0)+((h&1023)<<2)>>2]|0;c[n>>2]=h;if((qc(l,n)|0)!=0?(m=c[h>>2]|0,(m|0)!=(h+4|0)):0){h=m;do{jc(v,(c[h+16>>2]|0)+12|0,n);h=Ac(h)|0}while((h|0)!=((c[n>>2]|0)+4|0));e=c[f>>2]|0}g=g+1|0}while(g>>>0<e>>>0)}if(!(a[b+52>>0]|0)){k=D+4|0;h=c[k>>2]|0;g=(h|0)==(y|0);if(g)n=0;else{d=h;e=0;do{e=(hf(c[(c[d+16>>2]|0)+56>>2]|0)|0)+e|0;d=Ac(d)|0}while((d|0)!=(y|0));n=(e>>>0)/5|0}c[u+4>>2]=0;c[u+8>>2]=0;m=u+4|0;c[u>>2]=m;c[t+4>>2]=0;c[t+8>>2]=0;l=t+4|0;c[t>>2]=l;if(!g){do{d=c[h+16>>2]|0;c[o>>2]=d;f=c[d+20>>2]|0;if(((f>>>0>=2?(c[d+8>>2]|0)==0:0)?(Hc(d,o)|0)==0:0)?(ba(hf(c[d+56>>2]|0)|0,f+-1|0)|0)>>>0<=n>>>0:0){e=c[d+12>>2]|0;if((e|0)!=(d+16|0))do{c[q>>2]=c[e+16>>2];f=oe(68)|0;wb(f,c[d+56>>2]|0,c[d+60>>2]|0);c[r>>2]=f;Nb(c[D>>2]|0,f,c[d+52>>2]|0);jc(v,f+12|0,q);f=c[q>>2]|0;d=c[(Bb(f,o)|0)>>2]|0;g=oe(20)|0;sb(g,c[d+12>>2]|0,c[d+16>>2]|0);c[(Bb(f,r)|0)>>2]=g;ld(f,o)|0;f=c[o>>2]|0;g=c[f>>2]|0;f=f+4|0;if((g|0)!=(f|0))do{c[p>>2]=c[g+16>>2];F=c[g+20>>2]|0;d=oe(20)|0;sb(d,c[F+12>>2]|0,c[F+16>>2]|0);c[(Bb(c[r>>2]|0,p)|0)>>2]=d;jc(v,(c[p>>2]|0)+12|0,r);g=Ac(g)|0}while((g|0)!=(f|0));jc(v,u,r);jc(v,t,o);e=Ac(e)|0;d=c[o>>2]|0}while((e|0)!=(d+16|0));e=c[d>>2]|0;if((e|0)!=(d+4|0))do{qd((c[e+16>>2]|0)+12|0,o)|0;e=Ac(e)|0}while((e|0)!=((c[o>>2]|0)+4|0))}h=Ac(h)|0}while((h|0)!=(y|0));d=c[u>>2]|0;if((d|0)!=(m|0))do{jc(v,k,d+16|0);d=Ac(d)|0}while((d|0)!=(m|0))}d=c[t>>2]|0;if((d|0)!=(l|0))do{qd(k,d+16|0)|0;d=Ac(d)|0}while((d|0)!=(l|0));Od(t);Od(u)}c[B+4>>2]=0;c[B+8>>2]=0;c[B>>2]=B+4;d=c[s>>2]|0;if((d|0)!=(y|0))do{c[z>>2]=c[d+16>>2];jc(v,B,z);d=Ac(d)|0}while((d|0)!=(y|0));c[C+4>>2]=0;c[C+8>>2]=0;c[C>>2]=C+4;jc(v,C,w);c[x>>2]=b;d=Qb(x,B,C)|0;c[b+48>>2]=d;if(!d)ya(672,120,1043,680);else{c[A>>2]=b;c[A+4>>2]=0;Mc(d,0);Nc(d,0,0,0);Oc(A,d);Od(C);Od(B);Od(D+4|0);i=E;return}}function Qb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0;oa=i;i=i+160|0;if((i|0)>=(j|0))ca();w=oa+88|0;x=oa+72|0;Z=oa+56|0;_=oa+124|0;$=oa+84|0;aa=oa+52|0;ba=oa+104|0;ga=oa+112|0;ea=oa+120|0;la=oa+136|0;Y=oa+148|0;ia=oa+96|0;y=oa+40|0;ma=oa;da=oa+24|0;ha=oa+100|0;L=oa+108|0;ja=oa+80|0;fa=oa+116|0;ka=oa+48|0;c[ma+4>>2]=0;c[ma+8>>2]=0;c[ma>>2]=ma+4;c[ma+16>>2]=0;c[ma+20>>2]=0;c[ma+12>>2]=ma+16;z=d+8|0;A=_+4|0;B=_+8|0;E=_+4|0;F=(d|0)==0;G=d+4|0;H=da+4|0;I=da+8|0;J=da+4|0;K=Z+8|0;M=Z+12|0;N=Z+8|0;O=Z+4|0;P=_+4|0;Q=_+8|0;R=Z+4|0;S=Z+4|0;T=Z+8|0;U=Z+4|0;V=la+4|0;W=la+8|0;X=Z+4|0;f=0;h=0;k=0;g=0;a:while(1){u=h;v=k;while(1){v=1-v|0;t=ma+(v*12|0)|0;Wd(t);h=c[e+8>>2]|0;if(!h){f=g;na=106;break a}else if((h|0)!=1)break;k=c[(c[e>>2]|0)+16>>2]|0;if(a[(c[b>>2]|0)+52>>0]|0){m=oe(40)|0;c[m+4>>2]=-1;c[m+8>>2]=0;c[m+16>>2]=3;c[m>>2]=912;h=m+32|0;c[h>>2]=0;c[m+36>>2]=0;e=m+28|0;c[e>>2]=h;a[m+20>>0]=1;ed(b,m);c[m+24>>2]=k;h=c[d>>2]|0;if((h|0)!=(G|0))do{c[Z>>2]=c[h+16>>2];jc(w,e,Z);s=c[Z>>2]|0;c[s+48>>2]=m;fd(s,2,m,d);h=Ac(h)|0}while((h|0)!=(G|0));Wd(d);if(u)c[u+8>>2]=m;g=(g|0)==0?m:g;if(!(c[ma+(v*12|0)+8>>2]|0)){f=g;na=106;break a}else{u=m;e=t;continue}}if(c[k+20>>2]|0){e=ad(b,d,e,t)|0;if(u)c[u+8>>2]=e;g=(g|0)==0?e:g;if(!(c[ma+(v*12|0)+8>>2]|0)){f=g;na=106;break a}else{u=e;e=t;continue}}c[Z>>2]=k;n=oe(24)|0;c[n+4>>2]=-1;c[n+8>>2]=0;c[n+16>>2]=0;c[n>>2]=1112;s=n+20|0;c[s>>2]=0;ed(b,n);c[s>>2]=k;c[k+48>>2]=n;if((c[z>>2]|0)>>>0>1){qd(d,Z)|0;k=c[Z>>2]|0;h=c[k>>2]|0;k=k+4|0;if((h|0)!=(k|0))do{e=h+16|0;if(!(!F?(qc(d,e)|0)==0:0))jc(y,t,e);h=Ac(h)|0}while((h|0)!=(k|0));c[A>>2]=0;c[B>>2]=0;c[_>>2]=E;jc(w,_,Z);h=c[t>>2]|0;k=ma+(v*12|0)+4|0;if((h|0)!=(k|0))do{fd(c[h+16>>2]|0,0,n,_);h=Ac(h)|0}while((h|0)!=(k|0));Od(_)}if(u)c[u+8>>2]=n;g=(g|0)==0?n:g;if(!(c[ma+(v*12|0)+8>>2]|0)){f=g;na=106;break a}else{u=n;e=t}}c[H>>2]=0;c[I>>2]=0;c[da>>2]=J;c[Z>>2]=da;c[K>>2]=0;c[M>>2]=0;c[O>>2]=N;c[_>>2]=_;c[P>>2]=_;c[Q>>2]=0;h=c[e>>2]|0;s=e+4|0;if((h|0)!=(s|0)){do{r=c[h+16>>2]|0;c[$>>2]=r;c[(Cd(X,$)|0)>>2]=r;jc(w,bd(da,$)|0,$);Dd(_,$);h=Ac(h)|0}while((h|0)!=(s|0));if(c[Q>>2]|0)do{c[aa>>2]=c[(c[P>>2]|0)+8>>2];Ed(_);r=c[(Cd(X,aa)|0)>>2]|0;c[ba>>2]=r;if((r|0)!=0?(D=c[aa>>2]|0,C=c[D>>2]|0,D=D+4|0,(C|0)!=(D|0)):0){h=C;do{c[ga>>2]=c[h+16>>2];Jd(ea,X,ga);k=c[ea>>2]|0;if((k|0)!=(N|0)){r=c[k+20>>2]|0;if((r|0)!=0?(r|0)!=(c[ba>>2]|0):0)Fd(Z,c[ga>>2]|0)}else{r=c[ba>>2]|0;c[(Cd(X,ga)|0)>>2]=r;jc(w,bd(da,ba)|0,ga);Dd(_,ga)}h=Ac(h)|0}while((h|0)!=(D|0))}}while((c[Q>>2]|0)!=0)}h=c[e>>2]|0;if((h|0)!=(s|0)){do{m=bd(da,h+16|0)|0;c[la>>2]=la;c[V>>2]=la;c[W>>2]=0;k=c[m>>2]|0;m=m+4|0;if((k|0)!=(m|0))do{r=c[k+16>>2]|0;c[Y>>2]=r;l=c[r+12>>2]|0;if((l|0)!=(r+16|0))do{c[ia>>2]=c[l+16>>2];r=c[(Cd(X,ia)|0)>>2]|0;if((r|0)!=(c[(Cd(X,Y)|0)>>2]|0))Dd(la,Y);l=Ac(l)|0}while((l|0)!=((c[Y>>2]|0)+16|0));k=Ac(k)|0}while((k|0)!=(m|0));while(1){if(!(c[W>>2]|0))break;r=c[(c[V>>2]|0)+8>>2]|0;Ed(la);Fd(Z,r)}Id(la);h=Ac(h)|0}while((h|0)!=(s|0));h=c[e>>2]|0;if((h|0)!=(s|0))do{k=h+16|0;if(!(c[(bd(da,k)|0)+8>>2]|0))vd(da,k)|0;h=Ac(h)|0}while((h|0)!=(s|0))}Id(_);Gd(R);h=c[I>>2]|0;if(h){k=c[da>>2]|0;if((k|0)!=(J|0)){do{h=c[k+16>>2]|0;l=k;k=Ac(k)|0;m=c[h+12>>2]|0;h=h+16|0;b:do if((m|0)!=(h|0)){n=l+20|0;while(1){c[ha>>2]=c[m+16>>2];if(!(qc(n,ha)|0))break;m=Ac(m)|0;if((m|0)==(h|0))break b}c[Z>>2]=l;c[w+0>>2]=c[Z+0>>2];xd(L,da,w)}while(0)}while((k|0)!=(J|0));h=c[I>>2]|0}if((h|0)==2){m=c[da>>2]|0;l=c[m+16>>2]|0;c[ja>>2]=l;k=c[m+28>>2]|0;m=Ac(m)|0;h=c[m+16>>2]|0;c[fa>>2]=h;m=c[m+28>>2]|0;c:do if((k|0)!=(m|0)){if((k|0)>(m|0)){c[ja>>2]=h;c[fa>>2]=l}l=bd(da,ja)|0;k=c[l>>2]|0;h=l+4|0;if((k|0)!=(h|0))do{n=c[k+16>>2]|0;m=c[n>>2]|0;n=n+4|0;if((m|0)!=(n|0))do{c[ka>>2]=c[m+16>>2];if(!(qc(l,ka)|0))break c;m=Ac(m)|0}while((m|0)!=(n|0));k=Ac(k)|0}while((k|0)!=(h|0));vd(da,fa)|0}while(0);h=c[I>>2]|0}if(h){p=(Pc(u)|0)==0;r=oe(44)|0;ud(r);ed(b,r);c[S>>2]=0;c[T>>2]=0;c[Z>>2]=U;m=c[da>>2]|0;if((m|0)!=(J|0)){q=r+24|0;do{c[_>>2]=c[m+16>>2];h=m+20|0;Wd(Z);jc(w,Z,_);n=c[h>>2]|0;o=m+24|0;if((n|0)!=(o|0))do{c[$>>2]=c[n+16>>2];qd(d,$)|0;k=c[$>>2]|0;l=c[k>>2]|0;if((l|0)!=(k+4|0))do{c[aa>>2]=c[l+16>>2];l=Ac(l)|0;if(!(qc(h,aa)|0)){jc(w,t,aa);fd(c[aa>>2]|0,1,r,h);k=c[$>>2]|0}}while((l|0)!=(k+4|0));n=Ac(n)|0}while((n|0)!=(o|0));o=Qb(b,h,Z)|0;l=c[_>>2]|0;c[(gd(q,l+52|0)|0)>>2]=o;if(p)a[l+64>>0]=1;m=Ac(m)|0}while((m|0)!=(J|0))}k=c[e>>2]|0;if((k|0)!=(s|0))do{c[ba>>2]=c[k+16>>2];if(!(hd(da,ba)|0))jc(x,t,ba);k=Ac(k)|0}while((k|0)!=(s|0));if((c[r+32>>2]|0)>>>0>9){a[r+40>>0]=1;s=r+36|0;c[s>>2]=(c[s>>2]|0)+1}Od(Z);if(u)c[u+8>>2]=r;g=(g|0)==0?r:g;s=(c[ma+(v*12|0)+8>>2]|0)==0;m=s?1:2;f=s?g:f;h=s?u:r;e=s?e:t}else na=102}else na=102;if((na|0)==102){na=0;k=ad(b,d,e,t)|0;if(u)c[u+8>>2]=k;g=(g|0)==0?k:g;s=(c[ma+(v*12|0)+8>>2]|0)==0;m=s?1:2;f=s?g:f;h=s?u:k;e=s?e:t}cd(da);if((m|0)==2)k=v;else{na=106;break}}if((na|0)==106){Od(ma+12|0);Od(ma);i=oa;return f|0}return 0}function Rb(a){a=a|0;var b=0;b=i;c[176]=c[174];a=c[a+48>>2]|0;if(!a)ya(672,120,1278,184);else{fb[c[(c[a>>2]|0)+8>>2]&7](a,0);i=b;return}}function Sb(a){a=a|0;var b=0;b=i;Kc(a);i=b;return}function Tb(a,b){a=a|0;b=b|0;c[176]=a;c[174]=a;c[178]=b;c[180]=0;return}function Ub(a){a=a|0;var b=0,d=0;b=i;d=Pe(a)|0;c[176]=d;c[174]=d;c[178]=a;c[180]=0;i=b;return}function Vb(a){a=a|0;c[118]=a;return}function Wb(a,b){a=a|0;b=b|0;var c=0,d=0;d=i;c=oe(68)|0;wb(c,a,b);i=d;return c|0}function Xb(a,b){a=a|0;b=b|0;var c=0;c=i;zb(a,b);i=c;return}function Yb(a){a=a|0;var b=0;b=i;if(a){yb(a);pe(a)}i=b;return}function Zb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;Ab(a,b,c,d);i=e;return}function _b(){var b=0,d=0,e=0,f=0,g=0;f=i;b=oe(64)|0;d=b+56|0;e=b+0|0;g=e+52|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(g|0));a[b+52>>0]=0;c[d>>2]=1;c[b+60>>2]=0;i=f;return b|0}function $b(a){a=a|0;var b=0;b=i;if(a){Mb(a);pe(a)}i=b;return}function ac(a,b){a=a|0;b=b|0;var c=0;c=i;Nb(a,b,-1);i=c;return}function bc(a,b){a=a|0;b=b|0;var c=0;c=i;Pb(a,b);i=c;return}function cc(a){a=a|0;var b=0;b=i;Rb(a);i=b;return}function dc(a){a=a|0;var b=0;b=i;c[a>>2]=752;Ic(a+24|0);i=b;return}function ec(a){a=a|0;var b=0;b=i;c[a>>2]=752;Ic(a+24|0);pe(a);i=b;return}function fc(a){a=a|0;return}function gc(a){a=a|0;var b=0;b=i;pe(a);i=b;return}function hc(a){a=a|0;var b=0;b=i;c[a>>2]=912;Od(a+28|0);i=b;return}function ic(a){a=a|0;var b=0;b=i;c[a>>2]=912;Od(a+28|0);pe(a);i=b;return}function jc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,k=0,l=0;l=i;i=i+16|0;if((i|0)>=(j|0))ca();k=l+12|0;f=l;g=kc(d,k,e)|0;h=c[g>>2]|0;if(h){e=0;d=h;c[b>>2]=d;d=b+4|0;a[d>>0]=e;i=l;return}lc(f,d,e);h=c[f>>2]|0;c[f>>2]=0;mc(d,c[k>>2]|0,g,h);e=1;d=h;c[b>>2]=d;d=b+4|0;a[d>>0]=e;i=l;return}function kc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;e=c[a+4>>2]|0;if(!e){f=a+4|0;c[b>>2]=f;b=f;i=g;return b|0}f=c[d>>2]|0;while(1){d=c[e+16>>2]|0;if(f>>>0<d>>>0){d=c[e>>2]|0;if(!d){a=5;break}else{e=d;continue}}if(d>>>0>=f>>>0){a=9;break}d=e+4|0;a=c[d>>2]|0;if(!a){a=8;break}else e=a}if((a|0)==5){c[b>>2]=e;b=e;i=g;return b|0}else if((a|0)==8){c[b>>2]=e;b=d;i=g;return b|0}else if((a|0)==9){c[b>>2]=e;i=g;return b|0}return 0}function lc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=oe(20)|0;c[f+16>>2]=c[d>>2];c[a>>2]=f;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=1;i=e;return}function mc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[c[a>>2]>>2]|0;if(b){c[a>>2]=b;e=c[d>>2]|0}nc(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;i=f;return}function nc(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;j=(d|0)==(b|0);a[d+12>>0]=j&1;if(j){i=k;return}else h=d;while(1){e=c[h+8>>2]|0;g=e+12|0;if(a[g>>0]|0){f=17;break}j=e+8|0;d=c[j>>2]|0;f=c[d>>2]|0;if((f|0)==(e|0)){f=c[d+4>>2]|0;if(!f){f=7;break}f=f+12|0;if(a[f>>0]|0){f=7;break}a[g>>0]=1;a[d+12>>0]=(d|0)==(b|0)&1;a[f>>0]=1}else{if(!f){f=14;break}f=f+12|0;if(a[f>>0]|0){f=14;break}a[g>>0]=1;a[d+12>>0]=(d|0)==(b|0)&1;a[f>>0]=1}if((d|0)==(b|0)){f=17;break}else h=d}if((f|0)==7){if((c[e>>2]|0)!=(h|0)){oc(e);d=c[j>>2]|0;e=d;d=c[d+8>>2]|0}a[e+12>>0]=1;a[d+12>>0]=0;pc(d);i=k;return}else if((f|0)==14){if((c[e>>2]|0)==(h|0)){pc(e);d=c[j>>2]|0;e=d;d=c[d+8>>2]|0}a[e+12>>0]=1;a[d+12>>0]=0;oc(d);i=k;return}else if((f|0)==17){i=k;return}}function oc(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;d=a+4|0;e=c[d>>2]|0;b=c[e>>2]|0;c[d>>2]=b;if(b)c[b+8>>2]=a;b=a+8|0;c[e+8>>2]=c[b>>2];d=c[b>>2]|0;if((c[d>>2]|0)==(a|0)){c[d>>2]=e;c[e>>2]=a;c[b>>2]=e;i=f;return}else{c[d+4>>2]=e;c[e>>2]=a;c[b>>2]=e;i=f;return}}function pc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;g=i;e=c[a>>2]|0;f=e+4|0;b=c[f>>2]|0;c[a>>2]=b;if(b)c[b+8>>2]=a;b=a+8|0;c[e+8>>2]=c[b>>2];d=c[b>>2]|0;if((c[d>>2]|0)==(a|0)){c[d>>2]=e;c[f>>2]=a;c[b>>2]=e;i=g;return}else{c[d+4>>2]=e;c[f>>2]=a;c[b>>2]=e;i=g;return}}function qc(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=c[a+4>>2]|0;if(!a){d=0;i=e;return d|0}d=c[b>>2]|0;while(1){b=c[a+16>>2]|0;if(d>>>0>=b>>>0){if(b>>>0>=d>>>0){a=1;b=8;break}a=a+4|0}a=c[a>>2]|0;if(!a){a=0;b=8;break}}if((b|0)==8){i=e;return a|0}return 0}function rc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+64|0;if((i|0)>=(j|0))ca();r=v+8|0;q=v+32|0;u=v+36|0;s=v+56|0;t=v+4|0;f=v;m=v+12|0;b=a+16|0;d=c[b>>2]|0;if(d>>>0>1023){c[b>>2]=d+-1024;g=a+4|0;h=c[g>>2]|0;k=c[h>>2]|0;d=h+4|0;c[g>>2]=d;l=a+8|0;b=c[l>>2]|0;e=a+12|0;do if((b|0)==(c[e>>2]|0)){f=c[a>>2]|0;if(d>>>0>f>>>0){u=d;a=((u-f>>2)+1|0)/-2|0;b=b-u|0;mf(h+(a+1<<2)|0,d|0,b|0)|0;b=h+(a+(b>>2)+1<<2)|0;c[l>>2]=b;c[g>>2]=(c[g>>2]|0)+(a<<2);break}else{b=b-f>>1;b=(b|0)==0?1:b;xc(u,b,b>>>2,a+12|0);c[s>>2]=c[g>>2];c[t>>2]=c[l>>2];c[q+0>>2]=c[s+0>>2];c[r+0>>2]=c[t+0>>2];wc(u,q,r);b=c[a>>2]|0;c[a>>2]=c[u>>2];c[u>>2]=b;b=u+4|0;a=c[g>>2]|0;c[g>>2]=c[b>>2];c[b>>2]=a;b=u+8|0;a=c[l>>2]|0;c[l>>2]=c[b>>2];c[b>>2]=a;b=u+12|0;a=c[e>>2]|0;c[e>>2]=c[b>>2];c[b>>2]=a;vc(u);b=c[l>>2]|0;break}}while(0);if(!b)b=0;else{c[b>>2]=k;b=c[l>>2]|0}c[l>>2]=b+4;i=v;return}p=a+8|0;l=c[p>>2]|0;n=a+4|0;h=l-(c[n>>2]|0)>>2;o=a+12|0;k=c[o>>2]|0;g=k-(c[a>>2]|0)|0;if(h>>>0>=g>>2>>>0){g=g>>1;xc(m,(g|0)==0?1:g,h,a+12|0);g=oe(4096)|0;f=m+8|0;b=c[f>>2]|0;e=m+12|0;do if((b|0)==(c[e>>2]|0)){l=m+4|0;k=c[l>>2]|0;h=c[m>>2]|0;if(k>>>0>h>>>0){s=k;t=((s-h>>2)+1|0)/-2|0;u=k+(t<<2)|0;b=b-s|0;mf(u|0,k|0,b|0)|0;b=k+(t+(b>>2)<<2)|0;c[f>>2]=b;c[l>>2]=u;break}else{d=b-h>>1;d=(d|0)==0?1:d;xc(u,d,d>>>2,c[m+16>>2]|0);c[s>>2]=k;c[t>>2]=b;c[q+0>>2]=c[s+0>>2];c[r+0>>2]=c[t+0>>2];wc(u,q,r);c[m>>2]=c[u>>2];c[u>>2]=h;s=u+4|0;c[l>>2]=c[s>>2];c[s>>2]=k;s=u+8|0;t=c[s>>2]|0;c[f>>2]=t;c[s>>2]=b;s=u+12|0;c[e>>2]=c[s>>2];c[s>>2]=b;vc(u);b=t;break}}while(0);if(!b)b=0;else c[b>>2]=g;c[f>>2]=b+4;b=c[p>>2]|0;while(1){if((b|0)==(c[n>>2]|0))break;u=b+-4|0;uc(m,u);b=u}u=c[a>>2]|0;c[a>>2]=c[m>>2];c[m>>2]=u;a=m+4|0;c[n>>2]=c[a>>2];c[a>>2]=b;a=c[p>>2]|0;c[p>>2]=c[f>>2];c[f>>2]=a;a=c[o>>2]|0;c[o>>2]=c[e>>2];c[e>>2]=a;vc(m);i=v;return}d=oe(4096)|0;if((k|0)!=(l|0)){if(!l)b=0;else{c[l>>2]=d;b=c[p>>2]|0}c[p>>2]=b+4;i=v;return}c[f>>2]=d;tc(a,f);g=c[n>>2]|0;e=c[g>>2]|0;f=g+4|0;c[n>>2]=f;b=c[p>>2]|0;do if((b|0)==(c[o>>2]|0)){h=c[a>>2]|0;if(f>>>0>h>>>0){u=f;a=((u-h>>2)+1|0)/-2|0;b=b-u|0;mf(g+(a+1<<2)|0,f|0,b|0)|0;b=g+(a+(b>>2)+1<<2)|0;c[p>>2]=b;c[n>>2]=(c[n>>2]|0)+(a<<2);break}else{b=b-h>>1;b=(b|0)==0?1:b;xc(u,b,b>>>2,a+12|0);c[s>>2]=c[n>>2];c[t>>2]=c[p>>2];c[q+0>>2]=c[s+0>>2];c[r+0>>2]=c[t+0>>2];wc(u,q,r);b=c[a>>2]|0;c[a>>2]=c[u>>2];c[u>>2]=b;b=u+4|0;a=c[n>>2]|0;c[n>>2]=c[b>>2];c[b>>2]=a;b=u+8|0;a=c[p>>2]|0;c[p>>2]=c[b>>2];c[b>>2]=a;b=u+12|0;a=c[o>>2]|0;c[o>>2]=c[b>>2];c[b>>2]=a;vc(u);b=c[p>>2]|0;break}}while(0);if(!b)b=0;else{c[b>>2]=e;b=c[p>>2]|0}c[p>>2]=b+4;i=v;return}function sc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=(c[b+16>>2]|0)+(c[b+20>>2]|0)|0;f=c[b+4>>2]|0;e=f+(d>>>10<<2)|0;if((c[b+8>>2]|0)==(f|0))d=0;else d=(c[e>>2]|0)+((d&1023)<<2)|0;c[a>>2]=e;c[a+4>>2]=d;return}function tc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=i;i=i+48|0;if((i|0)>=(j|0))ca();e=q+32|0;d=q+28|0;p=q+8|0;f=q+4|0;g=q;k=a+4|0;l=c[k>>2]|0;if((l|0)!=(c[a>>2]|0)){a=l;a=a+-4|0;b=c[b>>2]|0;c[a>>2]=b;a=c[k>>2]|0;a=a+-4|0;c[k>>2]=a;i=q;return}m=a+8|0;n=c[m>>2]|0;o=a+12|0;r=c[o>>2]|0;h=r;if(n>>>0<r>>>0){p=n;a=((h-p>>2)+1|0)/2|0;p=p-l|0;r=n+(a-(p>>2)<<2)|0;mf(r|0,l|0,p|0)|0;c[k>>2]=r;c[m>>2]=(c[m>>2]|0)+(a<<2);r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}else{r=h-l>>1;r=(r|0)==0?1:r;xc(p,r,(r+3|0)>>>2,a+12|0);c[f>>2]=c[k>>2];c[g>>2]=c[m>>2];c[d+0>>2]=c[f+0>>2];c[e+0>>2]=c[g+0>>2];wc(p,d,e);r=c[a>>2]|0;c[a>>2]=c[p>>2];c[p>>2]=r;r=p+4|0;a=c[k>>2]|0;c[k>>2]=c[r>>2];c[r>>2]=a;r=p+8|0;a=c[m>>2]|0;c[m>>2]=c[r>>2];c[r>>2]=a;r=p+12|0;a=c[o>>2]|0;c[o>>2]=c[r>>2];c[r>>2]=a;vc(p);r=c[k>>2]|0;r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}}function uc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=i;i=i+48|0;if((i|0)>=(j|0))ca();e=q+32|0;d=q+28|0;p=q+8|0;f=q+4|0;g=q;k=a+4|0;l=c[k>>2]|0;if((l|0)!=(c[a>>2]|0)){a=l;a=a+-4|0;b=c[b>>2]|0;c[a>>2]=b;a=c[k>>2]|0;a=a+-4|0;c[k>>2]=a;i=q;return}m=a+8|0;n=c[m>>2]|0;o=a+12|0;r=c[o>>2]|0;h=r;if(n>>>0<r>>>0){p=n;a=((h-p>>2)+1|0)/2|0;p=p-l|0;r=n+(a-(p>>2)<<2)|0;mf(r|0,l|0,p|0)|0;c[k>>2]=r;c[m>>2]=(c[m>>2]|0)+(a<<2);r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}else{r=h-l>>1;r=(r|0)==0?1:r;xc(p,r,(r+3|0)>>>2,c[a+16>>2]|0);c[f>>2]=c[k>>2];c[g>>2]=c[m>>2];c[d+0>>2]=c[f+0>>2];c[e+0>>2]=c[g+0>>2];wc(p,d,e);r=c[a>>2]|0;c[a>>2]=c[p>>2];c[p>>2]=r;r=p+4|0;a=c[k>>2]|0;c[k>>2]=c[r>>2];c[r>>2]=a;r=p+8|0;a=c[m>>2]|0;c[m>>2]=c[r>>2];c[r>>2]=a;r=p+12|0;a=c[o>>2]|0;c[o>>2]=c[r>>2];c[r>>2]=a;vc(p);r=c[k>>2]|0;r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}}function vc(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;b=c[a+4>>2]|0;d=a+8|0;e=c[d>>2]|0;if((e|0)!=(b|0))c[d>>2]=e+(~((e+-4+(0-b)|0)>>>2)<<2);b=c[a>>2]|0;if(!b){i=f;return}pe(b);i=f;return}function wc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;j=i;h=c[b>>2]|0;g=c[d>>2]|0;if((h|0)==(g|0)){i=j;return}e=a+8|0;f=((g+-4+(0-h)|0)>>>2)+1|0;d=h;a=c[e>>2]|0;do{if(!a)a=0;else{c[a>>2]=c[d>>2];a=c[e>>2]|0}a=a+4|0;c[e>>2]=a;d=d+4|0}while((d|0)!=(g|0));c[b>>2]=h+(f<<2);i=j;return}function xc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;f=a+12|0;c[f>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=oe(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[f>>2]=e+(b<<2);i=g;return}function yc(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;b=c[a+4>>2]|0;d=a+8|0;e=c[d>>2]|0;if((e|0)!=(b|0))c[d>>2]=e+(~((e+-4+(0-b)|0)>>>2)<<2);b=c[a>>2]|0;if(!b){i=f;return}pe(b);i=f;return}function zc(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;b=c[a+4>>2]|0;d=a+8|0;e=c[d>>2]|0;if((e|0)!=(b|0))c[d>>2]=e+(~((e+-4+(0-b)|0)>>>2)<<2);b=c[a>>2]|0;if(!b){i=f;return}pe(b);i=f;return}function Ac(a){a=a|0;var b=0,d=0;d=i;b=c[a+4>>2]|0;if(!b){while(1){b=c[a+8>>2]|0;if((c[b>>2]|0)==(a|0))break;else a=b}i=d;return b|0}else{while(1){a=c[b>>2]|0;if(!a)break;else b=a}i=d;return b|0}return 0}function Bc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();g=f;e=b+4|0;Cc(g,b,d,c[b+4>>2]|0,e);b=c[g>>2]|0;if((b|0)!=(e|0)?(c[d>>2]|0)>=(c[b+16>>2]|0):0){c[a>>2]=b;i=f;return}c[a>>2]=e;i=f;return}function Cc(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;a:do if(e){d=c[d>>2]|0;while(1){b=e;while(1){if((c[b+16>>2]|0)>=(d|0))break;b=c[b+4>>2]|0;if(!b)break a}e=c[b>>2]|0;if(!e){f=b;break}else f=b}}while(0);c[a>>2]=f;i=g;return}function Dc(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=c[a+4>>2]|0;if(!a){d=0;i=e;return d|0}d=c[b>>2]|0;while(1){b=c[a+16>>2]|0;if((d|0)>=(b|0)){if((b|0)>=(d|0)){a=1;b=8;break}a=a+4|0}a=c[a>>2]|0;if(!a){a=0;b=8;break}}if((b|0)==8){i=e;return a|0}return 0}function Ec(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;e=c[a+4>>2]|0;if(!e){f=a+4|0;c[b>>2]=f;b=f;i=g;return b|0}f=c[d>>2]|0;while(1){d=c[e+16>>2]|0;if(f>>>0<d>>>0){d=c[e>>2]|0;if(!d){a=5;break}else{e=d;continue}}if(d>>>0>=f>>>0){a=9;break}d=e+4|0;a=c[d>>2]|0;if(!a){a=8;break}else e=a}if((a|0)==5){c[b>>2]=e;b=e;i=g;return b|0}else if((a|0)==8){c[b>>2]=e;b=d;i=g;return b|0}else if((a|0)==9){c[b>>2]=e;i=g;return b|0}return 0}function Fc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=oe(24)|0;c[f+16>>2]=c[d>>2];c[f+20>>2]=0;c[a>>2]=f;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=257;i=e;return}function Gc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[c[a>>2]>>2]|0;if(b){c[a>>2]=b;e=c[d>>2]|0}nc(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;i=f;return}function Hc(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=c[a+4>>2]|0;if(!a){d=0;i=e;return d|0}d=c[b>>2]|0;while(1){b=c[a+16>>2]|0;if(d>>>0>=b>>>0){if(b>>>0>=d>>>0){a=1;b=8;break}a=a+4|0}a=c[a>>2]|0;if(!a){a=0;b=8;break}}if((b|0)==8){i=e;return a|0}return 0}function Ic(a){a=a|0;var b=0;b=i;Jc(a,c[a+4>>2]|0);i=b;return}function Jc(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){i=d;return}else{Jc(a,c[b>>2]|0);Jc(a,c[b+4>>2]|0);pe(b);i=d;return}}function Kc(a){a=a|0;var b=0;b=i;Lc(a,c[a+4>>2]|0);i=b;return}function Lc(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){i=d;return}else{Lc(a,c[b>>2]|0);Lc(a,c[b+4>>2]|0);pe(b);i=d;return}}function Mc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=i;while(1){d=c[a+8>>2]|0;e=a+12|0;if(!d)c[e>>2]=b;else{c[e>>2]=d;Mc(d,b)}if(Pc(a)|0){a=12;break}d=Fb(a)|0;if(d){a=7;break}b=Rc(a)|0;if(!b){a=12;break}a=c[b+24>>2]|0;b=a}if((a|0)==7){b=c[d+24>>2]|0;d=d+28|0;if((b|0)==(d|0)){i=f;return}do{Mc(c[b+20>>2]|0,c[e>>2]|0);b=Ac(b)|0}while((b|0)!=(d|0));i=f;return}else if((a|0)==12){i=f;return}}function Nc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+32|0;if((i|0)>=(j|0))ca();r=t+8|0;o=t+4|0;s=t;c[r+4>>2]=0;c[r+8>>2]=0;c[r>>2]=r+4;$c(d,r);if(!b){Od(r);i=t;return}else{l=e;d=b}a:while(1){n=f+1|0;while(1){g=Pc(d)|0;if(g)break;g=Fb(d)|0;if(g){b=c[g+24>>2]|0;k=g+28|0;d=g+8|0;if((b|0)!=(k|0)){g=g+36|0;do{Nc(c[b+20>>2]|0,c[d>>2]|0,(c[g>>2]|0)!=0?0:l,n);b=Ac(b)|0}while((b|0)!=(k|0))}}else{e=Rc(d)|0;if(!e){e=37;break a}d=c[e+24>>2]|0;Nc(d,d,e,n);d=e+8|0}d=c[d>>2]|0;if(!d){e=37;break a}}k=c[g+20>>2]|0;b=(c[k+60>>2]|0)==0;m=b?l:0;d=c[g+8>>2]|0;if(!d){e=19;break}if(!b){n=f;l=m;f=n;continue}if(!(f>>>0<20?(c[k+32>>2]|0)==2:0)){n=f;l=m;f=n;continue}e=c[k+24>>2]|0;l=k+28|0;b=(e|0)==(l|0);if(b){l=m;f=n;continue}else{f=e;g=0;h=0}while(1){c[o>>2]=c[f+16>>2];k=c[(c[f+20>>2]|0)+4>>2]|0;if((k|0)==1){k=g|(qc(r,o)|0)==0;h=1}else if(!k)k=g;else k=1;f=Ac(f)|0;if((f|0)==(l|0))break;else g=k}if(k|h^1|b){l=m;f=n;continue}while(1){b=c[e+20>>2]|0;f=b+4|0;g=c[f>>2]|0;if((g|0)==1){c[f>>2]=0;f=Fb(c[b>>2]|0)|0;if(f){k=f+36|0;c[k>>2]=(c[k>>2]|0)+-1}}else if(!g)c[f>>2]=3;else{e=16;break a}e=Ac(e)|0;if((e|0)==(l|0)){l=m;f=n;continue a}}}if((e|0)==16)ya(1008,120,1147,1040);else if((e|0)==19){d=c[k+24>>2]|0;h=k+28|0;if((d|0)==(h|0)){Od(r);i=t;return}k=(m|0)==0;g=m+12|0;do{c[s>>2]=c[d+16>>2];f=c[d+20>>2]|0;e=f+4|0;b=c[e>>2]|0;do if(b){if(qc(r,s)|0){c[e>>2]=0;e=Fb(c[f>>2]|0)|0;if(!e)break;o=e+36|0;c[o>>2]=(c[o>>2]|0)+-1;break}if((!((b|0)!=1|k)?(p=c[f>>2]|0,(c[g>>2]|0)==(c[p+12>>2]|0)):0)?(a[f+8>>0]=0,q=Fb(p)|0,(q|0)!=0):0){o=q+36|0;c[o>>2]=(c[o>>2]|0)+-1}}while(0);d=Ac(d)|0}while((d|0)!=(h|0));Od(r);i=t;return}else if((e|0)==37){Od(r);i=t;return}}function Oc(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=i;i=i+32|0;if((i|0)>=(j|0))ca();t=A+16|0;u=A+12|0;v=A+8|0;w=A+4|0;x=A;y=b+4|0;e=c[y>>2]|0;z=(e|0)==0;if(z){e=oe(24)|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[y>>2]=e}a:do if(d){q=e+20|0;r=e+16|0;s=e+4|0;k=d;b:while(1){f=Pc(k)|0;do if(f){d=k+8|0;o=Fb(c[d>>2]|0)|0;p=(o|0)!=0;if(p?(c[o+36>>2]|0)!=0:0){c[t>>2]=o;Tc(e,t)}n=f+20|0;if(c[(c[n>>2]|0)+60>>2]|0){c[u>>2]=0;Tc(e,u)}if(p){if(a[o+40>>0]|0){c[v>>2]=0;Tc(e,v)}g=c[o+24>>2]|0;h=o+28|0;if((g|0)!=(h|0))do{Oc(b,c[g+20>>2]|0);g=Ac(g)|0}while((g|0)!=(h|0))}f=c[n>>2]|0;h=c[f+24>>2]|0;m=f+28|0;if((h|0)!=(m|0))do{k=c[h+20>>2]|0;do if(((c[k+4>>2]|0)+-1|0)>>>0<2){g=c[q>>2]|0;if(!g)break b;l=c[k>>2]|0;g=g+-1+(c[r>>2]|0)|0;k=k+8|0;if((l|0)!=(c[(c[(c[s>>2]|0)+(g>>>10<<2)>>2]|0)+((g&1023)<<2)>>2]|0)?(a[k>>0]|0)!=0:0){a[(Qc(l)|0)+20>>0]=1;break}a[k>>0]=0}while(0);h=Ac(h)|0}while((h|0)!=(m|0));if(p?(a[o+40>>0]|0)!=0:0){Sc(e);f=c[n>>2]|0}if(c[f+60>>2]|0)Sc(e);if(p){if(c[o+36>>2]|0)Sc(e);d=o+8|0}}else{f=Fb(k)|0;if(!f){d=Rc(k)|0;if(!d)break a;c[x>>2]=d;Tc(e,x);Oc(b,c[d+24>>2]|0);Sc(e);d=k+8|0;break}h=f+36|0;if(c[h>>2]|0){c[w>>2]=f;Tc(e,w)}d=c[f+24>>2]|0;g=f+28|0;if((d|0)!=(g|0)){f=d;do{Oc(b,c[f+20>>2]|0);f=Ac(f)|0}while((f|0)!=(g|0))}if(c[h>>2]|0)Sc(e);d=k+8|0}while(0);k=c[d>>2]|0;if(!k)break a}ya(960,120,1219,984)}while(0);if(!z){i=A;return}e=c[y>>2]|0;if(!e){i=A;return}Xd(e);pe(e);i=A;return}function Pc(a){a=a|0;var b=0;b=i;if(!((a|0)!=0?(c[a+16>>2]|0)==0:0))a=0;i=b;return a|0}function Qc(a){a=a|0;var b=0;b=i;if((Fb(a)|0)==0?(Rc(a)|0)==0:0){a=0;i=b;return a|0}i=b;return a|0}function Rc(a){a=a|0;var b=0;b=i;if(!((a|0)!=0?(c[a+16>>2]|0)==2:0))a=0;i=b;return a|0}function Sc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;g=i;e=a+20|0;d=(c[e>>2]|0)+-1|0;c[e>>2]=d;e=a+8|0;f=c[e>>2]|0;b=c[a+4>>2]|0;if((f|0)==(b|0))b=0;else b=(f-b<<8)+-1|0;if((b-(c[a+16>>2]|0)-d|0)>>>0<=2047){i=g;return}pe(c[f+-4>>2]|0);f=c[e>>2]|0;a=f+-4|0;c[e>>2]=f+(~((a+(0-a)|0)>>>2)<<2);i=g;return}function Tc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+16|0;if((i|0)>=(j|0))ca();f=g;d=c[a+8>>2]|0;e=c[a+4>>2]|0;if((d|0)==(e|0))d=0;else d=(d-e<<8)+-1|0;e=a+20|0;if((d-(c[a+16>>2]|0)|0)==(c[e>>2]|0))Uc(a);Vc(f,a);d=c[f+4>>2]|0;if(!d){b=c[e>>2]|0;b=b+1|0;c[e>>2]=b;i=g;return}c[d>>2]=c[b>>2];b=c[e>>2]|0;b=b+1|0;c[e>>2]=b;i=g;return}function Uc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+64|0;if((i|0)>=(j|0))ca();r=v+8|0;q=v+32|0;u=v+36|0;s=v+56|0;t=v+4|0;f=v;m=v+12|0;b=a+16|0;d=c[b>>2]|0;if(d>>>0>1023){c[b>>2]=d+-1024;g=a+4|0;h=c[g>>2]|0;k=c[h>>2]|0;d=h+4|0;c[g>>2]=d;l=a+8|0;b=c[l>>2]|0;e=a+12|0;do if((b|0)==(c[e>>2]|0)){f=c[a>>2]|0;if(d>>>0>f>>>0){u=d;a=((u-f>>2)+1|0)/-2|0;b=b-u|0;mf(h+(a+1<<2)|0,d|0,b|0)|0;b=h+(a+(b>>2)+1<<2)|0;c[l>>2]=b;c[g>>2]=(c[g>>2]|0)+(a<<2);break}else{b=b-f>>1;b=(b|0)==0?1:b;_c(u,b,b>>>2,a+12|0);c[s>>2]=c[g>>2];c[t>>2]=c[l>>2];c[q+0>>2]=c[s+0>>2];c[r+0>>2]=c[t+0>>2];Zc(u,q,r);b=c[a>>2]|0;c[a>>2]=c[u>>2];c[u>>2]=b;b=u+4|0;a=c[g>>2]|0;c[g>>2]=c[b>>2];c[b>>2]=a;b=u+8|0;a=c[l>>2]|0;c[l>>2]=c[b>>2];c[b>>2]=a;b=u+12|0;a=c[e>>2]|0;c[e>>2]=c[b>>2];c[b>>2]=a;Yc(u);b=c[l>>2]|0;break}}while(0);if(!b)b=0;else{c[b>>2]=k;b=c[l>>2]|0}c[l>>2]=b+4;i=v;return}p=a+8|0;l=c[p>>2]|0;n=a+4|0;h=l-(c[n>>2]|0)>>2;o=a+12|0;k=c[o>>2]|0;g=k-(c[a>>2]|0)|0;if(h>>>0>=g>>2>>>0){g=g>>1;_c(m,(g|0)==0?1:g,h,a+12|0);g=oe(4096)|0;f=m+8|0;b=c[f>>2]|0;e=m+12|0;do if((b|0)==(c[e>>2]|0)){l=m+4|0;k=c[l>>2]|0;h=c[m>>2]|0;if(k>>>0>h>>>0){s=k;t=((s-h>>2)+1|0)/-2|0;u=k+(t<<2)|0;b=b-s|0;mf(u|0,k|0,b|0)|0;b=k+(t+(b>>2)<<2)|0;c[f>>2]=b;c[l>>2]=u;break}else{d=b-h>>1;d=(d|0)==0?1:d;_c(u,d,d>>>2,c[m+16>>2]|0);c[s>>2]=k;c[t>>2]=b;c[q+0>>2]=c[s+0>>2];c[r+0>>2]=c[t+0>>2];Zc(u,q,r);c[m>>2]=c[u>>2];c[u>>2]=h;s=u+4|0;c[l>>2]=c[s>>2];c[s>>2]=k;s=u+8|0;t=c[s>>2]|0;c[f>>2]=t;c[s>>2]=b;s=u+12|0;c[e>>2]=c[s>>2];c[s>>2]=b;Yc(u);b=t;break}}while(0);if(!b)b=0;else c[b>>2]=g;c[f>>2]=b+4;b=c[p>>2]|0;while(1){if((b|0)==(c[n>>2]|0))break;u=b+-4|0;Xc(m,u);b=u}u=c[a>>2]|0;c[a>>2]=c[m>>2];c[m>>2]=u;a=m+4|0;c[n>>2]=c[a>>2];c[a>>2]=b;a=c[p>>2]|0;c[p>>2]=c[f>>2];c[f>>2]=a;a=c[o>>2]|0;c[o>>2]=c[e>>2];c[e>>2]=a;Yc(m);i=v;return}d=oe(4096)|0;if((k|0)!=(l|0)){if(!l)b=0;else{c[l>>2]=d;b=c[p>>2]|0}c[p>>2]=b+4;i=v;return}c[f>>2]=d;Wc(a,f);g=c[n>>2]|0;e=c[g>>2]|0;f=g+4|0;c[n>>2]=f;b=c[p>>2]|0;do if((b|0)==(c[o>>2]|0)){h=c[a>>2]|0;if(f>>>0>h>>>0){u=f;a=((u-h>>2)+1|0)/-2|0;b=b-u|0;mf(g+(a+1<<2)|0,f|0,b|0)|0;b=g+(a+(b>>2)+1<<2)|0;c[p>>2]=b;c[n>>2]=(c[n>>2]|0)+(a<<2);break}else{b=b-h>>1;b=(b|0)==0?1:b;_c(u,b,b>>>2,a+12|0);c[s>>2]=c[n>>2];c[t>>2]=c[p>>2];c[q+0>>2]=c[s+0>>2];c[r+0>>2]=c[t+0>>2];Zc(u,q,r);b=c[a>>2]|0;c[a>>2]=c[u>>2];c[u>>2]=b;b=u+4|0;a=c[n>>2]|0;c[n>>2]=c[b>>2];c[b>>2]=a;b=u+8|0;a=c[p>>2]|0;c[p>>2]=c[b>>2];c[b>>2]=a;b=u+12|0;a=c[o>>2]|0;c[o>>2]=c[b>>2];c[b>>2]=a;Yc(u);b=c[p>>2]|0;break}}while(0);if(!b)b=0;else{c[b>>2]=e;b=c[p>>2]|0}c[p>>2]=b+4;i=v;return}function Vc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=(c[b+16>>2]|0)+(c[b+20>>2]|0)|0;f=c[b+4>>2]|0;e=f+(d>>>10<<2)|0;if((c[b+8>>2]|0)==(f|0))d=0;else d=(c[e>>2]|0)+((d&1023)<<2)|0;c[a>>2]=e;c[a+4>>2]=d;return}function Wc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=i;i=i+48|0;if((i|0)>=(j|0))ca();e=q+32|0;d=q+28|0;p=q+8|0;f=q+4|0;g=q;k=a+4|0;l=c[k>>2]|0;if((l|0)!=(c[a>>2]|0)){a=l;a=a+-4|0;b=c[b>>2]|0;c[a>>2]=b;a=c[k>>2]|0;a=a+-4|0;c[k>>2]=a;i=q;return}m=a+8|0;n=c[m>>2]|0;o=a+12|0;r=c[o>>2]|0;h=r;if(n>>>0<r>>>0){p=n;a=((h-p>>2)+1|0)/2|0;p=p-l|0;r=n+(a-(p>>2)<<2)|0;mf(r|0,l|0,p|0)|0;c[k>>2]=r;c[m>>2]=(c[m>>2]|0)+(a<<2);r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}else{r=h-l>>1;r=(r|0)==0?1:r;_c(p,r,(r+3|0)>>>2,a+12|0);c[f>>2]=c[k>>2];c[g>>2]=c[m>>2];c[d+0>>2]=c[f+0>>2];c[e+0>>2]=c[g+0>>2];Zc(p,d,e);r=c[a>>2]|0;c[a>>2]=c[p>>2];c[p>>2]=r;r=p+4|0;a=c[k>>2]|0;c[k>>2]=c[r>>2];c[r>>2]=a;r=p+8|0;a=c[m>>2]|0;c[m>>2]=c[r>>2];c[r>>2]=a;r=p+12|0;a=c[o>>2]|0;c[o>>2]=c[r>>2];c[r>>2]=a;Yc(p);r=c[k>>2]|0;r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}}function Xc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=i;i=i+48|0;if((i|0)>=(j|0))ca();e=q+32|0;d=q+28|0;p=q+8|0;f=q+4|0;g=q;k=a+4|0;l=c[k>>2]|0;if((l|0)!=(c[a>>2]|0)){a=l;a=a+-4|0;b=c[b>>2]|0;c[a>>2]=b;a=c[k>>2]|0;a=a+-4|0;c[k>>2]=a;i=q;return}m=a+8|0;n=c[m>>2]|0;o=a+12|0;r=c[o>>2]|0;h=r;if(n>>>0<r>>>0){p=n;a=((h-p>>2)+1|0)/2|0;p=p-l|0;r=n+(a-(p>>2)<<2)|0;mf(r|0,l|0,p|0)|0;c[k>>2]=r;c[m>>2]=(c[m>>2]|0)+(a<<2);r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}else{r=h-l>>1;r=(r|0)==0?1:r;_c(p,r,(r+3|0)>>>2,c[a+16>>2]|0);c[f>>2]=c[k>>2];c[g>>2]=c[m>>2];c[d+0>>2]=c[f+0>>2];c[e+0>>2]=c[g+0>>2];Zc(p,d,e);r=c[a>>2]|0;c[a>>2]=c[p>>2];c[p>>2]=r;r=p+4|0;a=c[k>>2]|0;c[k>>2]=c[r>>2];c[r>>2]=a;r=p+8|0;a=c[m>>2]|0;c[m>>2]=c[r>>2];c[r>>2]=a;r=p+12|0;a=c[o>>2]|0;c[o>>2]=c[r>>2];c[r>>2]=a;Yc(p);r=c[k>>2]|0;r=r+-4|0;a=c[b>>2]|0;c[r>>2]=a;r=c[k>>2]|0;r=r+-4|0;c[k>>2]=r;i=q;return}}function Yc(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;b=c[a+4>>2]|0;d=a+8|0;e=c[d>>2]|0;if((e|0)!=(b|0))c[d>>2]=e+(~((e+-4+(0-b)|0)>>>2)<<2);b=c[a>>2]|0;if(!b){i=f;return}pe(b);i=f;return}function Zc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;j=i;h=c[b>>2]|0;g=c[d>>2]|0;if((h|0)==(g|0)){i=j;return}e=a+8|0;f=((g+-4+(0-h)|0)>>>2)+1|0;d=h;a=c[e>>2]|0;do{if(!a)a=0;else{c[a>>2]=c[d>>2];a=c[e>>2]|0}a=a+4|0;c[e>>2]=a;d=d+4|0}while((d|0)!=(g|0));c[b>>2]=h+(f<<2);i=j;return}function _c(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;f=a+12|0;c[f>>2]=0;c[a+16>>2]=e;if(!b)e=0;else e=oe(b<<2)|0;c[a>>2]=e;d=e+(d<<2)|0;c[a+8>>2]=d;c[a+4>>2]=d;c[f>>2]=e+(b<<2);i=g;return}function $c(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();d=Pc(a)|0;if(d){jc(f,b,d+20|0);i=f;return}e=Fb(a)|0;if(!e){d=Rc(a)|0;if(!d){i=f;return}$c(c[d+24>>2]|0,b);i=f;return}else{d=c[e+24>>2]|0;a=e+28|0;if((d|0)!=(a|0))do{$c(c[d+20>>2]|0,b);d=Ac(d)|0}while((d|0)!=(a|0));$c(c[e+8>>2]|0,b);i=f;return}}function ad(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;y=i;i=i+64|0;if((i|0)>=(j|0))ca();s=y+40|0;m=y+24|0;k=y+12|0;h=y+16|0;w=y+48|0;x=y;r=y+20|0;o=y+32|0;u=y+28|0;c[w+4>>2]=0;p=w+8|0;c[p>>2]=0;t=w+4|0;c[w>>2]=t;c[x+4>>2]=0;q=x+8|0;c[q>>2]=0;g=x+4|0;c[x>>2]=g;l=c[e>>2]|0;v=e+4|0;if((l|0)!=(v|0)){do{c[k>>2]=g;c[s+0>>2]=c[k+0>>2];Qd(h,x,s,l+16|0);l=Ac(l)|0}while((l|0)!=(v|0));if(c[q>>2]|0)do{l=c[x>>2]|0;c[r>>2]=c[l+16>>2];c[m>>2]=l;c[s+0>>2]=c[m+0>>2];sd(o,x,s);if((qc(w,r)|0)==0?(jc(s,w,r),qd(d,r)|0,l=c[r>>2]|0,n=c[l+12>>2]|0,(n|0)!=(l+16|0)):0){l=n;do{jc(s,x,l+16|0);l=Ac(l)|0}while((l|0)!=((c[r>>2]|0)+16|0))}}while((c[q>>2]|0)!=0)}if(!(c[p>>2]|0))ya(1064,120,647,1088);h=c[w>>2]|0;if((h|0)!=(t|0))do{k=c[h+16>>2]|0;g=c[k>>2]|0;k=k+4|0;if((g|0)!=(k|0))do{c[u>>2]=c[g+16>>2];if(!(qc(w,u)|0))jc(s,f,u);g=Ac(g)|0}while((g|0)!=(k|0));h=Ac(h)|0}while((h|0)!=(t|0));k=oe(28)|0;c[k+4>>2]=-1;c[k+8>>2]=0;c[k+16>>2]=2;a[k+20>>0]=0;c[k>>2]=856;l=k+24|0;c[l>>2]=0;ed(b,k);g=c[e>>2]|0;if((g|0)!=(v|0))do{fd(c[g+16>>2]|0,2,k,w);g=Ac(g)|0}while((g|0)!=(v|0));g=c[f>>2]|0;h=f+4|0;if((g|0)==(h|0)){b=Qb(b,w,e)|0;c[l>>2]=b;Od(x);Od(w);i=y;return k|0}do{fd(c[g+16>>2]|0,1,k,w);g=Ac(g)|0}while((g|0)!=(h|0));b=Qb(b,w,e)|0;c[l>>2]=b;Od(x);Od(w);i=y;return k|0}function bd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;if((i|0)>=(j|0))ca();g=h+12|0;d=h;e=zd(a,g,b)|0;f=c[e>>2]|0;if(f){a=f;a=a+20|0;i=h;return a|0}Ad(d,a,b);b=c[d>>2]|0;c[d>>2]=0;Bd(a,c[g>>2]|0,e,b);a=b;a=a+20|0;i=h;return a|0}function cd(a){a=a|0;var b=0;b=i;dd(a,c[a+4>>2]|0);i=b;return}function dd(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){i=d;return}else{dd(a,c[b>>2]|0);dd(a,c[b+4>>2]|0);Od(b+20|0);pe(b);i=d;return}}function ed(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;if((i|0)>=(j|0))ca();e=d;c[e>>2]=b;a=c[a>>2]|0;g=a+60|0;f=c[g>>2]|0;c[g>>2]=f+1;c[b+4>>2]=f;Tc(a+24|0,e);i=d;return}function fd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,k=0,l=0,m=0;m=i;i=i+16|0;if((i|0)>=(j|0))ca();h=m+8|0;k=m+4|0;l=m;c[k>>2]=a;f=c[a+12>>2]|0;if((f|0)==(a+16|0)){i=m;return}do{g=c[f+16>>2]|0;c[l>>2]=g;if(!(qc(e,l)|0))f=Ac(f)|0;else{a=c[(Bb(g,k)|0)>>2]|0;c[a>>2]=d;c[a+4>>2]=b;g=Fb(d)|0;if(g){g=g+36|0;c[g>>2]=(c[g>>2]|0)+1}f=Ac(f)|0;g=c[k>>2]|0;qd(g+12|0,l)|0;jc(h,g+36|0,l);g=c[l>>2]|0;ld(g,k)|0;c[(Bb(g+24|0,k)|0)>>2]=a;a=c[k>>2]|0}}while((f|0)!=(a+16|0));i=m;return}function gd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;if((i|0)>=(j|0))ca();g=h+12|0;d=h;e=id(a,g,b)|0;f=c[e>>2]|0;if(f){a=f;a=a+20|0;i=h;return a|0}jd(d,a,b);b=c[d>>2]|0;c[d>>2]=0;kd(a,c[g>>2]|0,e,b);a=b;a=a+20|0;i=h;return a|0}function hd(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=c[a+4>>2]|0;if(!a){d=0;i=e;return d|0}d=c[b>>2]|0;while(1){b=c[a+16>>2]|0;if(d>>>0>=b>>>0){if(b>>>0>=d>>>0){a=1;b=8;break}a=a+4|0}a=c[a>>2]|0;if(!a){a=0;b=8;break}}if((b|0)==8){i=e;return a|0}return 0}function id(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;e=c[a+4>>2]|0;if(!e){f=a+4|0;c[b>>2]=f;b=f;i=g;return b|0}f=c[d>>2]|0;while(1){d=c[e+16>>2]|0;if((f|0)<(d|0)){d=c[e>>2]|0;if(!d){a=5;break}else{e=d;continue}}if((d|0)>=(f|0)){a=9;break}d=e+4|0;a=c[d>>2]|0;if(!a){a=8;break}else e=a}if((a|0)==5){c[b>>2]=e;b=e;i=g;return b|0}else if((a|0)==8){c[b>>2]=e;b=d;i=g;return b|0}else if((a|0)==9){c[b>>2]=e;i=g;return b|0}return 0}function jd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=oe(24)|0;c[f+16>>2]=c[d>>2];c[f+20>>2]=0;c[a>>2]=f;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=257;i=e;return}function kd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[c[a>>2]>>2]|0;if(b){c[a>>2]=b;e=c[d>>2]|0}nc(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;i=f;return}function ld(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();d=f+12|0;g=f+8|0;e=f+4|0;md(g,a,b);b=c[g>>2]|0;if((b|0)==(a+4|0)){g=0;i=f;return g|0}c[e>>2]=b;c[d+0>>2]=c[e+0>>2];nd(f,a,d);g=1;i=f;return g|0}function md(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();g=f;e=b+4|0;pd(g,b,d,c[b+4>>2]|0,e);b=c[g>>2]|0;if((b|0)!=(e|0)?(c[d>>2]|0)>>>0>=(c[b+16>>2]|0)>>>0:0){c[a>>2]=b;i=f;return}c[a>>2]=e;i=f;return}function nd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;d=c[d>>2]|0;e=Ac(d)|0;c[a>>2]=e;if((c[b>>2]|0)==(d|0))c[b>>2]=e;a=b+8|0;c[a>>2]=(c[a>>2]|0)+-1;od(c[b+4>>2]|0,d);pe(d);i=f;return}function od(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=i;e=c[d>>2]|0;if(e)if(!(c[d+4>>2]|0))n=d;else{n=Ac(d)|0;e=c[n>>2]|0}else{e=0;n=d}m=n+4|0;k=c[((e|0)==0?m:n)>>2]|0;l=(k|0)==0;g=n+8|0;if(!l)c[k+8>>2]=c[g>>2];h=c[g>>2]|0;if((c[h>>2]|0)==(n|0)){c[h>>2]=k;if((n|0)==(b|0)){e=k;f=0}else{e=b;f=c[(c[g>>2]|0)+4>>2]|0}}else{c[h+4>>2]=k;e=b;f=c[c[g>>2]>>2]|0}b=n+12|0;j=(a[b>>0]|0)==0;if((n|0)!=(d|0)){p=d+8|0;h=c[p>>2]|0;c[g>>2]=h;if((c[c[p>>2]>>2]|0)==(d|0))c[h>>2]=n;else c[h+4>>2]=n;h=c[d>>2]|0;c[n>>2]=h;c[h+8>>2]=n;h=c[d+4>>2]|0;c[m>>2]=h;if(h)c[h+8>>2]=n;a[b>>0]=a[d+12>>0]|0;e=(e|0)==(d|0)?n:e}if(j|(e|0)==0){i=o;return}if(l)h=e;else{a[k+12>>0]=1;i=o;return}while(1){g=c[f+8>>2]|0;e=f+12|0;b=(a[e>>0]|0)!=0;if((c[g>>2]|0)==(f|0)){if(!b){a[e>>0]=1;a[g+12>>0]=0;pc(g);p=c[f+4>>2]|0;h=(h|0)==(p|0)?f:h;f=c[p>>2]|0}e=c[f>>2]|0;g=(e|0)==0;if(!g?(a[e+12>>0]|0)==0:0){j=46;break}p=c[f+4>>2]|0;if((p|0)!=0?(a[p+12>>0]|0)==0:0){j=45;break}a[f+12>>0]=0;e=c[f+8>>2]|0;f=e+12|0;if((a[f>>0]|0)==0|(e|0)==(h|0)){j=42;break}p=c[e+8>>2]|0;f=h;e=(c[p>>2]|0)==(e|0)?p+4|0:p}else{if(b)b=h;else{a[e>>0]=1;a[g+12>>0]=0;oc(g);p=c[f>>2]|0;b=(h|0)==(p|0)?f:h;f=c[p+4>>2]|0}h=c[f>>2]|0;if((h|0)!=0?(a[h+12>>0]|0)==0:0){j=31;break}e=c[f+4>>2]|0;if((e|0)!=0?(a[e+12>>0]|0)==0:0){j=32;break}a[f+12>>0]=0;e=c[f+8>>2]|0;if((e|0)==(b|0)){e=b;j=29;break}if(!(a[e+12>>0]|0)){j=29;break}p=c[e+8>>2]|0;f=b;e=(c[p>>2]|0)==(e|0)?p+4|0:p}h=f;f=c[e>>2]|0}if((j|0)==29){a[e+12>>0]=1;i=o;return}else if((j|0)==31){e=c[f+4>>2]|0;if(!e)j=33;else j=32}else if((j|0)==42){a[f>>0]=1;i=o;return}else if((j|0)==45)if(g)j=47;else j=46;if((j|0)==32)if(!(a[e+12>>0]|0))j=34;else j=33;else if((j|0)==46)if(!(a[e+12>>0]|0))j=48;else j=47;if((j|0)==33){a[h+12>>0]=1;a[f+12>>0]=0;pc(f);f=c[f+8>>2]|0;e=c[f+4>>2]|0;j=34}else if((j|0)==47){a[(c[f+4>>2]|0)+12>>0]=1;a[f+12>>0]=0;oc(f);f=c[f+8>>2]|0;e=c[f>>2]|0;j=48}if((j|0)==34){p=c[f+8>>2]|0;d=p+12|0;a[f+12>>0]=a[d>>0]|0;a[d>>0]=1;a[e+12>>0]=1;oc(p);i=o;return}else if((j|0)==48){p=c[f+8>>2]|0;d=p+12|0;a[f+12>>0]=a[d>>0]|0;a[d>>0]=1;a[e+12>>0]=1;pc(p);i=o;return}}function pd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;a:do if(e){d=c[d>>2]|0;while(1){b=e;while(1){if((c[b+16>>2]|0)>>>0>=d>>>0)break;b=c[b+4>>2]|0;if(!b)break a}e=c[b>>2]|0;if(!e){f=b;break}else f=b}}while(0);c[a>>2]=f;i=g;return}function qd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();d=f+12|0;g=f+8|0;e=f+4|0;rd(g,a,b);b=c[g>>2]|0;if((b|0)==(a+4|0)){g=0;i=f;return g|0}c[e>>2]=b;c[d+0>>2]=c[e+0>>2];sd(f,a,d);g=1;i=f;return g|0}function rd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();g=f;e=b+4|0;td(g,b,d,c[b+4>>2]|0,e);b=c[g>>2]|0;if((b|0)!=(e|0)?(c[d>>2]|0)>>>0>=(c[b+16>>2]|0)>>>0:0){c[a>>2]=b;i=f;return}c[a>>2]=e;i=f;return}function sd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;d=c[d>>2]|0;e=Ac(d)|0;c[a>>2]=e;if((c[b>>2]|0)==(d|0))c[b>>2]=e;a=b+8|0;c[a>>2]=(c[a>>2]|0)+-1;od(c[b+4>>2]|0,d);pe(d);i=f;return}function td(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;a:do if(e){d=c[d>>2]|0;while(1){b=e;while(1){if((c[b+16>>2]|0)>>>0>=d>>>0)break;b=c[b+4>>2]|0;if(!b)break a}e=c[b>>2]|0;if(!e){f=b;break}else f=b}}while(0);c[a>>2]=f;i=g;return}function ud(b){b=b|0;c[b+4>>2]=-1;c[b+8>>2]=0;c[b+16>>2]=1;a[b+20>>0]=0;c[b>>2]=752;c[b+28>>2]=0;c[b+32>>2]=0;c[b+24>>2]=b+28;c[b+36>>2]=0;a[b+40>>0]=0;return}function vd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();d=f+12|0;g=f+8|0;e=f+4|0;wd(g,a,b);b=c[g>>2]|0;if((b|0)==(a+4|0)){g=0;i=f;return g|0}c[e>>2]=b;c[d+0>>2]=c[e+0>>2];xd(f,a,d);g=1;i=f;return g|0}function wd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();g=f;e=b+4|0;yd(g,b,d,c[b+4>>2]|0,e);b=c[g>>2]|0;if((b|0)!=(e|0)?(c[d>>2]|0)>>>0>=(c[b+16>>2]|0)>>>0:0){c[a>>2]=b;i=f;return}c[a>>2]=e;i=f;return}function xd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;d=c[d>>2]|0;e=Ac(d)|0;c[a>>2]=e;if((c[b>>2]|0)==(d|0))c[b>>2]=e;a=b+8|0;c[a>>2]=(c[a>>2]|0)+-1;od(c[b+4>>2]|0,d);Od(d+20|0);pe(d);i=f;return}function yd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;a:do if(e){d=c[d>>2]|0;while(1){b=e;while(1){if((c[b+16>>2]|0)>>>0>=d>>>0)break;b=c[b+4>>2]|0;if(!b)break a}e=c[b>>2]|0;if(!e){f=b;break}else f=b}}while(0);c[a>>2]=f;i=g;return}function zd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;e=c[a+4>>2]|0;if(!e){f=a+4|0;c[b>>2]=f;b=f;i=g;return b|0}f=c[d>>2]|0;while(1){d=c[e+16>>2]|0;if(f>>>0<d>>>0){d=c[e>>2]|0;if(!d){a=5;break}else{e=d;continue}}if(d>>>0>=f>>>0){a=9;break}d=e+4|0;a=c[d>>2]|0;if(!a){a=8;break}else e=a}if((a|0)==5){c[b>>2]=e;b=e;i=g;return b|0}else if((a|0)==8){c[b>>2]=e;b=d;i=g;return b|0}else if((a|0)==9){c[b>>2]=e;i=g;return b|0}return 0}function Ad(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=oe(32)|0;c[f+16>>2]=c[d>>2];d=f+24|0;c[d>>2]=0;c[f+28>>2]=0;c[f+20>>2]=d;c[a>>2]=f;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=257;i=e;return}function Bd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[c[a>>2]>>2]|0;if(b){c[a>>2]=b;e=c[d>>2]|0}nc(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;i=f;return}function Cd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;h=i;i=i+16|0;if((i|0)>=(j|0))ca();g=h+12|0;d=h;e=Ld(a,g,b)|0;f=c[e>>2]|0;if(f){a=f;a=a+20|0;i=h;return a|0}Md(d,a,b);b=c[d>>2]|0;c[d>>2]=0;Nd(a,c[g>>2]|0,e,b);a=b;a=a+20|0;i=h;return a|0}function Dd(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=oe(12)|0;c[e+8>>2]=c[b>>2];c[e+4>>2]=a;b=c[a>>2]|0;c[e>>2]=b;c[b+4>>2]=e;c[a>>2]=e;a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;i=d;return}function Ed(a){a=a|0;var b=0,d=0,e=0;b=i;d=c[a+4>>2]|0;e=d+4|0;c[(c[d>>2]|0)+4>>2]=c[e>>2];c[c[e>>2]>>2]=c[d>>2];a=a+8|0;c[a>>2]=(c[a>>2]|0)+-1;pe(d);i=b;return}function Fd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=i;i=i+32|0;if((i|0)>=(j|0))ca();g=q+28|0;p=q+16|0;l=q+12|0;n=q+8|0;o=q+4|0;m=q;c[g>>2]=b;c[p>>2]=p;d=p+4|0;c[d>>2]=p;e=p+8|0;c[e>>2]=0;Dd(p,g);if(!(c[e>>2]|0)){Id(p);i=q;return}f=a+4|0;g=a+8|0;do{c[l>>2]=c[(c[d>>2]|0)+8>>2];Ed(p);c[n>>2]=c[(Cd(f,l)|0)>>2];b=c[a>>2]|0;if(hd(b,n)|0)qd(bd(b,n)|0,l)|0;if((c[(Cd(f,l)|0)>>2]|0)!=0?(c[(Cd(f,l)|0)>>2]=0,k=c[l>>2]|0,h=c[k>>2]|0,k=k+4|0,(h|0)!=(k|0)):0){b=h;do{c[o>>2]=c[b+16>>2];Jd(m,f,o);r=c[m>>2]|0;if((r|0)!=(g|0)?(c[r+20>>2]|0)!=0:0)Dd(p,o);b=Ac(b)|0}while((b|0)!=(k|0))}}while((c[e>>2]|0)!=0);Id(p);i=q;return}function Gd(a){a=a|0;var b=0;b=i;Hd(a,c[a+4>>2]|0);i=b;return}function Hd(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){i=d;return}else{Hd(a,c[b>>2]|0);Hd(a,c[b+4>>2]|0);pe(b);i=d;return}}function Id(a){a=a|0;var b=0,d=0,e=0,f=0;e=i;d=a+8|0;if(!(c[d>>2]|0)){i=e;return}b=c[a+4>>2]|0;f=(c[a>>2]|0)+4|0;c[(c[b>>2]|0)+4>>2]=c[f>>2];c[c[f>>2]>>2]=c[b>>2];c[d>>2]=0;if((b|0)==(a|0)){i=e;return}do{f=b;b=c[b+4>>2]|0;pe(f)}while((b|0)!=(a|0));i=e;return}function Jd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();g=f;e=b+4|0;Kd(g,b,d,c[b+4>>2]|0,e);b=c[g>>2]|0;if((b|0)!=(e|0)?(c[d>>2]|0)>>>0>=(c[b+16>>2]|0)>>>0:0){c[a>>2]=b;i=f;return}c[a>>2]=e;i=f;return}function Kd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;a:do if(e){d=c[d>>2]|0;while(1){b=e;while(1){if((c[b+16>>2]|0)>>>0>=d>>>0)break;b=c[b+4>>2]|0;if(!b)break a}e=c[b>>2]|0;if(!e){f=b;break}else f=b}}while(0);c[a>>2]=f;i=g;return}function Ld(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;e=c[a+4>>2]|0;if(!e){f=a+4|0;c[b>>2]=f;b=f;i=g;return b|0}f=c[d>>2]|0;while(1){d=c[e+16>>2]|0;if(f>>>0<d>>>0){d=c[e>>2]|0;if(!d){a=5;break}else{e=d;continue}}if(d>>>0>=f>>>0){a=9;break}d=e+4|0;a=c[d>>2]|0;if(!a){a=8;break}else e=a}if((a|0)==5){c[b>>2]=e;b=e;i=g;return b|0}else if((a|0)==8){c[b>>2]=e;b=d;i=g;return b|0}else if((a|0)==9){c[b>>2]=e;i=g;return b|0}return 0}function Md(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=oe(24)|0;c[f+16>>2]=c[d>>2];c[f+20>>2]=0;c[a>>2]=f;a=a+4|0;c[a>>2]=b+4;c[a+4>>2]=257;i=e;return}function Nd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=b;c[d>>2]=e;b=c[c[a>>2]>>2]|0;if(b){c[a>>2]=b;e=c[d>>2]|0}nc(c[a+4>>2]|0,e);a=a+8|0;c[a>>2]=(c[a>>2]|0)+1;i=f;return}function Od(a){a=a|0;var b=0;b=i;Pd(a,c[a+4>>2]|0);i=b;return}function Pd(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){i=d;return}else{Pd(a,c[b>>2]|0);Pd(a,c[b+4>>2]|0);pe(b);i=d;return}}function Qd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,k=0,l=0;k=i;i=i+32|0;if((i|0)>=(j|0))ca();f=k+20|0;h=k+16|0;l=k+12|0;g=k;c[l>>2]=c[d>>2];c[f+0>>2]=c[l+0>>2];d=Rd(b,f,h,e)|0;f=c[d>>2]|0;if(f){l=f;c[a>>2]=l;i=k;return}lc(g,b,e);l=c[g>>2]|0;c[g>>2]=0;mc(b,c[h>>2]|0,d,l);c[a>>2]=l;i=k;return}function Rd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;g=a+4|0;j=c[b>>2]|0;if((j|0)!=(g|0)?(h=c[e>>2]|0,f=c[j+16>>2]|0,h>>>0>=f>>>0):0){if(f>>>0>=h>>>0){c[d>>2]=j;i=k;return d|0}f=Ac(j)|0;if((f|0)!=(g|0)?h>>>0>=(c[f+16>>2]|0)>>>0:0){d=kc(a,d,e)|0;i=k;return d|0}b=j+4|0;if(!(c[b>>2]|0)){c[d>>2]=j;d=b;i=k;return d|0}else{c[d>>2]=f;d=f;i=k;return d|0}}if((j|0)!=(c[a>>2]|0)){b=Sd(j)|0;if((c[b+16>>2]|0)>>>0>=(c[e>>2]|0)>>>0){d=kc(a,d,e)|0;i=k;return d|0}}else b=j;if(!(c[j>>2]|0)){c[d>>2]=j;d=j;i=k;return d|0}else{c[d>>2]=b;d=b+4|0;i=k;return d|0}return 0}function Sd(a){a=a|0;var b=0,d=0;d=i;b=c[a>>2]|0;if(!b){while(1){b=c[a+8>>2]|0;if((c[b>>2]|0)==(a|0))a=b;else break}i=d;return b|0}else{while(1){a=c[b+4>>2]|0;if(!a)break;else b=a}i=d;return b|0}return 0}function Td(a){a=a|0;return}function Ud(a){a=a|0;var b=0;b=i;pe(a);i=b;return}function Vd(a,b){a=a|0;b=b|0;var d=0;d=i;Cb(c[a+20>>2]|0,b);a=c[a+8>>2]|0;if(!a){i=d;return}fb[c[(c[a>>2]|0)+8>>2]&7](a,b);i=d;return}function Wd(a){a=a|0;var b=0,d=0;b=i;Pd(a,c[a+4>>2]|0);c[a+8>>2]=0;d=a+4|0;c[a>>2]=d;c[d>>2]=0;i=b;return}function Xd(a){a=a|0;var b=0,d=0,e=0;e=i;Yd(a);b=c[a+4>>2]|0;d=c[a+8>>2]|0;if((b|0)!=(d|0))do{pe(c[b>>2]|0);b=b+4|0}while((b|0)!=(d|0));yc(a);i=e;return}function Yd(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,k=0;k=i;i=i+16|0;if((i|0)>=(j|0))ca();h=k+8|0;g=k;Zd(h,a);Vc(g,a);b=h+4|0;d=c[b>>2]|0;g=c[g+4>>2]|0;if((d|0)!=(g|0)){e=c[h>>2]|0;f=e;e=c[e>>2]|0;do{d=d+4|0;if((d-e|0)==4096){f=f+4|0;c[h>>2]=f;e=c[f>>2]|0;d=e}}while((d|0)!=(g|0));c[b>>2]=g}c[a+20>>2]=0;e=a+8|0;f=a+4|0;d=c[f>>2]|0;b=(c[e>>2]|0)-d>>2;if(b>>>0>2)do{pe(c[d>>2]|0);d=(c[f>>2]|0)+4|0;c[f>>2]=d;b=(c[e>>2]|0)-d>>2}while(b>>>0>2);if((b|0)==1){c[a+16>>2]=512;i=k;return}else if((b|0)==2){c[a+16>>2]=1024;i=k;return}else{i=k;return}}function Zd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=c[b+4>>2]|0;d=c[b+16>>2]|0;e=f+(d>>>10<<2)|0;if((c[b+8>>2]|0)==(f|0))d=0;else d=(c[e>>2]|0)+((d&1023)<<2)|0;c[a>>2]=e;c[a+4>>2]=d;return}function _d(a){a=a|0;var b=0,d=0,e=0;e=i;$d(a);b=c[a+4>>2]|0;d=c[a+8>>2]|0;if((b|0)!=(d|0))do{pe(c[b>>2]|0);b=b+4|0}while((b|0)!=(d|0));zc(a);i=e;return}function $d(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,k=0;k=i;i=i+16|0;if((i|0)>=(j|0))ca();h=k+8|0;g=k;ae(h,a);sc(g,a);b=h+4|0;d=c[b>>2]|0;g=c[g+4>>2]|0;if((d|0)!=(g|0)){e=c[h>>2]|0;f=e;e=c[e>>2]|0;do{d=d+4|0;if((d-e|0)==4096){f=f+4|0;c[h>>2]=f;e=c[f>>2]|0;d=e}}while((d|0)!=(g|0));c[b>>2]=g}c[a+20>>2]=0;e=a+8|0;f=a+4|0;d=c[f>>2]|0;b=(c[e>>2]|0)-d>>2;if(b>>>0>2)do{pe(c[d>>2]|0);d=(c[f>>2]|0)+4|0;c[f>>2]=d;b=(c[e>>2]|0)-d>>2}while(b>>>0>2);if((b|0)==2){c[a+16>>2]=1024;i=k;return}else if((b|0)==1){c[a+16>>2]=512;i=k;return}else{i=k;return}}function ae(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=c[b+4>>2]|0;d=c[b+16>>2]|0;e=f+(d>>>10<<2)|0;if((c[b+8>>2]|0)==(f|0))d=0;else d=(c[e>>2]|0)+((d&1023)<<2)|0;c[a>>2]=e;c[a+4>>2]=d;return}function be(a){a=a|0;var b=0;b=i;a=c[a+4>>2]|0;if(a)Qe(a);i=b;return}function ce(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;j=i;b=c[178]|0;h=c[174]|0;e=c[176]|0;f=h;g=b-e+f|0;d=(a+1|0)<(g|0);if(!(c[180]|0))if(d){h=1;i=j;return h|0}else ya(1192,120,61,1208);if(d){h=1;i=j;return h|0}f=e-f|0;d=a+10241+b-g|0;if((b|0)<(d|0))do b=((b|0)/2|0)+b|0;while((b|0)<(d|0));h=Re(h,b)|0;c[174]=h;c[176]=h+f;c[178]=b;h=0;i=j;return h|0}function de(a){a=a|0;var b=0;b=i;ee(a,c[a+4>>2]|0);i=b;return}function ee(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){i=d;return}else{ee(a,c[b>>2]|0);ee(a,c[b+4>>2]|0);pe(b);i=d;return}}function fe(){var a=0;a=i;c[183]=0;c[184]=0;c[182]=732;Ta(16,728,o|0)|0;i=a;return}function ge(b,c){b=b|0;c=c|0;var d=0;d=i;b=he(b,c)|0;i=d;return ((a[b>>0]|0)==(c&255)<<24>>24?b:0)|0}function he(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;j=i;h=d&255;if(!h){d=b+(hf(b|0)|0)|0;i=j;return d|0}a:do if(b&3){g=d&255;f=b;while(1){e=a[f>>0]|0;if(!(e<<24>>24)){b=f;f=13;break}b=f+1|0;if(e<<24>>24==g<<24>>24){b=f;f=13;break}if(!(b&3))break a;else f=b}if((f|0)==13){i=j;return b|0}}while(0);g=ba(h,16843009)|0;e=c[b>>2]|0;b:do if(!((e&-2139062144^-2139062144)&e+-16843009)){f=b;while(1){h=e^g;b=f+4|0;if((h&-2139062144^-2139062144)&h+-16843009){b=f;break b}e=c[b>>2]|0;if((e&-2139062144^-2139062144)&e+-16843009)break;else f=b}}while(0);e=d&255;while(1){d=a[b>>0]|0;if(d<<24>>24==0?1:d<<24>>24==e<<24>>24)break;else b=b+1|0}i=j;return b|0}function ie(a){a=a|0;var b=0,c=0,d=0;d=i;b=(hf(a|0)|0)+1|0;c=Pe(b)|0;if(!c){a=0;i=d;return a|0}lf(c|0,a|0,b|0)|0;a=c;i=d;return a|0}function je(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;if((i|0)>=(j|0))ca();e=d;c[e>>2]=b;d=c[p>>2]|0;xa(d|0,a|0,e|0)|0;Ua(10,d|0)|0;Wa()}function ke(){var a=0,b=0,d=0,e=0,f=0;a=i;i=i+16|0;if((i|0)>=(j|0))ca();f=a;e=a+12|0;a=le()|0;if(!a)je(1416,f);d=c[a>>2]|0;if(!d)je(1416,f);a=d+48|0;b=c[a>>2]|0;a=c[a+4>>2]|0;if(!((b&-256|0)==1126902528&(a|0)==1129074247)){c[f>>2]=c[314];je(1376,f)}if((b|0)==1126902529&(a|0)==1129074247)a=c[d+44>>2]|0;else a=d+80|0;c[e>>2]=a;d=c[d>>2]|0;a=c[d+4>>2]|0;if(cb[c[(c[1808>>2]|0)+16>>2]&3](1808,d,e)|0){e=c[e>>2]|0;d=c[314]|0;e=gb[c[(c[e>>2]|0)+8>>2]&1](e)|0;c[f>>2]=d;c[f+4>>2]=a;c[f+8>>2]=e;je(1280,f)}else{c[f>>2]=c[314];c[f+4>>2]=a;je(1328,f)}}function le(){var a=0,b=0;a=i;i=i+16|0;if((i|0)>=(j|0))ca();if(!(Na(1440,2)|0)){b=La(c[358]|0)|0;i=a;return b|0}else je(1448,a);return 0}function me(){var a=0;a=i;i=i+16|0;if((i|0)>=(j|0))ca();if(!(Pa(1432,17)|0)){i=a;return}else je(1504,a)}function ne(a){a=a|0;var b=0;b=i;i=i+16|0;if((i|0)>=(j|0))ca();Qe(a);if(!(Sa(c[358]|0,0)|0)){i=b;return}else je(1560,b)}function oe(a){a=a|0;var b=0,d=0;d=i;b=(a|0)==0?1:a;a=Pe(b)|0;if(a){b=a;i=d;return b|0}while(1){a=ve()|0;if(!a){b=4;break}hb[a&3]();a=Pe(b)|0;if(a){b=5;break}}if((b|0)==4){d=za(4)|0;c[d>>2]=1624;Va(d|0,1672,9)}else if((b|0)==5){i=d;return a|0}return 0}function pe(a){a=a|0;var b=0;b=i;Qe(a);i=b;return}function qe(a){a=a|0;var b=0;b=i;pe(a);i=b;return}function re(a){a=a|0;return}function se(a){a=a|0;return 1640}function te(a){a=a|0;var b=0;b=i;i=i+16|0;if((i|0)>=(j|0))ca();hb[a&3]();je(1688,b)}function ue(){var a=0,b=0;a=le()|0;if(((a|0)!=0?(b=c[a>>2]|0,(b|0)!=0):0)?(a=b+48|0,(c[a>>2]&-256|0)==1126902528?(c[a+4>>2]|0)==1129074247:0):0)te(c[b+12>>2]|0);b=c[312]|0;c[312]=b+0;te(b)}function ve(){var a=0;a=c[446]|0;c[446]=a+0;return a|0}function we(a){a=a|0;return}function xe(a){a=a|0;return}function ye(a){a=a|0;return}function ze(a){a=a|0;return}function Ae(a){a=a|0;return}function Be(a){a=a|0;var b=0;b=i;pe(a);i=b;return}function Ce(a){a=a|0;var b=0;b=i;pe(a);i=b;return}function De(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;i=i+64|0;if((i|0)>=(j|0))ca();g=h;if((a|0)==(b|0)){a=1;i=h;return a|0}if(!b){a=0;i=h;return a|0}b=He(b,1880,1936,0)|0;if(!b){a=0;i=h;return a|0}e=g+0|0;f=e+56|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));c[g>>2]=b;c[g+8>>2]=a;c[g+12>>2]=-1;c[g+48>>2]=1;jb[c[(c[b>>2]|0)+28>>2]&3](b,g,c[d>>2]|0,1);if((c[g+24>>2]|0)!=1){a=0;i=h;return a|0}c[d>>2]=c[g+16>>2];a=1;i=h;return a|0}function Ee(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=i;b=d+16|0;g=c[b>>2]|0;if(!g){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=h;return}if((g|0)!=(e|0)){f=d+36|0;c[f>>2]=(c[f>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=h;return}b=d+24|0;if((c[b>>2]|0)!=2){i=h;return}c[b>>2]=f;i=h;return}function Fe(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;if((c[b+8>>2]|0)!=(a|0)){i=f;return}Ee(0,b,d,e);i=f;return}function Ge(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;if((a|0)==(c[b+8>>2]|0)){Ee(0,b,d,e);i=f;return}else{a=c[a+8>>2]|0;jb[c[(c[a>>2]|0)+28>>2]&3](a,b,d,e);i=f;return}}function He(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+64|0;if((i|0)>=(j|0))ca();r=s;q=c[d>>2]|0;p=d+(c[q+-8>>2]|0)|0;q=c[q+-4>>2]|0;c[r>>2]=f;c[r+4>>2]=d;c[r+8>>2]=e;c[r+12>>2]=g;h=r+16|0;k=r+20|0;l=r+24|0;m=r+28|0;n=r+32|0;o=r+40|0;e=(q|0)==(f|0);d=h+0|0;g=d+36|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(g|0));b[h+36>>1]=0;a[h+38>>0]=0;if(e){c[r+48>>2]=1;ib[c[(c[q>>2]|0)+20>>2]&3](q,r,p,p,1,0);r=(c[l>>2]|0)==1?p:0;i=s;return r|0}db[c[(c[q>>2]|0)+24>>2]&3](q,r,p,1,0);g=c[r+36>>2]|0;if((g|0)==1){if((c[l>>2]|0)!=1){if(c[o>>2]|0){r=0;i=s;return r|0}if((c[m>>2]|0)!=1){r=0;i=s;return r|0}if((c[n>>2]|0)!=1){r=0;i=s;return r|0}}r=c[h>>2]|0;i=s;return r|0}else if(!g){if((c[o>>2]|0)!=1){r=0;i=s;return r|0}if((c[m>>2]|0)!=1){r=0;i=s;return r|0}r=(c[n>>2]|0)==1?c[k>>2]|0:0;i=s;return r|0}else{r=0;i=s;return r|0}return 0}function Ie(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=i;a[d+53>>0]=1;if((c[d+4>>2]|0)!=(f|0)){i=h;return}a[d+52>>0]=1;b=d+16|0;f=c[b>>2]|0;if(!f){c[b>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=h;return}a[d+54>>0]=1;i=h;return}if((f|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54>>0]=1;i=h;return}f=d+24|0;b=c[f>>2]|0;if((b|0)==2)c[f>>2]=g;else g=b;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=h;return}a[d+54>>0]=1;i=h;return}function Je(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){i=l;return}h=d+28|0;if((c[h>>2]|0)==1){i=l;return}c[h>>2]=f;i=l;return}if((b|0)!=(c[d>>2]|0)){k=c[b+8>>2]|0;db[c[(c[k>>2]|0)+24>>2]&3](k,d,e,f,g);i=l;return}if((c[d+16>>2]|0)!=(e|0)?(j=d+20|0,(c[j>>2]|0)!=(e|0)):0){c[d+32>>2]=f;f=d+44|0;if((c[f>>2]|0)==4){i=l;return}h=d+52|0;a[h>>0]=0;m=d+53|0;a[m>>0]=0;b=c[b+8>>2]|0;ib[c[(c[b>>2]|0)+20>>2]&3](b,d,e,e,1,g);if(a[m>>0]|0){if(!(a[h>>0]|0)){h=1;k=13}}else{h=0;k=13}do if((k|0)==13){c[j>>2]=e;m=d+40|0;c[m>>2]=(c[m>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(h)break}else k=16;if((k|0)==16?h:0)break;c[f>>2]=4;i=l;return}while(0);c[f>>2]=3;i=l;return}if((f|0)!=1){i=l;return}c[d+32>>2]=1;i=l;return}function Ke(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;j=i;if((c[d+8>>2]|0)==(b|0)){if((c[d+4>>2]|0)!=(e|0)){i=j;return}g=d+28|0;if((c[g>>2]|0)==1){i=j;return}c[g>>2]=f;i=j;return}if((c[d>>2]|0)!=(b|0)){i=j;return}if((c[d+16>>2]|0)!=(e|0)?(h=d+20|0,(c[h>>2]|0)!=(e|0)):0){c[d+32>>2]=f;c[h>>2]=e;f=d+40|0;c[f>>2]=(c[f>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0)a[d+54>>0]=1;c[d+44>>2]=4;i=j;return}if((f|0)!=1){i=j;return}c[d+32>>2]=1;i=j;return}function Le(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=i;if((a|0)==(c[b+8>>2]|0)){Ie(0,b,d,e,f);i=h;return}else{a=c[a+8>>2]|0;ib[c[(c[a>>2]|0)+20>>2]&3](a,b,d,e,f,g);i=h;return}}function Me(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=i;if((c[b+8>>2]|0)!=(a|0)){i=g;return}Ie(0,b,d,e,f);i=g;return}function Ne(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;i=i+16|0;if((i|0)>=(j|0))ca();e=f;c[e>>2]=c[d>>2];b=cb[c[(c[a>>2]|0)+16>>2]&3](a,b,e)|0;a=b&1;if(!b){i=f;return a|0}c[d>>2]=c[e>>2];i=f;return a|0}function Oe(a){a=a|0;var b=0;b=i;if(!a)a=0;else a=(He(a,1880,2048,0)|0)!=0;i=b;return a&1|0}function Pe(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;L=i;do if(a>>>0<245){if(a>>>0<11)o=16;else o=a+11&-8;a=o>>>3;l=c[550]|0;k=l>>>a;if(k&3){d=(k&1^1)+a|0;f=d<<1;b=2240+(f<<2)|0;f=2240+(f+2<<2)|0;g=c[f>>2]|0;h=g+8|0;j=c[h>>2]|0;do if((b|0)!=(j|0)){if(j>>>0<(c[554]|0)>>>0)Wa();e=j+12|0;if((c[e>>2]|0)==(g|0)){c[e>>2]=b;c[f>>2]=j;break}else Wa()}else c[550]=l&~(1<<d);while(0);K=d<<3;c[g+4>>2]=K|3;K=g+(K|4)|0;c[K>>2]=c[K>>2]|1;K=h;i=L;return K|0}if(o>>>0>(c[552]|0)>>>0){if(k){f=2<<a;f=k<<a&(f|0-f);f=(f&0-f)+-1|0;a=f>>>12&16;f=f>>>a;e=f>>>5&8;f=f>>>e;d=f>>>2&4;f=f>>>d;g=f>>>1&2;f=f>>>g;h=f>>>1&1;h=(e|a|d|g|h)+(f>>>h)|0;f=h<<1;g=2240+(f<<2)|0;f=2240+(f+2<<2)|0;d=c[f>>2]|0;a=d+8|0;e=c[a>>2]|0;do if((g|0)!=(e|0)){if(e>>>0<(c[554]|0)>>>0)Wa();j=e+12|0;if((c[j>>2]|0)==(d|0)){c[j>>2]=g;c[f>>2]=e;break}else Wa()}else c[550]=l&~(1<<h);while(0);e=h<<3;b=e-o|0;c[d+4>>2]=o|3;k=d+o|0;c[d+(o|4)>>2]=b|1;c[d+e>>2]=b;e=c[552]|0;if(e){d=c[555]|0;g=e>>>3;j=g<<1;f=2240+(j<<2)|0;h=c[550]|0;g=1<<g;if(h&g){h=2240+(j+2<<2)|0;j=c[h>>2]|0;if(j>>>0<(c[554]|0)>>>0)Wa();else{m=h;n=j}}else{c[550]=h|g;m=2240+(j+2<<2)|0;n=f}c[m>>2]=d;c[n+12>>2]=d;c[d+8>>2]=n;c[d+12>>2]=f}c[552]=b;c[555]=k;K=a;i=L;return K|0}a=c[551]|0;if(a){l=(a&0-a)+-1|0;J=l>>>12&16;l=l>>>J;I=l>>>5&8;l=l>>>I;K=l>>>2&4;l=l>>>K;j=l>>>1&2;l=l>>>j;m=l>>>1&1;m=c[2504+((I|J|K|j|m)+(l>>>m)<<2)>>2]|0;l=(c[m+4>>2]&-8)-o|0;j=m;while(1){e=c[j+16>>2]|0;if(!e){e=c[j+20>>2]|0;if(!e)break}j=(c[e+4>>2]&-8)-o|0;K=j>>>0<l>>>0;l=K?j:l;j=e;m=K?e:m}k=c[554]|0;if(m>>>0<k>>>0)Wa();b=m+o|0;if(m>>>0>=b>>>0)Wa();a=c[m+24>>2]|0;g=c[m+12>>2]|0;do if((g|0)==(m|0)){h=m+20|0;j=c[h>>2]|0;if(!j){h=m+16|0;j=c[h>>2]|0;if(!j){d=0;break}}while(1){g=j+20|0;f=c[g>>2]|0;if(f){j=f;h=g;continue}g=j+16|0;f=c[g>>2]|0;if(!f)break;else{j=f;h=g}}if(h>>>0<k>>>0)Wa();else{c[h>>2]=0;d=j;break}}else{f=c[m+8>>2]|0;if(f>>>0<k>>>0)Wa();j=f+12|0;if((c[j>>2]|0)!=(m|0))Wa();h=g+8|0;if((c[h>>2]|0)==(m|0)){c[j>>2]=g;c[h>>2]=f;d=g;break}else Wa()}while(0);do if(a){j=c[m+28>>2]|0;h=2504+(j<<2)|0;if((m|0)==(c[h>>2]|0)){c[h>>2]=d;if(!d){c[551]=c[551]&~(1<<j);break}}else{if(a>>>0<(c[554]|0)>>>0)Wa();j=a+16|0;if((c[j>>2]|0)==(m|0))c[j>>2]=d;else c[a+20>>2]=d;if(!d)break}if(d>>>0<(c[554]|0)>>>0)Wa();c[d+24>>2]=a;j=c[m+16>>2]|0;do if(j)if(j>>>0<(c[554]|0)>>>0)Wa();else{c[d+16>>2]=j;c[j+24>>2]=d;break}while(0);j=c[m+20>>2]|0;if(j)if(j>>>0<(c[554]|0)>>>0)Wa();else{c[d+20>>2]=j;c[j+24>>2]=d;break}}while(0);if(l>>>0<16){K=l+o|0;c[m+4>>2]=K|3;K=m+(K+4)|0;c[K>>2]=c[K>>2]|1}else{c[m+4>>2]=o|3;c[m+(o|4)>>2]=l|1;c[m+(l+o)>>2]=l;e=c[552]|0;if(e){d=c[555]|0;g=e>>>3;j=g<<1;f=2240+(j<<2)|0;h=c[550]|0;g=1<<g;if(h&g){j=2240+(j+2<<2)|0;h=c[j>>2]|0;if(h>>>0<(c[554]|0)>>>0)Wa();else{p=j;q=h}}else{c[550]=h|g;p=2240+(j+2<<2)|0;q=f}c[p>>2]=d;c[q+12>>2]=d;c[d+8>>2]=q;c[d+12>>2]=f}c[552]=l;c[555]=b}K=m+8|0;i=L;return K|0}}}else if(a>>>0<=4294967231){a=a+11|0;o=a&-8;m=c[551]|0;if(m){j=0-o|0;a=a>>>8;if(a)if(o>>>0>16777215)l=31;else{p=(a+1048320|0)>>>16&8;q=a<<p;n=(q+520192|0)>>>16&4;q=q<<n;l=(q+245760|0)>>>16&2;l=14-(n|p|l)+(q<<l>>>15)|0;l=o>>>(l+7|0)&1|l<<1}else l=0;h=c[2504+(l<<2)>>2]|0;a:do if(!h){a=0;k=0}else{if((l|0)==31)k=0;else k=25-(l>>>1)|0;f=j;a=0;e=o<<k;k=0;while(1){g=c[h+4>>2]&-8;j=g-o|0;if(j>>>0<f>>>0)if((g|0)==(o|0)){a=h;k=h;break a}else k=h;else j=f;q=c[h+20>>2]|0;h=c[h+(e>>>31<<2)+16>>2]|0;a=(q|0)==0|(q|0)==(h|0)?a:q;if(!h)break;else{f=j;e=e<<1}}}while(0);if((a|0)==0&(k|0)==0){a=2<<l;a=m&(a|0-a);if(!a)break;q=(a&0-a)+-1|0;m=q>>>12&16;q=q>>>m;l=q>>>5&8;q=q>>>l;n=q>>>2&4;q=q>>>n;p=q>>>1&2;q=q>>>p;a=q>>>1&1;a=c[2504+((l|m|n|p|a)+(q>>>a)<<2)>>2]|0}if(!a)m=j;else while(1){q=(c[a+4>>2]&-8)-o|0;h=q>>>0<j>>>0;j=h?q:j;k=h?a:k;h=c[a+16>>2]|0;if(h){a=h;continue}a=c[a+20>>2]|0;if(!a){m=j;break}}if((k|0)!=0?m>>>0<((c[552]|0)-o|0)>>>0:0){a=c[554]|0;if(k>>>0<a>>>0)Wa();n=k+o|0;if(k>>>0>=n>>>0)Wa();e=c[k+24>>2]|0;g=c[k+12>>2]|0;do if((g|0)==(k|0)){h=k+20|0;j=c[h>>2]|0;if(!j){h=k+16|0;j=c[h>>2]|0;if(!j){r=0;break}}while(1){g=j+20|0;f=c[g>>2]|0;if(f){j=f;h=g;continue}g=j+16|0;f=c[g>>2]|0;if(!f)break;else{j=f;h=g}}if(h>>>0<a>>>0)Wa();else{c[h>>2]=0;r=j;break}}else{f=c[k+8>>2]|0;if(f>>>0<a>>>0)Wa();j=f+12|0;if((c[j>>2]|0)!=(k|0))Wa();h=g+8|0;if((c[h>>2]|0)==(k|0)){c[j>>2]=g;c[h>>2]=f;r=g;break}else Wa()}while(0);do if(e){j=c[k+28>>2]|0;h=2504+(j<<2)|0;if((k|0)==(c[h>>2]|0)){c[h>>2]=r;if(!r){c[551]=c[551]&~(1<<j);break}}else{if(e>>>0<(c[554]|0)>>>0)Wa();j=e+16|0;if((c[j>>2]|0)==(k|0))c[j>>2]=r;else c[e+20>>2]=r;if(!r)break}if(r>>>0<(c[554]|0)>>>0)Wa();c[r+24>>2]=e;j=c[k+16>>2]|0;do if(j)if(j>>>0<(c[554]|0)>>>0)Wa();else{c[r+16>>2]=j;c[j+24>>2]=r;break}while(0);j=c[k+20>>2]|0;if(j)if(j>>>0<(c[554]|0)>>>0)Wa();else{c[r+20>>2]=j;c[j+24>>2]=r;break}}while(0);b:do if(m>>>0>=16){c[k+4>>2]=o|3;c[k+(o|4)>>2]=m|1;c[k+(m+o)>>2]=m;j=m>>>3;if(m>>>0<256){h=j<<1;f=2240+(h<<2)|0;g=c[550]|0;j=1<<j;do if(!(g&j)){c[550]=g|j;s=2240+(h+2<<2)|0;t=f}else{j=2240+(h+2<<2)|0;h=c[j>>2]|0;if(h>>>0>=(c[554]|0)>>>0){s=j;t=h;break}Wa()}while(0);c[s>>2]=n;c[t+12>>2]=n;c[k+(o+8)>>2]=t;c[k+(o+12)>>2]=f;break}e=m>>>8;if(e)if(m>>>0>16777215)f=31;else{J=(e+1048320|0)>>>16&8;K=e<<J;I=(K+520192|0)>>>16&4;K=K<<I;f=(K+245760|0)>>>16&2;f=14-(I|J|f)+(K<<f>>>15)|0;f=m>>>(f+7|0)&1|f<<1}else f=0;j=2504+(f<<2)|0;c[k+(o+28)>>2]=f;c[k+(o+20)>>2]=0;c[k+(o+16)>>2]=0;h=c[551]|0;g=1<<f;if(!(h&g)){c[551]=h|g;c[j>>2]=n;c[k+(o+24)>>2]=j;c[k+(o+12)>>2]=n;c[k+(o+8)>>2]=n;break}j=c[j>>2]|0;if((f|0)==31)e=0;else e=25-(f>>>1)|0;c:do if((c[j+4>>2]&-8|0)!=(m|0)){f=m<<e;while(1){g=j+(f>>>31<<2)+16|0;h=c[g>>2]|0;if(!h)break;if((c[h+4>>2]&-8|0)==(m|0)){z=h;break c}else{f=f<<1;j=h}}if(g>>>0<(c[554]|0)>>>0)Wa();else{c[g>>2]=n;c[k+(o+24)>>2]=j;c[k+(o+12)>>2]=n;c[k+(o+8)>>2]=n;break b}}else z=j;while(0);e=z+8|0;d=c[e>>2]|0;b=c[554]|0;if(z>>>0<b>>>0)Wa();if(d>>>0<b>>>0)Wa();else{c[d+12>>2]=n;c[e>>2]=n;c[k+(o+8)>>2]=d;c[k+(o+12)>>2]=z;c[k+(o+24)>>2]=0;break}}else{K=m+o|0;c[k+4>>2]=K|3;K=k+(K+4)|0;c[K>>2]=c[K>>2]|1}while(0);K=k+8|0;i=L;return K|0}}}else o=-1;while(0);k=c[552]|0;if(o>>>0<=k>>>0){b=k-o|0;d=c[555]|0;if(b>>>0>15){c[555]=d+o;c[552]=b;c[d+(o+4)>>2]=b|1;c[d+k>>2]=b;c[d+4>>2]=o|3}else{c[552]=0;c[555]=0;c[d+4>>2]=k|3;K=d+(k+4)|0;c[K>>2]=c[K>>2]|1}K=d+8|0;i=L;return K|0}k=c[553]|0;if(o>>>0<k>>>0){J=k-o|0;c[553]=J;K=c[556]|0;c[556]=K+o;c[K+(o+4)>>2]=J|1;c[K+4>>2]=o|3;K=K+8|0;i=L;return K|0}do if(!(c[668]|0)){k=Ka(30)|0;if(!(k+-1&k)){c[670]=k;c[669]=k;c[671]=-1;c[672]=-1;c[673]=0;c[661]=0;c[668]=(Ya(0)|0)&-16^1431655768;break}else Wa()}while(0);m=o+48|0;g=c[670]|0;l=o+47|0;h=g+l|0;g=0-g|0;e=h&g;if(e>>>0<=o>>>0){K=0;i=L;return K|0}a=c[660]|0;if((a|0)!=0?(t=c[658]|0,z=t+e|0,z>>>0<=t>>>0|z>>>0>a>>>0):0){K=0;i=L;return K|0}d:do if(!(c[661]&4)){j=c[556]|0;e:do if(j){a=2648|0;while(1){k=c[a>>2]|0;if(k>>>0<=j>>>0?(b=a+4|0,(k+(c[b>>2]|0)|0)>>>0>j>>>0):0)break;a=c[a+8>>2]|0;if(!a){A=182;break e}}if(a){k=h-(c[553]|0)&g;if(k>>>0<2147483647){g=Ea(k|0)|0;A=(g|0)==((c[a>>2]|0)+(c[b>>2]|0)|0);f=g;j=k;g=A?g:-1;k=A?k:0;A=191}else k=0}else A=182}else A=182;while(0);do if((A|0)==182){g=Ea(0)|0;if((g|0)!=(-1|0)){a=g;k=c[669]|0;j=k+-1|0;if(!(j&a))h=e;else h=e-a+(j+a&0-k)|0;a=c[658]|0;k=a+h|0;if(h>>>0>o>>>0&h>>>0<2147483647){z=c[660]|0;if((z|0)!=0?k>>>0<=a>>>0|k>>>0>z>>>0:0){k=0;break}f=Ea(h|0)|0;k=(f|0)==(g|0);j=h;g=k?g:-1;k=k?h:0;A=191}else k=0}else k=0}while(0);f:do if((A|0)==191){a=0-j|0;if((g|0)!=(-1|0)){v=g;q=k;A=202;break d}do if((f|0)!=(-1|0)&j>>>0<2147483647&j>>>0<m>>>0?(u=c[670]|0,u=l-j+u&0-u,u>>>0<2147483647):0)if((Ea(u|0)|0)==(-1|0)){Ea(a|0)|0;break f}else{j=u+j|0;break}while(0);if((f|0)!=(-1|0)){v=f;q=j;A=202;break d}}while(0);c[661]=c[661]|4;A=199}else{k=0;A=199}while(0);if((((A|0)==199?e>>>0<2147483647:0)?(v=Ea(e|0)|0,w=Ea(0)|0,(w|0)!=(-1|0)&(v|0)!=(-1|0)&v>>>0<w>>>0):0)?(x=w-v|0,y=x>>>0>(o+40|0)>>>0,y):0){q=y?x:k;A=202}if((A|0)==202){j=(c[658]|0)+q|0;c[658]=j;if(j>>>0>(c[659]|0)>>>0)c[659]=j;n=c[556]|0;g:do if(n){f=2648|0;while(1){k=c[f>>2]|0;j=f+4|0;h=c[j>>2]|0;if((v|0)==(k+h|0)){A=214;break}g=c[f+8>>2]|0;if(!g)break;else f=g}if(((A|0)==214?(c[f+12>>2]&8|0)==0:0)?n>>>0>=k>>>0&n>>>0<v>>>0:0){c[j>>2]=h+q;b=(c[553]|0)+q|0;d=n+8|0;if(!(d&7))d=0;else d=0-d&7;K=b-d|0;c[556]=n+d;c[553]=K;c[n+(d+4)>>2]=K|1;c[n+(b+4)>>2]=40;c[557]=c[672];break}if(v>>>0<(c[554]|0)>>>0)c[554]=v;k=v+q|0;h=2648|0;while(1){if((c[h>>2]|0)==(k|0)){A=224;break}j=c[h+8>>2]|0;if(!j)break;else h=j}if((A|0)==224?(c[h+12>>2]&8|0)==0:0){c[h>>2]=v;j=h+4|0;c[j>>2]=(c[j>>2]|0)+q;j=v+8|0;if(!(j&7))p=0;else p=0-j&7;j=v+(q+8)|0;if(!(j&7))m=0;else m=0-j&7;j=v+(m+q)|0;n=p+o|0;b=v+n|0;a=j-(v+p)-o|0;c[v+(p+4)>>2]=o|3;h:do if((j|0)!=(c[556]|0)){if((j|0)==(c[555]|0)){K=(c[552]|0)+a|0;c[552]=K;c[555]=b;c[v+(n+4)>>2]=K|1;c[v+(K+n)>>2]=K;break}d=q+4|0;k=c[v+(d+m)>>2]|0;if((k&3|0)==1){l=k&-8;f=k>>>3;i:do if(k>>>0>=256){e=c[v+((m|24)+q)>>2]|0;k=c[v+(q+12+m)>>2]|0;do if((k|0)==(j|0)){h=m|16;g=v+(d+h)|0;k=c[g>>2]|0;if(!k){h=v+(h+q)|0;k=c[h>>2]|0;if(!k){H=0;break}}else h=g;while(1){g=k+20|0;f=c[g>>2]|0;if(f){k=f;h=g;continue}g=k+16|0;f=c[g>>2]|0;if(!f)break;else{k=f;h=g}}if(h>>>0<(c[554]|0)>>>0)Wa();else{c[h>>2]=0;H=k;break}}else{h=c[v+((m|8)+q)>>2]|0;if(h>>>0<(c[554]|0)>>>0)Wa();g=h+12|0;if((c[g>>2]|0)!=(j|0))Wa();f=k+8|0;if((c[f>>2]|0)==(j|0)){c[g>>2]=k;c[f>>2]=h;H=k;break}else Wa()}while(0);if(!e)break;k=c[v+(q+28+m)>>2]|0;h=2504+(k<<2)|0;do if((j|0)!=(c[h>>2]|0)){if(e>>>0<(c[554]|0)>>>0)Wa();k=e+16|0;if((c[k>>2]|0)==(j|0))c[k>>2]=H;else c[e+20>>2]=H;if(!H)break i}else{c[h>>2]=H;if(H)break;c[551]=c[551]&~(1<<k);break i}while(0);if(H>>>0<(c[554]|0)>>>0)Wa();c[H+24>>2]=e;j=m|16;h=c[v+(j+q)>>2]|0;do if(h)if(h>>>0<(c[554]|0)>>>0)Wa();else{c[H+16>>2]=h;c[h+24>>2]=H;break}while(0);j=c[v+(d+j)>>2]|0;if(!j)break;if(j>>>0<(c[554]|0)>>>0)Wa();else{c[H+20>>2]=j;c[j+24>>2]=H;break}}else{h=c[v+((m|8)+q)>>2]|0;g=c[v+(q+12+m)>>2]|0;k=2240+(f<<1<<2)|0;do if((h|0)!=(k|0)){if(h>>>0<(c[554]|0)>>>0)Wa();if((c[h+12>>2]|0)==(j|0))break;Wa()}while(0);if((g|0)==(h|0)){c[550]=c[550]&~(1<<f);break}do if((g|0)==(k|0))D=g+8|0;else{if(g>>>0<(c[554]|0)>>>0)Wa();k=g+8|0;if((c[k>>2]|0)==(j|0)){D=k;break}Wa()}while(0);c[h+12>>2]=g;c[D>>2]=h}while(0);j=v+((l|m)+q)|0;a=l+a|0}j=j+4|0;c[j>>2]=c[j>>2]&-2;c[v+(n+4)>>2]=a|1;c[v+(a+n)>>2]=a;j=a>>>3;if(a>>>0<256){h=j<<1;f=2240+(h<<2)|0;g=c[550]|0;j=1<<j;do if(!(g&j)){c[550]=g|j;I=2240+(h+2<<2)|0;J=f}else{j=2240+(h+2<<2)|0;h=c[j>>2]|0;if(h>>>0>=(c[554]|0)>>>0){I=j;J=h;break}Wa()}while(0);c[I>>2]=b;c[J+12>>2]=b;c[v+(n+8)>>2]=J;c[v+(n+12)>>2]=f;break}e=a>>>8;do if(!e)f=0;else{if(a>>>0>16777215){f=31;break}I=(e+1048320|0)>>>16&8;J=e<<I;H=(J+520192|0)>>>16&4;J=J<<H;f=(J+245760|0)>>>16&2;f=14-(H|I|f)+(J<<f>>>15)|0;f=a>>>(f+7|0)&1|f<<1}while(0);j=2504+(f<<2)|0;c[v+(n+28)>>2]=f;c[v+(n+20)>>2]=0;c[v+(n+16)>>2]=0;h=c[551]|0;g=1<<f;if(!(h&g)){c[551]=h|g;c[j>>2]=b;c[v+(n+24)>>2]=j;c[v+(n+12)>>2]=b;c[v+(n+8)>>2]=b;break}h=c[j>>2]|0;if((f|0)==31)j=0;else j=25-(f>>>1)|0;j:do if((c[h+4>>2]&-8|0)!=(a|0)){f=a<<j;while(1){g=h+(f>>>31<<2)+16|0;j=c[g>>2]|0;if(!j)break;if((c[j+4>>2]&-8|0)==(a|0)){K=j;break j}else{f=f<<1;h=j}}if(g>>>0<(c[554]|0)>>>0)Wa();else{c[g>>2]=b;c[v+(n+24)>>2]=h;c[v+(n+12)>>2]=b;c[v+(n+8)>>2]=b;break h}}else K=h;while(0);j=K+8|0;h=c[j>>2]|0;g=c[554]|0;if(K>>>0<g>>>0)Wa();if(h>>>0<g>>>0)Wa();else{c[h+12>>2]=b;c[j>>2]=b;c[v+(n+8)>>2]=h;c[v+(n+12)>>2]=K;c[v+(n+24)>>2]=0;break}}else{K=(c[553]|0)+a|0;c[553]=K;c[556]=b;c[v+(n+4)>>2]=K|1}while(0);K=v+(p|8)|0;i=L;return K|0}j=2648|0;while(1){h=c[j>>2]|0;if(h>>>0<=n>>>0?(B=c[j+4>>2]|0,C=h+B|0,C>>>0>n>>>0):0)break;j=c[j+8>>2]|0}j=h+(B+-39)|0;if(!(j&7))j=0;else j=0-j&7;g=h+(B+-47+j)|0;g=g>>>0<(n+16|0)>>>0?n:g;h=g+8|0;j=v+8|0;if(!(j&7))j=0;else j=0-j&7;K=q+-40-j|0;c[556]=v+j;c[553]=K;c[v+(j+4)>>2]=K|1;c[v+(q+-36)>>2]=40;c[557]=c[672];c[g+4>>2]=27;c[h+0>>2]=c[662];c[h+4>>2]=c[663];c[h+8>>2]=c[664];c[h+12>>2]=c[665];c[662]=v;c[663]=q;c[665]=0;c[664]=h;j=g+28|0;c[j>>2]=7;if((g+32|0)>>>0<C>>>0)do{K=j;j=j+4|0;c[j>>2]=7}while((K+8|0)>>>0<C>>>0);if((g|0)!=(n|0)){k=g-n|0;j=n+(k+4)|0;c[j>>2]=c[j>>2]&-2;c[n+4>>2]=k|1;c[n+k>>2]=k;j=k>>>3;if(k>>>0<256){h=j<<1;f=2240+(h<<2)|0;g=c[550]|0;j=1<<j;do if(!(g&j)){c[550]=g|j;E=2240+(h+2<<2)|0;F=f}else{e=2240+(h+2<<2)|0;d=c[e>>2]|0;if(d>>>0>=(c[554]|0)>>>0){E=e;F=d;break}Wa()}while(0);c[E>>2]=n;c[F+12>>2]=n;c[n+8>>2]=F;c[n+12>>2]=f;break}d=k>>>8;if(d)if(k>>>0>16777215)j=31;else{J=(d+1048320|0)>>>16&8;K=d<<J;I=(K+520192|0)>>>16&4;K=K<<I;j=(K+245760|0)>>>16&2;j=14-(I|J|j)+(K<<j>>>15)|0;j=k>>>(j+7|0)&1|j<<1}else j=0;e=2504+(j<<2)|0;c[n+28>>2]=j;c[n+20>>2]=0;c[n+16>>2]=0;d=c[551]|0;b=1<<j;if(!(d&b)){c[551]=d|b;c[e>>2]=n;c[n+24>>2]=e;c[n+12>>2]=n;c[n+8>>2]=n;break}e=c[e>>2]|0;if((j|0)==31)d=0;else d=25-(j>>>1)|0;k:do if((c[e+4>>2]&-8|0)!=(k|0)){j=k<<d;while(1){b=e+(j>>>31<<2)+16|0;d=c[b>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(k|0)){G=d;break k}else{j=j<<1;e=d}}if(b>>>0<(c[554]|0)>>>0)Wa();else{c[b>>2]=n;c[n+24>>2]=e;c[n+12>>2]=n;c[n+8>>2]=n;break g}}else G=e;while(0);d=G+8|0;b=c[d>>2]|0;e=c[554]|0;if(G>>>0<e>>>0)Wa();if(b>>>0<e>>>0)Wa();else{c[b+12>>2]=n;c[d>>2]=n;c[n+8>>2]=b;c[n+12>>2]=G;c[n+24>>2]=0;break}}}else{K=c[554]|0;if((K|0)==0|v>>>0<K>>>0)c[554]=v;c[662]=v;c[663]=q;c[665]=0;c[559]=c[668];c[558]=-1;d=0;do{K=d<<1;J=2240+(K<<2)|0;c[2240+(K+3<<2)>>2]=J;c[2240+(K+2<<2)>>2]=J;d=d+1|0}while((d|0)!=32);d=v+8|0;if(!(d&7))d=0;else d=0-d&7;K=q+-40-d|0;c[556]=v+d;c[553]=K;c[v+(d+4)>>2]=K|1;c[v+(q+-36)>>2]=40;c[557]=c[672]}while(0);b=c[553]|0;if(b>>>0>o>>>0){J=b-o|0;c[553]=J;K=c[556]|0;c[556]=K+o;c[K+(o+4)>>2]=J|1;c[K+4>>2]=o|3;K=K+8|0;i=L;return K|0}}c[(Ra()|0)>>2]=12;K=0;i=L;return K|0}function Qe(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;if(!a){i=w;return}g=a+-8|0;h=c[554]|0;if(g>>>0<h>>>0)Wa();f=c[a+-4>>2]|0;e=f&3;if((e|0)==1)Wa();p=f&-8;r=a+(p+-8)|0;do if(!(f&1)){g=c[g>>2]|0;if(!e){i=w;return}j=-8-g|0;l=a+j|0;m=g+p|0;if(l>>>0<h>>>0)Wa();if((l|0)==(c[555]|0)){g=a+(p+-4)|0;if((c[g>>2]&3|0)!=3){v=l;n=m;break}c[552]=m;c[g>>2]=c[g>>2]&-2;c[a+(j+4)>>2]=m|1;c[r>>2]=m;i=w;return}d=g>>>3;if(g>>>0<256){e=c[a+(j+8)>>2]|0;f=c[a+(j+12)>>2]|0;g=2240+(d<<1<<2)|0;if((e|0)!=(g|0)){if(e>>>0<h>>>0)Wa();if((c[e+12>>2]|0)!=(l|0))Wa()}if((f|0)==(e|0)){c[550]=c[550]&~(1<<d);v=l;n=m;break}if((f|0)!=(g|0)){if(f>>>0<h>>>0)Wa();g=f+8|0;if((c[g>>2]|0)==(l|0))b=g;else Wa()}else b=f+8|0;c[e+12>>2]=f;c[b>>2]=e;v=l;n=m;break}b=c[a+(j+24)>>2]|0;e=c[a+(j+12)>>2]|0;do if((e|0)==(l|0)){f=a+(j+20)|0;g=c[f>>2]|0;if(!g){f=a+(j+16)|0;g=c[f>>2]|0;if(!g){k=0;break}}while(1){e=g+20|0;d=c[e>>2]|0;if(d){g=d;f=e;continue}e=g+16|0;d=c[e>>2]|0;if(!d)break;else{g=d;f=e}}if(f>>>0<h>>>0)Wa();else{c[f>>2]=0;k=g;break}}else{d=c[a+(j+8)>>2]|0;if(d>>>0<h>>>0)Wa();g=d+12|0;if((c[g>>2]|0)!=(l|0))Wa();f=e+8|0;if((c[f>>2]|0)==(l|0)){c[g>>2]=e;c[f>>2]=d;k=e;break}else Wa()}while(0);if(b){g=c[a+(j+28)>>2]|0;f=2504+(g<<2)|0;if((l|0)==(c[f>>2]|0)){c[f>>2]=k;if(!k){c[551]=c[551]&~(1<<g);v=l;n=m;break}}else{if(b>>>0<(c[554]|0)>>>0)Wa();g=b+16|0;if((c[g>>2]|0)==(l|0))c[g>>2]=k;else c[b+20>>2]=k;if(!k){v=l;n=m;break}}if(k>>>0<(c[554]|0)>>>0)Wa();c[k+24>>2]=b;g=c[a+(j+16)>>2]|0;do if(g)if(g>>>0<(c[554]|0)>>>0)Wa();else{c[k+16>>2]=g;c[g+24>>2]=k;break}while(0);g=c[a+(j+20)>>2]|0;if(g)if(g>>>0<(c[554]|0)>>>0)Wa();else{c[k+20>>2]=g;c[g+24>>2]=k;v=l;n=m;break}else{v=l;n=m}}else{v=l;n=m}}else{v=g;n=p}while(0);if(v>>>0>=r>>>0)Wa();g=a+(p+-4)|0;f=c[g>>2]|0;if(!(f&1))Wa();if(!(f&2)){if((r|0)==(c[556]|0)){u=(c[553]|0)+n|0;c[553]=u;c[556]=v;c[v+4>>2]=u|1;if((v|0)!=(c[555]|0)){i=w;return}c[555]=0;c[552]=0;i=w;return}if((r|0)==(c[555]|0)){u=(c[552]|0)+n|0;c[552]=u;c[555]=v;c[v+4>>2]=u|1;c[v+u>>2]=u;i=w;return}h=(f&-8)+n|0;b=f>>>3;do if(f>>>0>=256){b=c[a+(p+16)>>2]|0;g=c[a+(p|4)>>2]|0;do if((g|0)==(r|0)){f=a+(p+12)|0;g=c[f>>2]|0;if(!g){f=a+(p+8)|0;g=c[f>>2]|0;if(!g){q=0;break}}while(1){e=g+20|0;d=c[e>>2]|0;if(d){g=d;f=e;continue}e=g+16|0;d=c[e>>2]|0;if(!d)break;else{g=d;f=e}}if(f>>>0<(c[554]|0)>>>0)Wa();else{c[f>>2]=0;q=g;break}}else{f=c[a+p>>2]|0;if(f>>>0<(c[554]|0)>>>0)Wa();e=f+12|0;if((c[e>>2]|0)!=(r|0))Wa();d=g+8|0;if((c[d>>2]|0)==(r|0)){c[e>>2]=g;c[d>>2]=f;q=g;break}else Wa()}while(0);if(b){g=c[a+(p+20)>>2]|0;f=2504+(g<<2)|0;if((r|0)==(c[f>>2]|0)){c[f>>2]=q;if(!q){c[551]=c[551]&~(1<<g);break}}else{if(b>>>0<(c[554]|0)>>>0)Wa();g=b+16|0;if((c[g>>2]|0)==(r|0))c[g>>2]=q;else c[b+20>>2]=q;if(!q)break}if(q>>>0<(c[554]|0)>>>0)Wa();c[q+24>>2]=b;f=c[a+(p+8)>>2]|0;do if(f)if(f>>>0<(c[554]|0)>>>0)Wa();else{c[q+16>>2]=f;c[f+24>>2]=q;break}while(0);e=c[a+(p+12)>>2]|0;if(e)if(e>>>0<(c[554]|0)>>>0)Wa();else{c[q+20>>2]=e;c[e+24>>2]=q;break}}}else{d=c[a+p>>2]|0;e=c[a+(p|4)>>2]|0;g=2240+(b<<1<<2)|0;if((d|0)!=(g|0)){if(d>>>0<(c[554]|0)>>>0)Wa();if((c[d+12>>2]|0)!=(r|0))Wa()}if((e|0)==(d|0)){c[550]=c[550]&~(1<<b);break}if((e|0)!=(g|0)){if(e>>>0<(c[554]|0)>>>0)Wa();f=e+8|0;if((c[f>>2]|0)==(r|0))o=f;else Wa()}else o=e+8|0;c[d+12>>2]=e;c[o>>2]=d}while(0);c[v+4>>2]=h|1;c[v+h>>2]=h;if((v|0)==(c[555]|0)){c[552]=h;i=w;return}else g=h}else{c[g>>2]=f&-2;c[v+4>>2]=n|1;c[v+n>>2]=n;g=n}f=g>>>3;if(g>>>0<256){d=f<<1;g=2240+(d<<2)|0;b=c[550]|0;e=1<<f;if(b&e){e=2240+(d+2<<2)|0;d=c[e>>2]|0;if(d>>>0<(c[554]|0)>>>0)Wa();else{s=e;t=d}}else{c[550]=b|e;s=2240+(d+2<<2)|0;t=g}c[s>>2]=v;c[t+12>>2]=v;c[v+8>>2]=t;c[v+12>>2]=g;i=w;return}b=g>>>8;if(b)if(g>>>0>16777215)f=31;else{s=(b+1048320|0)>>>16&8;t=b<<s;r=(t+520192|0)>>>16&4;t=t<<r;f=(t+245760|0)>>>16&2;f=14-(r|s|f)+(t<<f>>>15)|0;f=g>>>(f+7|0)&1|f<<1}else f=0;e=2504+(f<<2)|0;c[v+28>>2]=f;c[v+20>>2]=0;c[v+16>>2]=0;d=c[551]|0;b=1<<f;a:do if(d&b){e=c[e>>2]|0;if((f|0)==31)b=0;else b=25-(f>>>1)|0;b:do if((c[e+4>>2]&-8|0)!=(g|0)){f=g<<b;while(1){b=e+(f>>>31<<2)+16|0;d=c[b>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(g|0)){u=d;break b}else{f=f<<1;e=d}}if(b>>>0<(c[554]|0)>>>0)Wa();else{c[b>>2]=v;c[v+24>>2]=e;c[v+12>>2]=v;c[v+8>>2]=v;break a}}else u=e;while(0);b=u+8|0;d=c[b>>2]|0;e=c[554]|0;if(u>>>0<e>>>0)Wa();if(d>>>0<e>>>0)Wa();else{c[d+12>>2]=v;c[b>>2]=v;c[v+8>>2]=d;c[v+12>>2]=u;c[v+24>>2]=0;break}}else{c[551]=d|b;c[e>>2]=v;c[v+24>>2]=e;c[v+12>>2]=v;c[v+8>>2]=v}while(0);v=(c[558]|0)+-1|0;c[558]=v;if(!v)b=2656|0;else{i=w;return}while(1){b=c[b>>2]|0;if(!b)break;else b=b+8|0}c[558]=-1;i=w;return}function Re(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;do if(a){if(b>>>0>4294967231){c[(Ra()|0)>>2]=12;d=0;break}if(b>>>0<11)d=16;else d=b+11&-8;d=Se(a+-8|0,d)|0;if(d){d=d+8|0;break}d=Pe(b)|0;if(!d)d=0;else{f=c[a+-4>>2]|0;f=(f&-8)-((f&3|0)==0?8:4)|0;lf(d|0,a|0,(f>>>0<b>>>0?f:b)|0)|0;Qe(a)}}else d=Pe(b)|0;while(0);i=e;return d|0}function Se(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;p=a+4|0;f=c[p>>2]|0;k=f&-8;o=a+k|0;j=c[554]|0;if(a>>>0<j>>>0)Wa();e=f&3;if(!((e|0)!=1&a>>>0<o>>>0))Wa();d=a+(k|4)|0;g=c[d>>2]|0;if(!(g&1))Wa();if(!e){if(b>>>0<256){a=0;i=q;return a|0}if(k>>>0>=(b+4|0)>>>0?(k-b|0)>>>0<=c[670]<<1>>>0:0){i=q;return a|0}a=0;i=q;return a|0}if(k>>>0>=b>>>0){e=k-b|0;if(e>>>0<=15){i=q;return a|0}c[p>>2]=f&1|b|2;c[a+(b+4)>>2]=e|3;c[d>>2]=c[d>>2]|1;Te(a+b|0,e);i=q;return a|0}if((o|0)==(c[556]|0)){e=(c[553]|0)+k|0;if(e>>>0<=b>>>0){a=0;i=q;return a|0}o=e-b|0;c[p>>2]=f&1|b|2;c[a+(b+4)>>2]=o|1;c[556]=a+b;c[553]=o;i=q;return a|0}if((o|0)==(c[555]|0)){e=(c[552]|0)+k|0;if(e>>>0<b>>>0){a=0;i=q;return a|0}d=e-b|0;if(d>>>0>15){c[p>>2]=f&1|b|2;c[a+(b+4)>>2]=d|1;c[a+e>>2]=d;e=a+(e+4)|0;c[e>>2]=c[e>>2]&-2;e=a+b|0}else{c[p>>2]=f&1|e|2;e=a+(e+4)|0;c[e>>2]=c[e>>2]|1;e=0;d=0}c[552]=d;c[555]=e;i=q;return a|0}if(g&2){a=0;i=q;return a|0}m=(g&-8)+k|0;if(m>>>0<b>>>0){a=0;i=q;return a|0}n=m-b|0;f=g>>>3;do if(g>>>0>=256){h=c[a+(k+24)>>2]|0;f=c[a+(k+12)>>2]|0;do if((f|0)==(o|0)){d=a+(k+20)|0;e=c[d>>2]|0;if(!e){d=a+(k+16)|0;e=c[d>>2]|0;if(!e){l=0;break}}while(1){g=e+20|0;f=c[g>>2]|0;if(f){e=f;d=g;continue}g=e+16|0;f=c[g>>2]|0;if(!f)break;else{e=f;d=g}}if(d>>>0<j>>>0)Wa();else{c[d>>2]=0;l=e;break}}else{g=c[a+(k+8)>>2]|0;if(g>>>0<j>>>0)Wa();e=g+12|0;if((c[e>>2]|0)!=(o|0))Wa();d=f+8|0;if((c[d>>2]|0)==(o|0)){c[e>>2]=f;c[d>>2]=g;l=f;break}else Wa()}while(0);if(h){e=c[a+(k+28)>>2]|0;d=2504+(e<<2)|0;if((o|0)==(c[d>>2]|0)){c[d>>2]=l;if(!l){c[551]=c[551]&~(1<<e);break}}else{if(h>>>0<(c[554]|0)>>>0)Wa();e=h+16|0;if((c[e>>2]|0)==(o|0))c[e>>2]=l;else c[h+20>>2]=l;if(!l)break}if(l>>>0<(c[554]|0)>>>0)Wa();c[l+24>>2]=h;e=c[a+(k+16)>>2]|0;do if(e)if(e>>>0<(c[554]|0)>>>0)Wa();else{c[l+16>>2]=e;c[e+24>>2]=l;break}while(0);e=c[a+(k+20)>>2]|0;if(e)if(e>>>0<(c[554]|0)>>>0)Wa();else{c[l+20>>2]=e;c[e+24>>2]=l;break}}}else{g=c[a+(k+8)>>2]|0;d=c[a+(k+12)>>2]|0;e=2240+(f<<1<<2)|0;if((g|0)!=(e|0)){if(g>>>0<j>>>0)Wa();if((c[g+12>>2]|0)!=(o|0))Wa()}if((d|0)==(g|0)){c[550]=c[550]&~(1<<f);break}if((d|0)!=(e|0)){if(d>>>0<j>>>0)Wa();e=d+8|0;if((c[e>>2]|0)==(o|0))h=e;else Wa()}else h=d+8|0;c[g+12>>2]=d;c[h>>2]=g}while(0);if(n>>>0<16){c[p>>2]=m|c[p>>2]&1|2;b=a+(m|4)|0;c[b>>2]=c[b>>2]|1;i=q;return a|0}else{c[p>>2]=c[p>>2]&1|b|2;c[a+(b+4)>>2]=n|3;p=a+(m|4)|0;c[p>>2]=c[p>>2]|1;Te(a+b|0,n);i=q;return a|0}return 0}function Te(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;r=a+b|0;g=c[a+4>>2]|0;do if(!(g&1)){l=c[a>>2]|0;if(!(g&3)){i=v;return}o=a+(0-l)|0;n=l+b|0;k=c[554]|0;if(o>>>0<k>>>0)Wa();if((o|0)==(c[555]|0)){g=a+(b+4)|0;if((c[g>>2]&3|0)!=3){u=o;h=n;break}c[552]=n;c[g>>2]=c[g>>2]&-2;c[a+(4-l)>>2]=n|1;c[r>>2]=n;i=v;return}e=l>>>3;if(l>>>0<256){f=c[a+(8-l)>>2]|0;h=c[a+(12-l)>>2]|0;g=2240+(e<<1<<2)|0;if((f|0)!=(g|0)){if(f>>>0<k>>>0)Wa();if((c[f+12>>2]|0)!=(o|0))Wa()}if((h|0)==(f|0)){c[550]=c[550]&~(1<<e);u=o;h=n;break}if((h|0)!=(g|0)){if(h>>>0<k>>>0)Wa();g=h+8|0;if((c[g>>2]|0)==(o|0))d=g;else Wa()}else d=h+8|0;c[f+12>>2]=h;c[d>>2]=f;u=o;h=n;break}j=c[a+(24-l)>>2]|0;e=c[a+(12-l)>>2]|0;do if((e|0)==(o|0)){f=16-l|0;e=a+(f+4)|0;g=c[e>>2]|0;if(!g){f=a+f|0;g=c[f>>2]|0;if(!g){m=0;break}}else f=e;while(1){e=g+20|0;d=c[e>>2]|0;if(d){g=d;f=e;continue}e=g+16|0;d=c[e>>2]|0;if(!d)break;else{g=d;f=e}}if(f>>>0<k>>>0)Wa();else{c[f>>2]=0;m=g;break}}else{d=c[a+(8-l)>>2]|0;if(d>>>0<k>>>0)Wa();g=d+12|0;if((c[g>>2]|0)!=(o|0))Wa();f=e+8|0;if((c[f>>2]|0)==(o|0)){c[g>>2]=e;c[f>>2]=d;m=e;break}else Wa()}while(0);if(j){g=c[a+(28-l)>>2]|0;f=2504+(g<<2)|0;if((o|0)==(c[f>>2]|0)){c[f>>2]=m;if(!m){c[551]=c[551]&~(1<<g);u=o;h=n;break}}else{if(j>>>0<(c[554]|0)>>>0)Wa();g=j+16|0;if((c[g>>2]|0)==(o|0))c[g>>2]=m;else c[j+20>>2]=m;if(!m){u=o;h=n;break}}if(m>>>0<(c[554]|0)>>>0)Wa();c[m+24>>2]=j;g=16-l|0;f=c[a+g>>2]|0;do if(f)if(f>>>0<(c[554]|0)>>>0)Wa();else{c[m+16>>2]=f;c[f+24>>2]=m;break}while(0);g=c[a+(g+4)>>2]|0;if(g)if(g>>>0<(c[554]|0)>>>0)Wa();else{c[m+20>>2]=g;c[g+24>>2]=m;u=o;h=n;break}else{u=o;h=n}}else{u=o;h=n}}else{u=a;h=b}while(0);k=c[554]|0;if(r>>>0<k>>>0)Wa();g=a+(b+4)|0;f=c[g>>2]|0;if(!(f&2)){if((r|0)==(c[556]|0)){t=(c[553]|0)+h|0;c[553]=t;c[556]=u;c[u+4>>2]=t|1;if((u|0)!=(c[555]|0)){i=v;return}c[555]=0;c[552]=0;i=v;return}if((r|0)==(c[555]|0)){t=(c[552]|0)+h|0;c[552]=t;c[555]=u;c[u+4>>2]=t|1;c[u+t>>2]=t;i=v;return}h=(f&-8)+h|0;d=f>>>3;do if(f>>>0>=256){j=c[a+(b+24)>>2]|0;e=c[a+(b+12)>>2]|0;do if((e|0)==(r|0)){f=a+(b+20)|0;g=c[f>>2]|0;if(!g){f=a+(b+16)|0;g=c[f>>2]|0;if(!g){q=0;break}}while(1){e=g+20|0;d=c[e>>2]|0;if(d){g=d;f=e;continue}e=g+16|0;d=c[e>>2]|0;if(!d)break;else{g=d;f=e}}if(f>>>0<k>>>0)Wa();else{c[f>>2]=0;q=g;break}}else{d=c[a+(b+8)>>2]|0;if(d>>>0<k>>>0)Wa();g=d+12|0;if((c[g>>2]|0)!=(r|0))Wa();f=e+8|0;if((c[f>>2]|0)==(r|0)){c[g>>2]=e;c[f>>2]=d;q=e;break}else Wa()}while(0);if(j){g=c[a+(b+28)>>2]|0;f=2504+(g<<2)|0;if((r|0)==(c[f>>2]|0)){c[f>>2]=q;if(!q){c[551]=c[551]&~(1<<g);break}}else{if(j>>>0<(c[554]|0)>>>0)Wa();g=j+16|0;if((c[g>>2]|0)==(r|0))c[g>>2]=q;else c[j+20>>2]=q;if(!q)break}if(q>>>0<(c[554]|0)>>>0)Wa();c[q+24>>2]=j;g=c[a+(b+16)>>2]|0;do if(g)if(g>>>0<(c[554]|0)>>>0)Wa();else{c[q+16>>2]=g;c[g+24>>2]=q;break}while(0);g=c[a+(b+20)>>2]|0;if(g)if(g>>>0<(c[554]|0)>>>0)Wa();else{c[q+20>>2]=g;c[g+24>>2]=q;break}}}else{e=c[a+(b+8)>>2]|0;f=c[a+(b+12)>>2]|0;g=2240+(d<<1<<2)|0;if((e|0)!=(g|0)){if(e>>>0<k>>>0)Wa();if((c[e+12>>2]|0)!=(r|0))Wa()}if((f|0)==(e|0)){c[550]=c[550]&~(1<<d);break}if((f|0)!=(g|0)){if(f>>>0<k>>>0)Wa();g=f+8|0;if((c[g>>2]|0)==(r|0))p=g;else Wa()}else p=f+8|0;c[e+12>>2]=f;c[p>>2]=e}while(0);c[u+4>>2]=h|1;c[u+h>>2]=h;if((u|0)==(c[555]|0)){c[552]=h;i=v;return}}else{c[g>>2]=f&-2;c[u+4>>2]=h|1;c[u+h>>2]=h}g=h>>>3;if(h>>>0<256){f=g<<1;d=2240+(f<<2)|0;e=c[550]|0;g=1<<g;if(e&g){g=2240+(f+2<<2)|0;f=c[g>>2]|0;if(f>>>0<(c[554]|0)>>>0)Wa();else{s=g;t=f}}else{c[550]=e|g;s=2240+(f+2<<2)|0;t=d}c[s>>2]=u;c[t+12>>2]=u;c[u+8>>2]=t;c[u+12>>2]=d;i=v;return}d=h>>>8;if(d)if(h>>>0>16777215)d=31;else{s=(d+1048320|0)>>>16&8;t=d<<s;r=(t+520192|0)>>>16&4;t=t<<r;d=(t+245760|0)>>>16&2;d=14-(r|s|d)+(t<<d>>>15)|0;d=h>>>(d+7|0)&1|d<<1}else d=0;g=2504+(d<<2)|0;c[u+28>>2]=d;c[u+20>>2]=0;c[u+16>>2]=0;f=c[551]|0;e=1<<d;if(!(f&e)){c[551]=f|e;c[g>>2]=u;c[u+24>>2]=g;c[u+12>>2]=u;c[u+8>>2]=u;i=v;return}g=c[g>>2]|0;if((d|0)==31)d=0;else d=25-(d>>>1)|0;a:do if((c[g+4>>2]&-8|0)!=(h|0)){d=h<<d;e=g;while(1){f=e+(d>>>31<<2)+16|0;g=c[f>>2]|0;if(!g)break;if((c[g+4>>2]&-8|0)==(h|0))break a;else{d=d<<1;e=g}}if(f>>>0<(c[554]|0)>>>0)Wa();c[f>>2]=u;c[u+24>>2]=e;c[u+12>>2]=u;c[u+8>>2]=u;i=v;return}while(0);d=g+8|0;e=c[d>>2]|0;f=c[554]|0;if(g>>>0<f>>>0)Wa();if(e>>>0<f>>>0)Wa();c[e+12>>2]=u;c[d>>2]=u;c[u+8>>2]=e;c[u+12>>2]=g;c[u+24>>2]=0;i=v;return}function Ue(a,b){a=+a;b=b|0;var d=0,e=0,f=0,g=0;g=i;h[k>>3]=a;d=c[k>>2]|0;e=c[k+4>>2]|0;f=kf(d|0,e|0,52)|0;f=f&2047;if((f|0)==2047){i=g;return +a}else if(!f){if(a!=0.0){a=+Ue(a*18446744073709551616.0,b);d=(c[b>>2]|0)+-64|0}else d=0;c[b>>2]=d;i=g;return +a}else{c[b>>2]=f+-1022;c[k>>2]=d;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3];i=g;return +a}return 0.0}function Ve(a,b){a=+a;b=b|0;var c=0;c=i;a=+Ue(a,b);i=c;return +a}function We(a,b){a=a|0;b=b|0;var c=0;c=i;if(!a)a=0;else a=Xe(a,b,0)|0;i=c;return a|0}function Xe(b,d,e){b=b|0;d=d|0;e=e|0;e=i;if(!b){d=1;i=e;return d|0}if(d>>>0<128){a[b>>0]=d;d=1;i=e;return d|0}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;d=2;i=e;return d|0}if(d>>>0<55296|(d+-57344|0)>>>0<8192){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;d=3;i=e;return d|0}if((d+-65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;d=4;i=e;return d|0}else{c[(Ra()|0)>>2]=84;d=-1;i=e;return d|0}return 0}function Ye(b){b=b|0;var d=0,e=0,f=0;e=i;d=b+74|0;f=a[d>>0]|0;a[d>>0]=f+255|f;d=c[b>>2]|0;if(!(d&8)){c[b+8>>2]=0;c[b+4>>2]=0;f=c[b+44>>2]|0;c[b+28>>2]=f;c[b+20>>2]=f;c[b+16>>2]=f+(c[b+48>>2]|0);f=0;i=e;return f|0}else{c[b>>2]=d|32;f=-1;i=e;return f|0}return 0}function Ze(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;f=e+16|0;g=c[f>>2]|0;do if(!g)if(!(Ye(e)|0)){g=c[f>>2]|0;break}else{j=0;i=k;return j|0}while(0);j=e+20|0;f=c[j>>2]|0;if((g-f|0)>>>0<d>>>0){j=cb[c[e+36>>2]&3](e,b,d)|0;i=k;return j|0}a:do if((a[e+75>>0]|0)>-1){g=d;while(1){if(!g){h=d;g=0;break a}h=g+-1|0;if((a[b+h>>0]|0)==10)break;else g=h}if((cb[c[e+36>>2]&3](e,b,g)|0)>>>0<g>>>0){j=g;i=k;return j|0}else{h=d-g|0;b=b+g|0;f=c[j>>2]|0;break}}else{h=d;g=0}while(0);lf(f|0,b|0,h|0)|0;c[j>>2]=(c[j>>2]|0)+h;j=g+h|0;i=k;return j|0}function _e(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+224|0;if((i|0)>=(j|0))ca();m=q+120|0;p=q+80|0;o=q;n=q+136|0;e=p+0|0;f=e+40|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));c[m>>2]=c[d>>2];if(($e(0,b,m,o,p)|0)<0){a=-1;i=q;return a|0}e=a+48|0;if(!(c[e>>2]|0)){g=a+44|0;h=c[g>>2]|0;c[g>>2]=n;k=a+28|0;c[k>>2]=n;l=a+20|0;c[l>>2]=n;c[e>>2]=80;f=a+16|0;c[f>>2]=n+80;d=$e(a,b,m,o,p)|0;if(h){cb[c[a+36>>2]&3](a,0,0)|0;d=(c[l>>2]|0)==0?-1:d;c[g>>2]=h;c[e>>2]=0;c[f>>2]=0;c[k>>2]=0;c[l>>2]=0}}else d=$e(a,b,m,o,p)|0;a=d;i=q;return a|0}
function $e(e,f,g,l,m){e=e|0;f=f|0;g=g|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0.0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0;gb=i;i=i+864|0;if((i|0)>=(j|0))ca();Oa=gb+16|0;Qa=gb+8|0;Pa=gb+560|0;la=Pa;Ka=gb+840|0;Xa=gb+584|0;Ha=gb+520|0;cb=gb;Ua=gb+852|0;ma=(e|0)!=0;Aa=Ha+40|0;Ga=Aa;Ha=Ha+39|0;Ia=cb+4|0;Ja=Ka+12|0;Ka=Ka+11|0;La=Ja;Ma=La-la|0;na=-2-la|0;ua=La+2|0;va=Oa+288|0;wa=Pa+9|0;xa=wa;ya=Pa+8|0;D=0;G=0;v=0;q=0;E=0;a:while(1){do if((v|0)>-1)if((q|0)>(2147483647-v|0)){c[(Ra()|0)>>2]=75;_=-1;break}else{_=q+v|0;break}else _=v;while(0);q=a[f>>0]|0;if(!(q<<24>>24)){O=344;break}else p=f;while(1){if(!(q<<24>>24)){ga=p;fa=p;break}else if(q<<24>>24==37){Da=p;db=p;O=9;break}N=p+1|0;q=a[N>>0]|0;p=N}b:do if((O|0)==9)while(1){O=0;if((a[Da+1>>0]|0)!=37){ga=Da;fa=db;break b}p=db+1|0;q=Da+2|0;if((a[q>>0]|0)==37){Da=q;db=p}else{ga=q;fa=p;break}}while(0);q=fa-f|0;if(ma)Ze(f,q,e)|0;if((fa|0)!=(f|0)){f=ga;v=_;continue}u=ga+1|0;p=a[u>>0]|0;t=(p<<24>>24)+-48|0;if(t>>>0<10?(a[ga+2>>0]|0)==36:0){x=ga+3|0;p=a[x>>0]|0;B=1}else{t=-1;B=E;x=u}u=p<<24>>24;c:do if((u+-32|0)>>>0<32){v=0;while(1){if(!(1<<u+-32&75913)){A=v;break c}v=1<<(p<<24>>24)+-32|v;x=x+1|0;p=a[x>>0]|0;u=p<<24>>24;if((u+-32|0)>>>0>=32){A=v;break}}}else A=0;while(0);do if(p<<24>>24==42){v=x+1|0;u=(a[v>>0]|0)+-48|0;if(u>>>0<10?(a[x+2>>0]|0)==36:0){c[m+(u<<2)>>2]=10;u=1;p=x+3|0;v=c[l+((a[v>>0]|0)+-48<<3)>>2]|0}else{if(B){eb=-1;O=362;break a}if(!ma){p=v;C=A;N=0;L=0;break}u=c[g>>2]|0;N=c[u>>2]|0;c[g>>2]=u+4;u=0;p=v;v=N}if((v|0)<0){C=A|8192;N=u;L=0-v|0}else{C=A;N=u;L=v}}else{u=p<<24>>24;if((u+-48|0)>>>0<10){p=x;v=0;do{v=u+-48+(v*10|0)|0;p=p+1|0;u=a[p>>0]|0}while((u+-48|0)>>>0<10);if((v|0)<0){eb=-1;O=362;break a}else{C=A;N=B;L=v}}else{p=x;C=A;N=B;L=0}}while(0);d:do if((a[p>>0]|0)==46){v=p+1|0;u=a[v>>0]|0;if(u<<24>>24!=42){u=u<<24>>24;if((u+-48|0)>>>0<10){p=v;v=0}else{p=v;v=0;break}while(1){v=u+-48+(v*10|0)|0;p=p+1|0;u=a[p>>0]|0;if((u+-48|0)>>>0>=10)break d}}u=p+2|0;v=(a[u>>0]|0)+-48|0;if(v>>>0<10?(a[p+3>>0]|0)==36:0){c[m+(v<<2)>>2]=10;p=p+4|0;v=c[l+((a[u>>0]|0)+-48<<3)>>2]|0;break}if(N){eb=-1;O=362;break a}if(ma){p=c[g>>2]|0;v=c[p>>2]|0;c[g>>2]=p+4;p=u}else{p=u;v=0}}else v=-1;while(0);A=0;while(1){z=a[p>>0]|0;u=(z<<24>>24)+-65|0;if(u>>>0>57){eb=-1;O=362;break a}M=p+1|0;u=a[2696+(A*58|0)+u>>0]|0;x=u&255;if((x+-1|0)>>>0<8){p=M;A=x}else break}if(!(u<<24>>24)){eb=-1;O=362;break}y=(t|0)>-1;e:do if(u<<24>>24==19)if(y){eb=-1;O=362;break a}else{oa=D;pa=G;O=63}else{if(y){c[m+(t<<2)>>2]=x;pa=l+(t<<3)|0;oa=c[pa+4>>2]|0;pa=c[pa>>2]|0;O=63;break}if(!ma){eb=0;O=362;break a}if((u&255)>20){za=z;Ba=G;Ca=D}else do switch(x|0){case 10:{qa=c[g>>2]|0;ra=c[qa>>2]|0;c[g>>2]=qa+4;qa=ra;ra=((ra|0)<0)<<31>>31;O=64;break e}case 17:{qa=c[g>>2]|0;c[k>>2]=c[qa>>2];c[k+4>>2]=c[qa+4>>2];w=+h[k>>3];c[g>>2]=qa+8;h[k>>3]=w;qa=c[k>>2]|0;ra=c[k+4>>2]|0;O=64;break e}case 14:{ra=c[g>>2]|0;qa=c[ra>>2]|0;c[g>>2]=ra+4;qa=qa&65535;ra=0;O=64;break e}case 15:{qa=c[g>>2]|0;ra=c[qa>>2]|0;c[g>>2]=qa+4;qa=ra<<24>>24;ra=(((ra&255)<<24>>24|0)<0)<<31>>31;O=64;break e}case 16:{ra=c[g>>2]|0;qa=c[ra>>2]|0;c[g>>2]=ra+4;qa=qa&255;ra=0;O=64;break e}case 18:{oa=c[g>>2]|0;c[k>>2]=c[oa>>2];c[k+4>>2]=c[oa+4>>2];w=+h[k>>3];c[g>>2]=oa+8;h[k>>3]=w;oa=c[k+4>>2]|0;pa=c[k>>2]|0;O=63;break e}case 9:{ra=c[g>>2]|0;qa=c[ra>>2]|0;c[g>>2]=ra+4;ra=D;O=64;break e}case 12:{O=c[g>>2]|0;ra=O;qa=c[ra>>2]|0;ra=c[ra+4>>2]|0;c[g>>2]=O+8;O=64;break e}case 13:{qa=c[g>>2]|0;ra=c[qa>>2]|0;c[g>>2]=qa+4;qa=ra<<16>>16;ra=(((ra&65535)<<16>>16|0)<0)<<31>>31;O=64;break e}case 11:{ra=c[g>>2]|0;qa=c[ra>>2]|0;c[g>>2]=ra+4;ra=0;O=64;break e}default:{qa=G;ra=D;O=64;break e}}while(0)}while(0);if((O|0)==63){O=0;if(ma){qa=pa;ra=oa;O=64}else{D=oa;G=pa;f=M;v=_;E=N;continue}}if((O|0)==64){O=0;za=a[p>>0]|0;Ba=qa;Ca=ra}t=za<<24>>24;if(A)t=(t&15|0)==3?t&-33:t;z=C&-65537;K=(C&8192|0)==0?C:z;f:do switch(t|0){case 109:{Na=_a(c[(Ra()|0)>>2]|0)|0;O=99;break}case 115:{Na=(Ba|0)==0?3176:Ba;O=99;break}case 110:switch(A|0){case 0:{c[Ba>>2]=_;D=Ca;G=Ba;f=M;v=_;E=N;continue a}case 1:{c[Ba>>2]=_;D=Ca;G=Ba;f=M;v=_;E=N;continue a}case 2:{D=Ba;c[D>>2]=_;c[D+4>>2]=((_|0)<0)<<31>>31;D=Ca;G=Ba;f=M;v=_;E=N;continue a}case 3:{b[Ba>>1]=_;D=Ca;G=Ba;f=M;v=_;E=N;continue a}case 4:{a[Ba>>0]=_;D=Ca;G=Ba;f=M;v=_;E=N;continue a}case 6:{c[Ba>>2]=_;D=Ca;G=Ba;f=M;v=_;E=N;continue a}case 7:{D=Ba;c[D>>2]=_;c[D+4>>2]=((_|0)<0)<<31>>31;D=Ca;G=Ba;f=M;v=_;E=N;continue a}default:{D=Ca;G=Ba;f=M;v=_;E=N;continue a}}case 112:{Sa=K|8;Va=v>>>0>8?v:8;bb=120;O=77;break}case 99:{a[Ha>>0]=Ba;ha=Ca;ia=Ba;ja=Ha;n=z;aa=1;da=0;ea=3160;$=Aa;break}case 88:case 120:{Sa=K;Va=v;bb=t;O=77;break}case 67:{c[cb>>2]=Ba;c[Ia>>2]=0;sa=cb;ta=cb;Wa=-1;O=104;break}case 83:{if(!v){Y=Ba;Z=Ba;s=0;O=110}else{sa=Ba;ta=Ba;Wa=v;O=104}break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{c[k>>2]=Ba;c[k+4>>2]=Ca;r=+h[k>>3];c[Qa>>2]=0;if((Ca|0)>=0)if(!(K&2048)){J=K&1;H=J;J=(J|0)==0?3185:3190}else{H=1;J=3187}else{r=-r;H=1;J=3184}h[k>>3]=r;I=c[k+4>>2]&2146435072;if(!(I>>>0<2146435072|(I|0)==2146435072&0<0)){f=(t&32|0)!=0;if(r!=r|0.0!=0.0){u=0;v=f?3224:3232}else{u=H;v=f?3208:3216}z=u+3|0;q=(z|0)<(L|0);if((K&8192|0)==0&q){t=L-z|0;ff(Xa|0,32,(t>>>0>256?256:t)|0)|0;if(t>>>0>255)do{Ze(Xa,256,e)|0;t=t+-256|0}while(t>>>0>255);Ze(Xa,t,e)|0}Ze(J,u,e)|0;Ze(v,3,e)|0;if((K&73728|0)==8192&q){f=L-z|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}D=Ca;G=Ba;f=M;v=_;q=q?L:z;E=N;continue a}r=+Ve(r,Qa)*2.0;u=r!=0.0;if(u)c[Qa>>2]=(c[Qa>>2]|0)+-1;D=t|32;if((D|0)==97){C=t&32;y=(C|0)==0?J:J+9|0;p=H|2;u=v>>>0>11?0:12-v|0;do if(u){w=8.0;do{u=u+-1|0;w=w*16.0}while((u|0)!=0);if((a[y>>0]|0)==45){r=-(w+(-r-w));break}else{r=r+w-w;break}}while(0);q=c[Qa>>2]|0;q=(q|0)<0?0-q|0:q;if((q|0)<0){u=Ja;f=q;q=((q|0)<0)<<31>>31;while(1){J=wf(f|0,q|0,10,0)|0;u=u+-1|0;a[u>>0]=J|48;J=f;f=vf(f|0,q|0,10,0)|0;if(!(q>>>0>9|(q|0)==9&J>>>0>4294967295))break;else q=F}}else{u=Ja;f=q}if(f)while(1){u=u+-1|0;a[u>>0]=(f>>>0)%10|0|48;if(f>>>0<10)break;else f=(f>>>0)/10|0}if((u|0)==(Ja|0)){a[Ka>>0]=48;u=Ka}a[u+-1>>0]=(c[Qa>>2]>>31&2)+43;q=u+-2|0;a[q>>0]=t+15;u=(K&8|0)==0;if((v|0)>0)if(u){t=Pa;do{J=~~r;u=t+1|0;a[t>>0]=d[3240+J>>0]|C;r=(r-+(J|0))*16.0;if((u-la|0)==1){a[u>>0]=46;t=t+2|0}else t=u}while(r!=0.0)}else{t=Pa;do{J=~~r;u=t+1|0;a[t>>0]=d[3240+J>>0]|C;r=(r-+(J|0))*16.0;if((u-la|0)==1){a[u>>0]=46;t=t+2|0}else t=u}while(r!=0.0)}else if(u){t=Pa;do{f=~~r;u=t+1|0;a[t>>0]=d[3240+f>>0]|C;r=(r-+(f|0))*16.0;f=r!=0.0;if((u-la|0)==1&f){a[u>>0]=46;t=t+2|0}else t=u}while(f)}else{t=Pa;do{J=~~r;u=t+1|0;a[t>>0]=d[3240+J>>0]|C;r=(r-+(J|0))*16.0;if((u-la|0)==1){a[u>>0]=46;t=t+2|0}else t=u}while(r!=0.0)}do if(!v)O=173;else{if((na+t|0)>=(v|0)){O=173;break}Ta=ua+v-q|0}while(0);if((O|0)==173){O=0;Ta=Ma-q+t|0}z=Ta+p|0;A=K&73728;B=(z|0)<(L|0);if((A|0)==0&B){u=L-z|0;ff(Xa|0,32,(u>>>0>256?256:u)|0)|0;if(u>>>0>255)do{Ze(Xa,256,e)|0;u=u+-256|0}while(u>>>0>255);Ze(Xa,u,e)|0}Ze(y,p,e)|0;if((A|0)==65536&B){f=L-z|0;ff(Xa|0,48,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}f=t-la|0;Ze(Pa,f,e)|0;u=La-q|0;f=Ta-u-f|0;if((f|0)>0){ff(Xa|0,48,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}Ze(q,u,e)|0;if((A|0)==8192&B){f=L-z|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}D=Ca;G=Ba;f=M;v=_;q=B?L:z;E=N;continue a}f=(v|0)<0?6:v;if(u){u=(c[Qa>>2]|0)+-28|0;c[Qa>>2]=u;r=r*268435456.0}else u=c[Qa>>2]|0;I=(u|0)<0?Oa:va;q=I;do{G=~~r>>>0;c[q>>2]=G;q=q+4|0;r=(r-+(G>>>0))*1.0e9}while(r!=0.0);u=c[Qa>>2]|0;if((u|0)>0){v=u;u=I;z=q;while(1){p=(v|0)>29?29:v;v=z+-4|0;do if(v>>>0>=u>>>0){q=0;do{E=gf(c[v>>2]|0,0,p|0)|0;E=jf(E|0,F|0,q|0,0)|0;G=F;C=wf(E|0,G|0,1e9,0)|0;c[v>>2]=C;q=vf(E|0,G|0,1e9,0)|0;v=v+-4|0}while(v>>>0>=u>>>0);if(!q)break;u=u+-4|0;c[u>>2]=q}while(0);q=z;while(1){if(q>>>0<=u>>>0)break;v=q+-4|0;if(!(c[v>>2]|0))q=v;else break}v=(c[Qa>>2]|0)-p|0;c[Qa>>2]=v;if((v|0)>0)z=q;else break}}else{v=u;u=I}g:do if((v|0)<0){C=((f+25|0)/9|0)+1|0;if((D|0)==102){x=I;B=I+(C<<2)|0;while(1){A=0-v|0;A=(A|0)>9?9:A;do if(u>>>0<q>>>0){z=(1<<A)+-1|0;v=1e9>>>A;y=0;p=u;do{G=c[p>>2]|0;c[p>>2]=(G>>>A)+y;y=ba(G&z,v)|0;p=p+4|0}while(p>>>0<q>>>0);u=(c[u>>2]|0)==0?u+4|0:u;if(!y){v=q;break}c[q>>2]=y;v=q+4|0}else{u=(c[u>>2]|0)==0?u+4|0:u;v=q}while(0);q=(v-x>>2|0)>(C|0)?B:v;v=(c[Qa>>2]|0)+A|0;c[Qa>>2]=v;if((v|0)>=0){B=q;break g}}}do{x=0-v|0;x=(x|0)>9?9:x;do if(u>>>0<q>>>0){z=(1<<x)+-1|0;v=1e9>>>x;y=0;p=u;do{G=c[p>>2]|0;c[p>>2]=(G>>>x)+y;y=ba(G&z,v)|0;p=p+4|0}while(p>>>0<q>>>0);u=(c[u>>2]|0)==0?u+4|0:u;if(!y){v=q;break}c[q>>2]=y;v=q+4|0}else{u=(c[u>>2]|0)==0?u+4|0:u;v=q}while(0);if((v-u>>2|0)>(C|0))q=u+(C<<2)|0;else q=v;v=(c[Qa>>2]|0)+x|0;c[Qa>>2]=v}while((v|0)<0);B=q}else B=q;while(0);E=I;do if(u>>>0<B>>>0){v=(E-u>>2)*9|0;z=c[u>>2]|0;if(z>>>0<10)break;else q=10;do{q=q*10|0;v=v+1|0}while(z>>>0>=q>>>0)}else v=0;while(0);C=(D|0)==103;q=f-((D|0)!=102?v:0)+((C&(f|0)!=0)<<31>>31)|0;if((q|0)<(((B-E>>2)*9|0)+-9|0)){p=q+9216|0;x=(p|0)/9|0;q=I+(x+-1023<<2)|0;p=((p|0)%9|0)+1|0;if((p|0)<9){z=10;do{z=z*10|0;p=p+1|0}while((p|0)!=9)}else z=10;A=c[q>>2]|0;y=(A>>>0)%(z>>>0)|0;if((y|0)==0?(I+(x+-1022<<2)|0)==(B|0):0){X=u;W=q;T=v}else O=233;do if((O|0)==233){O=0;r=(((A>>>0)/(z>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;p=(z|0)/2|0;do if(y>>>0<p>>>0)w=.5;else{if((y|0)==(p|0)?(I+(x+-1022<<2)|0)==(B|0):0){w=1.0;break}w=1.5}while(0);do if(H){if((a[J>>0]|0)!=45)break;r=r*-1.0;w=w*-1.0}while(0);p=A-y|0;c[q>>2]=p;if(!(r+w!=r)){X=u;W=q;T=v;break}X=p+z|0;c[q>>2]=X;if(X>>>0>999999999)while(1){v=q+-4|0;c[q>>2]=0;if(v>>>0<u>>>0){u=u+-4|0;c[u>>2]=0}X=(c[v>>2]|0)+1|0;c[v>>2]=X;if(X>>>0>999999999)q=v;else{q=v;break}}v=(E-u>>2)*9|0;x=c[u>>2]|0;if(x>>>0<10){X=u;W=q;T=v;break}else p=10;do{p=p*10|0;v=v+1|0}while(x>>>0>=p>>>0);X=u;W=q;T=v}while(0);q=W+4|0;u=X;v=T;q=B>>>0>q>>>0?q:B}else q=B;A=0-v|0;G=q;while(1){if(G>>>0<=u>>>0){D=0;break}q=G+-4|0;if(!(c[q>>2]|0))G=q;else{D=1;break}}do if(C){f=((f|0)==0&1)+f|0;if((f|0)>(v|0)&(v|0)>-5){t=t+-1|0;f=f+-1-v|0}else{t=t+-2|0;f=f+-1|0}if(K&8)break;do if(D){z=c[G+-4>>2]|0;if(!z){p=9;break}if(!((z>>>0)%10|0)){q=10;p=0}else{p=0;break}do{q=q*10|0;p=p+1|0}while(((z>>>0)%(q>>>0)|0|0)==0)}else p=9;while(0);q=((G-E>>2)*9|0)+-9|0;if((t|32|0)==102){E=q-p|0;E=(E|0)<0?0:E;f=(f|0)<(E|0)?f:E;break}else{E=q+v-p|0;E=(E|0)<0?0:E;f=(f|0)<(E|0)?f:E;break}}while(0);x=(f|0)!=0;if(x)q=1;else q=(K&8|0)!=0;B=q&1;y=(t|32|0)==102;if(y){v=(v|0)>0?v:0;C=0}else{p=(v|0)<0?A:v;if((p|0)<0){q=Ja;z=p;p=((p|0)<0)<<31>>31;while(1){E=wf(z|0,p|0,10,0)|0;q=q+-1|0;a[q>>0]=E|48;E=z;z=vf(z|0,p|0,10,0)|0;if(!(p>>>0>9|(p|0)==9&E>>>0>4294967295))break;else p=F}}else{q=Ja;z=p}if(z)while(1){q=q+-1|0;a[q>>0]=(z>>>0)%10|0|48;if(z>>>0<10)break;else z=(z>>>0)/10|0}if((La-q|0)<2)do{q=q+-1|0;a[q>>0]=48}while((La-q|0)<2);a[q+-1>>0]=(v>>31&2)+43;C=q+-2|0;a[C>>0]=t;v=La-C|0}E=H+1+f+B+v|0;B=K&73728;A=(E|0)<(L|0);if((B|0)==0&A){v=L-E|0;ff(Xa|0,32,(v>>>0>256?256:v)|0)|0;if(v>>>0>255)do{Ze(Xa,256,e)|0;v=v+-256|0}while(v>>>0>255);Ze(Xa,v,e)|0}Ze(J,H,e)|0;if((B|0)==65536&A){v=L-E|0;ff(Xa|0,48,(v>>>0>256?256:v)|0)|0;if(v>>>0>255)do{Ze(Xa,256,e)|0;v=v+-256|0}while(v>>>0>255);Ze(Xa,v,e)|0}do if(y){z=u>>>0>I>>>0?I:u;t=z;do{u=c[t>>2]|0;if(!u)v=wa;else{v=wa;while(1){v=v+-1|0;a[v>>0]=(u>>>0)%10|0|48;if(u>>>0<10)break;else u=(u>>>0)/10|0}}do if((t|0)==(z|0)){if((v|0)!=(wa|0))break;a[ya>>0]=48;v=ya}else{if(v>>>0<=Pa>>>0)break;do{v=v+-1|0;a[v>>0]=48}while(v>>>0>Pa>>>0)}while(0);Ze(v,xa-v|0,e)|0;t=t+4|0}while(t>>>0<=I>>>0);if(!x?(K&8|0)==0:0)break;Ze(3256,1,e)|0;if(t>>>0<G>>>0&(f|0)>0){v=t;do{u=c[v>>2]|0;if(u){t=wa;while(1){t=t+-1|0;a[t>>0]=(u>>>0)%10|0|48;if(u>>>0<10)break;else u=(u>>>0)/10|0}if(t>>>0>Pa>>>0){$a=t;O=300}else ka=t}else{$a=wa;O=300}if((O|0)==300)while(1){O=0;q=$a+-1|0;a[q>>0]=48;if(q>>>0>Pa>>>0)$a=q;else{ka=q;break}}Ze(ka,(f|0)>9?9:f,e)|0;v=v+4|0;f=f+-9|0}while(v>>>0<G>>>0&(f|0)>0)}if((f|0)<=0)break;ff(Xa|0,48,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}else{p=D?G:u+4|0;do if((f|0)>-1){q=(K&8|0)!=0;z=u;do{v=c[z>>2]|0;if(v){t=wa;while(1){t=t+-1|0;a[t>>0]=(v>>>0)%10|0|48;if(v>>>0<10)break;else v=(v>>>0)/10|0}if((t|0)!=(wa|0))ab=t;else O=311}else O=311;if((O|0)==311){O=0;a[ya>>0]=48;ab=ya}do if((z|0)==(u|0)){v=ab+1|0;Ze(ab,1,e)|0;if(!((f|0)>0|q))break;Ze(3256,1,e)|0}else{if(ab>>>0>Pa>>>0)v=ab;else{v=ab;break}do{v=v+-1|0;a[v>>0]=48}while(v>>>0>Pa>>>0)}while(0);J=xa-v|0;Ze(v,(J|0)<(f|0)?J:f,e)|0;f=f-J|0;z=z+4|0}while(z>>>0<p>>>0&(f|0)>-1);if((f|0)<=0)break;ff(Xa|0,48,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}while(0);Ze(C,La-C|0,e)|0}while(0);if((B|0)==8192&A){f=L-E|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}D=Ca;G=Ba;f=M;v=_;q=A?L:E;E=N;continue a}case 105:case 100:{if((Ca|0)<0){Ea=ef(0,0,Ba|0,Ca|0)|0;Fa=F;Ya=1;Za=3160;O=89;break f}if(!(K&2048)){Za=K&1;Ea=Ba;Fa=Ca;Ya=Za;Za=(Za|0)==0?3160:3162;O=89}else{Ea=Ba;Fa=Ca;Ya=1;Za=3161;O=89}break}case 117:{Ea=Ba;Fa=Ca;Ya=0;Za=3160;O=89;break}case 111:{f=Ba;u=(f|0)==0&(Ca|0)==0;if(u)o=Aa;else{o=Aa;q=Ca;do{o=o+-1|0;a[o>>0]=f&7|48;f=kf(f|0,q|0,3)|0;q=F}while(!((f|0)==0&(q|0)==0))}if(!(K&8)){U=Ba;V=Ca;Q=K;R=v;S=0;P=3160;O=94}else{U=Ba;V=Ca;Q=K;R=v;S=u&1^1;P=u?3160:3165;O=94}break}default:{ha=Ca;ia=Ba;ja=f;n=K;aa=v;da=0;ea=3160;$=Aa}}while(0);h:do if((O|0)==77){p=Ba;f=bb&32;if(!((p|0)==0&(Ca|0)==0)){o=Aa;q=Ca;do{o=o+-1|0;a[o>>0]=d[3240+(p&15)>>0]|f;p=kf(p|0,q|0,4)|0;q=F}while(!((p|0)==0&(q|0)==0));if(!(Sa&8)){U=Ba;V=Ca;Q=Sa;R=Va;S=0;P=3160;O=94}else{U=Ba;V=Ca;Q=Sa;R=Va;S=2;P=3160+(bb>>4)|0;O=94}}else{U=Ba;V=Ca;o=Aa;Q=Sa;R=Va;S=0;P=3160;O=94}}else if((O|0)==89){p=Ea;if(Fa>>>0>0|(Fa|0)==0&p>>>0>4294967295){o=Aa;q=Fa;while(1){V=wf(p|0,q|0,10,0)|0;o=o+-1|0;a[o>>0]=V|48;V=p;p=vf(p|0,q|0,10,0)|0;if(!(q>>>0>9|(q|0)==9&V>>>0>4294967295))break;else q=F}}else o=Aa;if(!p){U=Ea;V=Fa;Q=K;R=v;S=Ya;P=Za;O=94}else while(1){o=o+-1|0;a[o>>0]=(p>>>0)%10|0|48;if(p>>>0<10){U=Ea;V=Fa;Q=K;R=v;S=Ya;P=Za;O=94;break}else p=(p>>>0)/10|0}}else if((O|0)==99){O=0;f=cf(Na,0,v)|0;if(!f){ha=Ca;ia=Ba;ja=Na;n=z;aa=v;da=0;ea=3160;$=Na+v|0;break}else{ha=Ca;ia=Ba;ja=Na;n=z;aa=f-Na|0;da=0;ea=3160;$=f;break}}else if((O|0)==104){s=0;f=0;p=sa;while(1){q=c[p>>2]|0;if(!q){q=s;break}f=We(Ua,q)|0;if((f|0)<=-1){eb=-1;O=362;break a}q=f+s|0;if(f>>>0>(Wa-s|0)>>>0){Y=sa;Z=ta;O=110;break h}if(q>>>0<Wa>>>0){s=q;p=p+4|0}else break}if((f|0)<0){eb=-1;O=362;break a}else{Y=sa;Z=ta;s=q;O=110}}while(0);if((O|0)==94){O=0;n=(R|0)>-1?Q&-65537:Q;p=(U|0)==0&(V|0)==0;if(p&(R|0)==0){ha=V;ia=U;ja=Aa;aa=0;da=S;ea=P;$=Aa}else{aa=(p&1)+(Ga-o)|0;ha=V;ia=U;ja=o;aa=(R|0)>(aa|0)?R:aa;da=S;ea=P;$=Aa}}else if((O|0)==110){O=0;v=K&73728;z=(s|0)<(L|0);if((v|0)==0&z){f=L-s|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}i:do if(s){q=0;t=Y;while(1){f=c[t>>2]|0;if(!f)break i;f=We(Ua,f)|0;q=f+q|0;if((q|0)>(s|0))break i;Ze(Ua,f,e)|0;if(q>>>0>=s>>>0)break;else t=t+4|0}}while(0);if((v|0)==8192&z){f=L-s|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}D=Ca;G=Z;f=M;v=_;q=z?L:s;E=N;continue}t=$-ja|0;v=(aa|0)<(t|0)?t:aa;p=da+v|0;q=(L|0)<(p|0)?p:L;z=n&73728;u=(p|0)<(q|0);if((z|0)==0&u){f=q-p|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}Ze(ea,da,e)|0;if((z|0)==65536&u){f=q-p|0;ff(Xa|0,48,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}if((t|0)<(v|0)){f=v-t|0;ff(Xa|0,48,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0}Ze(ja,t,e)|0;if(!((z|0)==8192&u)){D=ha;G=ia;f=M;v=_;E=N;continue}f=q-p|0;ff(Xa|0,32,(f>>>0>256?256:f)|0)|0;if(f>>>0>255)do{Ze(Xa,256,e)|0;f=f+-256|0}while(f>>>0>255);Ze(Xa,f,e)|0;D=ha;G=ia;f=M;v=_;E=N}if((O|0)==344){if(e){m=_;i=gb;return m|0}if(!E){m=0;i=gb;return m|0}else p=1;while(1){n=c[m+(p<<2)>>2]|0;if(!n){fb=p;break}o=l+(p<<3)|0;j:do if(n>>>0<=20)do switch(n|0){case 9:{cb=c[g>>2]|0;db=c[cb>>2]|0;c[g>>2]=cb+4;c[o>>2]=db;break j}case 10:{db=c[g>>2]|0;cb=c[db>>2]|0;c[g>>2]=db+4;db=o;c[db>>2]=cb;c[db+4>>2]=((cb|0)<0)<<31>>31;break j}case 11:{db=c[g>>2]|0;cb=c[db>>2]|0;c[g>>2]=db+4;db=o;c[db>>2]=cb;c[db+4>>2]=0;break j}case 12:{db=c[g>>2]|0;cb=db;bb=c[cb>>2]|0;cb=c[cb+4>>2]|0;c[g>>2]=db+8;db=o;c[db>>2]=bb;c[db+4>>2]=cb;break j}case 13:{db=c[g>>2]|0;cb=c[db>>2]|0;c[g>>2]=db+4;cb=(cb&65535)<<16>>16;db=o;c[db>>2]=cb;c[db+4>>2]=((cb|0)<0)<<31>>31;break j}case 14:{db=c[g>>2]|0;cb=c[db>>2]|0;c[g>>2]=db+4;db=o;c[db>>2]=cb&65535;c[db+4>>2]=0;break j}case 15:{db=c[g>>2]|0;cb=c[db>>2]|0;c[g>>2]=db+4;cb=(cb&255)<<24>>24;db=o;c[db>>2]=cb;c[db+4>>2]=((cb|0)<0)<<31>>31;break j}case 16:{db=c[g>>2]|0;cb=c[db>>2]|0;c[g>>2]=db+4;db=o;c[db>>2]=cb&255;c[db+4>>2]=0;break j}case 17:{db=c[g>>2]|0;c[k>>2]=c[db>>2];c[k+4>>2]=c[db+4>>2];w=+h[k>>3];c[g>>2]=db+8;h[o>>3]=w;break j}case 18:{db=c[g>>2]|0;c[k>>2]=c[db>>2];c[k+4>>2]=c[db+4>>2];w=+h[k>>3];c[g>>2]=db+8;h[o>>3]=w;break j}default:break j}while(0);while(0);p=p+1|0;if((p|0)>=10){eb=1;O=362;break}}if((O|0)==362){i=gb;return eb|0}while(1){if(c[m+(fb<<2)>>2]|0){eb=-1;O=362;break}fb=fb+1|0;if((fb|0)>=10){eb=1;O=362;break}}if((O|0)==362){i=gb;return eb|0}}else if((O|0)==362){i=gb;return eb|0}return 0}function af(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,k=0,l=0,m=0,n=0;n=i;i=i+128|0;if((i|0)>=(j|0))ca();g=n+112|0;m=n;h=m+0|0;k=3264|0;l=h+112|0;do{c[h>>2]=c[k>>2];h=h+4|0;k=k+4|0}while((h|0)<(l|0));if((d+-1|0)>>>0>2147483646)if(!d)d=1;else{c[(Ra()|0)>>2]=75;e=-1;i=n;return e|0}else g=b;l=-2-g|0;l=d>>>0>l>>>0?l:d;c[m+48>>2]=l;b=m+20|0;c[b>>2]=g;c[m+44>>2]=g;d=g+l|0;g=m+16|0;c[g>>2]=d;c[m+28>>2]=d;d=_e(m,e,f)|0;if(!l){e=d;i=n;return e|0}e=c[b>>2]|0;a[e+(((e|0)==(c[g>>2]|0))<<31>>31)>>0]=0;e=d;i=n;return e|0}function bf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;f=a+20|0;g=c[f>>2]|0;a=(c[a+16>>2]|0)-g|0;a=a>>>0>d>>>0?d:a;lf(g|0,b|0,a|0)|0;c[f>>2]=(c[f>>2]|0)+a;i=e;return d|0}function cf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;h=d&255;f=(e|0)==0;a:do if((b&3|0)==0|f)g=5;else{g=d&255;while(1){if((a[b>>0]|0)==g<<24>>24){g=6;break a}b=b+1|0;e=e+-1|0;f=(e|0)==0;if((b&3|0)==0|f){g=5;break}}}while(0);if((g|0)==5)if(f)e=0;else g=6;b:do if((g|0)==6){g=d&255;if((a[b>>0]|0)!=g<<24>>24){f=ba(h,16843009)|0;c:do if(e>>>0>3)do{h=c[b>>2]^f;if((h&-2139062144^-2139062144)&h+-16843009)break c;b=b+4|0;e=e+-4|0}while(e>>>0>3);while(0);if(!e)e=0;else while(1){if((a[b>>0]|0)==g<<24>>24)break b;b=b+1|0;e=e+-1|0;if(!e){e=0;break}}}}while(0);i=j;return ((e|0)!=0?b:0)|0}function df(){}function ef(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=b-d-(c>>>0>a>>>0|0)>>>0;return (F=d,a-c>>>0|0)|0}function ff(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b+e|0;if((e|0)>=20){d=d&255;h=b&3;i=d|d<<8|d<<16|d<<24;g=f&~3;if(h){h=b+4-h|0;while((b|0)<(h|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(g|0)){c[b>>2]=i;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function gf(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){F=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}F=a<<c-32;return 0}function hf(b){b=b|0;var c=0;c=b;while(a[c>>0]|0)c=c+1|0;return c-b|0}function jf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=a+c>>>0;return (F=b+d+(c>>>0<a>>>0|0)>>>0,c|0)|0}function kf(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){F=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}F=0;return b>>>c-32|0}function lf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return Ga(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function mf(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else lf(b,c,d)|0;return b|0}function nf(b,c){b=b|0;c=c|0;var d=0;do{a[b+d>>0]=a[c+d>>0];d=d+1|0}while(a[c+(d-1)>>0]|0);return b|0}function of(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){F=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}F=(b|0)<0?-1:0;return b>>c-32|0}function pf(b){b=b|0;var c=0;c=a[n+(b>>>24)>>0]|0;if((c|0)<8)return c|0;c=a[n+(b>>16&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[n+(b>>8&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[n+(b&255)>>0]|0)+24|0}function qf(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function rf(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;f=a&65535;e=b&65535;c=ba(e,f)|0;d=a>>>16;a=(c>>>16)+(ba(e,d)|0)|0;e=b>>>16;b=ba(e,f)|0;return (F=(a>>>16)+(ba(e,d)|0)+(((a&65535)+b|0)>>>16)|0,a+b<<16|c&65535|0)|0}function sf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;j=b>>31|((b|0)<0?-1:0)<<1;i=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;f=d>>31|((d|0)<0?-1:0)<<1;e=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;h=ef(j^a,i^b,j,i)|0;g=F;a=f^j;b=e^i;d=ef((xf(h,g,ef(f^c,e^d,f,e)|0,F,0)|0)^a,F^b,a,b)|0;return d|0}function tf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+8|0;j=f|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;l=e>>31|((e|0)<0?-1:0)<<1;k=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;a=ef(h^a,g^b,h,g)|0;b=F;xf(a,b,ef(l^d,k^e,l,k)|0,F,j)|0;e=ef(c[j>>2]^h,c[j+4>>2]^g,h,g)|0;d=F;i=f;return (F=d,e)|0}function uf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=a;f=c;c=rf(e,f)|0;a=F;return (F=(ba(b,f)|0)+(ba(d,e)|0)+a|a&0,c|0|0)|0}function vf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=xf(a,b,c,d,0)|0;return d|0}function wf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;i=i+8|0;f=g|0;xf(a,b,d,e,f)|0;i=g;return (F=c[f+4>>2]|0,c[f>>2]|0)|0}function xf(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;n=a;l=b;m=l;k=d;o=e;i=o;if(!m){g=(f|0)!=0;if(!i){if(g){c[f>>2]=(n>>>0)%(k>>>0);c[f+4>>2]=0}o=0;f=(n>>>0)/(k>>>0)>>>0;return (F=o,f)|0}else{if(!g){o=0;f=0;return (F=o,f)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;o=0;f=0;return (F=o,f)|0}}j=(i|0)==0;do if(k){if(!j){h=(pf(i|0)|0)-(pf(m|0)|0)|0;if(h>>>0<=31){g=h+1|0;l=31-h|0;k=h-31>>31;i=g;j=n>>>(g>>>0)&k|m<<l;k=m>>>(g>>>0)&k;g=0;h=n<<l;break}if(!f){o=0;f=0;return (F=o,f)|0}c[f>>2]=a|0;c[f+4>>2]=l|b&0;o=0;f=0;return (F=o,f)|0}j=k-1|0;if(j&k){h=(pf(k|0)|0)+33-(pf(m|0)|0)|0;p=64-h|0;l=32-h|0;a=l>>31;b=h-32|0;k=b>>31;i=h;j=l-1>>31&m>>>(b>>>0)|(m<<l|n>>>(h>>>0))&k;k=k&m>>>(h>>>0);g=n<<p&a;h=(m<<p|n>>>(b>>>0))&a|n<<l&h-33>>31;break}if(f){c[f>>2]=j&n;c[f+4>>2]=0}if((k|0)==1){f=l|b&0;p=a|0|0;return (F=f,p)|0}else{p=qf(k|0)|0;f=m>>>(p>>>0)|0;p=m<<32-p|n>>>(p>>>0)|0;return (F=f,p)|0}}else{if(j){if(f){c[f>>2]=(m>>>0)%(k>>>0);c[f+4>>2]=0}f=0;p=(m>>>0)/(k>>>0)>>>0;return (F=f,p)|0}if(!n){if(f){c[f>>2]=0;c[f+4>>2]=(m>>>0)%(i>>>0)}f=0;p=(m>>>0)/(i>>>0)>>>0;return (F=f,p)|0}j=i-1|0;if(!(j&i)){if(f){c[f>>2]=a|0;c[f+4>>2]=j&m|b&0}f=0;p=m>>>((qf(i|0)|0)>>>0);return (F=f,p)|0}h=(pf(i|0)|0)-(pf(m|0)|0)|0;if(h>>>0<=30){k=h+1|0;h=31-h|0;i=k;j=m<<h|n>>>(k>>>0);k=m>>>(k>>>0);g=0;h=n<<h;break}if(!f){f=0;p=0;return (F=f,p)|0}c[f>>2]=a|0;c[f+4>>2]=l|b&0;f=0;p=0;return (F=f,p)|0}while(0);if(!i){l=h;i=0;h=0}else{m=d|0|0;l=o|e&0;b=jf(m,l,-1,-1)|0;a=F;d=h;h=0;do{n=d;d=g>>>31|d<<1;g=h|g<<1;n=j<<1|n>>>31|0;e=j>>>31|k<<1|0;ef(b,a,n,e)|0;p=F;o=p>>31|((p|0)<0?-1:0)<<1;h=o&1;j=ef(n,e,o&m,(((p|0)<0?-1:0)>>31|((p|0)<0?-1:0)<<1)&l)|0;k=F;i=i-1|0}while((i|0)!=0);l=d;i=0}d=0;if(f){c[f>>2]=j;c[f+4>>2]=k}f=(g|0)>>>31|(l|d)<<1|(d<<1|g>>>31)&0|i;p=(g<<1|0>>>31)&-2|h;return (F=f,p)|0}function yf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return cb[a&3](b|0,c|0,d|0)|0}function zf(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;db[a&3](b|0,c|0,d|0,e|0,f|0)}function Af(a,b){a=a|0;b=b|0;eb[a&31](b|0)}function Bf(a,b,c){a=a|0;b=b|0;c=c|0;fb[a&7](b|0,c|0)}function Cf(a,b){a=a|0;b=b|0;return gb[a&1](b|0)|0}function Df(a){a=a|0;hb[a&3]()}function Ef(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ib[a&3](b|0,c|0,d|0,e|0,f|0,g|0)}function Ff(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;jb[a&3](b|0,c|0,d|0,e|0)}function Gf(a,b,c){a=a|0;b=b|0;c=c|0;fa(0);return 0}function Hf(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ga(1)}function If(a){a=a|0;ha(2)}function Jf(a,b){a=a|0;b=b|0;ia(3)}function Kf(a){a=a|0;ja(4);return 0}function Lf(){ka(5)}function Mf(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;la(6)}function Nf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ma(7)}

// EMSCRIPTEN_END_FUNCS
var cb=[Gf,De,bf,Gf];var db=[Hf,Ke,Je,Hf];var eb=[If,dc,ec,fc,gc,hc,ic,Td,Ud,re,qe,ye,Be,ze,Ae,Ce,Sb,ne,If,If,If,If,If,If,If,If,If,If,If,If,If,If];var fb=[Jf,Jb,Kb,Lb,Vd,Jf,Jf,Jf];var gb=[Kf,se];var hb=[Lf,ke,me,Lf];var ib=[Mf,Me,Le,Mf];var jb=[Nf,Fe,Ge,Nf];return{_strlen:hf,_rl_new_block:Wb,_rl_block_add_branch_to:Zb,_rl_relooper_calculate:bc,_rl_set_output_buffer:Tb,_rl_make_output_buffer:Ub,_bitshift64Lshr:kf,_rl_relooper_render:cc,_bitshift64Shl:gf,_rl_relooper_add_block:ac,___cxa_is_pointer_type:Oe,_rl_set_block_code:Xb,_memset:ff,_memcpy:lf,_rl_delete_relooper:$b,_rl_set_asm_js_mode:Vb,_i64Subtract:ef,_realloc:Re,_i64Add:jf,___cxa_can_catch:Ne,_free:Qe,_memmove:mf,_malloc:Pe,_rl_new_relooper:_b,_rl_delete_block:Yb,_strcpy:nf,__GLOBAL__I_a:fe,runPostSets:df,stackAlloc:kb,stackSave:lb,stackRestore:mb,setThrew:nb,setTempRet0:qb,getTempRet0:rb,dynCall_iiii:yf,dynCall_viiiii:zf,dynCall_vi:Af,dynCall_vii:Bf,dynCall_ii:Cf,dynCall_v:Df,dynCall_viiiiii:Ef,dynCall_viiii:Ff}})


// EMSCRIPTEN_END_ASM
(Module.asmGlobalArg,Module.asmLibraryArg,buffer);var real__strlen=asm["_strlen"];asm["_strlen"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__strlen.apply(null,arguments)});var real__rl_new_block=asm["_rl_new_block"];asm["_rl_new_block"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_new_block.apply(null,arguments)});var real__rl_block_add_branch_to=asm["_rl_block_add_branch_to"];asm["_rl_block_add_branch_to"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_block_add_branch_to.apply(null,arguments)});var real__rl_relooper_calculate=asm["_rl_relooper_calculate"];asm["_rl_relooper_calculate"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_relooper_calculate.apply(null,arguments)});var real__rl_set_output_buffer=asm["_rl_set_output_buffer"];asm["_rl_set_output_buffer"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_set_output_buffer.apply(null,arguments)});var real__rl_make_output_buffer=asm["_rl_make_output_buffer"];asm["_rl_make_output_buffer"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_make_output_buffer.apply(null,arguments)});var real__bitshift64Lshr=asm["_bitshift64Lshr"];asm["_bitshift64Lshr"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__bitshift64Lshr.apply(null,arguments)});var real__rl_relooper_render=asm["_rl_relooper_render"];asm["_rl_relooper_render"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_relooper_render.apply(null,arguments)});var real__bitshift64Shl=asm["_bitshift64Shl"];asm["_bitshift64Shl"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__bitshift64Shl.apply(null,arguments)});var real__rl_relooper_add_block=asm["_rl_relooper_add_block"];asm["_rl_relooper_add_block"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_relooper_add_block.apply(null,arguments)});var real____cxa_is_pointer_type=asm["___cxa_is_pointer_type"];asm["___cxa_is_pointer_type"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real____cxa_is_pointer_type.apply(null,arguments)});var real__rl_set_block_code=asm["_rl_set_block_code"];asm["_rl_set_block_code"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_set_block_code.apply(null,arguments)});var real__rl_delete_relooper=asm["_rl_delete_relooper"];asm["_rl_delete_relooper"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_delete_relooper.apply(null,arguments)});var real__rl_set_asm_js_mode=asm["_rl_set_asm_js_mode"];asm["_rl_set_asm_js_mode"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_set_asm_js_mode.apply(null,arguments)});var real__i64Subtract=asm["_i64Subtract"];asm["_i64Subtract"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__i64Subtract.apply(null,arguments)});var real__realloc=asm["_realloc"];asm["_realloc"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__realloc.apply(null,arguments)});var real__i64Add=asm["_i64Add"];asm["_i64Add"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__i64Add.apply(null,arguments)});var real____cxa_can_catch=asm["___cxa_can_catch"];asm["___cxa_can_catch"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real____cxa_can_catch.apply(null,arguments)});var real__memmove=asm["_memmove"];asm["_memmove"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__memmove.apply(null,arguments)});var real__rl_new_relooper=asm["_rl_new_relooper"];asm["_rl_new_relooper"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_new_relooper.apply(null,arguments)});var real__rl_delete_block=asm["_rl_delete_block"];asm["_rl_delete_block"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__rl_delete_block.apply(null,arguments)});var real__strcpy=asm["_strcpy"];asm["_strcpy"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real__strcpy.apply(null,arguments)});var real___GLOBAL__I_a=asm["__GLOBAL__I_a"];asm["__GLOBAL__I_a"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real___GLOBAL__I_a.apply(null,arguments)});var real_runPostSets=asm["runPostSets"];asm["runPostSets"]=(function(){assert(runtimeInitialized,"you need to wait for the runtime to be ready (e.g. wait for main() to be called)");assert(!runtimeExited,"the runtime was exited (use NO_EXIT_RUNTIME to keep it alive after main() exits)");return real_runPostSets.apply(null,arguments)});var _strlen=Module["_strlen"]=asm["_strlen"];var _rl_new_block=Module["_rl_new_block"]=asm["_rl_new_block"];var _rl_block_add_branch_to=Module["_rl_block_add_branch_to"]=asm["_rl_block_add_branch_to"];var _rl_relooper_calculate=Module["_rl_relooper_calculate"]=asm["_rl_relooper_calculate"];var _rl_set_output_buffer=Module["_rl_set_output_buffer"]=asm["_rl_set_output_buffer"];var _rl_make_output_buffer=Module["_rl_make_output_buffer"]=asm["_rl_make_output_buffer"];var _bitshift64Lshr=Module["_bitshift64Lshr"]=asm["_bitshift64Lshr"];var _rl_relooper_render=Module["_rl_relooper_render"]=asm["_rl_relooper_render"];var _bitshift64Shl=Module["_bitshift64Shl"]=asm["_bitshift64Shl"];var _rl_relooper_add_block=Module["_rl_relooper_add_block"]=asm["_rl_relooper_add_block"];var ___cxa_is_pointer_type=Module["___cxa_is_pointer_type"]=asm["___cxa_is_pointer_type"];var _rl_set_block_code=Module["_rl_set_block_code"]=asm["_rl_set_block_code"];var _memset=Module["_memset"]=asm["_memset"];var _memcpy=Module["_memcpy"]=asm["_memcpy"];var _rl_delete_relooper=Module["_rl_delete_relooper"]=asm["_rl_delete_relooper"];var _rl_set_asm_js_mode=Module["_rl_set_asm_js_mode"]=asm["_rl_set_asm_js_mode"];var _i64Subtract=Module["_i64Subtract"]=asm["_i64Subtract"];var _realloc=Module["_realloc"]=asm["_realloc"];var _i64Add=Module["_i64Add"]=asm["_i64Add"];var ___cxa_can_catch=Module["___cxa_can_catch"]=asm["___cxa_can_catch"];var _free=Module["_free"]=asm["_free"];var _memmove=Module["_memmove"]=asm["_memmove"];var _malloc=Module["_malloc"]=asm["_malloc"];var _rl_new_relooper=Module["_rl_new_relooper"]=asm["_rl_new_relooper"];var _rl_delete_block=Module["_rl_delete_block"]=asm["_rl_delete_block"];var _strcpy=Module["_strcpy"]=asm["_strcpy"];var __GLOBAL__I_a=Module["__GLOBAL__I_a"]=asm["__GLOBAL__I_a"];var runPostSets=Module["runPostSets"]=asm["runPostSets"];var dynCall_iiii=Module["dynCall_iiii"]=asm["dynCall_iiii"];var dynCall_viiiii=Module["dynCall_viiiii"]=asm["dynCall_viiiii"];var dynCall_vi=Module["dynCall_vi"]=asm["dynCall_vi"];var dynCall_vii=Module["dynCall_vii"]=asm["dynCall_vii"];var dynCall_ii=Module["dynCall_ii"]=asm["dynCall_ii"];var dynCall_v=Module["dynCall_v"]=asm["dynCall_v"];var dynCall_viiiiii=Module["dynCall_viiiiii"]=asm["dynCall_viiiiii"];var dynCall_viiii=Module["dynCall_viiii"]=asm["dynCall_viiii"];Runtime.stackAlloc=asm["stackAlloc"];Runtime.stackSave=asm["stackSave"];Runtime.stackRestore=asm["stackRestore"];Runtime.setTempRet0=asm["setTempRet0"];Runtime.getTempRet0=asm["getTempRet0"];var i64Math=(function(){var goog={math:{}};goog.math.Long=(function(low,high){this.low_=low|0;this.high_=high|0});goog.math.Long.IntCache_={};goog.math.Long.fromInt=(function(value){if(-128<=value&&value<128){var cachedObj=goog.math.Long.IntCache_[value];if(cachedObj){return cachedObj}}var obj=new goog.math.Long(value|0,value<0?-1:0);if(-128<=value&&value<128){goog.math.Long.IntCache_[value]=obj}return obj});goog.math.Long.fromNumber=(function(value){if(isNaN(value)||!isFinite(value)){return goog.math.Long.ZERO}else if(value<=-goog.math.Long.TWO_PWR_63_DBL_){return goog.math.Long.MIN_VALUE}else if(value+1>=goog.math.Long.TWO_PWR_63_DBL_){return goog.math.Long.MAX_VALUE}else if(value<0){return goog.math.Long.fromNumber(-value).negate()}else{return new goog.math.Long(value%goog.math.Long.TWO_PWR_32_DBL_|0,value/goog.math.Long.TWO_PWR_32_DBL_|0)}});goog.math.Long.fromBits=(function(lowBits,highBits){return new goog.math.Long(lowBits,highBits)});goog.math.Long.fromString=(function(str,opt_radix){if(str.length==0){throw Error("number format error: empty string")}var radix=opt_radix||10;if(radix<2||36<radix){throw Error("radix out of range: "+radix)}if(str.charAt(0)=="-"){return goog.math.Long.fromString(str.substring(1),radix).negate()}else if(str.indexOf("-")>=0){throw Error('number format error: interior "-" character: '+str)}var radixToPower=goog.math.Long.fromNumber(Math.pow(radix,8));var result=goog.math.Long.ZERO;for(var i=0;i<str.length;i+=8){var size=Math.min(8,str.length-i);var value=parseInt(str.substring(i,i+size),radix);if(size<8){var power=goog.math.Long.fromNumber(Math.pow(radix,size));result=result.multiply(power).add(goog.math.Long.fromNumber(value))}else{result=result.multiply(radixToPower);result=result.add(goog.math.Long.fromNumber(value))}}return result});goog.math.Long.TWO_PWR_16_DBL_=1<<16;goog.math.Long.TWO_PWR_24_DBL_=1<<24;goog.math.Long.TWO_PWR_32_DBL_=goog.math.Long.TWO_PWR_16_DBL_*goog.math.Long.TWO_PWR_16_DBL_;goog.math.Long.TWO_PWR_31_DBL_=goog.math.Long.TWO_PWR_32_DBL_/2;goog.math.Long.TWO_PWR_48_DBL_=goog.math.Long.TWO_PWR_32_DBL_*goog.math.Long.TWO_PWR_16_DBL_;goog.math.Long.TWO_PWR_64_DBL_=goog.math.Long.TWO_PWR_32_DBL_*goog.math.Long.TWO_PWR_32_DBL_;goog.math.Long.TWO_PWR_63_DBL_=goog.math.Long.TWO_PWR_64_DBL_/2;goog.math.Long.ZERO=goog.math.Long.fromInt(0);goog.math.Long.ONE=goog.math.Long.fromInt(1);goog.math.Long.NEG_ONE=goog.math.Long.fromInt(-1);goog.math.Long.MAX_VALUE=goog.math.Long.fromBits(4294967295|0,2147483647|0);goog.math.Long.MIN_VALUE=goog.math.Long.fromBits(0,2147483648|0);goog.math.Long.TWO_PWR_24_=goog.math.Long.fromInt(1<<24);goog.math.Long.prototype.toInt=(function(){return this.low_});goog.math.Long.prototype.toNumber=(function(){return this.high_*goog.math.Long.TWO_PWR_32_DBL_+this.getLowBitsUnsigned()});goog.math.Long.prototype.toString=(function(opt_radix){var radix=opt_radix||10;if(radix<2||36<radix){throw Error("radix out of range: "+radix)}if(this.isZero()){return"0"}if(this.isNegative()){if(this.equals(goog.math.Long.MIN_VALUE)){var radixLong=goog.math.Long.fromNumber(radix);var div=this.div(radixLong);var rem=div.multiply(radixLong).subtract(this);return div.toString(radix)+rem.toInt().toString(radix)}else{return"-"+this.negate().toString(radix)}}var radixToPower=goog.math.Long.fromNumber(Math.pow(radix,6));var rem=this;var result="";while(true){var remDiv=rem.div(radixToPower);var intval=rem.subtract(remDiv.multiply(radixToPower)).toInt();var digits=intval.toString(radix);rem=remDiv;if(rem.isZero()){return digits+result}else{while(digits.length<6){digits="0"+digits}result=""+digits+result}}});goog.math.Long.prototype.getHighBits=(function(){return this.high_});goog.math.Long.prototype.getLowBits=(function(){return this.low_});goog.math.Long.prototype.getLowBitsUnsigned=(function(){return this.low_>=0?this.low_:goog.math.Long.TWO_PWR_32_DBL_+this.low_});goog.math.Long.prototype.getNumBitsAbs=(function(){if(this.isNegative()){if(this.equals(goog.math.Long.MIN_VALUE)){return 64}else{return this.negate().getNumBitsAbs()}}else{var val=this.high_!=0?this.high_:this.low_;for(var bit=31;bit>0;bit--){if((val&1<<bit)!=0){break}}return this.high_!=0?bit+33:bit+1}});goog.math.Long.prototype.isZero=(function(){return this.high_==0&&this.low_==0});goog.math.Long.prototype.isNegative=(function(){return this.high_<0});goog.math.Long.prototype.isOdd=(function(){return(this.low_&1)==1});goog.math.Long.prototype.equals=(function(other){return this.high_==other.high_&&this.low_==other.low_});goog.math.Long.prototype.notEquals=(function(other){return this.high_!=other.high_||this.low_!=other.low_});goog.math.Long.prototype.lessThan=(function(other){return this.compare(other)<0});goog.math.Long.prototype.lessThanOrEqual=(function(other){return this.compare(other)<=0});goog.math.Long.prototype.greaterThan=(function(other){return this.compare(other)>0});goog.math.Long.prototype.greaterThanOrEqual=(function(other){return this.compare(other)>=0});goog.math.Long.prototype.compare=(function(other){if(this.equals(other)){return 0}var thisNeg=this.isNegative();var otherNeg=other.isNegative();if(thisNeg&&!otherNeg){return-1}if(!thisNeg&&otherNeg){return 1}if(this.subtract(other).isNegative()){return-1}else{return 1}});goog.math.Long.prototype.negate=(function(){if(this.equals(goog.math.Long.MIN_VALUE)){return goog.math.Long.MIN_VALUE}else{return this.not().add(goog.math.Long.ONE)}});goog.math.Long.prototype.add=(function(other){var a48=this.high_>>>16;var a32=this.high_&65535;var a16=this.low_>>>16;var a00=this.low_&65535;var b48=other.high_>>>16;var b32=other.high_&65535;var b16=other.low_>>>16;var b00=other.low_&65535;var c48=0,c32=0,c16=0,c00=0;c00+=a00+b00;c16+=c00>>>16;c00&=65535;c16+=a16+b16;c32+=c16>>>16;c16&=65535;c32+=a32+b32;c48+=c32>>>16;c32&=65535;c48+=a48+b48;c48&=65535;return goog.math.Long.fromBits(c16<<16|c00,c48<<16|c32)});goog.math.Long.prototype.subtract=(function(other){return this.add(other.negate())});goog.math.Long.prototype.multiply=(function(other){if(this.isZero()){return goog.math.Long.ZERO}else if(other.isZero()){return goog.math.Long.ZERO}if(this.equals(goog.math.Long.MIN_VALUE)){return other.isOdd()?goog.math.Long.MIN_VALUE:goog.math.Long.ZERO}else if(other.equals(goog.math.Long.MIN_VALUE)){return this.isOdd()?goog.math.Long.MIN_VALUE:goog.math.Long.ZERO}if(this.isNegative()){if(other.isNegative()){return this.negate().multiply(other.negate())}else{return this.negate().multiply(other).negate()}}else if(other.isNegative()){return this.multiply(other.negate()).negate()}if(this.lessThan(goog.math.Long.TWO_PWR_24_)&&other.lessThan(goog.math.Long.TWO_PWR_24_)){return goog.math.Long.fromNumber(this.toNumber()*other.toNumber())}var a48=this.high_>>>16;var a32=this.high_&65535;var a16=this.low_>>>16;var a00=this.low_&65535;var b48=other.high_>>>16;var b32=other.high_&65535;var b16=other.low_>>>16;var b00=other.low_&65535;var c48=0,c32=0,c16=0,c00=0;c00+=a00*b00;c16+=c00>>>16;c00&=65535;c16+=a16*b00;c32+=c16>>>16;c16&=65535;c16+=a00*b16;c32+=c16>>>16;c16&=65535;c32+=a32*b00;c48+=c32>>>16;c32&=65535;c32+=a16*b16;c48+=c32>>>16;c32&=65535;c32+=a00*b32;c48+=c32>>>16;c32&=65535;c48+=a48*b00+a32*b16+a16*b32+a00*b48;c48&=65535;return goog.math.Long.fromBits(c16<<16|c00,c48<<16|c32)});goog.math.Long.prototype.div=(function(other){if(other.isZero()){throw Error("division by zero")}else if(this.isZero()){return goog.math.Long.ZERO}if(this.equals(goog.math.Long.MIN_VALUE)){if(other.equals(goog.math.Long.ONE)||other.equals(goog.math.Long.NEG_ONE)){return goog.math.Long.MIN_VALUE}else if(other.equals(goog.math.Long.MIN_VALUE)){return goog.math.Long.ONE}else{var halfThis=this.shiftRight(1);var approx=halfThis.div(other).shiftLeft(1);if(approx.equals(goog.math.Long.ZERO)){return other.isNegative()?goog.math.Long.ONE:goog.math.Long.NEG_ONE}else{var rem=this.subtract(other.multiply(approx));var result=approx.add(rem.div(other));return result}}}else if(other.equals(goog.math.Long.MIN_VALUE)){return goog.math.Long.ZERO}if(this.isNegative()){if(other.isNegative()){return this.negate().div(other.negate())}else{return this.negate().div(other).negate()}}else if(other.isNegative()){return this.div(other.negate()).negate()}var res=goog.math.Long.ZERO;var rem=this;while(rem.greaterThanOrEqual(other)){var approx=Math.max(1,Math.floor(rem.toNumber()/other.toNumber()));var log2=Math.ceil(Math.log(approx)/Math.LN2);var delta=log2<=48?1:Math.pow(2,log2-48);var approxRes=goog.math.Long.fromNumber(approx);var approxRem=approxRes.multiply(other);while(approxRem.isNegative()||approxRem.greaterThan(rem)){approx-=delta;approxRes=goog.math.Long.fromNumber(approx);approxRem=approxRes.multiply(other)}if(approxRes.isZero()){approxRes=goog.math.Long.ONE}res=res.add(approxRes);rem=rem.subtract(approxRem)}return res});goog.math.Long.prototype.modulo=(function(other){return this.subtract(this.div(other).multiply(other))});goog.math.Long.prototype.not=(function(){return goog.math.Long.fromBits(~this.low_,~this.high_)});goog.math.Long.prototype.and=(function(other){return goog.math.Long.fromBits(this.low_&other.low_,this.high_&other.high_)});goog.math.Long.prototype.or=(function(other){return goog.math.Long.fromBits(this.low_|other.low_,this.high_|other.high_)});goog.math.Long.prototype.xor=(function(other){return goog.math.Long.fromBits(this.low_^other.low_,this.high_^other.high_)});goog.math.Long.prototype.shiftLeft=(function(numBits){numBits&=63;if(numBits==0){return this}else{var low=this.low_;if(numBits<32){var high=this.high_;return goog.math.Long.fromBits(low<<numBits,high<<numBits|low>>>32-numBits)}else{return goog.math.Long.fromBits(0,low<<numBits-32)}}});goog.math.Long.prototype.shiftRight=(function(numBits){numBits&=63;if(numBits==0){return this}else{var high=this.high_;if(numBits<32){var low=this.low_;return goog.math.Long.fromBits(low>>>numBits|high<<32-numBits,high>>numBits)}else{return goog.math.Long.fromBits(high>>numBits-32,high>=0?0:-1)}}});goog.math.Long.prototype.shiftRightUnsigned=(function(numBits){numBits&=63;if(numBits==0){return this}else{var high=this.high_;if(numBits<32){var low=this.low_;return goog.math.Long.fromBits(low>>>numBits|high<<32-numBits,high>>>numBits)}else if(numBits==32){return goog.math.Long.fromBits(high,0)}else{return goog.math.Long.fromBits(high>>>numBits-32,0)}}});var navigator={appName:"Modern Browser"};var dbits;var canary=0xdeadbeefcafe;var j_lm=(canary&16777215)==15715070;function BigInteger(a,b,c){if(a!=null)if("number"==typeof a)this.fromNumber(a,b,c);else if(b==null&&"string"!=typeof a)this.fromString(a,256);else this.fromString(a,b)}function nbi(){return new BigInteger(null)}function am1(i,x,w,j,c,n){while(--n>=0){var v=x*this[i++]+w[j]+c;c=Math.floor(v/67108864);w[j++]=v&67108863}return c}function am2(i,x,w,j,c,n){var xl=x&32767,xh=x>>15;while(--n>=0){var l=this[i]&32767;var h=this[i++]>>15;var m=xh*l+h*xl;l=xl*l+((m&32767)<<15)+w[j]+(c&1073741823);c=(l>>>30)+(m>>>15)+xh*h+(c>>>30);w[j++]=l&1073741823}return c}function am3(i,x,w,j,c,n){var xl=x&16383,xh=x>>14;while(--n>=0){var l=this[i]&16383;var h=this[i++]>>14;var m=xh*l+h*xl;l=xl*l+((m&16383)<<14)+w[j]+c;c=(l>>28)+(m>>14)+xh*h;w[j++]=l&268435455}return c}if(j_lm&&navigator.appName=="Microsoft Internet Explorer"){BigInteger.prototype.am=am2;dbits=30}else if(j_lm&&navigator.appName!="Netscape"){BigInteger.prototype.am=am1;dbits=26}else{BigInteger.prototype.am=am3;dbits=28}BigInteger.prototype.DB=dbits;BigInteger.prototype.DM=(1<<dbits)-1;BigInteger.prototype.DV=1<<dbits;var BI_FP=52;BigInteger.prototype.FV=Math.pow(2,BI_FP);BigInteger.prototype.F1=BI_FP-dbits;BigInteger.prototype.F2=2*dbits-BI_FP;var BI_RM="0123456789abcdefghijklmnopqrstuvwxyz";var BI_RC=new Array;var rr,vv;rr="0".charCodeAt(0);for(vv=0;vv<=9;++vv)BI_RC[rr++]=vv;rr="a".charCodeAt(0);for(vv=10;vv<36;++vv)BI_RC[rr++]=vv;rr="A".charCodeAt(0);for(vv=10;vv<36;++vv)BI_RC[rr++]=vv;function int2char(n){return BI_RM.charAt(n)}function intAt(s,i){var c=BI_RC[s.charCodeAt(i)];return c==null?-1:c}function bnpCopyTo(r){for(var i=this.t-1;i>=0;--i)r[i]=this[i];r.t=this.t;r.s=this.s}function bnpFromInt(x){this.t=1;this.s=x<0?-1:0;if(x>0)this[0]=x;else if(x<-1)this[0]=x+DV;else this.t=0}function nbv(i){var r=nbi();r.fromInt(i);return r}function bnpFromString(s,b){var k;if(b==16)k=4;else if(b==8)k=3;else if(b==256)k=8;else if(b==2)k=1;else if(b==32)k=5;else if(b==4)k=2;else{this.fromRadix(s,b);return}this.t=0;this.s=0;var i=s.length,mi=false,sh=0;while(--i>=0){var x=k==8?s[i]&255:intAt(s,i);if(x<0){if(s.charAt(i)=="-")mi=true;continue}mi=false;if(sh==0)this[this.t++]=x;else if(sh+k>this.DB){this[this.t-1]|=(x&(1<<this.DB-sh)-1)<<sh;this[this.t++]=x>>this.DB-sh}else this[this.t-1]|=x<<sh;sh+=k;if(sh>=this.DB)sh-=this.DB}if(k==8&&(s[0]&128)!=0){this.s=-1;if(sh>0)this[this.t-1]|=(1<<this.DB-sh)-1<<sh}this.clamp();if(mi)BigInteger.ZERO.subTo(this,this)}function bnpClamp(){var c=this.s&this.DM;while(this.t>0&&this[this.t-1]==c)--this.t}function bnToString(b){if(this.s<0)return"-"+this.negate().toString(b);var k;if(b==16)k=4;else if(b==8)k=3;else if(b==2)k=1;else if(b==32)k=5;else if(b==4)k=2;else return this.toRadix(b);var km=(1<<k)-1,d,m=false,r="",i=this.t;var p=this.DB-i*this.DB%k;if(i-->0){if(p<this.DB&&(d=this[i]>>p)>0){m=true;r=int2char(d)}while(i>=0){if(p<k){d=(this[i]&(1<<p)-1)<<k-p;d|=this[--i]>>(p+=this.DB-k)}else{d=this[i]>>(p-=k)&km;if(p<=0){p+=this.DB;--i}}if(d>0)m=true;if(m)r+=int2char(d)}}return m?r:"0"}function bnNegate(){var r=nbi();BigInteger.ZERO.subTo(this,r);return r}function bnAbs(){return this.s<0?this.negate():this}function bnCompareTo(a){var r=this.s-a.s;if(r!=0)return r;var i=this.t;r=i-a.t;if(r!=0)return this.s<0?-r:r;while(--i>=0)if((r=this[i]-a[i])!=0)return r;return 0}function nbits(x){var r=1,t;if((t=x>>>16)!=0){x=t;r+=16}if((t=x>>8)!=0){x=t;r+=8}if((t=x>>4)!=0){x=t;r+=4}if((t=x>>2)!=0){x=t;r+=2}if((t=x>>1)!=0){x=t;r+=1}return r}function bnBitLength(){if(this.t<=0)return 0;return this.DB*(this.t-1)+nbits(this[this.t-1]^this.s&this.DM)}function bnpDLShiftTo(n,r){var i;for(i=this.t-1;i>=0;--i)r[i+n]=this[i];for(i=n-1;i>=0;--i)r[i]=0;r.t=this.t+n;r.s=this.s}function bnpDRShiftTo(n,r){for(var i=n;i<this.t;++i)r[i-n]=this[i];r.t=Math.max(this.t-n,0);r.s=this.s}function bnpLShiftTo(n,r){var bs=n%this.DB;var cbs=this.DB-bs;var bm=(1<<cbs)-1;var ds=Math.floor(n/this.DB),c=this.s<<bs&this.DM,i;for(i=this.t-1;i>=0;--i){r[i+ds+1]=this[i]>>cbs|c;c=(this[i]&bm)<<bs}for(i=ds-1;i>=0;--i)r[i]=0;r[ds]=c;r.t=this.t+ds+1;r.s=this.s;r.clamp()}function bnpRShiftTo(n,r){r.s=this.s;var ds=Math.floor(n/this.DB);if(ds>=this.t){r.t=0;return}var bs=n%this.DB;var cbs=this.DB-bs;var bm=(1<<bs)-1;r[0]=this[ds]>>bs;for(var i=ds+1;i<this.t;++i){r[i-ds-1]|=(this[i]&bm)<<cbs;r[i-ds]=this[i]>>bs}if(bs>0)r[this.t-ds-1]|=(this.s&bm)<<cbs;r.t=this.t-ds;r.clamp()}function bnpSubTo(a,r){var i=0,c=0,m=Math.min(a.t,this.t);while(i<m){c+=this[i]-a[i];r[i++]=c&this.DM;c>>=this.DB}if(a.t<this.t){c-=a.s;while(i<this.t){c+=this[i];r[i++]=c&this.DM;c>>=this.DB}c+=this.s}else{c+=this.s;while(i<a.t){c-=a[i];r[i++]=c&this.DM;c>>=this.DB}c-=a.s}r.s=c<0?-1:0;if(c<-1)r[i++]=this.DV+c;else if(c>0)r[i++]=c;r.t=i;r.clamp()}function bnpMultiplyTo(a,r){var x=this.abs(),y=a.abs();var i=x.t;r.t=i+y.t;while(--i>=0)r[i]=0;for(i=0;i<y.t;++i)r[i+x.t]=x.am(0,y[i],r,i,0,x.t);r.s=0;r.clamp();if(this.s!=a.s)BigInteger.ZERO.subTo(r,r)}function bnpSquareTo(r){var x=this.abs();var i=r.t=2*x.t;while(--i>=0)r[i]=0;for(i=0;i<x.t-1;++i){var c=x.am(i,x[i],r,2*i,0,1);if((r[i+x.t]+=x.am(i+1,2*x[i],r,2*i+1,c,x.t-i-1))>=x.DV){r[i+x.t]-=x.DV;r[i+x.t+1]=1}}if(r.t>0)r[r.t-1]+=x.am(i,x[i],r,2*i,0,1);r.s=0;r.clamp()}function bnpDivRemTo(m,q,r){var pm=m.abs();if(pm.t<=0)return;var pt=this.abs();if(pt.t<pm.t){if(q!=null)q.fromInt(0);if(r!=null)this.copyTo(r);return}if(r==null)r=nbi();var y=nbi(),ts=this.s,ms=m.s;var nsh=this.DB-nbits(pm[pm.t-1]);if(nsh>0){pm.lShiftTo(nsh,y);pt.lShiftTo(nsh,r)}else{pm.copyTo(y);pt.copyTo(r)}var ys=y.t;var y0=y[ys-1];if(y0==0)return;var yt=y0*(1<<this.F1)+(ys>1?y[ys-2]>>this.F2:0);var d1=this.FV/yt,d2=(1<<this.F1)/yt,e=1<<this.F2;var i=r.t,j=i-ys,t=q==null?nbi():q;y.dlShiftTo(j,t);if(r.compareTo(t)>=0){r[r.t++]=1;r.subTo(t,r)}BigInteger.ONE.dlShiftTo(ys,t);t.subTo(y,y);while(y.t<ys)y[y.t++]=0;while(--j>=0){var qd=r[--i]==y0?this.DM:Math.floor(r[i]*d1+(r[i-1]+e)*d2);if((r[i]+=y.am(0,qd,r,j,0,ys))<qd){y.dlShiftTo(j,t);r.subTo(t,r);while(r[i]<--qd)r.subTo(t,r)}}if(q!=null){r.drShiftTo(ys,q);if(ts!=ms)BigInteger.ZERO.subTo(q,q)}r.t=ys;r.clamp();if(nsh>0)r.rShiftTo(nsh,r);if(ts<0)BigInteger.ZERO.subTo(r,r)}function bnMod(a){var r=nbi();this.abs().divRemTo(a,null,r);if(this.s<0&&r.compareTo(BigInteger.ZERO)>0)a.subTo(r,r);return r}function Classic(m){this.m=m}function cConvert(x){if(x.s<0||x.compareTo(this.m)>=0)return x.mod(this.m);else return x}function cRevert(x){return x}function cReduce(x){x.divRemTo(this.m,null,x)}function cMulTo(x,y,r){x.multiplyTo(y,r);this.reduce(r)}function cSqrTo(x,r){x.squareTo(r);this.reduce(r)}Classic.prototype.convert=cConvert;Classic.prototype.revert=cRevert;Classic.prototype.reduce=cReduce;Classic.prototype.mulTo=cMulTo;Classic.prototype.sqrTo=cSqrTo;function bnpInvDigit(){if(this.t<1)return 0;var x=this[0];if((x&1)==0)return 0;var y=x&3;y=y*(2-(x&15)*y)&15;y=y*(2-(x&255)*y)&255;y=y*(2-((x&65535)*y&65535))&65535;y=y*(2-x*y%this.DV)%this.DV;return y>0?this.DV-y:-y}function Montgomery(m){this.m=m;this.mp=m.invDigit();this.mpl=this.mp&32767;this.mph=this.mp>>15;this.um=(1<<m.DB-15)-1;this.mt2=2*m.t}function montConvert(x){var r=nbi();x.abs().dlShiftTo(this.m.t,r);r.divRemTo(this.m,null,r);if(x.s<0&&r.compareTo(BigInteger.ZERO)>0)this.m.subTo(r,r);return r}function montRevert(x){var r=nbi();x.copyTo(r);this.reduce(r);return r}function montReduce(x){while(x.t<=this.mt2)x[x.t++]=0;for(var i=0;i<this.m.t;++i){var j=x[i]&32767;var u0=j*this.mpl+((j*this.mph+(x[i]>>15)*this.mpl&this.um)<<15)&x.DM;j=i+this.m.t;x[j]+=this.m.am(0,u0,x,i,0,this.m.t);while(x[j]>=x.DV){x[j]-=x.DV;x[++j]++}}x.clamp();x.drShiftTo(this.m.t,x);if(x.compareTo(this.m)>=0)x.subTo(this.m,x)}function montSqrTo(x,r){x.squareTo(r);this.reduce(r)}function montMulTo(x,y,r){x.multiplyTo(y,r);this.reduce(r)}Montgomery.prototype.convert=montConvert;Montgomery.prototype.revert=montRevert;Montgomery.prototype.reduce=montReduce;Montgomery.prototype.mulTo=montMulTo;Montgomery.prototype.sqrTo=montSqrTo;function bnpIsEven(){return(this.t>0?this[0]&1:this.s)==0}function bnpExp(e,z){if(e>4294967295||e<1)return BigInteger.ONE;var r=nbi(),r2=nbi(),g=z.convert(this),i=nbits(e)-1;g.copyTo(r);while(--i>=0){z.sqrTo(r,r2);if((e&1<<i)>0)z.mulTo(r2,g,r);else{var t=r;r=r2;r2=t}}return z.revert(r)}function bnModPowInt(e,m){var z;if(e<256||m.isEven())z=new Classic(m);else z=new Montgomery(m);return this.exp(e,z)}BigInteger.prototype.copyTo=bnpCopyTo;BigInteger.prototype.fromInt=bnpFromInt;BigInteger.prototype.fromString=bnpFromString;BigInteger.prototype.clamp=bnpClamp;BigInteger.prototype.dlShiftTo=bnpDLShiftTo;BigInteger.prototype.drShiftTo=bnpDRShiftTo;BigInteger.prototype.lShiftTo=bnpLShiftTo;BigInteger.prototype.rShiftTo=bnpRShiftTo;BigInteger.prototype.subTo=bnpSubTo;BigInteger.prototype.multiplyTo=bnpMultiplyTo;BigInteger.prototype.squareTo=bnpSquareTo;BigInteger.prototype.divRemTo=bnpDivRemTo;BigInteger.prototype.invDigit=bnpInvDigit;BigInteger.prototype.isEven=bnpIsEven;BigInteger.prototype.exp=bnpExp;BigInteger.prototype.toString=bnToString;BigInteger.prototype.negate=bnNegate;BigInteger.prototype.abs=bnAbs;BigInteger.prototype.compareTo=bnCompareTo;BigInteger.prototype.bitLength=bnBitLength;BigInteger.prototype.mod=bnMod;BigInteger.prototype.modPowInt=bnModPowInt;BigInteger.ZERO=nbv(0);BigInteger.ONE=nbv(1);function bnpFromRadix(s,b){this.fromInt(0);if(b==null)b=10;var cs=this.chunkSize(b);var d=Math.pow(b,cs),mi=false,j=0,w=0;for(var i=0;i<s.length;++i){var x=intAt(s,i);if(x<0){if(s.charAt(i)=="-"&&this.signum()==0)mi=true;continue}w=b*w+x;if(++j>=cs){this.dMultiply(d);this.dAddOffset(w,0);j=0;w=0}}if(j>0){this.dMultiply(Math.pow(b,j));this.dAddOffset(w,0)}if(mi)BigInteger.ZERO.subTo(this,this)}function bnpChunkSize(r){return Math.floor(Math.LN2*this.DB/Math.log(r))}function bnSigNum(){if(this.s<0)return-1;else if(this.t<=0||this.t==1&&this[0]<=0)return 0;else return 1}function bnpDMultiply(n){this[this.t]=this.am(0,n-1,this,0,0,this.t);++this.t;this.clamp()}function bnpDAddOffset(n,w){if(n==0)return;while(this.t<=w)this[this.t++]=0;this[w]+=n;while(this[w]>=this.DV){this[w]-=this.DV;if(++w>=this.t)this[this.t++]=0;++this[w]}}function bnpToRadix(b){if(b==null)b=10;if(this.signum()==0||b<2||b>36)return"0";var cs=this.chunkSize(b);var a=Math.pow(b,cs);var d=nbv(a),y=nbi(),z=nbi(),r="";this.divRemTo(d,y,z);while(y.signum()>0){r=(a+z.intValue()).toString(b).substr(1)+r;y.divRemTo(d,y,z)}return z.intValue().toString(b)+r}function bnIntValue(){if(this.s<0){if(this.t==1)return this[0]-this.DV;else if(this.t==0)return-1}else if(this.t==1)return this[0];else if(this.t==0)return 0;return(this[1]&(1<<32-this.DB)-1)<<this.DB|this[0]}function bnpAddTo(a,r){var i=0,c=0,m=Math.min(a.t,this.t);while(i<m){c+=this[i]+a[i];r[i++]=c&this.DM;c>>=this.DB}if(a.t<this.t){c+=a.s;while(i<this.t){c+=this[i];r[i++]=c&this.DM;c>>=this.DB}c+=this.s}else{c+=this.s;while(i<a.t){c+=a[i];r[i++]=c&this.DM;c>>=this.DB}c+=a.s}r.s=c<0?-1:0;if(c>0)r[i++]=c;else if(c<-1)r[i++]=this.DV+c;r.t=i;r.clamp()}BigInteger.prototype.fromRadix=bnpFromRadix;BigInteger.prototype.chunkSize=bnpChunkSize;BigInteger.prototype.signum=bnSigNum;BigInteger.prototype.dMultiply=bnpDMultiply;BigInteger.prototype.dAddOffset=bnpDAddOffset;BigInteger.prototype.toRadix=bnpToRadix;BigInteger.prototype.intValue=bnIntValue;BigInteger.prototype.addTo=bnpAddTo;var Wrapper={abs:(function(l,h){var x=new goog.math.Long(l,h);var ret;if(x.isNegative()){ret=x.negate()}else{ret=x}HEAP32[tempDoublePtr>>2]=ret.low_;HEAP32[tempDoublePtr+4>>2]=ret.high_}),ensureTemps:(function(){if(Wrapper.ensuredTemps)return;Wrapper.ensuredTemps=true;Wrapper.two32=new BigInteger;Wrapper.two32.fromString("4294967296",10);Wrapper.two64=new BigInteger;Wrapper.two64.fromString("18446744073709551616",10);Wrapper.temp1=new BigInteger;Wrapper.temp2=new BigInteger}),lh2bignum:(function(l,h){var a=new BigInteger;a.fromString(h.toString(),10);var b=new BigInteger;a.multiplyTo(Wrapper.two32,b);var c=new BigInteger;c.fromString(l.toString(),10);var d=new BigInteger;c.addTo(b,d);return d}),stringify:(function(l,h,unsigned){var ret=(new goog.math.Long(l,h)).toString();if(unsigned&&ret[0]=="-"){Wrapper.ensureTemps();var bignum=new BigInteger;bignum.fromString(ret,10);ret=new BigInteger;Wrapper.two64.addTo(bignum,ret);ret=ret.toString(10)}return ret}),fromString:(function(str,base,min,max,unsigned){Wrapper.ensureTemps();var bignum=new BigInteger;bignum.fromString(str,base);var bigmin=new BigInteger;bigmin.fromString(min,10);var bigmax=new BigInteger;bigmax.fromString(max,10);if(unsigned&&bignum.compareTo(BigInteger.ZERO)<0){var temp=new BigInteger;bignum.addTo(Wrapper.two64,temp);bignum=temp}var error=false;if(bignum.compareTo(bigmin)<0){bignum=bigmin;error=true}else if(bignum.compareTo(bigmax)>0){bignum=bigmax;error=true}var ret=goog.math.Long.fromString(bignum.toString());HEAP32[tempDoublePtr>>2]=ret.low_;HEAP32[tempDoublePtr+4>>2]=ret.high_;if(error)throw"range error"})};return Wrapper})();if(memoryInitializer){if(typeof Module["locateFile"]==="function"){memoryInitializer=Module["locateFile"](memoryInitializer)}else if(Module["memoryInitializerPrefixURL"]){memoryInitializer=Module["memoryInitializerPrefixURL"]+memoryInitializer}if(ENVIRONMENT_IS_NODE||ENVIRONMENT_IS_SHELL){var data=Module["readBinary"](memoryInitializer);HEAPU8.set(data,STATIC_BASE)}else{addRunDependency("memory initializer");Browser.asyncLoad(memoryInitializer,(function(data){for(var i=0;i<data.length;i++){assert(HEAPU8[STATIC_BASE+i]===0,"area for memory initializer should not have been touched before it's loaded")}HEAPU8.set(data,STATIC_BASE);removeRunDependency("memory initializer")}),(function(data){throw"could not load memory initializer "+memoryInitializer}))}}function ExitStatus(status){this.name="ExitStatus";this.message="Program terminated with exit("+status+")";this.status=status}ExitStatus.prototype=new Error;ExitStatus.prototype.constructor=ExitStatus;var initialStackTop;var preloadStartTime=null;var calledMain=false;dependenciesFulfilled=function runCaller(){if(!Module["calledRun"]&&shouldRunNow)run();if(!Module["calledRun"])dependenciesFulfilled=runCaller};Module["callMain"]=Module.callMain=function callMain(args){assert(runDependencies==0,"cannot call main when async dependencies remain! (listen on __ATMAIN__)");assert(__ATPRERUN__.length==0,"cannot call main when preRun functions remain to be called");args=args||[];ensureInitRuntime();var argc=args.length+1;function pad(){for(var i=0;i<4-1;i++){argv.push(0)}}var argv=[allocate(intArrayFromString(Module["thisProgram"]),"i8",ALLOC_NORMAL)];pad();for(var i=0;i<argc-1;i=i+1){argv.push(allocate(intArrayFromString(args[i]),"i8",ALLOC_NORMAL));pad()}argv.push(0);argv=allocate(argv,"i32",ALLOC_NORMAL);initialStackTop=STACKTOP;try{var ret=Module["_main"](argc,argv,0);exit(ret)}catch(e){if(e instanceof ExitStatus){return}else if(e=="SimulateInfiniteLoop"){Module["noExitRuntime"]=true;return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}finally{calledMain=true}};function run(args){args=args||Module["arguments"];if(preloadStartTime===null)preloadStartTime=Date.now();if(runDependencies>0){Module.printErr("run() called, but dependencies remain, so not running");return}preRun();if(runDependencies>0)return;if(Module["calledRun"])return;function doRun(){if(Module["calledRun"])return;Module["calledRun"]=true;if(ABORT)return;ensureInitRuntime();preMain();if(ENVIRONMENT_IS_WEB&&preloadStartTime!==null){}if(Module["onRuntimeInitialized"])Module["onRuntimeInitialized"]();if(Module["_main"]&&shouldRunNow)Module["callMain"](args);postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout((function(){setTimeout((function(){Module["setStatus"]("")}),1);doRun()}),1)}else{doRun()}}Module["run"]=Module.run=run;function exit(status){if(Module["noExitRuntime"]){Module.printErr("exit("+status+") called, but noExitRuntime, so not exiting");return}ABORT=true;EXITSTATUS=status;STACKTOP=initialStackTop;exitRuntime();if(ENVIRONMENT_IS_NODE){process["stdout"]["once"]("drain",(function(){process["exit"](status)}));console.log(" ");setTimeout((function(){process["exit"](status)}),500)}else if(ENVIRONMENT_IS_SHELL&&typeof quit==="function"){quit(status)}throw new ExitStatus(status)}Module["exit"]=Module.exit=exit;function abort(text){if(text){Module.print(text);Module.printErr(text)}ABORT=true;EXITSTATUS=1;var extra="";throw"abort() at "+stackTrace()+extra}Module["abort"]=Module.abort=abort;if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}var shouldRunNow=true;if(Module["noInitialRun"]){shouldRunNow=false}run();var RBUFFER_SIZE=RELOOPER_BUFFER_SIZE;var rbuffer=_malloc(RBUFFER_SIZE);_rl_set_output_buffer(rbuffer,RBUFFER_SIZE);var TBUFFER_SIZE=RELOOPER_BUFFER_SIZE/2;var tbuffer=_malloc(TBUFFER_SIZE);var VBUFFER_SIZE=256;var vbuffer=_malloc(VBUFFER_SIZE);var RelooperGlue={};RelooperGlue["init"]=(function(){this.r=_rl_new_relooper()}),RelooperGlue["cleanup"]=(function(){_rl_delete_relooper(this.r)}),RelooperGlue["addBlock"]=(function(text,branchVar){assert(this.r);if(text){assert(text.length+1<TBUFFER_SIZE,"buffer too small, increase RELOOPER_BUFFER_SIZE");writeAsciiToMemory(text,tbuffer);if(branchVar){assert(branchVar.length+1<VBUFFER_SIZE,"buffer too small, increase RELOOPER_BUFFER_SIZE");writeAsciiToMemory(branchVar,vbuffer)}}var b=_rl_new_block(text?tbuffer:0,branchVar?vbuffer:0);_rl_relooper_add_block(this.r,b);return b});RelooperGlue["setBlockCode"]=(function(block,text){assert(this.r);assert(text.length+1<TBUFFER_SIZE,"buffer too small, increase RELOOPER_BUFFER_SIZE");writeAsciiToMemory(text,tbuffer);_rl_set_block_code(block,tbuffer)});RelooperGlue["addBranch"]=(function(from,to,condition,code){assert(this.r);if(condition){assert(condition.length+1<TBUFFER_SIZE/2,"buffer too small, increase RELOOPER_BUFFER_SIZE");writeAsciiToMemory(condition,tbuffer);condition=tbuffer}else{condition=0}if(code){assert(code.length+1<TBUFFER_SIZE/2,"buffer too small, increase RELOOPER_BUFFER_SIZE");writeAsciiToMemory(code,tbuffer+TBUFFER_SIZE/2);code=tbuffer+TBUFFER_SIZE/2}else{code=0}_rl_block_add_branch_to(from,to,condition,code)});RelooperGlue["render"]=(function(entry){assert(this.r);assert(entry);_rl_relooper_calculate(this.r,entry);_rl_relooper_render(this.r);var ret=Pointer_stringify(rbuffer);_rl_delete_relooper(this.r);this.r=0;return ret});RelooperGlue["setDebug"]=(function(debug){_rl_set_debugging(+!!debug)});RelooperGlue["setAsmJSMode"]=(function(on){_rl_set_asm_js_mode(on)});Module["Relooper"]=RelooperGlue





  return Module.Relooper;
})(Relooper);
