﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="User_News_UserCateList, QianboCMS" EnableEventValidation="false" %>
<%@ Register Src="../Nav.ascx" TagName="Nav" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>会员专栏列表管理</title>
    <link href="../Images/default.css" rel="stylesheet" type="text/css" />
    <link href="../Images/model.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
        a { text-decoration: none; color: #333; }
        a:hover { color: #cc0000; text-decoration: underline; }
        th { font-weight: bold; }
        .nav { background: #f0f0f0; padding: 3px; }
    </style>
    <script type="text/javascript" src="../../Js/XmlHttp.js"></script>
    <script type="text/javascript" src="../../Js/Common.js"></script>
</head>

<body>
    <form id="form1" runat="server">
        <div class="wrapper">
            <div class="user_main_all">
                <uc1:Nav ID="Nav1" runat="server" />
                <div class="user_main">
                    <div class="user_sidebar">
                        <div>
                            <h3><span>个人信息</span></h3>
                            <ul>
                                <li><a href="../SetUser.aspx">个人资料维护</a></li>
                                <li><a href="../ChangePwd.aspx">修改密码</a></li>
                                <li><a href="../ChangeQA.aspx">修改密码保护</a></li>
                            </ul>
                        </div>
                        <div>
                            <h3><span>信息管理</span></h3>
                            <ul>
                                <li><a href="../Notice/NoticeList.aspx">系统公告</a></li>
                                <li><a href="../Message/MessageList.aspx?TypeId=1">短消息管理</a></li>
                                <li><a href="../UserFavoriteList.aspx">我的收藏夹</a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- 主体内容开始 -->
                    <div class="user_summary">
                        <div class="user_sitepath">
                            您现在的位置：
							<span id="YourPosition">
								<span><asp:HyperLink ID="hylnkIndex" runat="server">首页</asp:HyperLink></span>
								<span> &gt;&gt; </span>
								<span><a href="/User/Main.aspx">会员中心</a></span>
								<span> &gt;&gt; </span>
								<span>专栏列表</span>
							</span>
                        </div>
                        <div class="model_info_list">
                            <asp:GridView ID="gvInfoList" runat="server" AutoGenerateColumns="False" Width="99%" align="center" CellSpacing="1" GridLines="None" CssClass="border" OnRowDataBound="gvInfoList_RowDataBound" OnRowDeleting="gvInfoList_RowDeleting" DataKeyNames="UserCateId">
                                <Columns>
                                    <asp:BoundField HeaderText="ID" DataField="UserCateId">
                                        <ItemStyle Width="5%" />
                                    </asp:BoundField>
                                    <asp:BoundField HeaderText="专栏名称" DataField="CateName">
                                        <ItemStyle Width="20%" />
                                    </asp:BoundField>
                                    <asp:TemplateField HeaderText="所属模型">
                                        <ItemTemplate><%#Eval("ModelName") %></ItemTemplate>
                                        <ItemStyle Width="10%" />
                                    </asp:TemplateField>
                                    <asp:BoundField HeaderText="专栏描述" DataField="Discription">
                                        <ItemStyle Width="30%" />
                                    </asp:BoundField>
                                    <asp:TemplateField HeaderText="功能操作" ShowHeader="False">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="hlkBtnAddNews" runat="server" NavigateUrl="~/User/Info/SetUserCate.aspx">新建</asp:HyperLink>
                                            <asp:HyperLink ID="hlkUpdate" runat="server" Text="修改" NavigateUrl='<%# "SetUserCate.aspx?UCId="+Eval("UserCateId") %>'></asp:HyperLink>
                                            <asp:LinkButton ID="lkBtnDelete" runat="server" CausesValidation="False" CommandName="Delete" Text="删除" OnClientClick="return confirm('是否确定删除该专栏？')"></asp:LinkButton>
                                        </ItemTemplate>
                                        <ItemStyle Width="10%" />
                                    </asp:TemplateField>
                                </Columns>
                                <HeaderStyle CssClass="title" Width="20px" />
                                <PagerStyle />
                                <RowStyle CssClass="tdbg" />
                            </asp:GridView>
                            <table width="99%" cellpadding="0" cellspacing="1" class="border" align="center">
                                <tr>
                                    <td class="nav">
										<strong>所属模型：</strong>
                                        <asp:DropDownList ID="ddlModelType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlModelType_SelectedIndexChanged"></asp:DropDownList>
									</td>
                                </tr>
                            </table>
                        </div>
                        <!-- 主体内容结束 -->
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            <div class="foot">
                <div class="wrapper">
                    <div class="usercopyright"><a href="http://www.qianbo.com.cn/" target="_blank">技术架构：千博政府网站管理系统</a>Copyright © <%=DateTime.Now.ToString("yyyy")%></div>
                </div>
            </div>
    </form>
</body>
</html>