﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="System_User_Card, QianboCMS" EnableEventValidation="false" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>用户卡管理</title>
    <link href="../Css/layout.css" type="text/css" rel="Stylesheet" />
    <script src="../../Js/Common.js" type="text/javascript"></script>
</head>

<body>
    <form id="form1" runat="server">
        <table cellspacing="1" cellpadding="0" class="wzdh" align="center">
            <tr>
                <td style="padding-left: 10px;">
                    <img src="../Images/Skin/Default/you.gif" align="absmiddle" />
                    您现在的位置：<a href="../SystemInfo.aspx">后台管理</a> &gt;&gt; 用户管理 &gt;&gt; 充值卡管理
				</td>
            </tr>
        </table>
        <table cellspacing="1" cellpadding="0" class="border" align="center">
            <tr>
                <td class="wzlist">
					<a href="SetCard.aspx">添加新卡</a> | <asp:LinkButton ID="lnkbtnAll" runat="server" OnClick="lnkbtnAll_Click">所有卡</asp:LinkButton> | <asp:LinkButton ID="lnkbtnUnused" runat="server" OnClick="lnkbtnUnused_Click">未使用</asp:LinkButton> | <asp:LinkButton ID="lnkbtnUsed" runat="server" OnClick="lnkbtnUsed_Click">已使用</asp:LinkButton> | <asp:LinkButton ID="lnkbtnOverdue" runat="server" OnClick="lnkbtnOverdue_Click">已过期</asp:LinkButton>
                    每页显示：<asp:TextBox ID="txtPageSize" runat="server" Style="width: 40px;">20</asp:TextBox>
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="txtPageSize" Display="Dynamic" ErrorMessage="* 必须为正整数" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>条记录
					<asp:Button ID="btnView" runat="server" Text="查看" OnClick="btnView_Click" CssClass="btn" />
				</td>
            </tr>
        </table>
        <asp:GridView ID="gvCardList" runat="server" AutoGenerateColumns="False" BorderStyle="Solid" CellSpacing="1" align="center" CssClass="borderlist" DataKeyNames="CardAccount" GridLines="None" OnRowDataBound="gvCardList_RowDataBound" OnRowDeleting="gvCardList_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="选择" ItemStyle-Width="30px">
                    <ItemTemplate>
                        <asp:CheckBox ID="chkBox" runat="server" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="卡号" ItemStyle-HorizontalAlign="Left">
                    <ItemTemplate><a href='<%# ViewCard(Eval("CardAccount")) %>'><%#Eval("CardAccount")%></a></ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="已消费" ItemStyle-Width="60px">
                    <ItemTemplate>
                        <asp:Label ID="lbIsUsed" runat="server" Text='<%# Bind("IsUsed") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="CardPoint" HeaderText="点数" ItemStyle-Width="60px" />
                <asp:BoundField DataField="CardDay" HeaderText="天数" ItemStyle-Width="60px" />
                <asp:BoundField DataField="AdminName" HeaderText="操作员" ItemStyle-Width="150px" />
                <asp:TemplateField HeaderText="过期日期" ItemStyle-Width="120px">
                    <ItemTemplate>
                        <asp:Label ID="Label1" runat="server" Text='<%# Bind("OverdueDate", "{0:d}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除" ShowHeader="False" ItemStyle-Width="35px">
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandName="Delete" OnClientClick="return confirm('是否确定删除此项？')" Text="删除"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <RowStyle CssClass="tdbg" />
            <EmptyDataTemplate>
                <asp:Label ID="lbEmptyData" runat="server" CssClass="error" Text="暂无相关数据"></asp:Label>
            </EmptyDataTemplate>
            <HeaderStyle CssClass="title" />
        </asp:GridView>
        <table cellspacing="1" cellpadding="0" class="border" align="center">
            <tr>
                <td class="wzlist">
                    <asp:Panel ID="pnlpageIndex" runat="server" Width="100%">
                        <webdiyer:AspNetPager ID="Pager" runat="server" AlwaysShow="True" FirstPageText="首页" HorizontalAlign="Right" LastPageText="尾页" NextPageText="下一页" OnPageChanging="Pager_PageChanging" PageSize="20" PrevPageText="上一页" ShowCustomInfoSection="Left" ShowInputBox="Never" ShowNavigationToolTip="True" Width="100%" LayoutType="Table" CustomInfoSectionWidth="10%"></webdiyer:AspNetPager>
                    </asp:Panel>
                </td>
            </tr>
        </table>
        <table cellspacing="1" cellpadding="0" class="border" align="center">
            <tr>
                <td class="wzlist">
                    <input id="chk" type="checkbox" onclick="SelectAll('chk', 'gvCardList');" />
                    全选
                    <asp:Button ID="btnDeleteSelectd" runat="server" Text="删除选中项" CausesValidation="False" OnClick="btnDeleteSelectd_Click" OnClientClick="return confirm('是否确定删除所选项？')" CssClass="btn" />
				</td>
            </tr>
        </table>
    </form>
    <asp:Literal ID="LitMsg" runat="server"></asp:Literal>
</body>
</html>