# PyPuns

> Puns for everyone to laugh at.


[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/PyPuns/PyPuns/graphs/commit-activity)
[![Maintainer](https://img.shields.io/badge/Maintainer-Bunz-magenta)](https://github.com/66Bunz)
[![GitHub Issues](https://img.shields.io/github/issues/PyPuns/PyPuns.svg)](https://github.com/PyPuns/PyPuns/issues)
[![GitHub Pull-Requests](https://img.shields.io/github/issues-pr/PyPuns/PyPuns.svg)](https://github.com/PyPuns/PyPuns/pulls)
[![GitHub forks](https://badgen.net/github/forks/PyPuns/PyPuns/)](https://GitHub.com/PyPuns/PyPuns/network/)
[![GitHub stars](https://badgen.net/github/stars/PyPuns/PyPuns)](https://GitHub.com/PyPuns/PyPuns/stargazers/)
[![GitHub contributors](https://img.shields.io/github/contributors/PyPuns/PyPuns.svg)](https://GitHub.com/PyPuns/PyPuns/graphs/contributors/)


---

[![PyPI license](https://img.shields.io/pypi/l/pypuns.svg)](https://pypi.org/project/pypuns/)
[![PyPI version fury.io](https://badge.fury.io/py/pypuns.svg)](https://pypi.org/project/pypuns/)
[![PyPI pyversions](https://img.shields.io/pypi/pyversions/pypuns.svg)](https://pypi.org/project/pypuns/)
[![PyPI status](https://img.shields.io/pypi/status/pypuns.svg)](https://pypi.org/project/pypuns/)

---

[About](#about) | [Installation](#installation) | [Usage](#usage) | [Contributing](#contributing) | [Contributors](#contributors) | [Contacts](#contacts) | [What's new?](#whats-new)


---


## About

PyPuns is a library that make you able to get random puns divided in various categories and languages.  
This library was made to fill the gaps left by [PyJokes][pyjokes] for non-programming puns. 
I also took inspiration from their work for this repository.


## Installation
```python
pip install pypuns
```
You can use pip to install this package.


## Usage

Import the ```pypuns``` module and use the ```get_pun``` function to get a random pun.
```python
import pypuns

pun = pypuns.get_pun()
```
For further informations about the ```get_pun``` function take a look at the [wiki](https://github.com/PyPuns/PyPuns/wiki/Installation-&-Usage).


## Contributing

You can contribute to this project by adding new puns or by improving existing ones for the existing languages, or adding puns for a new language. Take a look at [CONTRIBUTING.md][contributing] for more information.


## Contributors

- Bunz


## Contacts

[![BuyMeACoffee](https://img.shields.io/badge/Buy%20Me%20a%20Coffee-ffdd00?style=for-the-badge&logo=buy-me-a-coffee&logoColor=black)](https://www.buymeacoffee.com/66bunz)
[![saythanks](https://img.shields.io/badge/say-thanks-magenta?style=for-the-badge)](https://saythanks.io/to/66Bunz)

- [Gmail][gmail]: 66bunz@gmail.com
- [Protonmail][protonmail]: bunzen@protonmail.com
- [DeviantArt][deviantart]: bunz66
- [Github][github]: 66Bunz
- [BuyMeACoffee][buymeacoffee]: 66bunz
- [SayThanks][saythanks]: 66Bunz
- [Twitter][twitter]: 66Bunz
- [Facebook][facebook]: Bunz66


## What's New

First Commit


[pyjokes]: https://pypi.org/project/pyjokes/
[contributing]: https://github.com/PyPuns/PyPuns/blob/main/CONTRIBUTING.md
[gmail]: mailto:66bunz@gmail.com
[protonmail]: mailto:bunzen@protonmail.com
[deviantart]: https://www.deviantart.com/bunz66
[github]: https://github.com/66Bunz
[buymeacoffee]: https://www.buymeacoffee.com/66bunz
[saythanks]: https://saythanks.io/to/66Bunz
[twitter]: https://twitter.com/66Bunz
[facebook]: https://www.facebook.com/Bunz66
