<?php
/**
 * HSB Color Space Data Model
 * ==========================
 * This class acts a momentary data model cache. This is so once a conversion is
 * done once for a color it won't need to be done again. (as long as the color
 * doesn't change)
 */

namespace projectcleverweb\color\data\color\space;
use projectcleverweb\color\data\color\space;

/**
 * HSB Color Space Data Model
 * ==========================
 * This class acts a momentary data model cache. This is so once a conversion is
 * done once for a color it won't need to be done again. (as long as the color
 * doesn't change)
 */
class hsb extends space {
	
	/**
	 * The name of the current color space
	 * @var string
	 */
	protected static $name = 'hsb';
	
	/**
	 * The specification for each key of the color space
	 * @var array
	 */
	protected static $specs = array(
		'h' => array(
			'name'            => 'Hue',
			'min'             => 0,
			'max'             => 359,
			'default'         => 0,
			'allow_negative'  => TRUE,
			'allow_float'     => FALSE,
			'overflow_method' => 'loop'
		),
		's' => array(
			'name'            => 'Saturation',
			'min'             => 0,
			'max'             => 100,
			'default'         => 0,
			'allow_negative'  => FALSE,
			'allow_float'     => FALSE,
			'overflow_method' => 'limit'
		),
		'b' => array(
			'name'            => 'Brightness',
			'min'             => 0,
			'max'             => 100,
			'default'         => 0,
			'allow_negative'  => FALSE,
			'allow_float'     => FALSE,
			'overflow_method' => 'limit'
		),
	);
}
