<!-- Copyright (c) 2024 Praneeth Vadlapati -->

# <img src="./files/logo_small.png" align="left" width="200" alt="Auto-Precise-Prompts" /> Auto-*Precise*-Prompts

Automated LLM-based Prompt Engineering for Structured Data Processing

[![License: CC BY 4.0](https://img.shields.io/badge/License-CC_BY_4.0-yellow.svg?style=for-the-badge)](./LICENSE.md)
[![Journal](https://img.shields.io/badge/Journal%20Article-Link-darkgreen?style=for-the-badge)](https://najer.org/najer/article/view/83)
[![Python](https://img.shields.io/badge/Python-3776AB?style=for-the-badge&logo=python&logoColor=ffdd54)](https://www.python.org/)

Created by Praneeth Vadlapati ([@prane-eth](https://github.com/prane-eth))

> [!NOTE]
> Please star :star: the repository to show your support. <br>

#### Why Auto-Precise-Prompts?
LLMs are powerful tools for processing text.
Structured data processing using LLMs requires precise prompts.
Prompt Engineering and testing require workforce for manual efforts, and require more time, resources, and budget. <br>
The project uses automated methods to generate and test prompts, to automate the Prompt Engineering process for structured data processing using LLMs.



## :page_facing_up: Research Paper
A published research paper is available at [NAJER](https://najer.org/najer/article/view/83) <br>


## :bookmark_tabs: Citation
To use my paper for reference, please cite it as below:
```bibtex
@article{vadlapati2024autopreciseprompts,
	title={{AutoPrecisePrompts: Automated LLM-based Prompt Engineering for Structured Data Processing}},
	journal={{North American Journal of Engineering and Research}},
	volume={5},
	number={1},
	year={2024},
	month={Jan},
	author={{Praneeth Vadlapati}},
	url={https://najer.org/najer/article/view/83}
}
```


## :rocket: Quick Start
```bash
pip install -r requirements.txt
cp .env.example .env
```
Now, edit the `.env` file and add your values. <br>
Run the file [Auto-Precise-Prompts.ipynb](Auto-Precise-Prompts.ipynb)


## :computer: More Projects
For more projects, open the profile: **[@Pro-GenAI](https://github.com/Pro-GenAI)** <br>


## :hammer_and_wrench: Contributing
Contributions are welcome! Feel free to create an issue for any bug reports or suggestions. <br>
To contribute, star :star: the repository and create an Issue. If I can't solve it, I will allow anyone to create a pull request.<br>


## :identification_card: License
Copyright (c) 2024 Praneeth Vadlapati <br>
Please refer to the [LICENSE](./LICENSE.md) file for more information.


## :warning: Disclaimer
The code is not intended for use in production environments.
This code is for educational and research purposes only.

No author is responsible for any misuse or damage caused by this code.
Use it at your own risk. The code is provided as is without any guarantees or warranty.


## :email: Contact
For personal queries, please find my contact details here: [linktr.ee/prane.eth](https://linktr.ee/prane.eth)

