import { FC } from 'react';
import NavItem from './nav-item';
import IconChat from '../assets/material/chat_FILL0_wght400_GRAD0_opsz20.svg';
import IconModel from '../assets/material/widgets_FILL0_wght400_GRAD0_opsz20.svg';
import IconOpenAI from '../assets/logo/openai.svg';
import IconGithub from '../assets/logo/github-32.svg';
import IconDiscord from '../assets/logo/discord-32.svg';
import IconSettings from '../assets/material/settings_FILL0_wght400_GRAD0_opsz20.svg';
import IconFolder from '../assets/material/folder_FILL0_wght400_GRAD0_opsz20.svg';
import IconTune from '../assets/material/tune_FILL0_wght400_GRAD0_opsz20.svg';

interface Props {}

const isDev = process.env.NODE_ENV === 'development';

const Index: FC<Props> = () => (
  <nav className="relative flex flex-col w-60 h-full overflow-y-auto shrink-0 grow-0">
    <div className="border-r absolute right-0 top-0 bottom-0" />
    <div className="text-theme-500 h-13 flex justify-center items-center">
      <IconOpenAI className="w-6 h-6" />
      <div className="pl-2 font-medium text-base">Bot Studio</div>
    </div>
    <NavItem href="/" text="Chat" icon={IconChat} />
    <NavItem href="/models" text="Models" icon={IconModel} />
    <NavItem href="/files" text="Files" icon={IconFolder} />
    <NavItem href="/fine-tunes" text="Fine tune" icon={IconTune} />
    {isDev && <NavItem href="/settings" text="Settings" icon={IconSettings} />}
    <div className="mt-1.5 mb-[5px] border-b mx-3" />
    <a
      target="_blank"
      rel="noreferrer"
      href="https://github.com/Privoce/Bot-Studio"
      className="group h-10 pl-1 flex items-center hover-theme hover:text-theme-700"
    >
      <div className="w-10 h-10 p-2.5">
        <IconGithub className="w-5 h-5" />
      </div>
      <div className="text-sm font-medium">Privoce/Bot-Studio</div>
      <div className="pl-2">
        <img
          alt="Github Star Count"
          className="opacity-0 w-0 group-hover:opacity-100 group-hover:w-fit"
          src="https://img.shields.io/badge/dynamic/json?color=%23047857&label=%20&query=%24%5B%27stargazers_count%27%5D&url=https%3A%2F%2Fapi.github.com%2Frepos%2FPrivoce%2FBot-Studio"
        />
        <img
          alt="Github Star Count"
          className="opacity-100 w-fit group-hover:opacity-0 group-hover:w-0"
          src="https://img.shields.io/badge/dynamic/json?color=%23111827&label=%20&query=%24%5B%27stargazers_count%27%5D&url=https%3A%2F%2Fapi.github.com%2Frepos%2FPrivoce%2FBot-Studio"
        />
      </div>
    </a>
    <a
      target="_blank"
      rel="noreferrer"
      href="https://discord.gg/Fu6NvJw5Ws"
      className="h-10 pl-1 flex items-center hover-theme hover:text-theme-700"
    >
      <div className="w-10 h-10 p-2.5">
        <IconDiscord className="w-5 h-5" />
      </div>
      <div className="text-sm font-medium">Discord/Bot-Studio</div>
    </a>
  </nav>
);

export default Index;
