/**
 * @file      initSequence.cpp
 * @author    Lewis He (lewishe@outlook.com)
 * @license   MIT
 * @copyright Copyright (c) 2023  Shenzhen Xin Yuan Electronic Technology Co., Ltd
 * @date      2023-05-29
 *
 */

#if AMOLED_S3

#include "amoled/initSequence.h"


const lcd_cmd_t sh8501_cmd[SH8501_INIT_SEQUENCE_LENGHT] = {

    // ===  CMD2 password  ===
    {0xfe00, {0x20}, 0x01},
    {0xf400, {0x5a}, 0x01},
    {0xf500, {0x59}, 0x01},

    // ===  ID code  ===
    {0xfe00, {0x40}, 0x01},
    {0xd800, {0x33}, 0x01},
    {0xd900, {0x06}, 0x01},
    {0xda00, {0x00}, 0x01},

    // ===  QSPI setting  ===
    {0xfe00, {0x20}, 0x01},
    {0x1a00, {0x15}, 0x01},
    {0x1900, {0x10}, 0x01},
    {0x1c00, {0xa0}, 0x01},

    // ===  Timing Gen  ===
    {0xfe00, {0x40}, 0x01},
    {0x0100, {0x90}, 0x01},
    {0x0200, {0x5c}, 0x01},
    {0x5900, {0x01}, 0x01},
    {0x5a00, {0x58}, 0x01},
    {0x5b00, {0x08}, 0x01},
    {0x5c00, {0x08}, 0x01},
    {0x7000, {0x01}, 0x01},
    {0x7100, {0x58}, 0x01},
    {0x7200, {0x08}, 0x01},
    {0x7300, {0x08}, 0x01},

    // ===  AOD setting===
    {0xfe00, {0x40}, 0x01},
    {0x5d00, {0x24}, 0x01},
    {0x6000, {0x08}, 0x01},
    {0x6100, {0x04}, 0x01},
    {0x6200, {0x7f}, 0x01},
    {0x6900, {0x06}, 0x01},
    {0x0c00, {0xd7}, 0x01},
    {0x0d00, {0xfc}, 0x01},
    {0x3900, {0x24}, 0x01},
    {0x3d00, {0x08}, 0x01},
    {0x4700, {0x06}, 0x01},
    {0x6d00, {0x04}, 0x01},
    {0x1000, {0x11}, 0x01},
    {0x1100, {0x09}, 0x01},

    // ===  Power Settings  ===
    {0xfe00, {0xe0}, 0x01},
    {0x0000, {0x14}, 0x01},
    {0x0100, {0x01}, 0x01},
    {0x0200, {0x00}, 0x01}, //{0x0200,{0x00},0x01},
    {0x0400, {0x04}, 0x01},
    {0x0600, {0x0f}, 0x01},
    {0x0800, {0x00}, 0x01},
    {0x0900, {0x14}, 0x01},
    {0x0a00, {0x01}, 0x01},
    {0x0b00, {0x00}, 0x01}, //{0x0b00,{0x00},0x01},
    {0x0c00, {0x04}, 0x01},
    {0x0e00, {0x0f}, 0x01},
    {0x0f00, {0x00}, 0x01},
    {0x1000, {0x14}, 0x01},
    {0x1100, {0x10}, 0x01},
    {0x2400, {0x00}, 0x01},
    {0x2100, {0x99}, 0x01},
    {0x2d00, {0x99}, 0x01},
    {0x3200, {0x99}, 0x01},
    {0x2600, {0x41}, 0x01},
    {0x2200, {0x1a}, 0x01},
    {0x2300, {0x13}, 0x01},
    {0x3000, {0x01}, 0x01},
    {0xfe00, {0x40}, 0x01},
    {0x5700, {0x43}, 0x01}, //{0x5700,{0x43},0x01},
    {0x5800, {0x33}, 0x01},
    {0x6e00, {0x43}, 0x01}, //{0x6e00,{0x43},0x01},
    {0x6f00, {0x33}, 0x01},
    {0x7400, {0x43}, 0x01}, //{0x7400,{0x43},0x01},
    {0x7500, {0x33}, 0x01},

    // // ===  swire setting for RT4722 ===
    // {0xfe00,{0x40},0x01},
    // {0x1200,{0xfe},0x01},
    // {0x1300,{0x08},0x01},
    // {0xc900,{0x21},0x01},
    // {0x9600,{0x00},0x01},
    // {0x9700,{0x02},0x01},
    // {0xa500,{0xff},0x01},//{0xa500,{0xff},0x01},
    // {0xaa00,{0x21},0x01},//{0xaa00,{0x21},0x01},
    // {0xab00,{0x00},0x01},//{0xab00,{0x00},0x01},
    // {0x9800,{0x00},0x01},
    // {0xa700,{0x21},0x01},
    // {0xa900,{0x00},0x01},

    // ===  swire setting for BV6802 ===
    {0xfe00, {0x40}, 0x01},
    {0x1200, {0xfe}, 0x01},
    {0x1300, {0x08}, 0x01},
    {0xc900, {0x5f}, 0x01},
    {0x9600, {0x38}, 0x01},
    {0x9700, {0x02}, 0x01},
    {0xa500, {0xff}, 0x01},
    {0xaa00, {0x38}, 0x01},
    {0xab00, {0x5f}, 0x01},
    {0x9800, {0x00}, 0x01},
    {0xa700, {0x38}, 0x01},
    {0xa900, {0x5f}, 0x01},

    //=== GOA mapping ===
    {0xfe00, {0x70}, 0x01},
    {0x9b00, {0x02}, 0x01},
    {0x9c00, {0x03}, 0x01},
    {0x9d00, {0x08}, 0x01},
    {0x9e00, {0x19}, 0x01},
    {0x9f00, {0x19}, 0x01},
    {0xa000, {0x19}, 0x01},
    {0xa200, {0x19}, 0x01},
    {0xa300, {0x19}, 0x01},
    {0xa400, {0x19}, 0x01},
    {0xa500, {0x19}, 0x01},
    {0xa600, {0x11}, 0x01},
    {0xa700, {0x10}, 0x01},
    {0xa900, {0x0f}, 0x01},
    {0xaa00, {0x19}, 0x01},
    {0xab00, {0x19}, 0x01},
    {0xac00, {0x19}, 0x01},
    {0xad00, {0x19}, 0x01},
    {0xae00, {0x19}, 0x01},
    {0xaf00, {0x19}, 0x01},
    {0xb000, {0x19}, 0x01},
    {0xb100, {0x19}, 0x01},
    {0xb200, {0x19}, 0x01},
    {0xb300, {0x19}, 0x01},
    {0xb400, {0x19}, 0x01},
    {0xb500, {0x19}, 0x01},
    {0xb600, {0x19}, 0x01},
    {0xb700, {0x19}, 0x01},
    {0xb800, {0x00}, 0x01},
    {0xb900, {0x01}, 0x01},
    {0xba00, {0x09}, 0x01},
    {0xbb00, {0x19}, 0x01},
    {0xbc00, {0x19}, 0x01},
    {0xbd00, {0xf9}, 0x01},
    {0xbe00, {0x19}, 0x01},
    {0xbf00, {0x19}, 0x01},
    {0xc000, {0x0e}, 0x01},
    {0xc100, {0x0d}, 0x01},
    {0xc200, {0x0c}, 0x01},
    {0xc300, {0x19}, 0x01},
    {0xc400, {0x19}, 0x01},
    {0xc500, {0x19}, 0x01},
    {0xc600, {0x19}, 0x01},
    {0xc700, {0x19}, 0x01},
    {0xc800, {0x19}, 0x01},

    // ===  source/mux sequence ===
    {0xfe00, {0x40}, 0x01},
    {0x4c00, {0x22}, 0x01},
    {0x5300, {0xa0}, 0x01},
    {0x0800, {0x0a}, 0x01},

    // ===  SD/SW_Toggle_Sequence_Control ===
    {0xfe00, {0xf0}, 0x01},
    {0x7200, {0x33}, 0x01},
    {0x7300, {0x66}, 0x01},
    {0x7400, {0x22}, 0x01},
    {0x7500, {0x55}, 0x01},
    {0x7600, {0x11}, 0x01},
    {0x7700, {0x44}, 0x01},
    {0x7800, {0x33}, 0x01},
    {0x7900, {0x66}, 0x01},
    {0x7a00, {0x22}, 0x01},
    {0x7b00, {0x55}, 0x01},
    {0x7c00, {0x11}, 0x01},
    {0x7d00, {0x44}, 0x01},
    {0x7e00, {0x66}, 0x01},
    {0x7f00, {0x33}, 0x01},
    {0x8000, {0x55}, 0x01},
    {0x8100, {0x22}, 0x01},
    {0x8200, {0x44}, 0x01},
    {0x8300, {0x11}, 0x01},
    {0x8400, {0x66}, 0x01},
    {0x8500, {0x33}, 0x01},
    {0x8600, {0x55}, 0x01},
    {0x8700, {0x22}, 0x01},
    {0x8800, {0x44}, 0x01},
    {0x8900, {0x11}, 0x01},

    // === GIP Setting  ===
    {0xfe00, {0x70}, 0x01},
    {0x0000, {0xc0}, 0x01},
    {0x0100, {0x08}, 0x01},
    {0x0200, {0x02}, 0x01},
    {0x0300, {0x00}, 0x01},
    {0x0400, {0x00}, 0x01},
    {0x0500, {0x01}, 0x01},
    {0x0600, {0x28}, 0x01},
    {0x0700, {0x28}, 0x01},
    {0x0900, {0xc0}, 0x01},
    {0x0a00, {0x08}, 0x01},
    {0x0b00, {0x02}, 0x01},
    {0x0c00, {0x00}, 0x01},
    {0x0d00, {0x00}, 0x01},
    {0x0e00, {0x00}, 0x01},
    {0x0f00, {0x28}, 0x01},
    {0x1000, {0x28}, 0x01},
    {0x1200, {0xc0}, 0x01},
    {0x1300, {0x08}, 0x01},
    {0x1400, {0x02}, 0x01},
    {0x1500, {0x00}, 0x01},
    {0x1600, {0x00}, 0x01},
    {0x1700, {0x01}, 0x01},
    {0x1800, {0xd8}, 0x01},
    {0x1900, {0x18}, 0x01},
    {0x1b00, {0xc0}, 0x01},
    {0x1c00, {0x08}, 0x01},
    {0x1d00, {0x02}, 0x01},
    {0x1e00, {0x00}, 0x01},
    {0x1f00, {0x00}, 0x01},
    {0x2000, {0x00}, 0x01},
    {0x2100, {0xd8}, 0x01},
    {0x2200, {0x18}, 0x01},
    {0x4c00, {0x80}, 0x01},
    {0x4d00, {0x00}, 0x01},
    {0x4e00, {0x01}, 0x01},
    {0x4f00, {0x00}, 0x01},
    {0x5000, {0x01}, 0x01},
    {0x5100, {0x01}, 0x01},
    {0x5200, {0x01}, 0x01},
    {0x5300, {0xc6}, 0x01},
    {0x5400, {0x00}, 0x01},
    {0x5500, {0x03}, 0x01},
    {0x5600, {0x28}, 0x01},
    {0x5800, {0x28}, 0x01},
    {0x6500, {0x80}, 0x01},
    {0x6600, {0x05}, 0x01},
    {0x6700, {0x10}, 0x01},

    // === MUX Sequence Control ===
    {0xfe00, {0xf0}, 0x01},
    {0xa300, {0x00}, 0x01},

    {0xfe00, {0x70}, 0x01},
    {0x7600, {0x00}, 0x01},
    {0x7700, {0x00}, 0x01},
    {0x7800, {0x05}, 0x01},
    {0x6800, {0x08}, 0x01},
    {0x6900, {0x08}, 0x01},
    {0x6a00, {0x10}, 0x01},
    {0x6b00, {0x08}, 0x01},
    {0x6c00, {0x08}, 0x01},
    {0x6d00, {0x08}, 0x01},

    {0xfe00, {0xf0}, 0x01},
    {0xa900, {0x18}, 0x01},
    {0xaa00, {0x18}, 0x01},
    {0xab00, {0x18}, 0x01},
    {0xac00, {0x18}, 0x01},
    {0xad00, {0x18}, 0x01},
    {0xae00, {0x18}, 0x01},

    {0xfe00, {0x70}, 0x01},
    {0x9300, {0x00}, 0x01},
    {0x9400, {0x00}, 0x01},
    {0x9600, {0x05}, 0x01},
    {0xdb00, {0x08}, 0x01},
    {0xdc00, {0x08}, 0x01},
    {0xdd00, {0x10}, 0x01},
    {0xde00, {0x08}, 0x01},
    {0xdf00, {0x08}, 0x01},
    {0xe000, {0x08}, 0x01},
    {0xe700, {0x18}, 0x01},
    {0xe800, {0x18}, 0x01},
    {0xe900, {0x18}, 0x01},
    {0xea00, {0x18}, 0x01},
    {0xeb00, {0x18}, 0x01},
    {0xec00, {0x18}, 0x01},

    // ===  Power on/off sequence Blank period control  ===
    {0xfe00, {0x70}, 0x01},
    {0xd100, {0xf0}, 0x01},
    {0xd200, {0xff}, 0x01},
    {0xd300, {0xf0}, 0x01},
    {0xd400, {0xff}, 0x01},
    {0xd500, {0xa0}, 0x01},
    {0xd600, {0xaa}, 0x01},
    {0xd700, {0xf0}, 0x01},
    {0xd800, {0xff}, 0x01},

    // ===  Source  ===
    {0xfe00, {0x40}, 0x01},
    {0x4d00, {0xaa}, 0x01},
    {0x4e00, {0x00}, 0x01},
    {0x4f00, {0xa0}, 0x01},
    {0x5000, {0x00}, 0x01},
    {0x5100, {0xf3}, 0x01},
    {0x5200, {0x23}, 0x01},
    {0x6b00, {0xf3}, 0x01},
    {0x6c00, {0x13}, 0x01},
    {0x8f00, {0xff}, 0x01},
    {0x9000, {0xff}, 0x01},
    {0x9100, {0x3f}, 0x01},
    {0xa200, {0x10}, 0x01},
    {0x0700, {0x21}, 0x01},
    {0x3500, {0x81}, 0x01},

    // === gamma setting  ===
    {0xfe00, {0x40}, 0x01},
    {0x3300, {0x10}, 0x01},
    {0xfe00, {0x50}, 0x01},
    {0xa900, {0x30}, 0x01},
    {0xaa00, {0xb8}, 0x01},
    {0xab00, {0x01}, 0x01},
    {0xfe00, {0x60}, 0x01},
    {0xa900, {0x30}, 0x01},
    {0xaa00, {0x90}, 0x01},
    {0xab00, {0x01}, 0x01},

    //=== Watchedge ===
    {0xfe00, {0x90}, 0x01},
    {0xa400, {0x16}, 0x01}, //{0xa400,{0x16},0x01},
    {0xa500, {0x16}, 0x01}, //{0xa500,{0x16},0x01},
    {0xa600, {0x00}, 0x01},
    {0xa700, {0x16}, 0x01}, //{0xa700,{0x16},0x01},
    {0xa900, {0x16}, 0x01}, //{0xa900,{0x16},0x01},
    {0xaa00, {0x80}, 0x01},
    {0xab00, {0x0f}, 0x01}, //{0xab00,{0x0f},0x01},
    {0xac00, {0xff}, 0x01}, //{0xac00,{0xff},0x01},
    {0xae00, {0x3f}, 0x01}, //{0xae00,{0x3f},0x01},

    {0x3f00, {0x58}, 0x01},
    {0x4000, {0xb4}, 0x01},
    {0x4100, {0x29}, 0x01},

    //=== SCC ===
    {0xfe00, {0x90}, 0x01},
    {0x5100, {0x00}, 0x01},
    {0x5200, {0x08}, 0x01},
    {0x5300, {0x00}, 0x01},
    {0x5400, {0x18}, 0x01},
    {0x5500, {0x00}, 0x01},
    {0x5600, {0x00}, 0x01},
    {0x5700, {0x00}, 0x01},
    {0x5800, {0x00}, 0x01},
    {0x5900, {0x08}, 0x01},
    {0x5a00, {0x00}, 0x01},
    {0x5b00, {0x18}, 0x01},
    {0x5c00, {0x00}, 0x01},
    {0x5d00, {0x00}, 0x01},
    {0x5e00, {0x80}, 0x01},
    {0x5f00, {0x00}, 0x01},
    {0x6000, {0x00}, 0x01},
    {0x6100, {0x00}, 0x01},
    {0x6200, {0x18}, 0x01},
    {0x6300, {0x00}, 0x01},
    {0x6400, {0x00}, 0x01},
    {0x6500, {0x00}, 0x01},
    {0x6600, {0x08}, 0x01},
    {0x6700, {0x80}, 0x01},
    {0x6800, {0x40}, 0x01},
    {0x6900, {0x00}, 0x01},
    {0x6a00, {0x00}, 0x01},
    {0x6b00, {0x00}, 0x01},
    {0x6c00, {0x00}, 0x01},
    {0x6d00, {0x00}, 0x01},
    {0x6e00, {0x00}, 0x01},
    {0x6f00, {0x18}, 0x01},
    {0x7000, {0x80}, 0x01},
    {0x7100, {0x00}, 0x01},
    {0x7200, {0x00}, 0x01},
    {0x7300, {0x00}, 0x01},
    {0x7400, {0x00}, 0x01},
    {0x7500, {0x00}, 0x01},
    {0x7600, {0x18}, 0x01},
    {0x7700, {0x00}, 0x01},
    {0x7800, {0x08}, 0x01},
    {0x7900, {0x00}, 0x01},
    {0x7a00, {0x00}, 0x01},
    {0x7b00, {0x00}, 0x01},
    {0x7c00, {0x00}, 0x01},
    {0x7d00, {0x18}, 0x01},
    {0x7e00, {0x00}, 0x01},
    {0x7f00, {0x08}, 0x01},
    {0x8000, {0x00}, 0x01},
    {0x8100, {0x00}, 0x01},
    {0x8200, {0x80}, 0x01},
    {0x8300, {0x40}, 0x01},
    {0x8400, {0x00}, 0x01},
    {0x8500, {0x00}, 0x01},
    {0x8600, {0x08}, 0x01},
    {0x8700, {0x00}, 0x01},
    {0x8800, {0x04}, 0x01},
    {0x8900, {0x00}, 0x01},
    {0x8a00, {0x18}, 0x01},
    {0x8b00, {0x40}, 0x01},
    {0x8c00, {0x00}, 0x01},
    {0x8d00, {0x00}, 0x01},
    {0x8e00, {0x00}, 0x01},
    {0x8f00, {0x04}, 0x01},
    {0x9000, {0x00}, 0x01},
    {0x9100, {0x18}, 0x01},
    {0x9200, {0x00}, 0x01},
    {0x9300, {0x04}, 0x01},
    {0x9400, {0x40}, 0x01},
    {0x9500, {0x00}, 0x01},
    {0x9600, {0x00}, 0x01},
    {0x9700, {0x00}, 0x01},
    {0x9800, {0x18}, 0x01},
    {0x9900, {0x00}, 0x01},
    {0x9a00, {0x04}, 0x01},
    {0x9b00, {0x00}, 0x01},
    {0x9c00, {0x04}, 0x01},
    {0x9d00, {0x80}, 0x01},
    {0x9e00, {0x40}, 0x01},
    {0x9f00, {0x00}, 0x01},
    {0xa000, {0x00}, 0x01},
    {0xa200, {0x04}, 0x01},

    // === Power saving ===
    {0xfe00, {0x70}, 0x01},
    {0x9800, {0x74}, 0x01},
    {0xc900, {0x05}, 0x01},
    {0xca00, {0x05}, 0x01},
    {0xcb00, {0x05}, 0x01},
    {0xcc00, {0x05}, 0x01},
    {0xcd00, {0x05}, 0x01},
    {0xce00, {0x85}, 0x01},
    {0xcf00, {0x05}, 0x01},
    {0xd000, {0x45}, 0x01},

    {0xfe00, {0xe0}, 0x01},
    {0x1900, {0x42}, 0x01},
    {0x1e00, {0x42}, 0x01},
    {0x1c00, {0x41}, 0x01},
    {0x1800, {0x00}, 0x01},
    {0x1b00, {0x0c}, 0x01},
    {0x1a00, {0x9a}, 0x01},
    {0x1d00, {0xda}, 0x01},
    {0x2800, {0x5f}, 0x01},

    {0xfe00, {0x40}, 0x01},
    {0x5400, {0xac}, 0x01},
    {0x5500, {0xa0}, 0x01},
    {0x4800, {0xaa}, 0x01},

    //======================== 194*368 setting ===========================
    {0xfe00, {0x40}, 0x01},
    {0x7600, {0x96}, 0x01},
    {0x7700, {0xc2}, 0x01},
    {0x7800, {0x8e}, 0x01},
    {0x7900, {0xb3}, 0x01},
    {0x7a00, {0x8d}, 0x01},
    {0x7b00, {0x11}, 0x01},

    //======================== EDGE SETTING ===========================
    {0xfe00, {0x20}, 0x01},
    {0x2700, {0xC2}, 0x01},
    // {0xfe00,{0x40},0x01},//{0xfe00,{0x40},0x01},
    // {0x7600,{0x01},0x01},

    /*******BIST Star**********///
    // CS0=0;SPI_WriteComm(0xFE);SPI_WriteData(0x90);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0xAA);SPI_WriteData(0x00);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0xFE);SPI_WriteData(0xD0);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0x4E);SPI_WriteData(0x80);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0x4D);SPI_WriteData(0x1F);CS0=1;Delay(10);// 02:Write 04:Red 08:Green 10:Blue
    // CS0=0;SPI_WriteComm(0xFE);SPI_WriteData(0x40);CS0=1;Delay(10);
    // CS0=0;SPI_WriteComm(0x54);SPI_WriteData(0xAF);CS0=1;Delay(10);
    // {0xFE00,{0x90},0x01},
    // {0xAA00,{0x00},0x01},
    // {0xFE00,{0xD0},0x01},
    // {0x4E00,{0x80},0x01},
    // {0x4D00,{0x1F},0x01},
    // {0xFE00,{0x40},0x01},
    // {0x5400,{0xAF},0x01},

    /************BIST end***********///
    //=== CMD1 setting ===
    {0xfe00, {0x00}, 0x01},
    {0xc400, {0x80}, 0x01},
    {0x3a00, {0x55}, 0x01},
    {0x3500, {0x00}, 0x01},
    {0x5300, {0x20}, 0x01},
    {0x5100, {AMOLED_DEFAULT_BRIGHTNESS}, 0x01},
    {0x6300, {0xff}, 0x01},
    {0x2a00, {0x00, 0x00, 0x00, 0xc1}, 0x04},
    {0x2b00, {0x00, 0x00, 0x01, 0x6f}, 0x04},
    {0x1100, {}, 0x80},
    {0x2900, {}, 0x80},
};

const lcd_cmd_t rm67162_cmd[RM67162_INIT_SEQUENCE_LENGHT] = {
    {0x1100, {0x00}, 0x80}, // Sleep Out
    // {0x44, {0x01, 0x66},        0x02}, //Set_Tear_Scanline
    // {0x35, {0x00},        0x00}, //TE ON
    // {0x34, {0x00},        0x00}, //TE OFF
    // {0x36, {0x00},        0x01}, //Scan Direction Control
    {0x3A00, {0x55}, 0x01}, // Interface Pixel Format 16bit/pixel
    // {0x3A, {0x66},        0x01}, //Interface Pixel Format    18bit/pixel
    // {0x3A, {0x77},        0x01}, //Interface Pixel Format    24bit/pixel
    {0x5100, {0x00}, 0x01}, // Write Display Brightness MAX_VAL=0XFF
    {0x2900, {0x00}, 0x80}, // Display on
    {0x5100, {AMOLED_DEFAULT_BRIGHTNESS}, 0x01}, // Write Display Brightness   MAX_VAL=0XFF
    {0x3600, {0x60}, 0x01}, //
};

const lcd_cmd_t rm690b0_cmd[RM690B0_INIT_SEQUENCE_LENGHT] = {
    {0xFE00, {0x20}, 0x01},           //SET PAGE
    {0x2600, {0x0A}, 0x01},           //MIPI OFF
    {0x2400, {0x80}, 0x01},           //SPI write RAM
    {0x5A00, {0x51}, 0x01},           //! 230918:SWIRE FOR BV6804
    {0x5B00, {0x2E}, 0x01},           //! 230918:SWIRE FOR BV6804
    {0xFE00, {0x00}, 0x01},           //SET PAGE
    {0x3A00, {0x55}, 0x01},           //Interface Pixel Format    16bit/pixel
    {0xC200, {0x00}, 0x21},           //delay_ms(10);
    {0x3500, {0x00}, 0x01},           //TE ON
    {0x5100, {0x00}, 0x01},           //Write Display Brightness  MAX_VAL=0XFF
    {0x1100, {0x00}, 0x80},           //Sleep Out delay_ms(120);
    {0x2900, {0x00}, 0x20},           //Display on delay_ms(10);
    {0x5100, {0xFF}, 0x01},           //Write Display Brightness  MAX_VAL=0XFF
};

const lcd_cmd_t jd9613_cmd[JD9613_INIT_SEQUENCE_LENGHT] = {
    {0xfe, {0x01}, 0x02},
    {0xf7, {0x96, 0x13, 0xa9}, 0x04},
    {0x90, {0x01}, 0x02},
    {0x2c, {0x19, 0x0b, 0x24, 0x1b, 0x1b, 0x1b, 0xaa, 0x50, 0x01, 0x16, 0x04, 0x04, 0x04, 0xd7}, 0x0f},
    {0x2d, {0x66, 0x56, 0x55}, 0x04},
    {0x2e, {0x24, 0x04, 0x3f, 0x30, 0x30, 0xa8, 0xb8, 0xb8, 0x07}, 0x0a},
    {0x33, {0x03, 0x03, 0x03, 0x19, 0x19, 0x19, 0x13, 0x13, 0x13, 0x1a, 0x1a, 0x1a}, 0x0d},
    {0x10, {0x0b, 0x08, 0x64, 0xae, 0x0b, 0x08, 0x64, 0xae, 0x00, 0x80, 0x00, 0x00, 0x01}, 0x0e},
    {0x11, {0x01, 0x1e, 0x01, 0x1e, 0x00}, 0x06},
    {0x03, {0x93, 0x1c, 0x00, 0x01, 0x7e}, 0x06},
    {0x19, {0x00}, 0x02},
    {0x31, {0x1b, 0x00, 0x06, 0x05, 0x05, 0x05}, 0x07},
    {0x35, {0x00, 0x80, 0x80, 0x00}, 0x05},
    {0x12, {0x1b}, 0x02},
    {0x1a, {0x01, 0x20, 0x00, 0x08, 0x01, 0x06, 0x06, 0x06}, 0x09},
    {0x74, {0xbd, 0x00, 0x01, 0x08, 0x01, 0xbb, 0x98}, 0x08},
    {0x6c, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x01, 0x30, 0x08, 0x00}, 0x0a},
    {0x6d, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x02, 0x30, 0x08, 0x00}, 0x0a},
    {0x76, {0xda, 0x00, 0x02, 0x20, 0x39, 0x80, 0x80, 0x50, 0x05}, 0x0a},
    {0x6e, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x02, 0x4f, 0x02, 0x00}, 0x0a},
    {0x6f, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x01, 0x4f, 0x02, 0x00}, 0x0a},
    {0x80, {0xbd, 0x00, 0x01, 0x08, 0x01, 0xbb, 0x98}, 0x08},
    {0x78, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x01, 0x30, 0x08, 0x00}, 0x0a},
    {0x79, {0xdc, 0x08, 0x02, 0x01, 0x08, 0x02, 0x30, 0x08, 0x00}, 0x0a},
    {0x82, {0xda, 0x40, 0x02, 0x20, 0x39, 0x00, 0x80, 0x50, 0x05}, 0x0a},
    {0x7a, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x02, 0x4f, 0x02, 0x00}, 0x0a},
    {0x7b, {0xdc, 0x00, 0x02, 0x01, 0x00, 0x01, 0x4f, 0x02, 0x00}, 0x0a},
    {0x84, {0x01, 0x00, 0x09, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19}, 0x0b},
    {0x85, {0x19, 0x19, 0x19, 0x03, 0x02, 0x08, 0x19, 0x19, 0x19, 0x19}, 0x0b},
    {0x20, {0x20, 0x00, 0x08, 0x00, 0x02, 0x00, 0x40, 0x00, 0x10, 0x00, 0x04, 0x00}, 0x0d},
    {0x1e, {0x40, 0x00, 0x10, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08, 0x00, 0x02, 0x00}, 0x0d},
    {0x24, {0x20, 0x00, 0x08, 0x00, 0x02, 0x00, 0x40, 0x00, 0x10, 0x00, 0x04, 0x00}, 0x0d},
    {0x22, {0x40, 0x00, 0x10, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08, 0x00, 0x02, 0x00}, 0x0d},
    {0x13, {0x63, 0x52, 0x41}, 0x04},
    {0x14, {0x36, 0x25, 0x14}, 0x04},
    {0x15, {0x63, 0x52, 0x41}, 0x04},
    {0x16, {0x36, 0x25, 0x14}, 0x04},
    {0x1d, {0x10, 0x00, 0x00}, 0x04},
    {0x2a, {0x0d, 0x07}, 0x03},
    {0x27, {0x00, 0x01, 0x02, 0x03, 0x04, 0x05}, 0x07},
    {0x28, {0x00, 0x01, 0x02, 0x03, 0x04, 0x05}, 0x07},
    {0x26, {0x01, 0x01}, 0x03},
    {0x86, {0x01, 0x01}, 0x03},
    {0xfe, {0x02}, 0x02},
    {0x16, {0x81, 0x43, 0x23, 0x1e, 0x03}, 0x06},
    {0xfe, {0x03}, 0x02},
    {0x60, {0x01}, 0x02},
    {0x61, {0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x0d, 0x26, 0x5a, 0x80, 0x80, 0x95, 0xf8, 0x3b, 0x75}, 0x10},
    {0x62, {0x21, 0x22, 0x32, 0x43, 0x44, 0xd7, 0x0a, 0x59, 0xa1, 0xe1, 0x52, 0xb7, 0x11, 0x64, 0xb1}, 0x10},
    {0x63, {0x54, 0x55, 0x66, 0x06, 0xfb, 0x3f, 0x81, 0xc6, 0x06, 0x45, 0x83}, 0x0c},
    {0x64, {0x00, 0x00, 0x11, 0x11, 0x21, 0x00, 0x23, 0x6a, 0xf8, 0x63, 0x67, 0x70, 0xa5, 0xdc, 0x02}, 0x10},
    {0x65, {0x22, 0x22, 0x32, 0x43, 0x44, 0x24, 0x44, 0x82, 0xc1, 0xf8, 0x61, 0xbf, 0x13, 0x62, 0xad}, 0x10},
    {0x66, {0x54, 0x55, 0x65, 0x06, 0xf5, 0x37, 0x76, 0xb8, 0xf5, 0x31, 0x6c}, 0x0c},
    {0x67, {0x00, 0x10, 0x22, 0x22, 0x22, 0x00, 0x37, 0xa4, 0x7e, 0x22, 0x25, 0x2c, 0x4c, 0x72, 0x9a}, 0x10},
    {0x68, {0x22, 0x33, 0x43, 0x44, 0x55, 0xc1, 0xe5, 0x2d, 0x6f, 0xaf, 0x23, 0x8f, 0xf3, 0x50, 0xa6}, 0x10},
    {0x69, {0x65, 0x66, 0x77, 0x07, 0xfd, 0x4e, 0x9c, 0xed, 0x39, 0x86, 0xd3}, 0x0c},
    {0xfe, {0x05}, 0x02},
    {0x61, {0x00, 0x31, 0x44, 0x54, 0x55, 0x00, 0x92, 0xb5, 0x88, 0x19, 0x90, 0xe8, 0x3e, 0x71, 0xa5}, 0x10},
    {0x62, {0x55, 0x66, 0x76, 0x77, 0x88, 0xce, 0xf2, 0x32, 0x6e, 0xc4, 0x34, 0x8b, 0xd9, 0x2a, 0x7d}, 0x10},
    {0x63, {0x98, 0x99, 0xaa, 0x0a, 0xdc, 0x2e, 0x7d, 0xc3, 0x0d, 0x5b, 0x9e}, 0x0c},
    {0x64, {0x00, 0x31, 0x44, 0x54, 0x55, 0x00, 0xa2, 0xe5, 0xcd, 0x5c, 0x94, 0xcf, 0x09, 0x4a, 0x72}, 0x10},
    {0x65, {0x55, 0x65, 0x66, 0x77, 0x87, 0x9c, 0xc2, 0xff, 0x36, 0x6a, 0xec, 0x45, 0x91, 0xd8, 0x20}, 0x10},
    {0x66, {0x88, 0x98, 0x99, 0x0a, 0x68, 0xb0, 0xfb, 0x43, 0x8c, 0xd5, 0x0e}, 0x0c},
    {0x67, {0x00, 0x42, 0x55, 0x55, 0x55, 0x00, 0xcb, 0x62, 0xc5, 0x09, 0x44, 0x72, 0xa9, 0xd6, 0xfd}, 0x10},
    {0x68, {0x66, 0x66, 0x77, 0x87, 0x98, 0x21, 0x45, 0x96, 0xed, 0x29, 0x90, 0xee, 0x4b, 0xb1, 0x13}, 0x10},
    {0x69, {0x99, 0xaa, 0xba, 0x0b, 0x6a, 0xb8, 0x0d, 0x62, 0xb8, 0x0e, 0x54}, 0x0c},
    {0xfe, {0x07}, 0x02},
    {0x3e, {0x00}, 0x02},
    {0x42, {0x03, 0x10}, 0x03},
    {0x4a, {0x31}, 0x02},
    {0x5c, {0x01}, 0x02},
    {0x3c, {0x07, 0x00, 0x24, 0x04, 0x3f, 0xe2}, 0x07},
    {0x44, {0x03, 0x40, 0x3f, 0x02}, 0x05},
    {0x12, {0xaa, 0xaa, 0xc0, 0xc8, 0xd0, 0xd8, 0xe0, 0xe8, 0xf0, 0xf8}, 0x0b},
    {0x11, {0xaa, 0xaa, 0xaa, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0xa0, 0xa8, 0xb0, 0xb8}, 0x10},
    {0x10, {0xaa, 0xaa, 0xaa, 0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x50, 0x58}, 0x10},
    {0x14, {0x03, 0x1f, 0x3f, 0x5f, 0x7f, 0x9f, 0xbf, 0xdf, 0x03, 0x1f, 0x3f, 0x5f, 0x7f, 0x9f, 0xbf, 0xdf}, 0x11},
    {0x18, {0x70, 0x1a, 0x22, 0xbb, 0xaa, 0xff, 0x24, 0x71, 0x0f, 0x01, 0x00, 0x03}, 0x0d},
    {0xfe, {0x00}, 0x02},
    {0x3a, {0x55}, 0x02},
    {0xc4, {0x80}, 0x02},
    {0x2a, {0x00, 0x00, 0x00, 0x7d}, 0x05},
    {0x2b, {0x00, 0x00, 0x01, 0x25}, 0x05},
    {0x35, {0x00}, 0x02},
    {0x53, {0x28}, 0x02},
    {0x51, {0xff}, 0x02},
    {0, {0}, 0xff},
};

#endif


