<?php

namespace PormTests;

use Pionia\Base\PioniaApplication;
use Pionia\Porm\Database\Db;
use Pionia\Porm\Driver\Connection;
use Pionia\TestSuite\PioniaTestCase;
use function PHPUnit\Framework\assertInstanceOf;
use function PHPUnit\Framework\assertTrue;

class DatabaseConnectionTest extends PioniaTestCase
{
    public Connection $connection;

    public Db $porm;

    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        $this->application = new PioniaApplication();
        $this->connection = Connection::connect($this->application, [
            'type' => 'sqlite',
            'database' => 'database.sqlite3'
        ]);
        $this->connection->setTestMode(true);

        $this->porm = new DB($this->application, $this->connection);
    }

    public function testConnection()
    {
        assertInstanceOf(Connection::class, $this->connection);
    }

    public function testConnectionIsTestMode()
    {
        assertTrue($this->connection->isTestMode());
    }

}
