# Pionia Core

##### This is the core of the Pionia Framework


## Installation

```bash
composer require pionia/pionia-core
```
This is meant for the core developers of the Pionia Core not the framework itself.
If you are looking to use or get started with the framework, please find the [Pionia Framework here](https://github.com/PioniaPHP-project/Application)

## Usage

#### [Go to the documentation here](https://pioniaphp-project.github.io/Pionia/)

# Road Map for the Pionia Framework(Subject to change)

> ##### Coverage 25/26 -- 96%

## Packages covered

- [x] Pionia\Core
- [x] Authentication
- [x] Database
- [x] File System
-  Mail
- [x] Session
- [x] Validation
- [x] Templating engine
- [x] Routing
- [x] Middleware
- [x] Request
- [x] Response
- [x] Services
- [x] Switches
- [x] Config and Environments
- [x] Logging
- [x] Cors
- [x] HTTP Kernel
- [x] Events
- [x] Console
- [x] Cache
- [x] Exception handling
- [x] Helper functions
- [x] CLI Bootstrapping
- [x] Uploading and Serving Media Files
- [x] Collections

## Setting up the this project

### Prerequisites

- PHP 8.1 or higher
- Composer
- Git
- Any Editor/IDE of your choice preferably PHPStorm or Intellij IDEA

### Installation

Clone the repository

```bash
git clone https://github.com/PioniaPHP-project/Pionia.git
```

Change directory to the project folder

```bash
cd Pionia
```

Install the dependencies

```bash
composer install
```

### Running the tests

```bash
composer test
```

### Compiling the core dev docs

```bash
composer document
```

### Contributing

Please read the [CONTRIBUTING.md](/CONTRIBUTING.md) file for more information on how to contribute to this project.

### Authors

- [**Jet2018**](https://github.com/jet2018)

## License
[MIT License](https://github.com/PioniaPHP-project/.github/blob/main/profile/LICENCE.md)
