<?php

declare(strict_types=1);

return [
    [
        'key' => 'overallFiles',
        'name' => 'Files',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallFileErrors',
        'name' => 'Files errors',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallFunctionCount',
        'name' => 'Function count',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallClasses',
        'name' => 'Class count',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAbstractClasses',
        'name' => 'Abstract classes',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallInterfaces',
        'name' => 'Interface count',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overAllMethodsCount',
        'name' => 'Method count',
        'shortName' => 'Methods',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overAllPublicMethodsCount',
        'name' => 'Public methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overAllPrivateMethodsCount',
        'name' => 'Private methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overAllStaticMethodsCount',
        'name' => 'Static methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallOutputStatements',
        'name' => 'Output statements',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallLoc',
        'name' => 'Lines of code',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallLloc',
        'name' => 'Logical lines of code',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallLlocOutside',
        'name' => 'Logical lines of code',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallInsideMethodLloc',
        'name' => 'Logical lines of code in methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallInsideFuntionLloc',
        'name' => 'Logical lines of code in functions',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallHtmlLoc',
        'name' => 'Lines of HTML Code',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallCloc',
        'name' => 'Comment lines of code',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMostComplexFile',
        'name' => 'Most complex file',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMostComplexClass',
        'name' => 'Most complex class',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMostComplexFunction',
        'name' => 'Most complex function',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMostComplexMethod',
        'name' => 'Most complex method',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMaxCC',
        'name' => 'Max. cyclomatic complexity',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgCC',
        'name' => 'Avg. cyclomatic complexity',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgCCFile',
        'name' => 'Avg. cyclomatic complexity of files',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgCCClass',
        'name' => 'Avg. cyclomatic complexity of classes',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgCCMethod',
        'name' => 'Avg. cyclomatic complexity of methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgCCFunction',
        'name' => 'Avg. cyclomatic complexity of functions',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgCCFile',
        'name' => 'Avg. cyclomatic complexity of files',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMaxCCFile',
        'name' => 'Max cyclomatic complexity of files',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMaxCCClass',
        'name' => 'Max cyclomatic complexity of classes',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMaxCCMethod',
        'name' => 'Max cyclomatic complexity of methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallMaxCCFunction',
        'name' => 'Max cyclomatic complexity of functions',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgLcom',
        'name' => 'Avg. LCOM',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgMI',
        'name' => 'Avg. maintainability index',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallCommentWeight',
        'name' => 'Comment weight',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgUsesCount',
        'name' => 'Average uses count',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgUsedByCount',
        'name' => 'Average used by count',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAvgInstability',
        'name' => 'Average instability',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallAbstractness',
        'name' => 'Abstractness',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallDistanceFromMainline',
        'name' => 'Distance from main line',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallInformationCount',
        'name' => 'Informations',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallWarningCount',
        'name' => 'Warnings',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'overallErrorCount',
        'name' => 'Errors',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],

    [
        'key' => 'originalEncoding',
        'name' => 'File encoding',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'commonPath',
        'name' => 'Common path',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'fullName',
        'name' => 'Full path',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'projectPath',
        'name' => 'Project path',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'dirName',
        'name' => 'Dir name',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'fileName',
        'name' => 'File name',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ProjectCollection,
        ],
    ],
    [
        'key' => 'filePath',
        'name' => 'File path',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'singleName',
        'name' => 'Name of the file',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'namespace',
        'name' => 'Namespace',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'package',
        'name' => 'Package',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_STRING,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'classInfo',
        'name' => 'Class',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_ARRAY,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'interface',
        'name' => 'Interface',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'trait',
        'name' => 'Trait',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'abstract',
        'name' => 'Abstract',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'enum',
        'name' => 'Enum',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'final',
        'name' => 'Final',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'realClass',
        'name' => 'Real class',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'anonymous',
        'name' => 'Anonymous class',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'constantCount',
        'name' => 'Constant count',
        'shortName' => 'Constants',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'propertyCount',
        'name' => 'Property count',
        'shortName' => 'Properties',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'methodCount',
        'name' => 'Method count',
        'shortName' => 'Methods',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'publicCount',
        'name' => 'Public methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'privateCount',
        'name' => 'Private methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'staticCount',
        'name' => 'Static methods',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],

    [
        'key' => 'protected',
        'name' => 'Protected',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'public',
        'name' => 'Public',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'private',
        'name' => 'Private',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'static',
        'name' => 'static',
        'shortName' => '',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],


    [
        'key' => 'loc',
        'name' => 'Lines of code',
        'shortName' => 'LOC',
        'description' => 'Lines of code as is, with comments and empty lines.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'lloc',
        'name' => 'Logical lines of code',
        'shortName' => 'LLOC',
        'description' => 'Lines of code without comments and empty lines.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'cloc',
        'name' => 'Comment lines of code',
        'shortName' => 'CLOC',
        'description' => 'Lines of code with comments only.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'htmlLoc',
        'name' => 'Lines of code with HTML code.',
        'shortName' => 'HTML LOC',
        'description' => 'Lines of code with comments only.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'outputCount',
        'name' => 'Count of echo and printf calls.',
        'shortName' => 'OC',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'llocOutside',
        'name' => 'Lines of code outside',
        'shortName' => 'Lloc outside',
        'description' => 'Lines of code outside of functions and classes.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
        ],
    ],
    [
        'key' => 'cc',
        'name' => 'Cyclomatic complexity',
        'shortName' => 'CC',
        'description' => 'McCabe cyclomatic complexity.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'problemData' => [
            [
                'key' => 'predictionTooComplex',
                'value' => true,
            ],
        ],
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'avgMethodCc',
        'name' => 'Avg. cyclomatic complexity of methods',
        'shortName' => 'Avg.CC/method',
        'description' => 'Average McCabe cyclomatic complexity of methods.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'problemData' => [
            [
                'key' => 'avgMethodCc',
                'value' => 10,
                'compare' => '>'
            ],
        ],
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],

    [
        'key' => 'vocabulary',
        'name' => 'Vocabulary',
        'shortName' => 'Voc',
        'description' => 'Code vocabulary.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],

    [
        'key' => 'length',
        'name' => 'Length',
        'shortName' => 'Len',
        'description' => 'Code length.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'calcLength',
        'name' => 'Calculated length',
        'shortName' => 'Calc. Len',
        'description' => 'Calculated code length.',
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'volume',
        'name' => 'Code volume',
        'shortName' => 'Vol',
        'description' => 'Code volume.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'difficulty',
        'name' => 'Difficulty',
        'shortName' => 'Difficulty',
        'description' => 'Code difficulty',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'effort',
        'name' => 'Effort',
        'shortName' => 'Effort',
        'description' => 'Effort to understand code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'operators',
        'name' => 'Operator count',
        'shortName' => 'Operators',
        'description' => 'Count of operators in code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'operands',
        'name' => 'Operands',
        'shortName' => 'Operands',
        'description' => 'Count of operands in code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'uniqueOperators',
        'name' => 'Unique operators',
        'shortName' => 'Unique operators',
        'description' => 'Unique operators in code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'uniqueOperands',
        'name' => 'Unique operands',
        'shortName' => 'Unique operands',
        'description' => 'Unique operands in code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'complexityDensity',
        'name' => 'Complexity density',
        'shortName' => 'Compl. dens.',
        'description' => 'Complexity density.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],

    [
        'key' => 'maintainabilityIndex',
        'name' => 'Maintainability index',
        'shortName' => 'MI',
        'description' => 'The calculated maintainability index.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'maintainabilityIndexWithoutComments',
        'name' => 'Maintainability index w/out comments',
        'shortName' => 'MI w/o comments',
        'description' => 'The calculated maintainability index without comments.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'commentWeight',
        'name' => 'Comment weight',
        'shortName' => 'CW',
        'description' => 'The weight of comments.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_HIGH,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],

    [
        'key' => 'lcom',
        'name' => 'LCOM',
        'shortName' => 'LCOM',
        'description' => 'LCOM.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],

    [
        'key' => 'instability',
        'name' => 'Instability',
        'shortName' => 'I',
        'description' => 'Instability.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => [\PhpCodeArch\Metrics\Model\MetricType::SHOW_COUPLING, \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE],
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'abstractness',
        'name' => 'Abstractness',
        'shortName' => 'A',
        'description' => 'Abstractness.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'distanceFromMainline',
        'name' => 'Distance from main line',
        'shortName' => 'Dist',
        'description' => 'Distance.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],

    [
        'key' => 'uses',
        'name' => 'Efferent coupling',
        'shortName' => 'Efferent coupling',
        'description' => 'Classes used.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_COUNT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_COUPLING,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'usesCount',
        'name' => 'Efferent coupling',
        'shortName' => 'Efferent coupling',
        'description' => 'Uses count.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'usedBy',
        'name' => 'Afferent coupling',
        'shortName' => 'Afferent coupling',
        'description' => 'Used by.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_COUNT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_COUPLING,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'usedByCount',
        'name' => 'Afferent coupling',
        'shortName' => 'Afferent coupling',
        'description' => 'Used by count.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_EVERYWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'usesInProject',
        'name' => 'Used classes in project',
        'shortName' => 'Used classes in project',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_ARRAY,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'usesInProjectCount',
        'name' => 'Used classes in project',
        'shortName' => 'Used classes in project',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'usesForInstability',
        'name' => 'Efferent coupling',
        'shortName' => 'Efferent coupling',
        'description' => 'Uses count für instability calculation.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_ARRAY,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'usesForInstabilityCount',
        'name' => 'Efferent coupling',
        'shortName' => 'Efferent coupling',
        'description' => 'Uses count für instability calculation.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::PackageCollection,
        ],
    ],
    [
        'key' => 'usedFromOutside',
        'name' => 'Uses from outside count',
        'shortName' => 'UfoC',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'usedFromOutsideCount',
        'name' => 'Uses from outside count',
        'shortName' => 'UfoC',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'usedByFunction',
        'name' => 'Uses from outside count',
        'shortName' => 'UfoC',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],
    [
        'key' => 'usedByFunctionCount',
        'name' => 'Uses from outside count',
        'shortName' => 'UfoC',
        'description' => '',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
        ],
    ],


    [
        'key' => 'superglobals',
        'name' => 'Superglobals used',
        'shortName' => 'Superglobals',
        'description' => 'Count of superglobals used.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_COUNT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'variables',
        'name' => 'Variables used',
        'shortName' => 'Variables',
        'description' => 'Count of variables uses.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_COUNT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'constants',
        'name' => 'Constants used',
        'shortName' => 'Constants used',
        'description' => 'Constants used in code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_COUNT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'superglobalsUsed',
        'name' => 'Superglobals count',
        'shortName' => 'Superglob. count',
        'description' => 'Count of superglobals.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'distinctSuperglobalsUsed',
        'name' => 'Distinct superglobals used',
        'shortName' => 'Dist. superglob. count',
        'description' => 'Distinct superglobals used.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'variablesUsed',
        'name' => 'Variables count',
        'shortName' => 'Variables count',
        'description' => 'Count of variables.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'distinctVariablesUsed',
        'name' => 'Distinct variables used',
        'shortName' => 'Distinct variables used',
        'description' => 'Distinct variables used.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'constantsUsed',
        'name' => 'Constants count',
        'shortName' => 'Constants count',
        'description' => 'Constants used in code.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'distinctConstantsUsed',
        'name' => 'Distinct constants count',
        'shortName' => 'Distinct constants count',
        'description' => 'Distinct constants count.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_INT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'superglobalMetric',
        'name' => 'Superglobal index',
        'shortName' => 'Superglobal score',
        'description' => 'Superglobal score.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_IN_DETAILS,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],

    [
        'key' => 'predictionTooLong',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'predictionGodObject',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'godObjectSuspectIndex',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_FLOAT,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'predictionTooComplex',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'predictionTooDependent',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'predictionTooMuchHtml',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'predictionTooMuchOutput',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'predictionViewOrDefect',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_BOOL,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_IRRELEVANT,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],
    [
        'key' => 'htmlPercentage',
        'name' => '',
        'shortName' => '',
        'description' => '.',
        'valueType' => \PhpCodeArch\Metrics\Model\MetricType::VALUE_PERCENTAGE,
        'better' => \PhpCodeArch\Metrics\Model\MetricType::BETTER_LOW,
        'visibility' => \PhpCodeArch\Metrics\Model\MetricType::SHOW_NOWHERE,
        'collections' => [
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FileCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::ClassCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::FunctionCollection,
            \PhpCodeArch\Metrics\MetricCollectionTypeEnum::MethodCollection,
        ],
    ],

    ['key' => 'returnType', 'type' => 'storage',],
    ['key' => 'functionType', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMaxCc', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMaxMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMaxDifficulty', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMaxEffort', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMinCc', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMinMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMinDifficulty', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionMinEffort', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionAvgCc', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionAvgMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionAvgDifficulty', 'type' => 'storage',],
    ['key' => 'overallFileMetricsCollectionAvgEffort', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMaxCc', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMaxMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMaxDifficulty', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMaxEffort', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMinCc', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMinMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMinDifficulty', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionMinEffort', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionAvgCc', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionAvgMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionAvgDifficulty', 'type' => 'storage',],
    ['key' => 'overallFunctionMetricsCollectionAvgEffort', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMaxCc', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMaxMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMaxDifficulty', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMaxEffort', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMaxLcom', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMaxInstability', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMinCc', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMinMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMinDifficulty', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMinEffort', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMinLcom', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionMinInstability', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionAvgCc', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionAvgMaintainabilityIndex', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionAvgDifficulty', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionAvgEffort', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionAvgLcom', 'type' => 'storage',],
    ['key' => 'overallClassMetricsCollectionAvgInstability', 'type' => 'storage',],
];
