"use strict";

class AfflictionsPage extends ListPage {
	constructor () {
		const pageFilter = new PageFilterAfflictions();

		super({
			dataSource: "data/afflictions.json",

			pageFilter,

			listClass: "afflictions",

			sublistClass: "subafflictions",

			dataProps: [ "disease", "curse" ],
		});
	}

	getListItem (it, cdI, isExcluded) {
		this._pageFilter.mutateAndAddToFilters(it, isExcluded);

		const eleLi = document.createElement("li");
		eleLi.className = `row ${isExcluded ? "row--blacklisted" : ""}`;

		const source = Parser.sourceJsonToAbv(it.source);
		const hash = UrlUtil.autoEncodeHash(it);

		eleLi.innerHTML = `<a href="#${hash}" class="lst--border">
			<span class="bold col-6 pl-0">${it.name}</span>
			<span class="col-3-5 text-center">${it.type ? it.type : "—"}</span>
			<span class="col-2-5 text-center ${Parser.sourceJsonToColor(it.source)}" title="${Parser.sourceJsonToFull(it.source)}" ${BrewUtil.sourceJsonToStyle(it.source)}>${source}</span>
		</a>`;

		const listItem = new ListItem(
			cdI,
			eleLi,
			it.name,
			{
				hash,
				source,
				type: it.type,
				aliases: it.alias ? it.alias.join(" - ") : "",
			},
			{
				uniqueId: it.uniqueId ? it.uniqueId : cdI,
				isExcluded,
			},
		);

		eleLi.addEventListener("click", (evt) => this._list.doSelect(listItem, evt));
		eleLi.addEventListener("contextmenu", (evt) => ListUtil.openContextMenu(evt, this._list, listItem));

		return listItem;
	}

	handleFilterChange () {
		const f = this._filterBox.getValues();
		this._list.filter(item => this._pageFilter.toDisplay(f, this._dataList[item.ix]));
		FilterBox.selectFirstVisible(this._dataList);
	}

	getSublistItem (it, pinId) {
		const hash = UrlUtil.autoEncodeHash(it);

		const $ele = $(`<li class="row">
			<a href="#${hash}" class="lst--border">
				<span class="bold col-8 pl-0">${it.name}</span>
				<span class="col-4 pr-0 text-center">${it.type ? it.type : "—"}</span>
			</a>
		</li>`)
			.contextmenu(evt => ListUtil.openSubContextMenu(evt, listItem));

		const listItem = new ListItem(
			pinId,
			$ele,
			it.name,
			{
				hash,
				type: it.type,
			},
		);
		return listItem;
	}

	doLoadHash (id) {
		const $content = $("#pagecontent").empty();
		const it = this._dataList[id];

		function buildStatsTab () {
			$content.append(Renderer.affliction.getRenderedString(it));
		}
		const buildInfoTab = async () => {
			const quickRules = await Renderer.utils.pGetQuickRules(it.__prop);
			$content.append(quickRules);
			if (it.temptedCurse) {
				const quickRulesExtra = await Renderer.utils.pGetQuickRules("temptedCurse");
				$content.append(quickRulesExtra);
			}
		}
		const statTab = Renderer.utils.tabButton(
			"Affliction",
			() => {},
			buildStatsTab,
		);
		const infoTab = Renderer.utils.tabButton(
			"Quick Rules",
			() => {},
			buildInfoTab,
		);

		Renderer.utils.bindTabButtons(statTab, infoTab);

		ListUtil.updateSelected();
	}

	async pDoLoadSubHash (sub) {
		sub = this._filterBox.setFromSubHashes(sub);
		await ListUtil.pSetFromSubHashes(sub);
	}
}

let afflictionsPage;
window.addEventListener("load", async () => {
	await Renderer.trait.preloadTraits();
	afflictionsPage = new AfflictionsPage();
	afflictionsPage.pOnLoad()
});
