unit TextParsingFrm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,
  PascalStrings, TextParsing, CoreClasses, UnicodeMixedLib, zExpression, opCode, MemoryStream64, ListEngine,
  DoStatusIO,
  TypInfo,
  Vcl.ComCtrls, Vcl.ExtCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Memo1: TMemo;
    Button1: TButton;
    Memo2: TMemo;
    Button2: TButton;
    TabSheet2: TTabSheet;
    Memo3: TMemo;
    Button3: TButton;
    Memo4: TMemo;
    TabSheet3: TTabSheet;
    Memo5: TMemo;
    Panel1: TPanel;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


procedure TForm1.Button1Click(Sender: TObject);
var
  t: TTextParsing;
  i: Integer;
  pt: PTokenData;
begin
  t := TTextParsing.Create(Memo1.Text, TTextStyle.tsPascal, nil);

  Memo2.Clear;

  for i := 0 to t.ParsingData.Cache.TokenDataList.Count - 1 do
    begin
      pt := t.ParsingData.Cache.TokenDataList[i];
      if pt^.tokenType <> TTokenType.ttUnknow then
          Memo2.Lines.Add(Format(' %d :%s ֵ %s', [i, GetEnumName(TypeInfo(TTokenType), Ord(pt^.tokenType)), pt^.Text.Text]));
    end;

  DisposeObject(t);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  t: TTextParsing;
  i: Integer;
  pt: PTokenData;
begin
  t := TTextParsing.Create(Memo1.Text, TTextStyle.tsC, nil);

  Memo2.Clear;

  for i := 0 to t.ParsingData.Cache.TokenDataList.Count - 1 do
    begin
      pt := t.ParsingData.Cache.TokenDataList[i];
      if pt^.tokenType <> TTokenType.ttUnknow then
          Memo2.Lines.Add(Format(' %d :%s ֵ %s', [i, GetEnumName(TypeInfo(TTokenType), Ord(pt^.tokenType)), pt^.Text.Text]));
    end;

  DisposeObject(t);
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  t: TTextParsing;
  i: Integer;
  pt: PTokenData;

  PrepareProc: Boolean;
begin
  t := TTextParsing.Create(Memo3.Text, TTextStyle.tsPascal, nil);

  Memo2.Clear;
  PrepareProc := False;

  for i := 0 to t.ParsingData.Cache.TokenDataList.Count - 1 do
    begin
      pt := t.ParsingData.Cache.TokenDataList[i];

      if PrepareProc then
        begin
          if (pt^.tokenType = TTokenType.ttSymbol) then
              PrepareProc := False
          else if (pt^.tokenType = TTokenType.ttAscii) then
              Memo4.Lines.Add(Format(' %d :%s ֵ %s', [i, GetEnumName(TypeInfo(TTokenType), Ord(pt^.tokenType)), pt^.Text.Text]));
        end
      else
          PrepareProc := (pt^.tokenType = TTokenType.ttAscii) and (pt^.Text.Same('function') or pt^.Text.Same('procedure'));
    end;

  DisposeObject(t);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  rt: TOpCustomRunTime;
  v: Variant;
begin
  Memo5.Lines.Add('ʹdemo');
  // rtΪzeкֿ֧
  rt := TOpCustomRunTime.Create;
  rt.RegOpP('myAddFunction', function(var Param: TOpParam): Variant
    // (a+b)*0.5
    begin
      Result := (Param[0] + Param[1]) * 0.5;
    end);
  rt.RegOpP('myStringFunction', function(var Param: TOpParam): Variant
    begin
      Result := Format('ַΪ:%d', [Length(VarToStr(Param[0]) + VarToStr(Param[1]))]);
    end);

  // ѧʽ
  v := EvaluateExpressionValue(False, '1000+{ Ǳע zeʶpascalcıעԼַд } myAddFunction(1+1/2*3/3.14*9999, 599+2+2*100 shl 3)', rt);
  Memo5.Lines.Add(VarToStr(v));

  // ַʽzeĬıʽΪPascal
  v := EvaluateExpressionValue(False, 'myStringFunction('#39'abc'#39', '#39'123'#39')', rt);
  Memo5.Lines.Add(VarToStr(v));

  // ַʽʹcıʽcֵ֧˫ţǲ֧#ַʽ
  v := EvaluateExpressionValue(tsC, 'myStringFunction("abc", "123")', rt);
  Memo5.Lines.Add(VarToStr(v));
  v := EvaluateExpressionValue(tsC, 'myStringFunction('#39'abc'#39', '#39'123'#39')', rt);
  Memo5.Lines.Add(VarToStr(v));

  DisposeObject(rt);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  tmpSym: TSymbolExpression;
  op: TOpCode;
  rt: TOpCustomRunTime;
  m64: TMemoryStream64;
begin
  Memo5.Lines.Add('ִdemo');
  // rtΪzeкֿ֧
  rt := TOpCustomRunTime.Create;
  rt.RegOpP('myAddFunction', function(var Param: TOpParam): Variant
    // (a+b)*0.5
    begin
      Result := (Param[0] + Param[1]) * 0.5;
    end);
  rt.RegOpP('myStringFunction', function(var Param: TOpParam): Variant
    begin
      Result := Format('ַΪ:%d', [Length(VarToStr(Param[0]) + VarToStr(Param[1]))]);
    end);

  // ʹParseTextExpressionAsSymbolʽɴʷ
  tmpSym := ParseTextExpressionAsSymbol_M(TTextParsing, tsPascal, '', '1000+myAddFunction(1+1/2*3/3.14*9999, 599+2+2*100 shl 3)', nil, rt);
  // BuildAsOpCodeὫʷٴη﷨Ȼٻ﷨op
  op := BuildAsOpCode(tmpSym);
  DisposeObject(tmpSym);
  // ִһop
  Memo5.Lines.Add(Format('opзֵ(ȷֵΪ4489.2962): %s', [VarToStr(op.Execute(rt))]));

  m64 := TMemoryStream64.Create;
  op.SaveToStream(m64);

  // Ѿͷop
  DisposeObject(op);

  // streamٶȡop
  m64.Position := 0;
  if LoadOpFromStream(m64, op) then
    begin
      Memo5.Lines.Add(Format('opзֵ(ȷֵΪ4489.2962): %s', [VarToStr(op.Execute(rt))]));
    end;

  DisposeObject([op, rt, m64]);

  Memo5.Lines.Add('ִdemo');
end;

procedure TForm1.Button6Click(Sender: TObject);
type
  TState = (sUnknow, sIF, sTrue, sFalse); // õļ״̬
label gFillStruct;
var
  t: TTextParsing;                                  // ʷ
  cp, ep: Integer;                                  // 
  wasNumber, wasText, wasAscii, wasSymbol: Boolean; // ı״̬
  state: TState;                                    // ṹ״̬
  decl: TPascalString;                              // ǰʷ壬
  ifMatchBody: TPascalString;                       // ж
  ifTrueBody: TPascalString;                        // 
  ifFalseBody: TPascalString;                       // 
  rt: TOpCustomRunTime;                             // к֧
begin
  // pascalַдڳУcַ
  t := TTextParsing.Create('if 1+1=/* comment */2 then writeln/* comment */("if was true") else writeln/* comment */("if was false");', tsC, nil);
  cp := 1;
  ep := 1;
  state := sUnknow;
  ifMatchBody := '';
  ifTrueBody := '';
  ifFalseBody := '';

  // ѭ
  while cp < t.Len do
    begin
      // Ǵ뱸עȥ
      if t.IsComment(cp) then
        begin
          ep := t.GetCommentEndPos(cp);
          cp := ep;
          continue;
        end;

      // ʷ̷ʽ״˷ʽԳʷΪûпܣҪнű뿼Ǳݽṹ洢Ըٷʽ
      wasNumber := t.IsNumber(cp);
      wasText := t.IsTextDecl(cp);
      wasAscii := t.IsAscii(cp);
      wasSymbol := t.IsSymbol(cp);

      if wasNumber then
        begin
          ep := t.GetNumberEndPos(cp);
          decl := t.GetStr(cp, ep);
          cp := ep;
          goto gFillStruct;
        end;

      if wasText then
        begin
          ep := t.GetTextDeclEndPos(cp);
          decl := t.GetStr(cp, ep);
          cp := ep;
          goto gFillStruct;
        end;

      if wasAscii then
        begin
          ep := t.GetAsciiEndPos(cp);
          decl := t.GetStr(cp, ep);
          cp := ep;
          goto gFillStruct;
        end;

      if wasSymbol then
        begin
          decl := t.ParsingData.Text[cp];
          inc(cp);
          ep := cp;
          goto gFillStruct;
        end;

      inc(cp);
      continue;
      // ʷ̷ʽṹж

    gFillStruct:

      if wasAscii then
        begin
          // ʷṹ
          if decl.Same('if') then
            begin
              if state <> sUnknow then
                begin
                  Memo5.Lines.Add('if ʽ');
                  break;
                end;
              state := sIF;
              continue;
            end;

          if decl.Same('then') then
            begin
              if state <> sIF then
                begin
                  Memo5.Lines.Add('then ʽ');
                  break;
                end;
              state := sTrue;
              continue;
            end;

          if decl.Same('else') then
            begin
              if state <> sTrue then
                begin
                  Memo5.Lines.Add('else дʽ');
                  break;
                end;
              state := sFalse;
              continue;
            end;
        end;

      case state of
        sIF: ifMatchBody.Append(decl);    // TPascalStringУʹAppendҪstring:=string+stringЧʸ
        sTrue: ifTrueBody.Append(decl);   // TPascalStringУʹAppendҪstring:=string+stringЧʸ
        sFalse: ifFalseBody.Append(decl); // TPascalStringУʹAppendҪstring:=string+stringЧʸ
      end;
    end;

  // һifṹѾɹˣֱг򼴿
  if state = sFalse then
    begin
      rt := TOpCustomRunTime.Create;
      rt.RegOpP('writeln', function(var Param: TOpParam): Variant
        begin
          Memo5.Lines.Add(VarToStr(Param[0]));
          Result := 0;
        end);
      // ҪܣĽṹԿݽṹ洢ʵֿٽű
      // opCache.Clear;
      if EvaluateExpressionValue(tsC, ifMatchBody, rt) = True then
          EvaluateExpressionValue(tsC, ifTrueBody, rt)
      else
          EvaluateExpressionValue(tsC, ifFalseBody, rt);
      DisposeObject(rt);
    end;

  DisposeObject(t);
end;

procedure TForm1.Button7Click(Sender: TObject);

  function Macro(var AText: string; const HeadToken, TailToken: string; const rt: TOpCustomRunTime): TPascalString; inline;
  var
    sour: TPascalString;
    ht, tt: TPascalString;
    bPos, ePos: Integer;
    KeyText: SystemString;
    i: Integer;
    tmpSym: TSymbolExpression;
    op: TOpCode;
  begin
    Result := '';
    sour.Text := AText;
    ht.Text := HeadToken;
    tt.Text := TailToken;

    i := 1;

    while i <= sour.Len do
      begin
        if sour.ComparePos(i, @ht) then
          begin
            bPos := i;
            ePos := sour.GetPos(@tt, i + ht.Len);
            if ePos > 0 then
              begin
                KeyText := sour.copy(bPos + ht.Len, ePos - (bPos + ht.Len)).Text;

                // TPascalStringУʹAppendҪstring:=string+stringЧʸ
                Result.Append(VarToStr(EvaluateExpressionValue(KeyText, rt)));
                i := ePos + tt.Len;
                continue;
              end;
          end;

        // TPascalStringУʹAppendҪstring:=string+stringЧʸ
        Result.Append(sour[i]);
        inc(i);
      end;
  end;

var
  n: string;
  i: Integer;
  t: TTimeTick;
  rt: TOpCustomRunTime;
begin
  Memo5.Lines.Add('ʾýűװzExpression');
  // rtΪzeкֿ֧
  rt := TOpCustomRunTime.Create;
  rt.RegOpP('OverFunction', function(var Param: TOpParam): Variant
    begin
      Result := 'лл';
    end);

  // ʹú괦1+1Աʽ
  n := '1+1=<begin>1+1<end>һUInt48λ:<begin>1<<48<end> <begin>OverFunction<end>';

  Memo5.Lines.Add('ԭ:' + n);
  Memo5.Lines.Add('' + Macro(n, '<begin>', '<end>', rt).Text);

  Memo5.Lines.Add('zExpressionڲܣԭ10δ');

  t := GetTimeTick;

  // ظ1ξ䷨ʽʹ
  for i := 1 to 10 * 10000 do
      Macro(n, '<begin>', '<end>', rt);

  Memo5.Lines.Add(Format('zExpressionܲɣʱ:%dms', [GetTimeTick - t]));

  DisposeObject([rt]);
end;

procedure TForm1.Button8Click(Sender: TObject);
// ߼Demoʵڲĸֵ
// Ҵһűγķе࣬ԭֻ
var
  sourTp, t: TTextParsing;            // ʷ
  setBefore, setAfter: TPascalString; // ֵǰ͸ֵĺ
  splitVarDecl: TArrayPascalString;   // пıʽ
  myvars: TArrayPascalString;         // ҪֵʱԶŷָ
  WasAssignment: Boolean;             // ڱʽҵ˸ֵ
  HashVars: THashVariantList;         // hash洢ṹǿԴŵӲе
  rt: TOpCustomRunTime;               // к֧
  op: TOpCode;                        // cacheop
  i: Integer;                         // forʹ
  dynvar: Integer;                    // ̬
begin
  // cpascalд޸ıע
  sourTp := TTextParsing.Create('myvar1/*Ǳע*/,myvar2,myvar3 = 123+456+" : "+dynamic', tsC, nil); // ʷ棬c﷨Ϊ
  // sourTp := TTextParsing.Create('myvar1(*Ǳע*),myvar2,myvar3 := 123+456+'#39' : '#39'+dynamic', tsPascal); // ʷ棬c﷨Ϊ
  // sourTp := TTextParsing.Create('123+456+dynamic', tsPascal); // ʷ棬c﷨Ϊ

  HashVars := THashVariantList.CustomCreate(16); // 16hashbuffȣֵԽٶԽ

  SetLength(splitVarDecl, 0);
  SetLength(myvars, 0);

  // һֵ
  case sourTp.TextStyle of
    tsPascal:
      begin
        // pascalĸֵΪ :=
        WasAssignment := sourTp.SplitString(1, ':=', ';', splitVarDecl) = 2; // ַΪиǺţԴ:=Ǻŵַи
        if WasAssignment then
          begin
            setBefore := splitVarDecl[0];
            setAfter := splitVarDecl[1];

            t := TTextParsing.Create(setBefore, tsPascal, nil);
            t.DeletedComment;
            if t.SplitChar(1, ',', ';', myvars) = 0 then // ﲻַַΪиǺţԴ,ַи
                Memo5.Lines.Add(Format('ֵ﷨ %s', [setBefore.Text]));
            DisposeObject(t);
          end;
      end;
    tsC:
      begin
        // cĸֵΪ =
        WasAssignment := sourTp.SplitChar(1, '=', ';', splitVarDecl) = 2; // ﲻַַΪиǺţԴ=ַи
        if WasAssignment then
          begin
            setBefore := splitVarDecl[0];
            setAfter := splitVarDecl[1];

            t := TTextParsing.Create(setBefore, tsC, nil);
            t.DeletedComment;
            if t.SplitChar(1, ',', ';', myvars) = 0 then // ﲻַַΪиǺţԴ,ַи
                Memo5.Lines.Add(Format('ֵ﷨ %s', [setBefore.Text]));
            DisposeObject(t);
          end;
      end;
    else
      begin
        Memo5.Lines.Add('ֱ֧ʽ');
        WasAssignment := False;
      end;
  end;

  rt := TOpCustomRunTime.Create;
  rt.RegOpP('dynamic', function(var Param: TOpParam): Variant
    begin
      Result := dynvar;
      inc(dynvar);
    end);
  rt.RegOpP('myvar1', function(var Param: TOpParam): Variant
    begin
      // myvar1ж̬
      Result := HashVars['myvar1'];
    end);

  dynvar := 1;

  // ڶҵ˸ֵ
  if WasAssignment then
    begin
      Memo5.Lines.Add('˱ֵʽ');

      op := BuildAsOpCode(sourTp.TextStyle, setAfter, rt);

      for i := low(myvars) to high(myvars) do
          HashVars[myvars[i].TrimChar(#32).Text] := op.Execute(rt); // һβոüִopĸֵ

      Memo5.Lines.Add('ֵ');
      Memo5.Lines.Add(HashVars.AsText);

      // ñڱʽеĸ
      Memo5.Lines.Add('ڣǿʼ̬Ǹղı̬ǽconstʽб');

      // opCacheԶеģκʱconstñʱҪ
      CleanOpCache();

      Memo5.Lines.Add(VarToStr(EvaluateExpressionValue_P(False, nil, TTextParsing, tsC, '"̬ "+myvar1',
        procedure(const DeclName: SystemString; var ValType: TExpressionDeclType; var Value: Variant)
        begin
          if HashVars.Exists(DeclName) then
            begin
              Value := HashVars[DeclName];
              ValType := TExpressionDeclType.edtString; // Ҫ߱ñ
            end;
        end)));

      Memo5.Lines.Add(VarToStr(EvaluateExpressionValue_P(False, nil, TTextParsing, tsC, '"̬ "+myvar4',
        procedure(const DeclName: SystemString; var ValType: TExpressionDeclType; var Value: Variant)
        begin
          // myvar4ǲڵ
          // Ȼ myvar2
          Value := HashVars['myvar2'];
          ValType := TExpressionDeclType.edtString; // Ҫ߱ñ
        end)));

      Memo5.Lines.Add('ڣǿʼ̬Ǹղı');
      Memo5.Lines.Add(VarToStr(EvaluateExpressionValue(tsC, '"̬ "+myvar1', rt)));

      HashVars['myvar1'] := 'abc';
      Memo5.Lines.Add(VarToStr(EvaluateExpressionValue(tsC, '"̬ "+myvar1', rt)));
    end
  else
    begin
      Memo5.Lines.Add('ûз˱ֵ');
      Memo5.Lines.Add(Format('ʽ "%s"' + #13#10 + 'н %s',
        [sourTp.ParsingData.Text.Text, VarToStr(EvaluateExpressionValue(sourTp.TextStyle, sourTp.ParsingData.Text, rt))]));
    end;

  DisposeObject([sourTp, HashVars, rt]);
end;

procedure TForm1.Button9Click(Sender: TObject);
// ź
var
  SpecialAsciiToken: TPascalStringList;
  rt: TOpCustomRunTime;
  v: Variant;
begin
  Memo5.Lines.Add('ȫֵĴʷ̽ͷǰ׺ʹ');

  // ǰ׺@@,Ϊascii
  SpecialAsciiToken := TPascalStringList.Create;
  SpecialAsciiToken.Add('@@');
  SpecialAsciiToken.Add('&&');

  // rtΪzeкֿ֧
  rt := TOpCustomRunTime.Create;
  rt.RegOpP('@@a&&', function(var Param: TOpParam): Variant
    // (a+b)*0.5
    begin
      Result := (Param[0] + Param[1]) * 0.5;
    end);
  rt.RegOpP('@@combineString&&', function(var Param: TOpParam): Variant
    // (a+b)*0.5
    begin
      Result := VarToStr(Param[0]) + VarToStr(Param[1]);
    end);

  // @@ǰ׺asciiҲں׺ţųȲ
  v := EvaluateExpressionValue(SpecialAsciiToken, False, '{ ע } @@a&&(1,2)', rt);
  Memo5.Lines.Add(VarToStr(v));

  // ַʽzeĬıʽΪPascal
  v := EvaluateExpressionValue(SpecialAsciiToken, False, '@@combineString&&('#39'abc'#39', '#39'123'#39')', rt);
  Memo5.Lines.Add(VarToStr(v));

  // ַʽʹcıʽ
  v := EvaluateExpressionValue(SpecialAsciiToken, tsC, '@@combineString&&("abc", "123")', rt);
  Memo5.Lines.Add(VarToStr(v));
  v := EvaluateExpressionValue(SpecialAsciiToken, tsC, '@@combineString&&('#39'abc'#39', '#39'123'#39')', rt);
  Memo5.Lines.Add(VarToStr(v));

  DisposeObject(rt);

  DisposeObject(SpecialAsciiToken);
end;

end.
