// Autogenerated from Pigeon (v22.4.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package org.moxxy.moxxyv2.quirks

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer

private fun wrapResult(result: Any?): List<Any?> {
  return listOf(result)
}

private fun wrapError(exception: Throwable): List<Any?> {
  return if (exception is FlutterError) {
    listOf(
      exception.code,
      exception.message,
      exception.details
    )
  } else {
    listOf(
      exception.javaClass.simpleName,
      exception.toString(),
      "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
    )
  }
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

enum class QuirkNotificationEventType(val raw: Int) {
  MARK_AS_READ(0),
  REPLY(1),
  OPEN(2);

  companion object {
    fun ofRaw(raw: Int): QuirkNotificationEventType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** Generated class from Pigeon that represents data sent in messages. */
data class QuirkNotificationEvent (
  /** The notification id. */
  val id: Long,
  /** The JID the notification was for. */
  val jid: String,
  /** The type of event. */
  val type: QuirkNotificationEventType,
  /**
   * An optional payload.
   * - type == NotificationType.reply: The reply message text.
   * Otherwise: undefined.
   */
  val payload: String? = null,
  /** Extra data. Only set when type == NotificationType.reply. */
  val extra: Map<String?, String?>? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): QuirkNotificationEvent {
      val id = pigeonVar_list[0] as Long
      val jid = pigeonVar_list[1] as String
      val type = pigeonVar_list[2] as QuirkNotificationEventType
      val payload = pigeonVar_list[3] as String?
      val extra = pigeonVar_list[4] as Map<String?, String?>?
      return QuirkNotificationEvent(id, jid, type, payload, extra)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      id,
      jid,
      type,
      payload,
      extra,
    )
  }
}
private open class NotificationsQuirksPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          QuirkNotificationEventType.ofRaw(it.toInt())
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          QuirkNotificationEvent.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is QuirkNotificationEventType -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      is QuirkNotificationEvent -> {
        stream.write(130)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface MoxxyQuirkApi {
  fun earlyNotificationEventQuirk(): QuirkNotificationEvent?

  companion object {
    /** The codec used by MoxxyQuirkApi. */
    val codec: MessageCodec<Any?> by lazy {
      NotificationsQuirksPigeonCodec()
    }
    /** Sets up an instance of `MoxxyQuirkApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: MoxxyQuirkApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.moxxyv2.MoxxyQuirkApi.earlyNotificationEventQuirk$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.earlyNotificationEventQuirk())
            } catch (exception: Throwable) {
              wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
